import { ExceptionHandler } from './exception_handler';
export { ExceptionHandler } from './exception_handler';
export class BaseException extends Error {
    constructor(message = "--") {
        super(message);
        this.message = message;
        this.stack = (new Error(message)).stack;
    }
    toString() { return this.message; }
}
export class WrappedException extends Error {
    constructor(_wrapperMessage, _originalException, _originalStack, _context) {
        super(_wrapperMessage);
        this._wrapperMessage = _wrapperMessage;
        this._originalException = _originalException;
        this._originalStack = _originalStack;
        this._context = _context;
        this._wrapperStack = (new Error(_wrapperMessage)).stack;
    }
    get wrapperMessage() { return this._wrapperMessage; }
    get wrapperStack() { return this._wrapperStack; }
    get originalException() { return this._originalException; }
    get originalStack() { return this._originalStack; }
    get context() { return this._context; }
    get message() { return ExceptionHandler.exceptionToString(this); }
    toString() { return this.message; }
}
export function makeTypeError(message) {
    return new TypeError(message);
}
export function unimplemented() {
    throw new BaseException('unimplemented');
}
//# sourceMappingURL=data:application/json;base64,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