import { isPresent } from 'angular2/src/facade/lang';
import { DOM } from 'angular2/src/platform/dom/dom_adapter';
export class By {
    static all() { return (debugElement) => true; }
    static css(selector) {
        return (debugElement) => {
            return isPresent(debugElement.nativeElement) ?
                DOM.elementMatches(debugElement.nativeElement, selector) :
                false;
        };
    }
    static directive(type) {
        return (debugElement) => { return debugElement.hasDirective(type); };
    }
}
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiYnkuanMiLCJzb3VyY2VSb290IjoiIiwic291cmNlcyI6WyJhbmd1bGFyMi9zcmMvcGxhdGZvcm0vZG9tL2RlYnVnL2J5LnRzIl0sIm5hbWVzIjpbIkJ5IiwiQnkuYWxsIiwiQnkuY3NzIiwiQnkuZGlyZWN0aXZlIl0sIm1hcHBpbmdzIjoiT0FBTyxFQUFPLFNBQVMsRUFBVSxNQUFNLDBCQUEwQjtPQUUxRCxFQUFDLEdBQUcsRUFBQyxNQUFNLHVDQUF1QztBQUd6RDtJQUNFQSxPQUFPQSxHQUFHQSxLQUFlQyxNQUFNQSxDQUFDQSxDQUFDQSxZQUFZQSxLQUFLQSxJQUFJQSxDQUFDQSxDQUFDQSxDQUFDQTtJQUV6REQsT0FBT0EsR0FBR0EsQ0FBQ0EsUUFBZ0JBO1FBQ3pCRSxNQUFNQSxDQUFDQSxDQUFDQSxZQUFZQTtZQUNsQkEsTUFBTUEsQ0FBQ0EsU0FBU0EsQ0FBQ0EsWUFBWUEsQ0FBQ0EsYUFBYUEsQ0FBQ0E7Z0JBQ2pDQSxHQUFHQSxDQUFDQSxjQUFjQSxDQUFDQSxZQUFZQSxDQUFDQSxhQUFhQSxFQUFFQSxRQUFRQSxDQUFDQTtnQkFDeERBLEtBQUtBLENBQUNBO1FBQ25CQSxDQUFDQSxDQUFDQTtJQUNKQSxDQUFDQTtJQUNERixPQUFPQSxTQUFTQSxDQUFDQSxJQUFVQTtRQUN6QkcsTUFBTUEsQ0FBQ0EsQ0FBQ0EsWUFBWUEsT0FBT0EsTUFBTUEsQ0FBQ0EsWUFBWUEsQ0FBQ0EsWUFBWUEsQ0FBQ0EsSUFBSUEsQ0FBQ0EsQ0FBQ0EsQ0FBQ0EsQ0FBQ0EsQ0FBQ0E7SUFDdkVBLENBQUNBO0FBQ0hILENBQUNBO0FBQUEiLCJzb3VyY2VzQ29udGVudCI6WyJpbXBvcnQge1R5cGUsIGlzUHJlc2VudCwgaXNCbGFua30gZnJvbSAnYW5ndWxhcjIvc3JjL2ZhY2FkZS9sYW5nJztcbmltcG9ydCB7UHJlZGljYXRlfSBmcm9tICdhbmd1bGFyMi9zcmMvZmFjYWRlL2NvbGxlY3Rpb24nO1xuaW1wb3J0IHtET019IGZyb20gJ2FuZ3VsYXIyL3NyYy9wbGF0Zm9ybS9kb20vZG9tX2FkYXB0ZXInO1xuaW1wb3J0IHtEZWJ1Z0VsZW1lbnR9IGZyb20gJ2FuZ3VsYXIyL2NvcmUnO1xuXG5leHBvcnQgY2xhc3MgQnkge1xuICBzdGF0aWMgYWxsKCk6IEZ1bmN0aW9uIHsgcmV0dXJuIChkZWJ1Z0VsZW1lbnQpID0+IHRydWU7IH1cblxuICBzdGF0aWMgY3NzKHNlbGVjdG9yOiBzdHJpbmcpOiBQcmVkaWNhdGU8RGVidWdFbGVtZW50PiB7XG4gICAgcmV0dXJuIChkZWJ1Z0VsZW1lbnQpID0+IHtcbiAgICAgIHJldHVybiBpc1ByZXNlbnQoZGVidWdFbGVtZW50Lm5hdGl2ZUVsZW1lbnQpID9cbiAgICAgICAgICAgICAgICAgRE9NLmVsZW1lbnRNYXRjaGVzKGRlYnVnRWxlbWVudC5uYXRpdmVFbGVtZW50LCBzZWxlY3RvcikgOlxuICAgICAgICAgICAgICAgICBmYWxzZTtcbiAgICB9O1xuICB9XG4gIHN0YXRpYyBkaXJlY3RpdmUodHlwZTogVHlwZSk6IFByZWRpY2F0ZTxEZWJ1Z0VsZW1lbnQ+IHtcbiAgICByZXR1cm4gKGRlYnVnRWxlbWVudCkgPT4geyByZXR1cm4gZGVidWdFbGVtZW50Lmhhc0RpcmVjdGl2ZSh0eXBlKTsgfTtcbiAgfVxufVxuIl19