var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") return Reflect.decorate(decorators, target, key, desc);
    switch (arguments.length) {
        case 2: return decorators.reduceRight(function(o, d) { return (d && d(o)) || o; }, target);
        case 3: return decorators.reduceRight(function(o, d) { return (d && d(target, key)), void 0; }, void 0);
        case 4: return decorators.reduceRight(function(o, d) { return (d && d(target, key, o)) || o; }, desc);
    }
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var __param = (this && this.__param) || function (paramIndex, decorator) {
    return function (target, key) { decorator(target, key, paramIndex); }
};
import { Inject, Injectable } from 'angular2/src/core/di';
import { AnimationBuilder } from 'angular2/src/animate/animation_builder';
import { isPresent, isBlank, RegExpWrapper, CONST_EXPR, stringify } from 'angular2/src/facade/lang';
import { BaseException } from 'angular2/src/facade/exceptions';
import { DomSharedStylesHost } from './shared_styles_host';
import { wtfLeave, wtfCreateScope } from 'angular2/src/core/profile/profile';
import { Renderer, RenderViewWithFragments } from 'angular2/core';
import { EventManager } from './events/event_manager';
import { DOCUMENT } from './dom_tokens';
import { createRenderView, encapsulateStyles } from 'angular2/src/core/render/view_factory';
import { DefaultProtoViewRef } from 'angular2/src/core/render/view';
import { camelCaseToDashCase } from './util';
import { ViewEncapsulation } from 'angular2/src/core/metadata';
import { DOM } from 'angular2/src/platform/dom/dom_adapter';
const NAMESPACE_URIS = CONST_EXPR({ 'xlink': 'http://www.w3.org/1999/xlink', 'svg': 'http://www.w3.org/2000/svg' });
export class DomRenderer extends Renderer {
    getNativeElementSync(location) {
        return resolveInternalDomView(location.renderView).boundElements[location.boundElementIndex];
    }
    getRootNodes(fragment) { return resolveInternalDomFragment(fragment); }
    attachFragmentAfterFragment(previousFragmentRef, fragmentRef) {
        var previousFragmentNodes = resolveInternalDomFragment(previousFragmentRef);
        if (previousFragmentNodes.length > 0) {
            var sibling = previousFragmentNodes[previousFragmentNodes.length - 1];
            let nodes = resolveInternalDomFragment(fragmentRef);
            moveNodesAfterSibling(sibling, nodes);
            this.animateNodesEnter(nodes);
        }
    }
    /**
     * Iterates through all nodes being added to the DOM and animates them if necessary
     * @param nodes
     */
    animateNodesEnter(nodes) {
        for (let i = 0; i < nodes.length; i++)
            this.animateNodeEnter(nodes[i]);
    }
    attachFragmentAfterElement(elementRef, fragmentRef) {
        var parentView = resolveInternalDomView(elementRef.renderView);
        var element = parentView.boundElements[elementRef.boundElementIndex];
        var nodes = resolveInternalDomFragment(fragmentRef);
        moveNodesAfterSibling(element, nodes);
        this.animateNodesEnter(nodes);
    }
    hydrateView(viewRef) { resolveInternalDomView(viewRef).hydrate(); }
    dehydrateView(viewRef) { resolveInternalDomView(viewRef).dehydrate(); }
    createTemplateAnchor(attrNameAndValues) {
        return this.createElement('script', attrNameAndValues);
    }
    createText(value) { return DOM.createTextNode(isPresent(value) ? value : ''); }
    appendChild(parent, child) { DOM.appendChild(parent, child); }
    setElementProperty(location, propertyName, propertyValue) {
        var view = resolveInternalDomView(location.renderView);
        DOM.setProperty(view.boundElements[location.boundElementIndex], propertyName, propertyValue);
    }
    setElementAttribute(location, attributeName, attributeValue) {
        var view = resolveInternalDomView(location.renderView);
        var element = view.boundElements[location.boundElementIndex];
        var dashCasedAttributeName = camelCaseToDashCase(attributeName);
        if (isPresent(attributeValue)) {
            DOM.setAttribute(element, dashCasedAttributeName, stringify(attributeValue));
        }
        else {
            DOM.removeAttribute(element, dashCasedAttributeName);
        }
    }
    setElementClass(location, className, isAdd) {
        var view = resolveInternalDomView(location.renderView);
        var element = view.boundElements[location.boundElementIndex];
        if (isAdd) {
            DOM.addClass(element, className);
        }
        else {
            DOM.removeClass(element, className);
        }
    }
    setElementStyle(location, styleName, styleValue) {
        var view = resolveInternalDomView(location.renderView);
        var element = view.boundElements[location.boundElementIndex];
        var dashCasedStyleName = camelCaseToDashCase(styleName);
        if (isPresent(styleValue)) {
            DOM.setStyle(element, dashCasedStyleName, stringify(styleValue));
        }
        else {
            DOM.removeStyle(element, dashCasedStyleName);
        }
    }
    invokeElementMethod(location, methodName, args) {
        var view = resolveInternalDomView(location.renderView);
        var element = view.boundElements[location.boundElementIndex];
        DOM.invoke(element, methodName, args);
    }
    setText(viewRef, textNodeIndex, text) {
        var view = resolveInternalDomView(viewRef);
        DOM.setText(view.boundTextNodes[textNodeIndex], text);
    }
    setEventDispatcher(viewRef, dispatcher) {
        resolveInternalDomView(viewRef).setEventDispatcher(dispatcher);
    }
}
export let DomRenderer_ = class extends DomRenderer {
    constructor(_eventManager, _domSharedStylesHost, _animate, document) {
        super();
        this._eventManager = _eventManager;
        this._domSharedStylesHost = _domSharedStylesHost;
        this._animate = _animate;
        this._componentTpls = new Map();
        /** @internal */
        this._createRootHostViewScope = wtfCreateScope('DomRenderer#createRootHostView()');
        /** @internal */
        this._createViewScope = wtfCreateScope('DomRenderer#createView()');
        /** @internal */
        this._detachFragmentScope = wtfCreateScope('DomRenderer#detachFragment()');
        this._document = document;
    }
    registerComponentTemplate(template) {
        this._componentTpls.set(template.id, template);
        if (template.encapsulation !== ViewEncapsulation.Native) {
            var encapsulatedStyles = encapsulateStyles(template);
            this._domSharedStylesHost.addStyles(encapsulatedStyles);
        }
    }
    createProtoView(componentTemplateId, cmds) {
        return new DefaultProtoViewRef(this._componentTpls.get(componentTemplateId), cmds);
    }
    resolveComponentTemplate(templateId) {
        return this._componentTpls.get(templateId);
    }
    createRootHostView(hostProtoViewRef, fragmentCount, hostElementSelector) {
        var s = this._createRootHostViewScope();
        var element = DOM.querySelector(this._document, hostElementSelector);
        if (isBlank(element)) {
            wtfLeave(s);
            throw new BaseException(`The selector "${hostElementSelector}" did not match any elements`);
        }
        return wtfLeave(s, this._createView(hostProtoViewRef, element));
    }
    createView(protoViewRef, fragmentCount) {
        var s = this._createViewScope();
        return wtfLeave(s, this._createView(protoViewRef, null));
    }
    _createView(protoViewRef, inplaceElement) {
        var dpvr = protoViewRef;
        var view = createRenderView(dpvr.template, dpvr.cmds, inplaceElement, this);
        var sdRoots = view.nativeShadowRoots;
        for (var i = 0; i < sdRoots.length; i++) {
            this._domSharedStylesHost.addHost(sdRoots[i]);
        }
        return new RenderViewWithFragments(view, view.fragments);
    }
    destroyView(viewRef) {
        var view = viewRef;
        var sdRoots = view.nativeShadowRoots;
        for (var i = 0; i < sdRoots.length; i++) {
            this._domSharedStylesHost.removeHost(sdRoots[i]);
        }
    }
    animateNodeEnter(node) {
        if (DOM.isElementNode(node) && DOM.hasClass(node, 'ng-animate')) {
            DOM.addClass(node, 'ng-enter');
            this._animate.css()
                .addAnimationClass('ng-enter-active')
                .start(node)
                .onComplete(() => { DOM.removeClass(node, 'ng-enter'); });
        }
    }
    animateNodeLeave(node) {
        if (DOM.isElementNode(node) && DOM.hasClass(node, 'ng-animate')) {
            DOM.addClass(node, 'ng-leave');
            this._animate.css()
                .addAnimationClass('ng-leave-active')
                .start(node)
                .onComplete(() => {
                DOM.removeClass(node, 'ng-leave');
                DOM.remove(node);
            });
        }
        else {
            DOM.remove(node);
        }
    }
    detachFragment(fragmentRef) {
        var s = this._detachFragmentScope();
        var fragmentNodes = resolveInternalDomFragment(fragmentRef);
        for (var i = 0; i < fragmentNodes.length; i++) {
            this.animateNodeLeave(fragmentNodes[i]);
        }
        wtfLeave(s);
    }
    createElement(name, attrNameAndValues) {
        var nsAndName = splitNamespace(name);
        var el = isPresent(nsAndName[0]) ?
            DOM.createElementNS(NAMESPACE_URIS[nsAndName[0]], nsAndName[1]) :
            DOM.createElement(nsAndName[1]);
        this._setAttributes(el, attrNameAndValues);
        return el;
    }
    mergeElement(existing, attrNameAndValues) {
        DOM.clearNodes(existing);
        this._setAttributes(existing, attrNameAndValues);
    }
    _setAttributes(node, attrNameAndValues) {
        for (var attrIdx = 0; attrIdx < attrNameAndValues.length; attrIdx += 2) {
            var attrNs;
            var attrName = attrNameAndValues[attrIdx];
            var nsAndName = splitNamespace(attrName);
            if (isPresent(nsAndName[0])) {
                attrName = nsAndName[0] + ':' + nsAndName[1];
                attrNs = NAMESPACE_URIS[nsAndName[0]];
            }
            var attrValue = attrNameAndValues[attrIdx + 1];
            if (isPresent(attrNs)) {
                DOM.setAttributeNS(node, attrNs, attrName, attrValue);
            }
            else {
                DOM.setAttribute(node, nsAndName[1], attrValue);
            }
        }
    }
    createRootContentInsertionPoint() {
        return DOM.createComment('root-content-insertion-point');
    }
    createShadowRoot(host, templateId) {
        var sr = DOM.createShadowRoot(host);
        var tpl = this._componentTpls.get(templateId);
        for (var i = 0; i < tpl.styles.length; i++) {
            DOM.appendChild(sr, DOM.createStyleElement(tpl.styles[i]));
        }
        return sr;
    }
    on(element, eventName, callback) {
        this._eventManager.addEventListener(element, eventName, decoratePreventDefault(callback));
    }
    globalOn(target, eventName, callback) {
        return this._eventManager.addGlobalEventListener(target, eventName, decoratePreventDefault(callback));
    }
};
DomRenderer_ = __decorate([
    Injectable(),
    __param(3, Inject(DOCUMENT)), 
    __metadata('design:paramtypes', [EventManager, DomSharedStylesHost, AnimationBuilder, Object])
], DomRenderer_);
function resolveInternalDomView(viewRef) {
    return viewRef;
}
function resolveInternalDomFragment(fragmentRef) {
    return fragmentRef.nodes;
}
function moveNodesAfterSibling(sibling, nodes) {
    if (nodes.length > 0 && isPresent(DOM.parentElement(sibling))) {
        for (var i = 0; i < nodes.length; i++) {
            DOM.insertBefore(sibling, nodes[i]);
        }
        DOM.insertBefore(nodes[0], sibling);
    }
}
function decoratePreventDefault(eventHandler) {
    return (event) => {
        var allowDefaultBehavior = eventHandler(event);
        if (!allowDefaultBehavior) {
            // TODO(tbosch): move preventDefault into event plugins...
            DOM.preventDefault(event);
        }
    };
}
var NS_PREFIX_RE = /^@([^:]+):(.+)/g;
function splitNamespace(name) {
    if (name[0] != '@') {
        return [null, name];
    }
    let match = RegExpWrapper.firstMatch(NS_PREFIX_RE, name);
    return [match[1], match[2]];
}
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiZG9tX3JlbmRlcmVyLmpzIiwic291cmNlUm9vdCI6IiIsInNvdXJjZXMiOlsiYW5ndWxhcjIvc3JjL3BsYXRmb3JtL2RvbS9kb21fcmVuZGVyZXIudHMiXSwibmFtZXMiOlsiRG9tUmVuZGVyZXIiLCJEb21SZW5kZXJlci5nZXROYXRpdmVFbGVtZW50U3luYyIsIkRvbVJlbmRlcmVyLmdldFJvb3ROb2RlcyIsIkRvbVJlbmRlcmVyLmF0dGFjaEZyYWdtZW50QWZ0ZXJGcmFnbWVudCIsIkRvbVJlbmRlcmVyLmFuaW1hdGVOb2Rlc0VudGVyIiwiRG9tUmVuZGVyZXIuYXR0YWNoRnJhZ21lbnRBZnRlckVsZW1lbnQiLCJEb21SZW5kZXJlci5oeWRyYXRlVmlldyIsIkRvbVJlbmRlcmVyLmRlaHlkcmF0ZVZpZXciLCJEb21SZW5kZXJlci5jcmVhdGVUZW1wbGF0ZUFuY2hvciIsIkRvbVJlbmRlcmVyLmNyZWF0ZVRleHQiLCJEb21SZW5kZXJlci5hcHBlbmRDaGlsZCIsIkRvbVJlbmRlcmVyLnNldEVsZW1lbnRQcm9wZXJ0eSIsIkRvbVJlbmRlcmVyLnNldEVsZW1lbnRBdHRyaWJ1dGUiLCJEb21SZW5kZXJlci5zZXRFbGVtZW50Q2xhc3MiLCJEb21SZW5kZXJlci5zZXRFbGVtZW50U3R5bGUiLCJEb21SZW5kZXJlci5pbnZva2VFbGVtZW50TWV0aG9kIiwiRG9tUmVuZGVyZXIuc2V0VGV4dCIsIkRvbVJlbmRlcmVyLnNldEV2ZW50RGlzcGF0Y2hlciIsIkRvbVJlbmRlcmVyXyIsIkRvbVJlbmRlcmVyXy5jb25zdHJ1Y3RvciIsIkRvbVJlbmRlcmVyXy5yZWdpc3RlckNvbXBvbmVudFRlbXBsYXRlIiwiRG9tUmVuZGVyZXJfLmNyZWF0ZVByb3RvVmlldyIsIkRvbVJlbmRlcmVyXy5yZXNvbHZlQ29tcG9uZW50VGVtcGxhdGUiLCJEb21SZW5kZXJlcl8uY3JlYXRlUm9vdEhvc3RWaWV3IiwiRG9tUmVuZGVyZXJfLmNyZWF0ZVZpZXciLCJEb21SZW5kZXJlcl8uX2NyZWF0ZVZpZXciLCJEb21SZW5kZXJlcl8uZGVzdHJveVZpZXciLCJEb21SZW5kZXJlcl8uYW5pbWF0ZU5vZGVFbnRlciIsIkRvbVJlbmRlcmVyXy5hbmltYXRlTm9kZUxlYXZlIiwiRG9tUmVuZGVyZXJfLmRldGFjaEZyYWdtZW50IiwiRG9tUmVuZGVyZXJfLmNyZWF0ZUVsZW1lbnQiLCJEb21SZW5kZXJlcl8ubWVyZ2VFbGVtZW50IiwiRG9tUmVuZGVyZXJfLl9zZXRBdHRyaWJ1dGVzIiwiRG9tUmVuZGVyZXJfLmNyZWF0ZVJvb3RDb250ZW50SW5zZXJ0aW9uUG9pbnQiLCJEb21SZW5kZXJlcl8uY3JlYXRlU2hhZG93Um9vdCIsIkRvbVJlbmRlcmVyXy5vbiIsIkRvbVJlbmRlcmVyXy5nbG9iYWxPbiIsInJlc29sdmVJbnRlcm5hbERvbVZpZXciLCJyZXNvbHZlSW50ZXJuYWxEb21GcmFnbWVudCIsIm1vdmVOb2Rlc0FmdGVyU2libGluZyIsImRlY29yYXRlUHJldmVudERlZmF1bHQiLCJzcGxpdE5hbWVzcGFjZSJdLCJtYXBwaW5ncyI6Ijs7Ozs7Ozs7Ozs7Ozs7T0FBTyxFQUFDLE1BQU0sRUFBRSxVQUFVLEVBQWMsTUFBTSxzQkFBc0I7T0FDN0QsRUFBQyxnQkFBZ0IsRUFBQyxNQUFNLHdDQUF3QztPQUVoRSxFQUNMLFNBQVMsRUFDVCxPQUFPLEVBQ1AsYUFBYSxFQUNiLFVBQVUsRUFDVixTQUFTLEVBRVYsTUFBTSwwQkFBMEI7T0FFMUIsRUFBQyxhQUFhLEVBQW1CLE1BQU0sZ0NBQWdDO09BQ3ZFLEVBQUMsbUJBQW1CLEVBQUMsTUFBTSxzQkFBc0I7T0FDakQsRUFBYSxRQUFRLEVBQUUsY0FBYyxFQUFDLE1BQU0sbUNBQW1DO09BRS9FLEVBQ0wsUUFBUSxFQUtSLHVCQUF1QixFQUl4QixNQUFNLGVBQWU7T0FFZixFQUFDLFlBQVksRUFBQyxNQUFNLHdCQUF3QjtPQUU1QyxFQUFDLFFBQVEsRUFBQyxNQUFNLGNBQWM7T0FDOUIsRUFDTCxnQkFBZ0IsRUFFaEIsaUJBQWlCLEVBQ2xCLE1BQU0sdUNBQXVDO09BQ3ZDLEVBR0wsbUJBQW1CLEVBQ3BCLE1BQU0sK0JBQStCO09BQy9CLEVBQUMsbUJBQW1CLEVBQUMsTUFBTSxRQUFRO09BQ25DLEVBQUMsaUJBQWlCLEVBQUMsTUFBTSw0QkFBNEI7T0FHckQsRUFBQyxHQUFHLEVBQUMsTUFBTSx1Q0FBdUM7QUFFekQsTUFBTSxjQUFjLEdBQ2hCLFVBQVUsQ0FBQyxFQUFDLE9BQU8sRUFBRSw4QkFBOEIsRUFBRSxLQUFLLEVBQUUsNEJBQTRCLEVBQUMsQ0FBQyxDQUFDO0FBRS9GLGlDQUEwQyxRQUFRO0lBa0JoREEsb0JBQW9CQSxDQUFDQSxRQUEwQkE7UUFDN0NDLE1BQU1BLENBQUNBLHNCQUFzQkEsQ0FBQ0EsUUFBUUEsQ0FBQ0EsVUFBVUEsQ0FBQ0EsQ0FBQ0EsYUFBYUEsQ0FBQ0EsUUFBUUEsQ0FBQ0EsaUJBQWlCQSxDQUFDQSxDQUFDQTtJQUMvRkEsQ0FBQ0E7SUFFREQsWUFBWUEsQ0FBQ0EsUUFBMkJBLElBQVlFLE1BQU1BLENBQUNBLDBCQUEwQkEsQ0FBQ0EsUUFBUUEsQ0FBQ0EsQ0FBQ0EsQ0FBQ0EsQ0FBQ0E7SUFFbEdGLDJCQUEyQkEsQ0FBQ0EsbUJBQXNDQSxFQUN0Q0EsV0FBOEJBO1FBQ3hERyxJQUFJQSxxQkFBcUJBLEdBQUdBLDBCQUEwQkEsQ0FBQ0EsbUJBQW1CQSxDQUFDQSxDQUFDQTtRQUM1RUEsRUFBRUEsQ0FBQ0EsQ0FBQ0EscUJBQXFCQSxDQUFDQSxNQUFNQSxHQUFHQSxDQUFDQSxDQUFDQSxDQUFDQSxDQUFDQTtZQUNyQ0EsSUFBSUEsT0FBT0EsR0FBR0EscUJBQXFCQSxDQUFDQSxxQkFBcUJBLENBQUNBLE1BQU1BLEdBQUdBLENBQUNBLENBQUNBLENBQUNBO1lBQ3RFQSxJQUFJQSxLQUFLQSxHQUFHQSwwQkFBMEJBLENBQUNBLFdBQVdBLENBQUNBLENBQUNBO1lBQ3BEQSxxQkFBcUJBLENBQUNBLE9BQU9BLEVBQUVBLEtBQUtBLENBQUNBLENBQUNBO1lBQ3RDQSxJQUFJQSxDQUFDQSxpQkFBaUJBLENBQUNBLEtBQUtBLENBQUNBLENBQUNBO1FBQ2hDQSxDQUFDQTtJQUNIQSxDQUFDQTtJQUVESDs7O09BR0dBO0lBQ0hBLGlCQUFpQkEsQ0FBQ0EsS0FBYUE7UUFDN0JJLEdBQUdBLENBQUNBLENBQUNBLEdBQUdBLENBQUNBLENBQUNBLEdBQUdBLENBQUNBLEVBQUVBLENBQUNBLEdBQUdBLEtBQUtBLENBQUNBLE1BQU1BLEVBQUVBLENBQUNBLEVBQUVBO1lBQUVBLElBQUlBLENBQUNBLGdCQUFnQkEsQ0FBQ0EsS0FBS0EsQ0FBQ0EsQ0FBQ0EsQ0FBQ0EsQ0FBQ0EsQ0FBQ0E7SUFDekVBLENBQUNBO0lBZURKLDBCQUEwQkEsQ0FBQ0EsVUFBNEJBLEVBQUVBLFdBQThCQTtRQUNyRkssSUFBSUEsVUFBVUEsR0FBR0Esc0JBQXNCQSxDQUFDQSxVQUFVQSxDQUFDQSxVQUFVQSxDQUFDQSxDQUFDQTtRQUMvREEsSUFBSUEsT0FBT0EsR0FBR0EsVUFBVUEsQ0FBQ0EsYUFBYUEsQ0FBQ0EsVUFBVUEsQ0FBQ0EsaUJBQWlCQSxDQUFDQSxDQUFDQTtRQUNyRUEsSUFBSUEsS0FBS0EsR0FBR0EsMEJBQTBCQSxDQUFDQSxXQUFXQSxDQUFDQSxDQUFDQTtRQUNwREEscUJBQXFCQSxDQUFDQSxPQUFPQSxFQUFFQSxLQUFLQSxDQUFDQSxDQUFDQTtRQUN0Q0EsSUFBSUEsQ0FBQ0EsaUJBQWlCQSxDQUFDQSxLQUFLQSxDQUFDQSxDQUFDQTtJQUNoQ0EsQ0FBQ0E7SUFJREwsV0FBV0EsQ0FBQ0EsT0FBc0JBLElBQUlNLHNCQUFzQkEsQ0FBQ0EsT0FBT0EsQ0FBQ0EsQ0FBQ0EsT0FBT0EsRUFBRUEsQ0FBQ0EsQ0FBQ0EsQ0FBQ0E7SUFFbEZOLGFBQWFBLENBQUNBLE9BQXNCQSxJQUFJTyxzQkFBc0JBLENBQUNBLE9BQU9BLENBQUNBLENBQUNBLFNBQVNBLEVBQUVBLENBQUNBLENBQUNBLENBQUNBO0lBRXRGUCxvQkFBb0JBLENBQUNBLGlCQUEyQkE7UUFDOUNRLE1BQU1BLENBQUNBLElBQUlBLENBQUNBLGFBQWFBLENBQUNBLFFBQVFBLEVBQUVBLGlCQUFpQkEsQ0FBQ0EsQ0FBQ0E7SUFDekRBLENBQUNBO0lBSURSLFVBQVVBLENBQUNBLEtBQWFBLElBQVVTLE1BQU1BLENBQUNBLEdBQUdBLENBQUNBLGNBQWNBLENBQUNBLFNBQVNBLENBQUNBLEtBQUtBLENBQUNBLEdBQUdBLEtBQUtBLEdBQUdBLEVBQUVBLENBQUNBLENBQUNBLENBQUNBLENBQUNBO0lBQzdGVCxXQUFXQSxDQUFDQSxNQUFZQSxFQUFFQSxLQUFXQSxJQUFJVSxHQUFHQSxDQUFDQSxXQUFXQSxDQUFDQSxNQUFNQSxFQUFFQSxLQUFLQSxDQUFDQSxDQUFDQSxDQUFDQSxDQUFDQTtJQUkxRVYsa0JBQWtCQSxDQUFDQSxRQUEwQkEsRUFBRUEsWUFBb0JBLEVBQUVBLGFBQWtCQTtRQUNyRlcsSUFBSUEsSUFBSUEsR0FBR0Esc0JBQXNCQSxDQUFDQSxRQUFRQSxDQUFDQSxVQUFVQSxDQUFDQSxDQUFDQTtRQUN2REEsR0FBR0EsQ0FBQ0EsV0FBV0EsQ0FBVUEsSUFBSUEsQ0FBQ0EsYUFBYUEsQ0FBQ0EsUUFBUUEsQ0FBQ0EsaUJBQWlCQSxDQUFDQSxFQUFFQSxZQUFZQSxFQUNyRUEsYUFBYUEsQ0FBQ0EsQ0FBQ0E7SUFDakNBLENBQUNBO0lBRURYLG1CQUFtQkEsQ0FBQ0EsUUFBMEJBLEVBQUVBLGFBQXFCQSxFQUNqREEsY0FBc0JBO1FBQ3hDWSxJQUFJQSxJQUFJQSxHQUFHQSxzQkFBc0JBLENBQUNBLFFBQVFBLENBQUNBLFVBQVVBLENBQUNBLENBQUNBO1FBQ3ZEQSxJQUFJQSxPQUFPQSxHQUFHQSxJQUFJQSxDQUFDQSxhQUFhQSxDQUFDQSxRQUFRQSxDQUFDQSxpQkFBaUJBLENBQUNBLENBQUNBO1FBQzdEQSxJQUFJQSxzQkFBc0JBLEdBQUdBLG1CQUFtQkEsQ0FBQ0EsYUFBYUEsQ0FBQ0EsQ0FBQ0E7UUFDaEVBLEVBQUVBLENBQUNBLENBQUNBLFNBQVNBLENBQUNBLGNBQWNBLENBQUNBLENBQUNBLENBQUNBLENBQUNBO1lBQzlCQSxHQUFHQSxDQUFDQSxZQUFZQSxDQUFDQSxPQUFPQSxFQUFFQSxzQkFBc0JBLEVBQUVBLFNBQVNBLENBQUNBLGNBQWNBLENBQUNBLENBQUNBLENBQUNBO1FBQy9FQSxDQUFDQTtRQUFDQSxJQUFJQSxDQUFDQSxDQUFDQTtZQUNOQSxHQUFHQSxDQUFDQSxlQUFlQSxDQUFDQSxPQUFPQSxFQUFFQSxzQkFBc0JBLENBQUNBLENBQUNBO1FBQ3ZEQSxDQUFDQTtJQUNIQSxDQUFDQTtJQUVEWixlQUFlQSxDQUFDQSxRQUEwQkEsRUFBRUEsU0FBaUJBLEVBQUVBLEtBQWNBO1FBQzNFYSxJQUFJQSxJQUFJQSxHQUFHQSxzQkFBc0JBLENBQUNBLFFBQVFBLENBQUNBLFVBQVVBLENBQUNBLENBQUNBO1FBQ3ZEQSxJQUFJQSxPQUFPQSxHQUFHQSxJQUFJQSxDQUFDQSxhQUFhQSxDQUFDQSxRQUFRQSxDQUFDQSxpQkFBaUJBLENBQUNBLENBQUNBO1FBQzdEQSxFQUFFQSxDQUFDQSxDQUFDQSxLQUFLQSxDQUFDQSxDQUFDQSxDQUFDQTtZQUNWQSxHQUFHQSxDQUFDQSxRQUFRQSxDQUFDQSxPQUFPQSxFQUFFQSxTQUFTQSxDQUFDQSxDQUFDQTtRQUNuQ0EsQ0FBQ0E7UUFBQ0EsSUFBSUEsQ0FBQ0EsQ0FBQ0E7WUFDTkEsR0FBR0EsQ0FBQ0EsV0FBV0EsQ0FBQ0EsT0FBT0EsRUFBRUEsU0FBU0EsQ0FBQ0EsQ0FBQ0E7UUFDdENBLENBQUNBO0lBQ0hBLENBQUNBO0lBRURiLGVBQWVBLENBQUNBLFFBQTBCQSxFQUFFQSxTQUFpQkEsRUFBRUEsVUFBa0JBO1FBQy9FYyxJQUFJQSxJQUFJQSxHQUFHQSxzQkFBc0JBLENBQUNBLFFBQVFBLENBQUNBLFVBQVVBLENBQUNBLENBQUNBO1FBQ3ZEQSxJQUFJQSxPQUFPQSxHQUFHQSxJQUFJQSxDQUFDQSxhQUFhQSxDQUFDQSxRQUFRQSxDQUFDQSxpQkFBaUJBLENBQUNBLENBQUNBO1FBQzdEQSxJQUFJQSxrQkFBa0JBLEdBQUdBLG1CQUFtQkEsQ0FBQ0EsU0FBU0EsQ0FBQ0EsQ0FBQ0E7UUFDeERBLEVBQUVBLENBQUNBLENBQUNBLFNBQVNBLENBQUNBLFVBQVVBLENBQUNBLENBQUNBLENBQUNBLENBQUNBO1lBQzFCQSxHQUFHQSxDQUFDQSxRQUFRQSxDQUFDQSxPQUFPQSxFQUFFQSxrQkFBa0JBLEVBQUVBLFNBQVNBLENBQUNBLFVBQVVBLENBQUNBLENBQUNBLENBQUNBO1FBQ25FQSxDQUFDQTtRQUFDQSxJQUFJQSxDQUFDQSxDQUFDQTtZQUNOQSxHQUFHQSxDQUFDQSxXQUFXQSxDQUFDQSxPQUFPQSxFQUFFQSxrQkFBa0JBLENBQUNBLENBQUNBO1FBQy9DQSxDQUFDQTtJQUNIQSxDQUFDQTtJQUVEZCxtQkFBbUJBLENBQUNBLFFBQTBCQSxFQUFFQSxVQUFrQkEsRUFBRUEsSUFBV0E7UUFDN0VlLElBQUlBLElBQUlBLEdBQUdBLHNCQUFzQkEsQ0FBQ0EsUUFBUUEsQ0FBQ0EsVUFBVUEsQ0FBQ0EsQ0FBQ0E7UUFDdkRBLElBQUlBLE9BQU9BLEdBQVlBLElBQUlBLENBQUNBLGFBQWFBLENBQUNBLFFBQVFBLENBQUNBLGlCQUFpQkEsQ0FBQ0EsQ0FBQ0E7UUFDdEVBLEdBQUdBLENBQUNBLE1BQU1BLENBQUNBLE9BQU9BLEVBQUVBLFVBQVVBLEVBQUVBLElBQUlBLENBQUNBLENBQUNBO0lBQ3hDQSxDQUFDQTtJQUVEZixPQUFPQSxDQUFDQSxPQUFzQkEsRUFBRUEsYUFBcUJBLEVBQUVBLElBQVlBO1FBQ2pFZ0IsSUFBSUEsSUFBSUEsR0FBR0Esc0JBQXNCQSxDQUFDQSxPQUFPQSxDQUFDQSxDQUFDQTtRQUMzQ0EsR0FBR0EsQ0FBQ0EsT0FBT0EsQ0FBQ0EsSUFBSUEsQ0FBQ0EsY0FBY0EsQ0FBQ0EsYUFBYUEsQ0FBQ0EsRUFBRUEsSUFBSUEsQ0FBQ0EsQ0FBQ0E7SUFDeERBLENBQUNBO0lBRURoQixrQkFBa0JBLENBQUNBLE9BQXNCQSxFQUFFQSxVQUFpQ0E7UUFDMUVpQixzQkFBc0JBLENBQUNBLE9BQU9BLENBQUNBLENBQUNBLGtCQUFrQkEsQ0FBQ0EsVUFBVUEsQ0FBQ0EsQ0FBQ0E7SUFDakVBLENBQUNBO0FBQ0hqQixDQUFDQTtBQUVELHdDQUNrQyxXQUFXO0lBSzNDa0IsWUFBb0JBLGFBQTJCQSxFQUMzQkEsb0JBQXlDQSxFQUFVQSxRQUEwQkEsRUFDbkVBLFFBQVFBO1FBQ3BDQyxPQUFPQSxDQUFDQTtRQUhVQSxrQkFBYUEsR0FBYkEsYUFBYUEsQ0FBY0E7UUFDM0JBLHlCQUFvQkEsR0FBcEJBLG9CQUFvQkEsQ0FBcUJBO1FBQVVBLGFBQVFBLEdBQVJBLFFBQVFBLENBQWtCQTtRQUx6RkEsbUJBQWNBLEdBQ2xCQSxJQUFJQSxHQUFHQSxFQUFtQ0EsQ0FBQ0E7UUEwQi9DQSxnQkFBZ0JBO1FBQ2hCQSw2QkFBd0JBLEdBQWVBLGNBQWNBLENBQUNBLGtDQUFrQ0EsQ0FBQ0EsQ0FBQ0E7UUFZMUZBLGdCQUFnQkE7UUFDaEJBLHFCQUFnQkEsR0FBR0EsY0FBY0EsQ0FBQ0EsMEJBQTBCQSxDQUFDQSxDQUFDQTtRQWtEOURBLGdCQUFnQkE7UUFDaEJBLHlCQUFvQkEsR0FBR0EsY0FBY0EsQ0FBQ0EsOEJBQThCQSxDQUFDQSxDQUFDQTtRQXBGcEVBLElBQUlBLENBQUNBLFNBQVNBLEdBQUdBLFFBQVFBLENBQUNBO0lBQzVCQSxDQUFDQTtJQUVERCx5QkFBeUJBLENBQUNBLFFBQWlDQTtRQUN6REUsSUFBSUEsQ0FBQ0EsY0FBY0EsQ0FBQ0EsR0FBR0EsQ0FBQ0EsUUFBUUEsQ0FBQ0EsRUFBRUEsRUFBRUEsUUFBUUEsQ0FBQ0EsQ0FBQ0E7UUFDL0NBLEVBQUVBLENBQUNBLENBQUNBLFFBQVFBLENBQUNBLGFBQWFBLEtBQUtBLGlCQUFpQkEsQ0FBQ0EsTUFBTUEsQ0FBQ0EsQ0FBQ0EsQ0FBQ0E7WUFDeERBLElBQUlBLGtCQUFrQkEsR0FBR0EsaUJBQWlCQSxDQUFDQSxRQUFRQSxDQUFDQSxDQUFDQTtZQUNyREEsSUFBSUEsQ0FBQ0Esb0JBQW9CQSxDQUFDQSxTQUFTQSxDQUFDQSxrQkFBa0JBLENBQUNBLENBQUNBO1FBQzFEQSxDQUFDQTtJQUNIQSxDQUFDQTtJQUVERixlQUFlQSxDQUFDQSxtQkFBMkJBLEVBQUVBLElBQXlCQTtRQUNwRUcsTUFBTUEsQ0FBQ0EsSUFBSUEsbUJBQW1CQSxDQUFDQSxJQUFJQSxDQUFDQSxjQUFjQSxDQUFDQSxHQUFHQSxDQUFDQSxtQkFBbUJBLENBQUNBLEVBQUVBLElBQUlBLENBQUNBLENBQUNBO0lBQ3JGQSxDQUFDQTtJQUVESCx3QkFBd0JBLENBQUNBLFVBQWtCQTtRQUN6Q0ksTUFBTUEsQ0FBQ0EsSUFBSUEsQ0FBQ0EsY0FBY0EsQ0FBQ0EsR0FBR0EsQ0FBQ0EsVUFBVUEsQ0FBQ0EsQ0FBQ0E7SUFDN0NBLENBQUNBO0lBSURKLGtCQUFrQkEsQ0FBQ0EsZ0JBQW9DQSxFQUFFQSxhQUFxQkEsRUFDM0RBLG1CQUEyQkE7UUFDNUNLLElBQUlBLENBQUNBLEdBQUdBLElBQUlBLENBQUNBLHdCQUF3QkEsRUFBRUEsQ0FBQ0E7UUFDeENBLElBQUlBLE9BQU9BLEdBQUdBLEdBQUdBLENBQUNBLGFBQWFBLENBQUNBLElBQUlBLENBQUNBLFNBQVNBLEVBQUVBLG1CQUFtQkEsQ0FBQ0EsQ0FBQ0E7UUFDckVBLEVBQUVBLENBQUNBLENBQUNBLE9BQU9BLENBQUNBLE9BQU9BLENBQUNBLENBQUNBLENBQUNBLENBQUNBO1lBQ3JCQSxRQUFRQSxDQUFDQSxDQUFDQSxDQUFDQSxDQUFDQTtZQUNaQSxNQUFNQSxJQUFJQSxhQUFhQSxDQUFDQSxpQkFBaUJBLG1CQUFtQkEsOEJBQThCQSxDQUFDQSxDQUFDQTtRQUM5RkEsQ0FBQ0E7UUFDREEsTUFBTUEsQ0FBQ0EsUUFBUUEsQ0FBQ0EsQ0FBQ0EsRUFBRUEsSUFBSUEsQ0FBQ0EsV0FBV0EsQ0FBQ0EsZ0JBQWdCQSxFQUFFQSxPQUFPQSxDQUFDQSxDQUFDQSxDQUFDQTtJQUNsRUEsQ0FBQ0E7SUFJREwsVUFBVUEsQ0FBQ0EsWUFBZ0NBLEVBQUVBLGFBQXFCQTtRQUNoRU0sSUFBSUEsQ0FBQ0EsR0FBR0EsSUFBSUEsQ0FBQ0EsZ0JBQWdCQSxFQUFFQSxDQUFDQTtRQUNoQ0EsTUFBTUEsQ0FBQ0EsUUFBUUEsQ0FBQ0EsQ0FBQ0EsRUFBRUEsSUFBSUEsQ0FBQ0EsV0FBV0EsQ0FBQ0EsWUFBWUEsRUFBRUEsSUFBSUEsQ0FBQ0EsQ0FBQ0EsQ0FBQ0E7SUFDM0RBLENBQUNBO0lBRU9OLFdBQVdBLENBQUNBLFlBQWdDQSxFQUNoQ0EsY0FBMkJBO1FBQzdDTyxJQUFJQSxJQUFJQSxHQUF3QkEsWUFBWUEsQ0FBQ0E7UUFDN0NBLElBQUlBLElBQUlBLEdBQUdBLGdCQUFnQkEsQ0FBQ0EsSUFBSUEsQ0FBQ0EsUUFBUUEsRUFBRUEsSUFBSUEsQ0FBQ0EsSUFBSUEsRUFBRUEsY0FBY0EsRUFBRUEsSUFBSUEsQ0FBQ0EsQ0FBQ0E7UUFDNUVBLElBQUlBLE9BQU9BLEdBQUdBLElBQUlBLENBQUNBLGlCQUFpQkEsQ0FBQ0E7UUFDckNBLEdBQUdBLENBQUNBLENBQUNBLEdBQUdBLENBQUNBLENBQUNBLEdBQUdBLENBQUNBLEVBQUVBLENBQUNBLEdBQUdBLE9BQU9BLENBQUNBLE1BQU1BLEVBQUVBLENBQUNBLEVBQUVBLEVBQUVBLENBQUNBO1lBQ3hDQSxJQUFJQSxDQUFDQSxvQkFBb0JBLENBQUNBLE9BQU9BLENBQUNBLE9BQU9BLENBQUNBLENBQUNBLENBQUNBLENBQUNBLENBQUNBO1FBQ2hEQSxDQUFDQTtRQUNEQSxNQUFNQSxDQUFDQSxJQUFJQSx1QkFBdUJBLENBQUNBLElBQUlBLEVBQUVBLElBQUlBLENBQUNBLFNBQVNBLENBQUNBLENBQUNBO0lBQzNEQSxDQUFDQTtJQUVEUCxXQUFXQSxDQUFDQSxPQUFzQkE7UUFDaENRLElBQUlBLElBQUlBLEdBQTRCQSxPQUFPQSxDQUFDQTtRQUM1Q0EsSUFBSUEsT0FBT0EsR0FBR0EsSUFBSUEsQ0FBQ0EsaUJBQWlCQSxDQUFDQTtRQUNyQ0EsR0FBR0EsQ0FBQ0EsQ0FBQ0EsR0FBR0EsQ0FBQ0EsQ0FBQ0EsR0FBR0EsQ0FBQ0EsRUFBRUEsQ0FBQ0EsR0FBR0EsT0FBT0EsQ0FBQ0EsTUFBTUEsRUFBRUEsQ0FBQ0EsRUFBRUEsRUFBRUEsQ0FBQ0E7WUFDeENBLElBQUlBLENBQUNBLG9CQUFvQkEsQ0FBQ0EsVUFBVUEsQ0FBQ0EsT0FBT0EsQ0FBQ0EsQ0FBQ0EsQ0FBQ0EsQ0FBQ0EsQ0FBQ0E7UUFDbkRBLENBQUNBO0lBQ0hBLENBQUNBO0lBRURSLGdCQUFnQkEsQ0FBQ0EsSUFBVUE7UUFDekJTLEVBQUVBLENBQUNBLENBQUNBLEdBQUdBLENBQUNBLGFBQWFBLENBQUNBLElBQUlBLENBQUNBLElBQUlBLEdBQUdBLENBQUNBLFFBQVFBLENBQUNBLElBQUlBLEVBQUVBLFlBQVlBLENBQUNBLENBQUNBLENBQUNBLENBQUNBO1lBQ2hFQSxHQUFHQSxDQUFDQSxRQUFRQSxDQUFDQSxJQUFJQSxFQUFFQSxVQUFVQSxDQUFDQSxDQUFDQTtZQUMvQkEsSUFBSUEsQ0FBQ0EsUUFBUUEsQ0FBQ0EsR0FBR0EsRUFBRUE7aUJBQ2RBLGlCQUFpQkEsQ0FBQ0EsaUJBQWlCQSxDQUFDQTtpQkFDcENBLEtBQUtBLENBQWNBLElBQUlBLENBQUNBO2lCQUN4QkEsVUFBVUEsQ0FBQ0EsUUFBUUEsR0FBR0EsQ0FBQ0EsV0FBV0EsQ0FBQ0EsSUFBSUEsRUFBRUEsVUFBVUEsQ0FBQ0EsQ0FBQ0EsQ0FBQ0EsQ0FBQ0EsQ0FBQ0EsQ0FBQ0E7UUFDaEVBLENBQUNBO0lBQ0hBLENBQUNBO0lBRURULGdCQUFnQkEsQ0FBQ0EsSUFBVUE7UUFDekJVLEVBQUVBLENBQUNBLENBQUNBLEdBQUdBLENBQUNBLGFBQWFBLENBQUNBLElBQUlBLENBQUNBLElBQUlBLEdBQUdBLENBQUNBLFFBQVFBLENBQUNBLElBQUlBLEVBQUVBLFlBQVlBLENBQUNBLENBQUNBLENBQUNBLENBQUNBO1lBQ2hFQSxHQUFHQSxDQUFDQSxRQUFRQSxDQUFDQSxJQUFJQSxFQUFFQSxVQUFVQSxDQUFDQSxDQUFDQTtZQUMvQkEsSUFBSUEsQ0FBQ0EsUUFBUUEsQ0FBQ0EsR0FBR0EsRUFBRUE7aUJBQ2RBLGlCQUFpQkEsQ0FBQ0EsaUJBQWlCQSxDQUFDQTtpQkFDcENBLEtBQUtBLENBQWNBLElBQUlBLENBQUNBO2lCQUN4QkEsVUFBVUEsQ0FBQ0E7Z0JBQ1ZBLEdBQUdBLENBQUNBLFdBQVdBLENBQUNBLElBQUlBLEVBQUVBLFVBQVVBLENBQUNBLENBQUNBO2dCQUNsQ0EsR0FBR0EsQ0FBQ0EsTUFBTUEsQ0FBQ0EsSUFBSUEsQ0FBQ0EsQ0FBQ0E7WUFDbkJBLENBQUNBLENBQUNBLENBQUNBO1FBQ1RBLENBQUNBO1FBQUNBLElBQUlBLENBQUNBLENBQUNBO1lBQ05BLEdBQUdBLENBQUNBLE1BQU1BLENBQUNBLElBQUlBLENBQUNBLENBQUNBO1FBQ25CQSxDQUFDQTtJQUNIQSxDQUFDQTtJQUlEVixjQUFjQSxDQUFDQSxXQUE4QkE7UUFDM0NXLElBQUlBLENBQUNBLEdBQUdBLElBQUlBLENBQUNBLG9CQUFvQkEsRUFBRUEsQ0FBQ0E7UUFDcENBLElBQUlBLGFBQWFBLEdBQUdBLDBCQUEwQkEsQ0FBQ0EsV0FBV0EsQ0FBQ0EsQ0FBQ0E7UUFDNURBLEdBQUdBLENBQUNBLENBQUNBLEdBQUdBLENBQUNBLENBQUNBLEdBQUdBLENBQUNBLEVBQUVBLENBQUNBLEdBQUdBLGFBQWFBLENBQUNBLE1BQU1BLEVBQUVBLENBQUNBLEVBQUVBLEVBQUVBLENBQUNBO1lBQzlDQSxJQUFJQSxDQUFDQSxnQkFBZ0JBLENBQUNBLGFBQWFBLENBQUNBLENBQUNBLENBQUNBLENBQUNBLENBQUNBO1FBQzFDQSxDQUFDQTtRQUNEQSxRQUFRQSxDQUFDQSxDQUFDQSxDQUFDQSxDQUFDQTtJQUNkQSxDQUFDQTtJQUNEWCxhQUFhQSxDQUFDQSxJQUFZQSxFQUFFQSxpQkFBMkJBO1FBQ3JEWSxJQUFJQSxTQUFTQSxHQUFHQSxjQUFjQSxDQUFDQSxJQUFJQSxDQUFDQSxDQUFDQTtRQUNyQ0EsSUFBSUEsRUFBRUEsR0FBR0EsU0FBU0EsQ0FBQ0EsU0FBU0EsQ0FBQ0EsQ0FBQ0EsQ0FBQ0EsQ0FBQ0E7WUFDbkJBLEdBQUdBLENBQUNBLGVBQWVBLENBQUNBLGNBQWNBLENBQUNBLFNBQVNBLENBQUNBLENBQUNBLENBQUNBLENBQUNBLEVBQUVBLFNBQVNBLENBQUNBLENBQUNBLENBQUNBLENBQUNBO1lBQy9EQSxHQUFHQSxDQUFDQSxhQUFhQSxDQUFDQSxTQUFTQSxDQUFDQSxDQUFDQSxDQUFDQSxDQUFDQSxDQUFDQTtRQUM3Q0EsSUFBSUEsQ0FBQ0EsY0FBY0EsQ0FBQ0EsRUFBRUEsRUFBRUEsaUJBQWlCQSxDQUFDQSxDQUFDQTtRQUMzQ0EsTUFBTUEsQ0FBQ0EsRUFBRUEsQ0FBQ0E7SUFDWkEsQ0FBQ0E7SUFDRFosWUFBWUEsQ0FBQ0EsUUFBY0EsRUFBRUEsaUJBQTJCQTtRQUN0RGEsR0FBR0EsQ0FBQ0EsVUFBVUEsQ0FBQ0EsUUFBUUEsQ0FBQ0EsQ0FBQ0E7UUFDekJBLElBQUlBLENBQUNBLGNBQWNBLENBQUNBLFFBQVFBLEVBQUVBLGlCQUFpQkEsQ0FBQ0EsQ0FBQ0E7SUFDbkRBLENBQUNBO0lBQ09iLGNBQWNBLENBQUNBLElBQVVBLEVBQUVBLGlCQUEyQkE7UUFDNURjLEdBQUdBLENBQUNBLENBQUNBLEdBQUdBLENBQUNBLE9BQU9BLEdBQUdBLENBQUNBLEVBQUVBLE9BQU9BLEdBQUdBLGlCQUFpQkEsQ0FBQ0EsTUFBTUEsRUFBRUEsT0FBT0EsSUFBSUEsQ0FBQ0EsRUFBRUEsQ0FBQ0E7WUFDdkVBLElBQUlBLE1BQU1BLENBQUNBO1lBQ1hBLElBQUlBLFFBQVFBLEdBQUdBLGlCQUFpQkEsQ0FBQ0EsT0FBT0EsQ0FBQ0EsQ0FBQ0E7WUFDMUNBLElBQUlBLFNBQVNBLEdBQUdBLGNBQWNBLENBQUNBLFFBQVFBLENBQUNBLENBQUNBO1lBQ3pDQSxFQUFFQSxDQUFDQSxDQUFDQSxTQUFTQSxDQUFDQSxTQUFTQSxDQUFDQSxDQUFDQSxDQUFDQSxDQUFDQSxDQUFDQSxDQUFDQSxDQUFDQTtnQkFDNUJBLFFBQVFBLEdBQUdBLFNBQVNBLENBQUNBLENBQUNBLENBQUNBLEdBQUdBLEdBQUdBLEdBQUdBLFNBQVNBLENBQUNBLENBQUNBLENBQUNBLENBQUNBO2dCQUM3Q0EsTUFBTUEsR0FBR0EsY0FBY0EsQ0FBQ0EsU0FBU0EsQ0FBQ0EsQ0FBQ0EsQ0FBQ0EsQ0FBQ0EsQ0FBQ0E7WUFDeENBLENBQUNBO1lBQ0RBLElBQUlBLFNBQVNBLEdBQUdBLGlCQUFpQkEsQ0FBQ0EsT0FBT0EsR0FBR0EsQ0FBQ0EsQ0FBQ0EsQ0FBQ0E7WUFDL0NBLEVBQUVBLENBQUNBLENBQUNBLFNBQVNBLENBQUNBLE1BQU1BLENBQUNBLENBQUNBLENBQUNBLENBQUNBO2dCQUN0QkEsR0FBR0EsQ0FBQ0EsY0FBY0EsQ0FBQ0EsSUFBSUEsRUFBRUEsTUFBTUEsRUFBRUEsUUFBUUEsRUFBRUEsU0FBU0EsQ0FBQ0EsQ0FBQ0E7WUFDeERBLENBQUNBO1lBQUNBLElBQUlBLENBQUNBLENBQUNBO2dCQUNOQSxHQUFHQSxDQUFDQSxZQUFZQSxDQUFDQSxJQUFJQSxFQUFFQSxTQUFTQSxDQUFDQSxDQUFDQSxDQUFDQSxFQUFFQSxTQUFTQSxDQUFDQSxDQUFDQTtZQUNsREEsQ0FBQ0E7UUFDSEEsQ0FBQ0E7SUFDSEEsQ0FBQ0E7SUFDRGQsK0JBQStCQTtRQUM3QmUsTUFBTUEsQ0FBQ0EsR0FBR0EsQ0FBQ0EsYUFBYUEsQ0FBQ0EsOEJBQThCQSxDQUFDQSxDQUFDQTtJQUMzREEsQ0FBQ0E7SUFDRGYsZ0JBQWdCQSxDQUFDQSxJQUFVQSxFQUFFQSxVQUFrQkE7UUFDN0NnQixJQUFJQSxFQUFFQSxHQUFHQSxHQUFHQSxDQUFDQSxnQkFBZ0JBLENBQUNBLElBQUlBLENBQUNBLENBQUNBO1FBQ3BDQSxJQUFJQSxHQUFHQSxHQUFHQSxJQUFJQSxDQUFDQSxjQUFjQSxDQUFDQSxHQUFHQSxDQUFDQSxVQUFVQSxDQUFDQSxDQUFDQTtRQUM5Q0EsR0FBR0EsQ0FBQ0EsQ0FBQ0EsR0FBR0EsQ0FBQ0EsQ0FBQ0EsR0FBR0EsQ0FBQ0EsRUFBRUEsQ0FBQ0EsR0FBR0EsR0FBR0EsQ0FBQ0EsTUFBTUEsQ0FBQ0EsTUFBTUEsRUFBRUEsQ0FBQ0EsRUFBRUEsRUFBRUEsQ0FBQ0E7WUFDM0NBLEdBQUdBLENBQUNBLFdBQVdBLENBQUNBLEVBQUVBLEVBQUVBLEdBQUdBLENBQUNBLGtCQUFrQkEsQ0FBQ0EsR0FBR0EsQ0FBQ0EsTUFBTUEsQ0FBQ0EsQ0FBQ0EsQ0FBQ0EsQ0FBQ0EsQ0FBQ0EsQ0FBQ0E7UUFDN0RBLENBQUNBO1FBQ0RBLE1BQU1BLENBQUNBLEVBQUVBLENBQUNBO0lBQ1pBLENBQUNBO0lBQ0RoQixFQUFFQSxDQUFDQSxPQUFhQSxFQUFFQSxTQUFpQkEsRUFBRUEsUUFBa0JBO1FBQ3JEaUIsSUFBSUEsQ0FBQ0EsYUFBYUEsQ0FBQ0EsZ0JBQWdCQSxDQUFjQSxPQUFPQSxFQUFFQSxTQUFTQSxFQUMvQkEsc0JBQXNCQSxDQUFDQSxRQUFRQSxDQUFDQSxDQUFDQSxDQUFDQTtJQUN4RUEsQ0FBQ0E7SUFDRGpCLFFBQVFBLENBQUNBLE1BQWNBLEVBQUVBLFNBQWlCQSxFQUFFQSxRQUFrQkE7UUFDNURrQixNQUFNQSxDQUFDQSxJQUFJQSxDQUFDQSxhQUFhQSxDQUFDQSxzQkFBc0JBLENBQUNBLE1BQU1BLEVBQUVBLFNBQVNBLEVBQ2pCQSxzQkFBc0JBLENBQUNBLFFBQVFBLENBQUNBLENBQUNBLENBQUNBO0lBQ3JGQSxDQUFDQTtBQUNIbEIsQ0FBQ0E7QUF2SkQ7SUFBQyxVQUFVLEVBQUU7SUFRQyxXQUFDLE1BQU0sQ0FBQyxRQUFRLENBQUMsQ0FBQTs7aUJBK0k5QjtBQUVELGdDQUFnQyxPQUFzQjtJQUNwRG1CLE1BQU1BLENBQTBCQSxPQUFPQSxDQUFDQTtBQUMxQ0EsQ0FBQ0E7QUFFRCxvQ0FBb0MsV0FBOEI7SUFDaEVDLE1BQU1BLENBQWtDQSxXQUFZQSxDQUFDQSxLQUFLQSxDQUFDQTtBQUM3REEsQ0FBQ0E7QUFFRCwrQkFBK0IsT0FBTyxFQUFFLEtBQUs7SUFDM0NDLEVBQUVBLENBQUNBLENBQUNBLEtBQUtBLENBQUNBLE1BQU1BLEdBQUdBLENBQUNBLElBQUlBLFNBQVNBLENBQUNBLEdBQUdBLENBQUNBLGFBQWFBLENBQUNBLE9BQU9BLENBQUNBLENBQUNBLENBQUNBLENBQUNBLENBQUNBO1FBQzlEQSxHQUFHQSxDQUFDQSxDQUFDQSxHQUFHQSxDQUFDQSxDQUFDQSxHQUFHQSxDQUFDQSxFQUFFQSxDQUFDQSxHQUFHQSxLQUFLQSxDQUFDQSxNQUFNQSxFQUFFQSxDQUFDQSxFQUFFQSxFQUFFQSxDQUFDQTtZQUN0Q0EsR0FBR0EsQ0FBQ0EsWUFBWUEsQ0FBQ0EsT0FBT0EsRUFBRUEsS0FBS0EsQ0FBQ0EsQ0FBQ0EsQ0FBQ0EsQ0FBQ0EsQ0FBQ0E7UUFDdENBLENBQUNBO1FBQ0RBLEdBQUdBLENBQUNBLFlBQVlBLENBQUNBLEtBQUtBLENBQUNBLENBQUNBLENBQUNBLEVBQUVBLE9BQU9BLENBQUNBLENBQUNBO0lBQ3RDQSxDQUFDQTtBQUNIQSxDQUFDQTtBQUVELGdDQUFnQyxZQUFzQjtJQUNwREMsTUFBTUEsQ0FBQ0EsQ0FBQ0EsS0FBS0E7UUFDWEEsSUFBSUEsb0JBQW9CQSxHQUFHQSxZQUFZQSxDQUFDQSxLQUFLQSxDQUFDQSxDQUFDQTtRQUMvQ0EsRUFBRUEsQ0FBQ0EsQ0FBQ0EsQ0FBQ0Esb0JBQW9CQSxDQUFDQSxDQUFDQSxDQUFDQTtZQUMxQkEsMERBQTBEQTtZQUMxREEsR0FBR0EsQ0FBQ0EsY0FBY0EsQ0FBQ0EsS0FBS0EsQ0FBQ0EsQ0FBQ0E7UUFDNUJBLENBQUNBO0lBQ0hBLENBQUNBLENBQUNBO0FBQ0pBLENBQUNBO0FBRUQsSUFBSSxZQUFZLEdBQUcsaUJBQWlCLENBQUM7QUFFckMsd0JBQXdCLElBQVk7SUFDbENDLEVBQUVBLENBQUNBLENBQUNBLElBQUlBLENBQUNBLENBQUNBLENBQUNBLElBQUlBLEdBQUdBLENBQUNBLENBQUNBLENBQUNBO1FBQ25CQSxNQUFNQSxDQUFDQSxDQUFDQSxJQUFJQSxFQUFFQSxJQUFJQSxDQUFDQSxDQUFDQTtJQUN0QkEsQ0FBQ0E7SUFDREEsSUFBSUEsS0FBS0EsR0FBR0EsYUFBYUEsQ0FBQ0EsVUFBVUEsQ0FBQ0EsWUFBWUEsRUFBRUEsSUFBSUEsQ0FBQ0EsQ0FBQ0E7SUFDekRBLE1BQU1BLENBQUNBLENBQUNBLEtBQUtBLENBQUNBLENBQUNBLENBQUNBLEVBQUVBLEtBQUtBLENBQUNBLENBQUNBLENBQUNBLENBQUNBLENBQUNBO0FBQzlCQSxDQUFDQSIsInNvdXJjZXNDb250ZW50IjpbImltcG9ydCB7SW5qZWN0LCBJbmplY3RhYmxlLCBPcGFxdWVUb2tlbn0gZnJvbSAnYW5ndWxhcjIvc3JjL2NvcmUvZGknO1xuaW1wb3J0IHtBbmltYXRpb25CdWlsZGVyfSBmcm9tICdhbmd1bGFyMi9zcmMvYW5pbWF0ZS9hbmltYXRpb25fYnVpbGRlcic7XG5cbmltcG9ydCB7XG4gIGlzUHJlc2VudCxcbiAgaXNCbGFuayxcbiAgUmVnRXhwV3JhcHBlcixcbiAgQ09OU1RfRVhQUixcbiAgc3RyaW5naWZ5LFxuICBTdHJpbmdXcmFwcGVyXG59IGZyb20gJ2FuZ3VsYXIyL3NyYy9mYWNhZGUvbGFuZyc7XG5cbmltcG9ydCB7QmFzZUV4Y2VwdGlvbiwgV3JhcHBlZEV4Y2VwdGlvbn0gZnJvbSAnYW5ndWxhcjIvc3JjL2ZhY2FkZS9leGNlcHRpb25zJztcbmltcG9ydCB7RG9tU2hhcmVkU3R5bGVzSG9zdH0gZnJvbSAnLi9zaGFyZWRfc3R5bGVzX2hvc3QnO1xuaW1wb3J0IHtXdGZTY29wZUZuLCB3dGZMZWF2ZSwgd3RmQ3JlYXRlU2NvcGV9IGZyb20gJ2FuZ3VsYXIyL3NyYy9jb3JlL3Byb2ZpbGUvcHJvZmlsZSc7XG5cbmltcG9ydCB7XG4gIFJlbmRlcmVyLFxuICBSZW5kZXJQcm90b1ZpZXdSZWYsXG4gIFJlbmRlclZpZXdSZWYsXG4gIFJlbmRlckVsZW1lbnRSZWYsXG4gIFJlbmRlckZyYWdtZW50UmVmLFxuICBSZW5kZXJWaWV3V2l0aEZyYWdtZW50cyxcbiAgUmVuZGVyVGVtcGxhdGVDbWQsXG4gIFJlbmRlckV2ZW50RGlzcGF0Y2hlcixcbiAgUmVuZGVyQ29tcG9uZW50VGVtcGxhdGVcbn0gZnJvbSAnYW5ndWxhcjIvY29yZSc7XG5cbmltcG9ydCB7RXZlbnRNYW5hZ2VyfSBmcm9tICcuL2V2ZW50cy9ldmVudF9tYW5hZ2VyJztcblxuaW1wb3J0IHtET0NVTUVOVH0gZnJvbSAnLi9kb21fdG9rZW5zJztcbmltcG9ydCB7XG4gIGNyZWF0ZVJlbmRlclZpZXcsXG4gIE5vZGVGYWN0b3J5LFxuICBlbmNhcHN1bGF0ZVN0eWxlc1xufSBmcm9tICdhbmd1bGFyMi9zcmMvY29yZS9yZW5kZXIvdmlld19mYWN0b3J5JztcbmltcG9ydCB7XG4gIERlZmF1bHRSZW5kZXJWaWV3LFxuICBEZWZhdWx0UmVuZGVyRnJhZ21lbnRSZWYsXG4gIERlZmF1bHRQcm90b1ZpZXdSZWZcbn0gZnJvbSAnYW5ndWxhcjIvc3JjL2NvcmUvcmVuZGVyL3ZpZXcnO1xuaW1wb3J0IHtjYW1lbENhc2VUb0Rhc2hDYXNlfSBmcm9tICcuL3V0aWwnO1xuaW1wb3J0IHtWaWV3RW5jYXBzdWxhdGlvbn0gZnJvbSAnYW5ndWxhcjIvc3JjL2NvcmUvbWV0YWRhdGEnO1xuXG4vLyBUT0RPIG1vdmUgaXQgb25jZSBEb21BZGFwdGVyIGlzIG1vdmVkXG5pbXBvcnQge0RPTX0gZnJvbSAnYW5ndWxhcjIvc3JjL3BsYXRmb3JtL2RvbS9kb21fYWRhcHRlcic7XG5cbmNvbnN0IE5BTUVTUEFDRV9VUklTID1cbiAgICBDT05TVF9FWFBSKHsneGxpbmsnOiAnaHR0cDovL3d3dy53My5vcmcvMTk5OS94bGluaycsICdzdmcnOiAnaHR0cDovL3d3dy53My5vcmcvMjAwMC9zdmcnfSk7XG5cbmV4cG9ydCBhYnN0cmFjdCBjbGFzcyBEb21SZW5kZXJlciBleHRlbmRzIFJlbmRlcmVyIGltcGxlbWVudHMgTm9kZUZhY3Rvcnk8Tm9kZT4ge1xuICBhYnN0cmFjdCByZWdpc3RlckNvbXBvbmVudFRlbXBsYXRlKHRlbXBsYXRlOiBSZW5kZXJDb21wb25lbnRUZW1wbGF0ZSk7XG5cbiAgYWJzdHJhY3QgcmVzb2x2ZUNvbXBvbmVudFRlbXBsYXRlKHRlbXBsYXRlSWQ6IHN0cmluZyk6IFJlbmRlckNvbXBvbmVudFRlbXBsYXRlO1xuXG4gIGFic3RyYWN0IGNyZWF0ZVByb3RvVmlldyhjb21wb25lbnRUZW1wbGF0ZUlkOiBzdHJpbmcsXG4gICAgICAgICAgICAgICAgICAgICAgICAgICBjbWRzOiBSZW5kZXJUZW1wbGF0ZUNtZFtdKTogUmVuZGVyUHJvdG9WaWV3UmVmO1xuXG4gIGFic3RyYWN0IGNyZWF0ZVJvb3RIb3N0Vmlldyhob3N0UHJvdG9WaWV3UmVmOiBSZW5kZXJQcm90b1ZpZXdSZWYsIGZyYWdtZW50Q291bnQ6IG51bWJlcixcbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIGhvc3RFbGVtZW50U2VsZWN0b3I6IHN0cmluZyk6IFJlbmRlclZpZXdXaXRoRnJhZ21lbnRzO1xuXG4gIGFic3RyYWN0IGNyZWF0ZVZpZXcocHJvdG9WaWV3UmVmOiBSZW5kZXJQcm90b1ZpZXdSZWYsXG4gICAgICAgICAgICAgICAgICAgICAgZnJhZ21lbnRDb3VudDogbnVtYmVyKTogUmVuZGVyVmlld1dpdGhGcmFnbWVudHM7XG5cbiAgYWJzdHJhY3QgZGVzdHJveVZpZXcodmlld1JlZjogUmVuZGVyVmlld1JlZik7XG5cbiAgYWJzdHJhY3QgY3JlYXRlUm9vdENvbnRlbnRJbnNlcnRpb25Qb2ludCgpO1xuXG4gIGdldE5hdGl2ZUVsZW1lbnRTeW5jKGxvY2F0aW9uOiBSZW5kZXJFbGVtZW50UmVmKTogYW55IHtcbiAgICByZXR1cm4gcmVzb2x2ZUludGVybmFsRG9tVmlldyhsb2NhdGlvbi5yZW5kZXJWaWV3KS5ib3VuZEVsZW1lbnRzW2xvY2F0aW9uLmJvdW5kRWxlbWVudEluZGV4XTtcbiAgfVxuXG4gIGdldFJvb3ROb2RlcyhmcmFnbWVudDogUmVuZGVyRnJhZ21lbnRSZWYpOiBOb2RlW10geyByZXR1cm4gcmVzb2x2ZUludGVybmFsRG9tRnJhZ21lbnQoZnJhZ21lbnQpOyB9XG5cbiAgYXR0YWNoRnJhZ21lbnRBZnRlckZyYWdtZW50KHByZXZpb3VzRnJhZ21lbnRSZWY6IFJlbmRlckZyYWdtZW50UmVmLFxuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgZnJhZ21lbnRSZWY6IFJlbmRlckZyYWdtZW50UmVmKSB7XG4gICAgdmFyIHByZXZpb3VzRnJhZ21lbnROb2RlcyA9IHJlc29sdmVJbnRlcm5hbERvbUZyYWdtZW50KHByZXZpb3VzRnJhZ21lbnRSZWYpO1xuICAgIGlmIChwcmV2aW91c0ZyYWdtZW50Tm9kZXMubGVuZ3RoID4gMCkge1xuICAgICAgdmFyIHNpYmxpbmcgPSBwcmV2aW91c0ZyYWdtZW50Tm9kZXNbcHJldmlvdXNGcmFnbWVudE5vZGVzLmxlbmd0aCAtIDFdO1xuICAgICAgbGV0IG5vZGVzID0gcmVzb2x2ZUludGVybmFsRG9tRnJhZ21lbnQoZnJhZ21lbnRSZWYpO1xuICAgICAgbW92ZU5vZGVzQWZ0ZXJTaWJsaW5nKHNpYmxpbmcsIG5vZGVzKTtcbiAgICAgIHRoaXMuYW5pbWF0ZU5vZGVzRW50ZXIobm9kZXMpO1xuICAgIH1cbiAgfVxuXG4gIC8qKlxuICAgKiBJdGVyYXRlcyB0aHJvdWdoIGFsbCBub2RlcyBiZWluZyBhZGRlZCB0byB0aGUgRE9NIGFuZCBhbmltYXRlcyB0aGVtIGlmIG5lY2Vzc2FyeVxuICAgKiBAcGFyYW0gbm9kZXNcbiAgICovXG4gIGFuaW1hdGVOb2Rlc0VudGVyKG5vZGVzOiBOb2RlW10pIHtcbiAgICBmb3IgKGxldCBpID0gMDsgaSA8IG5vZGVzLmxlbmd0aDsgaSsrKSB0aGlzLmFuaW1hdGVOb2RlRW50ZXIobm9kZXNbaV0pO1xuICB9XG5cbiAgLyoqXG4gICAqIFBlcmZvcm1zIGFuaW1hdGlvbnMgaWYgbmVjZXNzYXJ5XG4gICAqIEBwYXJhbSBub2RlXG4gICAqL1xuICBhYnN0cmFjdCBhbmltYXRlTm9kZUVudGVyKG5vZGU6IE5vZGUpO1xuXG4gIC8qKlxuICAgKiBJZiBhbmltYXRpb25zIGFyZSBuZWNlc3NhcnksIHBlcmZvcm1zIGFuaW1hdGlvbnMgdGhlbiByZW1vdmVzIHRoZSBlbGVtZW50OyBvdGhlcndpc2UsIGl0IGp1c3RcbiAgICogcmVtb3ZlcyB0aGUgZWxlbWVudC5cbiAgICogQHBhcmFtIG5vZGVcbiAgICovXG4gIGFic3RyYWN0IGFuaW1hdGVOb2RlTGVhdmUobm9kZTogTm9kZSk7XG5cbiAgYXR0YWNoRnJhZ21lbnRBZnRlckVsZW1lbnQoZWxlbWVudFJlZjogUmVuZGVyRWxlbWVudFJlZiwgZnJhZ21lbnRSZWY6IFJlbmRlckZyYWdtZW50UmVmKSB7XG4gICAgdmFyIHBhcmVudFZpZXcgPSByZXNvbHZlSW50ZXJuYWxEb21WaWV3KGVsZW1lbnRSZWYucmVuZGVyVmlldyk7XG4gICAgdmFyIGVsZW1lbnQgPSBwYXJlbnRWaWV3LmJvdW5kRWxlbWVudHNbZWxlbWVudFJlZi5ib3VuZEVsZW1lbnRJbmRleF07XG4gICAgdmFyIG5vZGVzID0gcmVzb2x2ZUludGVybmFsRG9tRnJhZ21lbnQoZnJhZ21lbnRSZWYpO1xuICAgIG1vdmVOb2Rlc0FmdGVyU2libGluZyhlbGVtZW50LCBub2Rlcyk7XG4gICAgdGhpcy5hbmltYXRlTm9kZXNFbnRlcihub2Rlcyk7XG4gIH1cblxuICBhYnN0cmFjdCBkZXRhY2hGcmFnbWVudChmcmFnbWVudFJlZjogUmVuZGVyRnJhZ21lbnRSZWYpO1xuXG4gIGh5ZHJhdGVWaWV3KHZpZXdSZWY6IFJlbmRlclZpZXdSZWYpIHsgcmVzb2x2ZUludGVybmFsRG9tVmlldyh2aWV3UmVmKS5oeWRyYXRlKCk7IH1cblxuICBkZWh5ZHJhdGVWaWV3KHZpZXdSZWY6IFJlbmRlclZpZXdSZWYpIHsgcmVzb2x2ZUludGVybmFsRG9tVmlldyh2aWV3UmVmKS5kZWh5ZHJhdGUoKTsgfVxuXG4gIGNyZWF0ZVRlbXBsYXRlQW5jaG9yKGF0dHJOYW1lQW5kVmFsdWVzOiBzdHJpbmdbXSk6IE5vZGUge1xuICAgIHJldHVybiB0aGlzLmNyZWF0ZUVsZW1lbnQoJ3NjcmlwdCcsIGF0dHJOYW1lQW5kVmFsdWVzKTtcbiAgfVxuICBhYnN0cmFjdCBjcmVhdGVFbGVtZW50KG5hbWU6IHN0cmluZywgYXR0ck5hbWVBbmRWYWx1ZXM6IHN0cmluZ1tdKTogTm9kZTtcbiAgYWJzdHJhY3QgbWVyZ2VFbGVtZW50KGV4aXN0aW5nOiBOb2RlLCBhdHRyTmFtZUFuZFZhbHVlczogc3RyaW5nW10pO1xuICBhYnN0cmFjdCBjcmVhdGVTaGFkb3dSb290KGhvc3Q6IE5vZGUsIHRlbXBsYXRlSWQ6IHN0cmluZyk6IE5vZGU7XG4gIGNyZWF0ZVRleHQodmFsdWU6IHN0cmluZyk6IE5vZGUgeyByZXR1cm4gRE9NLmNyZWF0ZVRleHROb2RlKGlzUHJlc2VudCh2YWx1ZSkgPyB2YWx1ZSA6ICcnKTsgfVxuICBhcHBlbmRDaGlsZChwYXJlbnQ6IE5vZGUsIGNoaWxkOiBOb2RlKSB7IERPTS5hcHBlbmRDaGlsZChwYXJlbnQsIGNoaWxkKTsgfVxuICBhYnN0cmFjdCBvbihlbGVtZW50OiBOb2RlLCBldmVudE5hbWU6IHN0cmluZywgY2FsbGJhY2s6IEZ1bmN0aW9uKTtcbiAgYWJzdHJhY3QgZ2xvYmFsT24odGFyZ2V0OiBzdHJpbmcsIGV2ZW50TmFtZTogc3RyaW5nLCBjYWxsYmFjazogRnVuY3Rpb24pOiBGdW5jdGlvbjtcblxuICBzZXRFbGVtZW50UHJvcGVydHkobG9jYXRpb246IFJlbmRlckVsZW1lbnRSZWYsIHByb3BlcnR5TmFtZTogc3RyaW5nLCBwcm9wZXJ0eVZhbHVlOiBhbnkpOiB2b2lkIHtcbiAgICB2YXIgdmlldyA9IHJlc29sdmVJbnRlcm5hbERvbVZpZXcobG9jYXRpb24ucmVuZGVyVmlldyk7XG4gICAgRE9NLnNldFByb3BlcnR5KDxFbGVtZW50PnZpZXcuYm91bmRFbGVtZW50c1tsb2NhdGlvbi5ib3VuZEVsZW1lbnRJbmRleF0sIHByb3BlcnR5TmFtZSxcbiAgICAgICAgICAgICAgICAgICAgcHJvcGVydHlWYWx1ZSk7XG4gIH1cblxuICBzZXRFbGVtZW50QXR0cmlidXRlKGxvY2F0aW9uOiBSZW5kZXJFbGVtZW50UmVmLCBhdHRyaWJ1dGVOYW1lOiBzdHJpbmcsXG4gICAgICAgICAgICAgICAgICAgICAgYXR0cmlidXRlVmFsdWU6IHN0cmluZyk6IHZvaWQge1xuICAgIHZhciB2aWV3ID0gcmVzb2x2ZUludGVybmFsRG9tVmlldyhsb2NhdGlvbi5yZW5kZXJWaWV3KTtcbiAgICB2YXIgZWxlbWVudCA9IHZpZXcuYm91bmRFbGVtZW50c1tsb2NhdGlvbi5ib3VuZEVsZW1lbnRJbmRleF07XG4gICAgdmFyIGRhc2hDYXNlZEF0dHJpYnV0ZU5hbWUgPSBjYW1lbENhc2VUb0Rhc2hDYXNlKGF0dHJpYnV0ZU5hbWUpO1xuICAgIGlmIChpc1ByZXNlbnQoYXR0cmlidXRlVmFsdWUpKSB7XG4gICAgICBET00uc2V0QXR0cmlidXRlKGVsZW1lbnQsIGRhc2hDYXNlZEF0dHJpYnV0ZU5hbWUsIHN0cmluZ2lmeShhdHRyaWJ1dGVWYWx1ZSkpO1xuICAgIH0gZWxzZSB7XG4gICAgICBET00ucmVtb3ZlQXR0cmlidXRlKGVsZW1lbnQsIGRhc2hDYXNlZEF0dHJpYnV0ZU5hbWUpO1xuICAgIH1cbiAgfVxuXG4gIHNldEVsZW1lbnRDbGFzcyhsb2NhdGlvbjogUmVuZGVyRWxlbWVudFJlZiwgY2xhc3NOYW1lOiBzdHJpbmcsIGlzQWRkOiBib29sZWFuKTogdm9pZCB7XG4gICAgdmFyIHZpZXcgPSByZXNvbHZlSW50ZXJuYWxEb21WaWV3KGxvY2F0aW9uLnJlbmRlclZpZXcpO1xuICAgIHZhciBlbGVtZW50ID0gdmlldy5ib3VuZEVsZW1lbnRzW2xvY2F0aW9uLmJvdW5kRWxlbWVudEluZGV4XTtcbiAgICBpZiAoaXNBZGQpIHtcbiAgICAgIERPTS5hZGRDbGFzcyhlbGVtZW50LCBjbGFzc05hbWUpO1xuICAgIH0gZWxzZSB7XG4gICAgICBET00ucmVtb3ZlQ2xhc3MoZWxlbWVudCwgY2xhc3NOYW1lKTtcbiAgICB9XG4gIH1cblxuICBzZXRFbGVtZW50U3R5bGUobG9jYXRpb246IFJlbmRlckVsZW1lbnRSZWYsIHN0eWxlTmFtZTogc3RyaW5nLCBzdHlsZVZhbHVlOiBzdHJpbmcpOiB2b2lkIHtcbiAgICB2YXIgdmlldyA9IHJlc29sdmVJbnRlcm5hbERvbVZpZXcobG9jYXRpb24ucmVuZGVyVmlldyk7XG4gICAgdmFyIGVsZW1lbnQgPSB2aWV3LmJvdW5kRWxlbWVudHNbbG9jYXRpb24uYm91bmRFbGVtZW50SW5kZXhdO1xuICAgIHZhciBkYXNoQ2FzZWRTdHlsZU5hbWUgPSBjYW1lbENhc2VUb0Rhc2hDYXNlKHN0eWxlTmFtZSk7XG4gICAgaWYgKGlzUHJlc2VudChzdHlsZVZhbHVlKSkge1xuICAgICAgRE9NLnNldFN0eWxlKGVsZW1lbnQsIGRhc2hDYXNlZFN0eWxlTmFtZSwgc3RyaW5naWZ5KHN0eWxlVmFsdWUpKTtcbiAgICB9IGVsc2Uge1xuICAgICAgRE9NLnJlbW92ZVN0eWxlKGVsZW1lbnQsIGRhc2hDYXNlZFN0eWxlTmFtZSk7XG4gICAgfVxuICB9XG5cbiAgaW52b2tlRWxlbWVudE1ldGhvZChsb2NhdGlvbjogUmVuZGVyRWxlbWVudFJlZiwgbWV0aG9kTmFtZTogc3RyaW5nLCBhcmdzOiBhbnlbXSk6IHZvaWQge1xuICAgIHZhciB2aWV3ID0gcmVzb2x2ZUludGVybmFsRG9tVmlldyhsb2NhdGlvbi5yZW5kZXJWaWV3KTtcbiAgICB2YXIgZWxlbWVudCA9IDxFbGVtZW50PnZpZXcuYm91bmRFbGVtZW50c1tsb2NhdGlvbi5ib3VuZEVsZW1lbnRJbmRleF07XG4gICAgRE9NLmludm9rZShlbGVtZW50LCBtZXRob2ROYW1lLCBhcmdzKTtcbiAgfVxuXG4gIHNldFRleHQodmlld1JlZjogUmVuZGVyVmlld1JlZiwgdGV4dE5vZGVJbmRleDogbnVtYmVyLCB0ZXh0OiBzdHJpbmcpOiB2b2lkIHtcbiAgICB2YXIgdmlldyA9IHJlc29sdmVJbnRlcm5hbERvbVZpZXcodmlld1JlZik7XG4gICAgRE9NLnNldFRleHQodmlldy5ib3VuZFRleHROb2Rlc1t0ZXh0Tm9kZUluZGV4XSwgdGV4dCk7XG4gIH1cblxuICBzZXRFdmVudERpc3BhdGNoZXIodmlld1JlZjogUmVuZGVyVmlld1JlZiwgZGlzcGF0Y2hlcjogUmVuZGVyRXZlbnREaXNwYXRjaGVyKTogdm9pZCB7XG4gICAgcmVzb2x2ZUludGVybmFsRG9tVmlldyh2aWV3UmVmKS5zZXRFdmVudERpc3BhdGNoZXIoZGlzcGF0Y2hlcik7XG4gIH1cbn1cblxuQEluamVjdGFibGUoKVxuZXhwb3J0IGNsYXNzIERvbVJlbmRlcmVyXyBleHRlbmRzIERvbVJlbmRlcmVyIHtcbiAgcHJpdmF0ZSBfY29tcG9uZW50VHBsczogTWFwPHN0cmluZywgUmVuZGVyQ29tcG9uZW50VGVtcGxhdGU+ID1cbiAgICAgIG5ldyBNYXA8c3RyaW5nLCBSZW5kZXJDb21wb25lbnRUZW1wbGF0ZT4oKTtcbiAgcHJpdmF0ZSBfZG9jdW1lbnQ7XG5cbiAgY29uc3RydWN0b3IocHJpdmF0ZSBfZXZlbnRNYW5hZ2VyOiBFdmVudE1hbmFnZXIsXG4gICAgICAgICAgICAgIHByaXZhdGUgX2RvbVNoYXJlZFN0eWxlc0hvc3Q6IERvbVNoYXJlZFN0eWxlc0hvc3QsIHByaXZhdGUgX2FuaW1hdGU6IEFuaW1hdGlvbkJ1aWxkZXIsXG4gICAgICAgICAgICAgIEBJbmplY3QoRE9DVU1FTlQpIGRvY3VtZW50KSB7XG4gICAgc3VwZXIoKTtcbiAgICB0aGlzLl9kb2N1bWVudCA9IGRvY3VtZW50O1xuICB9XG5cbiAgcmVnaXN0ZXJDb21wb25lbnRUZW1wbGF0ZSh0ZW1wbGF0ZTogUmVuZGVyQ29tcG9uZW50VGVtcGxhdGUpIHtcbiAgICB0aGlzLl9jb21wb25lbnRUcGxzLnNldCh0ZW1wbGF0ZS5pZCwgdGVtcGxhdGUpO1xuICAgIGlmICh0ZW1wbGF0ZS5lbmNhcHN1bGF0aW9uICE9PSBWaWV3RW5jYXBzdWxhdGlvbi5OYXRpdmUpIHtcbiAgICAgIHZhciBlbmNhcHN1bGF0ZWRTdHlsZXMgPSBlbmNhcHN1bGF0ZVN0eWxlcyh0ZW1wbGF0ZSk7XG4gICAgICB0aGlzLl9kb21TaGFyZWRTdHlsZXNIb3N0LmFkZFN0eWxlcyhlbmNhcHN1bGF0ZWRTdHlsZXMpO1xuICAgIH1cbiAgfVxuXG4gIGNyZWF0ZVByb3RvVmlldyhjb21wb25lbnRUZW1wbGF0ZUlkOiBzdHJpbmcsIGNtZHM6IFJlbmRlclRlbXBsYXRlQ21kW10pOiBSZW5kZXJQcm90b1ZpZXdSZWYge1xuICAgIHJldHVybiBuZXcgRGVmYXVsdFByb3RvVmlld1JlZih0aGlzLl9jb21wb25lbnRUcGxzLmdldChjb21wb25lbnRUZW1wbGF0ZUlkKSwgY21kcyk7XG4gIH1cblxuICByZXNvbHZlQ29tcG9uZW50VGVtcGxhdGUodGVtcGxhdGVJZDogc3RyaW5nKTogUmVuZGVyQ29tcG9uZW50VGVtcGxhdGUge1xuICAgIHJldHVybiB0aGlzLl9jb21wb25lbnRUcGxzLmdldCh0ZW1wbGF0ZUlkKTtcbiAgfVxuXG4gIC8qKiBAaW50ZXJuYWwgKi9cbiAgX2NyZWF0ZVJvb3RIb3N0Vmlld1Njb3BlOiBXdGZTY29wZUZuID0gd3RmQ3JlYXRlU2NvcGUoJ0RvbVJlbmRlcmVyI2NyZWF0ZVJvb3RIb3N0VmlldygpJyk7XG4gIGNyZWF0ZVJvb3RIb3N0Vmlldyhob3N0UHJvdG9WaWV3UmVmOiBSZW5kZXJQcm90b1ZpZXdSZWYsIGZyYWdtZW50Q291bnQ6IG51bWJlcixcbiAgICAgICAgICAgICAgICAgICAgIGhvc3RFbGVtZW50U2VsZWN0b3I6IHN0cmluZyk6IFJlbmRlclZpZXdXaXRoRnJhZ21lbnRzIHtcbiAgICB2YXIgcyA9IHRoaXMuX2NyZWF0ZVJvb3RIb3N0Vmlld1Njb3BlKCk7XG4gICAgdmFyIGVsZW1lbnQgPSBET00ucXVlcnlTZWxlY3Rvcih0aGlzLl9kb2N1bWVudCwgaG9zdEVsZW1lbnRTZWxlY3Rvcik7XG4gICAgaWYgKGlzQmxhbmsoZWxlbWVudCkpIHtcbiAgICAgIHd0ZkxlYXZlKHMpO1xuICAgICAgdGhyb3cgbmV3IEJhc2VFeGNlcHRpb24oYFRoZSBzZWxlY3RvciBcIiR7aG9zdEVsZW1lbnRTZWxlY3Rvcn1cIiBkaWQgbm90IG1hdGNoIGFueSBlbGVtZW50c2ApO1xuICAgIH1cbiAgICByZXR1cm4gd3RmTGVhdmUocywgdGhpcy5fY3JlYXRlVmlldyhob3N0UHJvdG9WaWV3UmVmLCBlbGVtZW50KSk7XG4gIH1cblxuICAvKiogQGludGVybmFsICovXG4gIF9jcmVhdGVWaWV3U2NvcGUgPSB3dGZDcmVhdGVTY29wZSgnRG9tUmVuZGVyZXIjY3JlYXRlVmlldygpJyk7XG4gIGNyZWF0ZVZpZXcocHJvdG9WaWV3UmVmOiBSZW5kZXJQcm90b1ZpZXdSZWYsIGZyYWdtZW50Q291bnQ6IG51bWJlcik6IFJlbmRlclZpZXdXaXRoRnJhZ21lbnRzIHtcbiAgICB2YXIgcyA9IHRoaXMuX2NyZWF0ZVZpZXdTY29wZSgpO1xuICAgIHJldHVybiB3dGZMZWF2ZShzLCB0aGlzLl9jcmVhdGVWaWV3KHByb3RvVmlld1JlZiwgbnVsbCkpO1xuICB9XG5cbiAgcHJpdmF0ZSBfY3JlYXRlVmlldyhwcm90b1ZpZXdSZWY6IFJlbmRlclByb3RvVmlld1JlZixcbiAgICAgICAgICAgICAgICAgICAgICBpbnBsYWNlRWxlbWVudDogSFRNTEVsZW1lbnQpOiBSZW5kZXJWaWV3V2l0aEZyYWdtZW50cyB7XG4gICAgdmFyIGRwdnIgPSA8RGVmYXVsdFByb3RvVmlld1JlZj5wcm90b1ZpZXdSZWY7XG4gICAgdmFyIHZpZXcgPSBjcmVhdGVSZW5kZXJWaWV3KGRwdnIudGVtcGxhdGUsIGRwdnIuY21kcywgaW5wbGFjZUVsZW1lbnQsIHRoaXMpO1xuICAgIHZhciBzZFJvb3RzID0gdmlldy5uYXRpdmVTaGFkb3dSb290cztcbiAgICBmb3IgKHZhciBpID0gMDsgaSA8IHNkUm9vdHMubGVuZ3RoOyBpKyspIHtcbiAgICAgIHRoaXMuX2RvbVNoYXJlZFN0eWxlc0hvc3QuYWRkSG9zdChzZFJvb3RzW2ldKTtcbiAgICB9XG4gICAgcmV0dXJuIG5ldyBSZW5kZXJWaWV3V2l0aEZyYWdtZW50cyh2aWV3LCB2aWV3LmZyYWdtZW50cyk7XG4gIH1cblxuICBkZXN0cm95Vmlldyh2aWV3UmVmOiBSZW5kZXJWaWV3UmVmKSB7XG4gICAgdmFyIHZpZXcgPSA8RGVmYXVsdFJlbmRlclZpZXc8Tm9kZT4+dmlld1JlZjtcbiAgICB2YXIgc2RSb290cyA9IHZpZXcubmF0aXZlU2hhZG93Um9vdHM7XG4gICAgZm9yICh2YXIgaSA9IDA7IGkgPCBzZFJvb3RzLmxlbmd0aDsgaSsrKSB7XG4gICAgICB0aGlzLl9kb21TaGFyZWRTdHlsZXNIb3N0LnJlbW92ZUhvc3Qoc2RSb290c1tpXSk7XG4gICAgfVxuICB9XG5cbiAgYW5pbWF0ZU5vZGVFbnRlcihub2RlOiBOb2RlKSB7XG4gICAgaWYgKERPTS5pc0VsZW1lbnROb2RlKG5vZGUpICYmIERPTS5oYXNDbGFzcyhub2RlLCAnbmctYW5pbWF0ZScpKSB7XG4gICAgICBET00uYWRkQ2xhc3Mobm9kZSwgJ25nLWVudGVyJyk7XG4gICAgICB0aGlzLl9hbmltYXRlLmNzcygpXG4gICAgICAgICAgLmFkZEFuaW1hdGlvbkNsYXNzKCduZy1lbnRlci1hY3RpdmUnKVxuICAgICAgICAgIC5zdGFydCg8SFRNTEVsZW1lbnQ+bm9kZSlcbiAgICAgICAgICAub25Db21wbGV0ZSgoKSA9PiB7IERPTS5yZW1vdmVDbGFzcyhub2RlLCAnbmctZW50ZXInKTsgfSk7XG4gICAgfVxuICB9XG5cbiAgYW5pbWF0ZU5vZGVMZWF2ZShub2RlOiBOb2RlKSB7XG4gICAgaWYgKERPTS5pc0VsZW1lbnROb2RlKG5vZGUpICYmIERPTS5oYXNDbGFzcyhub2RlLCAnbmctYW5pbWF0ZScpKSB7XG4gICAgICBET00uYWRkQ2xhc3Mobm9kZSwgJ25nLWxlYXZlJyk7XG4gICAgICB0aGlzLl9hbmltYXRlLmNzcygpXG4gICAgICAgICAgLmFkZEFuaW1hdGlvbkNsYXNzKCduZy1sZWF2ZS1hY3RpdmUnKVxuICAgICAgICAgIC5zdGFydCg8SFRNTEVsZW1lbnQ+bm9kZSlcbiAgICAgICAgICAub25Db21wbGV0ZSgoKSA9PiB7XG4gICAgICAgICAgICBET00ucmVtb3ZlQ2xhc3Mobm9kZSwgJ25nLWxlYXZlJyk7XG4gICAgICAgICAgICBET00ucmVtb3ZlKG5vZGUpO1xuICAgICAgICAgIH0pO1xuICAgIH0gZWxzZSB7XG4gICAgICBET00ucmVtb3ZlKG5vZGUpO1xuICAgIH1cbiAgfVxuXG4gIC8qKiBAaW50ZXJuYWwgKi9cbiAgX2RldGFjaEZyYWdtZW50U2NvcGUgPSB3dGZDcmVhdGVTY29wZSgnRG9tUmVuZGVyZXIjZGV0YWNoRnJhZ21lbnQoKScpO1xuICBkZXRhY2hGcmFnbWVudChmcmFnbWVudFJlZjogUmVuZGVyRnJhZ21lbnRSZWYpIHtcbiAgICB2YXIgcyA9IHRoaXMuX2RldGFjaEZyYWdtZW50U2NvcGUoKTtcbiAgICB2YXIgZnJhZ21lbnROb2RlcyA9IHJlc29sdmVJbnRlcm5hbERvbUZyYWdtZW50KGZyYWdtZW50UmVmKTtcbiAgICBmb3IgKHZhciBpID0gMDsgaSA8IGZyYWdtZW50Tm9kZXMubGVuZ3RoOyBpKyspIHtcbiAgICAgIHRoaXMuYW5pbWF0ZU5vZGVMZWF2ZShmcmFnbWVudE5vZGVzW2ldKTtcbiAgICB9XG4gICAgd3RmTGVhdmUocyk7XG4gIH1cbiAgY3JlYXRlRWxlbWVudChuYW1lOiBzdHJpbmcsIGF0dHJOYW1lQW5kVmFsdWVzOiBzdHJpbmdbXSk6IE5vZGUge1xuICAgIHZhciBuc0FuZE5hbWUgPSBzcGxpdE5hbWVzcGFjZShuYW1lKTtcbiAgICB2YXIgZWwgPSBpc1ByZXNlbnQobnNBbmROYW1lWzBdKSA/XG4gICAgICAgICAgICAgICAgIERPTS5jcmVhdGVFbGVtZW50TlMoTkFNRVNQQUNFX1VSSVNbbnNBbmROYW1lWzBdXSwgbnNBbmROYW1lWzFdKSA6XG4gICAgICAgICAgICAgICAgIERPTS5jcmVhdGVFbGVtZW50KG5zQW5kTmFtZVsxXSk7XG4gICAgdGhpcy5fc2V0QXR0cmlidXRlcyhlbCwgYXR0ck5hbWVBbmRWYWx1ZXMpO1xuICAgIHJldHVybiBlbDtcbiAgfVxuICBtZXJnZUVsZW1lbnQoZXhpc3Rpbmc6IE5vZGUsIGF0dHJOYW1lQW5kVmFsdWVzOiBzdHJpbmdbXSkge1xuICAgIERPTS5jbGVhck5vZGVzKGV4aXN0aW5nKTtcbiAgICB0aGlzLl9zZXRBdHRyaWJ1dGVzKGV4aXN0aW5nLCBhdHRyTmFtZUFuZFZhbHVlcyk7XG4gIH1cbiAgcHJpdmF0ZSBfc2V0QXR0cmlidXRlcyhub2RlOiBOb2RlLCBhdHRyTmFtZUFuZFZhbHVlczogc3RyaW5nW10pIHtcbiAgICBmb3IgKHZhciBhdHRySWR4ID0gMDsgYXR0cklkeCA8IGF0dHJOYW1lQW5kVmFsdWVzLmxlbmd0aDsgYXR0cklkeCArPSAyKSB7XG4gICAgICB2YXIgYXR0ck5zO1xuICAgICAgdmFyIGF0dHJOYW1lID0gYXR0ck5hbWVBbmRWYWx1ZXNbYXR0cklkeF07XG4gICAgICB2YXIgbnNBbmROYW1lID0gc3BsaXROYW1lc3BhY2UoYXR0ck5hbWUpO1xuICAgICAgaWYgKGlzUHJlc2VudChuc0FuZE5hbWVbMF0pKSB7XG4gICAgICAgIGF0dHJOYW1lID0gbnNBbmROYW1lWzBdICsgJzonICsgbnNBbmROYW1lWzFdO1xuICAgICAgICBhdHRyTnMgPSBOQU1FU1BBQ0VfVVJJU1tuc0FuZE5hbWVbMF1dO1xuICAgICAgfVxuICAgICAgdmFyIGF0dHJWYWx1ZSA9IGF0dHJOYW1lQW5kVmFsdWVzW2F0dHJJZHggKyAxXTtcbiAgICAgIGlmIChpc1ByZXNlbnQoYXR0ck5zKSkge1xuICAgICAgICBET00uc2V0QXR0cmlidXRlTlMobm9kZSwgYXR0ck5zLCBhdHRyTmFtZSwgYXR0clZhbHVlKTtcbiAgICAgIH0gZWxzZSB7XG4gICAgICAgIERPTS5zZXRBdHRyaWJ1dGUobm9kZSwgbnNBbmROYW1lWzFdLCBhdHRyVmFsdWUpO1xuICAgICAgfVxuICAgIH1cbiAgfVxuICBjcmVhdGVSb290Q29udGVudEluc2VydGlvblBvaW50KCk6IE5vZGUge1xuICAgIHJldHVybiBET00uY3JlYXRlQ29tbWVudCgncm9vdC1jb250ZW50LWluc2VydGlvbi1wb2ludCcpO1xuICB9XG4gIGNyZWF0ZVNoYWRvd1Jvb3QoaG9zdDogTm9kZSwgdGVtcGxhdGVJZDogc3RyaW5nKTogTm9kZSB7XG4gICAgdmFyIHNyID0gRE9NLmNyZWF0ZVNoYWRvd1Jvb3QoaG9zdCk7XG4gICAgdmFyIHRwbCA9IHRoaXMuX2NvbXBvbmVudFRwbHMuZ2V0KHRlbXBsYXRlSWQpO1xuICAgIGZvciAodmFyIGkgPSAwOyBpIDwgdHBsLnN0eWxlcy5sZW5ndGg7IGkrKykge1xuICAgICAgRE9NLmFwcGVuZENoaWxkKHNyLCBET00uY3JlYXRlU3R5bGVFbGVtZW50KHRwbC5zdHlsZXNbaV0pKTtcbiAgICB9XG4gICAgcmV0dXJuIHNyO1xuICB9XG4gIG9uKGVsZW1lbnQ6IE5vZGUsIGV2ZW50TmFtZTogc3RyaW5nLCBjYWxsYmFjazogRnVuY3Rpb24pIHtcbiAgICB0aGlzLl9ldmVudE1hbmFnZXIuYWRkRXZlbnRMaXN0ZW5lcig8SFRNTEVsZW1lbnQ+ZWxlbWVudCwgZXZlbnROYW1lLFxuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIGRlY29yYXRlUHJldmVudERlZmF1bHQoY2FsbGJhY2spKTtcbiAgfVxuICBnbG9iYWxPbih0YXJnZXQ6IHN0cmluZywgZXZlbnROYW1lOiBzdHJpbmcsIGNhbGxiYWNrOiBGdW5jdGlvbik6IEZ1bmN0aW9uIHtcbiAgICByZXR1cm4gdGhpcy5fZXZlbnRNYW5hZ2VyLmFkZEdsb2JhbEV2ZW50TGlzdGVuZXIodGFyZ2V0LCBldmVudE5hbWUsXG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIGRlY29yYXRlUHJldmVudERlZmF1bHQoY2FsbGJhY2spKTtcbiAgfVxufVxuXG5mdW5jdGlvbiByZXNvbHZlSW50ZXJuYWxEb21WaWV3KHZpZXdSZWY6IFJlbmRlclZpZXdSZWYpOiBEZWZhdWx0UmVuZGVyVmlldzxOb2RlPiB7XG4gIHJldHVybiA8RGVmYXVsdFJlbmRlclZpZXc8Tm9kZT4+dmlld1JlZjtcbn1cblxuZnVuY3Rpb24gcmVzb2x2ZUludGVybmFsRG9tRnJhZ21lbnQoZnJhZ21lbnRSZWY6IFJlbmRlckZyYWdtZW50UmVmKTogTm9kZVtdIHtcbiAgcmV0dXJuICg8RGVmYXVsdFJlbmRlckZyYWdtZW50UmVmPE5vZGU+PmZyYWdtZW50UmVmKS5ub2Rlcztcbn1cblxuZnVuY3Rpb24gbW92ZU5vZGVzQWZ0ZXJTaWJsaW5nKHNpYmxpbmcsIG5vZGVzKSB7XG4gIGlmIChub2Rlcy5sZW5ndGggPiAwICYmIGlzUHJlc2VudChET00ucGFyZW50RWxlbWVudChzaWJsaW5nKSkpIHtcbiAgICBmb3IgKHZhciBpID0gMDsgaSA8IG5vZGVzLmxlbmd0aDsgaSsrKSB7XG4gICAgICBET00uaW5zZXJ0QmVmb3JlKHNpYmxpbmcsIG5vZGVzW2ldKTtcbiAgICB9XG4gICAgRE9NLmluc2VydEJlZm9yZShub2Rlc1swXSwgc2libGluZyk7XG4gIH1cbn1cblxuZnVuY3Rpb24gZGVjb3JhdGVQcmV2ZW50RGVmYXVsdChldmVudEhhbmRsZXI6IEZ1bmN0aW9uKTogRnVuY3Rpb24ge1xuICByZXR1cm4gKGV2ZW50KSA9PiB7XG4gICAgdmFyIGFsbG93RGVmYXVsdEJlaGF2aW9yID0gZXZlbnRIYW5kbGVyKGV2ZW50KTtcbiAgICBpZiAoIWFsbG93RGVmYXVsdEJlaGF2aW9yKSB7XG4gICAgICAvLyBUT0RPKHRib3NjaCk6IG1vdmUgcHJldmVudERlZmF1bHQgaW50byBldmVudCBwbHVnaW5zLi4uXG4gICAgICBET00ucHJldmVudERlZmF1bHQoZXZlbnQpO1xuICAgIH1cbiAgfTtcbn1cblxudmFyIE5TX1BSRUZJWF9SRSA9IC9eQChbXjpdKyk6KC4rKS9nO1xuXG5mdW5jdGlvbiBzcGxpdE5hbWVzcGFjZShuYW1lOiBzdHJpbmcpOiBzdHJpbmdbXSB7XG4gIGlmIChuYW1lWzBdICE9ICdAJykge1xuICAgIHJldHVybiBbbnVsbCwgbmFtZV07XG4gIH1cbiAgbGV0IG1hdGNoID0gUmVnRXhwV3JhcHBlci5maXJzdE1hdGNoKE5TX1BSRUZJWF9SRSwgbmFtZSk7XG4gIHJldHVybiBbbWF0Y2hbMV0sIG1hdGNoWzJdXTtcbn1cbiJdfQ==