import { provide, Provider } from 'angular2/src/core/di';
import { AnimationBuilder } from 'angular2/src/animate/animation_builder';
import { MockAnimationBuilder } from 'angular2/src/mock/animation_builder_mock';
import { ProtoViewFactory } from 'angular2/src/core/linker/proto_view_factory';
import { Reflector, reflector } from 'angular2/src/core/reflection/reflection';
import { IterableDiffers, defaultIterableDiffers, KeyValueDiffers, defaultKeyValueDiffers, ChangeDetectorGenConfig } from 'angular2/src/core/change_detection/change_detection';
import { ExceptionHandler } from 'angular2/src/facade/exceptions';
import { ViewResolver } from 'angular2/src/core/linker/view_resolver';
import { DirectiveResolver } from 'angular2/src/core/linker/directive_resolver';
import { PipeResolver } from 'angular2/src/core/linker/pipe_resolver';
import { DynamicComponentLoader } from 'angular2/src/core/linker/dynamic_component_loader';
import { XHR } from 'angular2/src/compiler/xhr';
import { NgZone } from 'angular2/src/core/zone/ng_zone';
import { DOM } from 'angular2/src/platform/dom/dom_adapter';
import { MockDirectiveResolver } from 'angular2/src/mock/directive_resolver_mock';
import { MockViewResolver } from 'angular2/src/mock/view_resolver_mock';
import { MockLocationStrategy } from 'angular2/src/mock/mock_location_strategy';
import { LocationStrategy } from 'angular2/src/router/location_strategy';
import { MockNgZone } from 'angular2/src/mock/ng_zone_mock';
import { TestComponentBuilder } from './test_component_builder';
import { Injector } from 'angular2/src/core/di';
import { EventManager, EVENT_MANAGER_PLUGINS, ELEMENT_PROBE_PROVIDERS } from 'angular2/platform/common_dom';
import { ListWrapper } from 'angular2/src/facade/collection';
import { FunctionWrapper } from 'angular2/src/facade/lang';
import { AppViewPool, APP_VIEW_POOL_CAPACITY } from 'angular2/src/core/linker/view_pool';
import { AppViewManager } from 'angular2/src/core/linker/view_manager';
import { AppViewManagerUtils } from 'angular2/src/core/linker/view_manager_utils';
import { Renderer } from 'angular2/src/core/render/api';
import { DOCUMENT } from 'angular2/src/platform/dom/dom_tokens';
import { DomRenderer } from 'angular2/src/platform/dom/dom_renderer';
import { DomSharedStylesHost } from 'angular2/src/platform/dom/shared_styles_host';
import { SharedStylesHost } from 'angular2/src/platform/dom/shared_styles_host';
import { DomEventsPlugin } from 'angular2/src/platform/dom/events/dom_events';
import { APP_ID } from 'angular2/src/core/application_tokens';
import { Serializer } from "angular2/src/web_workers/shared/serializer";
import { Log } from './utils';
import { COMPILER_PROVIDERS } from 'angular2/src/compiler/compiler';
import { DomRenderer_ } from "angular2/src/platform/dom/dom_renderer";
import { DynamicComponentLoader_ } from "angular2/src/core/linker/dynamic_component_loader";
import { AppViewManager_ } from "angular2/src/core/linker/view_manager";
import { APPLICATION_COMMON_PROVIDERS } from 'angular2/src/core/application_common_providers';
/**
 * Returns the root injector providers.
 *
 * This must be kept in sync with the _rootBindings in application.js
 *
 * @returns {any[]}
 */
function _getRootProviders() {
    return [provide(Reflector, { useValue: reflector })];
}
/**
 * Returns the application injector providers.
 *
 * This must be kept in sync with _injectorBindings() in application.js
 *
 * @returns {any[]}
 */
function _getAppBindings() {
    var appDoc;
    // The document is only available in browser environment
    try {
        appDoc = DOM.defaultDoc();
    }
    catch (e) {
        appDoc = null;
    }
    return [
        APPLICATION_COMMON_PROVIDERS,
        provide(ChangeDetectorGenConfig, { useValue: new ChangeDetectorGenConfig(true, false, true) }),
        provide(DOCUMENT, { useValue: appDoc }),
        provide(DomRenderer, { useClass: DomRenderer_ }),
        provide(Renderer, { useExisting: DomRenderer }),
        provide(APP_ID, { useValue: 'a' }),
        DomSharedStylesHost,
        provide(SharedStylesHost, { useExisting: DomSharedStylesHost }),
        AppViewPool,
        provide(AppViewManager, { useClass: AppViewManager_ }),
        AppViewManagerUtils,
        Serializer,
        ELEMENT_PROBE_PROVIDERS,
        provide(APP_VIEW_POOL_CAPACITY, { useValue: 500 }),
        ProtoViewFactory,
        provide(DirectiveResolver, { useClass: MockDirectiveResolver }),
        provide(ViewResolver, { useClass: MockViewResolver }),
        provide(IterableDiffers, { useValue: defaultIterableDiffers }),
        provide(KeyValueDiffers, { useValue: defaultKeyValueDiffers }),
        Log,
        provide(DynamicComponentLoader, { useClass: DynamicComponentLoader_ }),
        PipeResolver,
        provide(ExceptionHandler, { useValue: new ExceptionHandler(DOM) }),
        provide(LocationStrategy, { useClass: MockLocationStrategy }),
        provide(XHR, { useClass: DOM.getXHR() }),
        TestComponentBuilder,
        provide(NgZone, { useClass: MockNgZone }),
        provide(AnimationBuilder, { useClass: MockAnimationBuilder }),
        EventManager,
        new Provider(EVENT_MANAGER_PLUGINS, { useClass: DomEventsPlugin, multi: true })
    ];
}
function _runtimeCompilerBindings() {
    return [
        provide(XHR, { useClass: DOM.getXHR() }),
        COMPILER_PROVIDERS,
    ];
}
export function createTestInjector(providers) {
    var rootInjector = Injector.resolveAndCreate(_getRootProviders());
    return rootInjector.resolveAndCreateChild(ListWrapper.concat(_getAppBindings(), providers));
}
export function createTestInjectorWithRuntimeCompiler(providers) {
    return createTestInjector(ListWrapper.concat(_runtimeCompilerBindings(), providers));
}
/**
 * Allows injecting dependencies in `beforeEach()` and `it()`. When using with the
 * `angular2/testing` library, the test function will be run within a zone and will
 * automatically complete when all asynchronous tests have finished.
 *
 * Example:
 *
 * ```
 * beforeEach(inject([Dependency, AClass], (dep, object) => {
 *   // some code that uses `dep` and `object`
 *   // ...
 * }));
 *
 * it('...', inject([AClass], (object) => {
 *   object.doSomething().then(() => {
 *     expect(...);
 *   });
 * })
 * ```
 *
 * Notes:
 * - inject is currently a function because of some Traceur limitation the syntax should eventually
 *   becomes `it('...', @Inject (object: AClass, async: AsyncTestCompleter) => { ... });`
 *
 * @param {Array} tokens
 * @param {Function} fn
 * @return {FunctionWithParamTokens}
 */
export function inject(tokens, fn) {
    return new FunctionWithParamTokens(tokens, fn, false);
}
/**
 * @deprecated Use inject instead, which now supports both synchronous and asynchronous tests.
 */
export function injectAsync(tokens, fn) {
    return new FunctionWithParamTokens(tokens, fn, true);
}
export class FunctionWithParamTokens {
    constructor(_tokens, _fn, isAsync) {
        this._tokens = _tokens;
        this._fn = _fn;
        this.isAsync = isAsync;
    }
    /**
     * Returns the value of the executed function.
     */
    execute(injector) {
        var params = this._tokens.map(t => injector.get(t));
        return FunctionWrapper.apply(this._fn, params);
    }
    hasToken(token) { return this._tokens.indexOf(token) > -1; }
}
//# sourceMappingURL=data:application/json;base64,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