'use strict';var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") return Reflect.decorate(decorators, target, key, desc);
    switch (arguments.length) {
        case 2: return decorators.reduceRight(function(o, d) { return (d && d(o)) || o; }, target);
        case 3: return decorators.reduceRight(function(o, d) { return (d && d(target, key)), void 0; }, void 0);
        case 4: return decorators.reduceRight(function(o, d) { return (d && d(target, key, o)) || o; }, desc);
    }
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var lang_1 = require('angular2/src/facade/lang');
var collection_1 = require('angular2/src/facade/collection');
var template_commands_1 = require('angular2/src/core/linker/template_commands');
var template_ast_1 = require('./template_ast');
var source_module_1 = require('./source_module');
var util_1 = require('./util');
var di_1 = require('angular2/src/core/di');
exports.TEMPLATE_COMMANDS_MODULE_REF = source_module_1.moduleRef("package:angular2/src/core/linker/template_commands" + util_1.MODULE_SUFFIX);
var IMPLICIT_TEMPLATE_VAR = '\$implicit';
var CLASS_ATTR = 'class';
var STYLE_ATTR = 'style';
var CommandCompiler = (function () {
    function CommandCompiler() {
    }
    CommandCompiler.prototype.compileComponentRuntime = function (component, template, changeDetectorFactories, componentTemplateFactory) {
        var visitor = new CommandBuilderVisitor(new RuntimeCommandFactory(component, componentTemplateFactory, changeDetectorFactories), 0);
        template_ast_1.templateVisitAll(visitor, template);
        return visitor.result;
    };
    CommandCompiler.prototype.compileComponentCodeGen = function (component, template, changeDetectorFactoryExpressions, componentTemplateFactory) {
        var visitor = new CommandBuilderVisitor(new CodegenCommandFactory(component, componentTemplateFactory, changeDetectorFactoryExpressions), 0);
        template_ast_1.templateVisitAll(visitor, template);
        return new source_module_1.SourceExpression([], codeGenArray(visitor.result));
    };
    CommandCompiler = __decorate([
        di_1.Injectable(), 
        __metadata('design:paramtypes', [])
    ], CommandCompiler);
    return CommandCompiler;
})();
exports.CommandCompiler = CommandCompiler;
var RuntimeCommandFactory = (function () {
    function RuntimeCommandFactory(component, componentTemplateFactory, changeDetectorFactories) {
        this.component = component;
        this.componentTemplateFactory = componentTemplateFactory;
        this.changeDetectorFactories = changeDetectorFactories;
    }
    RuntimeCommandFactory.prototype._mapDirectives = function (directives) {
        return directives.map(function (directive) { return directive.type.runtime; });
    };
    RuntimeCommandFactory.prototype.createText = function (value, isBound, ngContentIndex) {
        return new template_commands_1.TextCmd(value, isBound, ngContentIndex);
    };
    RuntimeCommandFactory.prototype.createNgContent = function (index, ngContentIndex) {
        return new template_commands_1.NgContentCmd(index, ngContentIndex);
    };
    RuntimeCommandFactory.prototype.createBeginElement = function (name, attrNameAndValues, eventTargetAndNames, variableNameAndValues, directives, isBound, ngContentIndex) {
        return new template_commands_1.BeginElementCmd(name, attrNameAndValues, eventTargetAndNames, variableNameAndValues, this._mapDirectives(directives), isBound, ngContentIndex);
    };
    RuntimeCommandFactory.prototype.createEndElement = function () { return new template_commands_1.EndElementCmd(); };
    RuntimeCommandFactory.prototype.createBeginComponent = function (name, attrNameAndValues, eventTargetAndNames, variableNameAndValues, directives, encapsulation, ngContentIndex) {
        var nestedTemplateAccessor = this.componentTemplateFactory(directives[0]);
        return new template_commands_1.BeginComponentCmd(name, attrNameAndValues, eventTargetAndNames, variableNameAndValues, this._mapDirectives(directives), encapsulation, ngContentIndex, nestedTemplateAccessor);
    };
    RuntimeCommandFactory.prototype.createEndComponent = function () { return new template_commands_1.EndComponentCmd(); };
    RuntimeCommandFactory.prototype.createEmbeddedTemplate = function (embeddedTemplateIndex, attrNameAndValues, variableNameAndValues, directives, isMerged, ngContentIndex, children) {
        return new template_commands_1.EmbeddedTemplateCmd(attrNameAndValues, variableNameAndValues, this._mapDirectives(directives), isMerged, ngContentIndex, this.changeDetectorFactories[embeddedTemplateIndex], children);
    };
    return RuntimeCommandFactory;
})();
var CodegenCommandFactory = (function () {
    function CodegenCommandFactory(component, componentTemplateFactory, changeDetectorFactoryExpressions) {
        this.component = component;
        this.componentTemplateFactory = componentTemplateFactory;
        this.changeDetectorFactoryExpressions = changeDetectorFactoryExpressions;
    }
    CodegenCommandFactory.prototype.createText = function (value, isBound, ngContentIndex) {
        return new Expression(util_1.codeGenConstConstructorCall(exports.TEMPLATE_COMMANDS_MODULE_REF + 'TextCmd') + "(" + util_1.escapeSingleQuoteString(value) + ", " + isBound + ", " + ngContentIndex + ")");
    };
    CodegenCommandFactory.prototype.createNgContent = function (index, ngContentIndex) {
        return new Expression(util_1.codeGenConstConstructorCall(exports.TEMPLATE_COMMANDS_MODULE_REF + 'NgContentCmd') + "(" + index + ", " + ngContentIndex + ")");
    };
    CodegenCommandFactory.prototype.createBeginElement = function (name, attrNameAndValues, eventTargetAndNames, variableNameAndValues, directives, isBound, ngContentIndex) {
        var attrsExpression = codeGenArray(attrNameAndValues);
        return new Expression((util_1.codeGenConstConstructorCall(exports.TEMPLATE_COMMANDS_MODULE_REF + 'BeginElementCmd') + "(" + util_1.escapeSingleQuoteString(name) + ", " + attrsExpression + ", ") +
            (codeGenArray(eventTargetAndNames) + ", " + codeGenArray(variableNameAndValues) + ", " + codeGenDirectivesArray(directives) + ", " + isBound + ", " + ngContentIndex + ")"));
    };
    CodegenCommandFactory.prototype.createEndElement = function () {
        return new Expression(util_1.codeGenConstConstructorCall(exports.TEMPLATE_COMMANDS_MODULE_REF + 'EndElementCmd') + "()");
    };
    CodegenCommandFactory.prototype.createBeginComponent = function (name, attrNameAndValues, eventTargetAndNames, variableNameAndValues, directives, encapsulation, ngContentIndex) {
        var attrsExpression = codeGenArray(attrNameAndValues);
        return new Expression((util_1.codeGenConstConstructorCall(exports.TEMPLATE_COMMANDS_MODULE_REF + 'BeginComponentCmd') + "(" + util_1.escapeSingleQuoteString(name) + ", " + attrsExpression + ", ") +
            (codeGenArray(eventTargetAndNames) + ", " + codeGenArray(variableNameAndValues) + ", " + codeGenDirectivesArray(directives) + ", " + codeGenViewEncapsulation(encapsulation) + ", " + ngContentIndex + ", " + this.componentTemplateFactory(directives[0]) + ")"));
    };
    CodegenCommandFactory.prototype.createEndComponent = function () {
        return new Expression(util_1.codeGenConstConstructorCall(exports.TEMPLATE_COMMANDS_MODULE_REF + 'EndComponentCmd') + "()");
    };
    CodegenCommandFactory.prototype.createEmbeddedTemplate = function (embeddedTemplateIndex, attrNameAndValues, variableNameAndValues, directives, isMerged, ngContentIndex, children) {
        return new Expression((util_1.codeGenConstConstructorCall(exports.TEMPLATE_COMMANDS_MODULE_REF + 'EmbeddedTemplateCmd') + "(" + codeGenArray(attrNameAndValues) + ", " + codeGenArray(variableNameAndValues) + ", ") +
            (codeGenDirectivesArray(directives) + ", " + isMerged + ", " + ngContentIndex + ", " + this.changeDetectorFactoryExpressions[embeddedTemplateIndex] + ", " + codeGenArray(children) + ")"));
    };
    return CodegenCommandFactory;
})();
function visitAndReturnContext(visitor, asts, context) {
    template_ast_1.templateVisitAll(visitor, asts, context);
    return context;
}
var CommandBuilderVisitor = (function () {
    function CommandBuilderVisitor(commandFactory, embeddedTemplateIndex) {
        this.commandFactory = commandFactory;
        this.embeddedTemplateIndex = embeddedTemplateIndex;
        this.result = [];
        this.transitiveNgContentCount = 0;
    }
    CommandBuilderVisitor.prototype._readAttrNameAndValues = function (directives, attrAsts) {
        var attrs = keyValueArrayToMap(visitAndReturnContext(this, attrAsts, []));
        directives.forEach(function (directiveMeta) {
            collection_1.StringMapWrapper.forEach(directiveMeta.hostAttributes, function (value, name) {
                var prevValue = attrs[name];
                attrs[name] = lang_1.isPresent(prevValue) ? mergeAttributeValue(name, prevValue, value) : value;
            });
        });
        return mapToKeyValueArray(attrs);
    };
    CommandBuilderVisitor.prototype.visitNgContent = function (ast, context) {
        this.transitiveNgContentCount++;
        this.result.push(this.commandFactory.createNgContent(ast.index, ast.ngContentIndex));
        return null;
    };
    CommandBuilderVisitor.prototype.visitEmbeddedTemplate = function (ast, context) {
        var _this = this;
        this.embeddedTemplateIndex++;
        var childVisitor = new CommandBuilderVisitor(this.commandFactory, this.embeddedTemplateIndex);
        template_ast_1.templateVisitAll(childVisitor, ast.children);
        var isMerged = childVisitor.transitiveNgContentCount > 0;
        var variableNameAndValues = [];
        ast.vars.forEach(function (varAst) {
            variableNameAndValues.push(varAst.name);
            variableNameAndValues.push(varAst.value.length > 0 ? varAst.value : IMPLICIT_TEMPLATE_VAR);
        });
        var directives = [];
        collection_1.ListWrapper.forEachWithIndex(ast.directives, function (directiveAst, index) {
            directiveAst.visit(_this, new DirectiveContext(index, [], [], directives));
        });
        this.result.push(this.commandFactory.createEmbeddedTemplate(this.embeddedTemplateIndex, this._readAttrNameAndValues(directives, ast.attrs), variableNameAndValues, directives, isMerged, ast.ngContentIndex, childVisitor.result));
        this.transitiveNgContentCount += childVisitor.transitiveNgContentCount;
        this.embeddedTemplateIndex = childVisitor.embeddedTemplateIndex;
        return null;
    };
    CommandBuilderVisitor.prototype.visitElement = function (ast, context) {
        var _this = this;
        var component = ast.getComponent();
        var eventTargetAndNames = visitAndReturnContext(this, ast.outputs, []);
        var variableNameAndValues = [];
        if (lang_1.isBlank(component)) {
            ast.exportAsVars.forEach(function (varAst) {
                variableNameAndValues.push(varAst.name);
                variableNameAndValues.push(null);
            });
        }
        var directives = [];
        collection_1.ListWrapper.forEachWithIndex(ast.directives, function (directiveAst, index) {
            directiveAst.visit(_this, new DirectiveContext(index, eventTargetAndNames, variableNameAndValues, directives));
        });
        eventTargetAndNames = removeKeyValueArrayDuplicates(eventTargetAndNames);
        var attrNameAndValues = this._readAttrNameAndValues(directives, ast.attrs);
        if (lang_1.isPresent(component)) {
            this.result.push(this.commandFactory.createBeginComponent(ast.name, attrNameAndValues, eventTargetAndNames, variableNameAndValues, directives, component.template.encapsulation, ast.ngContentIndex));
            template_ast_1.templateVisitAll(this, ast.children);
            this.result.push(this.commandFactory.createEndComponent());
        }
        else {
            this.result.push(this.commandFactory.createBeginElement(ast.name, attrNameAndValues, eventTargetAndNames, variableNameAndValues, directives, ast.isBound(), ast.ngContentIndex));
            template_ast_1.templateVisitAll(this, ast.children);
            this.result.push(this.commandFactory.createEndElement());
        }
        return null;
    };
    CommandBuilderVisitor.prototype.visitVariable = function (ast, ctx) { return null; };
    CommandBuilderVisitor.prototype.visitAttr = function (ast, attrNameAndValues) {
        attrNameAndValues.push(ast.name);
        attrNameAndValues.push(ast.value);
        return null;
    };
    CommandBuilderVisitor.prototype.visitBoundText = function (ast, context) {
        this.result.push(this.commandFactory.createText(null, true, ast.ngContentIndex));
        return null;
    };
    CommandBuilderVisitor.prototype.visitText = function (ast, context) {
        this.result.push(this.commandFactory.createText(ast.value, false, ast.ngContentIndex));
        return null;
    };
    CommandBuilderVisitor.prototype.visitDirective = function (ast, ctx) {
        ctx.targetDirectives.push(ast.directive);
        template_ast_1.templateVisitAll(this, ast.hostEvents, ctx.eventTargetAndNames);
        ast.exportAsVars.forEach(function (varAst) {
            ctx.targetVariableNameAndValues.push(varAst.name);
            ctx.targetVariableNameAndValues.push(ctx.index);
        });
        return null;
    };
    CommandBuilderVisitor.prototype.visitEvent = function (ast, eventTargetAndNames) {
        eventTargetAndNames.push(ast.target);
        eventTargetAndNames.push(ast.name);
        return null;
    };
    CommandBuilderVisitor.prototype.visitDirectiveProperty = function (ast, context) { return null; };
    CommandBuilderVisitor.prototype.visitElementProperty = function (ast, context) { return null; };
    return CommandBuilderVisitor;
})();
function removeKeyValueArrayDuplicates(keyValueArray) {
    var knownPairs = new Set();
    var resultKeyValueArray = [];
    for (var i = 0; i < keyValueArray.length; i += 2) {
        var key = keyValueArray[i];
        var value = keyValueArray[i + 1];
        var pairId = key + ":" + value;
        if (!collection_1.SetWrapper.has(knownPairs, pairId)) {
            resultKeyValueArray.push(key);
            resultKeyValueArray.push(value);
            knownPairs.add(pairId);
        }
    }
    return resultKeyValueArray;
}
function keyValueArrayToMap(keyValueArr) {
    var data = {};
    for (var i = 0; i < keyValueArr.length; i += 2) {
        data[keyValueArr[i]] = keyValueArr[i + 1];
    }
    return data;
}
function mapToKeyValueArray(data) {
    var entryArray = [];
    collection_1.StringMapWrapper.forEach(data, function (value, name) { entryArray.push([name, value]); });
    // We need to sort to get a defined output order
    // for tests and for caching generated artifacts...
    collection_1.ListWrapper.sort(entryArray, function (entry1, entry2) { return lang_1.StringWrapper.compare(entry1[0], entry2[0]); });
    var keyValueArray = [];
    entryArray.forEach(function (entry) {
        keyValueArray.push(entry[0]);
        keyValueArray.push(entry[1]);
    });
    return keyValueArray;
}
function mergeAttributeValue(attrName, attrValue1, attrValue2) {
    if (attrName == CLASS_ATTR || attrName == STYLE_ATTR) {
        return attrValue1 + " " + attrValue2;
    }
    else {
        return attrValue2;
    }
}
var DirectiveContext = (function () {
    function DirectiveContext(index, eventTargetAndNames, targetVariableNameAndValues, targetDirectives) {
        this.index = index;
        this.eventTargetAndNames = eventTargetAndNames;
        this.targetVariableNameAndValues = targetVariableNameAndValues;
        this.targetDirectives = targetDirectives;
    }
    return DirectiveContext;
})();
var Expression = (function () {
    function Expression(value) {
        this.value = value;
    }
    return Expression;
})();
function escapeValue(value) {
    if (value instanceof Expression) {
        return value.value;
    }
    else if (lang_1.isString(value)) {
        return util_1.escapeSingleQuoteString(value);
    }
    else if (lang_1.isBlank(value)) {
        return 'null';
    }
    else {
        return "" + value;
    }
}
function codeGenArray(data) {
    var base = "[" + data.map(escapeValue).join(',') + "]";
    return lang_1.IS_DART ? "const " + base : base;
}
function codeGenDirectivesArray(directives) {
    var expressions = directives.map(function (directiveType) { return ("" + source_module_1.moduleRef(directiveType.type.moduleUrl) + directiveType.type.name); });
    var base = "[" + expressions.join(',') + "]";
    return lang_1.IS_DART ? "const " + base : base;
}
function codeGenViewEncapsulation(value) {
    if (lang_1.IS_DART) {
        return "" + exports.TEMPLATE_COMMANDS_MODULE_REF + value;
    }
    else {
        return "" + value;
    }
}
//# sourceMappingURL=data:application/json;base64,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