'use strict';var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") return Reflect.decorate(decorators, target, key, desc);
    switch (arguments.length) {
        case 2: return decorators.reduceRight(function(o, d) { return (d && d(o)) || o; }, target);
        case 3: return decorators.reduceRight(function(o, d) { return (d && d(target, key)), void 0; }, void 0);
        case 4: return decorators.reduceRight(function(o, d) { return (d && d(target, key, o)) || o; }, desc);
    }
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var collection_1 = require('angular2/src/facade/collection');
var lang_1 = require('angular2/src/facade/lang');
var exceptions_1 = require('angular2/src/facade/exceptions');
var DefaultKeyValueDifferFactory = (function () {
    function DefaultKeyValueDifferFactory() {
    }
    DefaultKeyValueDifferFactory.prototype.supports = function (obj) { return obj instanceof Map || lang_1.isJsObject(obj); };
    DefaultKeyValueDifferFactory.prototype.create = function (cdRef) { return new DefaultKeyValueDiffer(); };
    DefaultKeyValueDifferFactory = __decorate([
        lang_1.CONST(), 
        __metadata('design:paramtypes', [])
    ], DefaultKeyValueDifferFactory);
    return DefaultKeyValueDifferFactory;
})();
exports.DefaultKeyValueDifferFactory = DefaultKeyValueDifferFactory;
var DefaultKeyValueDiffer = (function () {
    function DefaultKeyValueDiffer() {
        this._records = new Map();
        this._mapHead = null;
        this._previousMapHead = null;
        this._changesHead = null;
        this._changesTail = null;
        this._additionsHead = null;
        this._additionsTail = null;
        this._removalsHead = null;
        this._removalsTail = null;
    }
    Object.defineProperty(DefaultKeyValueDiffer.prototype, "isDirty", {
        get: function () {
            return this._additionsHead !== null || this._changesHead !== null ||
                this._removalsHead !== null;
        },
        enumerable: true,
        configurable: true
    });
    DefaultKeyValueDiffer.prototype.forEachItem = function (fn) {
        var record;
        for (record = this._mapHead; record !== null; record = record._next) {
            fn(record);
        }
    };
    DefaultKeyValueDiffer.prototype.forEachPreviousItem = function (fn) {
        var record;
        for (record = this._previousMapHead; record !== null; record = record._nextPrevious) {
            fn(record);
        }
    };
    DefaultKeyValueDiffer.prototype.forEachChangedItem = function (fn) {
        var record;
        for (record = this._changesHead; record !== null; record = record._nextChanged) {
            fn(record);
        }
    };
    DefaultKeyValueDiffer.prototype.forEachAddedItem = function (fn) {
        var record;
        for (record = this._additionsHead; record !== null; record = record._nextAdded) {
            fn(record);
        }
    };
    DefaultKeyValueDiffer.prototype.forEachRemovedItem = function (fn) {
        var record;
        for (record = this._removalsHead; record !== null; record = record._nextRemoved) {
            fn(record);
        }
    };
    DefaultKeyValueDiffer.prototype.diff = function (map) {
        if (lang_1.isBlank(map))
            map = collection_1.MapWrapper.createFromPairs([]);
        if (!(map instanceof Map || lang_1.isJsObject(map))) {
            throw new exceptions_1.BaseException("Error trying to diff '" + map + "'");
        }
        if (this.check(map)) {
            return this;
        }
        else {
            return null;
        }
    };
    DefaultKeyValueDiffer.prototype.onDestroy = function () { };
    DefaultKeyValueDiffer.prototype.check = function (map) {
        var _this = this;
        this._reset();
        var records = this._records;
        var oldSeqRecord = this._mapHead;
        var lastOldSeqRecord = null;
        var lastNewSeqRecord = null;
        var seqChanged = false;
        this._forEach(map, function (value, key) {
            var newSeqRecord;
            if (oldSeqRecord !== null && key === oldSeqRecord.key) {
                newSeqRecord = oldSeqRecord;
                if (!lang_1.looseIdentical(value, oldSeqRecord.currentValue)) {
                    oldSeqRecord.previousValue = oldSeqRecord.currentValue;
                    oldSeqRecord.currentValue = value;
                    _this._addToChanges(oldSeqRecord);
                }
            }
            else {
                seqChanged = true;
                if (oldSeqRecord !== null) {
                    oldSeqRecord._next = null;
                    _this._removeFromSeq(lastOldSeqRecord, oldSeqRecord);
                    _this._addToRemovals(oldSeqRecord);
                }
                if (records.has(key)) {
                    newSeqRecord = records.get(key);
                }
                else {
                    newSeqRecord = new KVChangeRecord(key);
                    records.set(key, newSeqRecord);
                    newSeqRecord.currentValue = value;
                    _this._addToAdditions(newSeqRecord);
                }
            }
            if (seqChanged) {
                if (_this._isInRemovals(newSeqRecord)) {
                    _this._removeFromRemovals(newSeqRecord);
                }
                if (lastNewSeqRecord == null) {
                    _this._mapHead = newSeqRecord;
                }
                else {
                    lastNewSeqRecord._next = newSeqRecord;
                }
            }
            lastOldSeqRecord = oldSeqRecord;
            lastNewSeqRecord = newSeqRecord;
            oldSeqRecord = oldSeqRecord === null ? null : oldSeqRecord._next;
        });
        this._truncate(lastOldSeqRecord, oldSeqRecord);
        return this.isDirty;
    };
    /** @internal */
    DefaultKeyValueDiffer.prototype._reset = function () {
        if (this.isDirty) {
            var record;
            // Record the state of the mapping
            for (record = this._previousMapHead = this._mapHead; record !== null; record = record._next) {
                record._nextPrevious = record._next;
            }
            for (record = this._changesHead; record !== null; record = record._nextChanged) {
                record.previousValue = record.currentValue;
            }
            for (record = this._additionsHead; record != null; record = record._nextAdded) {
                record.previousValue = record.currentValue;
            }
            // todo(vicb) once assert is supported
            // assert(() {
            //  var r = _changesHead;
            //  while (r != null) {
            //    var nextRecord = r._nextChanged;
            //    r._nextChanged = null;
            //    r = nextRecord;
            //  }
            //
            //  r = _additionsHead;
            //  while (r != null) {
            //    var nextRecord = r._nextAdded;
            //    r._nextAdded = null;
            //    r = nextRecord;
            //  }
            //
            //  r = _removalsHead;
            //  while (r != null) {
            //    var nextRecord = r._nextRemoved;
            //    r._nextRemoved = null;
            //    r = nextRecord;
            //  }
            //
            //  return true;
            //});
            this._changesHead = this._changesTail = null;
            this._additionsHead = this._additionsTail = null;
            this._removalsHead = this._removalsTail = null;
        }
    };
    /** @internal */
    DefaultKeyValueDiffer.prototype._truncate = function (lastRecord, record) {
        while (record !== null) {
            if (lastRecord === null) {
                this._mapHead = null;
            }
            else {
                lastRecord._next = null;
            }
            var nextRecord = record._next;
            // todo(vicb) assert
            // assert((() {
            //  record._next = null;
            //  return true;
            //}));
            this._addToRemovals(record);
            lastRecord = record;
            record = nextRecord;
        }
        for (var rec = this._removalsHead; rec !== null; rec = rec._nextRemoved) {
            rec.previousValue = rec.currentValue;
            rec.currentValue = null;
            this._records.delete(rec.key);
        }
    };
    /** @internal */
    DefaultKeyValueDiffer.prototype._isInRemovals = function (record) {
        return record === this._removalsHead || record._nextRemoved !== null ||
            record._prevRemoved !== null;
    };
    /** @internal */
    DefaultKeyValueDiffer.prototype._addToRemovals = function (record) {
        // todo(vicb) assert
        // assert(record._next == null);
        // assert(record._nextAdded == null);
        // assert(record._nextChanged == null);
        // assert(record._nextRemoved == null);
        // assert(record._prevRemoved == null);
        if (this._removalsHead === null) {
            this._removalsHead = this._removalsTail = record;
        }
        else {
            this._removalsTail._nextRemoved = record;
            record._prevRemoved = this._removalsTail;
            this._removalsTail = record;
        }
    };
    /** @internal */
    DefaultKeyValueDiffer.prototype._removeFromSeq = function (prev, record) {
        var next = record._next;
        if (prev === null) {
            this._mapHead = next;
        }
        else {
            prev._next = next;
        }
        // todo(vicb) assert
        // assert((() {
        //  record._next = null;
        //  return true;
        //})());
    };
    /** @internal */
    DefaultKeyValueDiffer.prototype._removeFromRemovals = function (record) {
        // todo(vicb) assert
        // assert(record._next == null);
        // assert(record._nextAdded == null);
        // assert(record._nextChanged == null);
        var prev = record._prevRemoved;
        var next = record._nextRemoved;
        if (prev === null) {
            this._removalsHead = next;
        }
        else {
            prev._nextRemoved = next;
        }
        if (next === null) {
            this._removalsTail = prev;
        }
        else {
            next._prevRemoved = prev;
        }
        record._prevRemoved = record._nextRemoved = null;
    };
    /** @internal */
    DefaultKeyValueDiffer.prototype._addToAdditions = function (record) {
        // todo(vicb): assert
        // assert(record._next == null);
        // assert(record._nextAdded == null);
        // assert(record._nextChanged == null);
        // assert(record._nextRemoved == null);
        // assert(record._prevRemoved == null);
        if (this._additionsHead === null) {
            this._additionsHead = this._additionsTail = record;
        }
        else {
            this._additionsTail._nextAdded = record;
            this._additionsTail = record;
        }
    };
    /** @internal */
    DefaultKeyValueDiffer.prototype._addToChanges = function (record) {
        // todo(vicb) assert
        // assert(record._nextAdded == null);
        // assert(record._nextChanged == null);
        // assert(record._nextRemoved == null);
        // assert(record._prevRemoved == null);
        if (this._changesHead === null) {
            this._changesHead = this._changesTail = record;
        }
        else {
            this._changesTail._nextChanged = record;
            this._changesTail = record;
        }
    };
    DefaultKeyValueDiffer.prototype.toString = function () {
        var items = [];
        var previous = [];
        var changes = [];
        var additions = [];
        var removals = [];
        var record;
        for (record = this._mapHead; record !== null; record = record._next) {
            items.push(lang_1.stringify(record));
        }
        for (record = this._previousMapHead; record !== null; record = record._nextPrevious) {
            previous.push(lang_1.stringify(record));
        }
        for (record = this._changesHead; record !== null; record = record._nextChanged) {
            changes.push(lang_1.stringify(record));
        }
        for (record = this._additionsHead; record !== null; record = record._nextAdded) {
            additions.push(lang_1.stringify(record));
        }
        for (record = this._removalsHead; record !== null; record = record._nextRemoved) {
            removals.push(lang_1.stringify(record));
        }
        return "map: " + items.join(', ') + "\n" + "previous: " + previous.join(', ') + "\n" +
            "additions: " + additions.join(', ') + "\n" + "changes: " + changes.join(', ') + "\n" +
            "removals: " + removals.join(', ') + "\n";
    };
    /** @internal */
    DefaultKeyValueDiffer.prototype._forEach = function (obj, fn) {
        if (obj instanceof Map) {
            obj.forEach(fn);
        }
        else {
            collection_1.StringMapWrapper.forEach(obj, fn);
        }
    };
    return DefaultKeyValueDiffer;
})();
exports.DefaultKeyValueDiffer = DefaultKeyValueDiffer;
var KVChangeRecord = (function () {
    function KVChangeRecord(key) {
        this.key = key;
        this.previousValue = null;
        this.currentValue = null;
        /** @internal */
        this._nextPrevious = null;
        /** @internal */
        this._next = null;
        /** @internal */
        this._nextAdded = null;
        /** @internal */
        this._nextRemoved = null;
        /** @internal */
        this._prevRemoved = null;
        /** @internal */
        this._nextChanged = null;
    }
    KVChangeRecord.prototype.toString = function () {
        return lang_1.looseIdentical(this.previousValue, this.currentValue) ?
            lang_1.stringify(this.key) :
            (lang_1.stringify(this.key) + '[' + lang_1.stringify(this.previousValue) + '->' +
                lang_1.stringify(this.currentValue) + ']');
    };
    return KVChangeRecord;
})();
exports.KVChangeRecord = KVChangeRecord;
//# sourceMappingURL=data:application/json;base64,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