'use strict';var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") return Reflect.decorate(decorators, target, key, desc);
    switch (arguments.length) {
        case 2: return decorators.reduceRight(function(o, d) { return (d && d(o)) || o; }, target);
        case 3: return decorators.reduceRight(function(o, d) { return (d && d(target, key)), void 0; }, void 0);
        case 4: return decorators.reduceRight(function(o, d) { return (d && d(target, key, o)) || o; }, desc);
    }
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var lang_1 = require('angular2/src/facade/lang');
var collection_1 = require('angular2/src/facade/collection');
var di_1 = require('angular2/src/core/di');
var view_listener_1 = require('angular2/src/core/linker/view_listener');
var dom_adapter_1 = require('angular2/src/platform/dom/dom_adapter');
var api_1 = require('angular2/src/core/render/api');
var debug_element_1 = require('angular2/src/core/debug/debug_element');
var NG_ID_PROPERTY = 'ngid';
var INSPECT_GLOBAL_NAME = 'ng.probe';
var NG_ID_SEPARATOR = '#';
// Need to keep the views in a global Map so that multiple angular apps are supported
var _allIdsByView = new collection_1.Map();
var _allViewsById = new collection_1.Map();
var _nextId = 0;
function _setElementId(element, indices) {
    if (lang_1.isPresent(element)) {
        dom_adapter_1.DOM.setData(element, NG_ID_PROPERTY, indices.join(NG_ID_SEPARATOR));
    }
}
function _getElementId(element) {
    var elId = dom_adapter_1.DOM.getData(element, NG_ID_PROPERTY);
    if (lang_1.isPresent(elId)) {
        return elId.split(NG_ID_SEPARATOR).map(function (partStr) { return lang_1.NumberWrapper.parseInt(partStr, 10); });
    }
    else {
        return null;
    }
}
function inspectNativeElement(element) {
    var elId = _getElementId(element);
    if (lang_1.isPresent(elId)) {
        var view = _allViewsById.get(elId[0]);
        if (lang_1.isPresent(view)) {
            return new debug_element_1.DebugElement_(view, elId[1]);
        }
    }
    return null;
}
exports.inspectNativeElement = inspectNativeElement;
var DebugElementViewListener = (function () {
    function DebugElementViewListener(_renderer) {
        this._renderer = _renderer;
        dom_adapter_1.DOM.setGlobalVar(INSPECT_GLOBAL_NAME, inspectNativeElement);
    }
    DebugElementViewListener.prototype.onViewCreated = function (view) {
        var viewId = _nextId++;
        _allViewsById.set(viewId, view);
        _allIdsByView.set(view, viewId);
        for (var i = 0; i < view.elementRefs.length; i++) {
            var el = view.elementRefs[i];
            _setElementId(this._renderer.getNativeElementSync(el), [viewId, i]);
        }
    };
    DebugElementViewListener.prototype.onViewDestroyed = function (view) {
        var viewId = _allIdsByView.get(view);
        _allIdsByView.delete(view);
        _allViewsById.delete(viewId);
    };
    DebugElementViewListener = __decorate([
        di_1.Injectable(), 
        __metadata('design:paramtypes', [api_1.Renderer])
    ], DebugElementViewListener);
    return DebugElementViewListener;
})();
exports.DebugElementViewListener = DebugElementViewListener;
exports.ELEMENT_PROBE_PROVIDERS = lang_1.CONST_EXPR([
    DebugElementViewListener,
    lang_1.CONST_EXPR(new di_1.Provider(view_listener_1.AppViewListener, { useExisting: DebugElementViewListener })),
]);
exports.ELEMENT_PROBE_BINDINGS = exports.ELEMENT_PROBE_PROVIDERS;
//# sourceMappingURL=data:application/json;base64,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