'use strict';var angular2_1 = require('angular2/angular2');
var COMPONENT_SELECTOR = /^[\w|-]*$/;
var SKEWER_CASE = /-(\w)/g;
var directiveResolver = new angular2_1.DirectiveResolver();
function getComponentInfo(type) {
    var resolvedMetadata = directiveResolver.resolve(type);
    var selector = resolvedMetadata.selector;
    if (!selector.match(COMPONENT_SELECTOR)) {
        throw new Error('Only selectors matching element names are supported, got: ' + selector);
    }
    var selector = selector.replace(SKEWER_CASE, function (all, letter) { return letter.toUpperCase(); });
    return {
        type: type,
        selector: selector,
        inputs: parseFields(resolvedMetadata.inputs),
        outputs: parseFields(resolvedMetadata.outputs)
    };
}
exports.getComponentInfo = getComponentInfo;
function parseFields(names) {
    var attrProps = [];
    if (names) {
        for (var i = 0; i < names.length; i++) {
            var parts = names[i].split(':');
            var prop = parts[0].trim();
            var attr = (parts[1] || parts[0]).trim();
            var capitalAttr = attr.charAt(0).toUpperCase() + attr.substr(1);
            attrProps.push({
                prop: prop,
                attr: attr,
                bracketAttr: "[" + attr + "]",
                parenAttr: "(" + attr + ")",
                bracketParenAttr: "[(" + attr + ")]",
                onAttr: "on" + capitalAttr,
                bindAttr: "bind" + capitalAttr,
                bindonAttr: "bindon" + capitalAttr
            });
        }
    }
    return attrProps;
}
exports.parseFields = parseFields;
//# sourceMappingURL=data:application/json;base64,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