'use strict';var __extends = (this && this.__extends) || function (d, b) {
    for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p];
    function __() { this.constructor = d; }
    d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
};
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") return Reflect.decorate(decorators, target, key, desc);
    switch (arguments.length) {
        case 2: return decorators.reduceRight(function(o, d) { return (d && d(o)) || o; }, target);
        case 3: return decorators.reduceRight(function(o, d) { return (d && d(target, key)), void 0; }, void 0);
        case 4: return decorators.reduceRight(function(o, d) { return (d && d(target, key, o)) || o; }, desc);
    }
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var __param = (this && this.__param) || function (paramIndex, decorator) {
    return function (target, key) { decorator(target, key, paramIndex); }
};
var di_1 = require("angular2/src/core/di");
var api_1 = require("angular2/src/core/render/api");
var api_2 = require("angular2/src/web_workers/shared/api");
var collection_1 = require("angular2/src/facade/collection");
var RenderViewWithFragmentsStore = (function () {
    function RenderViewWithFragmentsStore(onWebWorker) {
        this._nextIndex = 0;
        this._onWebWorker = onWebWorker;
        this._lookupByIndex = new Map();
        this._lookupByView = new Map();
        this._viewFragments = new Map();
    }
    RenderViewWithFragmentsStore.prototype.allocate = function (fragmentCount) {
        var initialIndex = this._nextIndex;
        var viewRef = new WebWorkerRenderViewRef(this._nextIndex++);
        var fragmentRefs = collection_1.ListWrapper.createGrowableSize(fragmentCount);
        for (var i = 0; i < fragmentCount; i++) {
            fragmentRefs[i] = new WebWorkerRenderFragmentRef(this._nextIndex++);
        }
        var renderViewWithFragments = new api_1.RenderViewWithFragments(viewRef, fragmentRefs);
        this.store(renderViewWithFragments, initialIndex);
        return renderViewWithFragments;
    };
    RenderViewWithFragmentsStore.prototype.store = function (view, startIndex) {
        var _this = this;
        this._lookupByIndex.set(startIndex, view.viewRef);
        this._lookupByView.set(view.viewRef, startIndex);
        startIndex++;
        view.fragmentRefs.forEach(function (ref) {
            _this._lookupByIndex.set(startIndex, ref);
            _this._lookupByView.set(ref, startIndex);
            startIndex++;
        });
        this._viewFragments.set(view.viewRef, view.fragmentRefs);
    };
    RenderViewWithFragmentsStore.prototype.remove = function (view) {
        var _this = this;
        this._removeRef(view);
        var fragments = this._viewFragments.get(view);
        fragments.forEach(function (fragment) { _this._removeRef(fragment); });
        this._viewFragments.delete(view);
    };
    RenderViewWithFragmentsStore.prototype._removeRef = function (ref) {
        var index = this._lookupByView.get(ref);
        this._lookupByView.delete(ref);
        this._lookupByIndex.delete(index);
    };
    RenderViewWithFragmentsStore.prototype.serializeRenderViewRef = function (viewRef) {
        return this._serializeRenderFragmentOrViewRef(viewRef);
    };
    RenderViewWithFragmentsStore.prototype.serializeRenderFragmentRef = function (fragmentRef) {
        return this._serializeRenderFragmentOrViewRef(fragmentRef);
    };
    RenderViewWithFragmentsStore.prototype.deserializeRenderViewRef = function (ref) {
        if (ref == null) {
            return null;
        }
        return this._retrieve(ref);
    };
    RenderViewWithFragmentsStore.prototype.deserializeRenderFragmentRef = function (ref) {
        if (ref == null) {
            return null;
        }
        return this._retrieve(ref);
    };
    RenderViewWithFragmentsStore.prototype._retrieve = function (ref) {
        if (ref == null) {
            return null;
        }
        if (!this._lookupByIndex.has(ref)) {
            return null;
        }
        return this._lookupByIndex.get(ref);
    };
    RenderViewWithFragmentsStore.prototype._serializeRenderFragmentOrViewRef = function (ref) {
        if (ref == null) {
            return null;
        }
        if (this._onWebWorker) {
            return ref.serialize();
        }
        else {
            return this._lookupByView.get(ref);
        }
    };
    RenderViewWithFragmentsStore.prototype.serializeViewWithFragments = function (view) {
        var _this = this;
        if (view == null) {
            return null;
        }
        if (this._onWebWorker) {
            return {
                'viewRef': view.viewRef.serialize(),
                'fragmentRefs': view.fragmentRefs.map(function (val) { return val.serialize(); })
            };
        }
        else {
            return {
                'viewRef': this._lookupByView.get(view.viewRef),
                'fragmentRefs': view.fragmentRefs.map(function (val) { return _this._lookupByView.get(val); })
            };
        }
    };
    RenderViewWithFragmentsStore.prototype.deserializeViewWithFragments = function (obj) {
        var _this = this;
        if (obj == null) {
            return null;
        }
        var viewRef = this.deserializeRenderViewRef(obj['viewRef']);
        var fragments = obj['fragmentRefs'].map(function (val) { return _this.deserializeRenderFragmentRef(val); });
        return new api_1.RenderViewWithFragments(viewRef, fragments);
    };
    RenderViewWithFragmentsStore = __decorate([
        di_1.Injectable(),
        __param(0, di_1.Inject(api_2.ON_WEB_WORKER)), 
        __metadata('design:paramtypes', [Object])
    ], RenderViewWithFragmentsStore);
    return RenderViewWithFragmentsStore;
})();
exports.RenderViewWithFragmentsStore = RenderViewWithFragmentsStore;
var WebWorkerRenderViewRef = (function (_super) {
    __extends(WebWorkerRenderViewRef, _super);
    function WebWorkerRenderViewRef(refNumber) {
        _super.call(this);
        this.refNumber = refNumber;
    }
    WebWorkerRenderViewRef.prototype.serialize = function () { return this.refNumber; };
    WebWorkerRenderViewRef.deserialize = function (ref) {
        return new WebWorkerRenderViewRef(ref);
    };
    return WebWorkerRenderViewRef;
})(api_1.RenderViewRef);
exports.WebWorkerRenderViewRef = WebWorkerRenderViewRef;
var WebWorkerRenderFragmentRef = (function (_super) {
    __extends(WebWorkerRenderFragmentRef, _super);
    function WebWorkerRenderFragmentRef(refNumber) {
        _super.call(this);
        this.refNumber = refNumber;
    }
    WebWorkerRenderFragmentRef.prototype.serialize = function () { return this.refNumber; };
    WebWorkerRenderFragmentRef.deserialize = function (ref) {
        return new WebWorkerRenderFragmentRef(ref);
    };
    return WebWorkerRenderFragmentRef;
})(api_1.RenderFragmentRef);
exports.WebWorkerRenderFragmentRef = WebWorkerRenderFragmentRef;
//# sourceMappingURL=data:application/json;base64,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