/**
 * @module
 * @description
 * Starting point to import all public core APIs.
 */
export * from './src/core/metadata';
export * from './src/core/util';
export * from './src/core/dev_mode';
export * from './src/core/di';
export * from './src/facade/facade';
export { platform, createNgZone, PlatformRef, ApplicationRef } from './src/core/application_ref';
export { APP_ID, APP_COMPONENT, APP_INITIALIZER, PACKAGE_ROOT_URL, PLATFORM_INITIALIZER } from './src/core/application_tokens';
export * from './src/core/zone';
export * from './src/core/render';
export * from './src/core/linker';
export { DebugElement, Scope, inspectElement, asNativeElements } from './src/core/debug/debug_element';
export * from './src/core/testability/testability';
export * from './src/core/change_detection';
export * from './src/core/platform_directives_and_pipes';
export * from './src/core/platform_common_providers';
export * from './src/core/application_common_providers';
export * from './src/core/reflection/reflection';
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiY29yZS5qcyIsInNvdXJjZVJvb3QiOiIiLCJzb3VyY2VzIjpbImFuZ3VsYXIyL2NvcmUudHMiXSwibmFtZXMiOltdLCJtYXBwaW5ncyI6IkFBQUE7Ozs7R0FJRztBQUNILGNBQWMscUJBQXFCLENBQUM7QUFDcEMsY0FBYyxpQkFBaUIsQ0FBQztBQUNoQyxjQUFjLHFCQUFxQixDQUFDO0FBQ3BDLGNBQWMsZUFBZSxDQUFDO0FBQzlCLGNBQWMscUJBQXFCLENBQUM7QUFDcEMsU0FBUSxRQUFRLEVBQUUsWUFBWSxFQUFFLFdBQVcsRUFBRSxjQUFjLFFBQU8sNEJBQTRCLENBQUM7QUFDL0YsU0FDRSxNQUFNLEVBQ04sYUFBYSxFQUNiLGVBQWUsRUFDZixnQkFBZ0IsRUFDaEIsb0JBQW9CLFFBQ2YsK0JBQStCLENBQUM7QUFDdkMsY0FBYyxpQkFBaUIsQ0FBQztBQUNoQyxjQUFjLG1CQUFtQixDQUFDO0FBQ2xDLGNBQWMsbUJBQW1CLENBQUM7QUFDbEMsU0FDRSxZQUFZLEVBQ1osS0FBSyxFQUNMLGNBQWMsRUFDZCxnQkFBZ0IsUUFDWCxnQ0FBZ0MsQ0FBQztBQUN4QyxjQUFjLG9DQUFvQyxDQUFDO0FBQ25ELGNBQWMsNkJBQTZCLENBQUM7QUFDNUMsY0FBYywwQ0FBMEMsQ0FBQztBQUN6RCxjQUFjLHNDQUFzQyxDQUFDO0FBQ3JELGNBQWMseUNBQXlDLENBQUM7QUFDeEQsY0FBYyxrQ0FBa0MsQ0FBQyIsInNvdXJjZXNDb250ZW50IjpbIi8qKlxuICogQG1vZHVsZVxuICogQGRlc2NyaXB0aW9uXG4gKiBTdGFydGluZyBwb2ludCB0byBpbXBvcnQgYWxsIHB1YmxpYyBjb3JlIEFQSXMuXG4gKi9cbmV4cG9ydCAqIGZyb20gJy4vc3JjL2NvcmUvbWV0YWRhdGEnO1xuZXhwb3J0ICogZnJvbSAnLi9zcmMvY29yZS91dGlsJztcbmV4cG9ydCAqIGZyb20gJy4vc3JjL2NvcmUvZGV2X21vZGUnO1xuZXhwb3J0ICogZnJvbSAnLi9zcmMvY29yZS9kaSc7XG5leHBvcnQgKiBmcm9tICcuL3NyYy9mYWNhZGUvZmFjYWRlJztcbmV4cG9ydCB7cGxhdGZvcm0sIGNyZWF0ZU5nWm9uZSwgUGxhdGZvcm1SZWYsIEFwcGxpY2F0aW9uUmVmfSBmcm9tICcuL3NyYy9jb3JlL2FwcGxpY2F0aW9uX3JlZic7XG5leHBvcnQge1xuICBBUFBfSUQsXG4gIEFQUF9DT01QT05FTlQsXG4gIEFQUF9JTklUSUFMSVpFUixcbiAgUEFDS0FHRV9ST09UX1VSTCxcbiAgUExBVEZPUk1fSU5JVElBTElaRVJcbn0gZnJvbSAnLi9zcmMvY29yZS9hcHBsaWNhdGlvbl90b2tlbnMnO1xuZXhwb3J0ICogZnJvbSAnLi9zcmMvY29yZS96b25lJztcbmV4cG9ydCAqIGZyb20gJy4vc3JjL2NvcmUvcmVuZGVyJztcbmV4cG9ydCAqIGZyb20gJy4vc3JjL2NvcmUvbGlua2VyJztcbmV4cG9ydCB7XG4gIERlYnVnRWxlbWVudCxcbiAgU2NvcGUsXG4gIGluc3BlY3RFbGVtZW50LFxuICBhc05hdGl2ZUVsZW1lbnRzXG59IGZyb20gJy4vc3JjL2NvcmUvZGVidWcvZGVidWdfZWxlbWVudCc7XG5leHBvcnQgKiBmcm9tICcuL3NyYy9jb3JlL3Rlc3RhYmlsaXR5L3Rlc3RhYmlsaXR5JztcbmV4cG9ydCAqIGZyb20gJy4vc3JjL2NvcmUvY2hhbmdlX2RldGVjdGlvbic7XG5leHBvcnQgKiBmcm9tICcuL3NyYy9jb3JlL3BsYXRmb3JtX2RpcmVjdGl2ZXNfYW5kX3BpcGVzJztcbmV4cG9ydCAqIGZyb20gJy4vc3JjL2NvcmUvcGxhdGZvcm1fY29tbW9uX3Byb3ZpZGVycyc7XG5leHBvcnQgKiBmcm9tICcuL3NyYy9jb3JlL2FwcGxpY2F0aW9uX2NvbW1vbl9wcm92aWRlcnMnO1xuZXhwb3J0ICogZnJvbSAnLi9zcmMvY29yZS9yZWZsZWN0aW9uL3JlZmxlY3Rpb24nO1xuIl19