var globalScope;
if (typeof window === 'undefined') {
    if (typeof WorkerGlobalScope !== 'undefined' && self instanceof WorkerGlobalScope) {
        // TODO: Replace any with WorkerGlobalScope from lib.webworker.d.ts #3492
        globalScope = self;
    }
    else {
        globalScope = global;
    }
}
else {
    globalScope = window;
}
;
export const IS_DART = false;
// Need to declare a new variable for global here since TypeScript
// exports the original value of the symbol.
var _global = globalScope;
export { _global as global };
export var Type = Function;
export function getTypeNameForDebugging(type) {
    return type['name'];
}
export var Math = _global.Math;
export var Date = _global.Date;
var _devMode = !!_global.angularDevMode;
var _devModeLocked = false;
export function lockDevMode() {
    _devModeLocked = true;
}
/**
 * Enable Angular's development mode, which turns on assertions and other
 * checks within the framework.
 *
 * One important assertion this enables verifies that a change detection pass
 * does not result in additional changes to any bindings (also known as
 * unidirectional data flow).
 *
 * {@example core/ts/dev_mode/dev_mode_example.ts region='enableDevMode'}
 */
export function enableDevMode() {
    // TODO(alxhub): Refactor out of facade/lang as per issue #5157.
    if (_devModeLocked) {
        // Cannot use BaseException as that ends up importing from facade/lang.
        throw 'Cannot enable dev mode after platform setup.';
    }
    _devMode = true;
}
export function assertionsEnabled() {
    return _devMode;
}
// TODO: remove calls to assert in production environment
// Note: Can't just export this and import in in other files
// as `assert` is a reserved keyword in Dart
_global.assert = function assert(condition) {
    // TODO: to be fixed properly via #2830, noop for now
};
// This function is needed only to properly support Dart's const expressions
// see https://github.com/angular/ts2dart/pull/151 for more info
export function CONST_EXPR(expr) {
    return expr;
}
export function CONST() {
    return (target) => target;
}
export function isPresent(obj) {
    return obj !== undefined && obj !== null;
}
export function isBlank(obj) {
    return obj === undefined || obj === null;
}
export function isString(obj) {
    return typeof obj === "string";
}
export function isFunction(obj) {
    return typeof obj === "function";
}
export function isType(obj) {
    return isFunction(obj);
}
export function isStringMap(obj) {
    return typeof obj === 'object' && obj !== null;
}
export function isPromise(obj) {
    return obj instanceof _global.Promise;
}
export function isArray(obj) {
    return Array.isArray(obj);
}
export function isNumber(obj) {
    return typeof obj === 'number';
}
export function isDate(obj) {
    return obj instanceof Date && !isNaN(obj.valueOf());
}
export function noop() { }
export function stringify(token) {
    if (typeof token === 'string') {
        return token;
    }
    if (token === undefined || token === null) {
        return '' + token;
    }
    if (token.name) {
        return token.name;
    }
    var res = token.toString();
    var newLineIndex = res.indexOf("\n");
    return (newLineIndex === -1) ? res : res.substring(0, newLineIndex);
}
// serialize / deserialize enum exist only for consistency with dart API
// enums in typescript don't need to be serialized
export function serializeEnum(val) {
    return val;
}
export function deserializeEnum(val, values) {
    return val;
}
export class StringWrapper {
    static fromCharCode(code) { return String.fromCharCode(code); }
    static charCodeAt(s, index) { return s.charCodeAt(index); }
    static split(s, regExp) { return s.split(regExp); }
    static equals(s, s2) { return s === s2; }
    static stripLeft(s, charVal) {
        if (s && s.length) {
            var pos = 0;
            for (var i = 0; i < s.length; i++) {
                if (s[i] != charVal)
                    break;
                pos++;
            }
            s = s.substring(pos);
        }
        return s;
    }
    static stripRight(s, charVal) {
        if (s && s.length) {
            var pos = s.length;
            for (var i = s.length - 1; i >= 0; i--) {
                if (s[i] != charVal)
                    break;
                pos--;
            }
            s = s.substring(0, pos);
        }
        return s;
    }
    static replace(s, from, replace) {
        return s.replace(from, replace);
    }
    static replaceAll(s, from, replace) {
        return s.replace(from, replace);
    }
    static slice(s, from = 0, to = null) {
        return s.slice(from, to === null ? undefined : to);
    }
    static replaceAllMapped(s, from, cb) {
        return s.replace(from, function (...matches) {
            // Remove offset & string from the result array
            matches.splice(-2, 2);
            // The callback receives match, p1, ..., pn
            return cb(matches);
        });
    }
    static contains(s, substr) { return s.indexOf(substr) != -1; }
    static compare(a, b) {
        if (a < b) {
            return -1;
        }
        else if (a > b) {
            return 1;
        }
        else {
            return 0;
        }
    }
}
export class StringJoiner {
    constructor(parts = []) {
        this.parts = parts;
    }
    add(part) { this.parts.push(part); }
    toString() { return this.parts.join(""); }
}
export class NumberParseError extends Error {
    constructor(message) {
        super();
        this.message = message;
    }
    toString() { return this.message; }
}
export class NumberWrapper {
    static toFixed(n, fractionDigits) { return n.toFixed(fractionDigits); }
    static equal(a, b) { return a === b; }
    static parseIntAutoRadix(text) {
        var result = parseInt(text);
        if (isNaN(result)) {
            throw new NumberParseError("Invalid integer literal when parsing " + text);
        }
        return result;
    }
    static parseInt(text, radix) {
        if (radix == 10) {
            if (/^(\-|\+)?[0-9]+$/.test(text)) {
                return parseInt(text, radix);
            }
        }
        else if (radix == 16) {
            if (/^(\-|\+)?[0-9ABCDEFabcdef]+$/.test(text)) {
                return parseInt(text, radix);
            }
        }
        else {
            var result = parseInt(text, radix);
            if (!isNaN(result)) {
                return result;
            }
        }
        throw new NumberParseError("Invalid integer literal when parsing " + text + " in base " +
            radix);
    }
    // TODO: NaN is a valid literal but is returned by parseFloat to indicate an error.
    static parseFloat(text) { return parseFloat(text); }
    static get NaN() { return NaN; }
    static isNaN(value) { return isNaN(value); }
    static isInteger(value) { return Number.isInteger(value); }
}
export var RegExp = _global.RegExp;
export class RegExpWrapper {
    static create(regExpStr, flags = '') {
        flags = flags.replace(/g/g, '');
        return new _global.RegExp(regExpStr, flags + 'g');
    }
    static firstMatch(regExp, input) {
        // Reset multimatch regex state
        regExp.lastIndex = 0;
        return regExp.exec(input);
    }
    static test(regExp, input) {
        regExp.lastIndex = 0;
        return regExp.test(input);
    }
    static matcher(regExp, input) {
        // Reset regex state for the case
        // someone did not loop over all matches
        // last time.
        regExp.lastIndex = 0;
        return { re: regExp, input: input };
    }
}
export class RegExpMatcherWrapper {
    static next(matcher) {
        return matcher.re.exec(matcher.input);
    }
}
export class FunctionWrapper {
    static apply(fn, posArgs) { return fn.apply(null, posArgs); }
}
// JS has NaN !== NaN
export function looseIdentical(a, b) {
    return a === b || typeof a === "number" && typeof b === "number" && isNaN(a) && isNaN(b);
}
// JS considers NaN is the same as NaN for map Key (while NaN !== NaN otherwise)
// see https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Map
export function getMapKey(value) {
    return value;
}
export function normalizeBlank(obj) {
    return isBlank(obj) ? null : obj;
}
export function normalizeBool(obj) {
    return isBlank(obj) ? false : obj;
}
export function isJsObject(o) {
    return o !== null && (typeof o === "function" || typeof o === "object");
}
export function print(obj) {
    console.log(obj);
}
// Can't be all uppercase as our transpiler would think it is a special directive...
export class Json {
    static parse(s) { return _global.JSON.parse(s); }
    static stringify(data) {
        // Dart doesn't take 3 arguments
        return _global.JSON.stringify(data, null, 2);
    }
}
export class DateWrapper {
    static create(year, month = 1, day = 1, hour = 0, minutes = 0, seconds = 0, milliseconds = 0) {
        return new Date(year, month - 1, day, hour, minutes, seconds, milliseconds);
    }
    static fromISOString(str) { return new Date(str); }
    static fromMillis(ms) { return new Date(ms); }
    static toMillis(date) { return date.getTime(); }
    static now() { return new Date(); }
    static toJson(date) { return date.toJSON(); }
}
export function setValueOnPath(global, path, value) {
    var parts = path.split('.');
    var obj = global;
    while (parts.length > 1) {
        var name = parts.shift();
        if (obj.hasOwnProperty(name) && isPresent(obj[name])) {
            obj = obj[name];
        }
        else {
            obj = obj[name] = {};
        }
    }
    if (obj === undefined || obj === null) {
        obj = {};
    }
    obj[parts.shift()] = value;
}
var _symbolIterator = null;
export function getSymbolIterator() {
    if (isBlank(_symbolIterator)) {
        if (isPresent(Symbol) && isPresent(Symbol.iterator)) {
            _symbolIterator = Symbol.iterator;
        }
        else {
            // es6-shim specific logic
            var keys = Object.getOwnPropertyNames(Map.prototype);
            for (var i = 0; i < keys.length; ++i) {
                var key = keys[i];
                if (key !== 'entries' && key !== 'size' &&
                    Map.prototype[key] === Map.prototype['entries']) {
                    _symbolIterator = key;
                }
            }
        }
    }
    return _symbolIterator;
}
//# sourceMappingURL=data:application/json;base64,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