'use strict';var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var lang_1 = require('angular2/src/facade/lang');
var collection_1 = require('angular2/src/facade/collection');
var template_commands_1 = require('angular2/src/core/linker/template_commands');
var template_ast_1 = require('./template_ast');
var source_module_1 = require('./source_module');
var util_1 = require('./util');
var di_1 = require('angular2/src/core/di');
exports.TEMPLATE_COMMANDS_MODULE_REF = source_module_1.moduleRef("package:angular2/src/core/linker/template_commands" + util_1.MODULE_SUFFIX);
var IMPLICIT_TEMPLATE_VAR = '\$implicit';
var CLASS_ATTR = 'class';
var STYLE_ATTR = 'style';
var CommandCompiler = (function () {
    function CommandCompiler() {
    }
    CommandCompiler.prototype.compileComponentRuntime = function (component, template, changeDetectorFactories, componentTemplateFactory) {
        var visitor = new CommandBuilderVisitor(new RuntimeCommandFactory(component, componentTemplateFactory, changeDetectorFactories), 0);
        template_ast_1.templateVisitAll(visitor, template);
        return visitor.result;
    };
    CommandCompiler.prototype.compileComponentCodeGen = function (component, template, changeDetectorFactoryExpressions, componentTemplateFactory) {
        var visitor = new CommandBuilderVisitor(new CodegenCommandFactory(component, componentTemplateFactory, changeDetectorFactoryExpressions), 0);
        template_ast_1.templateVisitAll(visitor, template);
        return new source_module_1.SourceExpression([], codeGenArray(visitor.result));
    };
    CommandCompiler = __decorate([
        di_1.Injectable(), 
        __metadata('design:paramtypes', [])
    ], CommandCompiler);
    return CommandCompiler;
})();
exports.CommandCompiler = CommandCompiler;
var RuntimeCommandFactory = (function () {
    function RuntimeCommandFactory(component, componentTemplateFactory, changeDetectorFactories) {
        this.component = component;
        this.componentTemplateFactory = componentTemplateFactory;
        this.changeDetectorFactories = changeDetectorFactories;
    }
    RuntimeCommandFactory.prototype._mapDirectives = function (directives) {
        return directives.map(function (directive) { return directive.type.runtime; });
    };
    RuntimeCommandFactory.prototype.createText = function (value, isBound, ngContentIndex) {
        return new template_commands_1.TextCmd(value, isBound, ngContentIndex);
    };
    RuntimeCommandFactory.prototype.createNgContent = function (index, ngContentIndex) {
        return new template_commands_1.NgContentCmd(index, ngContentIndex);
    };
    RuntimeCommandFactory.prototype.createBeginElement = function (name, attrNameAndValues, eventTargetAndNames, variableNameAndValues, directives, isBound, ngContentIndex) {
        return new template_commands_1.BeginElementCmd(name, attrNameAndValues, eventTargetAndNames, variableNameAndValues, this._mapDirectives(directives), isBound, ngContentIndex);
    };
    RuntimeCommandFactory.prototype.createEndElement = function () { return new template_commands_1.EndElementCmd(); };
    RuntimeCommandFactory.prototype.createBeginComponent = function (name, attrNameAndValues, eventTargetAndNames, variableNameAndValues, directives, encapsulation, ngContentIndex) {
        var nestedTemplateAccessor = this.componentTemplateFactory(directives[0]);
        return new template_commands_1.BeginComponentCmd(name, attrNameAndValues, eventTargetAndNames, variableNameAndValues, this._mapDirectives(directives), encapsulation, ngContentIndex, nestedTemplateAccessor);
    };
    RuntimeCommandFactory.prototype.createEndComponent = function () { return new template_commands_1.EndComponentCmd(); };
    RuntimeCommandFactory.prototype.createEmbeddedTemplate = function (embeddedTemplateIndex, attrNameAndValues, variableNameAndValues, directives, isMerged, ngContentIndex, children) {
        return new template_commands_1.EmbeddedTemplateCmd(attrNameAndValues, variableNameAndValues, this._mapDirectives(directives), isMerged, ngContentIndex, this.changeDetectorFactories[embeddedTemplateIndex], children);
    };
    return RuntimeCommandFactory;
})();
var CodegenCommandFactory = (function () {
    function CodegenCommandFactory(component, componentTemplateFactory, changeDetectorFactoryExpressions) {
        this.component = component;
        this.componentTemplateFactory = componentTemplateFactory;
        this.changeDetectorFactoryExpressions = changeDetectorFactoryExpressions;
    }
    CodegenCommandFactory.prototype.createText = function (value, isBound, ngContentIndex) {
        return new Expression(util_1.codeGenConstConstructorCall(exports.TEMPLATE_COMMANDS_MODULE_REF + 'TextCmd') + "(" + util_1.escapeSingleQuoteString(value) + ", " + isBound + ", " + ngContentIndex + ")");
    };
    CodegenCommandFactory.prototype.createNgContent = function (index, ngContentIndex) {
        return new Expression(util_1.codeGenConstConstructorCall(exports.TEMPLATE_COMMANDS_MODULE_REF + 'NgContentCmd') + "(" + index + ", " + ngContentIndex + ")");
    };
    CodegenCommandFactory.prototype.createBeginElement = function (name, attrNameAndValues, eventTargetAndNames, variableNameAndValues, directives, isBound, ngContentIndex) {
        var attrsExpression = codeGenArray(attrNameAndValues);
        return new Expression((util_1.codeGenConstConstructorCall(exports.TEMPLATE_COMMANDS_MODULE_REF + 'BeginElementCmd') + "(" + util_1.escapeSingleQuoteString(name) + ", " + attrsExpression + ", ") +
            (codeGenArray(eventTargetAndNames) + ", " + codeGenArray(variableNameAndValues) + ", " + codeGenDirectivesArray(directives) + ", " + isBound + ", " + ngContentIndex + ")"));
    };
    CodegenCommandFactory.prototype.createEndElement = function () {
        return new Expression(util_1.codeGenConstConstructorCall(exports.TEMPLATE_COMMANDS_MODULE_REF + 'EndElementCmd') + "()");
    };
    CodegenCommandFactory.prototype.createBeginComponent = function (name, attrNameAndValues, eventTargetAndNames, variableNameAndValues, directives, encapsulation, ngContentIndex) {
        var attrsExpression = codeGenArray(attrNameAndValues);
        return new Expression((util_1.codeGenConstConstructorCall(exports.TEMPLATE_COMMANDS_MODULE_REF + 'BeginComponentCmd') + "(" + util_1.escapeSingleQuoteString(name) + ", " + attrsExpression + ", ") +
            (codeGenArray(eventTargetAndNames) + ", " + codeGenArray(variableNameAndValues) + ", " + codeGenDirectivesArray(directives) + ", " + codeGenViewEncapsulation(encapsulation) + ", " + ngContentIndex + ", " + this.componentTemplateFactory(directives[0]) + ")"));
    };
    CodegenCommandFactory.prototype.createEndComponent = function () {
        return new Expression(util_1.codeGenConstConstructorCall(exports.TEMPLATE_COMMANDS_MODULE_REF + 'EndComponentCmd') + "()");
    };
    CodegenCommandFactory.prototype.createEmbeddedTemplate = function (embeddedTemplateIndex, attrNameAndValues, variableNameAndValues, directives, isMerged, ngContentIndex, children) {
        return new Expression((util_1.codeGenConstConstructorCall(exports.TEMPLATE_COMMANDS_MODULE_REF + 'EmbeddedTemplateCmd') + "(" + codeGenArray(attrNameAndValues) + ", " + codeGenArray(variableNameAndValues) + ", ") +
            (codeGenDirectivesArray(directives) + ", " + isMerged + ", " + ngContentIndex + ", " + this.changeDetectorFactoryExpressions[embeddedTemplateIndex] + ", " + codeGenArray(children) + ")"));
    };
    return CodegenCommandFactory;
})();
function visitAndReturnContext(visitor, asts, context) {
    template_ast_1.templateVisitAll(visitor, asts, context);
    return context;
}
var CommandBuilderVisitor = (function () {
    function CommandBuilderVisitor(commandFactory, embeddedTemplateIndex) {
        this.commandFactory = commandFactory;
        this.embeddedTemplateIndex = embeddedTemplateIndex;
        this.result = [];
        this.transitiveNgContentCount = 0;
    }
    CommandBuilderVisitor.prototype._readAttrNameAndValues = function (directives, attrAsts) {
        var attrs = keyValueArrayToMap(visitAndReturnContext(this, attrAsts, []));
        directives.forEach(function (directiveMeta) {
            collection_1.StringMapWrapper.forEach(directiveMeta.hostAttributes, function (value, name) {
                var prevValue = attrs[name];
                attrs[name] = lang_1.isPresent(prevValue) ? mergeAttributeValue(name, prevValue, value) : value;
            });
        });
        return mapToKeyValueArray(attrs);
    };
    CommandBuilderVisitor.prototype.visitNgContent = function (ast, context) {
        this.transitiveNgContentCount++;
        this.result.push(this.commandFactory.createNgContent(ast.index, ast.ngContentIndex));
        return null;
    };
    CommandBuilderVisitor.prototype.visitEmbeddedTemplate = function (ast, context) {
        var _this = this;
        this.embeddedTemplateIndex++;
        var childVisitor = new CommandBuilderVisitor(this.commandFactory, this.embeddedTemplateIndex);
        template_ast_1.templateVisitAll(childVisitor, ast.children);
        var isMerged = childVisitor.transitiveNgContentCount > 0;
        var variableNameAndValues = [];
        ast.vars.forEach(function (varAst) {
            variableNameAndValues.push(varAst.name);
            variableNameAndValues.push(varAst.value.length > 0 ? varAst.value : IMPLICIT_TEMPLATE_VAR);
        });
        var directives = [];
        collection_1.ListWrapper.forEachWithIndex(ast.directives, function (directiveAst, index) {
            directiveAst.visit(_this, new DirectiveContext(index, [], [], directives));
        });
        this.result.push(this.commandFactory.createEmbeddedTemplate(this.embeddedTemplateIndex, this._readAttrNameAndValues(directives, ast.attrs), variableNameAndValues, directives, isMerged, ast.ngContentIndex, childVisitor.result));
        this.transitiveNgContentCount += childVisitor.transitiveNgContentCount;
        this.embeddedTemplateIndex = childVisitor.embeddedTemplateIndex;
        return null;
    };
    CommandBuilderVisitor.prototype.visitElement = function (ast, context) {
        var _this = this;
        var component = ast.getComponent();
        var eventTargetAndNames = visitAndReturnContext(this, ast.outputs, []);
        var variableNameAndValues = [];
        if (lang_1.isBlank(component)) {
            ast.exportAsVars.forEach(function (varAst) {
                variableNameAndValues.push(varAst.name);
                variableNameAndValues.push(null);
            });
        }
        var directives = [];
        collection_1.ListWrapper.forEachWithIndex(ast.directives, function (directiveAst, index) {
            directiveAst.visit(_this, new DirectiveContext(index, eventTargetAndNames, variableNameAndValues, directives));
        });
        eventTargetAndNames = removeKeyValueArrayDuplicates(eventTargetAndNames);
        var attrNameAndValues = this._readAttrNameAndValues(directives, ast.attrs);
        if (lang_1.isPresent(component)) {
            this.result.push(this.commandFactory.createBeginComponent(ast.name, attrNameAndValues, eventTargetAndNames, variableNameAndValues, directives, component.template.encapsulation, ast.ngContentIndex));
            template_ast_1.templateVisitAll(this, ast.children);
            this.result.push(this.commandFactory.createEndComponent());
        }
        else {
            this.result.push(this.commandFactory.createBeginElement(ast.name, attrNameAndValues, eventTargetAndNames, variableNameAndValues, directives, ast.isBound(), ast.ngContentIndex));
            template_ast_1.templateVisitAll(this, ast.children);
            this.result.push(this.commandFactory.createEndElement());
        }
        return null;
    };
    CommandBuilderVisitor.prototype.visitVariable = function (ast, ctx) { return null; };
    CommandBuilderVisitor.prototype.visitAttr = function (ast, attrNameAndValues) {
        attrNameAndValues.push(ast.name);
        attrNameAndValues.push(ast.value);
        return null;
    };
    CommandBuilderVisitor.prototype.visitBoundText = function (ast, context) {
        this.result.push(this.commandFactory.createText(null, true, ast.ngContentIndex));
        return null;
    };
    CommandBuilderVisitor.prototype.visitText = function (ast, context) {
        this.result.push(this.commandFactory.createText(ast.value, false, ast.ngContentIndex));
        return null;
    };
    CommandBuilderVisitor.prototype.visitDirective = function (ast, ctx) {
        ctx.targetDirectives.push(ast.directive);
        template_ast_1.templateVisitAll(this, ast.hostEvents, ctx.eventTargetAndNames);
        ast.exportAsVars.forEach(function (varAst) {
            ctx.targetVariableNameAndValues.push(varAst.name);
            ctx.targetVariableNameAndValues.push(ctx.index);
        });
        return null;
    };
    CommandBuilderVisitor.prototype.visitEvent = function (ast, eventTargetAndNames) {
        eventTargetAndNames.push(ast.target);
        eventTargetAndNames.push(ast.name);
        return null;
    };
    CommandBuilderVisitor.prototype.visitDirectiveProperty = function (ast, context) { return null; };
    CommandBuilderVisitor.prototype.visitElementProperty = function (ast, context) { return null; };
    return CommandBuilderVisitor;
})();
function removeKeyValueArrayDuplicates(keyValueArray) {
    var knownPairs = new Set();
    var resultKeyValueArray = [];
    for (var i = 0; i < keyValueArray.length; i += 2) {
        var key = keyValueArray[i];
        var value = keyValueArray[i + 1];
        var pairId = key + ":" + value;
        if (!collection_1.SetWrapper.has(knownPairs, pairId)) {
            resultKeyValueArray.push(key);
            resultKeyValueArray.push(value);
            knownPairs.add(pairId);
        }
    }
    return resultKeyValueArray;
}
function keyValueArrayToMap(keyValueArr) {
    var data = {};
    for (var i = 0; i < keyValueArr.length; i += 2) {
        data[keyValueArr[i]] = keyValueArr[i + 1];
    }
    return data;
}
function mapToKeyValueArray(data) {
    var entryArray = [];
    collection_1.StringMapWrapper.forEach(data, function (value, name) { entryArray.push([name, value]); });
    // We need to sort to get a defined output order
    // for tests and for caching generated artifacts...
    collection_1.ListWrapper.sort(entryArray, function (entry1, entry2) { return lang_1.StringWrapper.compare(entry1[0], entry2[0]); });
    var keyValueArray = [];
    entryArray.forEach(function (entry) {
        keyValueArray.push(entry[0]);
        keyValueArray.push(entry[1]);
    });
    return keyValueArray;
}
function mergeAttributeValue(attrName, attrValue1, attrValue2) {
    if (attrName == CLASS_ATTR || attrName == STYLE_ATTR) {
        return attrValue1 + " " + attrValue2;
    }
    else {
        return attrValue2;
    }
}
var DirectiveContext = (function () {
    function DirectiveContext(index, eventTargetAndNames, targetVariableNameAndValues, targetDirectives) {
        this.index = index;
        this.eventTargetAndNames = eventTargetAndNames;
        this.targetVariableNameAndValues = targetVariableNameAndValues;
        this.targetDirectives = targetDirectives;
    }
    return DirectiveContext;
})();
var Expression = (function () {
    function Expression(value) {
        this.value = value;
    }
    return Expression;
})();
function escapeValue(value) {
    if (value instanceof Expression) {
        return value.value;
    }
    else if (lang_1.isString(value)) {
        return util_1.escapeSingleQuoteString(value);
    }
    else if (lang_1.isBlank(value)) {
        return 'null';
    }
    else {
        return "" + value;
    }
}
function codeGenArray(data) {
    var base = "[" + data.map(escapeValue).join(',') + "]";
    return lang_1.IS_DART ? "const " + base : base;
}
function codeGenDirectivesArray(directives) {
    var expressions = directives.map(function (directiveType) { return ("" + source_module_1.moduleRef(directiveType.type.moduleUrl) + directiveType.type.name); });
    var base = "[" + expressions.join(',') + "]";
    return lang_1.IS_DART ? "const " + base : base;
}
function codeGenViewEncapsulation(value) {
    if (lang_1.IS_DART) {
        return "" + exports.TEMPLATE_COMMANDS_MODULE_REF + value;
    }
    else {
        return "" + value;
    }
}
//# sourceMappingURL=data:application/json;base64,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