'use strict';var lang_1 = require('angular2/src/facade/lang');
var MODULE_REGEXP = /#MODULE\[([^\]]*)\]/g;
function moduleRef(moduleUrl) {
    return "#MODULE[" + moduleUrl + "]";
}
exports.moduleRef = moduleRef;
var SourceModule = (function () {
    function SourceModule(moduleUrl, sourceWithModuleRefs) {
        this.moduleUrl = moduleUrl;
        this.sourceWithModuleRefs = sourceWithModuleRefs;
    }
    SourceModule.prototype.getSourceWithImports = function () {
        var _this = this;
        var moduleAliases = {};
        var imports = [];
        var newSource = lang_1.StringWrapper.replaceAllMapped(this.sourceWithModuleRefs, MODULE_REGEXP, function (match) {
            var moduleUrl = match[1];
            var alias = moduleAliases[moduleUrl];
            if (lang_1.isBlank(alias)) {
                if (moduleUrl == _this.moduleUrl) {
                    alias = '';
                }
                else {
                    alias = "import" + imports.length;
                    imports.push([moduleUrl, alias]);
                }
                moduleAliases[moduleUrl] = alias;
            }
            return alias.length > 0 ? alias + "." : '';
        });
        return new SourceWithImports(newSource, imports);
    };
    return SourceModule;
})();
exports.SourceModule = SourceModule;
var SourceExpression = (function () {
    function SourceExpression(declarations, expression) {
        this.declarations = declarations;
        this.expression = expression;
    }
    return SourceExpression;
})();
exports.SourceExpression = SourceExpression;
var SourceExpressions = (function () {
    function SourceExpressions(declarations, expressions) {
        this.declarations = declarations;
        this.expressions = expressions;
    }
    return SourceExpressions;
})();
exports.SourceExpressions = SourceExpressions;
var SourceWithImports = (function () {
    function SourceWithImports(source, imports) {
        this.source = source;
        this.imports = imports;
    }
    return SourceWithImports;
})();
exports.SourceWithImports = SourceWithImports;
//# sourceMappingURL=data:application/json;base64,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