'use strict';var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var lang_1 = require('angular2/src/facade/lang');
var collection_1 = require('angular2/src/facade/collection');
var di_1 = require('angular2/src/core/di');
var view_listener_1 = require('angular2/src/core/linker/view_listener');
var dom_adapter_1 = require('angular2/src/platform/dom/dom_adapter');
var api_1 = require('angular2/src/core/render/api');
var debug_element_1 = require('angular2/src/core/debug/debug_element');
var NG_ID_PROPERTY = 'ngid';
var INSPECT_GLOBAL_NAME = 'ng.probe';
var NG_ID_SEPARATOR = '#';
// Need to keep the views in a global Map so that multiple angular apps are supported
var _allIdsByView = new collection_1.Map();
var _allViewsById = new collection_1.Map();
var _nextId = 0;
function _setElementId(element, indices) {
    if (lang_1.isPresent(element) && dom_adapter_1.DOM.isElementNode(element)) {
        dom_adapter_1.DOM.setData(element, NG_ID_PROPERTY, indices.join(NG_ID_SEPARATOR));
    }
}
function _getElementId(element) {
    var elId = dom_adapter_1.DOM.getData(element, NG_ID_PROPERTY);
    if (lang_1.isPresent(elId)) {
        return elId.split(NG_ID_SEPARATOR).map(function (partStr) { return lang_1.NumberWrapper.parseInt(partStr, 10); });
    }
    else {
        return null;
    }
}
/**
 * Returns a {@link DebugElement} for the given native DOM element, or
 * null if the given native element does not have an Angular view associated
 * with it.
 */
function inspectNativeElement(element) {
    var elId = _getElementId(element);
    if (lang_1.isPresent(elId)) {
        var view = _allViewsById.get(elId[0]);
        if (lang_1.isPresent(view)) {
            return new debug_element_1.DebugElement_(view, elId[1]);
        }
    }
    return null;
}
exports.inspectNativeElement = inspectNativeElement;
var DebugElementViewListener = (function () {
    function DebugElementViewListener(_renderer) {
        this._renderer = _renderer;
        dom_adapter_1.DOM.setGlobalVar(INSPECT_GLOBAL_NAME, inspectNativeElement);
    }
    DebugElementViewListener.prototype.onViewCreated = function (view) {
        var viewId = _nextId++;
        _allViewsById.set(viewId, view);
        _allIdsByView.set(view, viewId);
        for (var i = 0; i < view.elementRefs.length; i++) {
            var el = view.elementRefs[i];
            _setElementId(this._renderer.getNativeElementSync(el), [viewId, i]);
        }
    };
    DebugElementViewListener.prototype.onViewDestroyed = function (view) {
        var viewId = _allIdsByView.get(view);
        _allIdsByView.delete(view);
        _allViewsById.delete(viewId);
    };
    DebugElementViewListener = __decorate([
        di_1.Injectable(), 
        __metadata('design:paramtypes', [api_1.Renderer])
    ], DebugElementViewListener);
    return DebugElementViewListener;
})();
exports.DebugElementViewListener = DebugElementViewListener;
exports.ELEMENT_PROBE_PROVIDERS = lang_1.CONST_EXPR([
    DebugElementViewListener,
    lang_1.CONST_EXPR(new di_1.Provider(view_listener_1.AppViewListener, { useExisting: DebugElementViewListener })),
]);
exports.ELEMENT_PROBE_BINDINGS = exports.ELEMENT_PROBE_PROVIDERS;
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiZGVidWdfZWxlbWVudF92aWV3X2xpc3RlbmVyLmpzIiwic291cmNlUm9vdCI6IiIsInNvdXJjZXMiOlsiYW5ndWxhcjIvc3JjL3BsYXRmb3JtL2RvbS9kZWJ1Zy9kZWJ1Z19lbGVtZW50X3ZpZXdfbGlzdGVuZXIudHMiXSwibmFtZXMiOlsiX3NldEVsZW1lbnRJZCIsIl9nZXRFbGVtZW50SWQiLCJpbnNwZWN0TmF0aXZlRWxlbWVudCIsIkRlYnVnRWxlbWVudFZpZXdMaXN0ZW5lciIsIkRlYnVnRWxlbWVudFZpZXdMaXN0ZW5lci5jb25zdHJ1Y3RvciIsIkRlYnVnRWxlbWVudFZpZXdMaXN0ZW5lci5vblZpZXdDcmVhdGVkIiwiRGVidWdFbGVtZW50Vmlld0xpc3RlbmVyLm9uVmlld0Rlc3Ryb3llZCJdLCJtYXBwaW5ncyI6Ijs7Ozs7Ozs7O0FBQUEscUJBQWtFLDBCQUEwQixDQUFDLENBQUE7QUFDN0YsMkJBQTJDLGdDQUFnQyxDQUFDLENBQUE7QUFDNUUsbUJBQTRDLHNCQUFzQixDQUFDLENBQUE7QUFDbkUsOEJBQThCLHdDQUF3QyxDQUFDLENBQUE7QUFFdkUsNEJBQWtCLHVDQUF1QyxDQUFDLENBQUE7QUFDMUQsb0JBQXVCLDhCQUE4QixDQUFDLENBQUE7QUFDdEQsOEJBQTBDLHVDQUF1QyxDQUFDLENBQUE7QUFFbEYsSUFBTSxjQUFjLEdBQUcsTUFBTSxDQUFDO0FBQzlCLElBQU0sbUJBQW1CLEdBQUcsVUFBVSxDQUFDO0FBRXZDLElBQU0sZUFBZSxHQUFHLEdBQUcsQ0FBQztBQUU1QixxRkFBcUY7QUFDckYsSUFBSSxhQUFhLEdBQUcsSUFBSSxnQkFBRyxFQUFtQixDQUFDO0FBQy9DLElBQUksYUFBYSxHQUFHLElBQUksZ0JBQUcsRUFBbUIsQ0FBQztBQUUvQyxJQUFJLE9BQU8sR0FBRyxDQUFDLENBQUM7QUFFaEIsdUJBQXVCLE9BQU8sRUFBRSxPQUFpQjtJQUMvQ0EsRUFBRUEsQ0FBQ0EsQ0FBQ0EsZ0JBQVNBLENBQUNBLE9BQU9BLENBQUNBLElBQUlBLGlCQUFHQSxDQUFDQSxhQUFhQSxDQUFDQSxPQUFPQSxDQUFDQSxDQUFDQSxDQUFDQSxDQUFDQTtRQUNyREEsaUJBQUdBLENBQUNBLE9BQU9BLENBQUNBLE9BQU9BLEVBQUVBLGNBQWNBLEVBQUVBLE9BQU9BLENBQUNBLElBQUlBLENBQUNBLGVBQWVBLENBQUNBLENBQUNBLENBQUNBO0lBQ3RFQSxDQUFDQTtBQUNIQSxDQUFDQTtBQUVELHVCQUF1QixPQUFPO0lBQzVCQyxJQUFJQSxJQUFJQSxHQUFHQSxpQkFBR0EsQ0FBQ0EsT0FBT0EsQ0FBQ0EsT0FBT0EsRUFBRUEsY0FBY0EsQ0FBQ0EsQ0FBQ0E7SUFDaERBLEVBQUVBLENBQUNBLENBQUNBLGdCQUFTQSxDQUFDQSxJQUFJQSxDQUFDQSxDQUFDQSxDQUFDQSxDQUFDQTtRQUNwQkEsTUFBTUEsQ0FBQ0EsSUFBSUEsQ0FBQ0EsS0FBS0EsQ0FBQ0EsZUFBZUEsQ0FBQ0EsQ0FBQ0EsR0FBR0EsQ0FBQ0EsVUFBQUEsT0FBT0EsSUFBSUEsT0FBQUEsb0JBQWFBLENBQUNBLFFBQVFBLENBQUNBLE9BQU9BLEVBQUVBLEVBQUVBLENBQUNBLEVBQW5DQSxDQUFtQ0EsQ0FBQ0EsQ0FBQ0E7SUFDekZBLENBQUNBO0lBQUNBLElBQUlBLENBQUNBLENBQUNBO1FBQ05BLE1BQU1BLENBQUNBLElBQUlBLENBQUNBO0lBQ2RBLENBQUNBO0FBQ0hBLENBQUNBO0FBRUQ7Ozs7R0FJRztBQUNILDhCQUFxQyxPQUFPO0lBQzFDQyxJQUFJQSxJQUFJQSxHQUFHQSxhQUFhQSxDQUFDQSxPQUFPQSxDQUFDQSxDQUFDQTtJQUNsQ0EsRUFBRUEsQ0FBQ0EsQ0FBQ0EsZ0JBQVNBLENBQUNBLElBQUlBLENBQUNBLENBQUNBLENBQUNBLENBQUNBO1FBQ3BCQSxJQUFJQSxJQUFJQSxHQUFHQSxhQUFhQSxDQUFDQSxHQUFHQSxDQUFDQSxJQUFJQSxDQUFDQSxDQUFDQSxDQUFDQSxDQUFDQSxDQUFDQTtRQUN0Q0EsRUFBRUEsQ0FBQ0EsQ0FBQ0EsZ0JBQVNBLENBQUNBLElBQUlBLENBQUNBLENBQUNBLENBQUNBLENBQUNBO1lBQ3BCQSxNQUFNQSxDQUFDQSxJQUFJQSw2QkFBYUEsQ0FBQ0EsSUFBSUEsRUFBRUEsSUFBSUEsQ0FBQ0EsQ0FBQ0EsQ0FBQ0EsQ0FBQ0EsQ0FBQ0E7UUFDMUNBLENBQUNBO0lBQ0hBLENBQUNBO0lBQ0RBLE1BQU1BLENBQUNBLElBQUlBLENBQUNBO0FBQ2RBLENBQUNBO0FBVGUsNEJBQW9CLHVCQVNuQyxDQUFBO0FBRUQ7SUFFRUMsa0NBQW9CQSxTQUFtQkE7UUFBbkJDLGNBQVNBLEdBQVRBLFNBQVNBLENBQVVBO1FBQ3JDQSxpQkFBR0EsQ0FBQ0EsWUFBWUEsQ0FBQ0EsbUJBQW1CQSxFQUFFQSxvQkFBb0JBLENBQUNBLENBQUNBO0lBQzlEQSxDQUFDQTtJQUVERCxnREFBYUEsR0FBYkEsVUFBY0EsSUFBYUE7UUFDekJFLElBQUlBLE1BQU1BLEdBQUdBLE9BQU9BLEVBQUVBLENBQUNBO1FBQ3ZCQSxhQUFhQSxDQUFDQSxHQUFHQSxDQUFDQSxNQUFNQSxFQUFFQSxJQUFJQSxDQUFDQSxDQUFDQTtRQUNoQ0EsYUFBYUEsQ0FBQ0EsR0FBR0EsQ0FBQ0EsSUFBSUEsRUFBRUEsTUFBTUEsQ0FBQ0EsQ0FBQ0E7UUFDaENBLEdBQUdBLENBQUNBLENBQUNBLEdBQUdBLENBQUNBLENBQUNBLEdBQUdBLENBQUNBLEVBQUVBLENBQUNBLEdBQUdBLElBQUlBLENBQUNBLFdBQVdBLENBQUNBLE1BQU1BLEVBQUVBLENBQUNBLEVBQUVBLEVBQUVBLENBQUNBO1lBQ2pEQSxJQUFJQSxFQUFFQSxHQUFHQSxJQUFJQSxDQUFDQSxXQUFXQSxDQUFDQSxDQUFDQSxDQUFDQSxDQUFDQTtZQUM3QkEsYUFBYUEsQ0FBQ0EsSUFBSUEsQ0FBQ0EsU0FBU0EsQ0FBQ0Esb0JBQW9CQSxDQUFDQSxFQUFFQSxDQUFDQSxFQUFFQSxDQUFDQSxNQUFNQSxFQUFFQSxDQUFDQSxDQUFDQSxDQUFDQSxDQUFDQTtRQUN0RUEsQ0FBQ0E7SUFDSEEsQ0FBQ0E7SUFFREYsa0RBQWVBLEdBQWZBLFVBQWdCQSxJQUFhQTtRQUMzQkcsSUFBSUEsTUFBTUEsR0FBR0EsYUFBYUEsQ0FBQ0EsR0FBR0EsQ0FBQ0EsSUFBSUEsQ0FBQ0EsQ0FBQ0E7UUFDckNBLGFBQWFBLENBQUNBLE1BQU1BLENBQUNBLElBQUlBLENBQUNBLENBQUNBO1FBQzNCQSxhQUFhQSxDQUFDQSxNQUFNQSxDQUFDQSxNQUFNQSxDQUFDQSxDQUFDQTtJQUMvQkEsQ0FBQ0E7SUFwQkhIO1FBQUNBLGVBQVVBLEVBQUVBOztpQ0FxQlpBO0lBQURBLCtCQUFDQTtBQUFEQSxDQUFDQSxBQXJCRCxJQXFCQztBQXBCWSxnQ0FBd0IsMkJBb0JwQyxDQUFBO0FBRVksK0JBQXVCLEdBQVUsaUJBQVUsQ0FBQztJQUN2RCx3QkFBd0I7SUFDeEIsaUJBQVUsQ0FBQyxJQUFJLGFBQVEsQ0FBQywrQkFBZSxFQUFFLEVBQUMsV0FBVyxFQUFFLHdCQUF3QixFQUFDLENBQUMsQ0FBQztDQUNuRixDQUFDLENBQUM7QUFFVSw4QkFBc0IsR0FBRywrQkFBdUIsQ0FBQyIsInNvdXJjZXNDb250ZW50IjpbImltcG9ydCB7Q09OU1RfRVhQUiwgaXNQcmVzZW50LCBOdW1iZXJXcmFwcGVyLCBTdHJpbmdXcmFwcGVyfSBmcm9tICdhbmd1bGFyMi9zcmMvZmFjYWRlL2xhbmcnO1xuaW1wb3J0IHtNYXBXcmFwcGVyLCBNYXAsIExpc3RXcmFwcGVyfSBmcm9tICdhbmd1bGFyMi9zcmMvZmFjYWRlL2NvbGxlY3Rpb24nO1xuaW1wb3J0IHtJbmplY3RhYmxlLCBwcm92aWRlLCBQcm92aWRlcn0gZnJvbSAnYW5ndWxhcjIvc3JjL2NvcmUvZGknO1xuaW1wb3J0IHtBcHBWaWV3TGlzdGVuZXJ9IGZyb20gJ2FuZ3VsYXIyL3NyYy9jb3JlL2xpbmtlci92aWV3X2xpc3RlbmVyJztcbmltcG9ydCB7QXBwVmlld30gZnJvbSAnYW5ndWxhcjIvc3JjL2NvcmUvbGlua2VyL3ZpZXcnO1xuaW1wb3J0IHtET019IGZyb20gJ2FuZ3VsYXIyL3NyYy9wbGF0Zm9ybS9kb20vZG9tX2FkYXB0ZXInO1xuaW1wb3J0IHtSZW5kZXJlcn0gZnJvbSAnYW5ndWxhcjIvc3JjL2NvcmUvcmVuZGVyL2FwaSc7XG5pbXBvcnQge0RlYnVnRWxlbWVudCwgRGVidWdFbGVtZW50X30gZnJvbSAnYW5ndWxhcjIvc3JjL2NvcmUvZGVidWcvZGVidWdfZWxlbWVudCc7XG5cbmNvbnN0IE5HX0lEX1BST1BFUlRZID0gJ25naWQnO1xuY29uc3QgSU5TUEVDVF9HTE9CQUxfTkFNRSA9ICduZy5wcm9iZSc7XG5cbmNvbnN0IE5HX0lEX1NFUEFSQVRPUiA9ICcjJztcblxuLy8gTmVlZCB0byBrZWVwIHRoZSB2aWV3cyBpbiBhIGdsb2JhbCBNYXAgc28gdGhhdCBtdWx0aXBsZSBhbmd1bGFyIGFwcHMgYXJlIHN1cHBvcnRlZFxudmFyIF9hbGxJZHNCeVZpZXcgPSBuZXcgTWFwPEFwcFZpZXcsIG51bWJlcj4oKTtcbnZhciBfYWxsVmlld3NCeUlkID0gbmV3IE1hcDxudW1iZXIsIEFwcFZpZXc+KCk7XG5cbnZhciBfbmV4dElkID0gMDtcblxuZnVuY3Rpb24gX3NldEVsZW1lbnRJZChlbGVtZW50LCBpbmRpY2VzOiBudW1iZXJbXSkge1xuICBpZiAoaXNQcmVzZW50KGVsZW1lbnQpICYmIERPTS5pc0VsZW1lbnROb2RlKGVsZW1lbnQpKSB7XG4gICAgRE9NLnNldERhdGEoZWxlbWVudCwgTkdfSURfUFJPUEVSVFksIGluZGljZXMuam9pbihOR19JRF9TRVBBUkFUT1IpKTtcbiAgfVxufVxuXG5mdW5jdGlvbiBfZ2V0RWxlbWVudElkKGVsZW1lbnQpOiBudW1iZXJbXSB7XG4gIHZhciBlbElkID0gRE9NLmdldERhdGEoZWxlbWVudCwgTkdfSURfUFJPUEVSVFkpO1xuICBpZiAoaXNQcmVzZW50KGVsSWQpKSB7XG4gICAgcmV0dXJuIGVsSWQuc3BsaXQoTkdfSURfU0VQQVJBVE9SKS5tYXAocGFydFN0ciA9PiBOdW1iZXJXcmFwcGVyLnBhcnNlSW50KHBhcnRTdHIsIDEwKSk7XG4gIH0gZWxzZSB7XG4gICAgcmV0dXJuIG51bGw7XG4gIH1cbn1cblxuLyoqXG4gKiBSZXR1cm5zIGEge0BsaW5rIERlYnVnRWxlbWVudH0gZm9yIHRoZSBnaXZlbiBuYXRpdmUgRE9NIGVsZW1lbnQsIG9yXG4gKiBudWxsIGlmIHRoZSBnaXZlbiBuYXRpdmUgZWxlbWVudCBkb2VzIG5vdCBoYXZlIGFuIEFuZ3VsYXIgdmlldyBhc3NvY2lhdGVkXG4gKiB3aXRoIGl0LlxuICovXG5leHBvcnQgZnVuY3Rpb24gaW5zcGVjdE5hdGl2ZUVsZW1lbnQoZWxlbWVudCk6IERlYnVnRWxlbWVudCB7XG4gIHZhciBlbElkID0gX2dldEVsZW1lbnRJZChlbGVtZW50KTtcbiAgaWYgKGlzUHJlc2VudChlbElkKSkge1xuICAgIHZhciB2aWV3ID0gX2FsbFZpZXdzQnlJZC5nZXQoZWxJZFswXSk7XG4gICAgaWYgKGlzUHJlc2VudCh2aWV3KSkge1xuICAgICAgcmV0dXJuIG5ldyBEZWJ1Z0VsZW1lbnRfKHZpZXcsIGVsSWRbMV0pO1xuICAgIH1cbiAgfVxuICByZXR1cm4gbnVsbDtcbn1cblxuQEluamVjdGFibGUoKVxuZXhwb3J0IGNsYXNzIERlYnVnRWxlbWVudFZpZXdMaXN0ZW5lciBpbXBsZW1lbnRzIEFwcFZpZXdMaXN0ZW5lciB7XG4gIGNvbnN0cnVjdG9yKHByaXZhdGUgX3JlbmRlcmVyOiBSZW5kZXJlcikge1xuICAgIERPTS5zZXRHbG9iYWxWYXIoSU5TUEVDVF9HTE9CQUxfTkFNRSwgaW5zcGVjdE5hdGl2ZUVsZW1lbnQpO1xuICB9XG5cbiAgb25WaWV3Q3JlYXRlZCh2aWV3OiBBcHBWaWV3KSB7XG4gICAgdmFyIHZpZXdJZCA9IF9uZXh0SWQrKztcbiAgICBfYWxsVmlld3NCeUlkLnNldCh2aWV3SWQsIHZpZXcpO1xuICAgIF9hbGxJZHNCeVZpZXcuc2V0KHZpZXcsIHZpZXdJZCk7XG4gICAgZm9yICh2YXIgaSA9IDA7IGkgPCB2aWV3LmVsZW1lbnRSZWZzLmxlbmd0aDsgaSsrKSB7XG4gICAgICB2YXIgZWwgPSB2aWV3LmVsZW1lbnRSZWZzW2ldO1xuICAgICAgX3NldEVsZW1lbnRJZCh0aGlzLl9yZW5kZXJlci5nZXROYXRpdmVFbGVtZW50U3luYyhlbCksIFt2aWV3SWQsIGldKTtcbiAgICB9XG4gIH1cblxuICBvblZpZXdEZXN0cm95ZWQodmlldzogQXBwVmlldykge1xuICAgIHZhciB2aWV3SWQgPSBfYWxsSWRzQnlWaWV3LmdldCh2aWV3KTtcbiAgICBfYWxsSWRzQnlWaWV3LmRlbGV0ZSh2aWV3KTtcbiAgICBfYWxsVmlld3NCeUlkLmRlbGV0ZSh2aWV3SWQpO1xuICB9XG59XG5cbmV4cG9ydCBjb25zdCBFTEVNRU5UX1BST0JFX1BST1ZJREVSUzogYW55W10gPSBDT05TVF9FWFBSKFtcbiAgRGVidWdFbGVtZW50Vmlld0xpc3RlbmVyLFxuICBDT05TVF9FWFBSKG5ldyBQcm92aWRlcihBcHBWaWV3TGlzdGVuZXIsIHt1c2VFeGlzdGluZzogRGVidWdFbGVtZW50Vmlld0xpc3RlbmVyfSkpLFxuXSk7XG5cbmV4cG9ydCBjb25zdCBFTEVNRU5UX1BST0JFX0JJTkRJTkdTID0gRUxFTUVOVF9QUk9CRV9QUk9WSURFUlM7XG4iXX0=