'use strict';var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var lang_1 = require('angular2/src/facade/lang');
var exceptions_1 = require('angular2/src/facade/exceptions');
var collection_1 = require('angular2/src/facade/collection');
var async_1 = require('angular2/src/facade/async');
var template_commands_1 = require('angular2/src/core/linker/template_commands');
var directive_metadata_1 = require('./directive_metadata');
var di_1 = require('angular2/src/core/di');
var source_module_1 = require('./source_module');
var change_detector_compiler_1 = require('./change_detector_compiler');
var style_compiler_1 = require('./style_compiler');
var command_compiler_1 = require('./command_compiler');
var template_parser_1 = require('./template_parser');
var template_normalizer_1 = require('./template_normalizer');
var runtime_metadata_1 = require('./runtime_metadata');
var command_compiler_2 = require('./command_compiler');
var util_1 = require('./util');
/**
 * An internal module of the Angular compiler that begins with component types,
 * extracts templates, and eventually produces a compiled version of the component
 * ready for linking into an application.
 */
var TemplateCompiler = (function () {
    function TemplateCompiler(_runtimeMetadataResolver, _templateNormalizer, _templateParser, _styleCompiler, _commandCompiler, _cdCompiler) {
        this._runtimeMetadataResolver = _runtimeMetadataResolver;
        this._templateNormalizer = _templateNormalizer;
        this._templateParser = _templateParser;
        this._styleCompiler = _styleCompiler;
        this._commandCompiler = _commandCompiler;
        this._cdCompiler = _cdCompiler;
        this._hostCacheKeys = new Map();
        this._compiledTemplateCache = new Map();
        this._compiledTemplateDone = new Map();
        this._nextTemplateId = 0;
    }
    TemplateCompiler.prototype.normalizeDirectiveMetadata = function (directive) {
        if (!directive.isComponent) {
            // For non components there is nothing to be normalized yet.
            return async_1.PromiseWrapper.resolve(directive);
        }
        return this._templateNormalizer.normalizeTemplate(directive.type, directive.template)
            .then(function (normalizedTemplate) { return new directive_metadata_1.CompileDirectiveMetadata({
            type: directive.type,
            isComponent: directive.isComponent,
            dynamicLoadable: directive.dynamicLoadable,
            selector: directive.selector,
            exportAs: directive.exportAs,
            changeDetection: directive.changeDetection,
            inputs: directive.inputs,
            outputs: directive.outputs,
            hostListeners: directive.hostListeners,
            hostProperties: directive.hostProperties,
            hostAttributes: directive.hostAttributes,
            lifecycleHooks: directive.lifecycleHooks,
            template: normalizedTemplate
        }); });
    };
    TemplateCompiler.prototype.compileHostComponentRuntime = function (type) {
        var hostCacheKey = this._hostCacheKeys.get(type);
        if (lang_1.isBlank(hostCacheKey)) {
            hostCacheKey = new Object();
            this._hostCacheKeys.set(type, hostCacheKey);
            var compMeta = this._runtimeMetadataResolver.getMetadata(type);
            assertComponent(compMeta);
            var hostMeta = directive_metadata_1.createHostComponentMeta(compMeta.type, compMeta.selector);
            this._compileComponentRuntime(hostCacheKey, hostMeta, [compMeta], new Set());
        }
        return this._compiledTemplateDone.get(hostCacheKey)
            .then(function (compiledTemplate) { return new template_commands_1.CompiledHostTemplate(compiledTemplate); });
    };
    TemplateCompiler.prototype.clearCache = function () {
        this._hostCacheKeys.clear();
        this._styleCompiler.clearCache();
        this._compiledTemplateCache.clear();
        this._compiledTemplateDone.clear();
    };
    TemplateCompiler.prototype._compileComponentRuntime = function (cacheKey, compMeta, viewDirectives, compilingComponentCacheKeys) {
        var _this = this;
        var uniqViewDirectives = removeDuplicates(viewDirectives);
        var compiledTemplate = this._compiledTemplateCache.get(cacheKey);
        var done = this._compiledTemplateDone.get(cacheKey);
        if (lang_1.isBlank(compiledTemplate)) {
            var styles = [];
            var changeDetectorFactory;
            var commands = [];
            var templateId = lang_1.stringify(compMeta.type.runtime) + "Template" + this._nextTemplateId++;
            compiledTemplate = new template_commands_1.CompiledComponentTemplate(templateId, function (dispatcher) { return changeDetectorFactory(dispatcher); }, commands, styles);
            this._compiledTemplateCache.set(cacheKey, compiledTemplate);
            compilingComponentCacheKeys.add(cacheKey);
            done = async_1.PromiseWrapper
                .all([this._styleCompiler.compileComponentRuntime(compMeta.template)].concat(uniqViewDirectives.map(function (dirMeta) { return _this.normalizeDirectiveMetadata(dirMeta); })))
                .then(function (stylesAndNormalizedViewDirMetas) {
                var childPromises = [];
                var normalizedViewDirMetas = stylesAndNormalizedViewDirMetas.slice(1);
                var parsedTemplate = _this._templateParser.parse(compMeta.template.template, normalizedViewDirMetas, compMeta.type.name);
                var changeDetectorFactories = _this._cdCompiler.compileComponentRuntime(compMeta.type, compMeta.changeDetection, parsedTemplate);
                changeDetectorFactory = changeDetectorFactories[0];
                var tmpStyles = stylesAndNormalizedViewDirMetas[0];
                tmpStyles.forEach(function (style) { return styles.push(style); });
                var tmpCommands = _this._compileCommandsRuntime(compMeta, parsedTemplate, changeDetectorFactories, compilingComponentCacheKeys, childPromises);
                tmpCommands.forEach(function (cmd) { return commands.push(cmd); });
                return async_1.PromiseWrapper.all(childPromises);
            })
                .then(function (_) {
                collection_1.SetWrapper.delete(compilingComponentCacheKeys, cacheKey);
                return compiledTemplate;
            });
            this._compiledTemplateDone.set(cacheKey, done);
        }
        return compiledTemplate;
    };
    TemplateCompiler.prototype._compileCommandsRuntime = function (compMeta, parsedTemplate, changeDetectorFactories, compilingComponentCacheKeys, childPromises) {
        var _this = this;
        var cmds = this._commandCompiler.compileComponentRuntime(compMeta, parsedTemplate, changeDetectorFactories, function (childComponentDir) {
            var childCacheKey = childComponentDir.type.runtime;
            var childViewDirectives = _this._runtimeMetadataResolver.getViewDirectivesMetadata(childComponentDir.type.runtime);
            var childIsRecursive = collection_1.SetWrapper.has(compilingComponentCacheKeys, childCacheKey);
            var childTemplate = _this._compileComponentRuntime(childCacheKey, childComponentDir, childViewDirectives, compilingComponentCacheKeys);
            if (!childIsRecursive) {
                // Only wait for a child if it is not a cycle
                childPromises.push(_this._compiledTemplateDone.get(childCacheKey));
            }
            return function () { return childTemplate; };
        });
        cmds.forEach(function (cmd) {
            if (cmd instanceof template_commands_1.BeginComponentCmd) {
                cmd.templateGetter();
            }
        });
        return cmds;
    };
    TemplateCompiler.prototype.compileTemplatesCodeGen = function (components) {
        var _this = this;
        if (components.length === 0) {
            throw new exceptions_1.BaseException('No components given');
        }
        var declarations = [];
        var templateArguments = [];
        var componentMetas = [];
        components.forEach(function (componentWithDirs) {
            var compMeta = componentWithDirs.component;
            assertComponent(compMeta);
            componentMetas.push(compMeta);
            _this._processTemplateCodeGen(compMeta, componentWithDirs.directives, declarations, templateArguments);
            if (compMeta.dynamicLoadable) {
                var hostMeta = directive_metadata_1.createHostComponentMeta(compMeta.type, compMeta.selector);
                componentMetas.push(hostMeta);
                _this._processTemplateCodeGen(hostMeta, [compMeta], declarations, templateArguments);
            }
        });
        collection_1.ListWrapper.forEachWithIndex(componentMetas, function (compMeta, index) {
            var templateId = compMeta.type.moduleUrl + "|" + compMeta.type.name;
            var constructionKeyword = lang_1.IS_DART ? 'const' : 'new';
            var compiledTemplateExpr = constructionKeyword + " " + command_compiler_2.TEMPLATE_COMMANDS_MODULE_REF + "CompiledComponentTemplate('" + templateId + "'," + templateArguments[index].join(',') + ")";
            var variableValueExpr;
            if (compMeta.type.isHost) {
                variableValueExpr =
                    constructionKeyword + " " + command_compiler_2.TEMPLATE_COMMANDS_MODULE_REF + "CompiledHostTemplate(" + compiledTemplateExpr + ")";
            }
            else {
                variableValueExpr = compiledTemplateExpr;
            }
            var varName = templateVariableName(compMeta.type);
            declarations.push("" + util_1.codeGenExportVariable(varName) + variableValueExpr + ";");
            declarations.push(util_1.codeGenValueFn([], varName, templateGetterName(compMeta.type)) + ";");
        });
        var moduleUrl = components[0].component.type.moduleUrl;
        return new source_module_1.SourceModule("" + templateModuleUrl(moduleUrl), declarations.join('\n'));
    };
    TemplateCompiler.prototype.compileStylesheetCodeGen = function (stylesheetUrl, cssText) {
        return this._styleCompiler.compileStylesheetCodeGen(stylesheetUrl, cssText);
    };
    TemplateCompiler.prototype._processTemplateCodeGen = function (compMeta, directives, targetDeclarations, targetTemplateArguments) {
        var uniqueDirectives = removeDuplicates(directives);
        var styleExpr = this._styleCompiler.compileComponentCodeGen(compMeta.template);
        var parsedTemplate = this._templateParser.parse(compMeta.template.template, uniqueDirectives, compMeta.type.name);
        var changeDetectorsExprs = this._cdCompiler.compileComponentCodeGen(compMeta.type, compMeta.changeDetection, parsedTemplate);
        var commandsExpr = this._commandCompiler.compileComponentCodeGen(compMeta, parsedTemplate, changeDetectorsExprs.expressions, codeGenComponentTemplateFactory);
        addAll(styleExpr.declarations, targetDeclarations);
        addAll(changeDetectorsExprs.declarations, targetDeclarations);
        addAll(commandsExpr.declarations, targetDeclarations);
        targetTemplateArguments.push([changeDetectorsExprs.expressions[0], commandsExpr.expression, styleExpr.expression]);
    };
    TemplateCompiler = __decorate([
        di_1.Injectable(), 
        __metadata('design:paramtypes', [runtime_metadata_1.RuntimeMetadataResolver, template_normalizer_1.TemplateNormalizer, template_parser_1.TemplateParser, style_compiler_1.StyleCompiler, command_compiler_1.CommandCompiler, change_detector_compiler_1.ChangeDetectionCompiler])
    ], TemplateCompiler);
    return TemplateCompiler;
})();
exports.TemplateCompiler = TemplateCompiler;
var NormalizedComponentWithViewDirectives = (function () {
    function NormalizedComponentWithViewDirectives(component, directives) {
        this.component = component;
        this.directives = directives;
    }
    return NormalizedComponentWithViewDirectives;
})();
exports.NormalizedComponentWithViewDirectives = NormalizedComponentWithViewDirectives;
function assertComponent(meta) {
    if (!meta.isComponent) {
        throw new exceptions_1.BaseException("Could not compile '" + meta.type.name + "' because it is not a component.");
    }
}
function templateVariableName(type) {
    return type.name + "Template";
}
function templateGetterName(type) {
    return templateVariableName(type) + "Getter";
}
function templateModuleUrl(moduleUrl) {
    var urlWithoutSuffix = moduleUrl.substring(0, moduleUrl.length - util_1.MODULE_SUFFIX.length);
    return urlWithoutSuffix + ".template" + util_1.MODULE_SUFFIX;
}
function addAll(source, target) {
    for (var i = 0; i < source.length; i++) {
        target.push(source[i]);
    }
}
function codeGenComponentTemplateFactory(nestedCompType) {
    return "" + source_module_1.moduleRef(templateModuleUrl(nestedCompType.type.moduleUrl)) + templateGetterName(nestedCompType.type);
}
function removeDuplicates(items) {
    var res = [];
    items.forEach(function (item) {
        var hasMatch = res.filter(function (r) { return r.type.name == item.type.name && r.type.moduleUrl == item.type.moduleUrl &&
            r.type.runtime == item.type.runtime; })
            .length > 0;
        if (!hasMatch) {
            res.push(item);
        }
    });
    return res;
}
//# sourceMappingURL=data:application/json;base64,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