'use strict';var lang_1 = require('angular2/src/facade/lang');
var exceptions_1 = require('angular2/src/facade/exceptions');
var collection_1 = require('angular2/src/facade/collection');
var ast_1 = require('./parser/ast');
var change_detection_util_1 = require('./change_detection_util');
var dynamic_change_detector_1 = require('./dynamic_change_detector');
var directive_record_1 = require('./directive_record');
var event_binding_1 = require('./event_binding');
var coalesce_1 = require('./coalesce');
var proto_record_1 = require('./proto_record');
var DynamicProtoChangeDetector = (function () {
    function DynamicProtoChangeDetector(_definition) {
        this._definition = _definition;
        this._propertyBindingRecords = createPropertyRecords(_definition);
        this._eventBindingRecords = createEventRecords(_definition);
        this._propertyBindingTargets = this._definition.bindingRecords.map(function (b) { return b.target; });
        this._directiveIndices = this._definition.directiveRecords.map(function (d) { return d.directiveIndex; });
    }
    DynamicProtoChangeDetector.prototype.instantiate = function (dispatcher) {
        return new dynamic_change_detector_1.DynamicChangeDetector(this._definition.id, dispatcher, this._propertyBindingRecords.length, this._propertyBindingTargets, this._directiveIndices, this._definition.strategy, this._propertyBindingRecords, this._eventBindingRecords, this._definition.directiveRecords, this._definition.genConfig);
    };
    return DynamicProtoChangeDetector;
})();
exports.DynamicProtoChangeDetector = DynamicProtoChangeDetector;
function createPropertyRecords(definition) {
    var recordBuilder = new ProtoRecordBuilder();
    collection_1.ListWrapper.forEachWithIndex(definition.bindingRecords, function (b, index) { return recordBuilder.add(b, definition.variableNames, index); });
    return coalesce_1.coalesce(recordBuilder.records);
}
exports.createPropertyRecords = createPropertyRecords;
function createEventRecords(definition) {
    // TODO: vsavkin: remove $event when the compiler handles render-side variables properly
    var varNames = collection_1.ListWrapper.concat(['$event'], definition.variableNames);
    return definition.eventRecords.map(function (er) {
        var records = _ConvertAstIntoProtoRecords.create(er, varNames);
        var dirIndex = er.implicitReceiver instanceof directive_record_1.DirectiveIndex ? er.implicitReceiver : null;
        return new event_binding_1.EventBinding(er.target.name, er.target.elementIndex, dirIndex, records);
    });
}
exports.createEventRecords = createEventRecords;
var ProtoRecordBuilder = (function () {
    function ProtoRecordBuilder() {
        this.records = [];
    }
    ProtoRecordBuilder.prototype.add = function (b, variableNames, bindingIndex) {
        var oldLast = collection_1.ListWrapper.last(this.records);
        if (lang_1.isPresent(oldLast) && oldLast.bindingRecord.directiveRecord == b.directiveRecord) {
            oldLast.lastInDirective = false;
        }
        var numberOfRecordsBefore = this.records.length;
        this._appendRecords(b, variableNames, bindingIndex);
        var newLast = collection_1.ListWrapper.last(this.records);
        if (lang_1.isPresent(newLast) && newLast !== oldLast) {
            newLast.lastInBinding = true;
            newLast.lastInDirective = true;
            this._setArgumentToPureFunction(numberOfRecordsBefore);
        }
    };
    /** @internal */
    ProtoRecordBuilder.prototype._setArgumentToPureFunction = function (startIndex) {
        var _this = this;
        for (var i = startIndex; i < this.records.length; ++i) {
            var rec = this.records[i];
            if (rec.isPureFunction()) {
                rec.args.forEach(function (recordIndex) { return _this.records[recordIndex - 1].argumentToPureFunction =
                    true; });
            }
            if (rec.mode === proto_record_1.RecordType.Pipe) {
                rec.args.forEach(function (recordIndex) { return _this.records[recordIndex - 1].argumentToPureFunction =
                    true; });
                this.records[rec.contextIndex - 1].argumentToPureFunction = true;
            }
        }
    };
    /** @internal */
    ProtoRecordBuilder.prototype._appendRecords = function (b, variableNames, bindingIndex) {
        if (b.isDirectiveLifecycle()) {
            this.records.push(new proto_record_1.ProtoRecord(proto_record_1.RecordType.DirectiveLifecycle, b.lifecycleEvent, null, [], [], -1, null, this.records.length + 1, b, false, false, false, false, null));
        }
        else {
            _ConvertAstIntoProtoRecords.append(this.records, b, variableNames, bindingIndex);
        }
    };
    return ProtoRecordBuilder;
})();
exports.ProtoRecordBuilder = ProtoRecordBuilder;
var _ConvertAstIntoProtoRecords = (function () {
    function _ConvertAstIntoProtoRecords(_records, _bindingRecord, _variableNames, _bindingIndex) {
        this._records = _records;
        this._bindingRecord = _bindingRecord;
        this._variableNames = _variableNames;
        this._bindingIndex = _bindingIndex;
    }
    _ConvertAstIntoProtoRecords.append = function (records, b, variableNames, bindingIndex) {
        var c = new _ConvertAstIntoProtoRecords(records, b, variableNames, bindingIndex);
        b.ast.visit(c);
    };
    _ConvertAstIntoProtoRecords.create = function (b, variableNames) {
        var rec = [];
        _ConvertAstIntoProtoRecords.append(rec, b, variableNames, null);
        rec[rec.length - 1].lastInBinding = true;
        return rec;
    };
    _ConvertAstIntoProtoRecords.prototype.visitImplicitReceiver = function (ast) { return this._bindingRecord.implicitReceiver; };
    _ConvertAstIntoProtoRecords.prototype.visitInterpolation = function (ast) {
        var args = this._visitAll(ast.expressions);
        return this._addRecord(proto_record_1.RecordType.Interpolate, "interpolate", _interpolationFn(ast.strings), args, ast.strings, 0);
    };
    _ConvertAstIntoProtoRecords.prototype.visitLiteralPrimitive = function (ast) {
        return this._addRecord(proto_record_1.RecordType.Const, "literal", ast.value, [], null, 0);
    };
    _ConvertAstIntoProtoRecords.prototype.visitPropertyRead = function (ast) {
        var receiver = ast.receiver.visit(this);
        if (lang_1.isPresent(this._variableNames) && collection_1.ListWrapper.contains(this._variableNames, ast.name) &&
            ast.receiver instanceof ast_1.ImplicitReceiver) {
            return this._addRecord(proto_record_1.RecordType.Local, ast.name, ast.name, [], null, receiver);
        }
        else {
            return this._addRecord(proto_record_1.RecordType.PropertyRead, ast.name, ast.getter, [], null, receiver);
        }
    };
    _ConvertAstIntoProtoRecords.prototype.visitPropertyWrite = function (ast) {
        if (lang_1.isPresent(this._variableNames) && collection_1.ListWrapper.contains(this._variableNames, ast.name) &&
            ast.receiver instanceof ast_1.ImplicitReceiver) {
            throw new exceptions_1.BaseException("Cannot reassign a variable binding " + ast.name);
        }
        else {
            var receiver = ast.receiver.visit(this);
            var value = ast.value.visit(this);
            return this._addRecord(proto_record_1.RecordType.PropertyWrite, ast.name, ast.setter, [value], null, receiver);
        }
    };
    _ConvertAstIntoProtoRecords.prototype.visitKeyedWrite = function (ast) {
        var obj = ast.obj.visit(this);
        var key = ast.key.visit(this);
        var value = ast.value.visit(this);
        return this._addRecord(proto_record_1.RecordType.KeyedWrite, null, null, [key, value], null, obj);
    };
    _ConvertAstIntoProtoRecords.prototype.visitSafePropertyRead = function (ast) {
        var receiver = ast.receiver.visit(this);
        return this._addRecord(proto_record_1.RecordType.SafeProperty, ast.name, ast.getter, [], null, receiver);
    };
    _ConvertAstIntoProtoRecords.prototype.visitMethodCall = function (ast) {
        var receiver = ast.receiver.visit(this);
        var args = this._visitAll(ast.args);
        if (lang_1.isPresent(this._variableNames) && collection_1.ListWrapper.contains(this._variableNames, ast.name)) {
            var target = this._addRecord(proto_record_1.RecordType.Local, ast.name, ast.name, [], null, receiver);
            return this._addRecord(proto_record_1.RecordType.InvokeClosure, "closure", null, args, null, target);
        }
        else {
            return this._addRecord(proto_record_1.RecordType.InvokeMethod, ast.name, ast.fn, args, null, receiver);
        }
    };
    _ConvertAstIntoProtoRecords.prototype.visitSafeMethodCall = function (ast) {
        var receiver = ast.receiver.visit(this);
        var args = this._visitAll(ast.args);
        return this._addRecord(proto_record_1.RecordType.SafeMethodInvoke, ast.name, ast.fn, args, null, receiver);
    };
    _ConvertAstIntoProtoRecords.prototype.visitFunctionCall = function (ast) {
        var target = ast.target.visit(this);
        var args = this._visitAll(ast.args);
        return this._addRecord(proto_record_1.RecordType.InvokeClosure, "closure", null, args, null, target);
    };
    _ConvertAstIntoProtoRecords.prototype.visitLiteralArray = function (ast) {
        var primitiveName = "arrayFn" + ast.expressions.length;
        return this._addRecord(proto_record_1.RecordType.CollectionLiteral, primitiveName, _arrayFn(ast.expressions.length), this._visitAll(ast.expressions), null, 0);
    };
    _ConvertAstIntoProtoRecords.prototype.visitLiteralMap = function (ast) {
        return this._addRecord(proto_record_1.RecordType.CollectionLiteral, _mapPrimitiveName(ast.keys), change_detection_util_1.ChangeDetectionUtil.mapFn(ast.keys), this._visitAll(ast.values), null, 0);
    };
    _ConvertAstIntoProtoRecords.prototype.visitBinary = function (ast) {
        var left = ast.left.visit(this);
        switch (ast.operation) {
            case '&&':
                var branchEnd = [null];
                this._addRecord(proto_record_1.RecordType.SkipRecordsIfNot, "SkipRecordsIfNot", null, [], branchEnd, left);
                var right = ast.right.visit(this);
                branchEnd[0] = right;
                return this._addRecord(proto_record_1.RecordType.PrimitiveOp, "cond", change_detection_util_1.ChangeDetectionUtil.cond, [left, right, left], null, 0);
            case '||':
                var branchEnd = [null];
                this._addRecord(proto_record_1.RecordType.SkipRecordsIf, "SkipRecordsIf", null, [], branchEnd, left);
                var right = ast.right.visit(this);
                branchEnd[0] = right;
                return this._addRecord(proto_record_1.RecordType.PrimitiveOp, "cond", change_detection_util_1.ChangeDetectionUtil.cond, [left, left, right], null, 0);
            default:
                var right = ast.right.visit(this);
                return this._addRecord(proto_record_1.RecordType.PrimitiveOp, _operationToPrimitiveName(ast.operation), _operationToFunction(ast.operation), [left, right], null, 0);
        }
    };
    _ConvertAstIntoProtoRecords.prototype.visitPrefixNot = function (ast) {
        var exp = ast.expression.visit(this);
        return this._addRecord(proto_record_1.RecordType.PrimitiveOp, "operation_negate", change_detection_util_1.ChangeDetectionUtil.operation_negate, [exp], null, 0);
    };
    _ConvertAstIntoProtoRecords.prototype.visitConditional = function (ast) {
        var condition = ast.condition.visit(this);
        var startOfFalseBranch = [null];
        var endOfFalseBranch = [null];
        this._addRecord(proto_record_1.RecordType.SkipRecordsIfNot, "SkipRecordsIfNot", null, [], startOfFalseBranch, condition);
        var whenTrue = ast.trueExp.visit(this);
        var skip = this._addRecord(proto_record_1.RecordType.SkipRecords, "SkipRecords", null, [], endOfFalseBranch, 0);
        var whenFalse = ast.falseExp.visit(this);
        startOfFalseBranch[0] = skip;
        endOfFalseBranch[0] = whenFalse;
        return this._addRecord(proto_record_1.RecordType.PrimitiveOp, "cond", change_detection_util_1.ChangeDetectionUtil.cond, [condition, whenTrue, whenFalse], null, 0);
    };
    _ConvertAstIntoProtoRecords.prototype.visitPipe = function (ast) {
        var value = ast.exp.visit(this);
        var args = this._visitAll(ast.args);
        return this._addRecord(proto_record_1.RecordType.Pipe, ast.name, ast.name, args, null, value);
    };
    _ConvertAstIntoProtoRecords.prototype.visitKeyedRead = function (ast) {
        var obj = ast.obj.visit(this);
        var key = ast.key.visit(this);
        return this._addRecord(proto_record_1.RecordType.KeyedRead, "keyedAccess", change_detection_util_1.ChangeDetectionUtil.keyedAccess, [key], null, obj);
    };
    _ConvertAstIntoProtoRecords.prototype.visitChain = function (ast) {
        var _this = this;
        var args = ast.expressions.map(function (e) { return e.visit(_this); });
        return this._addRecord(proto_record_1.RecordType.Chain, "chain", null, args, null, 0);
    };
    _ConvertAstIntoProtoRecords.prototype.visitQuote = function (ast) {
        throw new exceptions_1.BaseException(("Caught uninterpreted expression at " + ast.location + ": " + ast.uninterpretedExpression + ". ") +
            ("Expression prefix " + ast.prefix + " did not match a template transformer to interpret the expression."));
    };
    _ConvertAstIntoProtoRecords.prototype._visitAll = function (asts) {
        var res = collection_1.ListWrapper.createFixedSize(asts.length);
        for (var i = 0; i < asts.length; ++i) {
            res[i] = asts[i].visit(this);
        }
        return res;
    };
    /**
     * Adds a `ProtoRecord` and returns its selfIndex.
     */
    _ConvertAstIntoProtoRecords.prototype._addRecord = function (type, name, funcOrValue, args, fixedArgs, context) {
        var selfIndex = this._records.length + 1;
        if (context instanceof directive_record_1.DirectiveIndex) {
            this._records.push(new proto_record_1.ProtoRecord(type, name, funcOrValue, args, fixedArgs, -1, context, selfIndex, this._bindingRecord, false, false, false, false, this._bindingIndex));
        }
        else {
            this._records.push(new proto_record_1.ProtoRecord(type, name, funcOrValue, args, fixedArgs, context, null, selfIndex, this._bindingRecord, false, false, false, false, this._bindingIndex));
        }
        return selfIndex;
    };
    return _ConvertAstIntoProtoRecords;
})();
function _arrayFn(length) {
    switch (length) {
        case 0:
            return change_detection_util_1.ChangeDetectionUtil.arrayFn0;
        case 1:
            return change_detection_util_1.ChangeDetectionUtil.arrayFn1;
        case 2:
            return change_detection_util_1.ChangeDetectionUtil.arrayFn2;
        case 3:
            return change_detection_util_1.ChangeDetectionUtil.arrayFn3;
        case 4:
            return change_detection_util_1.ChangeDetectionUtil.arrayFn4;
        case 5:
            return change_detection_util_1.ChangeDetectionUtil.arrayFn5;
        case 6:
            return change_detection_util_1.ChangeDetectionUtil.arrayFn6;
        case 7:
            return change_detection_util_1.ChangeDetectionUtil.arrayFn7;
        case 8:
            return change_detection_util_1.ChangeDetectionUtil.arrayFn8;
        case 9:
            return change_detection_util_1.ChangeDetectionUtil.arrayFn9;
        default:
            throw new exceptions_1.BaseException("Does not support literal maps with more than 9 elements");
    }
}
function _mapPrimitiveName(keys) {
    var stringifiedKeys = keys.map(function (k) { return lang_1.isString(k) ? "\"" + k + "\"" : "" + k; }).join(', ');
    return "mapFn([" + stringifiedKeys + "])";
}
function _operationToPrimitiveName(operation) {
    switch (operation) {
        case '+':
            return "operation_add";
        case '-':
            return "operation_subtract";
        case '*':
            return "operation_multiply";
        case '/':
            return "operation_divide";
        case '%':
            return "operation_remainder";
        case '==':
            return "operation_equals";
        case '!=':
            return "operation_not_equals";
        case '===':
            return "operation_identical";
        case '!==':
            return "operation_not_identical";
        case '<':
            return "operation_less_then";
        case '>':
            return "operation_greater_then";
        case '<=':
            return "operation_less_or_equals_then";
        case '>=':
            return "operation_greater_or_equals_then";
        default:
            throw new exceptions_1.BaseException("Unsupported operation " + operation);
    }
}
function _operationToFunction(operation) {
    switch (operation) {
        case '+':
            return change_detection_util_1.ChangeDetectionUtil.operation_add;
        case '-':
            return change_detection_util_1.ChangeDetectionUtil.operation_subtract;
        case '*':
            return change_detection_util_1.ChangeDetectionUtil.operation_multiply;
        case '/':
            return change_detection_util_1.ChangeDetectionUtil.operation_divide;
        case '%':
            return change_detection_util_1.ChangeDetectionUtil.operation_remainder;
        case '==':
            return change_detection_util_1.ChangeDetectionUtil.operation_equals;
        case '!=':
            return change_detection_util_1.ChangeDetectionUtil.operation_not_equals;
        case '===':
            return change_detection_util_1.ChangeDetectionUtil.operation_identical;
        case '!==':
            return change_detection_util_1.ChangeDetectionUtil.operation_not_identical;
        case '<':
            return change_detection_util_1.ChangeDetectionUtil.operation_less_then;
        case '>':
            return change_detection_util_1.ChangeDetectionUtil.operation_greater_then;
        case '<=':
            return change_detection_util_1.ChangeDetectionUtil.operation_less_or_equals_then;
        case '>=':
            return change_detection_util_1.ChangeDetectionUtil.operation_greater_or_equals_then;
        default:
            throw new exceptions_1.BaseException("Unsupported operation " + operation);
    }
}
function s(v) {
    return lang_1.isPresent(v) ? "" + v : '';
}
function _interpolationFn(strings) {
    var length = strings.length;
    var c0 = length > 0 ? strings[0] : null;
    var c1 = length > 1 ? strings[1] : null;
    var c2 = length > 2 ? strings[2] : null;
    var c3 = length > 3 ? strings[3] : null;
    var c4 = length > 4 ? strings[4] : null;
    var c5 = length > 5 ? strings[5] : null;
    var c6 = length > 6 ? strings[6] : null;
    var c7 = length > 7 ? strings[7] : null;
    var c8 = length > 8 ? strings[8] : null;
    var c9 = length > 9 ? strings[9] : null;
    switch (length - 1) {
        case 1:
            return function (a1) { return c0 + s(a1) + c1; };
        case 2:
            return function (a1, a2) { return c0 + s(a1) + c1 + s(a2) + c2; };
        case 3:
            return function (a1, a2, a3) { return c0 + s(a1) + c1 + s(a2) + c2 + s(a3) + c3; };
        case 4:
            return function (a1, a2, a3, a4) { return c0 + s(a1) + c1 + s(a2) + c2 + s(a3) + c3 + s(a4) + c4; };
        case 5:
            return function (a1, a2, a3, a4, a5) {
                return c0 + s(a1) + c1 + s(a2) + c2 + s(a3) + c3 + s(a4) + c4 + s(a5) + c5;
            };
        case 6:
            return function (a1, a2, a3, a4, a5, a6) {
                return c0 + s(a1) + c1 + s(a2) + c2 + s(a3) + c3 + s(a4) + c4 + s(a5) + c5 + s(a6) + c6;
            };
        case 7:
            return function (a1, a2, a3, a4, a5, a6, a7) { return c0 + s(a1) + c1 + s(a2) + c2 + s(a3) + c3 + s(a4) +
                c4 + s(a5) + c5 + s(a6) + c6 + s(a7) + c7; };
        case 8:
            return function (a1, a2, a3, a4, a5, a6, a7, a8) { return c0 + s(a1) + c1 + s(a2) + c2 + s(a3) + c3 + s(a4) +
                c4 + s(a5) + c5 + s(a6) + c6 + s(a7) + c7 + s(a8) +
                c8; };
        case 9:
            return function (a1, a2, a3, a4, a5, a6, a7, a8, a9) { return c0 + s(a1) + c1 + s(a2) + c2 + s(a3) + c3 +
                s(a4) + c4 + s(a5) + c5 + s(a6) + c6 + s(a7) +
                c7 + s(a8) + c8 + s(a9) + c9; };
        default:
            throw new exceptions_1.BaseException("Does not support more than 9 expressions");
    }
}
//# sourceMappingURL=data:application/json;base64,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