'use strict';var __extends = (this && this.__extends) || function (d, b) {
    for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p];
    function __() { this.constructor = d; }
    d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
};
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var di_1 = require('angular2/src/core/di');
var compiler_1 = require('./compiler');
var lang_1 = require('angular2/src/facade/lang');
var view_manager_1 = require('angular2/src/core/linker/view_manager');
/**
 * Represents an instance of a Component created via {@link DynamicComponentLoader}.
 *
 * `ComponentRef` provides access to the Component Instance as well other objects related to this
 * Component Instance and allows you to destroy the Component Instance via the {@link #dispose}
 * method.
 */
var ComponentRef = (function () {
    function ComponentRef() {
    }
    Object.defineProperty(ComponentRef.prototype, "hostView", {
        /**
         * The {@link ViewRef} of the Host View of this Component instance.
         */
        get: function () { return this.location.parentView; },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(ComponentRef.prototype, "hostComponent", {
        /**
         * @internal
         *
         * The instance of the component.
         *
         * TODO(i): this api should be removed
         */
        get: function () { return this.instance; },
        enumerable: true,
        configurable: true
    });
    return ComponentRef;
})();
exports.ComponentRef = ComponentRef;
var ComponentRef_ = (function (_super) {
    __extends(ComponentRef_, _super);
    /**
     * TODO(i): refactor into public/private fields
     */
    function ComponentRef_(location, instance, componentType, injector, _dispose) {
        _super.call(this);
        this._dispose = _dispose;
        this.location = location;
        this.instance = instance;
        this.componentType = componentType;
        this.injector = injector;
    }
    Object.defineProperty(ComponentRef_.prototype, "hostComponentType", {
        /**
         * @internal
         *
         * Returns the type of this Component instance.
         *
         * TODO(i): this api should be removed
         */
        get: function () { return this.componentType; },
        enumerable: true,
        configurable: true
    });
    ComponentRef_.prototype.dispose = function () { this._dispose(); };
    return ComponentRef_;
})(ComponentRef);
exports.ComponentRef_ = ComponentRef_;
/**
 * Service for instantiating a Component and attaching it to a View at a specified location.
 */
var DynamicComponentLoader = (function () {
    function DynamicComponentLoader() {
    }
    return DynamicComponentLoader;
})();
exports.DynamicComponentLoader = DynamicComponentLoader;
var DynamicComponentLoader_ = (function (_super) {
    __extends(DynamicComponentLoader_, _super);
    function DynamicComponentLoader_(_compiler, _viewManager) {
        _super.call(this);
        this._compiler = _compiler;
        this._viewManager = _viewManager;
    }
    DynamicComponentLoader_.prototype.loadAsRoot = function (type, overrideSelector, injector, onDispose) {
        var _this = this;
        return this._compiler.compileInHost(type).then(function (hostProtoViewRef) {
            var hostViewRef = _this._viewManager.createRootHostView(hostProtoViewRef, overrideSelector, injector);
            var newLocation = _this._viewManager.getHostElement(hostViewRef);
            var component = _this._viewManager.getComponent(newLocation);
            var dispose = function () {
                if (lang_1.isPresent(onDispose)) {
                    onDispose();
                }
                _this._viewManager.destroyRootHostView(hostViewRef);
            };
            return new ComponentRef_(newLocation, component, type, injector, dispose);
        });
    };
    DynamicComponentLoader_.prototype.loadIntoLocation = function (type, hostLocation, anchorName, providers) {
        if (providers === void 0) { providers = null; }
        return this.loadNextToLocation(type, this._viewManager.getNamedElementInComponentView(hostLocation, anchorName), providers);
    };
    DynamicComponentLoader_.prototype.loadNextToLocation = function (type, location, providers) {
        var _this = this;
        if (providers === void 0) { providers = null; }
        return this._compiler.compileInHost(type).then(function (hostProtoViewRef) {
            var viewContainer = _this._viewManager.getViewContainer(location);
            var hostViewRef = viewContainer.createHostView(hostProtoViewRef, viewContainer.length, providers);
            var newLocation = _this._viewManager.getHostElement(hostViewRef);
            var component = _this._viewManager.getComponent(newLocation);
            var dispose = function () {
                var index = viewContainer.indexOf(hostViewRef);
                if (index !== -1) {
                    viewContainer.remove(index);
                }
            };
            return new ComponentRef_(newLocation, component, type, null, dispose);
        });
    };
    DynamicComponentLoader_ = __decorate([
        di_1.Injectable(), 
        __metadata('design:paramtypes', [compiler_1.Compiler, view_manager_1.AppViewManager])
    ], DynamicComponentLoader_);
    return DynamicComponentLoader_;
})(DynamicComponentLoader);
exports.DynamicComponentLoader_ = DynamicComponentLoader_;
//# sourceMappingURL=data:application/json;base64,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