'use strict';var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var __param = (this && this.__param) || function (paramIndex, decorator) {
    return function (target, key) { decorator(target, key, paramIndex); }
};
var lang_1 = require('angular2/src/facade/lang');
var api_1 = require('angular2/src/core/render/api');
var di_1 = require('angular2/src/core/di');
var pipe_provider_1 = require('../pipes/pipe_provider');
var pipes_1 = require('../pipes/pipes');
var view_1 = require('./view');
var element_binder_1 = require('./element_binder');
var element_injector_1 = require('./element_injector');
var directive_resolver_1 = require('./directive_resolver');
var view_resolver_1 = require('./view_resolver');
var pipe_resolver_1 = require('./pipe_resolver');
var view_2 = require('../metadata/view');
var platform_directives_and_pipes_1 = require('angular2/src/core/platform_directives_and_pipes');
var template_commands_1 = require('./template_commands');
var api_2 = require('angular2/src/core/render/api');
var application_tokens_1 = require('angular2/src/core/application_tokens');
var ProtoViewFactory = (function () {
    function ProtoViewFactory(_renderer, _platformPipes, _directiveResolver, _viewResolver, _pipeResolver, _appId) {
        this._renderer = _renderer;
        this._platformPipes = _platformPipes;
        this._directiveResolver = _directiveResolver;
        this._viewResolver = _viewResolver;
        this._pipeResolver = _pipeResolver;
        this._appId = _appId;
        this._cache = new Map();
        this._nextTemplateId = 0;
    }
    ProtoViewFactory.prototype.clearCache = function () { this._cache.clear(); };
    ProtoViewFactory.prototype.createHost = function (compiledHostTemplate) {
        var compiledTemplate = compiledHostTemplate.template;
        var result = this._cache.get(compiledTemplate.id);
        if (lang_1.isBlank(result)) {
            var emptyMap = {};
            var shortId = this._appId + "-" + this._nextTemplateId++;
            this._renderer.registerComponentTemplate(new api_1.RenderComponentTemplate(compiledTemplate.id, shortId, view_2.ViewEncapsulation.None, compiledTemplate.commands, []));
            result =
                new view_1.AppProtoView(compiledTemplate.id, compiledTemplate.commands, view_1.ViewType.HOST, true, compiledTemplate.changeDetectorFactory, null, new pipes_1.ProtoPipes(emptyMap));
            this._cache.set(compiledTemplate.id, result);
        }
        return result;
    };
    ProtoViewFactory.prototype._createComponent = function (cmd) {
        var _this = this;
        var nestedProtoView = this._cache.get(cmd.templateId);
        if (lang_1.isBlank(nestedProtoView)) {
            var component = cmd.directives[0];
            var view = this._viewResolver.resolve(component);
            var compiledTemplate = cmd.templateGetter();
            var styles = _flattenStyleArr(compiledTemplate.styles, []);
            var shortId = this._appId + "-" + this._nextTemplateId++;
            this._renderer.registerComponentTemplate(new api_1.RenderComponentTemplate(compiledTemplate.id, shortId, cmd.encapsulation, compiledTemplate.commands, styles));
            var boundPipes = this._flattenPipes(view).map(function (pipe) { return _this._bindPipe(pipe); });
            nestedProtoView = new view_1.AppProtoView(compiledTemplate.id, compiledTemplate.commands, view_1.ViewType.COMPONENT, true, compiledTemplate.changeDetectorFactory, null, pipes_1.ProtoPipes.fromProviders(boundPipes));
            // Note: The cache is updated before recursing
            // to be able to resolve cycles
            this._cache.set(compiledTemplate.id, nestedProtoView);
            this._initializeProtoView(nestedProtoView, null);
        }
        return nestedProtoView;
    };
    ProtoViewFactory.prototype._createEmbeddedTemplate = function (cmd, parent) {
        var nestedProtoView = new view_1.AppProtoView(parent.templateId, cmd.children, view_1.ViewType.EMBEDDED, cmd.isMerged, cmd.changeDetectorFactory, arrayToMap(cmd.variableNameAndValues, true), new pipes_1.ProtoPipes(parent.pipes.config));
        if (cmd.isMerged) {
            this.initializeProtoViewIfNeeded(nestedProtoView);
        }
        return nestedProtoView;
    };
    ProtoViewFactory.prototype.initializeProtoViewIfNeeded = function (protoView) {
        if (!protoView.isInitialized()) {
            var render = this._renderer.createProtoView(protoView.templateId, protoView.templateCmds);
            this._initializeProtoView(protoView, render);
        }
    };
    ProtoViewFactory.prototype._initializeProtoView = function (protoView, render) {
        var initializer = new _ProtoViewInitializer(protoView, this._directiveResolver, this);
        template_commands_1.visitAllCommands(initializer, protoView.templateCmds);
        var mergeInfo = new view_1.AppProtoViewMergeInfo(initializer.mergeEmbeddedViewCount, initializer.mergeElementCount, initializer.mergeViewCount);
        protoView.init(render, initializer.elementBinders, initializer.boundTextCount, mergeInfo, initializer.variableLocations);
    };
    ProtoViewFactory.prototype._bindPipe = function (typeOrProvider) {
        var meta = this._pipeResolver.resolve(typeOrProvider);
        return pipe_provider_1.PipeProvider.createFromType(typeOrProvider, meta);
    };
    ProtoViewFactory.prototype._flattenPipes = function (view) {
        var pipes = [];
        if (lang_1.isPresent(this._platformPipes)) {
            _flattenArray(this._platformPipes, pipes);
        }
        if (lang_1.isPresent(view.pipes)) {
            _flattenArray(view.pipes, pipes);
        }
        return pipes;
    };
    ProtoViewFactory = __decorate([
        di_1.Injectable(),
        __param(1, di_1.Optional()),
        __param(1, di_1.Inject(platform_directives_and_pipes_1.PLATFORM_PIPES)),
        __param(5, di_1.Inject(application_tokens_1.APP_ID)), 
        __metadata('design:paramtypes', [api_2.Renderer, Array, directive_resolver_1.DirectiveResolver, view_resolver_1.ViewResolver, pipe_resolver_1.PipeResolver, String])
    ], ProtoViewFactory);
    return ProtoViewFactory;
})();
exports.ProtoViewFactory = ProtoViewFactory;
function createComponent(protoViewFactory, cmd) {
    return protoViewFactory._createComponent(cmd);
}
function createEmbeddedTemplate(protoViewFactory, cmd, parent) {
    return protoViewFactory._createEmbeddedTemplate(cmd, parent);
}
var _ProtoViewInitializer = (function () {
    function _ProtoViewInitializer(_protoView, _directiveResolver, _protoViewFactory) {
        this._protoView = _protoView;
        this._directiveResolver = _directiveResolver;
        this._protoViewFactory = _protoViewFactory;
        this.variableLocations = new Map();
        this.boundTextCount = 0;
        this.boundElementIndex = 0;
        this.elementBinderStack = [];
        this.distanceToParentElementBinder = 0;
        this.distanceToParentProtoElementInjector = 0;
        this.elementBinders = [];
        this.mergeEmbeddedViewCount = 0;
        this.mergeElementCount = 0;
        this.mergeViewCount = 1;
    }
    _ProtoViewInitializer.prototype.visitText = function (cmd, context) {
        if (cmd.isBound) {
            this.boundTextCount++;
        }
        return null;
    };
    _ProtoViewInitializer.prototype.visitNgContent = function (cmd, context) { return null; };
    _ProtoViewInitializer.prototype.visitBeginElement = function (cmd, context) {
        if (cmd.isBound) {
            this._visitBeginBoundElement(cmd, null);
        }
        else {
            this._visitBeginElement(cmd, null, null);
        }
        return null;
    };
    _ProtoViewInitializer.prototype.visitEndElement = function (context) { return this._visitEndElement(); };
    _ProtoViewInitializer.prototype.visitBeginComponent = function (cmd, context) {
        var nestedProtoView = createComponent(this._protoViewFactory, cmd);
        return this._visitBeginBoundElement(cmd, nestedProtoView);
    };
    _ProtoViewInitializer.prototype.visitEndComponent = function (context) { return this._visitEndElement(); };
    _ProtoViewInitializer.prototype.visitEmbeddedTemplate = function (cmd, context) {
        var nestedProtoView = createEmbeddedTemplate(this._protoViewFactory, cmd, this._protoView);
        if (cmd.isMerged) {
            this.mergeEmbeddedViewCount++;
        }
        this._visitBeginBoundElement(cmd, nestedProtoView);
        return this._visitEndElement();
    };
    _ProtoViewInitializer.prototype._visitBeginBoundElement = function (cmd, nestedProtoView) {
        if (lang_1.isPresent(nestedProtoView) && nestedProtoView.isMergable) {
            this.mergeElementCount += nestedProtoView.mergeInfo.elementCount;
            this.mergeViewCount += nestedProtoView.mergeInfo.viewCount;
            this.mergeEmbeddedViewCount += nestedProtoView.mergeInfo.embeddedViewCount;
        }
        var elementBinder = _createElementBinder(this._directiveResolver, nestedProtoView, this.elementBinderStack, this.boundElementIndex, this.distanceToParentElementBinder, this.distanceToParentProtoElementInjector, cmd);
        this.elementBinders.push(elementBinder);
        var protoElementInjector = elementBinder.protoElementInjector;
        for (var i = 0; i < cmd.variableNameAndValues.length; i += 2) {
            this.variableLocations.set(cmd.variableNameAndValues[i], this.boundElementIndex);
        }
        this.boundElementIndex++;
        this.mergeElementCount++;
        return this._visitBeginElement(cmd, elementBinder, protoElementInjector);
    };
    _ProtoViewInitializer.prototype._visitBeginElement = function (cmd, elementBinder, protoElementInjector) {
        this.distanceToParentElementBinder =
            lang_1.isPresent(elementBinder) ? 1 : this.distanceToParentElementBinder + 1;
        this.distanceToParentProtoElementInjector =
            lang_1.isPresent(protoElementInjector) ? 1 : this.distanceToParentProtoElementInjector + 1;
        this.elementBinderStack.push(elementBinder);
        return null;
    };
    _ProtoViewInitializer.prototype._visitEndElement = function () {
        var parentElementBinder = this.elementBinderStack.pop();
        var parentProtoElementInjector = lang_1.isPresent(parentElementBinder) ? parentElementBinder.protoElementInjector : null;
        this.distanceToParentElementBinder = lang_1.isPresent(parentElementBinder) ?
            parentElementBinder.distanceToParent :
            this.distanceToParentElementBinder - 1;
        this.distanceToParentProtoElementInjector = lang_1.isPresent(parentProtoElementInjector) ?
            parentProtoElementInjector.distanceToParent :
            this.distanceToParentProtoElementInjector - 1;
        return null;
    };
    return _ProtoViewInitializer;
})();
function _createElementBinder(directiveResolver, nestedProtoView, elementBinderStack, boundElementIndex, distanceToParentBinder, distanceToParentPei, beginElementCmd) {
    var parentElementBinder = null;
    var parentProtoElementInjector = null;
    if (distanceToParentBinder > 0) {
        parentElementBinder = elementBinderStack[elementBinderStack.length - distanceToParentBinder];
    }
    if (lang_1.isBlank(parentElementBinder)) {
        distanceToParentBinder = -1;
    }
    if (distanceToParentPei > 0) {
        var peiBinder = elementBinderStack[elementBinderStack.length - distanceToParentPei];
        if (lang_1.isPresent(peiBinder)) {
            parentProtoElementInjector = peiBinder.protoElementInjector;
        }
    }
    if (lang_1.isBlank(parentProtoElementInjector)) {
        distanceToParentPei = -1;
    }
    var componentDirectiveProvider = null;
    var isEmbeddedTemplate = false;
    var directiveProviders = beginElementCmd.directives.map(function (type) { return provideDirective(directiveResolver, type); });
    if (beginElementCmd instanceof template_commands_1.BeginComponentCmd) {
        componentDirectiveProvider = directiveProviders[0];
    }
    else if (beginElementCmd instanceof template_commands_1.EmbeddedTemplateCmd) {
        isEmbeddedTemplate = true;
    }
    var protoElementInjector = null;
    // Create a protoElementInjector for any element that either has bindings *or* has one
    // or more var- defined *or* for <template> elements:
    // - Elements with a var- defined need a their own element injector
    //   so that, when hydrating, $implicit can be set to the element.
    // - <template> elements need their own ElementInjector so that we can query their TemplateRef
    var hasVariables = beginElementCmd.variableNameAndValues.length > 0;
    if (directiveProviders.length > 0 || hasVariables || isEmbeddedTemplate) {
        var directiveVariableBindings = new Map();
        if (!isEmbeddedTemplate) {
            directiveVariableBindings = createDirectiveVariableBindings(beginElementCmd.variableNameAndValues, directiveProviders);
        }
        protoElementInjector = element_injector_1.ProtoElementInjector.create(parentProtoElementInjector, boundElementIndex, directiveProviders, lang_1.isPresent(componentDirectiveProvider), distanceToParentPei, directiveVariableBindings);
        protoElementInjector.attributes = arrayToMap(beginElementCmd.attrNameAndValues, false);
    }
    return new element_binder_1.ElementBinder(boundElementIndex, parentElementBinder, distanceToParentBinder, protoElementInjector, componentDirectiveProvider, nestedProtoView);
}
function provideDirective(directiveResolver, type) {
    var annotation = directiveResolver.resolve(type);
    return element_injector_1.DirectiveProvider.createFromType(type, annotation);
}
function createDirectiveVariableBindings(variableNameAndValues, directiveProviders) {
    var directiveVariableBindings = new Map();
    for (var i = 0; i < variableNameAndValues.length; i += 2) {
        var templateName = variableNameAndValues[i];
        var dirIndex = variableNameAndValues[i + 1];
        if (lang_1.isNumber(dirIndex)) {
            directiveVariableBindings.set(templateName, dirIndex);
        }
        else {
            // a variable without a directive index -> reference the element
            directiveVariableBindings.set(templateName, null);
        }
    }
    return directiveVariableBindings;
}
exports.createDirectiveVariableBindings = createDirectiveVariableBindings;
function arrayToMap(arr, inverse) {
    var result = new Map();
    for (var i = 0; i < arr.length; i += 2) {
        if (inverse) {
            result.set(arr[i + 1], arr[i]);
        }
        else {
            result.set(arr[i], arr[i + 1]);
        }
    }
    return result;
}
function _flattenArray(tree, out) {
    for (var i = 0; i < tree.length; i++) {
        var item = di_1.resolveForwardRef(tree[i]);
        if (lang_1.isArray(item)) {
            _flattenArray(item, out);
        }
        else {
            out.push(item);
        }
    }
}
function _flattenStyleArr(arr, out) {
    for (var i = 0; i < arr.length; i++) {
        var entry = arr[i];
        if (lang_1.isArray(entry)) {
            _flattenStyleArr(entry, out);
        }
        else {
            out.push(entry);
        }
    }
    return out;
}
//# sourceMappingURL=data:application/json;base64,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