'use strict';var lang_1 = require('angular2/src/facade/lang');
var view_1 = require('./view');
var metadata_1 = require('angular2/src/core/metadata');
var collection_1 = require('angular2/src/facade/collection');
function encapsulateStyles(componentTemplate) {
    var processedStyles = componentTemplate.styles;
    if (componentTemplate.encapsulation === metadata_1.ViewEncapsulation.Emulated) {
        processedStyles = collection_1.ListWrapper.createFixedSize(componentTemplate.styles.length);
        for (var i = 0; i < componentTemplate.styles.length; i++) {
            processedStyles[i] = lang_1.StringWrapper.replaceAll(componentTemplate.styles[i], COMPONENT_REGEX, componentTemplate.shortId);
        }
    }
    return processedStyles;
}
exports.encapsulateStyles = encapsulateStyles;
function createRenderView(componentTemplate, cmds, inplaceElement, nodeFactory) {
    var view;
    var eventDispatcher = function (boundElementIndex, eventName, event) {
        return view.dispatchRenderEvent(boundElementIndex, eventName, event);
    };
    var context = new BuildContext(eventDispatcher, nodeFactory, inplaceElement);
    context.build(componentTemplate, cmds);
    var fragments = [];
    for (var i = 0; i < context.fragments.length; i++) {
        fragments.push(new view_1.DefaultRenderFragmentRef(context.fragments[i]));
    }
    view = new view_1.DefaultRenderView(fragments, context.boundTextNodes, context.boundElements, context.nativeShadowRoots, context.globalEventAdders, context.rootContentInsertionPoints);
    return view;
}
exports.createRenderView = createRenderView;
var BuildContext = (function () {
    function BuildContext(_eventDispatcher, factory, _inplaceElement) {
        this._eventDispatcher = _eventDispatcher;
        this.factory = factory;
        this._inplaceElement = _inplaceElement;
        this._builders = [];
        this.globalEventAdders = [];
        this.boundElements = [];
        this.boundTextNodes = [];
        this.nativeShadowRoots = [];
        this.fragments = [];
        this.rootContentInsertionPoints = [];
        this.componentCount = 0;
        this.isHost = lang_1.isPresent((_inplaceElement));
    }
    BuildContext.prototype.build = function (template, cmds) {
        this.enqueueRootBuilder(template, cmds);
        this._build(this._builders[0]);
    };
    BuildContext.prototype._build = function (builder) {
        this._builders = [];
        builder.build(this);
        var enqueuedBuilders = this._builders;
        for (var i = 0; i < enqueuedBuilders.length; i++) {
            this._build(enqueuedBuilders[i]);
        }
    };
    BuildContext.prototype.enqueueComponentBuilder = function (component) {
        this.componentCount++;
        this._builders.push(new RenderViewBuilder(component, null, component.template, component.template.commands));
    };
    BuildContext.prototype.enqueueFragmentBuilder = function (parentComponent, parentTemplate, commands) {
        var rootNodes = [];
        this.fragments.push(rootNodes);
        this._builders.push(new RenderViewBuilder(parentComponent, rootNodes, parentTemplate, commands));
    };
    BuildContext.prototype.enqueueRootBuilder = function (template, cmds) {
        var rootNodes = [];
        this.fragments.push(rootNodes);
        this._builders.push(new RenderViewBuilder(null, rootNodes, template, cmds));
    };
    BuildContext.prototype.consumeInplaceElement = function () {
        var result = this._inplaceElement;
        this._inplaceElement = null;
        return result;
    };
    BuildContext.prototype.addEventListener = function (boundElementIndex, target, eventName) {
        if (lang_1.isPresent(target)) {
            var handler = createEventHandler(boundElementIndex, target + ":" + eventName, this._eventDispatcher);
            this.globalEventAdders.push(createGlobalEventAdder(target, eventName, handler, this.factory));
        }
        else {
            var handler = createEventHandler(boundElementIndex, eventName, this._eventDispatcher);
            this.factory.on(this.boundElements[boundElementIndex], eventName, handler);
        }
    };
    return BuildContext;
})();
function createEventHandler(boundElementIndex, eventName, eventDispatcher) {
    return function ($event) { return eventDispatcher(boundElementIndex, eventName, $event); };
}
function createGlobalEventAdder(target, eventName, eventHandler, nodeFactory) {
    return function () { return nodeFactory.globalOn(target, eventName, eventHandler); };
}
var RenderViewBuilder = (function () {
    function RenderViewBuilder(parentComponent, fragmentRootNodes, template, cmds) {
        this.parentComponent = parentComponent;
        this.fragmentRootNodes = fragmentRootNodes;
        this.template = template;
        this.cmds = cmds;
        var rootNodesParent = lang_1.isPresent(fragmentRootNodes) ? null : parentComponent.shadowRoot;
        this.parentStack = [rootNodesParent];
    }
    RenderViewBuilder.prototype.build = function (context) {
        var cmds = this.cmds;
        for (var i = 0; i < cmds.length; i++) {
            cmds[i].visit(this, context);
        }
    };
    Object.defineProperty(RenderViewBuilder.prototype, "parent", {
        get: function () { return this.parentStack[this.parentStack.length - 1]; },
        enumerable: true,
        configurable: true
    });
    RenderViewBuilder.prototype.visitText = function (cmd, context) {
        var text = context.factory.createText(cmd.value);
        this._addChild(text, cmd.ngContentIndex, context);
        if (cmd.isBound) {
            context.boundTextNodes.push(text);
        }
        return null;
    };
    RenderViewBuilder.prototype.visitNgContent = function (cmd, context) {
        if (lang_1.isPresent(this.parentComponent)) {
            if (this.parentComponent.isRoot) {
                var insertionPoint = context.factory.createRootContentInsertionPoint();
                if (this.parent instanceof Component) {
                    context.factory.appendChild(this.parent.shadowRoot, insertionPoint);
                }
                else {
                    context.factory.appendChild(this.parent, insertionPoint);
                }
                context.rootContentInsertionPoints.push(insertionPoint);
            }
            else {
                var projectedNodes = this.parentComponent.project(cmd.index);
                for (var i = 0; i < projectedNodes.length; i++) {
                    var node = projectedNodes[i];
                    this._addChild(node, cmd.ngContentIndex, context);
                }
            }
        }
        return null;
    };
    RenderViewBuilder.prototype.visitBeginElement = function (cmd, context) {
        this.parentStack.push(this._beginElement(cmd, context, null));
        return null;
    };
    RenderViewBuilder.prototype.visitEndElement = function (context) {
        this._endElement();
        return null;
    };
    RenderViewBuilder.prototype.visitBeginComponent = function (cmd, context) {
        var templateId = cmd.templateId;
        var tpl = context.factory.resolveComponentTemplate(templateId);
        var el = this._beginElement(cmd, context, tpl);
        var root = el;
        if (tpl.encapsulation === metadata_1.ViewEncapsulation.Native) {
            root = context.factory.createShadowRoot(el, templateId);
            context.nativeShadowRoots.push(root);
        }
        var isRoot = context.componentCount === 0 && context.isHost;
        var component = new Component(el, root, isRoot, tpl);
        context.enqueueComponentBuilder(component);
        this.parentStack.push(component);
        return null;
    };
    RenderViewBuilder.prototype.visitEndComponent = function (context) {
        this._endElement();
        return null;
    };
    RenderViewBuilder.prototype.visitEmbeddedTemplate = function (cmd, context) {
        var el = context.factory.createTemplateAnchor(cmd.attrNameAndValues);
        this._addChild(el, cmd.ngContentIndex, context);
        context.boundElements.push(el);
        if (cmd.isMerged) {
            context.enqueueFragmentBuilder(this.parentComponent, this.template, cmd.children);
        }
        return null;
    };
    RenderViewBuilder.prototype._beginElement = function (cmd, context, componentTemplate) {
        var el = context.consumeInplaceElement();
        var attrNameAndValues = cmd.attrNameAndValues;
        var templateEmulatedEncapsulation = this.template.encapsulation === metadata_1.ViewEncapsulation.Emulated;
        var componentEmulatedEncapsulation = lang_1.isPresent(componentTemplate) &&
            componentTemplate.encapsulation === metadata_1.ViewEncapsulation.Emulated;
        var newAttrLength = attrNameAndValues.length + (templateEmulatedEncapsulation ? 2 : 0) +
            (componentEmulatedEncapsulation ? 2 : 0);
        if (newAttrLength > attrNameAndValues.length) {
            // Note: Need to clone attrNameAndValues to make it writable!
            var newAttrNameAndValues = collection_1.ListWrapper.createFixedSize(newAttrLength);
            var attrIndex;
            for (attrIndex = 0; attrIndex < attrNameAndValues.length; attrIndex++) {
                newAttrNameAndValues[attrIndex] = attrNameAndValues[attrIndex];
            }
            if (templateEmulatedEncapsulation) {
                newAttrNameAndValues[attrIndex++] = _shimContentAttribute(this.template.shortId);
                newAttrNameAndValues[attrIndex++] = '';
            }
            if (componentEmulatedEncapsulation) {
                newAttrNameAndValues[attrIndex++] = _shimHostAttribute(componentTemplate.shortId);
                newAttrNameAndValues[attrIndex++] = '';
            }
            attrNameAndValues = newAttrNameAndValues;
        }
        if (lang_1.isPresent(el)) {
            context.factory.mergeElement(el, attrNameAndValues);
            this.fragmentRootNodes.push(el);
        }
        else {
            el = context.factory.createElement(cmd.name, attrNameAndValues);
            this._addChild(el, cmd.ngContentIndex, context);
        }
        if (cmd.isBound) {
            var boundElementIndex = context.boundElements.length;
            context.boundElements.push(el);
            for (var i = 0; i < cmd.eventTargetAndNames.length; i += 2) {
                var target = cmd.eventTargetAndNames[i];
                var eventName = cmd.eventTargetAndNames[i + 1];
                context.addEventListener(boundElementIndex, target, eventName);
            }
        }
        return el;
    };
    RenderViewBuilder.prototype._endElement = function () { this.parentStack.pop(); };
    RenderViewBuilder.prototype._addChild = function (node, ngContentIndex, context) {
        var parent = this.parent;
        if (lang_1.isPresent(parent)) {
            if (parent instanceof Component) {
                parent.addContentNode(ngContentIndex, node, context);
            }
            else {
                context.factory.appendChild(parent, node);
            }
        }
        else {
            this.fragmentRootNodes.push(node);
        }
    };
    return RenderViewBuilder;
})();
var Component = (function () {
    function Component(hostElement, shadowRoot, isRoot, template) {
        this.hostElement = hostElement;
        this.shadowRoot = shadowRoot;
        this.isRoot = isRoot;
        this.template = template;
        this.contentNodesByNgContentIndex = [];
    }
    Component.prototype.addContentNode = function (ngContentIndex, node, context) {
        if (lang_1.isBlank(ngContentIndex)) {
            if (this.template.encapsulation === metadata_1.ViewEncapsulation.Native) {
                context.factory.appendChild(this.hostElement, node);
            }
        }
        else {
            while (this.contentNodesByNgContentIndex.length <= ngContentIndex) {
                this.contentNodesByNgContentIndex.push([]);
            }
            this.contentNodesByNgContentIndex[ngContentIndex].push(node);
        }
    };
    Component.prototype.project = function (ngContentIndex) {
        return ngContentIndex < this.contentNodesByNgContentIndex.length ?
            this.contentNodesByNgContentIndex[ngContentIndex] :
            [];
    };
    return Component;
})();
var COMPONENT_REGEX = /%COMP%/g;
exports.COMPONENT_VARIABLE = '%COMP%';
exports.HOST_ATTR = "_nghost-" + exports.COMPONENT_VARIABLE;
exports.CONTENT_ATTR = "_ngcontent-" + exports.COMPONENT_VARIABLE;
function _shimContentAttribute(componentShortId) {
    return lang_1.StringWrapper.replaceAll(exports.CONTENT_ATTR, COMPONENT_REGEX, componentShortId);
}
function _shimHostAttribute(componentShortId) {
    return lang_1.StringWrapper.replaceAll(exports.HOST_ATTR, COMPONENT_REGEX, componentShortId);
}
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoidmlld19mYWN0b3J5LmpzIiwic291cmNlUm9vdCI6IiIsInNvdXJjZXMiOlsiYW5ndWxhcjIvc3JjL2NvcmUvcmVuZGVyL3ZpZXdfZmFjdG9yeS50cyJdLCJuYW1lcyI6WyJlbmNhcHN1bGF0ZVN0eWxlcyIsImNyZWF0ZVJlbmRlclZpZXciLCJCdWlsZENvbnRleHQiLCJCdWlsZENvbnRleHQuY29uc3RydWN0b3IiLCJCdWlsZENvbnRleHQuYnVpbGQiLCJCdWlsZENvbnRleHQuX2J1aWxkIiwiQnVpbGRDb250ZXh0LmVucXVldWVDb21wb25lbnRCdWlsZGVyIiwiQnVpbGRDb250ZXh0LmVucXVldWVGcmFnbWVudEJ1aWxkZXIiLCJCdWlsZENvbnRleHQuZW5xdWV1ZVJvb3RCdWlsZGVyIiwiQnVpbGRDb250ZXh0LmNvbnN1bWVJbnBsYWNlRWxlbWVudCIsIkJ1aWxkQ29udGV4dC5hZGRFdmVudExpc3RlbmVyIiwiY3JlYXRlRXZlbnRIYW5kbGVyIiwiY3JlYXRlR2xvYmFsRXZlbnRBZGRlciIsIlJlbmRlclZpZXdCdWlsZGVyIiwiUmVuZGVyVmlld0J1aWxkZXIuY29uc3RydWN0b3IiLCJSZW5kZXJWaWV3QnVpbGRlci5idWlsZCIsIlJlbmRlclZpZXdCdWlsZGVyLnBhcmVudCIsIlJlbmRlclZpZXdCdWlsZGVyLnZpc2l0VGV4dCIsIlJlbmRlclZpZXdCdWlsZGVyLnZpc2l0TmdDb250ZW50IiwiUmVuZGVyVmlld0J1aWxkZXIudmlzaXRCZWdpbkVsZW1lbnQiLCJSZW5kZXJWaWV3QnVpbGRlci52aXNpdEVuZEVsZW1lbnQiLCJSZW5kZXJWaWV3QnVpbGRlci52aXNpdEJlZ2luQ29tcG9uZW50IiwiUmVuZGVyVmlld0J1aWxkZXIudmlzaXRFbmRDb21wb25lbnQiLCJSZW5kZXJWaWV3QnVpbGRlci52aXNpdEVtYmVkZGVkVGVtcGxhdGUiLCJSZW5kZXJWaWV3QnVpbGRlci5fYmVnaW5FbGVtZW50IiwiUmVuZGVyVmlld0J1aWxkZXIuX2VuZEVsZW1lbnQiLCJSZW5kZXJWaWV3QnVpbGRlci5fYWRkQ2hpbGQiLCJDb21wb25lbnQiLCJDb21wb25lbnQuY29uc3RydWN0b3IiLCJDb21wb25lbnQuYWRkQ29udGVudE5vZGUiLCJDb21wb25lbnQucHJvamVjdCIsIl9zaGltQ29udGVudEF0dHJpYnV0ZSIsIl9zaGltSG9zdEF0dHJpYnV0ZSJdLCJtYXBwaW5ncyI6IkFBQUEscUJBQWdELDBCQUEwQixDQUFDLENBQUE7QUFZM0UscUJBQTBELFFBQVEsQ0FBQyxDQUFBO0FBQ25FLHlCQUFnQyw0QkFBNEIsQ0FBQyxDQUFBO0FBQzdELDJCQUEwQixnQ0FBZ0MsQ0FBQyxDQUFBO0FBRzNELDJCQUFrQyxpQkFBMEM7SUFDMUVBLElBQUlBLGVBQWVBLEdBQUdBLGlCQUFpQkEsQ0FBQ0EsTUFBTUEsQ0FBQ0E7SUFDL0NBLEVBQUVBLENBQUNBLENBQUNBLGlCQUFpQkEsQ0FBQ0EsYUFBYUEsS0FBS0EsNEJBQWlCQSxDQUFDQSxRQUFRQSxDQUFDQSxDQUFDQSxDQUFDQTtRQUNuRUEsZUFBZUEsR0FBR0Esd0JBQVdBLENBQUNBLGVBQWVBLENBQUNBLGlCQUFpQkEsQ0FBQ0EsTUFBTUEsQ0FBQ0EsTUFBTUEsQ0FBQ0EsQ0FBQ0E7UUFDL0VBLEdBQUdBLENBQUNBLENBQUNBLEdBQUdBLENBQUNBLENBQUNBLEdBQUdBLENBQUNBLEVBQUVBLENBQUNBLEdBQUdBLGlCQUFpQkEsQ0FBQ0EsTUFBTUEsQ0FBQ0EsTUFBTUEsRUFBRUEsQ0FBQ0EsRUFBRUEsRUFBRUEsQ0FBQ0E7WUFDekRBLGVBQWVBLENBQUNBLENBQUNBLENBQUNBLEdBQUdBLG9CQUFhQSxDQUFDQSxVQUFVQSxDQUFDQSxpQkFBaUJBLENBQUNBLE1BQU1BLENBQUNBLENBQUNBLENBQUNBLEVBQUVBLGVBQWVBLEVBQzVDQSxpQkFBaUJBLENBQUNBLE9BQU9BLENBQUNBLENBQUNBO1FBQzNFQSxDQUFDQTtJQUNIQSxDQUFDQTtJQUNEQSxNQUFNQSxDQUFDQSxlQUFlQSxDQUFDQTtBQUN6QkEsQ0FBQ0E7QUFWZSx5QkFBaUIsb0JBVWhDLENBQUE7QUFFRCwwQkFBaUMsaUJBQTBDLEVBQzFDLElBQXlCLEVBQUUsY0FBbUIsRUFDOUMsV0FBNkI7SUFDNURDLElBQUlBLElBQTRCQSxDQUFDQTtJQUNqQ0EsSUFBSUEsZUFBZUEsR0FBR0EsVUFBQ0EsaUJBQXlCQSxFQUFFQSxTQUFpQkEsRUFBRUEsS0FBVUE7ZUFDM0VBLElBQUlBLENBQUNBLG1CQUFtQkEsQ0FBQ0EsaUJBQWlCQSxFQUFFQSxTQUFTQSxFQUFFQSxLQUFLQSxDQUFDQTtJQUE3REEsQ0FBNkRBLENBQUNBO0lBQ2xFQSxJQUFJQSxPQUFPQSxHQUFHQSxJQUFJQSxZQUFZQSxDQUFDQSxlQUFlQSxFQUFFQSxXQUFXQSxFQUFFQSxjQUFjQSxDQUFDQSxDQUFDQTtJQUM3RUEsT0FBT0EsQ0FBQ0EsS0FBS0EsQ0FBQ0EsaUJBQWlCQSxFQUFFQSxJQUFJQSxDQUFDQSxDQUFDQTtJQUN2Q0EsSUFBSUEsU0FBU0EsR0FBb0NBLEVBQUVBLENBQUNBO0lBQ3BEQSxHQUFHQSxDQUFDQSxDQUFDQSxHQUFHQSxDQUFDQSxDQUFDQSxHQUFHQSxDQUFDQSxFQUFFQSxDQUFDQSxHQUFHQSxPQUFPQSxDQUFDQSxTQUFTQSxDQUFDQSxNQUFNQSxFQUFFQSxDQUFDQSxFQUFFQSxFQUFFQSxDQUFDQTtRQUNsREEsU0FBU0EsQ0FBQ0EsSUFBSUEsQ0FBQ0EsSUFBSUEsK0JBQXdCQSxDQUFDQSxPQUFPQSxDQUFDQSxTQUFTQSxDQUFDQSxDQUFDQSxDQUFDQSxDQUFDQSxDQUFDQSxDQUFDQTtJQUNyRUEsQ0FBQ0E7SUFDREEsSUFBSUEsR0FBR0EsSUFBSUEsd0JBQWlCQSxDQUFNQSxTQUFTQSxFQUFFQSxPQUFPQSxDQUFDQSxjQUFjQSxFQUFFQSxPQUFPQSxDQUFDQSxhQUFhQSxFQUN4REEsT0FBT0EsQ0FBQ0EsaUJBQWlCQSxFQUFFQSxPQUFPQSxDQUFDQSxpQkFBaUJBLEVBQ3BEQSxPQUFPQSxDQUFDQSwwQkFBMEJBLENBQUNBLENBQUNBO0lBQ3RFQSxNQUFNQSxDQUFDQSxJQUFJQSxDQUFDQTtBQUNkQSxDQUFDQTtBQWhCZSx3QkFBZ0IsbUJBZ0IvQixDQUFBO0FBZUQ7SUFDRUMsc0JBQW9CQSxnQkFBMEJBLEVBQVNBLE9BQXVCQSxFQUMxREEsZUFBa0JBO1FBRGxCQyxxQkFBZ0JBLEdBQWhCQSxnQkFBZ0JBLENBQVVBO1FBQVNBLFlBQU9BLEdBQVBBLE9BQU9BLENBQWdCQTtRQUMxREEsb0JBQWVBLEdBQWZBLGVBQWVBLENBQUdBO1FBRzlCQSxjQUFTQSxHQUEyQkEsRUFBRUEsQ0FBQ0E7UUFFL0NBLHNCQUFpQkEsR0FBZUEsRUFBRUEsQ0FBQ0E7UUFDbkNBLGtCQUFhQSxHQUFRQSxFQUFFQSxDQUFDQTtRQUN4QkEsbUJBQWNBLEdBQVFBLEVBQUVBLENBQUNBO1FBQ3pCQSxzQkFBaUJBLEdBQVFBLEVBQUVBLENBQUNBO1FBQzVCQSxjQUFTQSxHQUFVQSxFQUFFQSxDQUFDQTtRQUN0QkEsK0JBQTBCQSxHQUFRQSxFQUFFQSxDQUFDQTtRQUNyQ0EsbUJBQWNBLEdBQVdBLENBQUNBLENBQUNBO1FBVnpCQSxJQUFJQSxDQUFDQSxNQUFNQSxHQUFHQSxnQkFBU0EsQ0FBQ0EsQ0FBQ0EsZUFBZUEsQ0FBQ0EsQ0FBQ0EsQ0FBQ0E7SUFDN0NBLENBQUNBO0lBWURELDRCQUFLQSxHQUFMQSxVQUFNQSxRQUFpQ0EsRUFBRUEsSUFBeUJBO1FBQ2hFRSxJQUFJQSxDQUFDQSxrQkFBa0JBLENBQUNBLFFBQVFBLEVBQUVBLElBQUlBLENBQUNBLENBQUNBO1FBQ3hDQSxJQUFJQSxDQUFDQSxNQUFNQSxDQUFDQSxJQUFJQSxDQUFDQSxTQUFTQSxDQUFDQSxDQUFDQSxDQUFDQSxDQUFDQSxDQUFDQTtJQUNqQ0EsQ0FBQ0E7SUFFT0YsNkJBQU1BLEdBQWRBLFVBQWVBLE9BQTZCQTtRQUMxQ0csSUFBSUEsQ0FBQ0EsU0FBU0EsR0FBR0EsRUFBRUEsQ0FBQ0E7UUFDcEJBLE9BQU9BLENBQUNBLEtBQUtBLENBQUNBLElBQUlBLENBQUNBLENBQUNBO1FBQ3BCQSxJQUFJQSxnQkFBZ0JBLEdBQUdBLElBQUlBLENBQUNBLFNBQVNBLENBQUNBO1FBQ3RDQSxHQUFHQSxDQUFDQSxDQUFDQSxHQUFHQSxDQUFDQSxDQUFDQSxHQUFHQSxDQUFDQSxFQUFFQSxDQUFDQSxHQUFHQSxnQkFBZ0JBLENBQUNBLE1BQU1BLEVBQUVBLENBQUNBLEVBQUVBLEVBQUVBLENBQUNBO1lBQ2pEQSxJQUFJQSxDQUFDQSxNQUFNQSxDQUFDQSxnQkFBZ0JBLENBQUNBLENBQUNBLENBQUNBLENBQUNBLENBQUNBO1FBQ25DQSxDQUFDQTtJQUNIQSxDQUFDQTtJQUVESCw4Q0FBdUJBLEdBQXZCQSxVQUF3QkEsU0FBdUJBO1FBQzdDSSxJQUFJQSxDQUFDQSxjQUFjQSxFQUFFQSxDQUFDQTtRQUN0QkEsSUFBSUEsQ0FBQ0EsU0FBU0EsQ0FBQ0EsSUFBSUEsQ0FDZkEsSUFBSUEsaUJBQWlCQSxDQUFJQSxTQUFTQSxFQUFFQSxJQUFJQSxFQUFFQSxTQUFTQSxDQUFDQSxRQUFRQSxFQUFFQSxTQUFTQSxDQUFDQSxRQUFRQSxDQUFDQSxRQUFRQSxDQUFDQSxDQUFDQSxDQUFDQTtJQUNsR0EsQ0FBQ0E7SUFFREosNkNBQXNCQSxHQUF0QkEsVUFBdUJBLGVBQTZCQSxFQUFFQSxjQUF1Q0EsRUFDdEVBLFFBQTZCQTtRQUNsREssSUFBSUEsU0FBU0EsR0FBR0EsRUFBRUEsQ0FBQ0E7UUFDbkJBLElBQUlBLENBQUNBLFNBQVNBLENBQUNBLElBQUlBLENBQUNBLFNBQVNBLENBQUNBLENBQUNBO1FBQy9CQSxJQUFJQSxDQUFDQSxTQUFTQSxDQUFDQSxJQUFJQSxDQUNmQSxJQUFJQSxpQkFBaUJBLENBQUlBLGVBQWVBLEVBQUVBLFNBQVNBLEVBQUVBLGNBQWNBLEVBQUVBLFFBQVFBLENBQUNBLENBQUNBLENBQUNBO0lBQ3RGQSxDQUFDQTtJQUVETCx5Q0FBa0JBLEdBQWxCQSxVQUFtQkEsUUFBaUNBLEVBQUVBLElBQXlCQTtRQUM3RU0sSUFBSUEsU0FBU0EsR0FBR0EsRUFBRUEsQ0FBQ0E7UUFDbkJBLElBQUlBLENBQUNBLFNBQVNBLENBQUNBLElBQUlBLENBQUNBLFNBQVNBLENBQUNBLENBQUNBO1FBQy9CQSxJQUFJQSxDQUFDQSxTQUFTQSxDQUFDQSxJQUFJQSxDQUFDQSxJQUFJQSxpQkFBaUJBLENBQUlBLElBQUlBLEVBQUVBLFNBQVNBLEVBQUVBLFFBQVFBLEVBQUVBLElBQUlBLENBQUNBLENBQUNBLENBQUNBO0lBQ2pGQSxDQUFDQTtJQUVETiw0Q0FBcUJBLEdBQXJCQTtRQUNFTyxJQUFJQSxNQUFNQSxHQUFHQSxJQUFJQSxDQUFDQSxlQUFlQSxDQUFDQTtRQUNsQ0EsSUFBSUEsQ0FBQ0EsZUFBZUEsR0FBR0EsSUFBSUEsQ0FBQ0E7UUFDNUJBLE1BQU1BLENBQUNBLE1BQU1BLENBQUNBO0lBQ2hCQSxDQUFDQTtJQUVEUCx1Q0FBZ0JBLEdBQWhCQSxVQUFpQkEsaUJBQXlCQSxFQUFFQSxNQUFjQSxFQUFFQSxTQUFpQkE7UUFDM0VRLEVBQUVBLENBQUNBLENBQUNBLGdCQUFTQSxDQUFDQSxNQUFNQSxDQUFDQSxDQUFDQSxDQUFDQSxDQUFDQTtZQUN0QkEsSUFBSUEsT0FBT0EsR0FDUEEsa0JBQWtCQSxDQUFDQSxpQkFBaUJBLEVBQUtBLE1BQU1BLFNBQUlBLFNBQVdBLEVBQUVBLElBQUlBLENBQUNBLGdCQUFnQkEsQ0FBQ0EsQ0FBQ0E7WUFDM0ZBLElBQUlBLENBQUNBLGlCQUFpQkEsQ0FBQ0EsSUFBSUEsQ0FBQ0Esc0JBQXNCQSxDQUFDQSxNQUFNQSxFQUFFQSxTQUFTQSxFQUFFQSxPQUFPQSxFQUFFQSxJQUFJQSxDQUFDQSxPQUFPQSxDQUFDQSxDQUFDQSxDQUFDQTtRQUNoR0EsQ0FBQ0E7UUFBQ0EsSUFBSUEsQ0FBQ0EsQ0FBQ0E7WUFDTkEsSUFBSUEsT0FBT0EsR0FBR0Esa0JBQWtCQSxDQUFDQSxpQkFBaUJBLEVBQUVBLFNBQVNBLEVBQUVBLElBQUlBLENBQUNBLGdCQUFnQkEsQ0FBQ0EsQ0FBQ0E7WUFDdEZBLElBQUlBLENBQUNBLE9BQU9BLENBQUNBLEVBQUVBLENBQUNBLElBQUlBLENBQUNBLGFBQWFBLENBQUNBLGlCQUFpQkEsQ0FBQ0EsRUFBRUEsU0FBU0EsRUFBRUEsT0FBT0EsQ0FBQ0EsQ0FBQ0E7UUFDN0VBLENBQUNBO0lBQ0hBLENBQUNBO0lBQ0hSLG1CQUFDQTtBQUFEQSxDQUFDQSxBQWxFRCxJQWtFQztBQUdELDRCQUE0QixpQkFBeUIsRUFBRSxTQUFpQixFQUM1QyxlQUF5QjtJQUNuRFMsTUFBTUEsQ0FBQ0EsVUFBQ0EsTUFBTUEsSUFBS0EsT0FBQUEsZUFBZUEsQ0FBQ0EsaUJBQWlCQSxFQUFFQSxTQUFTQSxFQUFFQSxNQUFNQSxDQUFDQSxFQUFyREEsQ0FBcURBLENBQUNBO0FBQzNFQSxDQUFDQTtBQUVELGdDQUFnQyxNQUFjLEVBQUUsU0FBaUIsRUFBRSxZQUFzQixFQUN6RCxXQUE2QjtJQUMzREMsTUFBTUEsQ0FBQ0EsY0FBTUEsT0FBQUEsV0FBV0EsQ0FBQ0EsUUFBUUEsQ0FBQ0EsTUFBTUEsRUFBRUEsU0FBU0EsRUFBRUEsWUFBWUEsQ0FBQ0EsRUFBckRBLENBQXFEQSxDQUFDQTtBQUNyRUEsQ0FBQ0E7QUFFRDtJQUdFQywyQkFBbUJBLGVBQTZCQSxFQUFTQSxpQkFBc0JBLEVBQzVEQSxRQUFpQ0EsRUFBU0EsSUFBeUJBO1FBRG5FQyxvQkFBZUEsR0FBZkEsZUFBZUEsQ0FBY0E7UUFBU0Esc0JBQWlCQSxHQUFqQkEsaUJBQWlCQSxDQUFLQTtRQUM1REEsYUFBUUEsR0FBUkEsUUFBUUEsQ0FBeUJBO1FBQVNBLFNBQUlBLEdBQUpBLElBQUlBLENBQXFCQTtRQUNwRkEsSUFBSUEsZUFBZUEsR0FBR0EsZ0JBQVNBLENBQUNBLGlCQUFpQkEsQ0FBQ0EsR0FBR0EsSUFBSUEsR0FBR0EsZUFBZUEsQ0FBQ0EsVUFBVUEsQ0FBQ0E7UUFDdkZBLElBQUlBLENBQUNBLFdBQVdBLEdBQUdBLENBQUNBLGVBQWVBLENBQUNBLENBQUNBO0lBQ3ZDQSxDQUFDQTtJQUVERCxpQ0FBS0EsR0FBTEEsVUFBTUEsT0FBd0JBO1FBQzVCRSxJQUFJQSxJQUFJQSxHQUFHQSxJQUFJQSxDQUFDQSxJQUFJQSxDQUFDQTtRQUNyQkEsR0FBR0EsQ0FBQ0EsQ0FBQ0EsR0FBR0EsQ0FBQ0EsQ0FBQ0EsR0FBR0EsQ0FBQ0EsRUFBRUEsQ0FBQ0EsR0FBR0EsSUFBSUEsQ0FBQ0EsTUFBTUEsRUFBRUEsQ0FBQ0EsRUFBRUEsRUFBRUEsQ0FBQ0E7WUFDckNBLElBQUlBLENBQUNBLENBQUNBLENBQUNBLENBQUNBLEtBQUtBLENBQUNBLElBQUlBLEVBQUVBLE9BQU9BLENBQUNBLENBQUNBO1FBQy9CQSxDQUFDQTtJQUNIQSxDQUFDQTtJQUVERixzQkFBSUEscUNBQU1BO2FBQVZBLGNBQWlDRyxNQUFNQSxDQUFDQSxJQUFJQSxDQUFDQSxXQUFXQSxDQUFDQSxJQUFJQSxDQUFDQSxXQUFXQSxDQUFDQSxNQUFNQSxHQUFHQSxDQUFDQSxDQUFDQSxDQUFDQSxDQUFDQSxDQUFDQTs7O09BQUFIO0lBRXhGQSxxQ0FBU0EsR0FBVEEsVUFBVUEsR0FBa0JBLEVBQUVBLE9BQXdCQTtRQUNwREksSUFBSUEsSUFBSUEsR0FBR0EsT0FBT0EsQ0FBQ0EsT0FBT0EsQ0FBQ0EsVUFBVUEsQ0FBQ0EsR0FBR0EsQ0FBQ0EsS0FBS0EsQ0FBQ0EsQ0FBQ0E7UUFDakRBLElBQUlBLENBQUNBLFNBQVNBLENBQUNBLElBQUlBLEVBQUVBLEdBQUdBLENBQUNBLGNBQWNBLEVBQUVBLE9BQU9BLENBQUNBLENBQUNBO1FBQ2xEQSxFQUFFQSxDQUFDQSxDQUFDQSxHQUFHQSxDQUFDQSxPQUFPQSxDQUFDQSxDQUFDQSxDQUFDQTtZQUNoQkEsT0FBT0EsQ0FBQ0EsY0FBY0EsQ0FBQ0EsSUFBSUEsQ0FBQ0EsSUFBSUEsQ0FBQ0EsQ0FBQ0E7UUFDcENBLENBQUNBO1FBQ0RBLE1BQU1BLENBQUNBLElBQUlBLENBQUNBO0lBQ2RBLENBQUNBO0lBQ0RKLDBDQUFjQSxHQUFkQSxVQUFlQSxHQUF1QkEsRUFBRUEsT0FBd0JBO1FBQzlESyxFQUFFQSxDQUFDQSxDQUFDQSxnQkFBU0EsQ0FBQ0EsSUFBSUEsQ0FBQ0EsZUFBZUEsQ0FBQ0EsQ0FBQ0EsQ0FBQ0EsQ0FBQ0E7WUFDcENBLEVBQUVBLENBQUNBLENBQUNBLElBQUlBLENBQUNBLGVBQWVBLENBQUNBLE1BQU1BLENBQUNBLENBQUNBLENBQUNBO2dCQUNoQ0EsSUFBSUEsY0FBY0EsR0FBR0EsT0FBT0EsQ0FBQ0EsT0FBT0EsQ0FBQ0EsK0JBQStCQSxFQUFFQSxDQUFDQTtnQkFDdkVBLEVBQUVBLENBQUNBLENBQUNBLElBQUlBLENBQUNBLE1BQU1BLFlBQVlBLFNBQVNBLENBQUNBLENBQUNBLENBQUNBO29CQUNyQ0EsT0FBT0EsQ0FBQ0EsT0FBT0EsQ0FBQ0EsV0FBV0EsQ0FBZ0JBLElBQUlBLENBQUNBLE1BQU9BLENBQUNBLFVBQVVBLEVBQUVBLGNBQWNBLENBQUNBLENBQUNBO2dCQUN0RkEsQ0FBQ0E7Z0JBQUNBLElBQUlBLENBQUNBLENBQUNBO29CQUNOQSxPQUFPQSxDQUFDQSxPQUFPQSxDQUFDQSxXQUFXQSxDQUFJQSxJQUFJQSxDQUFDQSxNQUFNQSxFQUFFQSxjQUFjQSxDQUFDQSxDQUFDQTtnQkFDOURBLENBQUNBO2dCQUNEQSxPQUFPQSxDQUFDQSwwQkFBMEJBLENBQUNBLElBQUlBLENBQUNBLGNBQWNBLENBQUNBLENBQUNBO1lBQzFEQSxDQUFDQTtZQUFDQSxJQUFJQSxDQUFDQSxDQUFDQTtnQkFDTkEsSUFBSUEsY0FBY0EsR0FBR0EsSUFBSUEsQ0FBQ0EsZUFBZUEsQ0FBQ0EsT0FBT0EsQ0FBQ0EsR0FBR0EsQ0FBQ0EsS0FBS0EsQ0FBQ0EsQ0FBQ0E7Z0JBQzdEQSxHQUFHQSxDQUFDQSxDQUFDQSxHQUFHQSxDQUFDQSxDQUFDQSxHQUFHQSxDQUFDQSxFQUFFQSxDQUFDQSxHQUFHQSxjQUFjQSxDQUFDQSxNQUFNQSxFQUFFQSxDQUFDQSxFQUFFQSxFQUFFQSxDQUFDQTtvQkFDL0NBLElBQUlBLElBQUlBLEdBQUdBLGNBQWNBLENBQUNBLENBQUNBLENBQUNBLENBQUNBO29CQUM3QkEsSUFBSUEsQ0FBQ0EsU0FBU0EsQ0FBQ0EsSUFBSUEsRUFBRUEsR0FBR0EsQ0FBQ0EsY0FBY0EsRUFBRUEsT0FBT0EsQ0FBQ0EsQ0FBQ0E7Z0JBQ3BEQSxDQUFDQTtZQUNIQSxDQUFDQTtRQUNIQSxDQUFDQTtRQUNEQSxNQUFNQSxDQUFDQSxJQUFJQSxDQUFDQTtJQUNkQSxDQUFDQTtJQUNETCw2Q0FBaUJBLEdBQWpCQSxVQUFrQkEsR0FBMEJBLEVBQUVBLE9BQXdCQTtRQUNwRU0sSUFBSUEsQ0FBQ0EsV0FBV0EsQ0FBQ0EsSUFBSUEsQ0FBQ0EsSUFBSUEsQ0FBQ0EsYUFBYUEsQ0FBQ0EsR0FBR0EsRUFBRUEsT0FBT0EsRUFBRUEsSUFBSUEsQ0FBQ0EsQ0FBQ0EsQ0FBQ0E7UUFDOURBLE1BQU1BLENBQUNBLElBQUlBLENBQUNBO0lBQ2RBLENBQUNBO0lBQ0ROLDJDQUFlQSxHQUFmQSxVQUFnQkEsT0FBd0JBO1FBQ3RDTyxJQUFJQSxDQUFDQSxXQUFXQSxFQUFFQSxDQUFDQTtRQUNuQkEsTUFBTUEsQ0FBQ0EsSUFBSUEsQ0FBQ0E7SUFDZEEsQ0FBQ0E7SUFDRFAsK0NBQW1CQSxHQUFuQkEsVUFBb0JBLEdBQTRCQSxFQUFFQSxPQUF3QkE7UUFDeEVRLElBQUlBLFVBQVVBLEdBQUdBLEdBQUdBLENBQUNBLFVBQVVBLENBQUNBO1FBQ2hDQSxJQUFJQSxHQUFHQSxHQUFHQSxPQUFPQSxDQUFDQSxPQUFPQSxDQUFDQSx3QkFBd0JBLENBQUNBLFVBQVVBLENBQUNBLENBQUNBO1FBQy9EQSxJQUFJQSxFQUFFQSxHQUFHQSxJQUFJQSxDQUFDQSxhQUFhQSxDQUFDQSxHQUFHQSxFQUFFQSxPQUFPQSxFQUFFQSxHQUFHQSxDQUFDQSxDQUFDQTtRQUMvQ0EsSUFBSUEsSUFBSUEsR0FBR0EsRUFBRUEsQ0FBQ0E7UUFFZEEsRUFBRUEsQ0FBQ0EsQ0FBQ0EsR0FBR0EsQ0FBQ0EsYUFBYUEsS0FBS0EsNEJBQWlCQSxDQUFDQSxNQUFNQSxDQUFDQSxDQUFDQSxDQUFDQTtZQUNuREEsSUFBSUEsR0FBR0EsT0FBT0EsQ0FBQ0EsT0FBT0EsQ0FBQ0EsZ0JBQWdCQSxDQUFDQSxFQUFFQSxFQUFFQSxVQUFVQSxDQUFDQSxDQUFDQTtZQUN4REEsT0FBT0EsQ0FBQ0EsaUJBQWlCQSxDQUFDQSxJQUFJQSxDQUFDQSxJQUFJQSxDQUFDQSxDQUFDQTtRQUN2Q0EsQ0FBQ0E7UUFDREEsSUFBSUEsTUFBTUEsR0FBR0EsT0FBT0EsQ0FBQ0EsY0FBY0EsS0FBS0EsQ0FBQ0EsSUFBSUEsT0FBT0EsQ0FBQ0EsTUFBTUEsQ0FBQ0E7UUFDNURBLElBQUlBLFNBQVNBLEdBQUdBLElBQUlBLFNBQVNBLENBQUNBLEVBQUVBLEVBQUVBLElBQUlBLEVBQUVBLE1BQU1BLEVBQUVBLEdBQUdBLENBQUNBLENBQUNBO1FBQ3JEQSxPQUFPQSxDQUFDQSx1QkFBdUJBLENBQUNBLFNBQVNBLENBQUNBLENBQUNBO1FBQzNDQSxJQUFJQSxDQUFDQSxXQUFXQSxDQUFDQSxJQUFJQSxDQUFDQSxTQUFTQSxDQUFDQSxDQUFDQTtRQUNqQ0EsTUFBTUEsQ0FBQ0EsSUFBSUEsQ0FBQ0E7SUFDZEEsQ0FBQ0E7SUFDRFIsNkNBQWlCQSxHQUFqQkEsVUFBa0JBLE9BQXdCQTtRQUN4Q1MsSUFBSUEsQ0FBQ0EsV0FBV0EsRUFBRUEsQ0FBQ0E7UUFDbkJBLE1BQU1BLENBQUNBLElBQUlBLENBQUNBO0lBQ2RBLENBQUNBO0lBQ0RULGlEQUFxQkEsR0FBckJBLFVBQXNCQSxHQUE4QkEsRUFBRUEsT0FBd0JBO1FBQzVFVSxJQUFJQSxFQUFFQSxHQUFHQSxPQUFPQSxDQUFDQSxPQUFPQSxDQUFDQSxvQkFBb0JBLENBQUNBLEdBQUdBLENBQUNBLGlCQUFpQkEsQ0FBQ0EsQ0FBQ0E7UUFDckVBLElBQUlBLENBQUNBLFNBQVNBLENBQUNBLEVBQUVBLEVBQUVBLEdBQUdBLENBQUNBLGNBQWNBLEVBQUVBLE9BQU9BLENBQUNBLENBQUNBO1FBQ2hEQSxPQUFPQSxDQUFDQSxhQUFhQSxDQUFDQSxJQUFJQSxDQUFDQSxFQUFFQSxDQUFDQSxDQUFDQTtRQUMvQkEsRUFBRUEsQ0FBQ0EsQ0FBQ0EsR0FBR0EsQ0FBQ0EsUUFBUUEsQ0FBQ0EsQ0FBQ0EsQ0FBQ0E7WUFDakJBLE9BQU9BLENBQUNBLHNCQUFzQkEsQ0FBQ0EsSUFBSUEsQ0FBQ0EsZUFBZUEsRUFBRUEsSUFBSUEsQ0FBQ0EsUUFBUUEsRUFBRUEsR0FBR0EsQ0FBQ0EsUUFBUUEsQ0FBQ0EsQ0FBQ0E7UUFDcEZBLENBQUNBO1FBQ0RBLE1BQU1BLENBQUNBLElBQUlBLENBQUNBO0lBQ2RBLENBQUNBO0lBRU9WLHlDQUFhQSxHQUFyQkEsVUFBc0JBLEdBQTBCQSxFQUFFQSxPQUF3QkEsRUFDcERBLGlCQUEwQ0E7UUFDOURXLElBQUlBLEVBQUVBLEdBQU1BLE9BQU9BLENBQUNBLHFCQUFxQkEsRUFBRUEsQ0FBQ0E7UUFDNUNBLElBQUlBLGlCQUFpQkEsR0FBR0EsR0FBR0EsQ0FBQ0EsaUJBQWlCQSxDQUFDQTtRQUM5Q0EsSUFBSUEsNkJBQTZCQSxHQUFHQSxJQUFJQSxDQUFDQSxRQUFRQSxDQUFDQSxhQUFhQSxLQUFLQSw0QkFBaUJBLENBQUNBLFFBQVFBLENBQUNBO1FBQy9GQSxJQUFJQSw4QkFBOEJBLEdBQzlCQSxnQkFBU0EsQ0FBQ0EsaUJBQWlCQSxDQUFDQTtZQUM1QkEsaUJBQWlCQSxDQUFDQSxhQUFhQSxLQUFLQSw0QkFBaUJBLENBQUNBLFFBQVFBLENBQUNBO1FBQ25FQSxJQUFJQSxhQUFhQSxHQUFHQSxpQkFBaUJBLENBQUNBLE1BQU1BLEdBQUdBLENBQUNBLDZCQUE2QkEsR0FBR0EsQ0FBQ0EsR0FBR0EsQ0FBQ0EsQ0FBQ0E7WUFDbEVBLENBQUNBLDhCQUE4QkEsR0FBR0EsQ0FBQ0EsR0FBR0EsQ0FBQ0EsQ0FBQ0EsQ0FBQ0E7UUFDN0RBLEVBQUVBLENBQUNBLENBQUNBLGFBQWFBLEdBQUdBLGlCQUFpQkEsQ0FBQ0EsTUFBTUEsQ0FBQ0EsQ0FBQ0EsQ0FBQ0E7WUFDN0NBLDZEQUE2REE7WUFDN0RBLElBQUlBLG9CQUFvQkEsR0FBR0Esd0JBQVdBLENBQUNBLGVBQWVBLENBQUNBLGFBQWFBLENBQUNBLENBQUNBO1lBQ3RFQSxJQUFJQSxTQUFTQSxDQUFDQTtZQUNkQSxHQUFHQSxDQUFDQSxDQUFDQSxTQUFTQSxHQUFHQSxDQUFDQSxFQUFFQSxTQUFTQSxHQUFHQSxpQkFBaUJBLENBQUNBLE1BQU1BLEVBQUVBLFNBQVNBLEVBQUVBLEVBQUVBLENBQUNBO2dCQUN0RUEsb0JBQW9CQSxDQUFDQSxTQUFTQSxDQUFDQSxHQUFHQSxpQkFBaUJBLENBQUNBLFNBQVNBLENBQUNBLENBQUNBO1lBQ2pFQSxDQUFDQTtZQUNEQSxFQUFFQSxDQUFDQSxDQUFDQSw2QkFBNkJBLENBQUNBLENBQUNBLENBQUNBO2dCQUNsQ0Esb0JBQW9CQSxDQUFDQSxTQUFTQSxFQUFFQSxDQUFDQSxHQUFHQSxxQkFBcUJBLENBQUNBLElBQUlBLENBQUNBLFFBQVFBLENBQUNBLE9BQU9BLENBQUNBLENBQUNBO2dCQUNqRkEsb0JBQW9CQSxDQUFDQSxTQUFTQSxFQUFFQSxDQUFDQSxHQUFHQSxFQUFFQSxDQUFDQTtZQUN6Q0EsQ0FBQ0E7WUFDREEsRUFBRUEsQ0FBQ0EsQ0FBQ0EsOEJBQThCQSxDQUFDQSxDQUFDQSxDQUFDQTtnQkFDbkNBLG9CQUFvQkEsQ0FBQ0EsU0FBU0EsRUFBRUEsQ0FBQ0EsR0FBR0Esa0JBQWtCQSxDQUFDQSxpQkFBaUJBLENBQUNBLE9BQU9BLENBQUNBLENBQUNBO2dCQUNsRkEsb0JBQW9CQSxDQUFDQSxTQUFTQSxFQUFFQSxDQUFDQSxHQUFHQSxFQUFFQSxDQUFDQTtZQUN6Q0EsQ0FBQ0E7WUFDREEsaUJBQWlCQSxHQUFHQSxvQkFBb0JBLENBQUNBO1FBQzNDQSxDQUFDQTtRQUNEQSxFQUFFQSxDQUFDQSxDQUFDQSxnQkFBU0EsQ0FBQ0EsRUFBRUEsQ0FBQ0EsQ0FBQ0EsQ0FBQ0EsQ0FBQ0E7WUFDbEJBLE9BQU9BLENBQUNBLE9BQU9BLENBQUNBLFlBQVlBLENBQUNBLEVBQUVBLEVBQUVBLGlCQUFpQkEsQ0FBQ0EsQ0FBQ0E7WUFDcERBLElBQUlBLENBQUNBLGlCQUFpQkEsQ0FBQ0EsSUFBSUEsQ0FBQ0EsRUFBRUEsQ0FBQ0EsQ0FBQ0E7UUFDbENBLENBQUNBO1FBQUNBLElBQUlBLENBQUNBLENBQUNBO1lBQ05BLEVBQUVBLEdBQUdBLE9BQU9BLENBQUNBLE9BQU9BLENBQUNBLGFBQWFBLENBQUNBLEdBQUdBLENBQUNBLElBQUlBLEVBQUVBLGlCQUFpQkEsQ0FBQ0EsQ0FBQ0E7WUFDaEVBLElBQUlBLENBQUNBLFNBQVNBLENBQUNBLEVBQUVBLEVBQUVBLEdBQUdBLENBQUNBLGNBQWNBLEVBQUVBLE9BQU9BLENBQUNBLENBQUNBO1FBQ2xEQSxDQUFDQTtRQUNEQSxFQUFFQSxDQUFDQSxDQUFDQSxHQUFHQSxDQUFDQSxPQUFPQSxDQUFDQSxDQUFDQSxDQUFDQTtZQUNoQkEsSUFBSUEsaUJBQWlCQSxHQUFHQSxPQUFPQSxDQUFDQSxhQUFhQSxDQUFDQSxNQUFNQSxDQUFDQTtZQUNyREEsT0FBT0EsQ0FBQ0EsYUFBYUEsQ0FBQ0EsSUFBSUEsQ0FBQ0EsRUFBRUEsQ0FBQ0EsQ0FBQ0E7WUFDL0JBLEdBQUdBLENBQUNBLENBQUNBLEdBQUdBLENBQUNBLENBQUNBLEdBQUdBLENBQUNBLEVBQUVBLENBQUNBLEdBQUdBLEdBQUdBLENBQUNBLG1CQUFtQkEsQ0FBQ0EsTUFBTUEsRUFBRUEsQ0FBQ0EsSUFBSUEsQ0FBQ0EsRUFBRUEsQ0FBQ0E7Z0JBQzNEQSxJQUFJQSxNQUFNQSxHQUFHQSxHQUFHQSxDQUFDQSxtQkFBbUJBLENBQUNBLENBQUNBLENBQUNBLENBQUNBO2dCQUN4Q0EsSUFBSUEsU0FBU0EsR0FBR0EsR0FBR0EsQ0FBQ0EsbUJBQW1CQSxDQUFDQSxDQUFDQSxHQUFHQSxDQUFDQSxDQUFDQSxDQUFDQTtnQkFDL0NBLE9BQU9BLENBQUNBLGdCQUFnQkEsQ0FBQ0EsaUJBQWlCQSxFQUFFQSxNQUFNQSxFQUFFQSxTQUFTQSxDQUFDQSxDQUFDQTtZQUNqRUEsQ0FBQ0E7UUFDSEEsQ0FBQ0E7UUFDREEsTUFBTUEsQ0FBQ0EsRUFBRUEsQ0FBQ0E7SUFDWkEsQ0FBQ0E7SUFFT1gsdUNBQVdBLEdBQW5CQSxjQUF3QlksSUFBSUEsQ0FBQ0EsV0FBV0EsQ0FBQ0EsR0FBR0EsRUFBRUEsQ0FBQ0EsQ0FBQ0EsQ0FBQ0E7SUFFekNaLHFDQUFTQSxHQUFqQkEsVUFBa0JBLElBQU9BLEVBQUVBLGNBQXNCQSxFQUFFQSxPQUF3QkE7UUFDekVhLElBQUlBLE1BQU1BLEdBQUdBLElBQUlBLENBQUNBLE1BQU1BLENBQUNBO1FBQ3pCQSxFQUFFQSxDQUFDQSxDQUFDQSxnQkFBU0EsQ0FBQ0EsTUFBTUEsQ0FBQ0EsQ0FBQ0EsQ0FBQ0EsQ0FBQ0E7WUFDdEJBLEVBQUVBLENBQUNBLENBQUNBLE1BQU1BLFlBQVlBLFNBQVNBLENBQUNBLENBQUNBLENBQUNBO2dCQUNoQ0EsTUFBTUEsQ0FBQ0EsY0FBY0EsQ0FBQ0EsY0FBY0EsRUFBRUEsSUFBSUEsRUFBRUEsT0FBT0EsQ0FBQ0EsQ0FBQ0E7WUFDdkRBLENBQUNBO1lBQUNBLElBQUlBLENBQUNBLENBQUNBO2dCQUNOQSxPQUFPQSxDQUFDQSxPQUFPQSxDQUFDQSxXQUFXQSxDQUFJQSxNQUFNQSxFQUFFQSxJQUFJQSxDQUFDQSxDQUFDQTtZQUMvQ0EsQ0FBQ0E7UUFDSEEsQ0FBQ0E7UUFBQ0EsSUFBSUEsQ0FBQ0EsQ0FBQ0E7WUFDTkEsSUFBSUEsQ0FBQ0EsaUJBQWlCQSxDQUFDQSxJQUFJQSxDQUFDQSxJQUFJQSxDQUFDQSxDQUFDQTtRQUNwQ0EsQ0FBQ0E7SUFDSEEsQ0FBQ0E7SUFDSGIsd0JBQUNBO0FBQURBLENBQUNBLEFBaEpELElBZ0pDO0FBRUQ7SUFHRWMsbUJBQW1CQSxXQUFjQSxFQUFTQSxVQUFhQSxFQUFTQSxNQUFlQSxFQUM1REEsUUFBaUNBO1FBRGpDQyxnQkFBV0EsR0FBWEEsV0FBV0EsQ0FBR0E7UUFBU0EsZUFBVUEsR0FBVkEsVUFBVUEsQ0FBR0E7UUFBU0EsV0FBTUEsR0FBTkEsTUFBTUEsQ0FBU0E7UUFDNURBLGFBQVFBLEdBQVJBLFFBQVFBLENBQXlCQTtRQUg1Q0EsaUNBQTRCQSxHQUFVQSxFQUFFQSxDQUFDQTtJQUdNQSxDQUFDQTtJQUN4REQsa0NBQWNBLEdBQWRBLFVBQWVBLGNBQXNCQSxFQUFFQSxJQUFPQSxFQUFFQSxPQUF3QkE7UUFDdEVFLEVBQUVBLENBQUNBLENBQUNBLGNBQU9BLENBQUNBLGNBQWNBLENBQUNBLENBQUNBLENBQUNBLENBQUNBO1lBQzVCQSxFQUFFQSxDQUFDQSxDQUFDQSxJQUFJQSxDQUFDQSxRQUFRQSxDQUFDQSxhQUFhQSxLQUFLQSw0QkFBaUJBLENBQUNBLE1BQU1BLENBQUNBLENBQUNBLENBQUNBO2dCQUM3REEsT0FBT0EsQ0FBQ0EsT0FBT0EsQ0FBQ0EsV0FBV0EsQ0FBQ0EsSUFBSUEsQ0FBQ0EsV0FBV0EsRUFBRUEsSUFBSUEsQ0FBQ0EsQ0FBQ0E7WUFDdERBLENBQUNBO1FBQ0hBLENBQUNBO1FBQUNBLElBQUlBLENBQUNBLENBQUNBO1lBQ05BLE9BQU9BLElBQUlBLENBQUNBLDRCQUE0QkEsQ0FBQ0EsTUFBTUEsSUFBSUEsY0FBY0EsRUFBRUEsQ0FBQ0E7Z0JBQ2xFQSxJQUFJQSxDQUFDQSw0QkFBNEJBLENBQUNBLElBQUlBLENBQUNBLEVBQUVBLENBQUNBLENBQUNBO1lBQzdDQSxDQUFDQTtZQUNEQSxJQUFJQSxDQUFDQSw0QkFBNEJBLENBQUNBLGNBQWNBLENBQUNBLENBQUNBLElBQUlBLENBQUNBLElBQUlBLENBQUNBLENBQUNBO1FBQy9EQSxDQUFDQTtJQUNIQSxDQUFDQTtJQUNERiwyQkFBT0EsR0FBUEEsVUFBUUEsY0FBc0JBO1FBQzVCRyxNQUFNQSxDQUFDQSxjQUFjQSxHQUFHQSxJQUFJQSxDQUFDQSw0QkFBNEJBLENBQUNBLE1BQU1BO1lBQ3JEQSxJQUFJQSxDQUFDQSw0QkFBNEJBLENBQUNBLGNBQWNBLENBQUNBO1lBQ2pEQSxFQUFFQSxDQUFDQTtJQUNoQkEsQ0FBQ0E7SUFDSEgsZ0JBQUNBO0FBQURBLENBQUNBLEFBdEJELElBc0JDO0FBRUQsSUFBSSxlQUFlLEdBQUcsU0FBUyxDQUFDO0FBQ25CLDBCQUFrQixHQUFHLFFBQVEsQ0FBQztBQUM5QixpQkFBUyxHQUFHLGFBQVcsMEJBQW9CLENBQUM7QUFDNUMsb0JBQVksR0FBRyxnQkFBYywwQkFBb0IsQ0FBQztBQUUvRCwrQkFBK0IsZ0JBQXdCO0lBQ3JESSxNQUFNQSxDQUFDQSxvQkFBYUEsQ0FBQ0EsVUFBVUEsQ0FBQ0Esb0JBQVlBLEVBQUVBLGVBQWVBLEVBQUVBLGdCQUFnQkEsQ0FBQ0EsQ0FBQ0E7QUFDbkZBLENBQUNBO0FBRUQsNEJBQTRCLGdCQUF3QjtJQUNsREMsTUFBTUEsQ0FBQ0Esb0JBQWFBLENBQUNBLFVBQVVBLENBQUNBLGlCQUFTQSxFQUFFQSxlQUFlQSxFQUFFQSxnQkFBZ0JBLENBQUNBLENBQUNBO0FBQ2hGQSxDQUFDQSIsInNvdXJjZXNDb250ZW50IjpbImltcG9ydCB7aXNCbGFuaywgaXNQcmVzZW50LCBTdHJpbmdXcmFwcGVyfSBmcm9tICdhbmd1bGFyMi9zcmMvZmFjYWRlL2xhbmcnO1xuaW1wb3J0IHtcbiAgUmVuZGVyRXZlbnREaXNwYXRjaGVyLFxuICBSZW5kZXJUZW1wbGF0ZUNtZCxcbiAgUmVuZGVyQ29tbWFuZFZpc2l0b3IsXG4gIFJlbmRlckJlZ2luRWxlbWVudENtZCxcbiAgUmVuZGVyQmVnaW5Db21wb25lbnRDbWQsXG4gIFJlbmRlck5nQ29udGVudENtZCxcbiAgUmVuZGVyVGV4dENtZCxcbiAgUmVuZGVyRW1iZWRkZWRUZW1wbGF0ZUNtZCxcbiAgUmVuZGVyQ29tcG9uZW50VGVtcGxhdGVcbn0gZnJvbSAnLi9hcGknO1xuaW1wb3J0IHtEZWZhdWx0UmVuZGVyVmlldywgRGVmYXVsdFJlbmRlckZyYWdtZW50UmVmfSBmcm9tICcuL3ZpZXcnO1xuaW1wb3J0IHtWaWV3RW5jYXBzdWxhdGlvbn0gZnJvbSAnYW5ndWxhcjIvc3JjL2NvcmUvbWV0YWRhdGEnO1xuaW1wb3J0IHtMaXN0V3JhcHBlcn0gZnJvbSAnYW5ndWxhcjIvc3JjL2ZhY2FkZS9jb2xsZWN0aW9uJztcblxuXG5leHBvcnQgZnVuY3Rpb24gZW5jYXBzdWxhdGVTdHlsZXMoY29tcG9uZW50VGVtcGxhdGU6IFJlbmRlckNvbXBvbmVudFRlbXBsYXRlKTogc3RyaW5nW10ge1xuICB2YXIgcHJvY2Vzc2VkU3R5bGVzID0gY29tcG9uZW50VGVtcGxhdGUuc3R5bGVzO1xuICBpZiAoY29tcG9uZW50VGVtcGxhdGUuZW5jYXBzdWxhdGlvbiA9PT0gVmlld0VuY2Fwc3VsYXRpb24uRW11bGF0ZWQpIHtcbiAgICBwcm9jZXNzZWRTdHlsZXMgPSBMaXN0V3JhcHBlci5jcmVhdGVGaXhlZFNpemUoY29tcG9uZW50VGVtcGxhdGUuc3R5bGVzLmxlbmd0aCk7XG4gICAgZm9yICh2YXIgaSA9IDA7IGkgPCBjb21wb25lbnRUZW1wbGF0ZS5zdHlsZXMubGVuZ3RoOyBpKyspIHtcbiAgICAgIHByb2Nlc3NlZFN0eWxlc1tpXSA9IFN0cmluZ1dyYXBwZXIucmVwbGFjZUFsbChjb21wb25lbnRUZW1wbGF0ZS5zdHlsZXNbaV0sIENPTVBPTkVOVF9SRUdFWCxcbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBjb21wb25lbnRUZW1wbGF0ZS5zaG9ydElkKTtcbiAgICB9XG4gIH1cbiAgcmV0dXJuIHByb2Nlc3NlZFN0eWxlcztcbn1cblxuZXhwb3J0IGZ1bmN0aW9uIGNyZWF0ZVJlbmRlclZpZXcoY29tcG9uZW50VGVtcGxhdGU6IFJlbmRlckNvbXBvbmVudFRlbXBsYXRlLFxuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgY21kczogUmVuZGVyVGVtcGxhdGVDbWRbXSwgaW5wbGFjZUVsZW1lbnQ6IGFueSxcbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIG5vZGVGYWN0b3J5OiBOb2RlRmFjdG9yeTxhbnk+KTogRGVmYXVsdFJlbmRlclZpZXc8YW55PiB7XG4gIHZhciB2aWV3OiBEZWZhdWx0UmVuZGVyVmlldzxhbnk+O1xuICB2YXIgZXZlbnREaXNwYXRjaGVyID0gKGJvdW5kRWxlbWVudEluZGV4OiBudW1iZXIsIGV2ZW50TmFtZTogc3RyaW5nLCBldmVudDogYW55KSA9PlxuICAgICAgdmlldy5kaXNwYXRjaFJlbmRlckV2ZW50KGJvdW5kRWxlbWVudEluZGV4LCBldmVudE5hbWUsIGV2ZW50KTtcbiAgdmFyIGNvbnRleHQgPSBuZXcgQnVpbGRDb250ZXh0KGV2ZW50RGlzcGF0Y2hlciwgbm9kZUZhY3RvcnksIGlucGxhY2VFbGVtZW50KTtcbiAgY29udGV4dC5idWlsZChjb21wb25lbnRUZW1wbGF0ZSwgY21kcyk7XG4gIHZhciBmcmFnbWVudHM6IERlZmF1bHRSZW5kZXJGcmFnbWVudFJlZjxhbnk+W10gPSBbXTtcbiAgZm9yICh2YXIgaSA9IDA7IGkgPCBjb250ZXh0LmZyYWdtZW50cy5sZW5ndGg7IGkrKykge1xuICAgIGZyYWdtZW50cy5wdXNoKG5ldyBEZWZhdWx0UmVuZGVyRnJhZ21lbnRSZWYoY29udGV4dC5mcmFnbWVudHNbaV0pKTtcbiAgfVxuICB2aWV3ID0gbmV3IERlZmF1bHRSZW5kZXJWaWV3PGFueT4oZnJhZ21lbnRzLCBjb250ZXh0LmJvdW5kVGV4dE5vZGVzLCBjb250ZXh0LmJvdW5kRWxlbWVudHMsXG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBjb250ZXh0Lm5hdGl2ZVNoYWRvd1Jvb3RzLCBjb250ZXh0Lmdsb2JhbEV2ZW50QWRkZXJzLFxuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgY29udGV4dC5yb290Q29udGVudEluc2VydGlvblBvaW50cyk7XG4gIHJldHVybiB2aWV3O1xufVxuXG5leHBvcnQgaW50ZXJmYWNlIE5vZGVGYWN0b3J5PE4+IHtcbiAgcmVzb2x2ZUNvbXBvbmVudFRlbXBsYXRlKHRlbXBsYXRlSWQ6IHN0cmluZyk6IFJlbmRlckNvbXBvbmVudFRlbXBsYXRlO1xuICBjcmVhdGVUZW1wbGF0ZUFuY2hvcihhdHRyTmFtZUFuZFZhbHVlczogc3RyaW5nW10pOiBOO1xuICBjcmVhdGVFbGVtZW50KG5hbWU6IHN0cmluZywgYXR0ck5hbWVBbmRWYWx1ZXM6IHN0cmluZ1tdKTogTjtcbiAgY3JlYXRlUm9vdENvbnRlbnRJbnNlcnRpb25Qb2ludCgpOiBOO1xuICBtZXJnZUVsZW1lbnQoZXhpc3Rpbmc6IE4sIGF0dHJOYW1lQW5kVmFsdWVzOiBzdHJpbmdbXSk7XG4gIGNyZWF0ZVNoYWRvd1Jvb3QoaG9zdDogTiwgdGVtcGxhdGVJZDogc3RyaW5nKTogTjtcbiAgY3JlYXRlVGV4dCh2YWx1ZTogc3RyaW5nKTogTjtcbiAgYXBwZW5kQ2hpbGQocGFyZW50OiBOLCBjaGlsZDogTik7XG4gIG9uKGVsZW1lbnQ6IE4sIGV2ZW50TmFtZTogc3RyaW5nLCBjYWxsYmFjazogRnVuY3Rpb24pO1xuICBnbG9iYWxPbih0YXJnZXQ6IHN0cmluZywgZXZlbnROYW1lOiBzdHJpbmcsIGNhbGxiYWNrOiBGdW5jdGlvbik6IEZ1bmN0aW9uO1xufVxuXG5jbGFzcyBCdWlsZENvbnRleHQ8Tj4ge1xuICBjb25zdHJ1Y3Rvcihwcml2YXRlIF9ldmVudERpc3BhdGNoZXI6IEZ1bmN0aW9uLCBwdWJsaWMgZmFjdG9yeTogTm9kZUZhY3Rvcnk8Tj4sXG4gICAgICAgICAgICAgIHByaXZhdGUgX2lucGxhY2VFbGVtZW50OiBOKSB7XG4gICAgdGhpcy5pc0hvc3QgPSBpc1ByZXNlbnQoKF9pbnBsYWNlRWxlbWVudCkpO1xuICB9XG4gIHByaXZhdGUgX2J1aWxkZXJzOiBSZW5kZXJWaWV3QnVpbGRlcjxOPltdID0gW107XG5cbiAgZ2xvYmFsRXZlbnRBZGRlcnM6IEZ1bmN0aW9uW10gPSBbXTtcbiAgYm91bmRFbGVtZW50czogTltdID0gW107XG4gIGJvdW5kVGV4dE5vZGVzOiBOW10gPSBbXTtcbiAgbmF0aXZlU2hhZG93Um9vdHM6IE5bXSA9IFtdO1xuICBmcmFnbWVudHM6IE5bXVtdID0gW107XG4gIHJvb3RDb250ZW50SW5zZXJ0aW9uUG9pbnRzOiBOW10gPSBbXTtcbiAgY29tcG9uZW50Q291bnQ6IG51bWJlciA9IDA7XG4gIGlzSG9zdDogYm9vbGVhbjtcblxuICBidWlsZCh0ZW1wbGF0ZTogUmVuZGVyQ29tcG9uZW50VGVtcGxhdGUsIGNtZHM6IFJlbmRlclRlbXBsYXRlQ21kW10pIHtcbiAgICB0aGlzLmVucXVldWVSb290QnVpbGRlcih0ZW1wbGF0ZSwgY21kcyk7XG4gICAgdGhpcy5fYnVpbGQodGhpcy5fYnVpbGRlcnNbMF0pO1xuICB9XG5cbiAgcHJpdmF0ZSBfYnVpbGQoYnVpbGRlcjogUmVuZGVyVmlld0J1aWxkZXI8Tj4pIHtcbiAgICB0aGlzLl9idWlsZGVycyA9IFtdO1xuICAgIGJ1aWxkZXIuYnVpbGQodGhpcyk7XG4gICAgdmFyIGVucXVldWVkQnVpbGRlcnMgPSB0aGlzLl9idWlsZGVycztcbiAgICBmb3IgKHZhciBpID0gMDsgaSA8IGVucXVldWVkQnVpbGRlcnMubGVuZ3RoOyBpKyspIHtcbiAgICAgIHRoaXMuX2J1aWxkKGVucXVldWVkQnVpbGRlcnNbaV0pO1xuICAgIH1cbiAgfVxuXG4gIGVucXVldWVDb21wb25lbnRCdWlsZGVyKGNvbXBvbmVudDogQ29tcG9uZW50PE4+KSB7XG4gICAgdGhpcy5jb21wb25lbnRDb3VudCsrO1xuICAgIHRoaXMuX2J1aWxkZXJzLnB1c2goXG4gICAgICAgIG5ldyBSZW5kZXJWaWV3QnVpbGRlcjxOPihjb21wb25lbnQsIG51bGwsIGNvbXBvbmVudC50ZW1wbGF0ZSwgY29tcG9uZW50LnRlbXBsYXRlLmNvbW1hbmRzKSk7XG4gIH1cblxuICBlbnF1ZXVlRnJhZ21lbnRCdWlsZGVyKHBhcmVudENvbXBvbmVudDogQ29tcG9uZW50PE4+LCBwYXJlbnRUZW1wbGF0ZTogUmVuZGVyQ29tcG9uZW50VGVtcGxhdGUsXG4gICAgICAgICAgICAgICAgICAgICAgICAgY29tbWFuZHM6IFJlbmRlclRlbXBsYXRlQ21kW10pIHtcbiAgICB2YXIgcm9vdE5vZGVzID0gW107XG4gICAgdGhpcy5mcmFnbWVudHMucHVzaChyb290Tm9kZXMpO1xuICAgIHRoaXMuX2J1aWxkZXJzLnB1c2goXG4gICAgICAgIG5ldyBSZW5kZXJWaWV3QnVpbGRlcjxOPihwYXJlbnRDb21wb25lbnQsIHJvb3ROb2RlcywgcGFyZW50VGVtcGxhdGUsIGNvbW1hbmRzKSk7XG4gIH1cblxuICBlbnF1ZXVlUm9vdEJ1aWxkZXIodGVtcGxhdGU6IFJlbmRlckNvbXBvbmVudFRlbXBsYXRlLCBjbWRzOiBSZW5kZXJUZW1wbGF0ZUNtZFtdKSB7XG4gICAgdmFyIHJvb3ROb2RlcyA9IFtdO1xuICAgIHRoaXMuZnJhZ21lbnRzLnB1c2gocm9vdE5vZGVzKTtcbiAgICB0aGlzLl9idWlsZGVycy5wdXNoKG5ldyBSZW5kZXJWaWV3QnVpbGRlcjxOPihudWxsLCByb290Tm9kZXMsIHRlbXBsYXRlLCBjbWRzKSk7XG4gIH1cblxuICBjb25zdW1lSW5wbGFjZUVsZW1lbnQoKTogTiB7XG4gICAgdmFyIHJlc3VsdCA9IHRoaXMuX2lucGxhY2VFbGVtZW50O1xuICAgIHRoaXMuX2lucGxhY2VFbGVtZW50ID0gbnVsbDtcbiAgICByZXR1cm4gcmVzdWx0O1xuICB9XG5cbiAgYWRkRXZlbnRMaXN0ZW5lcihib3VuZEVsZW1lbnRJbmRleDogbnVtYmVyLCB0YXJnZXQ6IHN0cmluZywgZXZlbnROYW1lOiBzdHJpbmcpIHtcbiAgICBpZiAoaXNQcmVzZW50KHRhcmdldCkpIHtcbiAgICAgIHZhciBoYW5kbGVyID1cbiAgICAgICAgICBjcmVhdGVFdmVudEhhbmRsZXIoYm91bmRFbGVtZW50SW5kZXgsIGAke3RhcmdldH06JHtldmVudE5hbWV9YCwgdGhpcy5fZXZlbnREaXNwYXRjaGVyKTtcbiAgICAgIHRoaXMuZ2xvYmFsRXZlbnRBZGRlcnMucHVzaChjcmVhdGVHbG9iYWxFdmVudEFkZGVyKHRhcmdldCwgZXZlbnROYW1lLCBoYW5kbGVyLCB0aGlzLmZhY3RvcnkpKTtcbiAgICB9IGVsc2Uge1xuICAgICAgdmFyIGhhbmRsZXIgPSBjcmVhdGVFdmVudEhhbmRsZXIoYm91bmRFbGVtZW50SW5kZXgsIGV2ZW50TmFtZSwgdGhpcy5fZXZlbnREaXNwYXRjaGVyKTtcbiAgICAgIHRoaXMuZmFjdG9yeS5vbih0aGlzLmJvdW5kRWxlbWVudHNbYm91bmRFbGVtZW50SW5kZXhdLCBldmVudE5hbWUsIGhhbmRsZXIpO1xuICAgIH1cbiAgfVxufVxuXG5cbmZ1bmN0aW9uIGNyZWF0ZUV2ZW50SGFuZGxlcihib3VuZEVsZW1lbnRJbmRleDogbnVtYmVyLCBldmVudE5hbWU6IHN0cmluZyxcbiAgICAgICAgICAgICAgICAgICAgICAgICAgICBldmVudERpc3BhdGNoZXI6IEZ1bmN0aW9uKTogRnVuY3Rpb24ge1xuICByZXR1cm4gKCRldmVudCkgPT4gZXZlbnREaXNwYXRjaGVyKGJvdW5kRWxlbWVudEluZGV4LCBldmVudE5hbWUsICRldmVudCk7XG59XG5cbmZ1bmN0aW9uIGNyZWF0ZUdsb2JhbEV2ZW50QWRkZXIodGFyZ2V0OiBzdHJpbmcsIGV2ZW50TmFtZTogc3RyaW5nLCBldmVudEhhbmRsZXI6IEZ1bmN0aW9uLFxuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBub2RlRmFjdG9yeTogTm9kZUZhY3Rvcnk8YW55Pik6IEZ1bmN0aW9uIHtcbiAgcmV0dXJuICgpID0+IG5vZGVGYWN0b3J5Lmdsb2JhbE9uKHRhcmdldCwgZXZlbnROYW1lLCBldmVudEhhbmRsZXIpO1xufVxuXG5jbGFzcyBSZW5kZXJWaWV3QnVpbGRlcjxOPiBpbXBsZW1lbnRzIFJlbmRlckNvbW1hbmRWaXNpdG9yIHtcbiAgcGFyZW50U3RhY2s6IEFycmF5PE4gfCBDb21wb25lbnQ8Tj4+O1xuXG4gIGNvbnN0cnVjdG9yKHB1YmxpYyBwYXJlbnRDb21wb25lbnQ6IENvbXBvbmVudDxOPiwgcHVibGljIGZyYWdtZW50Um9vdE5vZGVzOiBOW10sXG4gICAgICAgICAgICAgIHB1YmxpYyB0ZW1wbGF0ZTogUmVuZGVyQ29tcG9uZW50VGVtcGxhdGUsIHB1YmxpYyBjbWRzOiBSZW5kZXJUZW1wbGF0ZUNtZFtdKSB7XG4gICAgdmFyIHJvb3ROb2Rlc1BhcmVudCA9IGlzUHJlc2VudChmcmFnbWVudFJvb3ROb2RlcykgPyBudWxsIDogcGFyZW50Q29tcG9uZW50LnNoYWRvd1Jvb3Q7XG4gICAgdGhpcy5wYXJlbnRTdGFjayA9IFtyb290Tm9kZXNQYXJlbnRdO1xuICB9XG5cbiAgYnVpbGQoY29udGV4dDogQnVpbGRDb250ZXh0PE4+KSB7XG4gICAgdmFyIGNtZHMgPSB0aGlzLmNtZHM7XG4gICAgZm9yICh2YXIgaSA9IDA7IGkgPCBjbWRzLmxlbmd0aDsgaSsrKSB7XG4gICAgICBjbWRzW2ldLnZpc2l0KHRoaXMsIGNvbnRleHQpO1xuICAgIH1cbiAgfVxuXG4gIGdldCBwYXJlbnQoKTogTiB8IENvbXBvbmVudDxOPiB7IHJldHVybiB0aGlzLnBhcmVudFN0YWNrW3RoaXMucGFyZW50U3RhY2subGVuZ3RoIC0gMV07IH1cblxuICB2aXNpdFRleHQoY21kOiBSZW5kZXJUZXh0Q21kLCBjb250ZXh0OiBCdWlsZENvbnRleHQ8Tj4pOiBhbnkge1xuICAgIHZhciB0ZXh0ID0gY29udGV4dC5mYWN0b3J5LmNyZWF0ZVRleHQoY21kLnZhbHVlKTtcbiAgICB0aGlzLl9hZGRDaGlsZCh0ZXh0LCBjbWQubmdDb250ZW50SW5kZXgsIGNvbnRleHQpO1xuICAgIGlmIChjbWQuaXNCb3VuZCkge1xuICAgICAgY29udGV4dC5ib3VuZFRleHROb2Rlcy5wdXNoKHRleHQpO1xuICAgIH1cbiAgICByZXR1cm4gbnVsbDtcbiAgfVxuICB2aXNpdE5nQ29udGVudChjbWQ6IFJlbmRlck5nQ29udGVudENtZCwgY29udGV4dDogQnVpbGRDb250ZXh0PE4+KTogYW55IHtcbiAgICBpZiAoaXNQcmVzZW50KHRoaXMucGFyZW50Q29tcG9uZW50KSkge1xuICAgICAgaWYgKHRoaXMucGFyZW50Q29tcG9uZW50LmlzUm9vdCkge1xuICAgICAgICB2YXIgaW5zZXJ0aW9uUG9pbnQgPSBjb250ZXh0LmZhY3RvcnkuY3JlYXRlUm9vdENvbnRlbnRJbnNlcnRpb25Qb2ludCgpO1xuICAgICAgICBpZiAodGhpcy5wYXJlbnQgaW5zdGFuY2VvZiBDb21wb25lbnQpIHtcbiAgICAgICAgICBjb250ZXh0LmZhY3RvcnkuYXBwZW5kQ2hpbGQoKDxDb21wb25lbnQ8Tj4+dGhpcy5wYXJlbnQpLnNoYWRvd1Jvb3QsIGluc2VydGlvblBvaW50KTtcbiAgICAgICAgfSBlbHNlIHtcbiAgICAgICAgICBjb250ZXh0LmZhY3RvcnkuYXBwZW5kQ2hpbGQoPE4+dGhpcy5wYXJlbnQsIGluc2VydGlvblBvaW50KTtcbiAgICAgICAgfVxuICAgICAgICBjb250ZXh0LnJvb3RDb250ZW50SW5zZXJ0aW9uUG9pbnRzLnB1c2goaW5zZXJ0aW9uUG9pbnQpO1xuICAgICAgfSBlbHNlIHtcbiAgICAgICAgdmFyIHByb2plY3RlZE5vZGVzID0gdGhpcy5wYXJlbnRDb21wb25lbnQucHJvamVjdChjbWQuaW5kZXgpO1xuICAgICAgICBmb3IgKHZhciBpID0gMDsgaSA8IHByb2plY3RlZE5vZGVzLmxlbmd0aDsgaSsrKSB7XG4gICAgICAgICAgdmFyIG5vZGUgPSBwcm9qZWN0ZWROb2Rlc1tpXTtcbiAgICAgICAgICB0aGlzLl9hZGRDaGlsZChub2RlLCBjbWQubmdDb250ZW50SW5kZXgsIGNvbnRleHQpO1xuICAgICAgICB9XG4gICAgICB9XG4gICAgfVxuICAgIHJldHVybiBudWxsO1xuICB9XG4gIHZpc2l0QmVnaW5FbGVtZW50KGNtZDogUmVuZGVyQmVnaW5FbGVtZW50Q21kLCBjb250ZXh0OiBCdWlsZENvbnRleHQ8Tj4pOiBhbnkge1xuICAgIHRoaXMucGFyZW50U3RhY2sucHVzaCh0aGlzLl9iZWdpbkVsZW1lbnQoY21kLCBjb250ZXh0LCBudWxsKSk7XG4gICAgcmV0dXJuIG51bGw7XG4gIH1cbiAgdmlzaXRFbmRFbGVtZW50KGNvbnRleHQ6IEJ1aWxkQ29udGV4dDxOPik6IGFueSB7XG4gICAgdGhpcy5fZW5kRWxlbWVudCgpO1xuICAgIHJldHVybiBudWxsO1xuICB9XG4gIHZpc2l0QmVnaW5Db21wb25lbnQoY21kOiBSZW5kZXJCZWdpbkNvbXBvbmVudENtZCwgY29udGV4dDogQnVpbGRDb250ZXh0PE4+KTogYW55IHtcbiAgICB2YXIgdGVtcGxhdGVJZCA9IGNtZC50ZW1wbGF0ZUlkO1xuICAgIHZhciB0cGwgPSBjb250ZXh0LmZhY3RvcnkucmVzb2x2ZUNvbXBvbmVudFRlbXBsYXRlKHRlbXBsYXRlSWQpO1xuICAgIHZhciBlbCA9IHRoaXMuX2JlZ2luRWxlbWVudChjbWQsIGNvbnRleHQsIHRwbCk7XG4gICAgdmFyIHJvb3QgPSBlbDtcblxuICAgIGlmICh0cGwuZW5jYXBzdWxhdGlvbiA9PT0gVmlld0VuY2Fwc3VsYXRpb24uTmF0aXZlKSB7XG4gICAgICByb290ID0gY29udGV4dC5mYWN0b3J5LmNyZWF0ZVNoYWRvd1Jvb3QoZWwsIHRlbXBsYXRlSWQpO1xuICAgICAgY29udGV4dC5uYXRpdmVTaGFkb3dSb290cy5wdXNoKHJvb3QpO1xuICAgIH1cbiAgICB2YXIgaXNSb290ID0gY29udGV4dC5jb21wb25lbnRDb3VudCA9PT0gMCAmJiBjb250ZXh0LmlzSG9zdDtcbiAgICB2YXIgY29tcG9uZW50ID0gbmV3IENvbXBvbmVudChlbCwgcm9vdCwgaXNSb290LCB0cGwpO1xuICAgIGNvbnRleHQuZW5xdWV1ZUNvbXBvbmVudEJ1aWxkZXIoY29tcG9uZW50KTtcbiAgICB0aGlzLnBhcmVudFN0YWNrLnB1c2goY29tcG9uZW50KTtcbiAgICByZXR1cm4gbnVsbDtcbiAgfVxuICB2aXNpdEVuZENvbXBvbmVudChjb250ZXh0OiBCdWlsZENvbnRleHQ8Tj4pOiBhbnkge1xuICAgIHRoaXMuX2VuZEVsZW1lbnQoKTtcbiAgICByZXR1cm4gbnVsbDtcbiAgfVxuICB2aXNpdEVtYmVkZGVkVGVtcGxhdGUoY21kOiBSZW5kZXJFbWJlZGRlZFRlbXBsYXRlQ21kLCBjb250ZXh0OiBCdWlsZENvbnRleHQ8Tj4pOiBhbnkge1xuICAgIHZhciBlbCA9IGNvbnRleHQuZmFjdG9yeS5jcmVhdGVUZW1wbGF0ZUFuY2hvcihjbWQuYXR0ck5hbWVBbmRWYWx1ZXMpO1xuICAgIHRoaXMuX2FkZENoaWxkKGVsLCBjbWQubmdDb250ZW50SW5kZXgsIGNvbnRleHQpO1xuICAgIGNvbnRleHQuYm91bmRFbGVtZW50cy5wdXNoKGVsKTtcbiAgICBpZiAoY21kLmlzTWVyZ2VkKSB7XG4gICAgICBjb250ZXh0LmVucXVldWVGcmFnbWVudEJ1aWxkZXIodGhpcy5wYXJlbnRDb21wb25lbnQsIHRoaXMudGVtcGxhdGUsIGNtZC5jaGlsZHJlbik7XG4gICAgfVxuICAgIHJldHVybiBudWxsO1xuICB9XG5cbiAgcHJpdmF0ZSBfYmVnaW5FbGVtZW50KGNtZDogUmVuZGVyQmVnaW5FbGVtZW50Q21kLCBjb250ZXh0OiBCdWlsZENvbnRleHQ8Tj4sXG4gICAgICAgICAgICAgICAgICAgICAgICBjb21wb25lbnRUZW1wbGF0ZTogUmVuZGVyQ29tcG9uZW50VGVtcGxhdGUpOiBOIHtcbiAgICB2YXIgZWw6IE4gPSBjb250ZXh0LmNvbnN1bWVJbnBsYWNlRWxlbWVudCgpO1xuICAgIHZhciBhdHRyTmFtZUFuZFZhbHVlcyA9IGNtZC5hdHRyTmFtZUFuZFZhbHVlcztcbiAgICB2YXIgdGVtcGxhdGVFbXVsYXRlZEVuY2Fwc3VsYXRpb24gPSB0aGlzLnRlbXBsYXRlLmVuY2Fwc3VsYXRpb24gPT09IFZpZXdFbmNhcHN1bGF0aW9uLkVtdWxhdGVkO1xuICAgIHZhciBjb21wb25lbnRFbXVsYXRlZEVuY2Fwc3VsYXRpb24gPVxuICAgICAgICBpc1ByZXNlbnQoY29tcG9uZW50VGVtcGxhdGUpICYmXG4gICAgICAgIGNvbXBvbmVudFRlbXBsYXRlLmVuY2Fwc3VsYXRpb24gPT09IFZpZXdFbmNhcHN1bGF0aW9uLkVtdWxhdGVkO1xuICAgIHZhciBuZXdBdHRyTGVuZ3RoID0gYXR0ck5hbWVBbmRWYWx1ZXMubGVuZ3RoICsgKHRlbXBsYXRlRW11bGF0ZWRFbmNhcHN1bGF0aW9uID8gMiA6IDApICtcbiAgICAgICAgICAgICAgICAgICAgICAgIChjb21wb25lbnRFbXVsYXRlZEVuY2Fwc3VsYXRpb24gPyAyIDogMCk7XG4gICAgaWYgKG5ld0F0dHJMZW5ndGggPiBhdHRyTmFtZUFuZFZhbHVlcy5sZW5ndGgpIHtcbiAgICAgIC8vIE5vdGU6IE5lZWQgdG8gY2xvbmUgYXR0ck5hbWVBbmRWYWx1ZXMgdG8gbWFrZSBpdCB3cml0YWJsZSFcbiAgICAgIHZhciBuZXdBdHRyTmFtZUFuZFZhbHVlcyA9IExpc3RXcmFwcGVyLmNyZWF0ZUZpeGVkU2l6ZShuZXdBdHRyTGVuZ3RoKTtcbiAgICAgIHZhciBhdHRySW5kZXg7XG4gICAgICBmb3IgKGF0dHJJbmRleCA9IDA7IGF0dHJJbmRleCA8IGF0dHJOYW1lQW5kVmFsdWVzLmxlbmd0aDsgYXR0ckluZGV4KyspIHtcbiAgICAgICAgbmV3QXR0ck5hbWVBbmRWYWx1ZXNbYXR0ckluZGV4XSA9IGF0dHJOYW1lQW5kVmFsdWVzW2F0dHJJbmRleF07XG4gICAgICB9XG4gICAgICBpZiAodGVtcGxhdGVFbXVsYXRlZEVuY2Fwc3VsYXRpb24pIHtcbiAgICAgICAgbmV3QXR0ck5hbWVBbmRWYWx1ZXNbYXR0ckluZGV4KytdID0gX3NoaW1Db250ZW50QXR0cmlidXRlKHRoaXMudGVtcGxhdGUuc2hvcnRJZCk7XG4gICAgICAgIG5ld0F0dHJOYW1lQW5kVmFsdWVzW2F0dHJJbmRleCsrXSA9ICcnO1xuICAgICAgfVxuICAgICAgaWYgKGNvbXBvbmVudEVtdWxhdGVkRW5jYXBzdWxhdGlvbikge1xuICAgICAgICBuZXdBdHRyTmFtZUFuZFZhbHVlc1thdHRySW5kZXgrK10gPSBfc2hpbUhvc3RBdHRyaWJ1dGUoY29tcG9uZW50VGVtcGxhdGUuc2hvcnRJZCk7XG4gICAgICAgIG5ld0F0dHJOYW1lQW5kVmFsdWVzW2F0dHJJbmRleCsrXSA9ICcnO1xuICAgICAgfVxuICAgICAgYXR0ck5hbWVBbmRWYWx1ZXMgPSBuZXdBdHRyTmFtZUFuZFZhbHVlcztcbiAgICB9XG4gICAgaWYgKGlzUHJlc2VudChlbCkpIHtcbiAgICAgIGNvbnRleHQuZmFjdG9yeS5tZXJnZUVsZW1lbnQoZWwsIGF0dHJOYW1lQW5kVmFsdWVzKTtcbiAgICAgIHRoaXMuZnJhZ21lbnRSb290Tm9kZXMucHVzaChlbCk7XG4gICAgfSBlbHNlIHtcbiAgICAgIGVsID0gY29udGV4dC5mYWN0b3J5LmNyZWF0ZUVsZW1lbnQoY21kLm5hbWUsIGF0dHJOYW1lQW5kVmFsdWVzKTtcbiAgICAgIHRoaXMuX2FkZENoaWxkKGVsLCBjbWQubmdDb250ZW50SW5kZXgsIGNvbnRleHQpO1xuICAgIH1cbiAgICBpZiAoY21kLmlzQm91bmQpIHtcbiAgICAgIHZhciBib3VuZEVsZW1lbnRJbmRleCA9IGNvbnRleHQuYm91bmRFbGVtZW50cy5sZW5ndGg7XG4gICAgICBjb250ZXh0LmJvdW5kRWxlbWVudHMucHVzaChlbCk7XG4gICAgICBmb3IgKHZhciBpID0gMDsgaSA8IGNtZC5ldmVudFRhcmdldEFuZE5hbWVzLmxlbmd0aDsgaSArPSAyKSB7XG4gICAgICAgIHZhciB0YXJnZXQgPSBjbWQuZXZlbnRUYXJnZXRBbmROYW1lc1tpXTtcbiAgICAgICAgdmFyIGV2ZW50TmFtZSA9IGNtZC5ldmVudFRhcmdldEFuZE5hbWVzW2kgKyAxXTtcbiAgICAgICAgY29udGV4dC5hZGRFdmVudExpc3RlbmVyKGJvdW5kRWxlbWVudEluZGV4LCB0YXJnZXQsIGV2ZW50TmFtZSk7XG4gICAgICB9XG4gICAgfVxuICAgIHJldHVybiBlbDtcbiAgfVxuXG4gIHByaXZhdGUgX2VuZEVsZW1lbnQoKSB7IHRoaXMucGFyZW50U3RhY2sucG9wKCk7IH1cblxuICBwcml2YXRlIF9hZGRDaGlsZChub2RlOiBOLCBuZ0NvbnRlbnRJbmRleDogbnVtYmVyLCBjb250ZXh0OiBCdWlsZENvbnRleHQ8Tj4pIHtcbiAgICB2YXIgcGFyZW50ID0gdGhpcy5wYXJlbnQ7XG4gICAgaWYgKGlzUHJlc2VudChwYXJlbnQpKSB7XG4gICAgICBpZiAocGFyZW50IGluc3RhbmNlb2YgQ29tcG9uZW50KSB7XG4gICAgICAgIHBhcmVudC5hZGRDb250ZW50Tm9kZShuZ0NvbnRlbnRJbmRleCwgbm9kZSwgY29udGV4dCk7XG4gICAgICB9IGVsc2Uge1xuICAgICAgICBjb250ZXh0LmZhY3RvcnkuYXBwZW5kQ2hpbGQoPE4+cGFyZW50LCBub2RlKTtcbiAgICAgIH1cbiAgICB9IGVsc2Uge1xuICAgICAgdGhpcy5mcmFnbWVudFJvb3ROb2Rlcy5wdXNoKG5vZGUpO1xuICAgIH1cbiAgfVxufVxuXG5jbGFzcyBDb21wb25lbnQ8Tj4ge1xuICBwcml2YXRlIGNvbnRlbnROb2Rlc0J5TmdDb250ZW50SW5kZXg6IE5bXVtdID0gW107XG5cbiAgY29uc3RydWN0b3IocHVibGljIGhvc3RFbGVtZW50OiBOLCBwdWJsaWMgc2hhZG93Um9vdDogTiwgcHVibGljIGlzUm9vdDogYm9vbGVhbixcbiAgICAgICAgICAgICAgcHVibGljIHRlbXBsYXRlOiBSZW5kZXJDb21wb25lbnRUZW1wbGF0ZSkge31cbiAgYWRkQ29udGVudE5vZGUobmdDb250ZW50SW5kZXg6IG51bWJlciwgbm9kZTogTiwgY29udGV4dDogQnVpbGRDb250ZXh0PE4+KSB7XG4gICAgaWYgKGlzQmxhbmsobmdDb250ZW50SW5kZXgpKSB7XG4gICAgICBpZiAodGhpcy50ZW1wbGF0ZS5lbmNhcHN1bGF0aW9uID09PSBWaWV3RW5jYXBzdWxhdGlvbi5OYXRpdmUpIHtcbiAgICAgICAgY29udGV4dC5mYWN0b3J5LmFwcGVuZENoaWxkKHRoaXMuaG9zdEVsZW1lbnQsIG5vZGUpO1xuICAgICAgfVxuICAgIH0gZWxzZSB7XG4gICAgICB3aGlsZSAodGhpcy5jb250ZW50Tm9kZXNCeU5nQ29udGVudEluZGV4Lmxlbmd0aCA8PSBuZ0NvbnRlbnRJbmRleCkge1xuICAgICAgICB0aGlzLmNvbnRlbnROb2Rlc0J5TmdDb250ZW50SW5kZXgucHVzaChbXSk7XG4gICAgICB9XG4gICAgICB0aGlzLmNvbnRlbnROb2Rlc0J5TmdDb250ZW50SW5kZXhbbmdDb250ZW50SW5kZXhdLnB1c2gobm9kZSk7XG4gICAgfVxuICB9XG4gIHByb2plY3QobmdDb250ZW50SW5kZXg6IG51bWJlcik6IE5bXSB7XG4gICAgcmV0dXJuIG5nQ29udGVudEluZGV4IDwgdGhpcy5jb250ZW50Tm9kZXNCeU5nQ29udGVudEluZGV4Lmxlbmd0aCA/XG4gICAgICAgICAgICAgICB0aGlzLmNvbnRlbnROb2Rlc0J5TmdDb250ZW50SW5kZXhbbmdDb250ZW50SW5kZXhdIDpcbiAgICAgICAgICAgICAgIFtdO1xuICB9XG59XG5cbnZhciBDT01QT05FTlRfUkVHRVggPSAvJUNPTVAlL2c7XG5leHBvcnQgY29uc3QgQ09NUE9ORU5UX1ZBUklBQkxFID0gJyVDT01QJSc7XG5leHBvcnQgY29uc3QgSE9TVF9BVFRSID0gYF9uZ2hvc3QtJHtDT01QT05FTlRfVkFSSUFCTEV9YDtcbmV4cG9ydCBjb25zdCBDT05URU5UX0FUVFIgPSBgX25nY29udGVudC0ke0NPTVBPTkVOVF9WQVJJQUJMRX1gO1xuXG5mdW5jdGlvbiBfc2hpbUNvbnRlbnRBdHRyaWJ1dGUoY29tcG9uZW50U2hvcnRJZDogc3RyaW5nKTogc3RyaW5nIHtcbiAgcmV0dXJuIFN0cmluZ1dyYXBwZXIucmVwbGFjZUFsbChDT05URU5UX0FUVFIsIENPTVBPTkVOVF9SRUdFWCwgY29tcG9uZW50U2hvcnRJZCk7XG59XG5cbmZ1bmN0aW9uIF9zaGltSG9zdEF0dHJpYnV0ZShjb21wb25lbnRTaG9ydElkOiBzdHJpbmcpOiBzdHJpbmcge1xuICByZXR1cm4gU3RyaW5nV3JhcHBlci5yZXBsYWNlQWxsKEhPU1RfQVRUUiwgQ09NUE9ORU5UX1JFR0VYLCBjb21wb25lbnRTaG9ydElkKTtcbn1cbiJdfQ==