'use strict';var __extends = (this && this.__extends) || function (d, b) {
    for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p];
    function __() { this.constructor = d; }
    d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
};
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var __param = (this && this.__param) || function (paramIndex, decorator) {
    return function (target, key) { decorator(target, key, paramIndex); }
};
var di_1 = require('angular2/src/core/di');
var animation_builder_1 = require('angular2/src/animate/animation_builder');
var lang_1 = require('angular2/src/facade/lang');
var exceptions_1 = require('angular2/src/facade/exceptions');
var shared_styles_host_1 = require('./shared_styles_host');
var profile_1 = require('angular2/src/core/profile/profile');
var core_1 = require('angular2/core');
var event_manager_1 = require('./events/event_manager');
var dom_tokens_1 = require('./dom_tokens');
var view_factory_1 = require('angular2/src/core/render/view_factory');
var view_1 = require('angular2/src/core/render/view');
var metadata_1 = require('angular2/src/core/metadata');
var dom_adapter_1 = require('angular2/src/platform/dom/dom_adapter');
var util_1 = require('./util');
var NAMESPACE_URIS = lang_1.CONST_EXPR({ 'xlink': 'http://www.w3.org/1999/xlink', 'svg': 'http://www.w3.org/2000/svg' });
var TEMPLATE_COMMENT_TEXT = 'template bindings={}';
var TEMPLATE_BINDINGS_EXP = /^template bindings=(.*)$/g;
var DomRenderer = (function (_super) {
    __extends(DomRenderer, _super);
    function DomRenderer() {
        _super.apply(this, arguments);
    }
    DomRenderer.prototype.getNativeElementSync = function (location) {
        return resolveInternalDomView(location.renderView).boundElements[location.boundElementIndex];
    };
    DomRenderer.prototype.getRootNodes = function (fragment) { return resolveInternalDomFragment(fragment); };
    DomRenderer.prototype.attachFragmentAfterFragment = function (previousFragmentRef, fragmentRef) {
        var previousFragmentNodes = resolveInternalDomFragment(previousFragmentRef);
        if (previousFragmentNodes.length > 0) {
            var sibling = previousFragmentNodes[previousFragmentNodes.length - 1];
            var nodes = resolveInternalDomFragment(fragmentRef);
            moveNodesAfterSibling(sibling, nodes);
            this.animateNodesEnter(nodes);
        }
    };
    /**
     * Iterates through all nodes being added to the DOM and animates them if necessary
     * @param nodes
     */
    DomRenderer.prototype.animateNodesEnter = function (nodes) {
        for (var i = 0; i < nodes.length; i++)
            this.animateNodeEnter(nodes[i]);
    };
    DomRenderer.prototype.attachFragmentAfterElement = function (elementRef, fragmentRef) {
        var parentView = resolveInternalDomView(elementRef.renderView);
        var element = parentView.boundElements[elementRef.boundElementIndex];
        var nodes = resolveInternalDomFragment(fragmentRef);
        moveNodesAfterSibling(element, nodes);
        this.animateNodesEnter(nodes);
    };
    DomRenderer.prototype.hydrateView = function (viewRef) { resolveInternalDomView(viewRef).hydrate(); };
    DomRenderer.prototype.dehydrateView = function (viewRef) { resolveInternalDomView(viewRef).dehydrate(); };
    DomRenderer.prototype.createTemplateAnchor = function (attrNameAndValues) {
        return dom_adapter_1.DOM.createComment(TEMPLATE_COMMENT_TEXT);
    };
    DomRenderer.prototype.createText = function (value) { return dom_adapter_1.DOM.createTextNode(lang_1.isPresent(value) ? value : ''); };
    DomRenderer.prototype.appendChild = function (parent, child) { dom_adapter_1.DOM.appendChild(parent, child); };
    DomRenderer.prototype.setElementProperty = function (location, propertyName, propertyValue) {
        var view = resolveInternalDomView(location.renderView);
        dom_adapter_1.DOM.setProperty(view.boundElements[location.boundElementIndex], propertyName, propertyValue);
    };
    DomRenderer.prototype.setElementAttribute = function (location, attributeName, attributeValue) {
        var view = resolveInternalDomView(location.renderView);
        var element = view.boundElements[location.boundElementIndex];
        if (lang_1.isPresent(attributeValue)) {
            dom_adapter_1.DOM.setAttribute(element, attributeName, lang_1.stringify(attributeValue));
        }
        else {
            dom_adapter_1.DOM.removeAttribute(element, attributeName);
        }
    };
    /**
     * Used only in debug mode to serialize property changes to comment nodes,
     * such as <template> placeholders.
     */
    DomRenderer.prototype.setBindingDebugInfo = function (location, propertyName, propertyValue) {
        var view = resolveInternalDomView(location.renderView);
        var element = view.boundElements[location.boundElementIndex];
        var dashCasedPropertyName = util_1.camelCaseToDashCase(propertyName);
        if (dom_adapter_1.DOM.isCommentNode(element)) {
            var existingBindings = lang_1.RegExpWrapper.firstMatch(TEMPLATE_BINDINGS_EXP, lang_1.StringWrapper.replaceAll(dom_adapter_1.DOM.getText(element), /\n/g, ''));
            var parsedBindings = lang_1.Json.parse(existingBindings[1]);
            parsedBindings[dashCasedPropertyName] = propertyValue;
            dom_adapter_1.DOM.setText(element, lang_1.StringWrapper.replace(TEMPLATE_COMMENT_TEXT, '{}', lang_1.Json.stringify(parsedBindings)));
        }
        else {
            this.setElementAttribute(location, propertyName, propertyValue);
        }
    };
    DomRenderer.prototype.setElementClass = function (location, className, isAdd) {
        var view = resolveInternalDomView(location.renderView);
        var element = view.boundElements[location.boundElementIndex];
        if (isAdd) {
            dom_adapter_1.DOM.addClass(element, className);
        }
        else {
            dom_adapter_1.DOM.removeClass(element, className);
        }
    };
    DomRenderer.prototype.setElementStyle = function (location, styleName, styleValue) {
        var view = resolveInternalDomView(location.renderView);
        var element = view.boundElements[location.boundElementIndex];
        if (lang_1.isPresent(styleValue)) {
            dom_adapter_1.DOM.setStyle(element, styleName, lang_1.stringify(styleValue));
        }
        else {
            dom_adapter_1.DOM.removeStyle(element, styleName);
        }
    };
    DomRenderer.prototype.invokeElementMethod = function (location, methodName, args) {
        var view = resolveInternalDomView(location.renderView);
        var element = view.boundElements[location.boundElementIndex];
        dom_adapter_1.DOM.invoke(element, methodName, args);
    };
    DomRenderer.prototype.setText = function (viewRef, textNodeIndex, text) {
        var view = resolveInternalDomView(viewRef);
        dom_adapter_1.DOM.setText(view.boundTextNodes[textNodeIndex], text);
    };
    DomRenderer.prototype.setEventDispatcher = function (viewRef, dispatcher) {
        resolveInternalDomView(viewRef).setEventDispatcher(dispatcher);
    };
    return DomRenderer;
})(core_1.Renderer);
exports.DomRenderer = DomRenderer;
var DomRenderer_ = (function (_super) {
    __extends(DomRenderer_, _super);
    function DomRenderer_(_eventManager, _domSharedStylesHost, _animate, document) {
        _super.call(this);
        this._eventManager = _eventManager;
        this._domSharedStylesHost = _domSharedStylesHost;
        this._animate = _animate;
        this._componentTpls = new Map();
        /** @internal */
        this._createRootHostViewScope = profile_1.wtfCreateScope('DomRenderer#createRootHostView()');
        /** @internal */
        this._createViewScope = profile_1.wtfCreateScope('DomRenderer#createView()');
        /** @internal */
        this._detachFragmentScope = profile_1.wtfCreateScope('DomRenderer#detachFragment()');
        this._document = document;
    }
    DomRenderer_.prototype.registerComponentTemplate = function (template) {
        this._componentTpls.set(template.id, template);
        if (template.encapsulation !== metadata_1.ViewEncapsulation.Native) {
            var encapsulatedStyles = view_factory_1.encapsulateStyles(template);
            this._domSharedStylesHost.addStyles(encapsulatedStyles);
        }
    };
    DomRenderer_.prototype.createProtoView = function (componentTemplateId, cmds) {
        return new view_1.DefaultProtoViewRef(this._componentTpls.get(componentTemplateId), cmds);
    };
    DomRenderer_.prototype.resolveComponentTemplate = function (templateId) {
        return this._componentTpls.get(templateId);
    };
    DomRenderer_.prototype.createRootHostView = function (hostProtoViewRef, fragmentCount, hostElementSelector) {
        var s = this._createRootHostViewScope();
        var element = dom_adapter_1.DOM.querySelector(this._document, hostElementSelector);
        if (lang_1.isBlank(element)) {
            profile_1.wtfLeave(s);
            throw new exceptions_1.BaseException("The selector \"" + hostElementSelector + "\" did not match any elements");
        }
        return profile_1.wtfLeave(s, this._createView(hostProtoViewRef, element));
    };
    DomRenderer_.prototype.createView = function (protoViewRef, fragmentCount) {
        var s = this._createViewScope();
        return profile_1.wtfLeave(s, this._createView(protoViewRef, null));
    };
    DomRenderer_.prototype._createView = function (protoViewRef, inplaceElement) {
        var dpvr = protoViewRef;
        var view = view_factory_1.createRenderView(dpvr.template, dpvr.cmds, inplaceElement, this);
        var sdRoots = view.nativeShadowRoots;
        for (var i = 0; i < sdRoots.length; i++) {
            this._domSharedStylesHost.addHost(sdRoots[i]);
        }
        return new core_1.RenderViewWithFragments(view, view.fragments);
    };
    DomRenderer_.prototype.destroyView = function (viewRef) {
        var view = viewRef;
        var sdRoots = view.nativeShadowRoots;
        for (var i = 0; i < sdRoots.length; i++) {
            this._domSharedStylesHost.removeHost(sdRoots[i]);
        }
    };
    DomRenderer_.prototype.animateNodeEnter = function (node) {
        if (dom_adapter_1.DOM.isElementNode(node) && dom_adapter_1.DOM.hasClass(node, 'ng-animate')) {
            dom_adapter_1.DOM.addClass(node, 'ng-enter');
            this._animate.css()
                .addAnimationClass('ng-enter-active')
                .start(node)
                .onComplete(function () { dom_adapter_1.DOM.removeClass(node, 'ng-enter'); });
        }
    };
    DomRenderer_.prototype.animateNodeLeave = function (node) {
        if (dom_adapter_1.DOM.isElementNode(node) && dom_adapter_1.DOM.hasClass(node, 'ng-animate')) {
            dom_adapter_1.DOM.addClass(node, 'ng-leave');
            this._animate.css()
                .addAnimationClass('ng-leave-active')
                .start(node)
                .onComplete(function () {
                dom_adapter_1.DOM.removeClass(node, 'ng-leave');
                dom_adapter_1.DOM.remove(node);
            });
        }
        else {
            dom_adapter_1.DOM.remove(node);
        }
    };
    DomRenderer_.prototype.detachFragment = function (fragmentRef) {
        var s = this._detachFragmentScope();
        var fragmentNodes = resolveInternalDomFragment(fragmentRef);
        for (var i = 0; i < fragmentNodes.length; i++) {
            this.animateNodeLeave(fragmentNodes[i]);
        }
        profile_1.wtfLeave(s);
    };
    DomRenderer_.prototype.createElement = function (name, attrNameAndValues) {
        var nsAndName = splitNamespace(name);
        var el = lang_1.isPresent(nsAndName[0]) ?
            dom_adapter_1.DOM.createElementNS(NAMESPACE_URIS[nsAndName[0]], nsAndName[1]) :
            dom_adapter_1.DOM.createElement(nsAndName[1]);
        this._setAttributes(el, attrNameAndValues);
        return el;
    };
    DomRenderer_.prototype.mergeElement = function (existing, attrNameAndValues) {
        dom_adapter_1.DOM.clearNodes(existing);
        this._setAttributes(existing, attrNameAndValues);
    };
    DomRenderer_.prototype._setAttributes = function (node, attrNameAndValues) {
        for (var attrIdx = 0; attrIdx < attrNameAndValues.length; attrIdx += 2) {
            var attrNs;
            var attrName = attrNameAndValues[attrIdx];
            var nsAndName = splitNamespace(attrName);
            if (lang_1.isPresent(nsAndName[0])) {
                attrName = nsAndName[0] + ':' + nsAndName[1];
                attrNs = NAMESPACE_URIS[nsAndName[0]];
            }
            var attrValue = attrNameAndValues[attrIdx + 1];
            if (lang_1.isPresent(attrNs)) {
                dom_adapter_1.DOM.setAttributeNS(node, attrNs, attrName, attrValue);
            }
            else {
                dom_adapter_1.DOM.setAttribute(node, nsAndName[1], attrValue);
            }
        }
    };
    DomRenderer_.prototype.createRootContentInsertionPoint = function () {
        return dom_adapter_1.DOM.createComment('root-content-insertion-point');
    };
    DomRenderer_.prototype.createShadowRoot = function (host, templateId) {
        var sr = dom_adapter_1.DOM.createShadowRoot(host);
        var tpl = this._componentTpls.get(templateId);
        for (var i = 0; i < tpl.styles.length; i++) {
            dom_adapter_1.DOM.appendChild(sr, dom_adapter_1.DOM.createStyleElement(tpl.styles[i]));
        }
        return sr;
    };
    DomRenderer_.prototype.on = function (element, eventName, callback) {
        this._eventManager.addEventListener(element, eventName, decoratePreventDefault(callback));
    };
    DomRenderer_.prototype.globalOn = function (target, eventName, callback) {
        return this._eventManager.addGlobalEventListener(target, eventName, decoratePreventDefault(callback));
    };
    DomRenderer_ = __decorate([
        di_1.Injectable(),
        __param(3, di_1.Inject(dom_tokens_1.DOCUMENT)), 
        __metadata('design:paramtypes', [event_manager_1.EventManager, shared_styles_host_1.DomSharedStylesHost, animation_builder_1.AnimationBuilder, Object])
    ], DomRenderer_);
    return DomRenderer_;
})(DomRenderer);
exports.DomRenderer_ = DomRenderer_;
function resolveInternalDomView(viewRef) {
    return viewRef;
}
function resolveInternalDomFragment(fragmentRef) {
    return fragmentRef.nodes;
}
function moveNodesAfterSibling(sibling, nodes) {
    var parent = dom_adapter_1.DOM.parentElement(sibling);
    if (nodes.length > 0 && lang_1.isPresent(parent)) {
        var nextSibling = dom_adapter_1.DOM.nextSibling(sibling);
        if (lang_1.isPresent(nextSibling)) {
            for (var i = 0; i < nodes.length; i++) {
                dom_adapter_1.DOM.insertBefore(nextSibling, nodes[i]);
            }
        }
        else {
            for (var i = 0; i < nodes.length; i++) {
                dom_adapter_1.DOM.appendChild(parent, nodes[i]);
            }
        }
    }
}
function decoratePreventDefault(eventHandler) {
    return function (event) {
        var allowDefaultBehavior = eventHandler(event);
        if (!allowDefaultBehavior) {
            // TODO(tbosch): move preventDefault into event plugins...
            dom_adapter_1.DOM.preventDefault(event);
        }
    };
}
var NS_PREFIX_RE = /^@([^:]+):(.+)/g;
function splitNamespace(name) {
    if (name[0] != '@') {
        return [null, name];
    }
    var match = lang_1.RegExpWrapper.firstMatch(NS_PREFIX_RE, name);
    return [match[1], match[2]];
}
//# sourceMappingURL=data:application/json;base64,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