'use strict';var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var lang_1 = require("angular2/src/facade/lang");
var exceptions_1 = require('angular2/src/facade/exceptions');
var collection_1 = require("angular2/src/facade/collection");
var api_1 = require("angular2/src/core/render/api");
var api_2 = require('angular2/src/web_workers/shared/api');
var di_1 = require("angular2/src/core/di");
var render_proto_view_ref_store_1 = require('angular2/src/web_workers/shared/render_proto_view_ref_store');
var render_view_with_fragments_store_1 = require('angular2/src/web_workers/shared/render_view_with_fragments_store');
var view_1 = require('angular2/src/core/metadata/view');
// PRIMITIVE is any type that does not need to be serialized (string, number, boolean)
// We set it to String so that it is considered a Type.
exports.PRIMITIVE = String;
var Serializer = (function () {
    function Serializer(_protoViewStore, _renderViewStore) {
        this._protoViewStore = _protoViewStore;
        this._renderViewStore = _renderViewStore;
    }
    Serializer.prototype.serialize = function (obj, type) {
        var _this = this;
        if (!lang_1.isPresent(obj)) {
            return null;
        }
        if (lang_1.isArray(obj)) {
            return obj.map(function (v) { return _this.serialize(v, type); });
        }
        if (type == exports.PRIMITIVE) {
            return obj;
        }
        if (type == api_1.RenderProtoViewRef) {
            return this._protoViewStore.serialize(obj);
        }
        else if (type == api_1.RenderViewRef) {
            return this._renderViewStore.serializeRenderViewRef(obj);
        }
        else if (type == api_1.RenderFragmentRef) {
            return this._renderViewStore.serializeRenderFragmentRef(obj);
        }
        else if (type == api_2.WebWorkerElementRef) {
            return this._serializeWorkerElementRef(obj);
        }
        else if (type == api_2.WebWorkerTemplateCmd) {
            return serializeTemplateCmd(obj);
        }
        else if (type === api_1.RenderComponentTemplate) {
            return this._serializeRenderTemplate(obj);
        }
        else if (type === view_1.ViewEncapsulation) {
            return lang_1.serializeEnum(obj);
        }
        else {
            throw new exceptions_1.BaseException("No serializer for " + type.toString());
        }
    };
    Serializer.prototype.deserialize = function (map, type, data) {
        var _this = this;
        if (!lang_1.isPresent(map)) {
            return null;
        }
        if (lang_1.isArray(map)) {
            var obj = [];
            map.forEach(function (val) { return obj.push(_this.deserialize(val, type, data)); });
            return obj;
        }
        if (type == exports.PRIMITIVE) {
            return map;
        }
        if (type == api_1.RenderProtoViewRef) {
            return this._protoViewStore.deserialize(map);
        }
        else if (type == api_1.RenderViewRef) {
            return this._renderViewStore.deserializeRenderViewRef(map);
        }
        else if (type == api_1.RenderFragmentRef) {
            return this._renderViewStore.deserializeRenderFragmentRef(map);
        }
        else if (type == api_2.WebWorkerElementRef) {
            return this._deserializeWorkerElementRef(map);
        }
        else if (type == api_2.WebWorkerTemplateCmd) {
            return deserializeTemplateCmd(map);
        }
        else if (type === api_1.RenderComponentTemplate) {
            return this._deserializeRenderTemplate(map);
        }
        else if (type === view_1.ViewEncapsulation) {
            return view_1.VIEW_ENCAPSULATION_VALUES[map];
        }
        else {
            throw new exceptions_1.BaseException("No deserializer for " + type.toString());
        }
    };
    Serializer.prototype.mapToObject = function (map, type) {
        var _this = this;
        var object = {};
        var serialize = lang_1.isPresent(type);
        map.forEach(function (value, key) {
            if (serialize) {
                object[key] = _this.serialize(value, type);
            }
            else {
                object[key] = value;
            }
        });
        return object;
    };
    /*
     * Transforms a Javascript object (StringMap) into a Map<string, V>
     * If the values need to be deserialized pass in their type
     * and they will be deserialized before being placed in the map
     */
    Serializer.prototype.objectToMap = function (obj, type, data) {
        var _this = this;
        if (lang_1.isPresent(type)) {
            var map = new collection_1.Map();
            collection_1.StringMapWrapper.forEach(obj, function (val, key) { map.set(key, _this.deserialize(val, type, data)); });
            return map;
        }
        else {
            return collection_1.MapWrapper.createFromStringMap(obj);
        }
    };
    Serializer.prototype.allocateRenderViews = function (fragmentCount) { this._renderViewStore.allocate(fragmentCount); };
    Serializer.prototype._serializeWorkerElementRef = function (elementRef) {
        return {
            'renderView': this.serialize(elementRef.renderView, api_1.RenderViewRef),
            'boundElementIndex': elementRef.boundElementIndex
        };
    };
    Serializer.prototype._deserializeWorkerElementRef = function (map) {
        return new api_2.WebWorkerElementRef(this.deserialize(map['renderView'], api_1.RenderViewRef), map['boundElementIndex']);
    };
    Serializer.prototype._serializeRenderTemplate = function (obj) {
        return {
            'id': obj.id,
            'shortId': obj.shortId,
            'encapsulation': this.serialize(obj.encapsulation, view_1.ViewEncapsulation),
            'commands': this.serialize(obj.commands, api_2.WebWorkerTemplateCmd),
            'styles': this.serialize(obj.styles, exports.PRIMITIVE)
        };
    };
    Serializer.prototype._deserializeRenderTemplate = function (map) {
        return new api_1.RenderComponentTemplate(map['id'], map['shortId'], this.deserialize(map['encapsulation'], view_1.ViewEncapsulation), this.deserialize(map['commands'], api_2.WebWorkerTemplateCmd), this.deserialize(map['styles'], exports.PRIMITIVE));
    };
    Serializer = __decorate([
        di_1.Injectable(), 
        __metadata('design:paramtypes', [render_proto_view_ref_store_1.RenderProtoViewRefStore, render_view_with_fragments_store_1.RenderViewWithFragmentsStore])
    ], Serializer);
    return Serializer;
})();
exports.Serializer = Serializer;
function serializeTemplateCmd(cmd) {
    return cmd.visit(RENDER_TEMPLATE_CMD_SERIALIZER, null);
}
function deserializeTemplateCmd(data) {
    return RENDER_TEMPLATE_CMD_DESERIALIZERS[data['deserializerIndex']](data);
}
var RenderTemplateCmdSerializer = (function () {
    function RenderTemplateCmdSerializer() {
    }
    RenderTemplateCmdSerializer.prototype.visitText = function (cmd, context) {
        return {
            'deserializerIndex': 0,
            'isBound': cmd.isBound,
            'ngContentIndex': cmd.ngContentIndex,
            'value': cmd.value
        };
    };
    RenderTemplateCmdSerializer.prototype.visitNgContent = function (cmd, context) {
        return { 'deserializerIndex': 1, 'index': cmd.index, 'ngContentIndex': cmd.ngContentIndex };
    };
    RenderTemplateCmdSerializer.prototype.visitBeginElement = function (cmd, context) {
        return {
            'deserializerIndex': 2,
            'isBound': cmd.isBound,
            'ngContentIndex': cmd.ngContentIndex,
            'name': cmd.name,
            'attrNameAndValues': cmd.attrNameAndValues,
            'eventTargetAndNames': cmd.eventTargetAndNames
        };
    };
    RenderTemplateCmdSerializer.prototype.visitEndElement = function (context) { return { 'deserializerIndex': 3 }; };
    RenderTemplateCmdSerializer.prototype.visitBeginComponent = function (cmd, context) {
        return {
            'deserializerIndex': 4,
            'isBound': cmd.isBound,
            'ngContentIndex': cmd.ngContentIndex,
            'name': cmd.name,
            'attrNameAndValues': cmd.attrNameAndValues,
            'eventTargetAndNames': cmd.eventTargetAndNames,
            'templateId': cmd.templateId
        };
    };
    RenderTemplateCmdSerializer.prototype.visitEndComponent = function (context) { return { 'deserializerIndex': 5 }; };
    RenderTemplateCmdSerializer.prototype.visitEmbeddedTemplate = function (cmd, context) {
        var _this = this;
        var children = cmd.children.map(function (child) { return child.visit(_this, null); });
        return {
            'deserializerIndex': 6,
            'isBound': cmd.isBound,
            'ngContentIndex': cmd.ngContentIndex,
            'name': cmd.name,
            'attrNameAndValues': cmd.attrNameAndValues,
            'eventTargetAndNames': cmd.eventTargetAndNames,
            'isMerged': cmd.isMerged,
            'children': children
        };
    };
    return RenderTemplateCmdSerializer;
})();
var RENDER_TEMPLATE_CMD_SERIALIZER = new RenderTemplateCmdSerializer();
var RENDER_TEMPLATE_CMD_DESERIALIZERS = [
    function (data) {
        return new api_2.WebWorkerTextCmd(data['isBound'], data['ngContentIndex'], data['value']);
    },
    function (data) { return new api_2.WebWorkerNgContentCmd(data['index'], data['ngContentIndex']); },
    function (data) {
        return new api_2.WebWorkerBeginElementCmd(data['isBound'], data['ngContentIndex'], data['name'], data['attrNameAndValues'], data['eventTargetAndNames']);
    },
    function (data) { return new api_2.WebWorkerEndElementCmd(); },
    function (data) { return new api_2.WebWorkerBeginComponentCmd(data['isBound'], data['ngContentIndex'], data['name'], data['attrNameAndValues'], data['eventTargetAndNames'], data['templateId']); },
    function (data) { return new api_2.WebWorkerEndComponentCmd(); },
    function (data) { return new api_2.WebWorkerEmbeddedTemplateCmd(data['isBound'], data['ngContentIndex'], data['name'], data['attrNameAndValues'], data['eventTargetAndNames'], data['isMerged'], data['children'].map(function (childData) { return deserializeTemplateCmd(childData); })); },
];
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoic2VyaWFsaXplci5qcyIsInNvdXJjZVJvb3QiOiIiLCJzb3VyY2VzIjpbImFuZ3VsYXIyL3NyYy93ZWJfd29ya2Vycy9zaGFyZWQvc2VyaWFsaXplci50cyJdLCJuYW1lcyI6WyJTZXJpYWxpemVyIiwiU2VyaWFsaXplci5jb25zdHJ1Y3RvciIsIlNlcmlhbGl6ZXIuc2VyaWFsaXplIiwiU2VyaWFsaXplci5kZXNlcmlhbGl6ZSIsIlNlcmlhbGl6ZXIubWFwVG9PYmplY3QiLCJTZXJpYWxpemVyLm9iamVjdFRvTWFwIiwiU2VyaWFsaXplci5hbGxvY2F0ZVJlbmRlclZpZXdzIiwiU2VyaWFsaXplci5fc2VyaWFsaXplV29ya2VyRWxlbWVudFJlZiIsIlNlcmlhbGl6ZXIuX2Rlc2VyaWFsaXplV29ya2VyRWxlbWVudFJlZiIsIlNlcmlhbGl6ZXIuX3NlcmlhbGl6ZVJlbmRlclRlbXBsYXRlIiwiU2VyaWFsaXplci5fZGVzZXJpYWxpemVSZW5kZXJUZW1wbGF0ZSIsInNlcmlhbGl6ZVRlbXBsYXRlQ21kIiwiZGVzZXJpYWxpemVUZW1wbGF0ZUNtZCIsIlJlbmRlclRlbXBsYXRlQ21kU2VyaWFsaXplciIsIlJlbmRlclRlbXBsYXRlQ21kU2VyaWFsaXplci5jb25zdHJ1Y3RvciIsIlJlbmRlclRlbXBsYXRlQ21kU2VyaWFsaXplci52aXNpdFRleHQiLCJSZW5kZXJUZW1wbGF0ZUNtZFNlcmlhbGl6ZXIudmlzaXROZ0NvbnRlbnQiLCJSZW5kZXJUZW1wbGF0ZUNtZFNlcmlhbGl6ZXIudmlzaXRCZWdpbkVsZW1lbnQiLCJSZW5kZXJUZW1wbGF0ZUNtZFNlcmlhbGl6ZXIudmlzaXRFbmRFbGVtZW50IiwiUmVuZGVyVGVtcGxhdGVDbWRTZXJpYWxpemVyLnZpc2l0QmVnaW5Db21wb25lbnQiLCJSZW5kZXJUZW1wbGF0ZUNtZFNlcmlhbGl6ZXIudmlzaXRFbmRDb21wb25lbnQiLCJSZW5kZXJUZW1wbGF0ZUNtZFNlcmlhbGl6ZXIudmlzaXRFbWJlZGRlZFRlbXBsYXRlIl0sIm1hcHBpbmdzIjoiOzs7Ozs7Ozs7QUFBQSxxQkFBdUUsMEJBQTBCLENBQUMsQ0FBQTtBQUNsRywyQkFBOEMsZ0NBQWdDLENBQUMsQ0FBQTtBQUUvRSwyQkFBZ0QsZ0NBQWdDLENBQUMsQ0FBQTtBQUNqRixvQkFhTyw4QkFBOEIsQ0FBQyxDQUFBO0FBQ3RDLG9CQVVPLHFDQUFxQyxDQUFDLENBQUE7QUFDN0MsbUJBQXlCLHNCQUFzQixDQUFDLENBQUE7QUFDaEQsNENBQXNDLDZEQUE2RCxDQUFDLENBQUE7QUFDcEcsaURBRU8sa0VBQWtFLENBQUMsQ0FBQTtBQUMxRSxxQkFBMkQsaUNBQWlDLENBQUMsQ0FBQTtBQUU3RixzRkFBc0Y7QUFDdEYsdURBQXVEO0FBQzFDLGlCQUFTLEdBQVMsTUFBTSxDQUFDO0FBRXRDO0lBRUVBLG9CQUFvQkEsZUFBd0NBLEVBQ3hDQSxnQkFBOENBO1FBRDlDQyxvQkFBZUEsR0FBZkEsZUFBZUEsQ0FBeUJBO1FBQ3hDQSxxQkFBZ0JBLEdBQWhCQSxnQkFBZ0JBLENBQThCQTtJQUFHQSxDQUFDQTtJQUV0RUQsOEJBQVNBLEdBQVRBLFVBQVVBLEdBQVFBLEVBQUVBLElBQVNBO1FBQTdCRSxpQkEyQkNBO1FBMUJDQSxFQUFFQSxDQUFDQSxDQUFDQSxDQUFDQSxnQkFBU0EsQ0FBQ0EsR0FBR0EsQ0FBQ0EsQ0FBQ0EsQ0FBQ0EsQ0FBQ0E7WUFDcEJBLE1BQU1BLENBQUNBLElBQUlBLENBQUNBO1FBQ2RBLENBQUNBO1FBQ0RBLEVBQUVBLENBQUNBLENBQUNBLGNBQU9BLENBQUNBLEdBQUdBLENBQUNBLENBQUNBLENBQUNBLENBQUNBO1lBQ2pCQSxNQUFNQSxDQUFTQSxHQUFJQSxDQUFDQSxHQUFHQSxDQUFDQSxVQUFBQSxDQUFDQSxJQUFJQSxPQUFBQSxLQUFJQSxDQUFDQSxTQUFTQSxDQUFDQSxDQUFDQSxFQUFFQSxJQUFJQSxDQUFDQSxFQUF2QkEsQ0FBdUJBLENBQUNBLENBQUNBO1FBQ3hEQSxDQUFDQTtRQUNEQSxFQUFFQSxDQUFDQSxDQUFDQSxJQUFJQSxJQUFJQSxpQkFBU0EsQ0FBQ0EsQ0FBQ0EsQ0FBQ0E7WUFDdEJBLE1BQU1BLENBQUNBLEdBQUdBLENBQUNBO1FBQ2JBLENBQUNBO1FBQ0RBLEVBQUVBLENBQUNBLENBQUNBLElBQUlBLElBQUlBLHdCQUFrQkEsQ0FBQ0EsQ0FBQ0EsQ0FBQ0E7WUFDL0JBLE1BQU1BLENBQUNBLElBQUlBLENBQUNBLGVBQWVBLENBQUNBLFNBQVNBLENBQUNBLEdBQUdBLENBQUNBLENBQUNBO1FBQzdDQSxDQUFDQTtRQUFDQSxJQUFJQSxDQUFDQSxFQUFFQSxDQUFDQSxDQUFDQSxJQUFJQSxJQUFJQSxtQkFBYUEsQ0FBQ0EsQ0FBQ0EsQ0FBQ0E7WUFDakNBLE1BQU1BLENBQUNBLElBQUlBLENBQUNBLGdCQUFnQkEsQ0FBQ0Esc0JBQXNCQSxDQUFDQSxHQUFHQSxDQUFDQSxDQUFDQTtRQUMzREEsQ0FBQ0E7UUFBQ0EsSUFBSUEsQ0FBQ0EsRUFBRUEsQ0FBQ0EsQ0FBQ0EsSUFBSUEsSUFBSUEsdUJBQWlCQSxDQUFDQSxDQUFDQSxDQUFDQTtZQUNyQ0EsTUFBTUEsQ0FBQ0EsSUFBSUEsQ0FBQ0EsZ0JBQWdCQSxDQUFDQSwwQkFBMEJBLENBQUNBLEdBQUdBLENBQUNBLENBQUNBO1FBQy9EQSxDQUFDQTtRQUFDQSxJQUFJQSxDQUFDQSxFQUFFQSxDQUFDQSxDQUFDQSxJQUFJQSxJQUFJQSx5QkFBbUJBLENBQUNBLENBQUNBLENBQUNBO1lBQ3ZDQSxNQUFNQSxDQUFDQSxJQUFJQSxDQUFDQSwwQkFBMEJBLENBQUNBLEdBQUdBLENBQUNBLENBQUNBO1FBQzlDQSxDQUFDQTtRQUFDQSxJQUFJQSxDQUFDQSxFQUFFQSxDQUFDQSxDQUFDQSxJQUFJQSxJQUFJQSwwQkFBb0JBLENBQUNBLENBQUNBLENBQUNBO1lBQ3hDQSxNQUFNQSxDQUFDQSxvQkFBb0JBLENBQUNBLEdBQUdBLENBQUNBLENBQUNBO1FBQ25DQSxDQUFDQTtRQUFDQSxJQUFJQSxDQUFDQSxFQUFFQSxDQUFDQSxDQUFDQSxJQUFJQSxLQUFLQSw2QkFBdUJBLENBQUNBLENBQUNBLENBQUNBO1lBQzVDQSxNQUFNQSxDQUFDQSxJQUFJQSxDQUFDQSx3QkFBd0JBLENBQUNBLEdBQUdBLENBQUNBLENBQUNBO1FBQzVDQSxDQUFDQTtRQUFDQSxJQUFJQSxDQUFDQSxFQUFFQSxDQUFDQSxDQUFDQSxJQUFJQSxLQUFLQSx3QkFBaUJBLENBQUNBLENBQUNBLENBQUNBO1lBQ3RDQSxNQUFNQSxDQUFDQSxvQkFBYUEsQ0FBQ0EsR0FBR0EsQ0FBQ0EsQ0FBQ0E7UUFDNUJBLENBQUNBO1FBQUNBLElBQUlBLENBQUNBLENBQUNBO1lBQ05BLE1BQU1BLElBQUlBLDBCQUFhQSxDQUFDQSxvQkFBb0JBLEdBQUdBLElBQUlBLENBQUNBLFFBQVFBLEVBQUVBLENBQUNBLENBQUNBO1FBQ2xFQSxDQUFDQTtJQUNIQSxDQUFDQTtJQUVERixnQ0FBV0EsR0FBWEEsVUFBWUEsR0FBUUEsRUFBRUEsSUFBU0EsRUFBRUEsSUFBVUE7UUFBM0NHLGlCQThCQ0E7UUE3QkNBLEVBQUVBLENBQUNBLENBQUNBLENBQUNBLGdCQUFTQSxDQUFDQSxHQUFHQSxDQUFDQSxDQUFDQSxDQUFDQSxDQUFDQTtZQUNwQkEsTUFBTUEsQ0FBQ0EsSUFBSUEsQ0FBQ0E7UUFDZEEsQ0FBQ0E7UUFDREEsRUFBRUEsQ0FBQ0EsQ0FBQ0EsY0FBT0EsQ0FBQ0EsR0FBR0EsQ0FBQ0EsQ0FBQ0EsQ0FBQ0EsQ0FBQ0E7WUFDakJBLElBQUlBLEdBQUdBLEdBQVVBLEVBQUVBLENBQUNBO1lBQ1pBLEdBQUlBLENBQUNBLE9BQU9BLENBQUNBLFVBQUFBLEdBQUdBLElBQUlBLE9BQUFBLEdBQUdBLENBQUNBLElBQUlBLENBQUNBLEtBQUlBLENBQUNBLFdBQVdBLENBQUNBLEdBQUdBLEVBQUVBLElBQUlBLEVBQUVBLElBQUlBLENBQUNBLENBQUNBLEVBQTNDQSxDQUEyQ0EsQ0FBQ0EsQ0FBQ0E7WUFDekVBLE1BQU1BLENBQUNBLEdBQUdBLENBQUNBO1FBQ2JBLENBQUNBO1FBQ0RBLEVBQUVBLENBQUNBLENBQUNBLElBQUlBLElBQUlBLGlCQUFTQSxDQUFDQSxDQUFDQSxDQUFDQTtZQUN0QkEsTUFBTUEsQ0FBQ0EsR0FBR0EsQ0FBQ0E7UUFDYkEsQ0FBQ0E7UUFFREEsRUFBRUEsQ0FBQ0EsQ0FBQ0EsSUFBSUEsSUFBSUEsd0JBQWtCQSxDQUFDQSxDQUFDQSxDQUFDQTtZQUMvQkEsTUFBTUEsQ0FBQ0EsSUFBSUEsQ0FBQ0EsZUFBZUEsQ0FBQ0EsV0FBV0EsQ0FBQ0EsR0FBR0EsQ0FBQ0EsQ0FBQ0E7UUFDL0NBLENBQUNBO1FBQUNBLElBQUlBLENBQUNBLEVBQUVBLENBQUNBLENBQUNBLElBQUlBLElBQUlBLG1CQUFhQSxDQUFDQSxDQUFDQSxDQUFDQTtZQUNqQ0EsTUFBTUEsQ0FBQ0EsSUFBSUEsQ0FBQ0EsZ0JBQWdCQSxDQUFDQSx3QkFBd0JBLENBQUNBLEdBQUdBLENBQUNBLENBQUNBO1FBQzdEQSxDQUFDQTtRQUFDQSxJQUFJQSxDQUFDQSxFQUFFQSxDQUFDQSxDQUFDQSxJQUFJQSxJQUFJQSx1QkFBaUJBLENBQUNBLENBQUNBLENBQUNBO1lBQ3JDQSxNQUFNQSxDQUFDQSxJQUFJQSxDQUFDQSxnQkFBZ0JBLENBQUNBLDRCQUE0QkEsQ0FBQ0EsR0FBR0EsQ0FBQ0EsQ0FBQ0E7UUFDakVBLENBQUNBO1FBQUNBLElBQUlBLENBQUNBLEVBQUVBLENBQUNBLENBQUNBLElBQUlBLElBQUlBLHlCQUFtQkEsQ0FBQ0EsQ0FBQ0EsQ0FBQ0E7WUFDdkNBLE1BQU1BLENBQUNBLElBQUlBLENBQUNBLDRCQUE0QkEsQ0FBQ0EsR0FBR0EsQ0FBQ0EsQ0FBQ0E7UUFDaERBLENBQUNBO1FBQUNBLElBQUlBLENBQUNBLEVBQUVBLENBQUNBLENBQUNBLElBQUlBLElBQUlBLDBCQUFvQkEsQ0FBQ0EsQ0FBQ0EsQ0FBQ0E7WUFDeENBLE1BQU1BLENBQUNBLHNCQUFzQkEsQ0FBQ0EsR0FBR0EsQ0FBQ0EsQ0FBQ0E7UUFDckNBLENBQUNBO1FBQUNBLElBQUlBLENBQUNBLEVBQUVBLENBQUNBLENBQUNBLElBQUlBLEtBQUtBLDZCQUF1QkEsQ0FBQ0EsQ0FBQ0EsQ0FBQ0E7WUFDNUNBLE1BQU1BLENBQUNBLElBQUlBLENBQUNBLDBCQUEwQkEsQ0FBQ0EsR0FBR0EsQ0FBQ0EsQ0FBQ0E7UUFDOUNBLENBQUNBO1FBQUNBLElBQUlBLENBQUNBLEVBQUVBLENBQUNBLENBQUNBLElBQUlBLEtBQUtBLHdCQUFpQkEsQ0FBQ0EsQ0FBQ0EsQ0FBQ0E7WUFDdENBLE1BQU1BLENBQUNBLGdDQUF5QkEsQ0FBQ0EsR0FBR0EsQ0FBQ0EsQ0FBQ0E7UUFDeENBLENBQUNBO1FBQUNBLElBQUlBLENBQUNBLENBQUNBO1lBQ05BLE1BQU1BLElBQUlBLDBCQUFhQSxDQUFDQSxzQkFBc0JBLEdBQUdBLElBQUlBLENBQUNBLFFBQVFBLEVBQUVBLENBQUNBLENBQUNBO1FBQ3BFQSxDQUFDQTtJQUNIQSxDQUFDQTtJQUVESCxnQ0FBV0EsR0FBWEEsVUFBWUEsR0FBcUJBLEVBQUVBLElBQVdBO1FBQTlDSSxpQkFZQ0E7UUFYQ0EsSUFBSUEsTUFBTUEsR0FBR0EsRUFBRUEsQ0FBQ0E7UUFDaEJBLElBQUlBLFNBQVNBLEdBQUdBLGdCQUFTQSxDQUFDQSxJQUFJQSxDQUFDQSxDQUFDQTtRQUVoQ0EsR0FBR0EsQ0FBQ0EsT0FBT0EsQ0FBQ0EsVUFBQ0EsS0FBS0EsRUFBRUEsR0FBR0E7WUFDckJBLEVBQUVBLENBQUNBLENBQUNBLFNBQVNBLENBQUNBLENBQUNBLENBQUNBO2dCQUNkQSxNQUFNQSxDQUFDQSxHQUFHQSxDQUFDQSxHQUFHQSxLQUFJQSxDQUFDQSxTQUFTQSxDQUFDQSxLQUFLQSxFQUFFQSxJQUFJQSxDQUFDQSxDQUFDQTtZQUM1Q0EsQ0FBQ0E7WUFBQ0EsSUFBSUEsQ0FBQ0EsQ0FBQ0E7Z0JBQ05BLE1BQU1BLENBQUNBLEdBQUdBLENBQUNBLEdBQUdBLEtBQUtBLENBQUNBO1lBQ3RCQSxDQUFDQTtRQUNIQSxDQUFDQSxDQUFDQSxDQUFDQTtRQUNIQSxNQUFNQSxDQUFDQSxNQUFNQSxDQUFDQTtJQUNoQkEsQ0FBQ0E7SUFFREo7Ozs7T0FJR0E7SUFDSEEsZ0NBQVdBLEdBQVhBLFVBQVlBLEdBQXlCQSxFQUFFQSxJQUFXQSxFQUFFQSxJQUFVQTtRQUE5REssaUJBU0NBO1FBUkNBLEVBQUVBLENBQUNBLENBQUNBLGdCQUFTQSxDQUFDQSxJQUFJQSxDQUFDQSxDQUFDQSxDQUFDQSxDQUFDQTtZQUNwQkEsSUFBSUEsR0FBR0EsR0FBR0EsSUFBSUEsZ0JBQUdBLEVBQWVBLENBQUNBO1lBQ2pDQSw2QkFBZ0JBLENBQUNBLE9BQU9BLENBQUNBLEdBQUdBLEVBQ0hBLFVBQUNBLEdBQUdBLEVBQUVBLEdBQUdBLElBQU9BLEdBQUdBLENBQUNBLEdBQUdBLENBQUNBLEdBQUdBLEVBQUVBLEtBQUlBLENBQUNBLFdBQVdBLENBQUNBLEdBQUdBLEVBQUVBLElBQUlBLEVBQUVBLElBQUlBLENBQUNBLENBQUNBLENBQUNBLENBQUNBLENBQUNBLENBQUNBLENBQUNBO1lBQzdGQSxNQUFNQSxDQUFDQSxHQUFHQSxDQUFDQTtRQUNiQSxDQUFDQTtRQUFDQSxJQUFJQSxDQUFDQSxDQUFDQTtZQUNOQSxNQUFNQSxDQUFDQSx1QkFBVUEsQ0FBQ0EsbUJBQW1CQSxDQUFDQSxHQUFHQSxDQUFDQSxDQUFDQTtRQUM3Q0EsQ0FBQ0E7SUFDSEEsQ0FBQ0E7SUFFREwsd0NBQW1CQSxHQUFuQkEsVUFBb0JBLGFBQXFCQSxJQUFJTSxJQUFJQSxDQUFDQSxnQkFBZ0JBLENBQUNBLFFBQVFBLENBQUNBLGFBQWFBLENBQUNBLENBQUNBLENBQUNBLENBQUNBO0lBRXJGTiwrQ0FBMEJBLEdBQWxDQSxVQUFtQ0EsVUFBNEJBO1FBQzdETyxNQUFNQSxDQUFDQTtZQUNMQSxZQUFZQSxFQUFFQSxJQUFJQSxDQUFDQSxTQUFTQSxDQUFDQSxVQUFVQSxDQUFDQSxVQUFVQSxFQUFFQSxtQkFBYUEsQ0FBQ0E7WUFDbEVBLG1CQUFtQkEsRUFBRUEsVUFBVUEsQ0FBQ0EsaUJBQWlCQTtTQUNsREEsQ0FBQ0E7SUFDSkEsQ0FBQ0E7SUFFT1AsaURBQTRCQSxHQUFwQ0EsVUFBcUNBLEdBQXlCQTtRQUM1RFEsTUFBTUEsQ0FBQ0EsSUFBSUEseUJBQW1CQSxDQUFDQSxJQUFJQSxDQUFDQSxXQUFXQSxDQUFDQSxHQUFHQSxDQUFDQSxZQUFZQSxDQUFDQSxFQUFFQSxtQkFBYUEsQ0FBQ0EsRUFDbERBLEdBQUdBLENBQUNBLG1CQUFtQkEsQ0FBQ0EsQ0FBQ0EsQ0FBQ0E7SUFDM0RBLENBQUNBO0lBR09SLDZDQUF3QkEsR0FBaENBLFVBQWlDQSxHQUE0QkE7UUFDM0RTLE1BQU1BLENBQUNBO1lBQ0xBLElBQUlBLEVBQUVBLEdBQUdBLENBQUNBLEVBQUVBO1lBQ1pBLFNBQVNBLEVBQUVBLEdBQUdBLENBQUNBLE9BQU9BO1lBQ3RCQSxlQUFlQSxFQUFFQSxJQUFJQSxDQUFDQSxTQUFTQSxDQUFDQSxHQUFHQSxDQUFDQSxhQUFhQSxFQUFFQSx3QkFBaUJBLENBQUNBO1lBQ3JFQSxVQUFVQSxFQUFFQSxJQUFJQSxDQUFDQSxTQUFTQSxDQUFDQSxHQUFHQSxDQUFDQSxRQUFRQSxFQUFFQSwwQkFBb0JBLENBQUNBO1lBQzlEQSxRQUFRQSxFQUFFQSxJQUFJQSxDQUFDQSxTQUFTQSxDQUFDQSxHQUFHQSxDQUFDQSxNQUFNQSxFQUFFQSxpQkFBU0EsQ0FBQ0E7U0FDaERBLENBQUNBO0lBQ0pBLENBQUNBO0lBRU9ULCtDQUEwQkEsR0FBbENBLFVBQW1DQSxHQUF5QkE7UUFDMURVLE1BQU1BLENBQUNBLElBQUlBLDZCQUF1QkEsQ0FBQ0EsR0FBR0EsQ0FBQ0EsSUFBSUEsQ0FBQ0EsRUFBRUEsR0FBR0EsQ0FBQ0EsU0FBU0EsQ0FBQ0EsRUFDekJBLElBQUlBLENBQUNBLFdBQVdBLENBQUNBLEdBQUdBLENBQUNBLGVBQWVBLENBQUNBLEVBQUVBLHdCQUFpQkEsQ0FBQ0EsRUFDekRBLElBQUlBLENBQUNBLFdBQVdBLENBQUNBLEdBQUdBLENBQUNBLFVBQVVBLENBQUNBLEVBQUVBLDBCQUFvQkEsQ0FBQ0EsRUFDdkRBLElBQUlBLENBQUNBLFdBQVdBLENBQUNBLEdBQUdBLENBQUNBLFFBQVFBLENBQUNBLEVBQUVBLGlCQUFTQSxDQUFDQSxDQUFDQSxDQUFDQTtJQUNqRkEsQ0FBQ0E7SUE5SEhWO1FBQUNBLGVBQVVBLEVBQUVBOzttQkErSFpBO0lBQURBLGlCQUFDQTtBQUFEQSxDQUFDQSxBQS9IRCxJQStIQztBQTlIWSxrQkFBVSxhQThIdEIsQ0FBQTtBQUdELDhCQUE4QixHQUFzQjtJQUNsRFcsTUFBTUEsQ0FBQ0EsR0FBR0EsQ0FBQ0EsS0FBS0EsQ0FBQ0EsOEJBQThCQSxFQUFFQSxJQUFJQSxDQUFDQSxDQUFDQTtBQUN6REEsQ0FBQ0E7QUFFRCxnQ0FBZ0MsSUFBMEI7SUFDeERDLE1BQU1BLENBQUNBLGlDQUFpQ0EsQ0FBQ0EsSUFBSUEsQ0FBQ0EsbUJBQW1CQSxDQUFDQSxDQUFDQSxDQUFDQSxJQUFJQSxDQUFDQSxDQUFDQTtBQUM1RUEsQ0FBQ0E7QUFFRDtJQUFBQztJQWdEQUMsQ0FBQ0E7SUEvQ0NELCtDQUFTQSxHQUFUQSxVQUFVQSxHQUFrQkEsRUFBRUEsT0FBWUE7UUFDeENFLE1BQU1BLENBQUNBO1lBQ0xBLG1CQUFtQkEsRUFBRUEsQ0FBQ0E7WUFDdEJBLFNBQVNBLEVBQUVBLEdBQUdBLENBQUNBLE9BQU9BO1lBQ3RCQSxnQkFBZ0JBLEVBQUVBLEdBQUdBLENBQUNBLGNBQWNBO1lBQ3BDQSxPQUFPQSxFQUFFQSxHQUFHQSxDQUFDQSxLQUFLQTtTQUNuQkEsQ0FBQ0E7SUFDSkEsQ0FBQ0E7SUFDREYsb0RBQWNBLEdBQWRBLFVBQWVBLEdBQXVCQSxFQUFFQSxPQUFZQTtRQUNsREcsTUFBTUEsQ0FBQ0EsRUFBQ0EsbUJBQW1CQSxFQUFFQSxDQUFDQSxFQUFFQSxPQUFPQSxFQUFFQSxHQUFHQSxDQUFDQSxLQUFLQSxFQUFFQSxnQkFBZ0JBLEVBQUVBLEdBQUdBLENBQUNBLGNBQWNBLEVBQUNBLENBQUNBO0lBQzVGQSxDQUFDQTtJQUNESCx1REFBaUJBLEdBQWpCQSxVQUFrQkEsR0FBMEJBLEVBQUVBLE9BQVlBO1FBQ3hESSxNQUFNQSxDQUFDQTtZQUNMQSxtQkFBbUJBLEVBQUVBLENBQUNBO1lBQ3RCQSxTQUFTQSxFQUFFQSxHQUFHQSxDQUFDQSxPQUFPQTtZQUN0QkEsZ0JBQWdCQSxFQUFFQSxHQUFHQSxDQUFDQSxjQUFjQTtZQUNwQ0EsTUFBTUEsRUFBRUEsR0FBR0EsQ0FBQ0EsSUFBSUE7WUFDaEJBLG1CQUFtQkEsRUFBRUEsR0FBR0EsQ0FBQ0EsaUJBQWlCQTtZQUMxQ0EscUJBQXFCQSxFQUFFQSxHQUFHQSxDQUFDQSxtQkFBbUJBO1NBQy9DQSxDQUFDQTtJQUNKQSxDQUFDQTtJQUNESixxREFBZUEsR0FBZkEsVUFBZ0JBLE9BQVlBLElBQVNLLE1BQU1BLENBQUNBLEVBQUNBLG1CQUFtQkEsRUFBRUEsQ0FBQ0EsRUFBQ0EsQ0FBQ0EsQ0FBQ0EsQ0FBQ0E7SUFDdkVMLHlEQUFtQkEsR0FBbkJBLFVBQW9CQSxHQUE0QkEsRUFBRUEsT0FBWUE7UUFDNURNLE1BQU1BLENBQUNBO1lBQ0xBLG1CQUFtQkEsRUFBRUEsQ0FBQ0E7WUFDdEJBLFNBQVNBLEVBQUVBLEdBQUdBLENBQUNBLE9BQU9BO1lBQ3RCQSxnQkFBZ0JBLEVBQUVBLEdBQUdBLENBQUNBLGNBQWNBO1lBQ3BDQSxNQUFNQSxFQUFFQSxHQUFHQSxDQUFDQSxJQUFJQTtZQUNoQkEsbUJBQW1CQSxFQUFFQSxHQUFHQSxDQUFDQSxpQkFBaUJBO1lBQzFDQSxxQkFBcUJBLEVBQUVBLEdBQUdBLENBQUNBLG1CQUFtQkE7WUFDOUNBLFlBQVlBLEVBQUVBLEdBQUdBLENBQUNBLFVBQVVBO1NBQzdCQSxDQUFDQTtJQUNKQSxDQUFDQTtJQUNETix1REFBaUJBLEdBQWpCQSxVQUFrQkEsT0FBWUEsSUFBU08sTUFBTUEsQ0FBQ0EsRUFBQ0EsbUJBQW1CQSxFQUFFQSxDQUFDQSxFQUFDQSxDQUFDQSxDQUFDQSxDQUFDQTtJQUN6RVAsMkRBQXFCQSxHQUFyQkEsVUFBc0JBLEdBQThCQSxFQUFFQSxPQUFZQTtRQUFsRVEsaUJBWUNBO1FBWENBLElBQUlBLFFBQVFBLEdBQUdBLEdBQUdBLENBQUNBLFFBQVFBLENBQUNBLEdBQUdBLENBQUNBLFVBQUFBLEtBQUtBLElBQUlBLE9BQUFBLEtBQUtBLENBQUNBLEtBQUtBLENBQUNBLEtBQUlBLEVBQUVBLElBQUlBLENBQUNBLEVBQXZCQSxDQUF1QkEsQ0FBQ0EsQ0FBQ0E7UUFDbEVBLE1BQU1BLENBQUNBO1lBQ0xBLG1CQUFtQkEsRUFBRUEsQ0FBQ0E7WUFDdEJBLFNBQVNBLEVBQUVBLEdBQUdBLENBQUNBLE9BQU9BO1lBQ3RCQSxnQkFBZ0JBLEVBQUVBLEdBQUdBLENBQUNBLGNBQWNBO1lBQ3BDQSxNQUFNQSxFQUFFQSxHQUFHQSxDQUFDQSxJQUFJQTtZQUNoQkEsbUJBQW1CQSxFQUFFQSxHQUFHQSxDQUFDQSxpQkFBaUJBO1lBQzFDQSxxQkFBcUJBLEVBQUVBLEdBQUdBLENBQUNBLG1CQUFtQkE7WUFDOUNBLFVBQVVBLEVBQUVBLEdBQUdBLENBQUNBLFFBQVFBO1lBQ3hCQSxVQUFVQSxFQUFFQSxRQUFRQTtTQUNyQkEsQ0FBQ0E7SUFDSkEsQ0FBQ0E7SUFDSFIsa0NBQUNBO0FBQURBLENBQUNBLEFBaERELElBZ0RDO0FBRUQsSUFBSSw4QkFBOEIsR0FBRyxJQUFJLDJCQUEyQixFQUFFLENBQUM7QUFFdkUsSUFBSSxpQ0FBaUMsR0FBRztJQUN0QyxVQUFDLElBQTBCO2VBQ3ZCLElBQUksc0JBQWdCLENBQUMsSUFBSSxDQUFDLFNBQVMsQ0FBQyxFQUFFLElBQUksQ0FBQyxnQkFBZ0IsQ0FBQyxFQUFFLElBQUksQ0FBQyxPQUFPLENBQUMsQ0FBQztJQUE1RSxDQUE0RTtJQUNoRixVQUFDLElBQTBCLElBQUssT0FBQSxJQUFJLDJCQUFxQixDQUFDLElBQUksQ0FBQyxPQUFPLENBQUMsRUFBRSxJQUFJLENBQUMsZ0JBQWdCLENBQUMsQ0FBQyxFQUFoRSxDQUFnRTtJQUNoRyxVQUFDLElBQTBCO2VBQ3ZCLElBQUksOEJBQXdCLENBQUMsSUFBSSxDQUFDLFNBQVMsQ0FBQyxFQUFFLElBQUksQ0FBQyxnQkFBZ0IsQ0FBQyxFQUFFLElBQUksQ0FBQyxNQUFNLENBQUMsRUFDckQsSUFBSSxDQUFDLG1CQUFtQixDQUFDLEVBQUUsSUFBSSxDQUFDLHFCQUFxQixDQUFDLENBQUM7SUFEcEYsQ0FDb0Y7SUFDeEYsVUFBQyxJQUEwQixJQUFLLE9BQUEsSUFBSSw0QkFBc0IsRUFBRSxFQUE1QixDQUE0QjtJQUM1RCxVQUFDLElBQTBCLElBQUssT0FBQSxJQUFJLGdDQUEwQixDQUMxRCxJQUFJLENBQUMsU0FBUyxDQUFDLEVBQUUsSUFBSSxDQUFDLGdCQUFnQixDQUFDLEVBQUUsSUFBSSxDQUFDLE1BQU0sQ0FBQyxFQUFFLElBQUksQ0FBQyxtQkFBbUIsQ0FBQyxFQUNoRixJQUFJLENBQUMscUJBQXFCLENBQUMsRUFBRSxJQUFJLENBQUMsWUFBWSxDQUFDLENBQUMsRUFGcEIsQ0FFb0I7SUFDcEQsVUFBQyxJQUEwQixJQUFLLE9BQUEsSUFBSSw4QkFBd0IsRUFBRSxFQUE5QixDQUE4QjtJQUM5RCxVQUFDLElBQTBCLElBQUssT0FBQSxJQUFJLGtDQUE0QixDQUM1RCxJQUFJLENBQUMsU0FBUyxDQUFDLEVBQUUsSUFBSSxDQUFDLGdCQUFnQixDQUFDLEVBQUUsSUFBSSxDQUFDLE1BQU0sQ0FBQyxFQUFFLElBQUksQ0FBQyxtQkFBbUIsQ0FBQyxFQUNoRixJQUFJLENBQUMscUJBQXFCLENBQUMsRUFBRSxJQUFJLENBQUMsVUFBVSxDQUFDLEVBQ3JDLElBQUksQ0FBQyxVQUFVLENBQUUsQ0FBQyxHQUFHLENBQUMsVUFBQSxTQUFTLElBQUksT0FBQSxzQkFBc0IsQ0FBQyxTQUFTLENBQUMsRUFBakMsQ0FBaUMsQ0FBQyxDQUFDLEVBSGxELENBR2tEO0NBQ25GLENBQUMiLCJzb3VyY2VzQ29udGVudCI6WyJpbXBvcnQge1R5cGUsIGlzQXJyYXksIGlzUHJlc2VudCwgc2VyaWFsaXplRW51bSwgZGVzZXJpYWxpemVFbnVtfSBmcm9tIFwiYW5ndWxhcjIvc3JjL2ZhY2FkZS9sYW5nXCI7XG5pbXBvcnQge0Jhc2VFeGNlcHRpb24sIFdyYXBwZWRFeGNlcHRpb259IGZyb20gJ2FuZ3VsYXIyL3NyYy9mYWNhZGUvZXhjZXB0aW9ucyc7XG5cbmltcG9ydCB7TWFwLCBTdHJpbmdNYXBXcmFwcGVyLCBNYXBXcmFwcGVyfSBmcm9tIFwiYW5ndWxhcjIvc3JjL2ZhY2FkZS9jb2xsZWN0aW9uXCI7XG5pbXBvcnQge1xuICBSZW5kZXJQcm90b1ZpZXdSZWYsXG4gIFJlbmRlclZpZXdSZWYsXG4gIFJlbmRlckZyYWdtZW50UmVmLFxuICBSZW5kZXJFbGVtZW50UmVmLFxuICBSZW5kZXJUZW1wbGF0ZUNtZCxcbiAgUmVuZGVyQ29tbWFuZFZpc2l0b3IsXG4gIFJlbmRlclRleHRDbWQsXG4gIFJlbmRlck5nQ29udGVudENtZCxcbiAgUmVuZGVyQmVnaW5FbGVtZW50Q21kLFxuICBSZW5kZXJCZWdpbkNvbXBvbmVudENtZCxcbiAgUmVuZGVyRW1iZWRkZWRUZW1wbGF0ZUNtZCxcbiAgUmVuZGVyQ29tcG9uZW50VGVtcGxhdGVcbn0gZnJvbSBcImFuZ3VsYXIyL3NyYy9jb3JlL3JlbmRlci9hcGlcIjtcbmltcG9ydCB7XG4gIFdlYldvcmtlckVsZW1lbnRSZWYsXG4gIFdlYldvcmtlclRlbXBsYXRlQ21kLFxuICBXZWJXb3JrZXJUZXh0Q21kLFxuICBXZWJXb3JrZXJOZ0NvbnRlbnRDbWQsXG4gIFdlYldvcmtlckJlZ2luRWxlbWVudENtZCxcbiAgV2ViV29ya2VyRW5kRWxlbWVudENtZCxcbiAgV2ViV29ya2VyQmVnaW5Db21wb25lbnRDbWQsXG4gIFdlYldvcmtlckVuZENvbXBvbmVudENtZCxcbiAgV2ViV29ya2VyRW1iZWRkZWRUZW1wbGF0ZUNtZFxufSBmcm9tICdhbmd1bGFyMi9zcmMvd2ViX3dvcmtlcnMvc2hhcmVkL2FwaSc7XG5pbXBvcnQge0luamVjdGFibGV9IGZyb20gXCJhbmd1bGFyMi9zcmMvY29yZS9kaVwiO1xuaW1wb3J0IHtSZW5kZXJQcm90b1ZpZXdSZWZTdG9yZX0gZnJvbSAnYW5ndWxhcjIvc3JjL3dlYl93b3JrZXJzL3NoYXJlZC9yZW5kZXJfcHJvdG9fdmlld19yZWZfc3RvcmUnO1xuaW1wb3J0IHtcbiAgUmVuZGVyVmlld1dpdGhGcmFnbWVudHNTdG9yZVxufSBmcm9tICdhbmd1bGFyMi9zcmMvd2ViX3dvcmtlcnMvc2hhcmVkL3JlbmRlcl92aWV3X3dpdGhfZnJhZ21lbnRzX3N0b3JlJztcbmltcG9ydCB7Vmlld0VuY2Fwc3VsYXRpb24sIFZJRVdfRU5DQVBTVUxBVElPTl9WQUxVRVN9IGZyb20gJ2FuZ3VsYXIyL3NyYy9jb3JlL21ldGFkYXRhL3ZpZXcnO1xuXG4vLyBQUklNSVRJVkUgaXMgYW55IHR5cGUgdGhhdCBkb2VzIG5vdCBuZWVkIHRvIGJlIHNlcmlhbGl6ZWQgKHN0cmluZywgbnVtYmVyLCBib29sZWFuKVxuLy8gV2Ugc2V0IGl0IHRvIFN0cmluZyBzbyB0aGF0IGl0IGlzIGNvbnNpZGVyZWQgYSBUeXBlLlxuZXhwb3J0IGNvbnN0IFBSSU1JVElWRTogVHlwZSA9IFN0cmluZztcblxuQEluamVjdGFibGUoKVxuZXhwb3J0IGNsYXNzIFNlcmlhbGl6ZXIge1xuICBjb25zdHJ1Y3Rvcihwcml2YXRlIF9wcm90b1ZpZXdTdG9yZTogUmVuZGVyUHJvdG9WaWV3UmVmU3RvcmUsXG4gICAgICAgICAgICAgIHByaXZhdGUgX3JlbmRlclZpZXdTdG9yZTogUmVuZGVyVmlld1dpdGhGcmFnbWVudHNTdG9yZSkge31cblxuICBzZXJpYWxpemUob2JqOiBhbnksIHR5cGU6IGFueSk6IE9iamVjdCB7XG4gICAgaWYgKCFpc1ByZXNlbnQob2JqKSkge1xuICAgICAgcmV0dXJuIG51bGw7XG4gICAgfVxuICAgIGlmIChpc0FycmF5KG9iaikpIHtcbiAgICAgIHJldHVybiAoPGFueVtdPm9iaikubWFwKHYgPT4gdGhpcy5zZXJpYWxpemUodiwgdHlwZSkpO1xuICAgIH1cbiAgICBpZiAodHlwZSA9PSBQUklNSVRJVkUpIHtcbiAgICAgIHJldHVybiBvYmo7XG4gICAgfVxuICAgIGlmICh0eXBlID09IFJlbmRlclByb3RvVmlld1JlZikge1xuICAgICAgcmV0dXJuIHRoaXMuX3Byb3RvVmlld1N0b3JlLnNlcmlhbGl6ZShvYmopO1xuICAgIH0gZWxzZSBpZiAodHlwZSA9PSBSZW5kZXJWaWV3UmVmKSB7XG4gICAgICByZXR1cm4gdGhpcy5fcmVuZGVyVmlld1N0b3JlLnNlcmlhbGl6ZVJlbmRlclZpZXdSZWYob2JqKTtcbiAgICB9IGVsc2UgaWYgKHR5cGUgPT0gUmVuZGVyRnJhZ21lbnRSZWYpIHtcbiAgICAgIHJldHVybiB0aGlzLl9yZW5kZXJWaWV3U3RvcmUuc2VyaWFsaXplUmVuZGVyRnJhZ21lbnRSZWYob2JqKTtcbiAgICB9IGVsc2UgaWYgKHR5cGUgPT0gV2ViV29ya2VyRWxlbWVudFJlZikge1xuICAgICAgcmV0dXJuIHRoaXMuX3NlcmlhbGl6ZVdvcmtlckVsZW1lbnRSZWYob2JqKTtcbiAgICB9IGVsc2UgaWYgKHR5cGUgPT0gV2ViV29ya2VyVGVtcGxhdGVDbWQpIHtcbiAgICAgIHJldHVybiBzZXJpYWxpemVUZW1wbGF0ZUNtZChvYmopO1xuICAgIH0gZWxzZSBpZiAodHlwZSA9PT0gUmVuZGVyQ29tcG9uZW50VGVtcGxhdGUpIHtcbiAgICAgIHJldHVybiB0aGlzLl9zZXJpYWxpemVSZW5kZXJUZW1wbGF0ZShvYmopO1xuICAgIH0gZWxzZSBpZiAodHlwZSA9PT0gVmlld0VuY2Fwc3VsYXRpb24pIHtcbiAgICAgIHJldHVybiBzZXJpYWxpemVFbnVtKG9iaik7XG4gICAgfSBlbHNlIHtcbiAgICAgIHRocm93IG5ldyBCYXNlRXhjZXB0aW9uKFwiTm8gc2VyaWFsaXplciBmb3IgXCIgKyB0eXBlLnRvU3RyaW5nKCkpO1xuICAgIH1cbiAgfVxuXG4gIGRlc2VyaWFsaXplKG1hcDogYW55LCB0eXBlOiBhbnksIGRhdGE/OiBhbnkpOiBhbnkge1xuICAgIGlmICghaXNQcmVzZW50KG1hcCkpIHtcbiAgICAgIHJldHVybiBudWxsO1xuICAgIH1cbiAgICBpZiAoaXNBcnJheShtYXApKSB7XG4gICAgICB2YXIgb2JqOiBhbnlbXSA9IFtdO1xuICAgICAgKDxhbnlbXT5tYXApLmZvckVhY2godmFsID0+IG9iai5wdXNoKHRoaXMuZGVzZXJpYWxpemUodmFsLCB0eXBlLCBkYXRhKSkpO1xuICAgICAgcmV0dXJuIG9iajtcbiAgICB9XG4gICAgaWYgKHR5cGUgPT0gUFJJTUlUSVZFKSB7XG4gICAgICByZXR1cm4gbWFwO1xuICAgIH1cblxuICAgIGlmICh0eXBlID09IFJlbmRlclByb3RvVmlld1JlZikge1xuICAgICAgcmV0dXJuIHRoaXMuX3Byb3RvVmlld1N0b3JlLmRlc2VyaWFsaXplKG1hcCk7XG4gICAgfSBlbHNlIGlmICh0eXBlID09IFJlbmRlclZpZXdSZWYpIHtcbiAgICAgIHJldHVybiB0aGlzLl9yZW5kZXJWaWV3U3RvcmUuZGVzZXJpYWxpemVSZW5kZXJWaWV3UmVmKG1hcCk7XG4gICAgfSBlbHNlIGlmICh0eXBlID09IFJlbmRlckZyYWdtZW50UmVmKSB7XG4gICAgICByZXR1cm4gdGhpcy5fcmVuZGVyVmlld1N0b3JlLmRlc2VyaWFsaXplUmVuZGVyRnJhZ21lbnRSZWYobWFwKTtcbiAgICB9IGVsc2UgaWYgKHR5cGUgPT0gV2ViV29ya2VyRWxlbWVudFJlZikge1xuICAgICAgcmV0dXJuIHRoaXMuX2Rlc2VyaWFsaXplV29ya2VyRWxlbWVudFJlZihtYXApO1xuICAgIH0gZWxzZSBpZiAodHlwZSA9PSBXZWJXb3JrZXJUZW1wbGF0ZUNtZCkge1xuICAgICAgcmV0dXJuIGRlc2VyaWFsaXplVGVtcGxhdGVDbWQobWFwKTtcbiAgICB9IGVsc2UgaWYgKHR5cGUgPT09IFJlbmRlckNvbXBvbmVudFRlbXBsYXRlKSB7XG4gICAgICByZXR1cm4gdGhpcy5fZGVzZXJpYWxpemVSZW5kZXJUZW1wbGF0ZShtYXApO1xuICAgIH0gZWxzZSBpZiAodHlwZSA9PT0gVmlld0VuY2Fwc3VsYXRpb24pIHtcbiAgICAgIHJldHVybiBWSUVXX0VOQ0FQU1VMQVRJT05fVkFMVUVTW21hcF07XG4gICAgfSBlbHNlIHtcbiAgICAgIHRocm93IG5ldyBCYXNlRXhjZXB0aW9uKFwiTm8gZGVzZXJpYWxpemVyIGZvciBcIiArIHR5cGUudG9TdHJpbmcoKSk7XG4gICAgfVxuICB9XG5cbiAgbWFwVG9PYmplY3QobWFwOiBNYXA8c3RyaW5nLCBhbnk+LCB0eXBlPzogVHlwZSk6IE9iamVjdCB7XG4gICAgdmFyIG9iamVjdCA9IHt9O1xuICAgIHZhciBzZXJpYWxpemUgPSBpc1ByZXNlbnQodHlwZSk7XG5cbiAgICBtYXAuZm9yRWFjaCgodmFsdWUsIGtleSkgPT4ge1xuICAgICAgaWYgKHNlcmlhbGl6ZSkge1xuICAgICAgICBvYmplY3Rba2V5XSA9IHRoaXMuc2VyaWFsaXplKHZhbHVlLCB0eXBlKTtcbiAgICAgIH0gZWxzZSB7XG4gICAgICAgIG9iamVjdFtrZXldID0gdmFsdWU7XG4gICAgICB9XG4gICAgfSk7XG4gICAgcmV0dXJuIG9iamVjdDtcbiAgfVxuXG4gIC8qXG4gICAqIFRyYW5zZm9ybXMgYSBKYXZhc2NyaXB0IG9iamVjdCAoU3RyaW5nTWFwKSBpbnRvIGEgTWFwPHN0cmluZywgVj5cbiAgICogSWYgdGhlIHZhbHVlcyBuZWVkIHRvIGJlIGRlc2VyaWFsaXplZCBwYXNzIGluIHRoZWlyIHR5cGVcbiAgICogYW5kIHRoZXkgd2lsbCBiZSBkZXNlcmlhbGl6ZWQgYmVmb3JlIGJlaW5nIHBsYWNlZCBpbiB0aGUgbWFwXG4gICAqL1xuICBvYmplY3RUb01hcChvYmo6IHtba2V5OiBzdHJpbmddOiBhbnl9LCB0eXBlPzogVHlwZSwgZGF0YT86IGFueSk6IE1hcDxzdHJpbmcsIGFueT4ge1xuICAgIGlmIChpc1ByZXNlbnQodHlwZSkpIHtcbiAgICAgIHZhciBtYXAgPSBuZXcgTWFwPHN0cmluZywgYW55PigpO1xuICAgICAgU3RyaW5nTWFwV3JhcHBlci5mb3JFYWNoKG9iaixcbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAodmFsLCBrZXkpID0+IHsgbWFwLnNldChrZXksIHRoaXMuZGVzZXJpYWxpemUodmFsLCB0eXBlLCBkYXRhKSk7IH0pO1xuICAgICAgcmV0dXJuIG1hcDtcbiAgICB9IGVsc2Uge1xuICAgICAgcmV0dXJuIE1hcFdyYXBwZXIuY3JlYXRlRnJvbVN0cmluZ01hcChvYmopO1xuICAgIH1cbiAgfVxuXG4gIGFsbG9jYXRlUmVuZGVyVmlld3MoZnJhZ21lbnRDb3VudDogbnVtYmVyKSB7IHRoaXMuX3JlbmRlclZpZXdTdG9yZS5hbGxvY2F0ZShmcmFnbWVudENvdW50KTsgfVxuXG4gIHByaXZhdGUgX3NlcmlhbGl6ZVdvcmtlckVsZW1lbnRSZWYoZWxlbWVudFJlZjogUmVuZGVyRWxlbWVudFJlZik6IHtba2V5OiBzdHJpbmddOiBhbnl9IHtcbiAgICByZXR1cm4ge1xuICAgICAgJ3JlbmRlclZpZXcnOiB0aGlzLnNlcmlhbGl6ZShlbGVtZW50UmVmLnJlbmRlclZpZXcsIFJlbmRlclZpZXdSZWYpLFxuICAgICAgJ2JvdW5kRWxlbWVudEluZGV4JzogZWxlbWVudFJlZi5ib3VuZEVsZW1lbnRJbmRleFxuICAgIH07XG4gIH1cblxuICBwcml2YXRlIF9kZXNlcmlhbGl6ZVdvcmtlckVsZW1lbnRSZWYobWFwOiB7W2tleTogc3RyaW5nXTogYW55fSk6IFJlbmRlckVsZW1lbnRSZWYge1xuICAgIHJldHVybiBuZXcgV2ViV29ya2VyRWxlbWVudFJlZih0aGlzLmRlc2VyaWFsaXplKG1hcFsncmVuZGVyVmlldyddLCBSZW5kZXJWaWV3UmVmKSxcbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgbWFwWydib3VuZEVsZW1lbnRJbmRleCddKTtcbiAgfVxuXG5cbiAgcHJpdmF0ZSBfc2VyaWFsaXplUmVuZGVyVGVtcGxhdGUob2JqOiBSZW5kZXJDb21wb25lbnRUZW1wbGF0ZSk6IE9iamVjdCB7XG4gICAgcmV0dXJuIHtcbiAgICAgICdpZCc6IG9iai5pZCxcbiAgICAgICdzaG9ydElkJzogb2JqLnNob3J0SWQsXG4gICAgICAnZW5jYXBzdWxhdGlvbic6IHRoaXMuc2VyaWFsaXplKG9iai5lbmNhcHN1bGF0aW9uLCBWaWV3RW5jYXBzdWxhdGlvbiksXG4gICAgICAnY29tbWFuZHMnOiB0aGlzLnNlcmlhbGl6ZShvYmouY29tbWFuZHMsIFdlYldvcmtlclRlbXBsYXRlQ21kKSxcbiAgICAgICdzdHlsZXMnOiB0aGlzLnNlcmlhbGl6ZShvYmouc3R5bGVzLCBQUklNSVRJVkUpXG4gICAgfTtcbiAgfVxuXG4gIHByaXZhdGUgX2Rlc2VyaWFsaXplUmVuZGVyVGVtcGxhdGUobWFwOiB7W2tleTogc3RyaW5nXTogYW55fSk6IFJlbmRlckNvbXBvbmVudFRlbXBsYXRlIHtcbiAgICByZXR1cm4gbmV3IFJlbmRlckNvbXBvbmVudFRlbXBsYXRlKG1hcFsnaWQnXSwgbWFwWydzaG9ydElkJ10sXG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICB0aGlzLmRlc2VyaWFsaXplKG1hcFsnZW5jYXBzdWxhdGlvbiddLCBWaWV3RW5jYXBzdWxhdGlvbiksXG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICB0aGlzLmRlc2VyaWFsaXplKG1hcFsnY29tbWFuZHMnXSwgV2ViV29ya2VyVGVtcGxhdGVDbWQpLFxuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgdGhpcy5kZXNlcmlhbGl6ZShtYXBbJ3N0eWxlcyddLCBQUklNSVRJVkUpKTtcbiAgfVxufVxuXG5cbmZ1bmN0aW9uIHNlcmlhbGl6ZVRlbXBsYXRlQ21kKGNtZDogUmVuZGVyVGVtcGxhdGVDbWQpOiBPYmplY3Qge1xuICByZXR1cm4gY21kLnZpc2l0KFJFTkRFUl9URU1QTEFURV9DTURfU0VSSUFMSVpFUiwgbnVsbCk7XG59XG5cbmZ1bmN0aW9uIGRlc2VyaWFsaXplVGVtcGxhdGVDbWQoZGF0YToge1trZXk6IHN0cmluZ106IGFueX0pOiBSZW5kZXJUZW1wbGF0ZUNtZCB7XG4gIHJldHVybiBSRU5ERVJfVEVNUExBVEVfQ01EX0RFU0VSSUFMSVpFUlNbZGF0YVsnZGVzZXJpYWxpemVySW5kZXgnXV0oZGF0YSk7XG59XG5cbmNsYXNzIFJlbmRlclRlbXBsYXRlQ21kU2VyaWFsaXplciBpbXBsZW1lbnRzIFJlbmRlckNvbW1hbmRWaXNpdG9yIHtcbiAgdmlzaXRUZXh0KGNtZDogUmVuZGVyVGV4dENtZCwgY29udGV4dDogYW55KTogYW55IHtcbiAgICByZXR1cm4ge1xuICAgICAgJ2Rlc2VyaWFsaXplckluZGV4JzogMCxcbiAgICAgICdpc0JvdW5kJzogY21kLmlzQm91bmQsXG4gICAgICAnbmdDb250ZW50SW5kZXgnOiBjbWQubmdDb250ZW50SW5kZXgsXG4gICAgICAndmFsdWUnOiBjbWQudmFsdWVcbiAgICB9O1xuICB9XG4gIHZpc2l0TmdDb250ZW50KGNtZDogUmVuZGVyTmdDb250ZW50Q21kLCBjb250ZXh0OiBhbnkpOiBhbnkge1xuICAgIHJldHVybiB7J2Rlc2VyaWFsaXplckluZGV4JzogMSwgJ2luZGV4JzogY21kLmluZGV4LCAnbmdDb250ZW50SW5kZXgnOiBjbWQubmdDb250ZW50SW5kZXh9O1xuICB9XG4gIHZpc2l0QmVnaW5FbGVtZW50KGNtZDogUmVuZGVyQmVnaW5FbGVtZW50Q21kLCBjb250ZXh0OiBhbnkpOiBhbnkge1xuICAgIHJldHVybiB7XG4gICAgICAnZGVzZXJpYWxpemVySW5kZXgnOiAyLFxuICAgICAgJ2lzQm91bmQnOiBjbWQuaXNCb3VuZCxcbiAgICAgICduZ0NvbnRlbnRJbmRleCc6IGNtZC5uZ0NvbnRlbnRJbmRleCxcbiAgICAgICduYW1lJzogY21kLm5hbWUsXG4gICAgICAnYXR0ck5hbWVBbmRWYWx1ZXMnOiBjbWQuYXR0ck5hbWVBbmRWYWx1ZXMsXG4gICAgICAnZXZlbnRUYXJnZXRBbmROYW1lcyc6IGNtZC5ldmVudFRhcmdldEFuZE5hbWVzXG4gICAgfTtcbiAgfVxuICB2aXNpdEVuZEVsZW1lbnQoY29udGV4dDogYW55KTogYW55IHsgcmV0dXJuIHsnZGVzZXJpYWxpemVySW5kZXgnOiAzfTsgfVxuICB2aXNpdEJlZ2luQ29tcG9uZW50KGNtZDogUmVuZGVyQmVnaW5Db21wb25lbnRDbWQsIGNvbnRleHQ6IGFueSk6IGFueSB7XG4gICAgcmV0dXJuIHtcbiAgICAgICdkZXNlcmlhbGl6ZXJJbmRleCc6IDQsXG4gICAgICAnaXNCb3VuZCc6IGNtZC5pc0JvdW5kLFxuICAgICAgJ25nQ29udGVudEluZGV4JzogY21kLm5nQ29udGVudEluZGV4LFxuICAgICAgJ25hbWUnOiBjbWQubmFtZSxcbiAgICAgICdhdHRyTmFtZUFuZFZhbHVlcyc6IGNtZC5hdHRyTmFtZUFuZFZhbHVlcyxcbiAgICAgICdldmVudFRhcmdldEFuZE5hbWVzJzogY21kLmV2ZW50VGFyZ2V0QW5kTmFtZXMsXG4gICAgICAndGVtcGxhdGVJZCc6IGNtZC50ZW1wbGF0ZUlkXG4gICAgfTtcbiAgfVxuICB2aXNpdEVuZENvbXBvbmVudChjb250ZXh0OiBhbnkpOiBhbnkgeyByZXR1cm4geydkZXNlcmlhbGl6ZXJJbmRleCc6IDV9OyB9XG4gIHZpc2l0RW1iZWRkZWRUZW1wbGF0ZShjbWQ6IFJlbmRlckVtYmVkZGVkVGVtcGxhdGVDbWQsIGNvbnRleHQ6IGFueSk6IGFueSB7XG4gICAgdmFyIGNoaWxkcmVuID0gY21kLmNoaWxkcmVuLm1hcChjaGlsZCA9PiBjaGlsZC52aXNpdCh0aGlzLCBudWxsKSk7XG4gICAgcmV0dXJuIHtcbiAgICAgICdkZXNlcmlhbGl6ZXJJbmRleCc6IDYsXG4gICAgICAnaXNCb3VuZCc6IGNtZC5pc0JvdW5kLFxuICAgICAgJ25nQ29udGVudEluZGV4JzogY21kLm5nQ29udGVudEluZGV4LFxuICAgICAgJ25hbWUnOiBjbWQubmFtZSxcbiAgICAgICdhdHRyTmFtZUFuZFZhbHVlcyc6IGNtZC5hdHRyTmFtZUFuZFZhbHVlcyxcbiAgICAgICdldmVudFRhcmdldEFuZE5hbWVzJzogY21kLmV2ZW50VGFyZ2V0QW5kTmFtZXMsXG4gICAgICAnaXNNZXJnZWQnOiBjbWQuaXNNZXJnZWQsXG4gICAgICAnY2hpbGRyZW4nOiBjaGlsZHJlblxuICAgIH07XG4gIH1cbn1cblxudmFyIFJFTkRFUl9URU1QTEFURV9DTURfU0VSSUFMSVpFUiA9IG5ldyBSZW5kZXJUZW1wbGF0ZUNtZFNlcmlhbGl6ZXIoKTtcblxudmFyIFJFTkRFUl9URU1QTEFURV9DTURfREVTRVJJQUxJWkVSUyA9IFtcbiAgKGRhdGE6IHtba2V5OiBzdHJpbmddOiBhbnl9KSA9PlxuICAgICAgbmV3IFdlYldvcmtlclRleHRDbWQoZGF0YVsnaXNCb3VuZCddLCBkYXRhWyduZ0NvbnRlbnRJbmRleCddLCBkYXRhWyd2YWx1ZSddKSxcbiAgKGRhdGE6IHtba2V5OiBzdHJpbmddOiBhbnl9KSA9PiBuZXcgV2ViV29ya2VyTmdDb250ZW50Q21kKGRhdGFbJ2luZGV4J10sIGRhdGFbJ25nQ29udGVudEluZGV4J10pLFxuICAoZGF0YToge1trZXk6IHN0cmluZ106IGFueX0pID0+XG4gICAgICBuZXcgV2ViV29ya2VyQmVnaW5FbGVtZW50Q21kKGRhdGFbJ2lzQm91bmQnXSwgZGF0YVsnbmdDb250ZW50SW5kZXgnXSwgZGF0YVsnbmFtZSddLFxuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBkYXRhWydhdHRyTmFtZUFuZFZhbHVlcyddLCBkYXRhWydldmVudFRhcmdldEFuZE5hbWVzJ10pLFxuICAoZGF0YToge1trZXk6IHN0cmluZ106IGFueX0pID0+IG5ldyBXZWJXb3JrZXJFbmRFbGVtZW50Q21kKCksXG4gIChkYXRhOiB7W2tleTogc3RyaW5nXTogYW55fSkgPT4gbmV3IFdlYldvcmtlckJlZ2luQ29tcG9uZW50Q21kKFxuICAgICAgZGF0YVsnaXNCb3VuZCddLCBkYXRhWyduZ0NvbnRlbnRJbmRleCddLCBkYXRhWyduYW1lJ10sIGRhdGFbJ2F0dHJOYW1lQW5kVmFsdWVzJ10sXG4gICAgICBkYXRhWydldmVudFRhcmdldEFuZE5hbWVzJ10sIGRhdGFbJ3RlbXBsYXRlSWQnXSksXG4gIChkYXRhOiB7W2tleTogc3RyaW5nXTogYW55fSkgPT4gbmV3IFdlYldvcmtlckVuZENvbXBvbmVudENtZCgpLFxuICAoZGF0YToge1trZXk6IHN0cmluZ106IGFueX0pID0+IG5ldyBXZWJXb3JrZXJFbWJlZGRlZFRlbXBsYXRlQ21kKFxuICAgICAgZGF0YVsnaXNCb3VuZCddLCBkYXRhWyduZ0NvbnRlbnRJbmRleCddLCBkYXRhWyduYW1lJ10sIGRhdGFbJ2F0dHJOYW1lQW5kVmFsdWVzJ10sXG4gICAgICBkYXRhWydldmVudFRhcmdldEFuZE5hbWVzJ10sIGRhdGFbJ2lzTWVyZ2VkJ10sXG4gICAgICAoPGFueVtdPmRhdGFbJ2NoaWxkcmVuJ10pLm1hcChjaGlsZERhdGEgPT4gZGVzZXJpYWxpemVUZW1wbGF0ZUNtZChjaGlsZERhdGEpKSksXG5dO1xuIl19