var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
import { IS_DART, isBlank, stringify } from 'angular2/src/facade/lang';
import { BaseException } from 'angular2/src/facade/exceptions';
import { ListWrapper, SetWrapper } from 'angular2/src/facade/collection';
import { PromiseWrapper } from 'angular2/src/facade/async';
import { CompiledComponentTemplate, CompiledHostTemplate, BeginComponentCmd } from 'angular2/src/core/linker/template_commands';
import { createHostComponentMeta, CompileDirectiveMetadata } from './directive_metadata';
import { Injectable } from 'angular2/src/core/di';
import { SourceModule, moduleRef } from './source_module';
import { ChangeDetectionCompiler } from './change_detector_compiler';
import { StyleCompiler } from './style_compiler';
import { CommandCompiler } from './command_compiler';
import { TemplateParser } from './template_parser';
import { TemplateNormalizer } from './template_normalizer';
import { RuntimeMetadataResolver } from './runtime_metadata';
import { TEMPLATE_COMMANDS_MODULE_REF } from './command_compiler';
import { codeGenExportVariable, codeGenValueFn, MODULE_SUFFIX } from './util';
/**
 * An internal module of the Angular compiler that begins with component types,
 * extracts templates, and eventually produces a compiled version of the component
 * ready for linking into an application.
 */
export let TemplateCompiler = class {
    constructor(_runtimeMetadataResolver, _templateNormalizer, _templateParser, _styleCompiler, _commandCompiler, _cdCompiler) {
        this._runtimeMetadataResolver = _runtimeMetadataResolver;
        this._templateNormalizer = _templateNormalizer;
        this._templateParser = _templateParser;
        this._styleCompiler = _styleCompiler;
        this._commandCompiler = _commandCompiler;
        this._cdCompiler = _cdCompiler;
        this._hostCacheKeys = new Map();
        this._compiledTemplateCache = new Map();
        this._compiledTemplateDone = new Map();
        this._nextTemplateId = 0;
    }
    normalizeDirectiveMetadata(directive) {
        if (!directive.isComponent) {
            // For non components there is nothing to be normalized yet.
            return PromiseWrapper.resolve(directive);
        }
        return this._templateNormalizer.normalizeTemplate(directive.type, directive.template)
            .then((normalizedTemplate) => new CompileDirectiveMetadata({
            type: directive.type,
            isComponent: directive.isComponent,
            dynamicLoadable: directive.dynamicLoadable,
            selector: directive.selector,
            exportAs: directive.exportAs,
            changeDetection: directive.changeDetection,
            inputs: directive.inputs,
            outputs: directive.outputs,
            hostListeners: directive.hostListeners,
            hostProperties: directive.hostProperties,
            hostAttributes: directive.hostAttributes,
            lifecycleHooks: directive.lifecycleHooks,
            template: normalizedTemplate
        }));
    }
    compileHostComponentRuntime(type) {
        var hostCacheKey = this._hostCacheKeys.get(type);
        if (isBlank(hostCacheKey)) {
            hostCacheKey = new Object();
            this._hostCacheKeys.set(type, hostCacheKey);
            var compMeta = this._runtimeMetadataResolver.getMetadata(type);
            assertComponent(compMeta);
            var hostMeta = createHostComponentMeta(compMeta.type, compMeta.selector);
            this._compileComponentRuntime(hostCacheKey, hostMeta, [compMeta], new Set());
        }
        return this._compiledTemplateDone.get(hostCacheKey)
            .then(compiledTemplate => new CompiledHostTemplate(compiledTemplate));
    }
    clearCache() {
        this._hostCacheKeys.clear();
        this._styleCompiler.clearCache();
        this._compiledTemplateCache.clear();
        this._compiledTemplateDone.clear();
    }
    _compileComponentRuntime(cacheKey, compMeta, viewDirectives, compilingComponentCacheKeys) {
        let uniqViewDirectives = removeDuplicates(viewDirectives);
        var compiledTemplate = this._compiledTemplateCache.get(cacheKey);
        var done = this._compiledTemplateDone.get(cacheKey);
        if (isBlank(compiledTemplate)) {
            var styles = [];
            var changeDetectorFactory;
            var commands = [];
            var templateId = `${stringify(compMeta.type.runtime)}Template${this._nextTemplateId++}`;
            compiledTemplate = new CompiledComponentTemplate(templateId, (dispatcher) => changeDetectorFactory(dispatcher), commands, styles);
            this._compiledTemplateCache.set(cacheKey, compiledTemplate);
            compilingComponentCacheKeys.add(cacheKey);
            done = PromiseWrapper
                .all([this._styleCompiler.compileComponentRuntime(compMeta.template)].concat(uniqViewDirectives.map(dirMeta => this.normalizeDirectiveMetadata(dirMeta))))
                .then((stylesAndNormalizedViewDirMetas) => {
                var childPromises = [];
                var normalizedViewDirMetas = stylesAndNormalizedViewDirMetas.slice(1);
                var parsedTemplate = this._templateParser.parse(compMeta.template.template, normalizedViewDirMetas, compMeta.type.name);
                var changeDetectorFactories = this._cdCompiler.compileComponentRuntime(compMeta.type, compMeta.changeDetection, parsedTemplate);
                changeDetectorFactory = changeDetectorFactories[0];
                var tmpStyles = stylesAndNormalizedViewDirMetas[0];
                tmpStyles.forEach(style => styles.push(style));
                var tmpCommands = this._compileCommandsRuntime(compMeta, parsedTemplate, changeDetectorFactories, compilingComponentCacheKeys, childPromises);
                tmpCommands.forEach(cmd => commands.push(cmd));
                return PromiseWrapper.all(childPromises);
            })
                .then((_) => {
                SetWrapper.delete(compilingComponentCacheKeys, cacheKey);
                return compiledTemplate;
            });
            this._compiledTemplateDone.set(cacheKey, done);
        }
        return compiledTemplate;
    }
    _compileCommandsRuntime(compMeta, parsedTemplate, changeDetectorFactories, compilingComponentCacheKeys, childPromises) {
        var cmds = this._commandCompiler.compileComponentRuntime(compMeta, parsedTemplate, changeDetectorFactories, (childComponentDir) => {
            var childCacheKey = childComponentDir.type.runtime;
            var childViewDirectives = this._runtimeMetadataResolver.getViewDirectivesMetadata(childComponentDir.type.runtime);
            var childIsRecursive = SetWrapper.has(compilingComponentCacheKeys, childCacheKey);
            var childTemplate = this._compileComponentRuntime(childCacheKey, childComponentDir, childViewDirectives, compilingComponentCacheKeys);
            if (!childIsRecursive) {
                // Only wait for a child if it is not a cycle
                childPromises.push(this._compiledTemplateDone.get(childCacheKey));
            }
            return () => childTemplate;
        });
        cmds.forEach(cmd => {
            if (cmd instanceof BeginComponentCmd) {
                cmd.templateGetter();
            }
        });
        return cmds;
    }
    compileTemplatesCodeGen(components) {
        if (components.length === 0) {
            throw new BaseException('No components given');
        }
        var declarations = [];
        var templateArguments = [];
        var componentMetas = [];
        components.forEach(componentWithDirs => {
            var compMeta = componentWithDirs.component;
            assertComponent(compMeta);
            componentMetas.push(compMeta);
            this._processTemplateCodeGen(compMeta, componentWithDirs.directives, declarations, templateArguments);
            if (compMeta.dynamicLoadable) {
                var hostMeta = createHostComponentMeta(compMeta.type, compMeta.selector);
                componentMetas.push(hostMeta);
                this._processTemplateCodeGen(hostMeta, [compMeta], declarations, templateArguments);
            }
        });
        ListWrapper.forEachWithIndex(componentMetas, (compMeta, index) => {
            var templateId = `${compMeta.type.moduleUrl}|${compMeta.type.name}`;
            var constructionKeyword = IS_DART ? 'const' : 'new';
            var compiledTemplateExpr = `${constructionKeyword} ${TEMPLATE_COMMANDS_MODULE_REF}CompiledComponentTemplate('${templateId}',${templateArguments[index].join(',')})`;
            var variableValueExpr;
            if (compMeta.type.isHost) {
                variableValueExpr =
                    `${constructionKeyword} ${TEMPLATE_COMMANDS_MODULE_REF}CompiledHostTemplate(${compiledTemplateExpr})`;
            }
            else {
                variableValueExpr = compiledTemplateExpr;
            }
            var varName = templateVariableName(compMeta.type);
            declarations.push(`${codeGenExportVariable(varName)}${variableValueExpr};`);
            declarations.push(`${codeGenValueFn([], varName, templateGetterName(compMeta.type))};`);
        });
        var moduleUrl = components[0].component.type.moduleUrl;
        return new SourceModule(`${templateModuleUrl(moduleUrl)}`, declarations.join('\n'));
    }
    compileStylesheetCodeGen(stylesheetUrl, cssText) {
        return this._styleCompiler.compileStylesheetCodeGen(stylesheetUrl, cssText);
    }
    _processTemplateCodeGen(compMeta, directives, targetDeclarations, targetTemplateArguments) {
        let uniqueDirectives = removeDuplicates(directives);
        var styleExpr = this._styleCompiler.compileComponentCodeGen(compMeta.template);
        var parsedTemplate = this._templateParser.parse(compMeta.template.template, uniqueDirectives, compMeta.type.name);
        var changeDetectorsExprs = this._cdCompiler.compileComponentCodeGen(compMeta.type, compMeta.changeDetection, parsedTemplate);
        var commandsExpr = this._commandCompiler.compileComponentCodeGen(compMeta, parsedTemplate, changeDetectorsExprs.expressions, codeGenComponentTemplateFactory);
        addAll(styleExpr.declarations, targetDeclarations);
        addAll(changeDetectorsExprs.declarations, targetDeclarations);
        addAll(commandsExpr.declarations, targetDeclarations);
        targetTemplateArguments.push([changeDetectorsExprs.expressions[0], commandsExpr.expression, styleExpr.expression]);
    }
};
TemplateCompiler = __decorate([
    Injectable(), 
    __metadata('design:paramtypes', [RuntimeMetadataResolver, TemplateNormalizer, TemplateParser, StyleCompiler, CommandCompiler, ChangeDetectionCompiler])
], TemplateCompiler);
export class NormalizedComponentWithViewDirectives {
    constructor(component, directives) {
        this.component = component;
        this.directives = directives;
    }
}
function assertComponent(meta) {
    if (!meta.isComponent) {
        throw new BaseException(`Could not compile '${meta.type.name}' because it is not a component.`);
    }
}
function templateVariableName(type) {
    return `${type.name}Template`;
}
function templateGetterName(type) {
    return `${templateVariableName(type)}Getter`;
}
function templateModuleUrl(moduleUrl) {
    var urlWithoutSuffix = moduleUrl.substring(0, moduleUrl.length - MODULE_SUFFIX.length);
    return `${urlWithoutSuffix}.template${MODULE_SUFFIX}`;
}
function addAll(source, target) {
    for (var i = 0; i < source.length; i++) {
        target.push(source[i]);
    }
}
function codeGenComponentTemplateFactory(nestedCompType) {
    return `${moduleRef(templateModuleUrl(nestedCompType.type.moduleUrl))}${templateGetterName(nestedCompType.type)}`;
}
function removeDuplicates(items) {
    let res = [];
    items.forEach(item => {
        let hasMatch = res.filter(r => r.type.name == item.type.name && r.type.moduleUrl == item.type.moduleUrl &&
            r.type.runtime == item.type.runtime)
            .length > 0;
        if (!hasMatch) {
            res.push(item);
        }
    });
    return res;
}
//# sourceMappingURL=data:application/json;base64,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