'use strict';var ParseLocation = (function () {
    function ParseLocation(file, offset, line, col) {
        this.file = file;
        this.offset = offset;
        this.line = line;
        this.col = col;
    }
    ParseLocation.prototype.toString = function () { return this.file.url + "@" + this.line + ":" + this.col; };
    return ParseLocation;
})();
exports.ParseLocation = ParseLocation;
var ParseSourceFile = (function () {
    function ParseSourceFile(content, url) {
        this.content = content;
        this.url = url;
    }
    return ParseSourceFile;
})();
exports.ParseSourceFile = ParseSourceFile;
var ParseError = (function () {
    function ParseError(location, msg) {
        this.location = location;
        this.msg = msg;
    }
    ParseError.prototype.toString = function () {
        var source = this.location.file.content;
        var ctxStart = this.location.offset;
        if (ctxStart > source.length - 1) {
            ctxStart = source.length - 1;
        }
        var ctxEnd = ctxStart;
        var ctxLen = 0;
        var ctxLines = 0;
        while (ctxLen < 100 && ctxStart > 0) {
            ctxStart--;
            ctxLen++;
            if (source[ctxStart] == "\n") {
                if (++ctxLines == 3) {
                    break;
                }
            }
        }
        ctxLen = 0;
        ctxLines = 0;
        while (ctxLen < 100 && ctxEnd < source.length - 1) {
            ctxEnd++;
            ctxLen++;
            if (source[ctxEnd] == "\n") {
                if (++ctxLines == 3) {
                    break;
                }
            }
        }
        var context = source.substring(ctxStart, this.location.offset) + '[ERROR ->]' +
            source.substring(this.location.offset, ctxEnd + 1);
        return this.msg + " (\"" + context + "\"): " + this.location;
    };
    return ParseError;
})();
exports.ParseError = ParseError;
var ParseSourceSpan = (function () {
    function ParseSourceSpan(start, end) {
        this.start = start;
        this.end = end;
    }
    ParseSourceSpan.prototype.toString = function () {
        return this.start.file.content.substring(this.start.offset, this.end.offset);
    };
    return ParseSourceSpan;
})();
exports.ParseSourceSpan = ParseSourceSpan;
//# sourceMappingURL=data:application/json;base64,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