'use strict';// Promises are put into their own facade file so that they can be used without
// introducing a dependency on rxjs. They are re-exported through facade/async.
var PromiseWrapper = (function () {
    function PromiseWrapper() {
    }
    PromiseWrapper.resolve = function (obj) { return Promise.resolve(obj); };
    PromiseWrapper.reject = function (obj, _) { return Promise.reject(obj); };
    // Note: We can't rename this method into `catch`, as this is not a valid
    // method name in Dart.
    PromiseWrapper.catchError = function (promise, onError) {
        return promise.catch(onError);
    };
    PromiseWrapper.all = function (promises) {
        if (promises.length == 0)
            return Promise.resolve([]);
        return Promise.all(promises);
    };
    PromiseWrapper.then = function (promise, success, rejection) {
        return promise.then(success, rejection);
    };
    PromiseWrapper.wrap = function (computation) {
        return new Promise(function (res, rej) {
            try {
                res(computation());
            }
            catch (e) {
                rej(e);
            }
        });
    };
    PromiseWrapper.scheduleMicrotask = function (computation) {
        PromiseWrapper.then(PromiseWrapper.resolve(null), computation, function (_) { });
    };
    PromiseWrapper.isPromise = function (obj) { return obj instanceof Promise; };
    PromiseWrapper.completer = function () {
        var resolve;
        var reject;
        var p = new Promise(function (res, rej) {
            resolve = res;
            reject = rej;
        });
        return { promise: p, resolve: resolve, reject: reject };
    };
    return PromiseWrapper;
})();
exports.PromiseWrapper = PromiseWrapper;
//# sourceMappingURL=data:application/json;base64,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