'use strict';var collection_1 = require('angular2/src/facade/collection');
var lang_1 = require('angular2/src/facade/lang');
var MOUSE_EVENT_PROPERTIES = [
    "altKey",
    "button",
    "clientX",
    "clientY",
    "metaKey",
    "movementX",
    "movementY",
    "offsetX",
    "offsetY",
    "region",
    "screenX",
    "screenY",
    "shiftKey"
];
var KEYBOARD_EVENT_PROPERTIES = [
    'altkey',
    'charCode',
    'code',
    'ctrlKey',
    'isComposing',
    'key',
    'keyCode',
    'location',
    'metaKey',
    'repeat',
    'shiftKey',
    'which'
];
var EVENT_PROPERTIES = ['type', 'bubbles', 'cancelable'];
var NODES_WITH_VALUE = new collection_1.Set(["input", "select", "option", "button", "li", "meter", "progress", "param"]);
function serializeGenericEvent(e) {
    return serializeEvent(e, EVENT_PROPERTIES);
}
exports.serializeGenericEvent = serializeGenericEvent;
// TODO(jteplitz602): Allow users to specify the properties they need rather than always
// adding value and files #3374
function serializeEventWithTarget(e) {
    var serializedEvent = serializeEvent(e, EVENT_PROPERTIES);
    return addTarget(e, serializedEvent);
}
exports.serializeEventWithTarget = serializeEventWithTarget;
function serializeMouseEvent(e) {
    return serializeEvent(e, MOUSE_EVENT_PROPERTIES);
}
exports.serializeMouseEvent = serializeMouseEvent;
function serializeKeyboardEvent(e) {
    var serializedEvent = serializeEvent(e, KEYBOARD_EVENT_PROPERTIES);
    return addTarget(e, serializedEvent);
}
exports.serializeKeyboardEvent = serializeKeyboardEvent;
// TODO(jteplitz602): #3374. See above.
function addTarget(e, serializedEvent) {
    if (NODES_WITH_VALUE.has(e.target.tagName.toLowerCase())) {
        var target = e.target;
        serializedEvent['target'] = { 'value': target.value };
        if (lang_1.isPresent(target.files)) {
            serializedEvent['target']['files'] = target.files;
        }
    }
    return serializedEvent;
}
function serializeEvent(e, properties) {
    var serialized = {};
    for (var i = 0; i < properties.length; i++) {
        var prop = properties[i];
        serialized[prop] = e[prop];
    }
    return serialized;
}
//# sourceMappingURL=data:application/json;base64,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