'use strict';var __extends = (this && this.__extends) || function (d, b) {
    for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p];
    function __() { this.constructor = d; }
    d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
};
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var __param = (this && this.__param) || function (paramIndex, decorator) {
    return function (target, key) { decorator(target, key, paramIndex); }
};
var di_1 = require('angular2/src/core/di');
var lang_1 = require('angular2/src/facade/lang');
var collection_1 = require('angular2/src/facade/collection');
var exceptions_1 = require('angular2/src/facade/exceptions');
var view_1 = require('./view');
var element_1 = require('./element');
var view_listener_1 = require('./view_listener');
var api_1 = require('angular2/src/core/render/api');
var profile_1 = require('../profile/profile');
var application_tokens_1 = require('angular2/src/core/application_tokens');
var view_type_1 = require('./view_type');
/**
 * Service exposing low level API for creating, moving and destroying Views.
 *
 * Most applications should use higher-level abstractions like {@link DynamicComponentLoader} and
 * {@link ViewContainerRef} instead.
 */
var AppViewManager = (function () {
    function AppViewManager() {
    }
    return AppViewManager;
})();
exports.AppViewManager = AppViewManager;
var AppViewManager_ = (function (_super) {
    __extends(AppViewManager_, _super);
    function AppViewManager_(_renderer, _viewListener, _appId) {
        _super.call(this);
        this._renderer = _renderer;
        this._viewListener = _viewListener;
        this._appId = _appId;
        this._nextCompTypeId = 0;
        /** @internal */
        this._createRootHostViewScope = profile_1.wtfCreateScope('AppViewManager#createRootHostView()');
        /** @internal */
        this._destroyRootHostViewScope = profile_1.wtfCreateScope('AppViewManager#destroyRootHostView()');
        /** @internal */
        this._createEmbeddedViewInContainerScope = profile_1.wtfCreateScope('AppViewManager#createEmbeddedViewInContainer()');
        /** @internal */
        this._createHostViewInContainerScope = profile_1.wtfCreateScope('AppViewManager#createHostViewInContainer()');
        /** @internal */
        this._destroyViewInContainerScope = profile_1.wtfCreateScope('AppViewMananger#destroyViewInContainer()');
        /** @internal */
        this._attachViewInContainerScope = profile_1.wtfCreateScope('AppViewMananger#attachViewInContainer()');
        /** @internal */
        this._detachViewInContainerScope = profile_1.wtfCreateScope('AppViewMananger#detachViewInContainer()');
    }
    AppViewManager_.prototype.getViewContainer = function (location) {
        return location.internalElement.getViewContainerRef();
    };
    AppViewManager_.prototype.getHostElement = function (hostViewRef) {
        var hostView = hostViewRef.internalView;
        if (hostView.proto.type !== view_type_1.ViewType.HOST) {
            throw new exceptions_1.BaseException('This operation is only allowed on host views');
        }
        return hostView.appElements[0].ref;
    };
    AppViewManager_.prototype.getNamedElementInComponentView = function (hostLocation, variableName) {
        var appEl = hostLocation.internalElement;
        var componentView = appEl.componentView;
        if (lang_1.isBlank(componentView)) {
            throw new exceptions_1.BaseException("There is no component directive at element " + hostLocation);
        }
        for (var i = 0; i < componentView.appElements.length; i++) {
            var compAppEl = componentView.appElements[i];
            if (collection_1.StringMapWrapper.contains(compAppEl.proto.directiveVariableBindings, variableName)) {
                return compAppEl.ref;
            }
        }
        throw new exceptions_1.BaseException("Could not find variable " + variableName);
    };
    AppViewManager_.prototype.getComponent = function (hostLocation) {
        return hostLocation.internalElement.getComponent();
    };
    AppViewManager_.prototype.createRootHostView = function (hostViewFactoryRef, overrideSelector, injector, projectableNodes) {
        if (projectableNodes === void 0) { projectableNodes = null; }
        var s = this._createRootHostViewScope();
        var hostViewFactory = hostViewFactoryRef.internalHostViewFactory;
        var selector = lang_1.isPresent(overrideSelector) ? overrideSelector : hostViewFactory.selector;
        var view = hostViewFactory.viewFactory(this._renderer, this, null, projectableNodes, selector, null, injector);
        return profile_1.wtfLeave(s, view.ref);
    };
    AppViewManager_.prototype.destroyRootHostView = function (hostViewRef) {
        var s = this._destroyRootHostViewScope();
        var hostView = hostViewRef.internalView;
        hostView.renderer.detachView(view_1.flattenNestedViewRenderNodes(hostView.rootNodesOrAppElements));
        hostView.destroy();
        profile_1.wtfLeave(s);
    };
    AppViewManager_.prototype.createEmbeddedViewInContainer = function (viewContainerLocation, index, templateRef) {
        var s = this._createEmbeddedViewInContainerScope();
        var contextEl = templateRef.elementRef.internalElement;
        var view = contextEl.embeddedViewFactory(contextEl.parentView.renderer, this, contextEl, contextEl.parentView.projectableNodes, null, null, null);
        this._attachViewToContainer(view, viewContainerLocation.internalElement, index);
        return profile_1.wtfLeave(s, view.ref);
    };
    AppViewManager_.prototype.createHostViewInContainer = function (viewContainerLocation, index, hostViewFactoryRef, dynamicallyCreatedProviders, projectableNodes) {
        var s = this._createHostViewInContainerScope();
        // TODO(tbosch): This should be specifiable via an additional argument!
        var contextEl = viewContainerLocation.internalElement;
        var hostViewFactory = hostViewFactoryRef.internalHostViewFactory;
        var view = hostViewFactory.viewFactory(contextEl.parentView.renderer, contextEl.parentView.viewManager, contextEl, projectableNodes, null, dynamicallyCreatedProviders, null);
        this._attachViewToContainer(view, viewContainerLocation.internalElement, index);
        return profile_1.wtfLeave(s, view.ref);
    };
    AppViewManager_.prototype.destroyViewInContainer = function (viewContainerLocation, index) {
        var s = this._destroyViewInContainerScope();
        var view = this._detachViewInContainer(viewContainerLocation.internalElement, index);
        view.destroy();
        profile_1.wtfLeave(s);
    };
    // TODO(i): refactor detachViewInContainer+attachViewInContainer to moveViewInContainer
    AppViewManager_.prototype.attachViewInContainer = function (viewContainerLocation, index, viewRef) {
        var s = this._attachViewInContainerScope();
        this._attachViewToContainer(viewRef.internalView, viewContainerLocation.internalElement, index);
        return profile_1.wtfLeave(s, viewRef);
    };
    // TODO(i): refactor detachViewInContainer+attachViewInContainer to moveViewInContainer
    AppViewManager_.prototype.detachViewInContainer = function (viewContainerLocation, index) {
        var s = this._detachViewInContainerScope();
        var view = this._detachViewInContainer(viewContainerLocation.internalElement, index);
        return profile_1.wtfLeave(s, view.ref);
    };
    /** @internal */
    AppViewManager_.prototype.onViewCreated = function (view) { this._viewListener.onViewCreated(view); };
    /** @internal */
    AppViewManager_.prototype.onViewDestroyed = function (view) { this._viewListener.onViewDestroyed(view); };
    /** @internal */
    AppViewManager_.prototype.createRenderComponentType = function (encapsulation, styles) {
        return new api_1.RenderComponentType(this._appId + "-" + this._nextCompTypeId++, encapsulation, styles);
    };
    AppViewManager_.prototype._attachViewToContainer = function (view, vcAppElement, viewIndex) {
        if (view.proto.type === view_type_1.ViewType.COMPONENT) {
            throw new exceptions_1.BaseException("Component views can't be moved!");
        }
        var nestedViews = vcAppElement.nestedViews;
        if (nestedViews == null) {
            nestedViews = [];
            vcAppElement.nestedViews = nestedViews;
        }
        collection_1.ListWrapper.insert(nestedViews, viewIndex, view);
        var refNode;
        if (viewIndex > 0) {
            var prevView = nestedViews[viewIndex - 1];
            refNode = prevView.rootNodesOrAppElements.length > 0 ?
                prevView.rootNodesOrAppElements[prevView.rootNodesOrAppElements.length - 1] :
                null;
        }
        else {
            refNode = vcAppElement.nativeElement;
        }
        if (lang_1.isPresent(refNode)) {
            var refRenderNode;
            if (refNode instanceof element_1.AppElement) {
                refRenderNode = refNode.nativeElement;
            }
            else {
                refRenderNode = refNode;
            }
            view.renderer.attachViewAfter(refRenderNode, view_1.flattenNestedViewRenderNodes(view.rootNodesOrAppElements));
        }
        // TODO: This is only needed when a view is destroyed,
        // not when it is detached for reordering with ng-for...
        vcAppElement.parentView.changeDetector.addContentChild(view.changeDetector);
        vcAppElement.traverseAndSetQueriesAsDirty();
    };
    AppViewManager_.prototype._detachViewInContainer = function (vcAppElement, viewIndex) {
        var view = collection_1.ListWrapper.removeAt(vcAppElement.nestedViews, viewIndex);
        if (view.proto.type === view_type_1.ViewType.COMPONENT) {
            throw new exceptions_1.BaseException("Component views can't be moved!");
        }
        vcAppElement.traverseAndSetQueriesAsDirty();
        view.renderer.detachView(view_1.flattenNestedViewRenderNodes(view.rootNodesOrAppElements));
        // TODO: This is only needed when a view is destroyed,
        // not when it is detached for reordering with ng-for...
        view.changeDetector.remove();
        return view;
    };
    AppViewManager_ = __decorate([
        di_1.Injectable(),
        __param(2, di_1.Inject(application_tokens_1.APP_ID)), 
        __metadata('design:paramtypes', [api_1.RootRenderer, view_listener_1.AppViewListener, String])
    ], AppViewManager_);
    return AppViewManager_;
})(AppViewManager);
exports.AppViewManager_ = AppViewManager_;
//# sourceMappingURL=data:application/json;base64,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