/**
 * @module
 * @description
 * This module provides a set of common Pipes.
 */
export { AsyncPipe } from './pipes/async_pipe';
export { DatePipe } from './pipes/date_pipe';
export { JsonPipe } from './pipes/json_pipe';
export { SlicePipe } from './pipes/slice_pipe';
export { LowerCasePipe } from './pipes/lowercase_pipe';
export { NumberPipe, DecimalPipe, PercentPipe, CurrencyPipe } from './pipes/number_pipe';
export { UpperCasePipe } from './pipes/uppercase_pipe';
export { ReplacePipe } from './pipes/replace_pipe';
export { I18nPluralPipe } from './pipes/i18n_plural_pipe';
export { I18nSelectPipe } from './pipes/i18n_select_pipe';
export { COMMON_PIPES } from './pipes/common_pipes';
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoicGlwZXMuanMiLCJzb3VyY2VSb290IjoiIiwic291cmNlcyI6WyJkaWZmaW5nX3BsdWdpbl93cmFwcGVyLW91dHB1dF9wYXRoLW9YRE80cDJ2LnRtcC9hbmd1bGFyMi9zcmMvY29tbW9uL3BpcGVzLnRzIl0sIm5hbWVzIjpbXSwibWFwcGluZ3MiOiJBQUFBOzs7O0dBSUc7QUFFSCxTQUFRLFNBQVMsUUFBTyxvQkFBb0IsQ0FBQztBQUM3QyxTQUFRLFFBQVEsUUFBTyxtQkFBbUIsQ0FBQztBQUMzQyxTQUFRLFFBQVEsUUFBTyxtQkFBbUIsQ0FBQztBQUMzQyxTQUFRLFNBQVMsUUFBTyxvQkFBb0IsQ0FBQztBQUM3QyxTQUFRLGFBQWEsUUFBTyx3QkFBd0IsQ0FBQztBQUNyRCxTQUFRLFVBQVUsRUFBRSxXQUFXLEVBQUUsV0FBVyxFQUFFLFlBQVksUUFBTyxxQkFBcUIsQ0FBQztBQUN2RixTQUFRLGFBQWEsUUFBTyx3QkFBd0IsQ0FBQztBQUNyRCxTQUFRLFdBQVcsUUFBTyxzQkFBc0IsQ0FBQztBQUNqRCxTQUFRLGNBQWMsUUFBTywwQkFBMEIsQ0FBQztBQUN4RCxTQUFRLGNBQWMsUUFBTywwQkFBMEIsQ0FBQztBQUN4RCxTQUFRLFlBQVksUUFBTyxzQkFBc0IsQ0FBQyIsInNvdXJjZXNDb250ZW50IjpbIi8qKlxuICogQG1vZHVsZVxuICogQGRlc2NyaXB0aW9uXG4gKiBUaGlzIG1vZHVsZSBwcm92aWRlcyBhIHNldCBvZiBjb21tb24gUGlwZXMuXG4gKi9cblxuZXhwb3J0IHtBc3luY1BpcGV9IGZyb20gJy4vcGlwZXMvYXN5bmNfcGlwZSc7XG5leHBvcnQge0RhdGVQaXBlfSBmcm9tICcuL3BpcGVzL2RhdGVfcGlwZSc7XG5leHBvcnQge0pzb25QaXBlfSBmcm9tICcuL3BpcGVzL2pzb25fcGlwZSc7XG5leHBvcnQge1NsaWNlUGlwZX0gZnJvbSAnLi9waXBlcy9zbGljZV9waXBlJztcbmV4cG9ydCB7TG93ZXJDYXNlUGlwZX0gZnJvbSAnLi9waXBlcy9sb3dlcmNhc2VfcGlwZSc7XG5leHBvcnQge051bWJlclBpcGUsIERlY2ltYWxQaXBlLCBQZXJjZW50UGlwZSwgQ3VycmVuY3lQaXBlfSBmcm9tICcuL3BpcGVzL251bWJlcl9waXBlJztcbmV4cG9ydCB7VXBwZXJDYXNlUGlwZX0gZnJvbSAnLi9waXBlcy91cHBlcmNhc2VfcGlwZSc7XG5leHBvcnQge1JlcGxhY2VQaXBlfSBmcm9tICcuL3BpcGVzL3JlcGxhY2VfcGlwZSc7XG5leHBvcnQge0kxOG5QbHVyYWxQaXBlfSBmcm9tICcuL3BpcGVzL2kxOG5fcGx1cmFsX3BpcGUnO1xuZXhwb3J0IHtJMThuU2VsZWN0UGlwZX0gZnJvbSAnLi9waXBlcy9pMThuX3NlbGVjdF9waXBlJztcbmV4cG9ydCB7Q09NTU9OX1BJUEVTfSBmcm9tICcuL3BpcGVzL2NvbW1vbl9waXBlcyc7XG4iXX0=