var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
import { isPresent, isBlank, StringWrapper, IS_DART, CONST_EXPR } from 'angular2/src/facade/lang';
import { StringMapWrapper, ListWrapper } from 'angular2/src/facade/collection';
import { templateVisitAll } from './template_ast';
import { moduleRef } from './source_module';
import { AppProtoView } from 'angular2/src/core/linker/view';
import { ViewType } from 'angular2/src/core/linker/view_type';
import { AppProtoElement } from 'angular2/src/core/linker/element';
import { MODULE_SUFFIX, codeGenStringMap, Expression, Statement } from './util';
import { Injectable } from 'angular2/src/core/di';
export const PROTO_VIEW_JIT_IMPORTS = CONST_EXPR({ 'AppProtoView': AppProtoView, 'AppProtoElement': AppProtoElement, 'ViewType': ViewType });
// TODO: have a single file that reexports everything needed for
// codegen explicitly
// - helps understanding what codegen works against
// - less imports in codegen code
export var APP_VIEW_MODULE_REF = moduleRef('package:angular2/src/core/linker/view' + MODULE_SUFFIX);
export var VIEW_TYPE_MODULE_REF = moduleRef('package:angular2/src/core/linker/view_type' + MODULE_SUFFIX);
export var APP_EL_MODULE_REF = moduleRef('package:angular2/src/core/linker/element' + MODULE_SUFFIX);
export var METADATA_MODULE_REF = moduleRef('package:angular2/src/core/metadata/view' + MODULE_SUFFIX);
const IMPLICIT_TEMPLATE_VAR = '\$implicit';
const CLASS_ATTR = 'class';
const STYLE_ATTR = 'style';
export let ProtoViewCompiler = class ProtoViewCompiler {
    constructor() {
    }
    compileProtoViewRuntime(metadataCache, component, template, pipes) {
        var protoViewFactory = new RuntimeProtoViewFactory(metadataCache, component, pipes);
        var allProtoViews = [];
        protoViewFactory.createCompileProtoView(template, [], [], allProtoViews);
        return new CompileProtoViews([], allProtoViews);
    }
    compileProtoViewCodeGen(resolvedMetadataCacheExpr, component, template, pipes) {
        var protoViewFactory = new CodeGenProtoViewFactory(resolvedMetadataCacheExpr, component, pipes);
        var allProtoViews = [];
        var allStatements = [];
        protoViewFactory.createCompileProtoView(template, [], allStatements, allProtoViews);
        return new CompileProtoViews(allStatements.map(stmt => stmt.statement), allProtoViews);
    }
};
ProtoViewCompiler = __decorate([
    Injectable(), 
    __metadata('design:paramtypes', [])
], ProtoViewCompiler);
export class CompileProtoViews {
    constructor(declarations, protoViews) {
        this.declarations = declarations;
        this.protoViews = protoViews;
    }
}
export class CompileProtoView {
    constructor(embeddedTemplateIndex, protoElements, protoView) {
        this.embeddedTemplateIndex = embeddedTemplateIndex;
        this.protoElements = protoElements;
        this.protoView = protoView;
    }
}
export class CompileProtoElement {
    constructor(boundElementIndex, attrNameAndValues, variableNameAndValues, renderEvents, directives, embeddedTemplateIndex, appProtoEl) {
        this.boundElementIndex = boundElementIndex;
        this.attrNameAndValues = attrNameAndValues;
        this.variableNameAndValues = variableNameAndValues;
        this.renderEvents = renderEvents;
        this.directives = directives;
        this.embeddedTemplateIndex = embeddedTemplateIndex;
        this.appProtoEl = appProtoEl;
    }
}
function visitAndReturnContext(visitor, asts, context) {
    templateVisitAll(visitor, asts, context);
    return context;
}
class ProtoViewFactory {
    constructor(component) {
        this.component = component;
    }
    createCompileProtoView(template, templateVariableBindings, targetStatements, targetProtoViews) {
        var embeddedTemplateIndex = targetProtoViews.length;
        // Note: targetProtoViews needs to be in depth first order.
        // So we "reserve" a space here that we fill after the recursion is done
        targetProtoViews.push(null);
        var builder = new ProtoViewBuilderVisitor(this, targetStatements, targetProtoViews);
        templateVisitAll(builder, template);
        var viewType = getViewType(this.component, embeddedTemplateIndex);
        var appProtoView = this.createAppProtoView(embeddedTemplateIndex, viewType, templateVariableBindings, targetStatements);
        var cpv = new CompileProtoView(embeddedTemplateIndex, builder.protoElements, appProtoView);
        targetProtoViews[embeddedTemplateIndex] = cpv;
        return cpv;
    }
}
class CodeGenProtoViewFactory extends ProtoViewFactory {
    constructor(resolvedMetadataCacheExpr, component, pipes) {
        super(component);
        this.resolvedMetadataCacheExpr = resolvedMetadataCacheExpr;
        this.pipes = pipes;
        this._nextVarId = 0;
    }
    _nextProtoViewVar(embeddedTemplateIndex) {
        return `appProtoView${this._nextVarId++}_${this.component.type.name}${embeddedTemplateIndex}`;
    }
    createAppProtoView(embeddedTemplateIndex, viewType, templateVariableBindings, targetStatements) {
        var protoViewVarName = this._nextProtoViewVar(embeddedTemplateIndex);
        var viewTypeExpr = codeGenViewType(viewType);
        var pipesExpr = embeddedTemplateIndex === 0 ?
            codeGenTypesArray(this.pipes.map(pipeMeta => pipeMeta.type)) :
            null;
        var statement = `var ${protoViewVarName} = ${APP_VIEW_MODULE_REF}AppProtoView.create(${this.resolvedMetadataCacheExpr.expression}, ${viewTypeExpr}, ${pipesExpr}, ${codeGenStringMap(templateVariableBindings)});`;
        targetStatements.push(new Statement(statement));
        return new Expression(protoViewVarName);
    }
    createAppProtoElement(boundElementIndex, attrNameAndValues, variableNameAndValues, directives, targetStatements) {
        var varName = `appProtoEl${this._nextVarId++}_${this.component.type.name}`;
        var value = `${APP_EL_MODULE_REF}AppProtoElement.create(
        ${this.resolvedMetadataCacheExpr.expression},
        ${boundElementIndex},
        ${codeGenStringMap(attrNameAndValues)},
        ${codeGenDirectivesArray(directives)},
        ${codeGenStringMap(variableNameAndValues)}
      )`;
        var statement = `var ${varName} = ${value};`;
        targetStatements.push(new Statement(statement));
        return new Expression(varName);
    }
}
class RuntimeProtoViewFactory extends ProtoViewFactory {
    constructor(metadataCache, component, pipes) {
        super(component);
        this.metadataCache = metadataCache;
        this.pipes = pipes;
    }
    createAppProtoView(embeddedTemplateIndex, viewType, templateVariableBindings, targetStatements) {
        var pipes = embeddedTemplateIndex === 0 ? this.pipes.map(pipeMeta => pipeMeta.type.runtime) : [];
        var templateVars = keyValueArrayToStringMap(templateVariableBindings);
        return AppProtoView.create(this.metadataCache, viewType, pipes, templateVars);
    }
    createAppProtoElement(boundElementIndex, attrNameAndValues, variableNameAndValues, directives, targetStatements) {
        var attrs = keyValueArrayToStringMap(attrNameAndValues);
        return AppProtoElement.create(this.metadataCache, boundElementIndex, attrs, directives.map(dirMeta => dirMeta.type.runtime), keyValueArrayToStringMap(variableNameAndValues));
    }
}
class ProtoViewBuilderVisitor {
    constructor(factory, allStatements, allProtoViews) {
        this.factory = factory;
        this.allStatements = allStatements;
        this.allProtoViews = allProtoViews;
        this.protoElements = [];
        this.boundElementCount = 0;
    }
    _readAttrNameAndValues(directives, attrAsts) {
        var attrs = visitAndReturnContext(this, attrAsts, {});
        directives.forEach(directiveMeta => {
            StringMapWrapper.forEach(directiveMeta.hostAttributes, (value, name) => {
                var prevValue = attrs[name];
                attrs[name] = isPresent(prevValue) ? mergeAttributeValue(name, prevValue, value) : value;
            });
        });
        return mapToKeyValueArray(attrs);
    }
    visitBoundText(ast, context) { return null; }
    visitText(ast, context) { return null; }
    visitNgContent(ast, context) { return null; }
    visitElement(ast, context) {
        var boundElementIndex = null;
        if (ast.isBound()) {
            boundElementIndex = this.boundElementCount++;
        }
        var component = ast.getComponent();
        var variableNameAndValues = [];
        if (isBlank(component)) {
            ast.exportAsVars.forEach((varAst) => { variableNameAndValues.push([varAst.name, null]); });
        }
        var directives = [];
        var renderEvents = visitAndReturnContext(this, ast.outputs, new Map());
        ListWrapper.forEachWithIndex(ast.directives, (directiveAst, index) => {
            directiveAst.visit(this, new DirectiveContext(index, boundElementIndex, renderEvents, variableNameAndValues, directives));
        });
        var renderEventArray = [];
        renderEvents.forEach((eventAst, _) => renderEventArray.push(eventAst));
        var attrNameAndValues = this._readAttrNameAndValues(directives, ast.attrs);
        this._addProtoElement(ast.isBound(), boundElementIndex, attrNameAndValues, variableNameAndValues, renderEventArray, directives, null);
        templateVisitAll(this, ast.children);
        return null;
    }
    visitEmbeddedTemplate(ast, context) {
        var boundElementIndex = this.boundElementCount++;
        var directives = [];
        ListWrapper.forEachWithIndex(ast.directives, (directiveAst, index) => {
            directiveAst.visit(this, new DirectiveContext(index, boundElementIndex, new Map(), [], directives));
        });
        var attrNameAndValues = this._readAttrNameAndValues(directives, ast.attrs);
        var templateVariableBindings = ast.vars.map(varAst => [varAst.value.length > 0 ? varAst.value : IMPLICIT_TEMPLATE_VAR, varAst.name]);
        var nestedProtoView = this.factory.createCompileProtoView(ast.children, templateVariableBindings, this.allStatements, this.allProtoViews);
        this._addProtoElement(true, boundElementIndex, attrNameAndValues, [], [], directives, nestedProtoView.embeddedTemplateIndex);
        return null;
    }
    _addProtoElement(isBound, boundElementIndex, attrNameAndValues, variableNameAndValues, renderEvents, directives, embeddedTemplateIndex) {
        var appProtoEl = null;
        if (isBound) {
            appProtoEl =
                this.factory.createAppProtoElement(boundElementIndex, attrNameAndValues, variableNameAndValues, directives, this.allStatements);
        }
        var compileProtoEl = new CompileProtoElement(boundElementIndex, attrNameAndValues, variableNameAndValues, renderEvents, directives, embeddedTemplateIndex, appProtoEl);
        this.protoElements.push(compileProtoEl);
    }
    visitVariable(ast, ctx) { return null; }
    visitAttr(ast, attrNameAndValues) {
        attrNameAndValues[ast.name] = ast.value;
        return null;
    }
    visitDirective(ast, ctx) {
        ctx.targetDirectives.push(ast.directive);
        templateVisitAll(this, ast.hostEvents, ctx.hostEventTargetAndNames);
        ast.exportAsVars.forEach(varAst => { ctx.targetVariableNameAndValues.push([varAst.name, ctx.index]); });
        return null;
    }
    visitEvent(ast, eventTargetAndNames) {
        eventTargetAndNames.set(ast.fullName, ast);
        return null;
    }
    visitDirectiveProperty(ast, context) { return null; }
    visitElementProperty(ast, context) { return null; }
}
function mapToKeyValueArray(data) {
    var entryArray = [];
    StringMapWrapper.forEach(data, (value, name) => { entryArray.push([name, value]); });
    // We need to sort to get a defined output order
    // for tests and for caching generated artifacts...
    ListWrapper.sort(entryArray, (entry1, entry2) => StringWrapper.compare(entry1[0], entry2[0]));
    var keyValueArray = [];
    entryArray.forEach((entry) => { keyValueArray.push([entry[0], entry[1]]); });
    return keyValueArray;
}
function mergeAttributeValue(attrName, attrValue1, attrValue2) {
    if (attrName == CLASS_ATTR || attrName == STYLE_ATTR) {
        return `${attrValue1} ${attrValue2}`;
    }
    else {
        return attrValue2;
    }
}
class DirectiveContext {
    constructor(index, boundElementIndex, hostEventTargetAndNames, targetVariableNameAndValues, targetDirectives) {
        this.index = index;
        this.boundElementIndex = boundElementIndex;
        this.hostEventTargetAndNames = hostEventTargetAndNames;
        this.targetVariableNameAndValues = targetVariableNameAndValues;
        this.targetDirectives = targetDirectives;
    }
}
function keyValueArrayToStringMap(keyValueArray) {
    var stringMap = {};
    for (var i = 0; i < keyValueArray.length; i++) {
        var entry = keyValueArray[i];
        stringMap[entry[0]] = entry[1];
    }
    return stringMap;
}
function codeGenDirectivesArray(directives) {
    var expressions = directives.map(directiveType => typeRef(directiveType.type));
    return `[${expressions.join(',')}]`;
}
function codeGenTypesArray(types) {
    var expressions = types.map(typeRef);
    return `[${expressions.join(',')}]`;
}
function codeGenViewType(value) {
    if (IS_DART) {
        return `${VIEW_TYPE_MODULE_REF}${value}`;
    }
    else {
        return `${value}`;
    }
}
function typeRef(type) {
    return `${moduleRef(type.moduleUrl)}${type.name}`;
}
function getViewType(component, embeddedTemplateIndex) {
    if (embeddedTemplateIndex > 0) {
        return ViewType.EMBEDDED;
    }
    else if (component.type.isHost) {
        return ViewType.HOST;
    }
    else {
        return ViewType.COMPONENT;
    }
}
//# sourceMappingURL=data:application/json;base64,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