'use strict';"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var lang_1 = require('angular2/src/facade/lang');
var collection_1 = require('angular2/src/facade/collection');
var template_ast_1 = require('./template_ast');
var source_module_1 = require('./source_module');
var view_1 = require('angular2/src/core/linker/view');
var view_type_1 = require('angular2/src/core/linker/view_type');
var element_1 = require('angular2/src/core/linker/element');
var view_2 = require('angular2/src/core/metadata/view');
var util_1 = require('./util');
var di_1 = require('angular2/src/core/di');
var proto_view_compiler_1 = require('./proto_view_compiler');
exports.VIEW_JIT_IMPORTS = lang_1.CONST_EXPR({
    'AppView': view_1.AppView,
    'AppElement': element_1.AppElement,
    'flattenNestedViewRenderNodes': view_1.flattenNestedViewRenderNodes,
    'checkSlotCount': view_1.checkSlotCount
});
var ViewCompiler = (function () {
    function ViewCompiler() {
    }
    ViewCompiler.prototype.compileComponentRuntime = function (component, template, styles, protoViews, changeDetectorFactories, componentViewFactory) {
        var viewFactory = new RuntimeViewFactory(component, styles, protoViews, changeDetectorFactories, componentViewFactory);
        return viewFactory.createViewFactory(template, 0, []);
    };
    ViewCompiler.prototype.compileComponentCodeGen = function (component, template, styles, protoViews, changeDetectorFactoryExpressions, componentViewFactory) {
        var viewFactory = new CodeGenViewFactory(component, styles, protoViews, changeDetectorFactoryExpressions, componentViewFactory);
        var targetStatements = [];
        var viewFactoryExpression = viewFactory.createViewFactory(template, 0, targetStatements);
        return new source_module_1.SourceExpression(targetStatements.map(function (stmt) { return stmt.statement; }), viewFactoryExpression.expression);
    };
    ViewCompiler = __decorate([
        di_1.Injectable(), 
        __metadata('design:paramtypes', [])
    ], ViewCompiler);
    return ViewCompiler;
}());
exports.ViewCompiler = ViewCompiler;
var CodeGenViewFactory = (function () {
    function CodeGenViewFactory(component, styles, protoViews, changeDetectorExpressions, componentViewFactory) {
        this.component = component;
        this.styles = styles;
        this.protoViews = protoViews;
        this.changeDetectorExpressions = changeDetectorExpressions;
        this.componentViewFactory = componentViewFactory;
        this._nextVarId = 0;
    }
    CodeGenViewFactory.prototype._nextVar = function (prefix) {
        return "" + prefix + this._nextVarId++ + "_" + this.component.type.name;
    };
    CodeGenViewFactory.prototype._nextRenderVar = function () { return this._nextVar('render'); };
    CodeGenViewFactory.prototype._nextAppVar = function () { return this._nextVar('app'); };
    CodeGenViewFactory.prototype._nextDisposableVar = function () {
        return "disposable" + this._nextVarId++ + "_" + this.component.type.name;
    };
    CodeGenViewFactory.prototype.createText = function (renderer, parent, text, targetStatements) {
        var varName = this._nextRenderVar();
        var statement = "var " + varName + " = " + renderer.expression + ".createText(" + (lang_1.isPresent(parent) ? parent.expression : null) + ", " + util_1.escapeSingleQuoteString(text) + ");";
        targetStatements.push(new util_1.Statement(statement));
        return new util_1.Expression(varName);
    };
    CodeGenViewFactory.prototype.createElement = function (renderer, parentRenderNode, name, rootSelector, targetStatements) {
        var varName = this._nextRenderVar();
        var valueExpr;
        if (lang_1.isPresent(rootSelector)) {
            valueExpr = rootSelector.expression + " == null ?\n        " + renderer.expression + ".createElement(" + (lang_1.isPresent(parentRenderNode) ? parentRenderNode.expression : null) + ", " + util_1.escapeSingleQuoteString(name) + ") :\n        " + renderer.expression + ".selectRootElement(" + rootSelector.expression + ");";
        }
        else {
            valueExpr =
                renderer.expression + ".createElement(" + (lang_1.isPresent(parentRenderNode) ? parentRenderNode.expression : null) + ", " + util_1.escapeSingleQuoteString(name) + ")";
        }
        var statement = "var " + varName + " = " + valueExpr + ";";
        targetStatements.push(new util_1.Statement(statement));
        return new util_1.Expression(varName);
    };
    CodeGenViewFactory.prototype.createTemplateAnchor = function (renderer, parentRenderNode, targetStatements) {
        var varName = this._nextRenderVar();
        var valueExpr = renderer.expression + ".createTemplateAnchor(" + (lang_1.isPresent(parentRenderNode) ? parentRenderNode.expression : null) + ");";
        targetStatements.push(new util_1.Statement("var " + varName + " = " + valueExpr));
        return new util_1.Expression(varName);
    };
    CodeGenViewFactory.prototype.createGlobalEventListener = function (renderer, appView, boundElementIndex, eventAst, targetStatements) {
        var disposableVar = this._nextDisposableVar();
        var eventHandlerExpr = codeGenEventHandler(appView, boundElementIndex, eventAst.fullName);
        targetStatements.push(new util_1.Statement("var " + disposableVar + " = " + renderer.expression + ".listenGlobal(" + util_1.escapeValue(eventAst.target) + ", " + util_1.escapeValue(eventAst.name) + ", " + eventHandlerExpr + ");"));
        return new util_1.Expression(disposableVar);
    };
    CodeGenViewFactory.prototype.createElementEventListener = function (renderer, appView, boundElementIndex, renderNode, eventAst, targetStatements) {
        var disposableVar = this._nextDisposableVar();
        var eventHandlerExpr = codeGenEventHandler(appView, boundElementIndex, eventAst.fullName);
        targetStatements.push(new util_1.Statement("var " + disposableVar + " = " + renderer.expression + ".listen(" + renderNode.expression + ", " + util_1.escapeValue(eventAst.name) + ", " + eventHandlerExpr + ");"));
        return new util_1.Expression(disposableVar);
    };
    CodeGenViewFactory.prototype.setElementAttribute = function (renderer, renderNode, attrName, attrValue, targetStatements) {
        targetStatements.push(new util_1.Statement(renderer.expression + ".setElementAttribute(" + renderNode.expression + ", " + util_1.escapeSingleQuoteString(attrName) + ", " + util_1.escapeSingleQuoteString(attrValue) + ");"));
    };
    CodeGenViewFactory.prototype.createAppElement = function (appProtoEl, appView, renderNode, parentAppEl, embeddedViewFactory, targetStatements) {
        var appVar = this._nextAppVar();
        var varValue = "new " + proto_view_compiler_1.APP_EL_MODULE_REF + "AppElement(" + appProtoEl.expression + ", " + appView.expression + ",\n      " + (lang_1.isPresent(parentAppEl) ? parentAppEl.expression : null) + ", " + renderNode.expression + ", " + (lang_1.isPresent(embeddedViewFactory) ? embeddedViewFactory.expression : null) + ")";
        targetStatements.push(new util_1.Statement("var " + appVar + " = " + varValue + ";"));
        return new util_1.Expression(appVar);
    };
    CodeGenViewFactory.prototype.createAndSetComponentView = function (renderer, viewManager, view, appEl, component, contentNodesByNgContentIndex, targetStatements) {
        var codeGenContentNodes;
        if (this.component.type.isHost) {
            codeGenContentNodes = view.expression + ".projectableNodes";
        }
        else {
            codeGenContentNodes =
                "[" + contentNodesByNgContentIndex.map(function (nodes) { return util_1.codeGenFlatArray(nodes); }).join(',') + "]";
        }
        targetStatements.push(new util_1.Statement(this.componentViewFactory(component) + "(" + renderer.expression + ", " + viewManager.expression + ", " + appEl.expression + ", " + codeGenContentNodes + ", null, null, null);"));
    };
    CodeGenViewFactory.prototype.getProjectedNodes = function (projectableNodes, ngContentIndex) {
        return new util_1.Expression(projectableNodes.expression + "[" + ngContentIndex + "]", true);
    };
    CodeGenViewFactory.prototype.appendProjectedNodes = function (renderer, parent, nodes, targetStatements) {
        targetStatements.push(new util_1.Statement(renderer.expression + ".projectNodes(" + parent.expression + ", " + proto_view_compiler_1.APP_VIEW_MODULE_REF + "flattenNestedViewRenderNodes(" + nodes.expression + "));"));
    };
    CodeGenViewFactory.prototype.createViewFactory = function (asts, embeddedTemplateIndex, targetStatements) {
        var compileProtoView = this.protoViews[embeddedTemplateIndex];
        var isHostView = this.component.type.isHost;
        var isComponentView = embeddedTemplateIndex === 0 && !isHostView;
        var visitor = new ViewBuilderVisitor(new util_1.Expression('renderer'), new util_1.Expression('viewManager'), new util_1.Expression('projectableNodes'), isHostView ? new util_1.Expression('rootSelector') : null, new util_1.Expression('view'), compileProtoView, targetStatements, this);
        template_ast_1.templateVisitAll(visitor, asts, new ParentElement(isComponentView ? new util_1.Expression('parentRenderNode') : null, null, null));
        var appProtoView = compileProtoView.protoView.expression;
        var viewFactoryName = codeGenViewFactoryName(this.component, embeddedTemplateIndex);
        var changeDetectorFactory = this.changeDetectorExpressions.expressions[embeddedTemplateIndex];
        var factoryArgs = [
            'parentRenderer',
            'viewManager',
            'containerEl',
            'projectableNodes',
            'rootSelector',
            'dynamicallyCreatedProviders',
            'rootInjector'
        ];
        var initRendererStmts = [];
        var rendererExpr = "parentRenderer";
        if (embeddedTemplateIndex === 0) {
            var renderCompTypeVar = this._nextVar('renderType');
            targetStatements.push(new util_1.Statement("var " + renderCompTypeVar + " = null;"));
            var stylesVar = this._nextVar('styles');
            targetStatements.push(new util_1.Statement(util_1.CONST_VAR + " " + stylesVar + " = " + this.styles.expression + ";"));
            var encapsulation = this.component.template.encapsulation;
            initRendererStmts.push("if (" + renderCompTypeVar + " == null) {\n        " + renderCompTypeVar + " = viewManager.createRenderComponentType(" + codeGenViewEncapsulation(encapsulation) + ", " + stylesVar + ");\n      }");
            rendererExpr = "parentRenderer.renderComponent(" + renderCompTypeVar + ")";
        }
        var statement = "\n" + util_1.codeGenFnHeader(factoryArgs, viewFactoryName) + "{\n  " + initRendererStmts.join('\n') + "\n  var renderer = " + rendererExpr + ";\n  var view = new " + proto_view_compiler_1.APP_VIEW_MODULE_REF + "AppView(\n    " + appProtoView + ", renderer, viewManager,\n    projectableNodes,\n    containerEl,\n    dynamicallyCreatedProviders, rootInjector,\n    " + changeDetectorFactory + "()\n  );\n  " + proto_view_compiler_1.APP_VIEW_MODULE_REF + "checkSlotCount(" + util_1.escapeValue(this.component.type.name) + ", " + this.component.template.ngContentSelectors.length + ", projectableNodes);\n  " + (isComponentView ? 'var parentRenderNode = renderer.createViewRoot(view.containerAppElement.nativeElement);' : '') + "\n  " + visitor.renderStmts.map(function (stmt) { return stmt.statement; }).join('\n') + "\n  " + visitor.appStmts.map(function (stmt) { return stmt.statement; }).join('\n') + "\n\n  view.init(" + util_1.codeGenFlatArray(visitor.rootNodesOrAppElements) + ", " + util_1.codeGenArray(visitor.renderNodes) + ", " + util_1.codeGenArray(visitor.appDisposables) + ",\n            " + util_1.codeGenArray(visitor.appElements) + ");\n  return view;\n}";
        targetStatements.push(new util_1.Statement(statement));
        return new util_1.Expression(viewFactoryName);
    };
    return CodeGenViewFactory;
}());
var RuntimeViewFactory = (function () {
    function RuntimeViewFactory(component, styles, protoViews, changeDetectorFactories, componentViewFactory) {
        this.component = component;
        this.styles = styles;
        this.protoViews = protoViews;
        this.changeDetectorFactories = changeDetectorFactories;
        this.componentViewFactory = componentViewFactory;
    }
    RuntimeViewFactory.prototype.createText = function (renderer, parent, text, targetStatements) {
        return renderer.createText(parent, text);
    };
    RuntimeViewFactory.prototype.createElement = function (renderer, parent, name, rootSelector, targetStatements) {
        var el;
        if (lang_1.isPresent(rootSelector)) {
            el = renderer.selectRootElement(rootSelector);
        }
        else {
            el = renderer.createElement(parent, name);
        }
        return el;
    };
    RuntimeViewFactory.prototype.createTemplateAnchor = function (renderer, parent, targetStatements) {
        return renderer.createTemplateAnchor(parent);
    };
    RuntimeViewFactory.prototype.createGlobalEventListener = function (renderer, appView, boundElementIndex, eventAst, targetStatements) {
        return renderer.listenGlobal(eventAst.target, eventAst.name, function (event) { return appView.triggerEventHandlers(eventAst.fullName, event, boundElementIndex); });
    };
    RuntimeViewFactory.prototype.createElementEventListener = function (renderer, appView, boundElementIndex, renderNode, eventAst, targetStatements) {
        return renderer.listen(renderNode, eventAst.name, function (event) { return appView.triggerEventHandlers(eventAst.fullName, event, boundElementIndex); });
    };
    RuntimeViewFactory.prototype.setElementAttribute = function (renderer, renderNode, attrName, attrValue, targetStatements) {
        renderer.setElementAttribute(renderNode, attrName, attrValue);
    };
    RuntimeViewFactory.prototype.createAppElement = function (appProtoEl, appView, renderNode, parentAppEl, embeddedViewFactory, targetStatements) {
        return new element_1.AppElement(appProtoEl, appView, parentAppEl, renderNode, embeddedViewFactory);
    };
    RuntimeViewFactory.prototype.createAndSetComponentView = function (renderer, viewManager, appView, appEl, component, contentNodesByNgContentIndex, targetStatements) {
        var flattenedContentNodes;
        if (this.component.type.isHost) {
            flattenedContentNodes = appView.projectableNodes;
        }
        else {
            flattenedContentNodes = collection_1.ListWrapper.createFixedSize(contentNodesByNgContentIndex.length);
            for (var i = 0; i < contentNodesByNgContentIndex.length; i++) {
                flattenedContentNodes[i] = util_1.flattenArray(contentNodesByNgContentIndex[i], []);
            }
        }
        this.componentViewFactory(component)(renderer, viewManager, appEl, flattenedContentNodes);
    };
    RuntimeViewFactory.prototype.getProjectedNodes = function (projectableNodes, ngContentIndex) {
        return projectableNodes[ngContentIndex];
    };
    RuntimeViewFactory.prototype.appendProjectedNodes = function (renderer, parent, nodes, targetStatements) {
        renderer.projectNodes(parent, view_1.flattenNestedViewRenderNodes(nodes));
    };
    RuntimeViewFactory.prototype.createViewFactory = function (asts, embeddedTemplateIndex, targetStatements) {
        var _this = this;
        var compileProtoView = this.protoViews[embeddedTemplateIndex];
        var isComponentView = compileProtoView.protoView.type === view_type_1.ViewType.COMPONENT;
        var renderComponentType = null;
        return function (parentRenderer, viewManager, containerEl, projectableNodes, rootSelector, dynamicallyCreatedProviders, rootInjector) {
            if (rootSelector === void 0) { rootSelector = null; }
            if (dynamicallyCreatedProviders === void 0) { dynamicallyCreatedProviders = null; }
            if (rootInjector === void 0) { rootInjector = null; }
            view_1.checkSlotCount(_this.component.type.name, _this.component.template.ngContentSelectors.length, projectableNodes);
            var renderer;
            if (embeddedTemplateIndex === 0) {
                if (lang_1.isBlank(renderComponentType)) {
                    renderComponentType = viewManager.createRenderComponentType(_this.component.template.encapsulation, _this.styles);
                }
                renderer = parentRenderer.renderComponent(renderComponentType);
            }
            else {
                renderer = parentRenderer;
            }
            var changeDetector = _this.changeDetectorFactories[embeddedTemplateIndex]();
            var view = new view_1.AppView(compileProtoView.protoView, renderer, viewManager, projectableNodes, containerEl, dynamicallyCreatedProviders, rootInjector, changeDetector);
            var visitor = new ViewBuilderVisitor(renderer, viewManager, projectableNodes, rootSelector, view, compileProtoView, [], _this);
            var parentRenderNode = isComponentView ? renderer.createViewRoot(containerEl.nativeElement) : null;
            template_ast_1.templateVisitAll(visitor, asts, new ParentElement(parentRenderNode, null, null));
            view.init(util_1.flattenArray(visitor.rootNodesOrAppElements, []), visitor.renderNodes, visitor.appDisposables, visitor.appElements);
            return view;
        };
    };
    return RuntimeViewFactory;
}());
var ParentElement = (function () {
    function ParentElement(renderNode, appEl, component) {
        this.renderNode = renderNode;
        this.appEl = appEl;
        this.component = component;
        if (lang_1.isPresent(component)) {
            this.contentNodesByNgContentIndex =
                collection_1.ListWrapper.createFixedSize(component.template.ngContentSelectors.length);
            for (var i = 0; i < this.contentNodesByNgContentIndex.length; i++) {
                this.contentNodesByNgContentIndex[i] = [];
            }
        }
        else {
            this.contentNodesByNgContentIndex = null;
        }
    }
    ParentElement.prototype.addContentNode = function (ngContentIndex, nodeExpr) {
        this.contentNodesByNgContentIndex[ngContentIndex].push(nodeExpr);
    };
    return ParentElement;
}());
var ViewBuilderVisitor = (function () {
    function ViewBuilderVisitor(renderer, viewManager, projectableNodes, rootSelector, view, protoView, targetStatements, factory) {
        this.renderer = renderer;
        this.viewManager = viewManager;
        this.projectableNodes = projectableNodes;
        this.rootSelector = rootSelector;
        this.view = view;
        this.protoView = protoView;
        this.targetStatements = targetStatements;
        this.factory = factory;
        this.renderStmts = [];
        this.renderNodes = [];
        this.appStmts = [];
        this.appElements = [];
        this.appDisposables = [];
        this.rootNodesOrAppElements = [];
        this.elementCount = 0;
    }
    ViewBuilderVisitor.prototype._addRenderNode = function (renderNode, appEl, ngContentIndex, parent) {
        this.renderNodes.push(renderNode);
        if (lang_1.isPresent(parent.component)) {
            if (lang_1.isPresent(ngContentIndex)) {
                parent.addContentNode(ngContentIndex, lang_1.isPresent(appEl) ? appEl : renderNode);
            }
        }
        else if (lang_1.isBlank(parent.renderNode)) {
            this.rootNodesOrAppElements.push(lang_1.isPresent(appEl) ? appEl : renderNode);
        }
    };
    ViewBuilderVisitor.prototype._getParentRenderNode = function (ngContentIndex, parent) {
        return lang_1.isPresent(parent.component) &&
            parent.component.template.encapsulation !== view_2.ViewEncapsulation.Native ?
            null :
            parent.renderNode;
    };
    ViewBuilderVisitor.prototype.visitBoundText = function (ast, parent) {
        return this._visitText('', ast.ngContentIndex, parent);
    };
    ViewBuilderVisitor.prototype.visitText = function (ast, parent) {
        return this._visitText(ast.value, ast.ngContentIndex, parent);
    };
    ViewBuilderVisitor.prototype._visitText = function (value, ngContentIndex, parent) {
        var renderNode = this.factory.createText(this.renderer, this._getParentRenderNode(ngContentIndex, parent), value, this.renderStmts);
        this._addRenderNode(renderNode, null, ngContentIndex, parent);
        return null;
    };
    ViewBuilderVisitor.prototype.visitNgContent = function (ast, parent) {
        var nodesExpression = this.factory.getProjectedNodes(this.projectableNodes, ast.index);
        if (lang_1.isPresent(parent.component)) {
            if (lang_1.isPresent(ast.ngContentIndex)) {
                parent.addContentNode(ast.ngContentIndex, nodesExpression);
            }
        }
        else {
            if (lang_1.isPresent(parent.renderNode)) {
                this.factory.appendProjectedNodes(this.renderer, parent.renderNode, nodesExpression, this.renderStmts);
            }
            else {
                this.rootNodesOrAppElements.push(nodesExpression);
            }
        }
        return null;
    };
    ViewBuilderVisitor.prototype.visitElement = function (ast, parent) {
        var _this = this;
        var renderNode = this.factory.createElement(this.renderer, this._getParentRenderNode(ast.ngContentIndex, parent), ast.name, this.rootSelector, this.renderStmts);
        var component = ast.getComponent();
        var elementIndex = this.elementCount++;
        var protoEl = this.protoView.protoElements[elementIndex];
        protoEl.renderEvents.forEach(function (eventAst) {
            var disposable;
            if (lang_1.isPresent(eventAst.target)) {
                disposable = _this.factory.createGlobalEventListener(_this.renderer, _this.view, protoEl.boundElementIndex, eventAst, _this.renderStmts);
            }
            else {
                disposable = _this.factory.createElementEventListener(_this.renderer, _this.view, protoEl.boundElementIndex, renderNode, eventAst, _this.renderStmts);
            }
            _this.appDisposables.push(disposable);
        });
        for (var i = 0; i < protoEl.attrNameAndValues.length; i++) {
            var attrName = protoEl.attrNameAndValues[i][0];
            var attrValue = protoEl.attrNameAndValues[i][1];
            this.factory.setElementAttribute(this.renderer, renderNode, attrName, attrValue, this.renderStmts);
        }
        var appEl = null;
        if (lang_1.isPresent(protoEl.appProtoEl)) {
            appEl = this.factory.createAppElement(protoEl.appProtoEl, this.view, renderNode, parent.appEl, null, this.appStmts);
            this.appElements.push(appEl);
        }
        this._addRenderNode(renderNode, appEl, ast.ngContentIndex, parent);
        var newParent = new ParentElement(renderNode, lang_1.isPresent(appEl) ? appEl : parent.appEl, component);
        template_ast_1.templateVisitAll(this, ast.children, newParent);
        if (lang_1.isPresent(appEl) && lang_1.isPresent(component)) {
            this.factory.createAndSetComponentView(this.renderer, this.viewManager, this.view, appEl, component, newParent.contentNodesByNgContentIndex, this.appStmts);
        }
        return null;
    };
    ViewBuilderVisitor.prototype.visitEmbeddedTemplate = function (ast, parent) {
        var renderNode = this.factory.createTemplateAnchor(this.renderer, this._getParentRenderNode(ast.ngContentIndex, parent), this.renderStmts);
        var elementIndex = this.elementCount++;
        var protoEl = this.protoView.protoElements[elementIndex];
        var embeddedViewFactory = this.factory.createViewFactory(ast.children, protoEl.embeddedTemplateIndex, this.targetStatements);
        var appEl = this.factory.createAppElement(protoEl.appProtoEl, this.view, renderNode, parent.appEl, embeddedViewFactory, this.appStmts);
        this._addRenderNode(renderNode, appEl, ast.ngContentIndex, parent);
        this.appElements.push(appEl);
        return null;
    };
    ViewBuilderVisitor.prototype.visitVariable = function (ast, ctx) { return null; };
    ViewBuilderVisitor.prototype.visitAttr = function (ast, ctx) { return null; };
    ViewBuilderVisitor.prototype.visitDirective = function (ast, ctx) { return null; };
    ViewBuilderVisitor.prototype.visitEvent = function (ast, ctx) { return null; };
    ViewBuilderVisitor.prototype.visitDirectiveProperty = function (ast, context) { return null; };
    ViewBuilderVisitor.prototype.visitElementProperty = function (ast, context) { return null; };
    return ViewBuilderVisitor;
}());
function codeGenEventHandler(view, boundElementIndex, eventName) {
    return util_1.codeGenValueFn(['event'], view.expression + ".triggerEventHandlers(" + util_1.escapeValue(eventName) + ", event, " + boundElementIndex + ")");
}
function codeGenViewFactoryName(component, embeddedTemplateIndex) {
    return "viewFactory_" + component.type.name + embeddedTemplateIndex;
}
function codeGenViewEncapsulation(value) {
    if (lang_1.IS_DART) {
        return "" + proto_view_compiler_1.METADATA_MODULE_REF + value;
    }
    else {
        return "" + value;
    }
}
//# sourceMappingURL=data:application/json;base64,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