var globalScope;
if (typeof window === 'undefined') {
    if (typeof WorkerGlobalScope !== 'undefined' && self instanceof WorkerGlobalScope) {
        // TODO: Replace any with WorkerGlobalScope from lib.webworker.d.ts #3492
        globalScope = self;
    }
    else {
        globalScope = global;
    }
}
else {
    globalScope = window;
}
export function scheduleMicroTask(fn) {
    Zone.current.scheduleMicroTask('scheduleMicrotask', fn);
}
export const IS_DART = false;
// Need to declare a new variable for global here since TypeScript
// exports the original value of the symbol.
var _global = globalScope;
export { _global as global };
export var Type = Function;
export function getTypeNameForDebugging(type) {
    if (type['name']) {
        return type['name'];
    }
    return typeof type;
}
export var Math = _global.Math;
export var Date = _global.Date;
var _devMode = true;
var _modeLocked = false;
export function lockMode() {
    _modeLocked = true;
}
/**
 * Disable Angular's development mode, which turns off assertions and other
 * checks within the framework.
 *
 * One important assertion this disables verifies that a change detection pass
 * does not result in additional changes to any bindings (also known as
 * unidirectional data flow).
 */
export function enableProdMode() {
    if (_modeLocked) {
        // Cannot use BaseException as that ends up importing from facade/lang.
        throw 'Cannot enable prod mode after platform setup.';
    }
    _devMode = false;
}
export function assertionsEnabled() {
    return _devMode;
}
// TODO: remove calls to assert in production environment
// Note: Can't just export this and import in in other files
// as `assert` is a reserved keyword in Dart
_global.assert = function assert(condition) {
    // TODO: to be fixed properly via #2830, noop for now
};
// This function is needed only to properly support Dart's const expressions
// see https://github.com/angular/ts2dart/pull/151 for more info
export function CONST_EXPR(expr) {
    return expr;
}
export function CONST() {
    return (target) => target;
}
export function isPresent(obj) {
    return obj !== undefined && obj !== null;
}
export function isBlank(obj) {
    return obj === undefined || obj === null;
}
export function isBoolean(obj) {
    return typeof obj === "boolean";
}
export function isNumber(obj) {
    return typeof obj === "number";
}
export function isString(obj) {
    return typeof obj === "string";
}
export function isFunction(obj) {
    return typeof obj === "function";
}
export function isType(obj) {
    return isFunction(obj);
}
export function isStringMap(obj) {
    return typeof obj === 'object' && obj !== null;
}
export function isPromise(obj) {
    return obj instanceof _global.Promise;
}
export function isArray(obj) {
    return Array.isArray(obj);
}
export function isDate(obj) {
    return obj instanceof Date && !isNaN(obj.valueOf());
}
export function noop() { }
export function stringify(token) {
    if (typeof token === 'string') {
        return token;
    }
    if (token === undefined || token === null) {
        return '' + token;
    }
    if (token.name) {
        return token.name;
    }
    if (token.overriddenName) {
        return token.overriddenName;
    }
    var res = token.toString();
    var newLineIndex = res.indexOf("\n");
    return (newLineIndex === -1) ? res : res.substring(0, newLineIndex);
}
// serialize / deserialize enum exist only for consistency with dart API
// enums in typescript don't need to be serialized
export function serializeEnum(val) {
    return val;
}
export function deserializeEnum(val, values) {
    return val;
}
export function resolveEnumToken(enumValue, val) {
    return enumValue[val];
}
export class StringWrapper {
    static fromCharCode(code) { return String.fromCharCode(code); }
    static charCodeAt(s, index) { return s.charCodeAt(index); }
    static split(s, regExp) { return s.split(regExp); }
    static equals(s, s2) { return s === s2; }
    static stripLeft(s, charVal) {
        if (s && s.length) {
            var pos = 0;
            for (var i = 0; i < s.length; i++) {
                if (s[i] != charVal)
                    break;
                pos++;
            }
            s = s.substring(pos);
        }
        return s;
    }
    static stripRight(s, charVal) {
        if (s && s.length) {
            var pos = s.length;
            for (var i = s.length - 1; i >= 0; i--) {
                if (s[i] != charVal)
                    break;
                pos--;
            }
            s = s.substring(0, pos);
        }
        return s;
    }
    static replace(s, from, replace) {
        return s.replace(from, replace);
    }
    static replaceAll(s, from, replace) {
        return s.replace(from, replace);
    }
    static slice(s, from = 0, to = null) {
        return s.slice(from, to === null ? undefined : to);
    }
    static replaceAllMapped(s, from, cb) {
        return s.replace(from, function (...matches) {
            // Remove offset & string from the result array
            matches.splice(-2, 2);
            // The callback receives match, p1, ..., pn
            return cb(matches);
        });
    }
    static contains(s, substr) { return s.indexOf(substr) != -1; }
    static compare(a, b) {
        if (a < b) {
            return -1;
        }
        else if (a > b) {
            return 1;
        }
        else {
            return 0;
        }
    }
}
export class StringJoiner {
    constructor(parts = []) {
        this.parts = parts;
    }
    add(part) { this.parts.push(part); }
    toString() { return this.parts.join(""); }
}
export class NumberParseError extends Error {
    constructor(message) {
        super();
        this.message = message;
    }
    toString() { return this.message; }
}
export class NumberWrapper {
    static toFixed(n, fractionDigits) { return n.toFixed(fractionDigits); }
    static equal(a, b) { return a === b; }
    static parseIntAutoRadix(text) {
        var result = parseInt(text);
        if (isNaN(result)) {
            throw new NumberParseError("Invalid integer literal when parsing " + text);
        }
        return result;
    }
    static parseInt(text, radix) {
        if (radix == 10) {
            if (/^(\-|\+)?[0-9]+$/.test(text)) {
                return parseInt(text, radix);
            }
        }
        else if (radix == 16) {
            if (/^(\-|\+)?[0-9ABCDEFabcdef]+$/.test(text)) {
                return parseInt(text, radix);
            }
        }
        else {
            var result = parseInt(text, radix);
            if (!isNaN(result)) {
                return result;
            }
        }
        throw new NumberParseError("Invalid integer literal when parsing " + text + " in base " +
            radix);
    }
    // TODO: NaN is a valid literal but is returned by parseFloat to indicate an error.
    static parseFloat(text) { return parseFloat(text); }
    static get NaN() { return NaN; }
    static isNaN(value) { return isNaN(value); }
    static isInteger(value) { return Number.isInteger(value); }
}
export var RegExp = _global.RegExp;
export class RegExpWrapper {
    static create(regExpStr, flags = '') {
        flags = flags.replace(/g/g, '');
        return new _global.RegExp(regExpStr, flags + 'g');
    }
    static firstMatch(regExp, input) {
        // Reset multimatch regex state
        regExp.lastIndex = 0;
        return regExp.exec(input);
    }
    static test(regExp, input) {
        regExp.lastIndex = 0;
        return regExp.test(input);
    }
    static matcher(regExp, input) {
        // Reset regex state for the case
        // someone did not loop over all matches
        // last time.
        regExp.lastIndex = 0;
        return { re: regExp, input: input };
    }
    static replaceAll(regExp, input, replace) {
        let c = regExp.exec(input);
        let res = '';
        regExp.lastIndex = 0;
        let prev = 0;
        while (c) {
            res += input.substring(prev, c.index);
            res += replace(c);
            prev = c.index + c[0].length;
            regExp.lastIndex = prev;
            c = regExp.exec(input);
        }
        res += input.substring(prev);
        return res;
    }
}
export class RegExpMatcherWrapper {
    static next(matcher) {
        return matcher.re.exec(matcher.input);
    }
}
export class FunctionWrapper {
    static apply(fn, posArgs) { return fn.apply(null, posArgs); }
}
// JS has NaN !== NaN
export function looseIdentical(a, b) {
    return a === b || typeof a === "number" && typeof b === "number" && isNaN(a) && isNaN(b);
}
// JS considers NaN is the same as NaN for map Key (while NaN !== NaN otherwise)
// see https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Map
export function getMapKey(value) {
    return value;
}
export function normalizeBlank(obj) {
    return isBlank(obj) ? null : obj;
}
export function normalizeBool(obj) {
    return isBlank(obj) ? false : obj;
}
export function isJsObject(o) {
    return o !== null && (typeof o === "function" || typeof o === "object");
}
export function print(obj) {
    console.log(obj);
}
// Can't be all uppercase as our transpiler would think it is a special directive...
export class Json {
    static parse(s) { return _global.JSON.parse(s); }
    static stringify(data) {
        // Dart doesn't take 3 arguments
        return _global.JSON.stringify(data, null, 2);
    }
}
export class DateWrapper {
    static create(year, month = 1, day = 1, hour = 0, minutes = 0, seconds = 0, milliseconds = 0) {
        return new Date(year, month - 1, day, hour, minutes, seconds, milliseconds);
    }
    static fromISOString(str) { return new Date(str); }
    static fromMillis(ms) { return new Date(ms); }
    static toMillis(date) { return date.getTime(); }
    static now() { return new Date(); }
    static toJson(date) { return date.toJSON(); }
}
export function setValueOnPath(global, path, value) {
    var parts = path.split('.');
    var obj = global;
    while (parts.length > 1) {
        var name = parts.shift();
        if (obj.hasOwnProperty(name) && isPresent(obj[name])) {
            obj = obj[name];
        }
        else {
            obj = obj[name] = {};
        }
    }
    if (obj === undefined || obj === null) {
        obj = {};
    }
    obj[parts.shift()] = value;
}
var _symbolIterator = null;
export function getSymbolIterator() {
    if (isBlank(_symbolIterator)) {
        if (isPresent(Symbol) && isPresent(Symbol.iterator)) {
            _symbolIterator = Symbol.iterator;
        }
        else {
            // es6-shim specific logic
            var keys = Object.getOwnPropertyNames(Map.prototype);
            for (var i = 0; i < keys.length; ++i) {
                var key = keys[i];
                if (key !== 'entries' && key !== 'size' &&
                    Map.prototype[key] === Map.prototype['entries']) {
                    _symbolIterator = key;
                }
            }
        }
    }
    return _symbolIterator;
}
export function evalExpression(sourceUrl, expr, declarations, vars) {
    var fnBody = `${declarations}\nreturn ${expr}\n//# sourceURL=${sourceUrl}`;
    var fnArgNames = [];
    var fnArgValues = [];
    for (var argName in vars) {
        fnArgNames.push(argName);
        fnArgValues.push(vars[argName]);
    }
    return new Function(...fnArgNames.concat(fnBody))(...fnArgValues);
}
export function isPrimitive(obj) {
    return !isJsObject(obj);
}
export function hasConstructor(value, type) {
    return value.constructor === type;
}
export function bitWiseOr(values) {
    return values.reduce((a, b) => { return a | b; });
}
export function bitWiseAnd(values) {
    return values.reduce((a, b) => { return a & b; });
}
export function escape(s) {
    return _global.encodeURI(s);
}
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoibGFuZy5qcyIsInNvdXJjZVJvb3QiOiIiLCJzb3VyY2VzIjpbImRpZmZpbmdfcGx1Z2luX3dyYXBwZXItb3V0cHV0X3BhdGgtOUQxaUdRVkcudG1wL2FuZ3VsYXIyL3NyYy9mYWNhZGUvbGFuZy50cyJdLCJuYW1lcyI6W10sIm1hcHBpbmdzIjoiQUF3QkEsSUFBSSxXQUE4QixDQUFDO0FBQ25DLEVBQUUsQ0FBQyxDQUFDLE9BQU8sTUFBTSxLQUFLLFdBQVcsQ0FBQyxDQUFDLENBQUM7SUFDbEMsRUFBRSxDQUFDLENBQUMsT0FBTyxpQkFBaUIsS0FBSyxXQUFXLElBQUksSUFBSSxZQUFZLGlCQUFpQixDQUFDLENBQUMsQ0FBQztRQUNsRix5RUFBeUU7UUFDekUsV0FBVyxHQUFRLElBQUksQ0FBQztJQUMxQixDQUFDO0lBQUMsSUFBSSxDQUFDLENBQUM7UUFDTixXQUFXLEdBQVEsTUFBTSxDQUFDO0lBQzVCLENBQUM7QUFDSCxDQUFDO0FBQUMsSUFBSSxDQUFDLENBQUM7SUFDTixXQUFXLEdBQVEsTUFBTSxDQUFDO0FBQzVCLENBQUM7QUFFRCxrQ0FBa0MsRUFBWTtJQUM1QyxJQUFJLENBQUMsT0FBTyxDQUFDLGlCQUFpQixDQUFDLG1CQUFtQixFQUFFLEVBQUUsQ0FBQyxDQUFDO0FBQzFELENBQUM7QUFFRCxPQUFPLE1BQU0sT0FBTyxHQUFHLEtBQUssQ0FBQztBQUU3QixrRUFBa0U7QUFDbEUsNENBQTRDO0FBQzVDLElBQUksT0FBTyxHQUFzQixXQUFXLENBQUM7QUFFN0MsU0FBUSxPQUFPLElBQUksTUFBTSxHQUFFO0FBRTNCLE9BQU8sSUFBSSxJQUFJLEdBQUcsUUFBUSxDQUFDO0FBZTNCLHdDQUF3QyxJQUFVO0lBQ2hELEVBQUUsQ0FBQyxDQUFDLElBQUksQ0FBQyxNQUFNLENBQUMsQ0FBQyxDQUFDLENBQUM7UUFDakIsTUFBTSxDQUFDLElBQUksQ0FBQyxNQUFNLENBQUMsQ0FBQztJQUN0QixDQUFDO0lBQ0QsTUFBTSxDQUFDLE9BQU8sSUFBSSxDQUFDO0FBQ3JCLENBQUM7QUFHRCxPQUFPLElBQUksSUFBSSxHQUFHLE9BQU8sQ0FBQyxJQUFJLENBQUM7QUFDL0IsT0FBTyxJQUFJLElBQUksR0FBRyxPQUFPLENBQUMsSUFBSSxDQUFDO0FBRS9CLElBQUksUUFBUSxHQUFZLElBQUksQ0FBQztBQUM3QixJQUFJLFdBQVcsR0FBWSxLQUFLLENBQUM7QUFFakM7SUFDRSxXQUFXLEdBQUcsSUFBSSxDQUFDO0FBQ3JCLENBQUM7QUFFRDs7Ozs7OztHQU9HO0FBQ0g7SUFDRSxFQUFFLENBQUMsQ0FBQyxXQUFXLENBQUMsQ0FBQyxDQUFDO1FBQ2hCLHVFQUF1RTtRQUN2RSxNQUFNLCtDQUErQyxDQUFDO0lBQ3hELENBQUM7SUFDRCxRQUFRLEdBQUcsS0FBSyxDQUFDO0FBQ25CLENBQUM7QUFFRDtJQUNFLE1BQU0sQ0FBQyxRQUFRLENBQUM7QUFDbEIsQ0FBQztBQUVELHlEQUF5RDtBQUN6RCw0REFBNEQ7QUFDNUQsNENBQTRDO0FBQzVDLE9BQU8sQ0FBQyxNQUFNLEdBQUcsZ0JBQWdCLFNBQVM7SUFDeEMscURBQXFEO0FBQ3ZELENBQUMsQ0FBQztBQUVGLDRFQUE0RTtBQUM1RSxnRUFBZ0U7QUFDaEUsMkJBQThCLElBQU87SUFDbkMsTUFBTSxDQUFDLElBQUksQ0FBQztBQUNkLENBQUM7QUFFRDtJQUNFLE1BQU0sQ0FBQyxDQUFDLE1BQU0sS0FBSyxNQUFNLENBQUM7QUFDNUIsQ0FBQztBQUVELDBCQUEwQixHQUFRO0lBQ2hDLE1BQU0sQ0FBQyxHQUFHLEtBQUssU0FBUyxJQUFJLEdBQUcsS0FBSyxJQUFJLENBQUM7QUFDM0MsQ0FBQztBQUVELHdCQUF3QixHQUFRO0lBQzlCLE1BQU0sQ0FBQyxHQUFHLEtBQUssU0FBUyxJQUFJLEdBQUcsS0FBSyxJQUFJLENBQUM7QUFDM0MsQ0FBQztBQUVELDBCQUEwQixHQUFRO0lBQ2hDLE1BQU0sQ0FBQyxPQUFPLEdBQUcsS0FBSyxTQUFTLENBQUM7QUFDbEMsQ0FBQztBQUVELHlCQUF5QixHQUFRO0lBQy9CLE1BQU0sQ0FBQyxPQUFPLEdBQUcsS0FBSyxRQUFRLENBQUM7QUFDakMsQ0FBQztBQUVELHlCQUF5QixHQUFRO0lBQy9CLE1BQU0sQ0FBQyxPQUFPLEdBQUcsS0FBSyxRQUFRLENBQUM7QUFDakMsQ0FBQztBQUVELDJCQUEyQixHQUFRO0lBQ2pDLE1BQU0sQ0FBQyxPQUFPLEdBQUcsS0FBSyxVQUFVLENBQUM7QUFDbkMsQ0FBQztBQUVELHVCQUF1QixHQUFRO0lBQzdCLE1BQU0sQ0FBQyxVQUFVLENBQUMsR0FBRyxDQUFDLENBQUM7QUFDekIsQ0FBQztBQUVELDRCQUE0QixHQUFRO0lBQ2xDLE1BQU0sQ0FBQyxPQUFPLEdBQUcsS0FBSyxRQUFRLElBQUksR0FBRyxLQUFLLElBQUksQ0FBQztBQUNqRCxDQUFDO0FBRUQsMEJBQTBCLEdBQVE7SUFDaEMsTUFBTSxDQUFDLEdBQUcsWUFBa0IsT0FBUSxDQUFDLE9BQU8sQ0FBQztBQUMvQyxDQUFDO0FBRUQsd0JBQXdCLEdBQVE7SUFDOUIsTUFBTSxDQUFDLEtBQUssQ0FBQyxPQUFPLENBQUMsR0FBRyxDQUFDLENBQUM7QUFDNUIsQ0FBQztBQUVELHVCQUF1QixHQUFHO0lBQ3hCLE1BQU0sQ0FBQyxHQUFHLFlBQVksSUFBSSxJQUFJLENBQUMsS0FBSyxDQUFDLEdBQUcsQ0FBQyxPQUFPLEVBQUUsQ0FBQyxDQUFDO0FBQ3RELENBQUM7QUFFRCx5QkFBd0IsQ0FBQztBQUV6QiwwQkFBMEIsS0FBSztJQUM3QixFQUFFLENBQUMsQ0FBQyxPQUFPLEtBQUssS0FBSyxRQUFRLENBQUMsQ0FBQyxDQUFDO1FBQzlCLE1BQU0sQ0FBQyxLQUFLLENBQUM7SUFDZixDQUFDO0lBRUQsRUFBRSxDQUFDLENBQUMsS0FBSyxLQUFLLFNBQVMsSUFBSSxLQUFLLEtBQUssSUFBSSxDQUFDLENBQUMsQ0FBQztRQUMxQyxNQUFNLENBQUMsRUFBRSxHQUFHLEtBQUssQ0FBQztJQUNwQixDQUFDO0lBRUQsRUFBRSxDQUFDLENBQUMsS0FBSyxDQUFDLElBQUksQ0FBQyxDQUFDLENBQUM7UUFDZixNQUFNLENBQUMsS0FBSyxDQUFDLElBQUksQ0FBQztJQUNwQixDQUFDO0lBQ0QsRUFBRSxDQUFDLENBQUMsS0FBSyxDQUFDLGNBQWMsQ0FBQyxDQUFDLENBQUM7UUFDekIsTUFBTSxDQUFDLEtBQUssQ0FBQyxjQUFjLENBQUM7SUFDOUIsQ0FBQztJQUVELElBQUksR0FBRyxHQUFHLEtBQUssQ0FBQyxRQUFRLEVBQUUsQ0FBQztJQUMzQixJQUFJLFlBQVksR0FBRyxHQUFHLENBQUMsT0FBTyxDQUFDLElBQUksQ0FBQyxDQUFDO0lBQ3JDLE1BQU0sQ0FBQyxDQUFDLFlBQVksS0FBSyxDQUFDLENBQUMsQ0FBQyxHQUFHLEdBQUcsR0FBRyxHQUFHLENBQUMsU0FBUyxDQUFDLENBQUMsRUFBRSxZQUFZLENBQUMsQ0FBQztBQUN0RSxDQUFDO0FBRUQsd0VBQXdFO0FBQ3hFLGtEQUFrRDtBQUVsRCw4QkFBOEIsR0FBRztJQUMvQixNQUFNLENBQUMsR0FBRyxDQUFDO0FBQ2IsQ0FBQztBQUVELGdDQUFnQyxHQUFHLEVBQUUsTUFBd0I7SUFDM0QsTUFBTSxDQUFDLEdBQUcsQ0FBQztBQUNiLENBQUM7QUFFRCxpQ0FBaUMsU0FBUyxFQUFFLEdBQUc7SUFDN0MsTUFBTSxDQUFDLFNBQVMsQ0FBQyxHQUFHLENBQUMsQ0FBQztBQUN4QixDQUFDO0FBRUQ7SUFDRSxPQUFPLFlBQVksQ0FBQyxJQUFZLElBQVksTUFBTSxDQUFDLE1BQU0sQ0FBQyxZQUFZLENBQUMsSUFBSSxDQUFDLENBQUMsQ0FBQyxDQUFDO0lBRS9FLE9BQU8sVUFBVSxDQUFDLENBQVMsRUFBRSxLQUFhLElBQVksTUFBTSxDQUFDLENBQUMsQ0FBQyxVQUFVLENBQUMsS0FBSyxDQUFDLENBQUMsQ0FBQyxDQUFDO0lBRW5GLE9BQU8sS0FBSyxDQUFDLENBQVMsRUFBRSxNQUFjLElBQWMsTUFBTSxDQUFDLENBQUMsQ0FBQyxLQUFLLENBQUMsTUFBTSxDQUFDLENBQUMsQ0FBQyxDQUFDO0lBRTdFLE9BQU8sTUFBTSxDQUFDLENBQVMsRUFBRSxFQUFVLElBQWEsTUFBTSxDQUFDLENBQUMsS0FBSyxFQUFFLENBQUMsQ0FBQyxDQUFDO0lBRWxFLE9BQU8sU0FBUyxDQUFDLENBQVMsRUFBRSxPQUFlO1FBQ3pDLEVBQUUsQ0FBQyxDQUFDLENBQUMsSUFBSSxDQUFDLENBQUMsTUFBTSxDQUFDLENBQUMsQ0FBQztZQUNsQixJQUFJLEdBQUcsR0FBRyxDQUFDLENBQUM7WUFDWixHQUFHLENBQUMsQ0FBQyxJQUFJLENBQUMsR0FBRyxDQUFDLEVBQUUsQ0FBQyxHQUFHLENBQUMsQ0FBQyxNQUFNLEVBQUUsQ0FBQyxFQUFFLEVBQUUsQ0FBQztnQkFDbEMsRUFBRSxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxJQUFJLE9BQU8sQ0FBQztvQkFBQyxLQUFLLENBQUM7Z0JBQzNCLEdBQUcsRUFBRSxDQUFDO1lBQ1IsQ0FBQztZQUNELENBQUMsR0FBRyxDQUFDLENBQUMsU0FBUyxDQUFDLEdBQUcsQ0FBQyxDQUFDO1FBQ3ZCLENBQUM7UUFDRCxNQUFNLENBQUMsQ0FBQyxDQUFDO0lBQ1gsQ0FBQztJQUVELE9BQU8sVUFBVSxDQUFDLENBQVMsRUFBRSxPQUFlO1FBQzFDLEVBQUUsQ0FBQyxDQUFDLENBQUMsSUFBSSxDQUFDLENBQUMsTUFBTSxDQUFDLENBQUMsQ0FBQztZQUNsQixJQUFJLEdBQUcsR0FBRyxDQUFDLENBQUMsTUFBTSxDQUFDO1lBQ25CLEdBQUcsQ0FBQyxDQUFDLElBQUksQ0FBQyxHQUFHLENBQUMsQ0FBQyxNQUFNLEdBQUcsQ0FBQyxFQUFFLENBQUMsSUFBSSxDQUFDLEVBQUUsQ0FBQyxFQUFFLEVBQUUsQ0FBQztnQkFDdkMsRUFBRSxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxJQUFJLE9BQU8sQ0FBQztvQkFBQyxLQUFLLENBQUM7Z0JBQzNCLEdBQUcsRUFBRSxDQUFDO1lBQ1IsQ0FBQztZQUNELENBQUMsR0FBRyxDQUFDLENBQUMsU0FBUyxDQUFDLENBQUMsRUFBRSxHQUFHLENBQUMsQ0FBQztRQUMxQixDQUFDO1FBQ0QsTUFBTSxDQUFDLENBQUMsQ0FBQztJQUNYLENBQUM7SUFFRCxPQUFPLE9BQU8sQ0FBQyxDQUFTLEVBQUUsSUFBWSxFQUFFLE9BQWU7UUFDckQsTUFBTSxDQUFDLENBQUMsQ0FBQyxPQUFPLENBQUMsSUFBSSxFQUFFLE9BQU8sQ0FBQyxDQUFDO0lBQ2xDLENBQUM7SUFFRCxPQUFPLFVBQVUsQ0FBQyxDQUFTLEVBQUUsSUFBWSxFQUFFLE9BQWU7UUFDeEQsTUFBTSxDQUFDLENBQUMsQ0FBQyxPQUFPLENBQUMsSUFBSSxFQUFFLE9BQU8sQ0FBQyxDQUFDO0lBQ2xDLENBQUM7SUFFRCxPQUFPLEtBQUssQ0FBSSxDQUFTLEVBQUUsSUFBSSxHQUFXLENBQUMsRUFBRSxFQUFFLEdBQVcsSUFBSTtRQUM1RCxNQUFNLENBQUMsQ0FBQyxDQUFDLEtBQUssQ0FBQyxJQUFJLEVBQUUsRUFBRSxLQUFLLElBQUksR0FBRyxTQUFTLEdBQUcsRUFBRSxDQUFDLENBQUM7SUFDckQsQ0FBQztJQUVELE9BQU8sZ0JBQWdCLENBQUMsQ0FBUyxFQUFFLElBQVksRUFBRSxFQUFZO1FBQzNELE1BQU0sQ0FBQyxDQUFDLENBQUMsT0FBTyxDQUFDLElBQUksRUFBRSxVQUFTLEdBQUcsT0FBTztZQUN4QywrQ0FBK0M7WUFDL0MsT0FBTyxDQUFDLE1BQU0sQ0FBQyxDQUFDLENBQUMsRUFBRSxDQUFDLENBQUMsQ0FBQztZQUN0QiwyQ0FBMkM7WUFDM0MsTUFBTSxDQUFDLEVBQUUsQ0FBQyxPQUFPLENBQUMsQ0FBQztRQUNyQixDQUFDLENBQUMsQ0FBQztJQUNMLENBQUM7SUFFRCxPQUFPLFFBQVEsQ0FBQyxDQUFTLEVBQUUsTUFBYyxJQUFhLE1BQU0sQ0FBQyxDQUFDLENBQUMsT0FBTyxDQUFDLE1BQU0sQ0FBQyxJQUFJLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQztJQUV2RixPQUFPLE9BQU8sQ0FBQyxDQUFTLEVBQUUsQ0FBUztRQUNqQyxFQUFFLENBQUMsQ0FBQyxDQUFDLEdBQUcsQ0FBQyxDQUFDLENBQUMsQ0FBQztZQUNWLE1BQU0sQ0FBQyxDQUFDLENBQUMsQ0FBQztRQUNaLENBQUM7UUFBQyxJQUFJLENBQUMsRUFBRSxDQUFDLENBQUMsQ0FBQyxHQUFHLENBQUMsQ0FBQyxDQUFDLENBQUM7WUFDakIsTUFBTSxDQUFDLENBQUMsQ0FBQztRQUNYLENBQUM7UUFBQyxJQUFJLENBQUMsQ0FBQztZQUNOLE1BQU0sQ0FBQyxDQUFDLENBQUM7UUFDWCxDQUFDO0lBQ0gsQ0FBQztBQUNILENBQUM7QUFFRDtJQUNFLFlBQW1CLEtBQUssR0FBRyxFQUFFO1FBQVYsVUFBSyxHQUFMLEtBQUssQ0FBSztJQUFHLENBQUM7SUFFakMsR0FBRyxDQUFDLElBQVksSUFBVSxJQUFJLENBQUMsS0FBSyxDQUFDLElBQUksQ0FBQyxJQUFJLENBQUMsQ0FBQyxDQUFDLENBQUM7SUFFbEQsUUFBUSxLQUFhLE1BQU0sQ0FBQyxJQUFJLENBQUMsS0FBSyxDQUFDLElBQUksQ0FBQyxFQUFFLENBQUMsQ0FBQyxDQUFDLENBQUM7QUFDcEQsQ0FBQztBQUVELHNDQUFzQyxLQUFLO0lBR3pDLFlBQW1CLE9BQWU7UUFBSSxPQUFPLENBQUM7UUFBM0IsWUFBTyxHQUFQLE9BQU8sQ0FBUTtJQUFhLENBQUM7SUFFaEQsUUFBUSxLQUFhLE1BQU0sQ0FBQyxJQUFJLENBQUMsT0FBTyxDQUFDLENBQUMsQ0FBQztBQUM3QyxDQUFDO0FBR0Q7SUFDRSxPQUFPLE9BQU8sQ0FBQyxDQUFTLEVBQUUsY0FBc0IsSUFBWSxNQUFNLENBQUMsQ0FBQyxDQUFDLE9BQU8sQ0FBQyxjQUFjLENBQUMsQ0FBQyxDQUFDLENBQUM7SUFFL0YsT0FBTyxLQUFLLENBQUMsQ0FBUyxFQUFFLENBQVMsSUFBYSxNQUFNLENBQUMsQ0FBQyxLQUFLLENBQUMsQ0FBQyxDQUFDLENBQUM7SUFFL0QsT0FBTyxpQkFBaUIsQ0FBQyxJQUFZO1FBQ25DLElBQUksTUFBTSxHQUFXLFFBQVEsQ0FBQyxJQUFJLENBQUMsQ0FBQztRQUNwQyxFQUFFLENBQUMsQ0FBQyxLQUFLLENBQUMsTUFBTSxDQUFDLENBQUMsQ0FBQyxDQUFDO1lBQ2xCLE1BQU0sSUFBSSxnQkFBZ0IsQ0FBQyx1Q0FBdUMsR0FBRyxJQUFJLENBQUMsQ0FBQztRQUM3RSxDQUFDO1FBQ0QsTUFBTSxDQUFDLE1BQU0sQ0FBQztJQUNoQixDQUFDO0lBRUQsT0FBTyxRQUFRLENBQUMsSUFBWSxFQUFFLEtBQWE7UUFDekMsRUFBRSxDQUFDLENBQUMsS0FBSyxJQUFJLEVBQUUsQ0FBQyxDQUFDLENBQUM7WUFDaEIsRUFBRSxDQUFDLENBQUMsa0JBQWtCLENBQUMsSUFBSSxDQUFDLElBQUksQ0FBQyxDQUFDLENBQUMsQ0FBQztnQkFDbEMsTUFBTSxDQUFDLFFBQVEsQ0FBQyxJQUFJLEVBQUUsS0FBSyxDQUFDLENBQUM7WUFDL0IsQ0FBQztRQUNILENBQUM7UUFBQyxJQUFJLENBQUMsRUFBRSxDQUFDLENBQUMsS0FBSyxJQUFJLEVBQUUsQ0FBQyxDQUFDLENBQUM7WUFDdkIsRUFBRSxDQUFDLENBQUMsOEJBQThCLENBQUMsSUFBSSxDQUFDLElBQUksQ0FBQyxDQUFDLENBQUMsQ0FBQztnQkFDOUMsTUFBTSxDQUFDLFFBQVEsQ0FBQyxJQUFJLEVBQUUsS0FBSyxDQUFDLENBQUM7WUFDL0IsQ0FBQztRQUNILENBQUM7UUFBQyxJQUFJLENBQUMsQ0FBQztZQUNOLElBQUksTUFBTSxHQUFXLFFBQVEsQ0FBQyxJQUFJLEVBQUUsS0FBSyxDQUFDLENBQUM7WUFDM0MsRUFBRSxDQUFDLENBQUMsQ0FBQyxLQUFLLENBQUMsTUFBTSxDQUFDLENBQUMsQ0FBQyxDQUFDO2dCQUNuQixNQUFNLENBQUMsTUFBTSxDQUFDO1lBQ2hCLENBQUM7UUFDSCxDQUFDO1FBQ0QsTUFBTSxJQUFJLGdCQUFnQixDQUFDLHVDQUF1QyxHQUFHLElBQUksR0FBRyxXQUFXO1lBQzVELEtBQUssQ0FBQyxDQUFDO0lBQ3BDLENBQUM7SUFFRCxtRkFBbUY7SUFDbkYsT0FBTyxVQUFVLENBQUMsSUFBWSxJQUFZLE1BQU0sQ0FBQyxVQUFVLENBQUMsSUFBSSxDQUFDLENBQUMsQ0FBQyxDQUFDO0lBRXBFLFdBQVcsR0FBRyxLQUFhLE1BQU0sQ0FBQyxHQUFHLENBQUMsQ0FBQyxDQUFDO0lBRXhDLE9BQU8sS0FBSyxDQUFDLEtBQVUsSUFBYSxNQUFNLENBQUMsS0FBSyxDQUFDLEtBQUssQ0FBQyxDQUFDLENBQUMsQ0FBQztJQUUxRCxPQUFPLFNBQVMsQ0FBQyxLQUFVLElBQWEsTUFBTSxDQUFDLE1BQU0sQ0FBQyxTQUFTLENBQUMsS0FBSyxDQUFDLENBQUMsQ0FBQyxDQUFDO0FBQzNFLENBQUM7QUFFRCxPQUFPLElBQUksTUFBTSxHQUFHLE9BQU8sQ0FBQyxNQUFNLENBQUM7QUFFbkM7SUFDRSxPQUFPLE1BQU0sQ0FBQyxTQUFpQixFQUFFLEtBQUssR0FBVyxFQUFFO1FBQ2pELEtBQUssR0FBRyxLQUFLLENBQUMsT0FBTyxDQUFDLElBQUksRUFBRSxFQUFFLENBQUMsQ0FBQztRQUNoQyxNQUFNLENBQUMsSUFBSSxPQUFPLENBQUMsTUFBTSxDQUFDLFNBQVMsRUFBRSxLQUFLLEdBQUcsR0FBRyxDQUFDLENBQUM7SUFDcEQsQ0FBQztJQUNELE9BQU8sVUFBVSxDQUFDLE1BQWMsRUFBRSxLQUFhO1FBQzdDLCtCQUErQjtRQUMvQixNQUFNLENBQUMsU0FBUyxHQUFHLENBQUMsQ0FBQztRQUNyQixNQUFNLENBQUMsTUFBTSxDQUFDLElBQUksQ0FBQyxLQUFLLENBQUMsQ0FBQztJQUM1QixDQUFDO0lBQ0QsT0FBTyxJQUFJLENBQUMsTUFBYyxFQUFFLEtBQWE7UUFDdkMsTUFBTSxDQUFDLFNBQVMsR0FBRyxDQUFDLENBQUM7UUFDckIsTUFBTSxDQUFDLE1BQU0sQ0FBQyxJQUFJLENBQUMsS0FBSyxDQUFDLENBQUM7SUFDNUIsQ0FBQztJQUNELE9BQU8sT0FBTyxDQUFDLE1BQWMsRUFBRSxLQUFhO1FBSzFDLGlDQUFpQztRQUNqQyx3Q0FBd0M7UUFDeEMsYUFBYTtRQUNiLE1BQU0sQ0FBQyxTQUFTLEdBQUcsQ0FBQyxDQUFDO1FBQ3JCLE1BQU0sQ0FBQyxFQUFDLEVBQUUsRUFBRSxNQUFNLEVBQUUsS0FBSyxFQUFFLEtBQUssRUFBQyxDQUFDO0lBQ3BDLENBQUM7SUFDRCxPQUFPLFVBQVUsQ0FBQyxNQUFjLEVBQUUsS0FBYSxFQUFFLE9BQWlCO1FBQ2hFLElBQUksQ0FBQyxHQUFHLE1BQU0sQ0FBQyxJQUFJLENBQUMsS0FBSyxDQUFDLENBQUM7UUFDM0IsSUFBSSxHQUFHLEdBQUcsRUFBRSxDQUFDO1FBQ2IsTUFBTSxDQUFDLFNBQVMsR0FBRyxDQUFDLENBQUM7UUFDckIsSUFBSSxJQUFJLEdBQUcsQ0FBQyxDQUFDO1FBQ2IsT0FBTyxDQUFDLEVBQUUsQ0FBQztZQUNULEdBQUcsSUFBSSxLQUFLLENBQUMsU0FBUyxDQUFDLElBQUksRUFBRSxDQUFDLENBQUMsS0FBSyxDQUFDLENBQUM7WUFDdEMsR0FBRyxJQUFJLE9BQU8sQ0FBQyxDQUFDLENBQUMsQ0FBQztZQUNsQixJQUFJLEdBQUcsQ0FBQyxDQUFDLEtBQUssR0FBRyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsTUFBTSxDQUFDO1lBQzdCLE1BQU0sQ0FBQyxTQUFTLEdBQUcsSUFBSSxDQUFDO1lBQ3hCLENBQUMsR0FBRyxNQUFNLENBQUMsSUFBSSxDQUFDLEtBQUssQ0FBQyxDQUFDO1FBQ3pCLENBQUM7UUFDRCxHQUFHLElBQUksS0FBSyxDQUFDLFNBQVMsQ0FBQyxJQUFJLENBQUMsQ0FBQztRQUM3QixNQUFNLENBQUMsR0FBRyxDQUFDO0lBQ2IsQ0FBQztBQUNILENBQUM7QUFFRDtJQUNFLE9BQU8sSUFBSSxDQUFDLE9BR1g7UUFDQyxNQUFNLENBQUMsT0FBTyxDQUFDLEVBQUUsQ0FBQyxJQUFJLENBQUMsT0FBTyxDQUFDLEtBQUssQ0FBQyxDQUFDO0lBQ3hDLENBQUM7QUFDSCxDQUFDO0FBRUQ7SUFDRSxPQUFPLEtBQUssQ0FBQyxFQUFZLEVBQUUsT0FBWSxJQUFTLE1BQU0sQ0FBQyxFQUFFLENBQUMsS0FBSyxDQUFDLElBQUksRUFBRSxPQUFPLENBQUMsQ0FBQyxDQUFDLENBQUM7QUFDbkYsQ0FBQztBQUVELHFCQUFxQjtBQUNyQiwrQkFBK0IsQ0FBQyxFQUFFLENBQUM7SUFDakMsTUFBTSxDQUFDLENBQUMsS0FBSyxDQUFDLElBQUksT0FBTyxDQUFDLEtBQUssUUFBUSxJQUFJLE9BQU8sQ0FBQyxLQUFLLFFBQVEsSUFBSSxLQUFLLENBQUMsQ0FBQyxDQUFDLElBQUksS0FBSyxDQUFDLENBQUMsQ0FBQyxDQUFDO0FBQzNGLENBQUM7QUFFRCxnRkFBZ0Y7QUFDaEYsMkZBQTJGO0FBQzNGLDBCQUE2QixLQUFRO0lBQ25DLE1BQU0sQ0FBQyxLQUFLLENBQUM7QUFDZixDQUFDO0FBRUQsK0JBQStCLEdBQVc7SUFDeEMsTUFBTSxDQUFDLE9BQU8sQ0FBQyxHQUFHLENBQUMsR0FBRyxJQUFJLEdBQUcsR0FBRyxDQUFDO0FBQ25DLENBQUM7QUFFRCw4QkFBOEIsR0FBWTtJQUN4QyxNQUFNLENBQUMsT0FBTyxDQUFDLEdBQUcsQ0FBQyxHQUFHLEtBQUssR0FBRyxHQUFHLENBQUM7QUFDcEMsQ0FBQztBQUVELDJCQUEyQixDQUFNO0lBQy9CLE1BQU0sQ0FBQyxDQUFDLEtBQUssSUFBSSxJQUFJLENBQUMsT0FBTyxDQUFDLEtBQUssVUFBVSxJQUFJLE9BQU8sQ0FBQyxLQUFLLFFBQVEsQ0FBQyxDQUFDO0FBQzFFLENBQUM7QUFFRCxzQkFBc0IsR0FBbUI7SUFDdkMsT0FBTyxDQUFDLEdBQUcsQ0FBQyxHQUFHLENBQUMsQ0FBQztBQUNuQixDQUFDO0FBRUQsb0ZBQW9GO0FBQ3BGO0lBQ0UsT0FBTyxLQUFLLENBQUMsQ0FBUyxJQUFZLE1BQU0sQ0FBQyxPQUFPLENBQUMsSUFBSSxDQUFDLEtBQUssQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUM7SUFDakUsT0FBTyxTQUFTLENBQUMsSUFBWTtRQUMzQixnQ0FBZ0M7UUFDaEMsTUFBTSxDQUFDLE9BQU8sQ0FBQyxJQUFJLENBQUMsU0FBUyxDQUFDLElBQUksRUFBRSxJQUFJLEVBQUUsQ0FBQyxDQUFDLENBQUM7SUFDL0MsQ0FBQztBQUNILENBQUM7QUFFRDtJQUNFLE9BQU8sTUFBTSxDQUFDLElBQVksRUFBRSxLQUFLLEdBQVcsQ0FBQyxFQUFFLEdBQUcsR0FBVyxDQUFDLEVBQUUsSUFBSSxHQUFXLENBQUMsRUFDbEUsT0FBTyxHQUFXLENBQUMsRUFBRSxPQUFPLEdBQVcsQ0FBQyxFQUFFLFlBQVksR0FBVyxDQUFDO1FBQzlFLE1BQU0sQ0FBQyxJQUFJLElBQUksQ0FBQyxJQUFJLEVBQUUsS0FBSyxHQUFHLENBQUMsRUFBRSxHQUFHLEVBQUUsSUFBSSxFQUFFLE9BQU8sRUFBRSxPQUFPLEVBQUUsWUFBWSxDQUFDLENBQUM7SUFDOUUsQ0FBQztJQUNELE9BQU8sYUFBYSxDQUFDLEdBQVcsSUFBVSxNQUFNLENBQUMsSUFBSSxJQUFJLENBQUMsR0FBRyxDQUFDLENBQUMsQ0FBQyxDQUFDO0lBQ2pFLE9BQU8sVUFBVSxDQUFDLEVBQVUsSUFBVSxNQUFNLENBQUMsSUFBSSxJQUFJLENBQUMsRUFBRSxDQUFDLENBQUMsQ0FBQyxDQUFDO0lBQzVELE9BQU8sUUFBUSxDQUFDLElBQVUsSUFBWSxNQUFNLENBQUMsSUFBSSxDQUFDLE9BQU8sRUFBRSxDQUFDLENBQUMsQ0FBQztJQUM5RCxPQUFPLEdBQUcsS0FBVyxNQUFNLENBQUMsSUFBSSxJQUFJLEVBQUUsQ0FBQyxDQUFDLENBQUM7SUFDekMsT0FBTyxNQUFNLENBQUMsSUFBVSxJQUFZLE1BQU0sQ0FBQyxJQUFJLENBQUMsTUFBTSxFQUFFLENBQUMsQ0FBQyxDQUFDO0FBQzdELENBQUM7QUFFRCwrQkFBK0IsTUFBVyxFQUFFLElBQVksRUFBRSxLQUFVO0lBQ2xFLElBQUksS0FBSyxHQUFHLElBQUksQ0FBQyxLQUFLLENBQUMsR0FBRyxDQUFDLENBQUM7SUFDNUIsSUFBSSxHQUFHLEdBQVEsTUFBTSxDQUFDO0lBQ3RCLE9BQU8sS0FBSyxDQUFDLE1BQU0sR0FBRyxDQUFDLEVBQUUsQ0FBQztRQUN4QixJQUFJLElBQUksR0FBRyxLQUFLLENBQUMsS0FBSyxFQUFFLENBQUM7UUFDekIsRUFBRSxDQUFDLENBQUMsR0FBRyxDQUFDLGNBQWMsQ0FBQyxJQUFJLENBQUMsSUFBSSxTQUFTLENBQUMsR0FBRyxDQUFDLElBQUksQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDO1lBQ3JELEdBQUcsR0FBRyxHQUFHLENBQUMsSUFBSSxDQUFDLENBQUM7UUFDbEIsQ0FBQztRQUFDLElBQUksQ0FBQyxDQUFDO1lBQ04sR0FBRyxHQUFHLEdBQUcsQ0FBQyxJQUFJLENBQUMsR0FBRyxFQUFFLENBQUM7UUFDdkIsQ0FBQztJQUNILENBQUM7SUFDRCxFQUFFLENBQUMsQ0FBQyxHQUFHLEtBQUssU0FBUyxJQUFJLEdBQUcsS0FBSyxJQUFJLENBQUMsQ0FBQyxDQUFDO1FBQ3RDLEdBQUcsR0FBRyxFQUFFLENBQUM7SUFDWCxDQUFDO0lBQ0QsR0FBRyxDQUFDLEtBQUssQ0FBQyxLQUFLLEVBQUUsQ0FBQyxHQUFHLEtBQUssQ0FBQztBQUM3QixDQUFDO0FBSUQsSUFBSSxlQUFlLEdBQUcsSUFBSSxDQUFDO0FBQzNCO0lBQ0UsRUFBRSxDQUFDLENBQUMsT0FBTyxDQUFDLGVBQWUsQ0FBQyxDQUFDLENBQUMsQ0FBQztRQUM3QixFQUFFLENBQUMsQ0FBQyxTQUFTLENBQUMsTUFBTSxDQUFDLElBQUksU0FBUyxDQUFDLE1BQU0sQ0FBQyxRQUFRLENBQUMsQ0FBQyxDQUFDLENBQUM7WUFDcEQsZUFBZSxHQUFHLE1BQU0sQ0FBQyxRQUFRLENBQUM7UUFDcEMsQ0FBQztRQUFDLElBQUksQ0FBQyxDQUFDO1lBQ04sMEJBQTBCO1lBQzFCLElBQUksSUFBSSxHQUFHLE1BQU0sQ0FBQyxtQkFBbUIsQ0FBQyxHQUFHLENBQUMsU0FBUyxDQUFDLENBQUM7WUFDckQsR0FBRyxDQUFDLENBQUMsSUFBSSxDQUFDLEdBQUcsQ0FBQyxFQUFFLENBQUMsR0FBRyxJQUFJLENBQUMsTUFBTSxFQUFFLEVBQUUsQ0FBQyxFQUFFLENBQUM7Z0JBQ3JDLElBQUksR0FBRyxHQUFHLElBQUksQ0FBQyxDQUFDLENBQUMsQ0FBQztnQkFDbEIsRUFBRSxDQUFDLENBQUMsR0FBRyxLQUFLLFNBQVMsSUFBSSxHQUFHLEtBQUssTUFBTTtvQkFDbkMsR0FBRyxDQUFDLFNBQVMsQ0FBQyxHQUFHLENBQUMsS0FBSyxHQUFHLENBQUMsU0FBUyxDQUFDLFNBQVMsQ0FBQyxDQUFDLENBQUMsQ0FBQztvQkFDcEQsZUFBZSxHQUFHLEdBQUcsQ0FBQztnQkFDeEIsQ0FBQztZQUNILENBQUM7UUFDSCxDQUFDO0lBQ0gsQ0FBQztJQUNELE1BQU0sQ0FBQyxlQUFlLENBQUM7QUFDekIsQ0FBQztBQUVELCtCQUErQixTQUFpQixFQUFFLElBQVksRUFBRSxZQUFvQixFQUNyRCxJQUEwQjtJQUN2RCxJQUFJLE1BQU0sR0FBRyxHQUFHLFlBQVksWUFBWSxJQUFJLG1CQUFtQixTQUFTLEVBQUUsQ0FBQztJQUMzRSxJQUFJLFVBQVUsR0FBRyxFQUFFLENBQUM7SUFDcEIsSUFBSSxXQUFXLEdBQUcsRUFBRSxDQUFDO0lBQ3JCLEdBQUcsQ0FBQyxDQUFDLElBQUksT0FBTyxJQUFJLElBQUksQ0FBQyxDQUFDLENBQUM7UUFDekIsVUFBVSxDQUFDLElBQUksQ0FBQyxPQUFPLENBQUMsQ0FBQztRQUN6QixXQUFXLENBQUMsSUFBSSxDQUFDLElBQUksQ0FBQyxPQUFPLENBQUMsQ0FBQyxDQUFDO0lBQ2xDLENBQUM7SUFDRCxNQUFNLENBQUMsSUFBSSxRQUFRLENBQUMsR0FBRyxVQUFVLENBQUMsTUFBTSxDQUFDLE1BQU0sQ0FBQyxDQUFDLENBQUMsR0FBRyxXQUFXLENBQUMsQ0FBQztBQUNwRSxDQUFDO0FBRUQsNEJBQTRCLEdBQVE7SUFDbEMsTUFBTSxDQUFDLENBQUMsVUFBVSxDQUFDLEdBQUcsQ0FBQyxDQUFDO0FBQzFCLENBQUM7QUFFRCwrQkFBK0IsS0FBYSxFQUFFLElBQVU7SUFDdEQsTUFBTSxDQUFDLEtBQUssQ0FBQyxXQUFXLEtBQUssSUFBSSxDQUFDO0FBQ3BDLENBQUM7QUFFRCwwQkFBMEIsTUFBZ0I7SUFDeEMsTUFBTSxDQUFDLE1BQU0sQ0FBQyxNQUFNLENBQUMsQ0FBQyxDQUFDLEVBQUUsQ0FBQyxPQUFPLE1BQU0sQ0FBQyxDQUFDLEdBQUcsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUM7QUFDcEQsQ0FBQztBQUVELDJCQUEyQixNQUFnQjtJQUN6QyxNQUFNLENBQUMsTUFBTSxDQUFDLE1BQU0sQ0FBQyxDQUFDLENBQUMsRUFBRSxDQUFDLE9BQU8sTUFBTSxDQUFDLENBQUMsR0FBRyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQztBQUNwRCxDQUFDO0FBRUQsdUJBQXVCLENBQVM7SUFDOUIsTUFBTSxDQUFDLE9BQU8sQ0FBQyxTQUFTLENBQUMsQ0FBQyxDQUFDLENBQUM7QUFDOUIsQ0FBQyIsInNvdXJjZXNDb250ZW50IjpbImV4cG9ydCBpbnRlcmZhY2UgQnJvd3Nlck5vZGVHbG9iYWwge1xuICBPYmplY3Q6IHR5cGVvZiBPYmplY3Q7XG4gIEFycmF5OiB0eXBlb2YgQXJyYXk7XG4gIE1hcDogdHlwZW9mIE1hcDtcbiAgU2V0OiB0eXBlb2YgU2V0O1xuICBEYXRlOiBEYXRlQ29uc3RydWN0b3I7XG4gIFJlZ0V4cDogUmVnRXhwQ29uc3RydWN0b3I7XG4gIEpTT046IHR5cGVvZiBKU09OO1xuICBNYXRoOiBhbnk7ICAvLyB0eXBlb2YgTWF0aDtcbiAgYXNzZXJ0KGNvbmRpdGlvbjogYW55KTogdm9pZDtcbiAgUmVmbGVjdDogYW55O1xuICBnZXRBbmd1bGFyVGVzdGFiaWxpdHk6IEZ1bmN0aW9uO1xuICBnZXRBbGxBbmd1bGFyVGVzdGFiaWxpdGllczogRnVuY3Rpb247XG4gIGdldEFsbEFuZ3VsYXJSb290RWxlbWVudHM6IEZ1bmN0aW9uO1xuICBmcmFtZXdvcmtTdGFiaWxpemVyczogQXJyYXk8RnVuY3Rpb24+O1xuICBzZXRUaW1lb3V0OiBGdW5jdGlvbjtcbiAgY2xlYXJUaW1lb3V0OiBGdW5jdGlvbjtcbiAgc2V0SW50ZXJ2YWw6IEZ1bmN0aW9uO1xuICBjbGVhckludGVydmFsOiBGdW5jdGlvbjtcbiAgZW5jb2RlVVJJOiBGdW5jdGlvbjtcbn1cblxuLy8gVE9ETyhqdGVwbGl0ejYwMik6IExvYWQgV29ya2VyR2xvYmFsU2NvcGUgZnJvbSBsaWIud2Vid29ya2VyLmQudHMgZmlsZSAjMzQ5MlxuZGVjbGFyZSB2YXIgV29ya2VyR2xvYmFsU2NvcGU7XG52YXIgZ2xvYmFsU2NvcGU6IEJyb3dzZXJOb2RlR2xvYmFsO1xuaWYgKHR5cGVvZiB3aW5kb3cgPT09ICd1bmRlZmluZWQnKSB7XG4gIGlmICh0eXBlb2YgV29ya2VyR2xvYmFsU2NvcGUgIT09ICd1bmRlZmluZWQnICYmIHNlbGYgaW5zdGFuY2VvZiBXb3JrZXJHbG9iYWxTY29wZSkge1xuICAgIC8vIFRPRE86IFJlcGxhY2UgYW55IHdpdGggV29ya2VyR2xvYmFsU2NvcGUgZnJvbSBsaWIud2Vid29ya2VyLmQudHMgIzM0OTJcbiAgICBnbG9iYWxTY29wZSA9IDxhbnk+c2VsZjtcbiAgfSBlbHNlIHtcbiAgICBnbG9iYWxTY29wZSA9IDxhbnk+Z2xvYmFsO1xuICB9XG59IGVsc2Uge1xuICBnbG9iYWxTY29wZSA9IDxhbnk+d2luZG93O1xufVxuXG5leHBvcnQgZnVuY3Rpb24gc2NoZWR1bGVNaWNyb1Rhc2soZm46IEZ1bmN0aW9uKSB7XG4gIFpvbmUuY3VycmVudC5zY2hlZHVsZU1pY3JvVGFzaygnc2NoZWR1bGVNaWNyb3Rhc2snLCBmbik7XG59XG5cbmV4cG9ydCBjb25zdCBJU19EQVJUID0gZmFsc2U7XG5cbi8vIE5lZWQgdG8gZGVjbGFyZSBhIG5ldyB2YXJpYWJsZSBmb3IgZ2xvYmFsIGhlcmUgc2luY2UgVHlwZVNjcmlwdFxuLy8gZXhwb3J0cyB0aGUgb3JpZ2luYWwgdmFsdWUgb2YgdGhlIHN5bWJvbC5cbnZhciBfZ2xvYmFsOiBCcm93c2VyTm9kZUdsb2JhbCA9IGdsb2JhbFNjb3BlO1xuXG5leHBvcnQge19nbG9iYWwgYXMgZ2xvYmFsfTtcblxuZXhwb3J0IHZhciBUeXBlID0gRnVuY3Rpb247XG5cbi8qKlxuICogUnVudGltZSByZXByZXNlbnRhdGlvbiBhIHR5cGUgdGhhdCBhIENvbXBvbmVudCBvciBvdGhlciBvYmplY3QgaXMgaW5zdGFuY2VzIG9mLlxuICpcbiAqIEFuIGV4YW1wbGUgb2YgYSBgVHlwZWAgaXMgYE15Q3VzdG9tQ29tcG9uZW50YCBjbGFzcywgd2hpY2ggaW4gSmF2YVNjcmlwdCBpcyBiZSByZXByZXNlbnRlZCBieVxuICogdGhlIGBNeUN1c3RvbUNvbXBvbmVudGAgY29uc3RydWN0b3IgZnVuY3Rpb24uXG4gKi9cbmV4cG9ydCBpbnRlcmZhY2UgVHlwZSBleHRlbmRzIEZ1bmN0aW9uIHt9XG5cbi8qKlxuICogUnVudGltZSByZXByZXNlbnRhdGlvbiBvZiBhIHR5cGUgdGhhdCBpcyBjb25zdHJ1Y3RhYmxlIChub24tYWJzdHJhY3QpLlxuICovXG5leHBvcnQgaW50ZXJmYWNlIENvbmNyZXRlVHlwZSBleHRlbmRzIFR5cGUgeyBuZXcgKC4uLmFyZ3MpOiBhbnk7IH1cblxuZXhwb3J0IGZ1bmN0aW9uIGdldFR5cGVOYW1lRm9yRGVidWdnaW5nKHR5cGU6IFR5cGUpOiBzdHJpbmcge1xuICBpZiAodHlwZVsnbmFtZSddKSB7XG4gICAgcmV0dXJuIHR5cGVbJ25hbWUnXTtcbiAgfVxuICByZXR1cm4gdHlwZW9mIHR5cGU7XG59XG5cblxuZXhwb3J0IHZhciBNYXRoID0gX2dsb2JhbC5NYXRoO1xuZXhwb3J0IHZhciBEYXRlID0gX2dsb2JhbC5EYXRlO1xuXG52YXIgX2Rldk1vZGU6IGJvb2xlYW4gPSB0cnVlO1xudmFyIF9tb2RlTG9ja2VkOiBib29sZWFuID0gZmFsc2U7XG5cbmV4cG9ydCBmdW5jdGlvbiBsb2NrTW9kZSgpIHtcbiAgX21vZGVMb2NrZWQgPSB0cnVlO1xufVxuXG4vKipcbiAqIERpc2FibGUgQW5ndWxhcidzIGRldmVsb3BtZW50IG1vZGUsIHdoaWNoIHR1cm5zIG9mZiBhc3NlcnRpb25zIGFuZCBvdGhlclxuICogY2hlY2tzIHdpdGhpbiB0aGUgZnJhbWV3b3JrLlxuICpcbiAqIE9uZSBpbXBvcnRhbnQgYXNzZXJ0aW9uIHRoaXMgZGlzYWJsZXMgdmVyaWZpZXMgdGhhdCBhIGNoYW5nZSBkZXRlY3Rpb24gcGFzc1xuICogZG9lcyBub3QgcmVzdWx0IGluIGFkZGl0aW9uYWwgY2hhbmdlcyB0byBhbnkgYmluZGluZ3MgKGFsc28ga25vd24gYXNcbiAqIHVuaWRpcmVjdGlvbmFsIGRhdGEgZmxvdykuXG4gKi9cbmV4cG9ydCBmdW5jdGlvbiBlbmFibGVQcm9kTW9kZSgpIHtcbiAgaWYgKF9tb2RlTG9ja2VkKSB7XG4gICAgLy8gQ2Fubm90IHVzZSBCYXNlRXhjZXB0aW9uIGFzIHRoYXQgZW5kcyB1cCBpbXBvcnRpbmcgZnJvbSBmYWNhZGUvbGFuZy5cbiAgICB0aHJvdyAnQ2Fubm90IGVuYWJsZSBwcm9kIG1vZGUgYWZ0ZXIgcGxhdGZvcm0gc2V0dXAuJztcbiAgfVxuICBfZGV2TW9kZSA9IGZhbHNlO1xufVxuXG5leHBvcnQgZnVuY3Rpb24gYXNzZXJ0aW9uc0VuYWJsZWQoKTogYm9vbGVhbiB7XG4gIHJldHVybiBfZGV2TW9kZTtcbn1cblxuLy8gVE9ETzogcmVtb3ZlIGNhbGxzIHRvIGFzc2VydCBpbiBwcm9kdWN0aW9uIGVudmlyb25tZW50XG4vLyBOb3RlOiBDYW4ndCBqdXN0IGV4cG9ydCB0aGlzIGFuZCBpbXBvcnQgaW4gaW4gb3RoZXIgZmlsZXNcbi8vIGFzIGBhc3NlcnRgIGlzIGEgcmVzZXJ2ZWQga2V5d29yZCBpbiBEYXJ0XG5fZ2xvYmFsLmFzc2VydCA9IGZ1bmN0aW9uIGFzc2VydChjb25kaXRpb24pIHtcbiAgLy8gVE9ETzogdG8gYmUgZml4ZWQgcHJvcGVybHkgdmlhICMyODMwLCBub29wIGZvciBub3dcbn07XG5cbi8vIFRoaXMgZnVuY3Rpb24gaXMgbmVlZGVkIG9ubHkgdG8gcHJvcGVybHkgc3VwcG9ydCBEYXJ0J3MgY29uc3QgZXhwcmVzc2lvbnNcbi8vIHNlZSBodHRwczovL2dpdGh1Yi5jb20vYW5ndWxhci90czJkYXJ0L3B1bGwvMTUxIGZvciBtb3JlIGluZm9cbmV4cG9ydCBmdW5jdGlvbiBDT05TVF9FWFBSPFQ+KGV4cHI6IFQpOiBUIHtcbiAgcmV0dXJuIGV4cHI7XG59XG5cbmV4cG9ydCBmdW5jdGlvbiBDT05TVCgpOiBDbGFzc0RlY29yYXRvciAmIFByb3BlcnR5RGVjb3JhdG9yIHtcbiAgcmV0dXJuICh0YXJnZXQpID0+IHRhcmdldDtcbn1cblxuZXhwb3J0IGZ1bmN0aW9uIGlzUHJlc2VudChvYmo6IGFueSk6IGJvb2xlYW4ge1xuICByZXR1cm4gb2JqICE9PSB1bmRlZmluZWQgJiYgb2JqICE9PSBudWxsO1xufVxuXG5leHBvcnQgZnVuY3Rpb24gaXNCbGFuayhvYmo6IGFueSk6IGJvb2xlYW4ge1xuICByZXR1cm4gb2JqID09PSB1bmRlZmluZWQgfHwgb2JqID09PSBudWxsO1xufVxuXG5leHBvcnQgZnVuY3Rpb24gaXNCb29sZWFuKG9iajogYW55KTogYm9vbGVhbiB7XG4gIHJldHVybiB0eXBlb2Ygb2JqID09PSBcImJvb2xlYW5cIjtcbn1cblxuZXhwb3J0IGZ1bmN0aW9uIGlzTnVtYmVyKG9iajogYW55KTogYm9vbGVhbiB7XG4gIHJldHVybiB0eXBlb2Ygb2JqID09PSBcIm51bWJlclwiO1xufVxuXG5leHBvcnQgZnVuY3Rpb24gaXNTdHJpbmcob2JqOiBhbnkpOiBib29sZWFuIHtcbiAgcmV0dXJuIHR5cGVvZiBvYmogPT09IFwic3RyaW5nXCI7XG59XG5cbmV4cG9ydCBmdW5jdGlvbiBpc0Z1bmN0aW9uKG9iajogYW55KTogYm9vbGVhbiB7XG4gIHJldHVybiB0eXBlb2Ygb2JqID09PSBcImZ1bmN0aW9uXCI7XG59XG5cbmV4cG9ydCBmdW5jdGlvbiBpc1R5cGUob2JqOiBhbnkpOiBib29sZWFuIHtcbiAgcmV0dXJuIGlzRnVuY3Rpb24ob2JqKTtcbn1cblxuZXhwb3J0IGZ1bmN0aW9uIGlzU3RyaW5nTWFwKG9iajogYW55KTogYm9vbGVhbiB7XG4gIHJldHVybiB0eXBlb2Ygb2JqID09PSAnb2JqZWN0JyAmJiBvYmogIT09IG51bGw7XG59XG5cbmV4cG9ydCBmdW5jdGlvbiBpc1Byb21pc2Uob2JqOiBhbnkpOiBib29sZWFuIHtcbiAgcmV0dXJuIG9iaiBpbnN0YW5jZW9mICg8YW55Pl9nbG9iYWwpLlByb21pc2U7XG59XG5cbmV4cG9ydCBmdW5jdGlvbiBpc0FycmF5KG9iajogYW55KTogYm9vbGVhbiB7XG4gIHJldHVybiBBcnJheS5pc0FycmF5KG9iaik7XG59XG5cbmV4cG9ydCBmdW5jdGlvbiBpc0RhdGUob2JqKTogYm9vbGVhbiB7XG4gIHJldHVybiBvYmogaW5zdGFuY2VvZiBEYXRlICYmICFpc05hTihvYmoudmFsdWVPZigpKTtcbn1cblxuZXhwb3J0IGZ1bmN0aW9uIG5vb3AoKSB7fVxuXG5leHBvcnQgZnVuY3Rpb24gc3RyaW5naWZ5KHRva2VuKTogc3RyaW5nIHtcbiAgaWYgKHR5cGVvZiB0b2tlbiA9PT0gJ3N0cmluZycpIHtcbiAgICByZXR1cm4gdG9rZW47XG4gIH1cblxuICBpZiAodG9rZW4gPT09IHVuZGVmaW5lZCB8fCB0b2tlbiA9PT0gbnVsbCkge1xuICAgIHJldHVybiAnJyArIHRva2VuO1xuICB9XG5cbiAgaWYgKHRva2VuLm5hbWUpIHtcbiAgICByZXR1cm4gdG9rZW4ubmFtZTtcbiAgfVxuICBpZiAodG9rZW4ub3ZlcnJpZGRlbk5hbWUpIHtcbiAgICByZXR1cm4gdG9rZW4ub3ZlcnJpZGRlbk5hbWU7XG4gIH1cblxuICB2YXIgcmVzID0gdG9rZW4udG9TdHJpbmcoKTtcbiAgdmFyIG5ld0xpbmVJbmRleCA9IHJlcy5pbmRleE9mKFwiXFxuXCIpO1xuICByZXR1cm4gKG5ld0xpbmVJbmRleCA9PT0gLTEpID8gcmVzIDogcmVzLnN1YnN0cmluZygwLCBuZXdMaW5lSW5kZXgpO1xufVxuXG4vLyBzZXJpYWxpemUgLyBkZXNlcmlhbGl6ZSBlbnVtIGV4aXN0IG9ubHkgZm9yIGNvbnNpc3RlbmN5IHdpdGggZGFydCBBUElcbi8vIGVudW1zIGluIHR5cGVzY3JpcHQgZG9uJ3QgbmVlZCB0byBiZSBzZXJpYWxpemVkXG5cbmV4cG9ydCBmdW5jdGlvbiBzZXJpYWxpemVFbnVtKHZhbCk6IG51bWJlciB7XG4gIHJldHVybiB2YWw7XG59XG5cbmV4cG9ydCBmdW5jdGlvbiBkZXNlcmlhbGl6ZUVudW0odmFsLCB2YWx1ZXM6IE1hcDxudW1iZXIsIGFueT4pOiBhbnkge1xuICByZXR1cm4gdmFsO1xufVxuXG5leHBvcnQgZnVuY3Rpb24gcmVzb2x2ZUVudW1Ub2tlbihlbnVtVmFsdWUsIHZhbCk6IHN0cmluZyB7XG4gIHJldHVybiBlbnVtVmFsdWVbdmFsXTtcbn1cblxuZXhwb3J0IGNsYXNzIFN0cmluZ1dyYXBwZXIge1xuICBzdGF0aWMgZnJvbUNoYXJDb2RlKGNvZGU6IG51bWJlcik6IHN0cmluZyB7IHJldHVybiBTdHJpbmcuZnJvbUNoYXJDb2RlKGNvZGUpOyB9XG5cbiAgc3RhdGljIGNoYXJDb2RlQXQoczogc3RyaW5nLCBpbmRleDogbnVtYmVyKTogbnVtYmVyIHsgcmV0dXJuIHMuY2hhckNvZGVBdChpbmRleCk7IH1cblxuICBzdGF0aWMgc3BsaXQoczogc3RyaW5nLCByZWdFeHA6IFJlZ0V4cCk6IHN0cmluZ1tdIHsgcmV0dXJuIHMuc3BsaXQocmVnRXhwKTsgfVxuXG4gIHN0YXRpYyBlcXVhbHMoczogc3RyaW5nLCBzMjogc3RyaW5nKTogYm9vbGVhbiB7IHJldHVybiBzID09PSBzMjsgfVxuXG4gIHN0YXRpYyBzdHJpcExlZnQoczogc3RyaW5nLCBjaGFyVmFsOiBzdHJpbmcpOiBzdHJpbmcge1xuICAgIGlmIChzICYmIHMubGVuZ3RoKSB7XG4gICAgICB2YXIgcG9zID0gMDtcbiAgICAgIGZvciAodmFyIGkgPSAwOyBpIDwgcy5sZW5ndGg7IGkrKykge1xuICAgICAgICBpZiAoc1tpXSAhPSBjaGFyVmFsKSBicmVhaztcbiAgICAgICAgcG9zKys7XG4gICAgICB9XG4gICAgICBzID0gcy5zdWJzdHJpbmcocG9zKTtcbiAgICB9XG4gICAgcmV0dXJuIHM7XG4gIH1cblxuICBzdGF0aWMgc3RyaXBSaWdodChzOiBzdHJpbmcsIGNoYXJWYWw6IHN0cmluZyk6IHN0cmluZyB7XG4gICAgaWYgKHMgJiYgcy5sZW5ndGgpIHtcbiAgICAgIHZhciBwb3MgPSBzLmxlbmd0aDtcbiAgICAgIGZvciAodmFyIGkgPSBzLmxlbmd0aCAtIDE7IGkgPj0gMDsgaS0tKSB7XG4gICAgICAgIGlmIChzW2ldICE9IGNoYXJWYWwpIGJyZWFrO1xuICAgICAgICBwb3MtLTtcbiAgICAgIH1cbiAgICAgIHMgPSBzLnN1YnN0cmluZygwLCBwb3MpO1xuICAgIH1cbiAgICByZXR1cm4gcztcbiAgfVxuXG4gIHN0YXRpYyByZXBsYWNlKHM6IHN0cmluZywgZnJvbTogc3RyaW5nLCByZXBsYWNlOiBzdHJpbmcpOiBzdHJpbmcge1xuICAgIHJldHVybiBzLnJlcGxhY2UoZnJvbSwgcmVwbGFjZSk7XG4gIH1cblxuICBzdGF0aWMgcmVwbGFjZUFsbChzOiBzdHJpbmcsIGZyb206IFJlZ0V4cCwgcmVwbGFjZTogc3RyaW5nKTogc3RyaW5nIHtcbiAgICByZXR1cm4gcy5yZXBsYWNlKGZyb20sIHJlcGxhY2UpO1xuICB9XG5cbiAgc3RhdGljIHNsaWNlPFQ+KHM6IHN0cmluZywgZnJvbTogbnVtYmVyID0gMCwgdG86IG51bWJlciA9IG51bGwpOiBzdHJpbmcge1xuICAgIHJldHVybiBzLnNsaWNlKGZyb20sIHRvID09PSBudWxsID8gdW5kZWZpbmVkIDogdG8pO1xuICB9XG5cbiAgc3RhdGljIHJlcGxhY2VBbGxNYXBwZWQoczogc3RyaW5nLCBmcm9tOiBSZWdFeHAsIGNiOiBGdW5jdGlvbik6IHN0cmluZyB7XG4gICAgcmV0dXJuIHMucmVwbGFjZShmcm9tLCBmdW5jdGlvbiguLi5tYXRjaGVzKSB7XG4gICAgICAvLyBSZW1vdmUgb2Zmc2V0ICYgc3RyaW5nIGZyb20gdGhlIHJlc3VsdCBhcnJheVxuICAgICAgbWF0Y2hlcy5zcGxpY2UoLTIsIDIpO1xuICAgICAgLy8gVGhlIGNhbGxiYWNrIHJlY2VpdmVzIG1hdGNoLCBwMSwgLi4uLCBwblxuICAgICAgcmV0dXJuIGNiKG1hdGNoZXMpO1xuICAgIH0pO1xuICB9XG5cbiAgc3RhdGljIGNvbnRhaW5zKHM6IHN0cmluZywgc3Vic3RyOiBzdHJpbmcpOiBib29sZWFuIHsgcmV0dXJuIHMuaW5kZXhPZihzdWJzdHIpICE9IC0xOyB9XG5cbiAgc3RhdGljIGNvbXBhcmUoYTogc3RyaW5nLCBiOiBzdHJpbmcpOiBudW1iZXIge1xuICAgIGlmIChhIDwgYikge1xuICAgICAgcmV0dXJuIC0xO1xuICAgIH0gZWxzZSBpZiAoYSA+IGIpIHtcbiAgICAgIHJldHVybiAxO1xuICAgIH0gZWxzZSB7XG4gICAgICByZXR1cm4gMDtcbiAgICB9XG4gIH1cbn1cblxuZXhwb3J0IGNsYXNzIFN0cmluZ0pvaW5lciB7XG4gIGNvbnN0cnVjdG9yKHB1YmxpYyBwYXJ0cyA9IFtdKSB7fVxuXG4gIGFkZChwYXJ0OiBzdHJpbmcpOiB2b2lkIHsgdGhpcy5wYXJ0cy5wdXNoKHBhcnQpOyB9XG5cbiAgdG9TdHJpbmcoKTogc3RyaW5nIHsgcmV0dXJuIHRoaXMucGFydHMuam9pbihcIlwiKTsgfVxufVxuXG5leHBvcnQgY2xhc3MgTnVtYmVyUGFyc2VFcnJvciBleHRlbmRzIEVycm9yIHtcbiAgbmFtZTogc3RyaW5nO1xuXG4gIGNvbnN0cnVjdG9yKHB1YmxpYyBtZXNzYWdlOiBzdHJpbmcpIHsgc3VwZXIoKTsgfVxuXG4gIHRvU3RyaW5nKCk6IHN0cmluZyB7IHJldHVybiB0aGlzLm1lc3NhZ2U7IH1cbn1cblxuXG5leHBvcnQgY2xhc3MgTnVtYmVyV3JhcHBlciB7XG4gIHN0YXRpYyB0b0ZpeGVkKG46IG51bWJlciwgZnJhY3Rpb25EaWdpdHM6IG51bWJlcik6IHN0cmluZyB7IHJldHVybiBuLnRvRml4ZWQoZnJhY3Rpb25EaWdpdHMpOyB9XG5cbiAgc3RhdGljIGVxdWFsKGE6IG51bWJlciwgYjogbnVtYmVyKTogYm9vbGVhbiB7IHJldHVybiBhID09PSBiOyB9XG5cbiAgc3RhdGljIHBhcnNlSW50QXV0b1JhZGl4KHRleHQ6IHN0cmluZyk6IG51bWJlciB7XG4gICAgdmFyIHJlc3VsdDogbnVtYmVyID0gcGFyc2VJbnQodGV4dCk7XG4gICAgaWYgKGlzTmFOKHJlc3VsdCkpIHtcbiAgICAgIHRocm93IG5ldyBOdW1iZXJQYXJzZUVycm9yKFwiSW52YWxpZCBpbnRlZ2VyIGxpdGVyYWwgd2hlbiBwYXJzaW5nIFwiICsgdGV4dCk7XG4gICAgfVxuICAgIHJldHVybiByZXN1bHQ7XG4gIH1cblxuICBzdGF0aWMgcGFyc2VJbnQodGV4dDogc3RyaW5nLCByYWRpeDogbnVtYmVyKTogbnVtYmVyIHtcbiAgICBpZiAocmFkaXggPT0gMTApIHtcbiAgICAgIGlmICgvXihcXC18XFwrKT9bMC05XSskLy50ZXN0KHRleHQpKSB7XG4gICAgICAgIHJldHVybiBwYXJzZUludCh0ZXh0LCByYWRpeCk7XG4gICAgICB9XG4gICAgfSBlbHNlIGlmIChyYWRpeCA9PSAxNikge1xuICAgICAgaWYgKC9eKFxcLXxcXCspP1swLTlBQkNERUZhYmNkZWZdKyQvLnRlc3QodGV4dCkpIHtcbiAgICAgICAgcmV0dXJuIHBhcnNlSW50KHRleHQsIHJhZGl4KTtcbiAgICAgIH1cbiAgICB9IGVsc2Uge1xuICAgICAgdmFyIHJlc3VsdDogbnVtYmVyID0gcGFyc2VJbnQodGV4dCwgcmFkaXgpO1xuICAgICAgaWYgKCFpc05hTihyZXN1bHQpKSB7XG4gICAgICAgIHJldHVybiByZXN1bHQ7XG4gICAgICB9XG4gICAgfVxuICAgIHRocm93IG5ldyBOdW1iZXJQYXJzZUVycm9yKFwiSW52YWxpZCBpbnRlZ2VyIGxpdGVyYWwgd2hlbiBwYXJzaW5nIFwiICsgdGV4dCArIFwiIGluIGJhc2UgXCIgK1xuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIHJhZGl4KTtcbiAgfVxuXG4gIC8vIFRPRE86IE5hTiBpcyBhIHZhbGlkIGxpdGVyYWwgYnV0IGlzIHJldHVybmVkIGJ5IHBhcnNlRmxvYXQgdG8gaW5kaWNhdGUgYW4gZXJyb3IuXG4gIHN0YXRpYyBwYXJzZUZsb2F0KHRleHQ6IHN0cmluZyk6IG51bWJlciB7IHJldHVybiBwYXJzZUZsb2F0KHRleHQpOyB9XG5cbiAgc3RhdGljIGdldCBOYU4oKTogbnVtYmVyIHsgcmV0dXJuIE5hTjsgfVxuXG4gIHN0YXRpYyBpc05hTih2YWx1ZTogYW55KTogYm9vbGVhbiB7IHJldHVybiBpc05hTih2YWx1ZSk7IH1cblxuICBzdGF0aWMgaXNJbnRlZ2VyKHZhbHVlOiBhbnkpOiBib29sZWFuIHsgcmV0dXJuIE51bWJlci5pc0ludGVnZXIodmFsdWUpOyB9XG59XG5cbmV4cG9ydCB2YXIgUmVnRXhwID0gX2dsb2JhbC5SZWdFeHA7XG5cbmV4cG9ydCBjbGFzcyBSZWdFeHBXcmFwcGVyIHtcbiAgc3RhdGljIGNyZWF0ZShyZWdFeHBTdHI6IHN0cmluZywgZmxhZ3M6IHN0cmluZyA9ICcnKTogUmVnRXhwIHtcbiAgICBmbGFncyA9IGZsYWdzLnJlcGxhY2UoL2cvZywgJycpO1xuICAgIHJldHVybiBuZXcgX2dsb2JhbC5SZWdFeHAocmVnRXhwU3RyLCBmbGFncyArICdnJyk7XG4gIH1cbiAgc3RhdGljIGZpcnN0TWF0Y2gocmVnRXhwOiBSZWdFeHAsIGlucHV0OiBzdHJpbmcpOiBSZWdFeHBFeGVjQXJyYXkge1xuICAgIC8vIFJlc2V0IG11bHRpbWF0Y2ggcmVnZXggc3RhdGVcbiAgICByZWdFeHAubGFzdEluZGV4ID0gMDtcbiAgICByZXR1cm4gcmVnRXhwLmV4ZWMoaW5wdXQpO1xuICB9XG4gIHN0YXRpYyB0ZXN0KHJlZ0V4cDogUmVnRXhwLCBpbnB1dDogc3RyaW5nKTogYm9vbGVhbiB7XG4gICAgcmVnRXhwLmxhc3RJbmRleCA9IDA7XG4gICAgcmV0dXJuIHJlZ0V4cC50ZXN0KGlucHV0KTtcbiAgfVxuICBzdGF0aWMgbWF0Y2hlcihyZWdFeHA6IFJlZ0V4cCwgaW5wdXQ6IHN0cmluZyk6IHtcbiAgICByZTogUmVnRXhwO1xuICAgIGlucHV0OiBzdHJpbmdcbiAgfVxuICB7XG4gICAgLy8gUmVzZXQgcmVnZXggc3RhdGUgZm9yIHRoZSBjYXNlXG4gICAgLy8gc29tZW9uZSBkaWQgbm90IGxvb3Agb3ZlciBhbGwgbWF0Y2hlc1xuICAgIC8vIGxhc3QgdGltZS5cbiAgICByZWdFeHAubGFzdEluZGV4ID0gMDtcbiAgICByZXR1cm4ge3JlOiByZWdFeHAsIGlucHV0OiBpbnB1dH07XG4gIH1cbiAgc3RhdGljIHJlcGxhY2VBbGwocmVnRXhwOiBSZWdFeHAsIGlucHV0OiBzdHJpbmcsIHJlcGxhY2U6IEZ1bmN0aW9uKTogc3RyaW5nIHtcbiAgICBsZXQgYyA9IHJlZ0V4cC5leGVjKGlucHV0KTtcbiAgICBsZXQgcmVzID0gJyc7XG4gICAgcmVnRXhwLmxhc3RJbmRleCA9IDA7XG4gICAgbGV0IHByZXYgPSAwO1xuICAgIHdoaWxlIChjKSB7XG4gICAgICByZXMgKz0gaW5wdXQuc3Vic3RyaW5nKHByZXYsIGMuaW5kZXgpO1xuICAgICAgcmVzICs9IHJlcGxhY2UoYyk7XG4gICAgICBwcmV2ID0gYy5pbmRleCArIGNbMF0ubGVuZ3RoO1xuICAgICAgcmVnRXhwLmxhc3RJbmRleCA9IHByZXY7XG4gICAgICBjID0gcmVnRXhwLmV4ZWMoaW5wdXQpO1xuICAgIH1cbiAgICByZXMgKz0gaW5wdXQuc3Vic3RyaW5nKHByZXYpO1xuICAgIHJldHVybiByZXM7XG4gIH1cbn1cblxuZXhwb3J0IGNsYXNzIFJlZ0V4cE1hdGNoZXJXcmFwcGVyIHtcbiAgc3RhdGljIG5leHQobWF0Y2hlcjoge1xuICAgIHJlOiBSZWdFeHA7XG4gICAgaW5wdXQ6IHN0cmluZ1xuICB9KTogUmVnRXhwRXhlY0FycmF5IHtcbiAgICByZXR1cm4gbWF0Y2hlci5yZS5leGVjKG1hdGNoZXIuaW5wdXQpO1xuICB9XG59XG5cbmV4cG9ydCBjbGFzcyBGdW5jdGlvbldyYXBwZXIge1xuICBzdGF0aWMgYXBwbHkoZm46IEZ1bmN0aW9uLCBwb3NBcmdzOiBhbnkpOiBhbnkgeyByZXR1cm4gZm4uYXBwbHkobnVsbCwgcG9zQXJncyk7IH1cbn1cblxuLy8gSlMgaGFzIE5hTiAhPT0gTmFOXG5leHBvcnQgZnVuY3Rpb24gbG9vc2VJZGVudGljYWwoYSwgYik6IGJvb2xlYW4ge1xuICByZXR1cm4gYSA9PT0gYiB8fCB0eXBlb2YgYSA9PT0gXCJudW1iZXJcIiAmJiB0eXBlb2YgYiA9PT0gXCJudW1iZXJcIiAmJiBpc05hTihhKSAmJiBpc05hTihiKTtcbn1cblxuLy8gSlMgY29uc2lkZXJzIE5hTiBpcyB0aGUgc2FtZSBhcyBOYU4gZm9yIG1hcCBLZXkgKHdoaWxlIE5hTiAhPT0gTmFOIG90aGVyd2lzZSlcbi8vIHNlZSBodHRwczovL2RldmVsb3Blci5tb3ppbGxhLm9yZy9lbi1VUy9kb2NzL1dlYi9KYXZhU2NyaXB0L1JlZmVyZW5jZS9HbG9iYWxfT2JqZWN0cy9NYXBcbmV4cG9ydCBmdW5jdGlvbiBnZXRNYXBLZXk8VD4odmFsdWU6IFQpOiBUIHtcbiAgcmV0dXJuIHZhbHVlO1xufVxuXG5leHBvcnQgZnVuY3Rpb24gbm9ybWFsaXplQmxhbmsob2JqOiBPYmplY3QpOiBhbnkge1xuICByZXR1cm4gaXNCbGFuayhvYmopID8gbnVsbCA6IG9iajtcbn1cblxuZXhwb3J0IGZ1bmN0aW9uIG5vcm1hbGl6ZUJvb2wob2JqOiBib29sZWFuKTogYm9vbGVhbiB7XG4gIHJldHVybiBpc0JsYW5rKG9iaikgPyBmYWxzZSA6IG9iajtcbn1cblxuZXhwb3J0IGZ1bmN0aW9uIGlzSnNPYmplY3QobzogYW55KTogYm9vbGVhbiB7XG4gIHJldHVybiBvICE9PSBudWxsICYmICh0eXBlb2YgbyA9PT0gXCJmdW5jdGlvblwiIHx8IHR5cGVvZiBvID09PSBcIm9iamVjdFwiKTtcbn1cblxuZXhwb3J0IGZ1bmN0aW9uIHByaW50KG9iajogRXJyb3IgfCBPYmplY3QpIHtcbiAgY29uc29sZS5sb2cob2JqKTtcbn1cblxuLy8gQ2FuJ3QgYmUgYWxsIHVwcGVyY2FzZSBhcyBvdXIgdHJhbnNwaWxlciB3b3VsZCB0aGluayBpdCBpcyBhIHNwZWNpYWwgZGlyZWN0aXZlLi4uXG5leHBvcnQgY2xhc3MgSnNvbiB7XG4gIHN0YXRpYyBwYXJzZShzOiBzdHJpbmcpOiBPYmplY3QgeyByZXR1cm4gX2dsb2JhbC5KU09OLnBhcnNlKHMpOyB9XG4gIHN0YXRpYyBzdHJpbmdpZnkoZGF0YTogT2JqZWN0KTogc3RyaW5nIHtcbiAgICAvLyBEYXJ0IGRvZXNuJ3QgdGFrZSAzIGFyZ3VtZW50c1xuICAgIHJldHVybiBfZ2xvYmFsLkpTT04uc3RyaW5naWZ5KGRhdGEsIG51bGwsIDIpO1xuICB9XG59XG5cbmV4cG9ydCBjbGFzcyBEYXRlV3JhcHBlciB7XG4gIHN0YXRpYyBjcmVhdGUoeWVhcjogbnVtYmVyLCBtb250aDogbnVtYmVyID0gMSwgZGF5OiBudW1iZXIgPSAxLCBob3VyOiBudW1iZXIgPSAwLFxuICAgICAgICAgICAgICAgIG1pbnV0ZXM6IG51bWJlciA9IDAsIHNlY29uZHM6IG51bWJlciA9IDAsIG1pbGxpc2Vjb25kczogbnVtYmVyID0gMCk6IERhdGUge1xuICAgIHJldHVybiBuZXcgRGF0ZSh5ZWFyLCBtb250aCAtIDEsIGRheSwgaG91ciwgbWludXRlcywgc2Vjb25kcywgbWlsbGlzZWNvbmRzKTtcbiAgfVxuICBzdGF0aWMgZnJvbUlTT1N0cmluZyhzdHI6IHN0cmluZyk6IERhdGUgeyByZXR1cm4gbmV3IERhdGUoc3RyKTsgfVxuICBzdGF0aWMgZnJvbU1pbGxpcyhtczogbnVtYmVyKTogRGF0ZSB7IHJldHVybiBuZXcgRGF0ZShtcyk7IH1cbiAgc3RhdGljIHRvTWlsbGlzKGRhdGU6IERhdGUpOiBudW1iZXIgeyByZXR1cm4gZGF0ZS5nZXRUaW1lKCk7IH1cbiAgc3RhdGljIG5vdygpOiBEYXRlIHsgcmV0dXJuIG5ldyBEYXRlKCk7IH1cbiAgc3RhdGljIHRvSnNvbihkYXRlOiBEYXRlKTogc3RyaW5nIHsgcmV0dXJuIGRhdGUudG9KU09OKCk7IH1cbn1cblxuZXhwb3J0IGZ1bmN0aW9uIHNldFZhbHVlT25QYXRoKGdsb2JhbDogYW55LCBwYXRoOiBzdHJpbmcsIHZhbHVlOiBhbnkpIHtcbiAgdmFyIHBhcnRzID0gcGF0aC5zcGxpdCgnLicpO1xuICB2YXIgb2JqOiBhbnkgPSBnbG9iYWw7XG4gIHdoaWxlIChwYXJ0cy5sZW5ndGggPiAxKSB7XG4gICAgdmFyIG5hbWUgPSBwYXJ0cy5zaGlmdCgpO1xuICAgIGlmIChvYmouaGFzT3duUHJvcGVydHkobmFtZSkgJiYgaXNQcmVzZW50KG9ialtuYW1lXSkpIHtcbiAgICAgIG9iaiA9IG9ialtuYW1lXTtcbiAgICB9IGVsc2Uge1xuICAgICAgb2JqID0gb2JqW25hbWVdID0ge307XG4gICAgfVxuICB9XG4gIGlmIChvYmogPT09IHVuZGVmaW5lZCB8fCBvYmogPT09IG51bGwpIHtcbiAgICBvYmogPSB7fTtcbiAgfVxuICBvYmpbcGFydHMuc2hpZnQoKV0gPSB2YWx1ZTtcbn1cblxuLy8gV2hlbiBTeW1ib2wuaXRlcmF0b3IgZG9lc24ndCBleGlzdCwgcmV0cmlldmVzIHRoZSBrZXkgdXNlZCBpbiBlczYtc2hpbVxuZGVjbGFyZSB2YXIgU3ltYm9sO1xudmFyIF9zeW1ib2xJdGVyYXRvciA9IG51bGw7XG5leHBvcnQgZnVuY3Rpb24gZ2V0U3ltYm9sSXRlcmF0b3IoKTogc3RyaW5nIHwgc3ltYm9sIHtcbiAgaWYgKGlzQmxhbmsoX3N5bWJvbEl0ZXJhdG9yKSkge1xuICAgIGlmIChpc1ByZXNlbnQoU3ltYm9sKSAmJiBpc1ByZXNlbnQoU3ltYm9sLml0ZXJhdG9yKSkge1xuICAgICAgX3N5bWJvbEl0ZXJhdG9yID0gU3ltYm9sLml0ZXJhdG9yO1xuICAgIH0gZWxzZSB7XG4gICAgICAvLyBlczYtc2hpbSBzcGVjaWZpYyBsb2dpY1xuICAgICAgdmFyIGtleXMgPSBPYmplY3QuZ2V0T3duUHJvcGVydHlOYW1lcyhNYXAucHJvdG90eXBlKTtcbiAgICAgIGZvciAodmFyIGkgPSAwOyBpIDwga2V5cy5sZW5ndGg7ICsraSkge1xuICAgICAgICB2YXIga2V5ID0ga2V5c1tpXTtcbiAgICAgICAgaWYgKGtleSAhPT0gJ2VudHJpZXMnICYmIGtleSAhPT0gJ3NpemUnICYmXG4gICAgICAgICAgICBNYXAucHJvdG90eXBlW2tleV0gPT09IE1hcC5wcm90b3R5cGVbJ2VudHJpZXMnXSkge1xuICAgICAgICAgIF9zeW1ib2xJdGVyYXRvciA9IGtleTtcbiAgICAgICAgfVxuICAgICAgfVxuICAgIH1cbiAgfVxuICByZXR1cm4gX3N5bWJvbEl0ZXJhdG9yO1xufVxuXG5leHBvcnQgZnVuY3Rpb24gZXZhbEV4cHJlc3Npb24oc291cmNlVXJsOiBzdHJpbmcsIGV4cHI6IHN0cmluZywgZGVjbGFyYXRpb25zOiBzdHJpbmcsXG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgdmFyczoge1trZXk6IHN0cmluZ106IGFueX0pOiBhbnkge1xuICB2YXIgZm5Cb2R5ID0gYCR7ZGVjbGFyYXRpb25zfVxcbnJldHVybiAke2V4cHJ9XFxuLy8jIHNvdXJjZVVSTD0ke3NvdXJjZVVybH1gO1xuICB2YXIgZm5BcmdOYW1lcyA9IFtdO1xuICB2YXIgZm5BcmdWYWx1ZXMgPSBbXTtcbiAgZm9yICh2YXIgYXJnTmFtZSBpbiB2YXJzKSB7XG4gICAgZm5BcmdOYW1lcy5wdXNoKGFyZ05hbWUpO1xuICAgIGZuQXJnVmFsdWVzLnB1c2godmFyc1thcmdOYW1lXSk7XG4gIH1cbiAgcmV0dXJuIG5ldyBGdW5jdGlvbiguLi5mbkFyZ05hbWVzLmNvbmNhdChmbkJvZHkpKSguLi5mbkFyZ1ZhbHVlcyk7XG59XG5cbmV4cG9ydCBmdW5jdGlvbiBpc1ByaW1pdGl2ZShvYmo6IGFueSk6IGJvb2xlYW4ge1xuICByZXR1cm4gIWlzSnNPYmplY3Qob2JqKTtcbn1cblxuZXhwb3J0IGZ1bmN0aW9uIGhhc0NvbnN0cnVjdG9yKHZhbHVlOiBPYmplY3QsIHR5cGU6IFR5cGUpOiBib29sZWFuIHtcbiAgcmV0dXJuIHZhbHVlLmNvbnN0cnVjdG9yID09PSB0eXBlO1xufVxuXG5leHBvcnQgZnVuY3Rpb24gYml0V2lzZU9yKHZhbHVlczogbnVtYmVyW10pOiBudW1iZXIge1xuICByZXR1cm4gdmFsdWVzLnJlZHVjZSgoYSwgYikgPT4geyByZXR1cm4gYSB8IGI7IH0pO1xufVxuXG5leHBvcnQgZnVuY3Rpb24gYml0V2lzZUFuZCh2YWx1ZXM6IG51bWJlcltdKTogbnVtYmVyIHtcbiAgcmV0dXJuIHZhbHVlcy5yZWR1Y2UoKGEsIGIpID0+IHsgcmV0dXJuIGEgJiBiOyB9KTtcbn1cblxuZXhwb3J0IGZ1bmN0aW9uIGVzY2FwZShzOiBzdHJpbmcpOiBzdHJpbmcge1xuICByZXR1cm4gX2dsb2JhbC5lbmNvZGVVUkkocyk7XG59XG4iXX0=