'use strict';"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var __param = (this && this.__param) || function (paramIndex, decorator) {
    return function (target, key) { decorator(target, key, paramIndex); }
};
var lang_1 = require('angular2/src/facade/lang');
var collection_1 = require('angular2/src/facade/collection');
var exceptions_1 = require('angular2/src/facade/exceptions');
var element_1 = require('./element');
var exceptions_2 = require('./exceptions');
var change_detection_1 = require('angular2/src/core/change_detection/change_detection');
var di_1 = require('angular2/src/core/di');
var api_1 = require('angular2/src/core/render/api');
var application_tokens_1 = require('angular2/src/core/application_tokens');
var ViewUtils = (function () {
    function ViewUtils(_renderer, _appId) {
        this._renderer = _renderer;
        this._appId = _appId;
        this._nextCompTypeId = 0;
    }
    /**
     * Used by the generated code
     */
    ViewUtils.prototype.createRenderComponentType = function (templateUrl, slotCount, encapsulation, styles) {
        return new api_1.RenderComponentType(this._appId + "-" + this._nextCompTypeId++, templateUrl, slotCount, encapsulation, styles);
    };
    /** @internal */
    ViewUtils.prototype.renderComponent = function (renderComponentType) {
        return this._renderer.renderComponent(renderComponentType);
    };
    ViewUtils = __decorate([
        di_1.Injectable(),
        __param(1, di_1.Inject(application_tokens_1.APP_ID)), 
        __metadata('design:paramtypes', [api_1.RootRenderer, String])
    ], ViewUtils);
    return ViewUtils;
}());
exports.ViewUtils = ViewUtils;
function flattenNestedViewRenderNodes(nodes) {
    return _flattenNestedViewRenderNodes(nodes, []);
}
exports.flattenNestedViewRenderNodes = flattenNestedViewRenderNodes;
function _flattenNestedViewRenderNodes(nodes, renderNodes) {
    for (var i = 0; i < nodes.length; i++) {
        var node = nodes[i];
        if (node instanceof element_1.AppElement) {
            var appEl = node;
            renderNodes.push(appEl.nativeElement);
            if (lang_1.isPresent(appEl.nestedViews)) {
                for (var k = 0; k < appEl.nestedViews.length; k++) {
                    _flattenNestedViewRenderNodes(appEl.nestedViews[k].rootNodesOrAppElements, renderNodes);
                }
            }
        }
        else {
            renderNodes.push(node);
        }
    }
    return renderNodes;
}
var EMPTY_ARR = lang_1.CONST_EXPR([]);
function ensureSlotCount(projectableNodes, expectedSlotCount) {
    var res;
    if (lang_1.isBlank(projectableNodes)) {
        res = EMPTY_ARR;
    }
    else if (projectableNodes.length < expectedSlotCount) {
        var givenSlotCount = projectableNodes.length;
        res = collection_1.ListWrapper.createFixedSize(expectedSlotCount);
        for (var i = 0; i < expectedSlotCount; i++) {
            res[i] = (i < givenSlotCount) ? projectableNodes[i] : EMPTY_ARR;
        }
    }
    else {
        res = projectableNodes;
    }
    return res;
}
exports.ensureSlotCount = ensureSlotCount;
exports.MAX_INTERPOLATION_VALUES = 9;
function interpolate(valueCount, c0, a1, c1, a2, c2, a3, c3, a4, c4, a5, c5, a6, c6, a7, c7, a8, c8, a9, c9) {
    switch (valueCount) {
        case 1:
            return c0 + _toStringWithNull(a1) + c1;
        case 2:
            return c0 + _toStringWithNull(a1) + c1 + _toStringWithNull(a2) + c2;
        case 3:
            return c0 + _toStringWithNull(a1) + c1 + _toStringWithNull(a2) + c2 + _toStringWithNull(a3) +
                c3;
        case 4:
            return c0 + _toStringWithNull(a1) + c1 + _toStringWithNull(a2) + c2 + _toStringWithNull(a3) +
                c3 + _toStringWithNull(a4) + c4;
        case 5:
            return c0 + _toStringWithNull(a1) + c1 + _toStringWithNull(a2) + c2 + _toStringWithNull(a3) +
                c3 + _toStringWithNull(a4) + c4 + _toStringWithNull(a5) + c5;
        case 6:
            return c0 + _toStringWithNull(a1) + c1 + _toStringWithNull(a2) + c2 + _toStringWithNull(a3) +
                c3 + _toStringWithNull(a4) + c4 + _toStringWithNull(a5) + c5 + _toStringWithNull(a6) +
                c6;
        case 7:
            return c0 + _toStringWithNull(a1) + c1 + _toStringWithNull(a2) + c2 + _toStringWithNull(a3) +
                c3 + _toStringWithNull(a4) + c4 + _toStringWithNull(a5) + c5 + _toStringWithNull(a6) +
                c6 + _toStringWithNull(a7) + c7;
        case 8:
            return c0 + _toStringWithNull(a1) + c1 + _toStringWithNull(a2) + c2 + _toStringWithNull(a3) +
                c3 + _toStringWithNull(a4) + c4 + _toStringWithNull(a5) + c5 + _toStringWithNull(a6) +
                c6 + _toStringWithNull(a7) + c7 + _toStringWithNull(a8) + c8;
        case 9:
            return c0 + _toStringWithNull(a1) + c1 + _toStringWithNull(a2) + c2 + _toStringWithNull(a3) +
                c3 + _toStringWithNull(a4) + c4 + _toStringWithNull(a5) + c5 + _toStringWithNull(a6) +
                c6 + _toStringWithNull(a7) + c7 + _toStringWithNull(a8) + c8 + _toStringWithNull(a9) +
                c9;
        default:
            throw new exceptions_1.BaseException("Does not support more than 9 expressions");
    }
}
exports.interpolate = interpolate;
function _toStringWithNull(v) {
    return v != null ? v.toString() : '';
}
function checkBinding(throwOnChange, oldValue, newValue) {
    if (throwOnChange) {
        if (!change_detection_1.devModeEqual(oldValue, newValue)) {
            throw new exceptions_2.ExpressionChangedAfterItHasBeenCheckedException(oldValue, newValue, null);
        }
        return false;
    }
    else {
        return !lang_1.looseIdentical(oldValue, newValue);
    }
}
exports.checkBinding = checkBinding;
function arrayLooseIdentical(a, b) {
    if (a.length != b.length)
        return false;
    for (var i = 0; i < a.length; ++i) {
        if (!lang_1.looseIdentical(a[i], b[i]))
            return false;
    }
    return true;
}
exports.arrayLooseIdentical = arrayLooseIdentical;
function mapLooseIdentical(m1, m2) {
    var k1 = collection_1.StringMapWrapper.keys(m1);
    var k2 = collection_1.StringMapWrapper.keys(m2);
    if (k1.length != k2.length) {
        return false;
    }
    var key;
    for (var i = 0; i < k1.length; i++) {
        key = k1[i];
        if (!lang_1.looseIdentical(m1[key], m2[key])) {
            return false;
        }
    }
    return true;
}
exports.mapLooseIdentical = mapLooseIdentical;
function castByValue(input, value) {
    return input;
}
exports.castByValue = castByValue;
function pureProxy1(fn) {
    var result;
    var v0;
    v0 = change_detection_1.uninitialized;
    return function (p0) {
        if (!lang_1.looseIdentical(v0, p0)) {
            v0 = p0;
            result = fn(p0);
        }
        return result;
    };
}
exports.pureProxy1 = pureProxy1;
function pureProxy2(fn) {
    var result;
    var v0, v1;
    v0 = v1 = change_detection_1.uninitialized;
    return function (p0, p1) {
        if (!lang_1.looseIdentical(v0, p0) || !lang_1.looseIdentical(v1, p1)) {
            v0 = p0;
            v1 = p1;
            result = fn(p0, p1);
        }
        return result;
    };
}
exports.pureProxy2 = pureProxy2;
function pureProxy3(fn) {
    var result;
    var v0, v1, v2;
    v0 = v1 = v2 = change_detection_1.uninitialized;
    return function (p0, p1, p2) {
        if (!lang_1.looseIdentical(v0, p0) || !lang_1.looseIdentical(v1, p1) || !lang_1.looseIdentical(v2, p2)) {
            v0 = p0;
            v1 = p1;
            v2 = p2;
            result = fn(p0, p1, p2);
        }
        return result;
    };
}
exports.pureProxy3 = pureProxy3;
function pureProxy4(fn) {
    var result;
    var v0, v1, v2, v3;
    v0 = v1 = v2 = v3 = change_detection_1.uninitialized;
    return function (p0, p1, p2, p3) {
        if (!lang_1.looseIdentical(v0, p0) || !lang_1.looseIdentical(v1, p1) || !lang_1.looseIdentical(v2, p2) ||
            !lang_1.looseIdentical(v3, p3)) {
            v0 = p0;
            v1 = p1;
            v2 = p2;
            v3 = p3;
            result = fn(p0, p1, p2, p3);
        }
        return result;
    };
}
exports.pureProxy4 = pureProxy4;
function pureProxy5(fn) {
    var result;
    var v0, v1, v2, v3, v4;
    v0 = v1 = v2 = v3 = v4 = change_detection_1.uninitialized;
    return function (p0, p1, p2, p3, p4) {
        if (!lang_1.looseIdentical(v0, p0) || !lang_1.looseIdentical(v1, p1) || !lang_1.looseIdentical(v2, p2) ||
            !lang_1.looseIdentical(v3, p3) || !lang_1.looseIdentical(v4, p4)) {
            v0 = p0;
            v1 = p1;
            v2 = p2;
            v3 = p3;
            v4 = p4;
            result = fn(p0, p1, p2, p3, p4);
        }
        return result;
    };
}
exports.pureProxy5 = pureProxy5;
function pureProxy6(fn) {
    var result;
    var v0, v1, v2, v3, v4, v5;
    v0 = v1 = v2 = v3 = v4 = v5 = change_detection_1.uninitialized;
    return function (p0, p1, p2, p3, p4, p5) {
        if (!lang_1.looseIdentical(v0, p0) || !lang_1.looseIdentical(v1, p1) || !lang_1.looseIdentical(v2, p2) ||
            !lang_1.looseIdentical(v3, p3) || !lang_1.looseIdentical(v4, p4) || !lang_1.looseIdentical(v5, p5)) {
            v0 = p0;
            v1 = p1;
            v2 = p2;
            v3 = p3;
            v4 = p4;
            v5 = p5;
            result = fn(p0, p1, p2, p3, p4, p5);
        }
        return result;
    };
}
exports.pureProxy6 = pureProxy6;
function pureProxy7(fn) {
    var result;
    var v0, v1, v2, v3, v4, v5, v6;
    v0 = v1 = v2 = v3 = v4 = v5 = v6 = change_detection_1.uninitialized;
    return function (p0, p1, p2, p3, p4, p5, p6) {
        if (!lang_1.looseIdentical(v0, p0) || !lang_1.looseIdentical(v1, p1) || !lang_1.looseIdentical(v2, p2) ||
            !lang_1.looseIdentical(v3, p3) || !lang_1.looseIdentical(v4, p4) || !lang_1.looseIdentical(v5, p5) ||
            !lang_1.looseIdentical(v6, p6)) {
            v0 = p0;
            v1 = p1;
            v2 = p2;
            v3 = p3;
            v4 = p4;
            v5 = p5;
            v6 = p6;
            result = fn(p0, p1, p2, p3, p4, p5, p6);
        }
        return result;
    };
}
exports.pureProxy7 = pureProxy7;
function pureProxy8(fn) {
    var result;
    var v0, v1, v2, v3, v4, v5, v6, v7;
    v0 = v1 = v2 = v3 = v4 = v5 = v6 = v7 = change_detection_1.uninitialized;
    return function (p0, p1, p2, p3, p4, p5, p6, p7) {
        if (!lang_1.looseIdentical(v0, p0) || !lang_1.looseIdentical(v1, p1) || !lang_1.looseIdentical(v2, p2) ||
            !lang_1.looseIdentical(v3, p3) || !lang_1.looseIdentical(v4, p4) || !lang_1.looseIdentical(v5, p5) ||
            !lang_1.looseIdentical(v6, p6) || !lang_1.looseIdentical(v7, p7)) {
            v0 = p0;
            v1 = p1;
            v2 = p2;
            v3 = p3;
            v4 = p4;
            v5 = p5;
            v6 = p6;
            v7 = p7;
            result = fn(p0, p1, p2, p3, p4, p5, p6, p7);
        }
        return result;
    };
}
exports.pureProxy8 = pureProxy8;
function pureProxy9(fn) {
    var result;
    var v0, v1, v2, v3, v4, v5, v6, v7, v8;
    v0 = v1 = v2 = v3 = v4 = v5 = v6 = v7 = v8 = change_detection_1.uninitialized;
    return function (p0, p1, p2, p3, p4, p5, p6, p7, p8) {
        if (!lang_1.looseIdentical(v0, p0) || !lang_1.looseIdentical(v1, p1) || !lang_1.looseIdentical(v2, p2) ||
            !lang_1.looseIdentical(v3, p3) || !lang_1.looseIdentical(v4, p4) || !lang_1.looseIdentical(v5, p5) ||
            !lang_1.looseIdentical(v6, p6) || !lang_1.looseIdentical(v7, p7) || !lang_1.looseIdentical(v8, p8)) {
            v0 = p0;
            v1 = p1;
            v2 = p2;
            v3 = p3;
            v4 = p4;
            v5 = p5;
            v6 = p6;
            v7 = p7;
            v8 = p8;
            result = fn(p0, p1, p2, p3, p4, p5, p6, p7, p8);
        }
        return result;
    };
}
exports.pureProxy9 = pureProxy9;
function pureProxy10(fn) {
    var result;
    var v0, v1, v2, v3, v4, v5, v6, v7, v8, v9;
    v0 = v1 = v2 = v3 = v4 = v5 = v6 = v7 = v8 = v9 = change_detection_1.uninitialized;
    return function (p0, p1, p2, p3, p4, p5, p6, p7, p8, p9) {
        if (!lang_1.looseIdentical(v0, p0) || !lang_1.looseIdentical(v1, p1) || !lang_1.looseIdentical(v2, p2) ||
            !lang_1.looseIdentical(v3, p3) || !lang_1.looseIdentical(v4, p4) || !lang_1.looseIdentical(v5, p5) ||
            !lang_1.looseIdentical(v6, p6) || !lang_1.looseIdentical(v7, p7) || !lang_1.looseIdentical(v8, p8) ||
            !lang_1.looseIdentical(v9, p9)) {
            v0 = p0;
            v1 = p1;
            v2 = p2;
            v3 = p3;
            v4 = p4;
            v5 = p5;
            v6 = p6;
            v7 = p7;
            v8 = p8;
            v9 = p9;
            result = fn(p0, p1, p2, p3, p4, p5, p6, p7, p8, p9);
        }
        return result;
    };
}
exports.pureProxy10 = pureProxy10;
//# sourceMappingURL=data:application/json;base64,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