'use strict';var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var collection_1 = require('angular2/src/facade/collection');
var change_detection_1 = require('angular2/src/core/change_detection/change_detection');
var interfaces_1 = require('angular2/src/core/change_detection/interfaces');
var element_1 = require('./element');
var lang_1 = require('angular2/src/facade/lang');
var exceptions_1 = require('angular2/src/facade/exceptions');
var view_ref_1 = require('./view_ref');
var pipes_1 = require('angular2/src/core/pipes/pipes');
var util_1 = require('angular2/src/core/render/util');
var interfaces_2 = require('angular2/src/core/change_detection/interfaces');
exports.DebugContext = interfaces_2.DebugContext;
var pipes_2 = require('angular2/src/core/pipes/pipes');
var view_type_1 = require('./view_type');
var REFLECT_PREFIX = 'ng-reflect-';
var EMPTY_CONTEXT = lang_1.CONST_EXPR(new Object());
/**
 * Cost of making objects: http://jsperf.com/instantiate-size-of-object
 *
 */
var AppView = (function () {
    function AppView(proto, renderer, viewManager, projectableNodes, containerAppElement, imperativelyCreatedProviders, rootInjector, changeDetector) {
        this.proto = proto;
        this.renderer = renderer;
        this.viewManager = viewManager;
        this.projectableNodes = projectableNodes;
        this.containerAppElement = containerAppElement;
        this.changeDetector = changeDetector;
        /**
         * The context against which data-binding expressions in this view are evaluated against.
         * This is always a component instance.
         */
        this.context = null;
        this.destroyed = false;
        this.ref = new view_ref_1.ViewRef_(this);
        var injectorWithHostBoundary = element_1.AppElement.getViewParentInjector(this.proto.type, containerAppElement, imperativelyCreatedProviders, rootInjector);
        this.parentInjector = injectorWithHostBoundary.injector;
        this.hostInjectorBoundary = injectorWithHostBoundary.hostInjectorBoundary;
        var pipes;
        var context;
        switch (proto.type) {
            case view_type_1.ViewType.COMPONENT:
                pipes = new pipes_2.Pipes(proto.protoPipes, containerAppElement.getInjector());
                context = containerAppElement.getComponent();
                break;
            case view_type_1.ViewType.EMBEDDED:
                pipes = containerAppElement.parentView.pipes;
                context = containerAppElement.parentView.context;
                break;
            case view_type_1.ViewType.HOST:
                pipes = null;
                context = EMPTY_CONTEXT;
                break;
        }
        this.pipes = pipes;
        this.context = context;
    }
    AppView.prototype.init = function (rootNodesOrAppElements, allNodes, disposables, appElements) {
        this.rootNodesOrAppElements = rootNodesOrAppElements;
        this.allNodes = allNodes;
        this.disposables = disposables;
        this.appElements = appElements;
        var localsMap = new collection_1.Map();
        collection_1.StringMapWrapper.forEach(this.proto.templateVariableBindings, function (templateName, _) { localsMap.set(templateName, null); });
        for (var i = 0; i < appElements.length; i++) {
            var appEl = appElements[i];
            collection_1.StringMapWrapper.forEach(appEl.proto.directiveVariableBindings, function (directiveIndex, name) {
                if (lang_1.isBlank(directiveIndex)) {
                    localsMap.set(name, appEl.nativeElement);
                }
                else {
                    localsMap.set(name, appEl.getDirectiveAtIndex(directiveIndex));
                }
            });
        }
        var parentLocals = null;
        if (this.proto.type !== view_type_1.ViewType.COMPONENT) {
            parentLocals =
                lang_1.isPresent(this.containerAppElement) ? this.containerAppElement.parentView.locals : null;
        }
        if (this.proto.type === view_type_1.ViewType.COMPONENT) {
            // Note: the render nodes have been attached to their host element
            // in the ViewFactory already.
            this.containerAppElement.attachComponentView(this);
            this.containerAppElement.parentView.changeDetector.addViewChild(this.changeDetector);
        }
        this.locals = new change_detection_1.Locals(parentLocals, localsMap);
        this.changeDetector.hydrate(this.context, this.locals, this, this.pipes);
        this.viewManager.onViewCreated(this);
    };
    AppView.prototype.destroy = function () {
        if (this.destroyed) {
            throw new exceptions_1.BaseException('This view has already been destroyed!');
        }
        this.changeDetector.destroyRecursive();
    };
    AppView.prototype.notifyOnDestroy = function () {
        this.destroyed = true;
        var hostElement = this.proto.type === view_type_1.ViewType.COMPONENT ? this.containerAppElement.nativeElement : null;
        this.renderer.destroyView(hostElement, this.allNodes);
        for (var i = 0; i < this.disposables.length; i++) {
            this.disposables[i]();
        }
        this.viewManager.onViewDestroyed(this);
    };
    Object.defineProperty(AppView.prototype, "changeDetectorRef", {
        get: function () { return this.changeDetector.ref; },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(AppView.prototype, "flatRootNodes", {
        get: function () { return flattenNestedViewRenderNodes(this.rootNodesOrAppElements); },
        enumerable: true,
        configurable: true
    });
    AppView.prototype.hasLocal = function (contextName) {
        return collection_1.StringMapWrapper.contains(this.proto.templateVariableBindings, contextName);
    };
    AppView.prototype.setLocal = function (contextName, value) {
        if (!this.hasLocal(contextName)) {
            return;
        }
        var templateName = this.proto.templateVariableBindings[contextName];
        this.locals.set(templateName, value);
    };
    // dispatch to element injector or text nodes based on context
    AppView.prototype.notifyOnBinding = function (b, currentValue) {
        if (b.isTextNode()) {
            this.renderer.setText(this.allNodes[b.elementIndex], currentValue);
        }
        else {
            var nativeElement = this.appElements[b.elementIndex].nativeElement;
            if (b.isElementProperty()) {
                this.renderer.setElementProperty(nativeElement, b.name, currentValue);
            }
            else if (b.isElementAttribute()) {
                this.renderer.setElementAttribute(nativeElement, b.name, lang_1.isPresent(currentValue) ? "" + currentValue : null);
            }
            else if (b.isElementClass()) {
                this.renderer.setElementClass(nativeElement, b.name, currentValue);
            }
            else if (b.isElementStyle()) {
                var unit = lang_1.isPresent(b.unit) ? b.unit : '';
                this.renderer.setElementStyle(nativeElement, b.name, lang_1.isPresent(currentValue) ? "" + currentValue + unit : null);
            }
            else {
                throw new exceptions_1.BaseException('Unsupported directive record');
            }
        }
    };
    AppView.prototype.logBindingUpdate = function (b, value) {
        if (b.isDirective() || b.isElementProperty()) {
            var nativeElement = this.appElements[b.elementIndex].nativeElement;
            this.renderer.setBindingDebugInfo(nativeElement, "" + REFLECT_PREFIX + util_1.camelCaseToDashCase(b.name), "" + value);
        }
    };
    AppView.prototype.notifyAfterContentChecked = function () {
        var count = this.appElements.length;
        for (var i = count - 1; i >= 0; i--) {
            this.appElements[i].ngAfterContentChecked();
        }
    };
    AppView.prototype.notifyAfterViewChecked = function () {
        var count = this.appElements.length;
        for (var i = count - 1; i >= 0; i--) {
            this.appElements[i].ngAfterViewChecked();
        }
    };
    AppView.prototype.getDebugContext = function (appElement, elementIndex, directiveIndex) {
        try {
            if (lang_1.isBlank(appElement) && elementIndex < this.appElements.length) {
                appElement = this.appElements[elementIndex];
            }
            var container = this.containerAppElement;
            var element = lang_1.isPresent(appElement) ? appElement.nativeElement : null;
            var componentElement = lang_1.isPresent(container) ? container.nativeElement : null;
            var directive = lang_1.isPresent(directiveIndex) ? appElement.getDirectiveAtIndex(directiveIndex) : null;
            var injector = lang_1.isPresent(appElement) ? appElement.getInjector() : null;
            return new interfaces_1.DebugContext(element, componentElement, directive, this.context, _localsToStringMap(this.locals), injector);
        }
        catch (e) {
            // TODO: vsavkin log the exception once we have a good way to log errors and warnings
            // if an error happens during getting the debug context, we return null.
            return null;
        }
    };
    AppView.prototype.getDirectiveFor = function (directive) {
        return this.appElements[directive.elementIndex].getDirectiveAtIndex(directive.directiveIndex);
    };
    AppView.prototype.getDetectorFor = function (directive) {
        var componentView = this.appElements[directive.elementIndex].componentView;
        return lang_1.isPresent(componentView) ? componentView.changeDetector : null;
    };
    /**
     * Triggers the event handlers for the element and the directives.
     *
     * This method is intended to be called from directive EventEmitters.
     *
     * @param {string} eventName
     * @param {*} eventObj
     * @param {number} boundElementIndex
     * @return false if preventDefault must be applied to the DOM event
     */
    AppView.prototype.triggerEventHandlers = function (eventName, eventObj, boundElementIndex) {
        return this.changeDetector.handleEvent(eventName, boundElementIndex, eventObj);
    };
    return AppView;
})();
exports.AppView = AppView;
function _localsToStringMap(locals) {
    var res = {};
    var c = locals;
    while (lang_1.isPresent(c)) {
        res = collection_1.StringMapWrapper.merge(res, collection_1.MapWrapper.toStringMap(c.current));
        c = c.parent;
    }
    return res;
}
/**
 *
 */
var AppProtoView = (function () {
    function AppProtoView(type, protoPipes, templateVariableBindings) {
        this.type = type;
        this.protoPipes = protoPipes;
        this.templateVariableBindings = templateVariableBindings;
    }
    AppProtoView.create = function (metadataCache, type, pipes, templateVariableBindings) {
        var protoPipes = null;
        if (lang_1.isPresent(pipes) && pipes.length > 0) {
            var boundPipes = collection_1.ListWrapper.createFixedSize(pipes.length);
            for (var i = 0; i < pipes.length; i++) {
                boundPipes[i] = metadataCache.getResolvedPipeMetadata(pipes[i]);
            }
            protoPipes = pipes_1.ProtoPipes.fromProviders(boundPipes);
        }
        return new AppProtoView(type, protoPipes, templateVariableBindings);
    };
    return AppProtoView;
})();
exports.AppProtoView = AppProtoView;
var HostViewFactory = (function () {
    function HostViewFactory(selector, viewFactory) {
        this.selector = selector;
        this.viewFactory = viewFactory;
    }
    HostViewFactory = __decorate([
        lang_1.CONST(), 
        __metadata('design:paramtypes', [String, Function])
    ], HostViewFactory);
    return HostViewFactory;
})();
exports.HostViewFactory = HostViewFactory;
function flattenNestedViewRenderNodes(nodes) {
    return _flattenNestedViewRenderNodes(nodes, []);
}
exports.flattenNestedViewRenderNodes = flattenNestedViewRenderNodes;
function _flattenNestedViewRenderNodes(nodes, renderNodes) {
    for (var i = 0; i < nodes.length; i++) {
        var node = nodes[i];
        if (node instanceof element_1.AppElement) {
            var appEl = node;
            renderNodes.push(appEl.nativeElement);
            if (lang_1.isPresent(appEl.nestedViews)) {
                for (var k = 0; k < appEl.nestedViews.length; k++) {
                    _flattenNestedViewRenderNodes(appEl.nestedViews[k].rootNodesOrAppElements, renderNodes);
                }
            }
        }
        else {
            renderNodes.push(node);
        }
    }
    return renderNodes;
}
function checkSlotCount(componentName, expectedSlotCount, projectableNodes) {
    var givenSlotCount = lang_1.isPresent(projectableNodes) ? projectableNodes.length : 0;
    if (givenSlotCount < expectedSlotCount) {
        throw new exceptions_1.BaseException(("The component " + componentName + " has " + expectedSlotCount + " <ng-content> elements,") +
            (" but only " + givenSlotCount + " slots were provided."));
    }
}
exports.checkSlotCount = checkSlotCount;
//# sourceMappingURL=data:application/json;base64,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