'use strict';var __extends = (this && this.__extends) || function (d, b) {
    for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p];
    function __() { this.constructor = d; }
    d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
};
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var __param = (this && this.__param) || function (paramIndex, decorator) {
    return function (target, key) { decorator(target, key, paramIndex); }
};
var di_1 = require('angular2/src/core/di');
var lang_1 = require('angular2/src/facade/lang');
var collection_1 = require('angular2/src/facade/collection');
var exceptions_1 = require('angular2/src/facade/exceptions');
var view_1 = require('./view');
var element_1 = require('./element');
var view_listener_1 = require('./view_listener');
var api_1 = require('angular2/src/core/render/api');
var profile_1 = require('../profile/profile');
var application_tokens_1 = require('angular2/src/core/application_tokens');
var view_type_1 = require('./view_type');
/**
 * Service exposing low level API for creating, moving and destroying Views.
 *
 * Most applications should use higher-level abstractions like {@link DynamicComponentLoader} and
 * {@link ViewContainerRef} instead.
 */
var AppViewManager = (function () {
    function AppViewManager() {
    }
    return AppViewManager;
})();
exports.AppViewManager = AppViewManager;
var AppViewManager_ = (function (_super) {
    __extends(AppViewManager_, _super);
    function AppViewManager_(_renderer, _viewListener, _appId) {
        _super.call(this);
        this._renderer = _renderer;
        this._viewListener = _viewListener;
        this._appId = _appId;
        this._nextCompTypeId = 0;
        /** @internal */
        this._createRootHostViewScope = profile_1.wtfCreateScope('AppViewManager#createRootHostView()');
        /** @internal */
        this._destroyRootHostViewScope = profile_1.wtfCreateScope('AppViewManager#destroyRootHostView()');
        /** @internal */
        this._createEmbeddedViewInContainerScope = profile_1.wtfCreateScope('AppViewManager#createEmbeddedViewInContainer()');
        /** @internal */
        this._createHostViewInContainerScope = profile_1.wtfCreateScope('AppViewManager#createHostViewInContainer()');
        /** @internal */
        this._destroyViewInContainerScope = profile_1.wtfCreateScope('AppViewMananger#destroyViewInContainer()');
        /** @internal */
        this._attachViewInContainerScope = profile_1.wtfCreateScope('AppViewMananger#attachViewInContainer()');
        /** @internal */
        this._detachViewInContainerScope = profile_1.wtfCreateScope('AppViewMananger#detachViewInContainer()');
    }
    AppViewManager_.prototype.getViewContainer = function (location) {
        return location.internalElement.getViewContainerRef();
    };
    AppViewManager_.prototype.getHostElement = function (hostViewRef) {
        var hostView = hostViewRef.internalView;
        if (hostView.proto.type !== view_type_1.ViewType.HOST) {
            throw new exceptions_1.BaseException('This operation is only allowed on host views');
        }
        return hostView.appElements[0].ref;
    };
    AppViewManager_.prototype.getNamedElementInComponentView = function (hostLocation, variableName) {
        var appEl = hostLocation.internalElement;
        var componentView = appEl.componentView;
        if (lang_1.isBlank(componentView)) {
            throw new exceptions_1.BaseException("There is no component directive at element " + hostLocation);
        }
        for (var i = 0; i < componentView.appElements.length; i++) {
            var compAppEl = componentView.appElements[i];
            if (collection_1.StringMapWrapper.contains(compAppEl.proto.directiveVariableBindings, variableName)) {
                return compAppEl.ref;
            }
        }
        throw new exceptions_1.BaseException("Could not find variable " + variableName);
    };
    AppViewManager_.prototype.getComponent = function (hostLocation) {
        return hostLocation.internalElement.getComponent();
    };
    AppViewManager_.prototype.createRootHostView = function (hostViewFactoryRef, overrideSelector, injector, projectableNodes) {
        if (projectableNodes === void 0) { projectableNodes = null; }
        var s = this._createRootHostViewScope();
        var hostViewFactory = hostViewFactoryRef.internalHostViewFactory;
        var selector = lang_1.isPresent(overrideSelector) ? overrideSelector : hostViewFactory.selector;
        var view = hostViewFactory.viewFactory(this._renderer, this, null, projectableNodes, selector, null, injector);
        return profile_1.wtfLeave(s, view.ref);
    };
    AppViewManager_.prototype.destroyRootHostView = function (hostViewRef) {
        var s = this._destroyRootHostViewScope();
        var hostView = hostViewRef.internalView;
        hostView.renderer.detachView(view_1.flattenNestedViewRenderNodes(hostView.rootNodesOrAppElements));
        hostView.destroy();
        profile_1.wtfLeave(s);
    };
    AppViewManager_.prototype.createEmbeddedViewInContainer = function (viewContainerLocation, index, templateRef) {
        var s = this._createEmbeddedViewInContainerScope();
        var contextEl = templateRef.elementRef.internalElement;
        var view = contextEl.embeddedViewFactory(contextEl.parentView.renderer, this, contextEl, contextEl.parentView.projectableNodes, null, null, null);
        this._attachViewToContainer(view, viewContainerLocation.internalElement, index);
        return profile_1.wtfLeave(s, view.ref);
    };
    AppViewManager_.prototype.createHostViewInContainer = function (viewContainerLocation, index, hostViewFactoryRef, dynamicallyCreatedProviders, projectableNodes) {
        var s = this._createHostViewInContainerScope();
        // TODO(tbosch): This should be specifiable via an additional argument!
        var viewContainerLocation_ = viewContainerLocation;
        var contextEl = viewContainerLocation_.internalElement;
        var hostViewFactory = hostViewFactoryRef.internalHostViewFactory;
        var view = hostViewFactory.viewFactory(contextEl.parentView.renderer, contextEl.parentView.viewManager, contextEl, projectableNodes, null, dynamicallyCreatedProviders, null);
        this._attachViewToContainer(view, viewContainerLocation_.internalElement, index);
        return profile_1.wtfLeave(s, view.ref);
    };
    AppViewManager_.prototype.destroyViewInContainer = function (viewContainerLocation, index) {
        var s = this._destroyViewInContainerScope();
        var view = this._detachViewInContainer(viewContainerLocation.internalElement, index);
        view.destroy();
        profile_1.wtfLeave(s);
    };
    // TODO(i): refactor detachViewInContainer+attachViewInContainer to moveViewInContainer
    AppViewManager_.prototype.attachViewInContainer = function (viewContainerLocation, index, viewRef) {
        var viewRef_ = viewRef;
        var s = this._attachViewInContainerScope();
        this._attachViewToContainer(viewRef_.internalView, viewContainerLocation.internalElement, index);
        return profile_1.wtfLeave(s, viewRef_);
    };
    // TODO(i): refactor detachViewInContainer+attachViewInContainer to moveViewInContainer
    AppViewManager_.prototype.detachViewInContainer = function (viewContainerLocation, index) {
        var s = this._detachViewInContainerScope();
        var view = this._detachViewInContainer(viewContainerLocation.internalElement, index);
        return profile_1.wtfLeave(s, view.ref);
    };
    /** @internal */
    AppViewManager_.prototype.onViewCreated = function (view) { this._viewListener.onViewCreated(view); };
    /** @internal */
    AppViewManager_.prototype.onViewDestroyed = function (view) { this._viewListener.onViewDestroyed(view); };
    /** @internal */
    AppViewManager_.prototype.createRenderComponentType = function (encapsulation, styles) {
        return new api_1.RenderComponentType(this._appId + "-" + this._nextCompTypeId++, encapsulation, styles);
    };
    AppViewManager_.prototype._attachViewToContainer = function (view, vcAppElement, viewIndex) {
        if (view.proto.type === view_type_1.ViewType.COMPONENT) {
            throw new exceptions_1.BaseException("Component views can't be moved!");
        }
        var nestedViews = vcAppElement.nestedViews;
        if (nestedViews == null) {
            nestedViews = [];
            vcAppElement.nestedViews = nestedViews;
        }
        collection_1.ListWrapper.insert(nestedViews, viewIndex, view);
        var refNode;
        if (viewIndex > 0) {
            var prevView = nestedViews[viewIndex - 1];
            refNode = prevView.rootNodesOrAppElements.length > 0 ?
                prevView.rootNodesOrAppElements[prevView.rootNodesOrAppElements.length - 1] :
                null;
        }
        else {
            refNode = vcAppElement.nativeElement;
        }
        if (lang_1.isPresent(refNode)) {
            var refRenderNode;
            if (refNode instanceof element_1.AppElement) {
                refRenderNode = refNode.nativeElement;
            }
            else {
                refRenderNode = refNode;
            }
            view.renderer.attachViewAfter(refRenderNode, view_1.flattenNestedViewRenderNodes(view.rootNodesOrAppElements));
        }
        // TODO: This is only needed when a view is destroyed,
        // not when it is detached for reordering with ng-for...
        vcAppElement.parentView.changeDetector.addContentChild(view.changeDetector);
        vcAppElement.traverseAndSetQueriesAsDirty();
    };
    AppViewManager_.prototype._detachViewInContainer = function (vcAppElement, viewIndex) {
        var view = collection_1.ListWrapper.removeAt(vcAppElement.nestedViews, viewIndex);
        if (view.proto.type === view_type_1.ViewType.COMPONENT) {
            throw new exceptions_1.BaseException("Component views can't be moved!");
        }
        vcAppElement.traverseAndSetQueriesAsDirty();
        view.renderer.detachView(view_1.flattenNestedViewRenderNodes(view.rootNodesOrAppElements));
        // TODO: This is only needed when a view is destroyed,
        // not when it is detached for reordering with ng-for...
        view.changeDetector.remove();
        return view;
    };
    AppViewManager_ = __decorate([
        di_1.Injectable(),
        __param(2, di_1.Inject(application_tokens_1.APP_ID)), 
        __metadata('design:paramtypes', [api_1.RootRenderer, view_listener_1.AppViewListener, String])
    ], AppViewManager_);
    return AppViewManager_;
})(AppViewManager);
exports.AppViewManager_ = AppViewManager_;
//# sourceMappingURL=data:application/json;base64,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