import { ChangeDetectorRef } from '../change_detection/change_detector_ref';
import { AppView } from './view';
export declare abstract class ViewRef extends ChangeDetectorRef {
    destroyed: boolean;
    abstract onDestroy(callback: Function): any;
}
/**
 * Represents an Angular View.
 *
 * <!-- TODO: move the next two paragraphs to the dev guide -->
 * A View is a fundamental building block of the application UI. It is the smallest grouping of
 * Elements which are created and destroyed together.
 *
 * Properties of elements in a View can change, but the structure (number and order) of elements in
 * a View cannot. Changing the structure of Elements can only be done by inserting, moving or
 * removing nested Views via a {@link ViewContainerRef}. Each View can contain many View Containers.
 * <!-- /TODO -->
 *
 * ### Example
 *
 * Given this template...
 *
 * ```
 * Count: {{items.length}}
 * <ul>
 *   <li *ngFor="let  item of items">{{item}}</li>
 * </ul>
 * ```
 *
 * ... we have two {@link ProtoViewRef}s:
 *
 * Outer {@link ProtoViewRef}:
 * ```
 * Count: {{items.length}}
 * <ul>
 *   <template ngFor let-item [ngForOf]="items"></template>
 * </ul>
 * ```
 *
 * Inner {@link ProtoViewRef}:
 * ```
 *   <li>{{item}}</li>
 * ```
 *
 * Notice that the original template is broken down into two separate {@link ProtoViewRef}s.
 *
 * The outer/inner {@link ProtoViewRef}s are then assembled into views like so:
 *
 * ```
 * <!-- ViewRef: outer-0 -->
 * Count: 2
 * <ul>
 *   <template view-container-ref></template>
 *   <!-- ViewRef: inner-1 --><li>first</li><!-- /ViewRef: inner-1 -->
 *   <!-- ViewRef: inner-2 --><li>second</li><!-- /ViewRef: inner-2 -->
 * </ul>
 * <!-- /ViewRef: outer-0 -->
 * ```
 */
export declare abstract class EmbeddedViewRef extends ViewRef {
    /**
     * Sets `value` of local variable called `variableName` in this View.
     */
    abstract setLocal(variableName: string, value: any): void;
    /**
     * Checks whether this view has a local variable called `variableName`.
     */
    abstract hasLocal(variableName: string): boolean;
    rootNodes: any[];
    /**
     * Destroys the view and all of the data structures associated with it.
     */
    abstract destroy(): any;
}
export declare class ViewRef_ implements EmbeddedViewRef {
    private _view;
    constructor(_view: AppView<any>);
    internalView: AppView<any>;
    /**
     * Return `ChangeDetectorRef`
     */
    changeDetectorRef: ChangeDetectorRef;
    rootNodes: any[];
    setLocal(variableName: string, value: any): void;
    hasLocal(variableName: string): boolean;
    destroyed: boolean;
    markForCheck(): void;
    detach(): void;
    detectChanges(): void;
    checkNoChanges(): void;
    reattach(): void;
    onDestroy(callback: Function): void;
    destroy(): void;
}
