'use strict';var lang_1 = require('angular2/src/facade/lang');
var di_1 = require('angular2/src/core/di');
var dom_adapter_1 = require('angular2/src/platform/dom/dom_adapter');
var debug_node_1 = require('angular2/src/core/debug/debug_node');
var dom_renderer_1 = require('angular2/src/platform/dom/dom_renderer');
var core_1 = require('angular2/core');
var debug_renderer_1 = require('angular2/src/core/debug/debug_renderer');
var INSPECT_GLOBAL_NAME = 'ng.probe';
/**
 * Returns a {@link DebugElement} for the given native DOM element, or
 * null if the given native element does not have an Angular view associated
 * with it.
 */
function inspectNativeElement(element) {
    return debug_node_1.getDebugNode(element);
}
exports.inspectNativeElement = inspectNativeElement;
function _createConditionalRootRenderer(rootRenderer) {
    if (lang_1.assertionsEnabled()) {
        return _createRootRenderer(rootRenderer);
    }
    return rootRenderer;
}
function _createRootRenderer(rootRenderer) {
    dom_adapter_1.DOM.setGlobalVar(INSPECT_GLOBAL_NAME, inspectNativeElement);
    return new debug_renderer_1.DebugDomRootRenderer(rootRenderer);
}
/**
 * Providers which support debugging Angular applications (e.g. via `ng.probe`).
 */
exports.ELEMENT_PROBE_PROVIDERS = lang_1.CONST_EXPR([
    new di_1.Provider(core_1.RootRenderer, { useFactory: _createConditionalRootRenderer, deps: [dom_renderer_1.DomRootRenderer] })
]);
exports.ELEMENT_PROBE_PROVIDERS_PROD_MODE = lang_1.CONST_EXPR([new di_1.Provider(core_1.RootRenderer, { useFactory: _createRootRenderer, deps: [dom_renderer_1.DomRootRenderer] })]);
//# sourceMappingURL=data:application/json;base64,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