var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
import { isPresent, isBlank, IS_DART, CONST_EXPR } from 'angular2/src/facade/lang';
import { ListWrapper } from 'angular2/src/facade/collection';
import { templateVisitAll } from './template_ast';
import { SourceExpression } from './source_module';
import { AppView, flattenNestedViewRenderNodes, checkSlotCount } from 'angular2/src/core/linker/view';
import { ViewType } from 'angular2/src/core/linker/view_type';
import { AppElement } from 'angular2/src/core/linker/element';
import { ViewEncapsulation } from 'angular2/src/core/metadata/view';
import { escapeSingleQuoteString, codeGenValueFn, codeGenFnHeader, Statement, escapeValue, codeGenArray, codeGenFlatArray, Expression, flattenArray, CONST_VAR } from './util';
import { Injectable } from 'angular2/src/core/di';
import { APP_VIEW_MODULE_REF, APP_EL_MODULE_REF, METADATA_MODULE_REF } from './proto_view_compiler';
export const VIEW_JIT_IMPORTS = CONST_EXPR({
    'AppView': AppView,
    'AppElement': AppElement,
    'flattenNestedViewRenderNodes': flattenNestedViewRenderNodes,
    'checkSlotCount': checkSlotCount
});
export let ViewCompiler = class {
    constructor() {
    }
    compileComponentRuntime(component, template, styles, protoViews, changeDetectorFactories, componentViewFactory) {
        var viewFactory = new RuntimeViewFactory(component, styles, protoViews, changeDetectorFactories, componentViewFactory);
        return viewFactory.createViewFactory(template, 0, []);
    }
    compileComponentCodeGen(component, template, styles, protoViews, changeDetectorFactoryExpressions, componentViewFactory) {
        var viewFactory = new CodeGenViewFactory(component, styles, protoViews, changeDetectorFactoryExpressions, componentViewFactory);
        var targetStatements = [];
        var viewFactoryExpression = viewFactory.createViewFactory(template, 0, targetStatements);
        return new SourceExpression(targetStatements.map(stmt => stmt.statement), viewFactoryExpression.expression);
    }
};
ViewCompiler = __decorate([
    Injectable(), 
    __metadata('design:paramtypes', [])
], ViewCompiler);
class CodeGenViewFactory {
    constructor(component, styles, protoViews, changeDetectorExpressions, componentViewFactory) {
        this.component = component;
        this.styles = styles;
        this.protoViews = protoViews;
        this.changeDetectorExpressions = changeDetectorExpressions;
        this.componentViewFactory = componentViewFactory;
        this._nextVarId = 0;
    }
    _nextVar(prefix) {
        return `${prefix}${this._nextVarId++}_${this.component.type.name}`;
    }
    _nextRenderVar() { return this._nextVar('render'); }
    _nextAppVar() { return this._nextVar('app'); }
    _nextDisposableVar() {
        return `disposable${this._nextVarId++}_${this.component.type.name}`;
    }
    createText(renderer, parent, text, targetStatements) {
        var varName = this._nextRenderVar();
        var statement = `var ${varName} = ${renderer.expression}.createText(${isPresent(parent) ? parent.expression : null}, ${escapeSingleQuoteString(text)});`;
        targetStatements.push(new Statement(statement));
        return new Expression(varName);
    }
    createElement(renderer, parentRenderNode, name, rootSelector, targetStatements) {
        var varName = this._nextRenderVar();
        var valueExpr;
        if (isPresent(rootSelector)) {
            valueExpr = `${rootSelector.expression} == null ?
        ${renderer.expression}.createElement(${isPresent(parentRenderNode) ? parentRenderNode.expression : null}, ${escapeSingleQuoteString(name)}) :
        ${renderer.expression}.selectRootElement(${rootSelector.expression});`;
        }
        else {
            valueExpr =
                `${renderer.expression}.createElement(${isPresent(parentRenderNode) ? parentRenderNode.expression : null}, ${escapeSingleQuoteString(name)})`;
        }
        var statement = `var ${varName} = ${valueExpr};`;
        targetStatements.push(new Statement(statement));
        return new Expression(varName);
    }
    createTemplateAnchor(renderer, parentRenderNode, targetStatements) {
        var varName = this._nextRenderVar();
        var valueExpr = `${renderer.expression}.createTemplateAnchor(${isPresent(parentRenderNode) ? parentRenderNode.expression : null});`;
        targetStatements.push(new Statement(`var ${varName} = ${valueExpr}`));
        return new Expression(varName);
    }
    createGlobalEventListener(renderer, appView, boundElementIndex, eventAst, targetStatements) {
        var disposableVar = this._nextDisposableVar();
        var eventHandlerExpr = codeGenEventHandler(appView, boundElementIndex, eventAst.fullName);
        targetStatements.push(new Statement(`var ${disposableVar} = ${renderer.expression}.listenGlobal(${escapeValue(eventAst.target)}, ${escapeValue(eventAst.name)}, ${eventHandlerExpr});`));
        return new Expression(disposableVar);
    }
    createElementEventListener(renderer, appView, boundElementIndex, renderNode, eventAst, targetStatements) {
        var disposableVar = this._nextDisposableVar();
        var eventHandlerExpr = codeGenEventHandler(appView, boundElementIndex, eventAst.fullName);
        targetStatements.push(new Statement(`var ${disposableVar} = ${renderer.expression}.listen(${renderNode.expression}, ${escapeValue(eventAst.name)}, ${eventHandlerExpr});`));
        return new Expression(disposableVar);
    }
    setElementAttribute(renderer, renderNode, attrName, attrValue, targetStatements) {
        targetStatements.push(new Statement(`${renderer.expression}.setElementAttribute(${renderNode.expression}, ${escapeSingleQuoteString(attrName)}, ${escapeSingleQuoteString(attrValue)});`));
    }
    createAppElement(appProtoEl, appView, renderNode, parentAppEl, embeddedViewFactory, targetStatements) {
        var appVar = this._nextAppVar();
        var varValue = `new ${APP_EL_MODULE_REF}AppElement(${appProtoEl.expression}, ${appView.expression},
      ${isPresent(parentAppEl) ? parentAppEl.expression : null}, ${renderNode.expression}, ${isPresent(embeddedViewFactory) ? embeddedViewFactory.expression : null})`;
        targetStatements.push(new Statement(`var ${appVar} = ${varValue};`));
        return new Expression(appVar);
    }
    createAndSetComponentView(renderer, viewManager, view, appEl, component, contentNodesByNgContentIndex, targetStatements) {
        var codeGenContentNodes;
        if (this.component.type.isHost) {
            codeGenContentNodes = `${view.expression}.projectableNodes`;
        }
        else {
            codeGenContentNodes =
                `[${contentNodesByNgContentIndex.map(nodes => codeGenFlatArray(nodes)).join(',')}]`;
        }
        targetStatements.push(new Statement(`${this.componentViewFactory(component)}(${renderer.expression}, ${viewManager.expression}, ${appEl.expression}, ${codeGenContentNodes}, null, null, null);`));
    }
    getProjectedNodes(projectableNodes, ngContentIndex) {
        return new Expression(`${projectableNodes.expression}[${ngContentIndex}]`, true);
    }
    appendProjectedNodes(renderer, parent, nodes, targetStatements) {
        targetStatements.push(new Statement(`${renderer.expression}.projectNodes(${parent.expression}, ${APP_VIEW_MODULE_REF}flattenNestedViewRenderNodes(${nodes.expression}));`));
    }
    createViewFactory(asts, embeddedTemplateIndex, targetStatements) {
        var compileProtoView = this.protoViews[embeddedTemplateIndex];
        var isHostView = this.component.type.isHost;
        var isComponentView = embeddedTemplateIndex === 0 && !isHostView;
        var visitor = new ViewBuilderVisitor(new Expression('renderer'), new Expression('viewManager'), new Expression('projectableNodes'), isHostView ? new Expression('rootSelector') : null, new Expression('view'), compileProtoView, targetStatements, this);
        templateVisitAll(visitor, asts, new ParentElement(isComponentView ? new Expression('parentRenderNode') : null, null, null));
        var appProtoView = compileProtoView.protoView.expression;
        var viewFactoryName = codeGenViewFactoryName(this.component, embeddedTemplateIndex);
        var changeDetectorFactory = this.changeDetectorExpressions.expressions[embeddedTemplateIndex];
        var factoryArgs = [
            'parentRenderer',
            'viewManager',
            'containerEl',
            'projectableNodes',
            'rootSelector',
            'dynamicallyCreatedProviders',
            'rootInjector'
        ];
        var initRendererStmts = [];
        var rendererExpr = `parentRenderer`;
        if (embeddedTemplateIndex === 0) {
            var renderCompTypeVar = this._nextVar('renderType');
            targetStatements.push(new Statement(`var ${renderCompTypeVar} = null;`));
            var stylesVar = this._nextVar('styles');
            targetStatements.push(new Statement(`${CONST_VAR} ${stylesVar} = ${this.styles.expression};`));
            var encapsulation = this.component.template.encapsulation;
            initRendererStmts.push(`if (${renderCompTypeVar} == null) {
        ${renderCompTypeVar} = viewManager.createRenderComponentType(${codeGenViewEncapsulation(encapsulation)}, ${stylesVar});
      }`);
            rendererExpr = `parentRenderer.renderComponent(${renderCompTypeVar})`;
        }
        var statement = `
${codeGenFnHeader(factoryArgs, viewFactoryName)}{
  ${initRendererStmts.join('\n')}
  var renderer = ${rendererExpr};
  var view = new ${APP_VIEW_MODULE_REF}AppView(
    ${appProtoView}, renderer, viewManager,
    projectableNodes,
    containerEl,
    dynamicallyCreatedProviders, rootInjector,
    ${changeDetectorFactory}()
  );
  ${APP_VIEW_MODULE_REF}checkSlotCount(${escapeValue(this.component.type.name)}, ${this.component.template.ngContentSelectors.length}, projectableNodes);
  ${isComponentView ? 'var parentRenderNode = renderer.createViewRoot(view.containerAppElement.nativeElement);' : ''}
  ${visitor.renderStmts.map(stmt => stmt.statement).join('\n')}
  ${visitor.appStmts.map(stmt => stmt.statement).join('\n')}

  view.init(${codeGenFlatArray(visitor.rootNodesOrAppElements)}, ${codeGenArray(visitor.renderNodes)}, ${codeGenArray(visitor.appDisposables)},
            ${codeGenArray(visitor.appElements)});
  return view;
}`;
        targetStatements.push(new Statement(statement));
        return new Expression(viewFactoryName);
    }
}
class RuntimeViewFactory {
    constructor(component, styles, protoViews, changeDetectorFactories, componentViewFactory) {
        this.component = component;
        this.styles = styles;
        this.protoViews = protoViews;
        this.changeDetectorFactories = changeDetectorFactories;
        this.componentViewFactory = componentViewFactory;
    }
    createText(renderer, parent, text, targetStatements) {
        return renderer.createText(parent, text);
    }
    createElement(renderer, parent, name, rootSelector, targetStatements) {
        var el;
        if (isPresent(rootSelector)) {
            el = renderer.selectRootElement(rootSelector);
        }
        else {
            el = renderer.createElement(parent, name);
        }
        return el;
    }
    createTemplateAnchor(renderer, parent, targetStatements) {
        return renderer.createTemplateAnchor(parent);
    }
    createGlobalEventListener(renderer, appView, boundElementIndex, eventAst, targetStatements) {
        return renderer.listenGlobal(eventAst.target, eventAst.name, (event) => appView.triggerEventHandlers(eventAst.fullName, event, boundElementIndex));
    }
    createElementEventListener(renderer, appView, boundElementIndex, renderNode, eventAst, targetStatements) {
        return renderer.listen(renderNode, eventAst.name, (event) => appView.triggerEventHandlers(eventAst.fullName, event, boundElementIndex));
    }
    setElementAttribute(renderer, renderNode, attrName, attrValue, targetStatements) {
        renderer.setElementAttribute(renderNode, attrName, attrValue);
    }
    createAppElement(appProtoEl, appView, renderNode, parentAppEl, embeddedViewFactory, targetStatements) {
        return new AppElement(appProtoEl, appView, parentAppEl, renderNode, embeddedViewFactory);
    }
    createAndSetComponentView(renderer, viewManager, appView, appEl, component, contentNodesByNgContentIndex, targetStatements) {
        var flattenedContentNodes;
        if (this.component.type.isHost) {
            flattenedContentNodes = appView.projectableNodes;
        }
        else {
            flattenedContentNodes = ListWrapper.createFixedSize(contentNodesByNgContentIndex.length);
            for (var i = 0; i < contentNodesByNgContentIndex.length; i++) {
                flattenedContentNodes[i] = flattenArray(contentNodesByNgContentIndex[i], []);
            }
        }
        this.componentViewFactory(component)(renderer, viewManager, appEl, flattenedContentNodes);
    }
    getProjectedNodes(projectableNodes, ngContentIndex) {
        return projectableNodes[ngContentIndex];
    }
    appendProjectedNodes(renderer, parent, nodes, targetStatements) {
        renderer.projectNodes(parent, flattenNestedViewRenderNodes(nodes));
    }
    createViewFactory(asts, embeddedTemplateIndex, targetStatements) {
        var compileProtoView = this.protoViews[embeddedTemplateIndex];
        var isComponentView = compileProtoView.protoView.type === ViewType.COMPONENT;
        var renderComponentType = null;
        return (parentRenderer, viewManager, containerEl, projectableNodes, rootSelector = null, dynamicallyCreatedProviders = null, rootInjector = null) => {
            checkSlotCount(this.component.type.name, this.component.template.ngContentSelectors.length, projectableNodes);
            var renderer;
            if (embeddedTemplateIndex === 0) {
                if (isBlank(renderComponentType)) {
                    renderComponentType = viewManager.createRenderComponentType(this.component.template.encapsulation, this.styles);
                }
                renderer = parentRenderer.renderComponent(renderComponentType);
            }
            else {
                renderer = parentRenderer;
            }
            var changeDetector = this.changeDetectorFactories[embeddedTemplateIndex]();
            var view = new AppView(compileProtoView.protoView, renderer, viewManager, projectableNodes, containerEl, dynamicallyCreatedProviders, rootInjector, changeDetector);
            var visitor = new ViewBuilderVisitor(renderer, viewManager, projectableNodes, rootSelector, view, compileProtoView, [], this);
            var parentRenderNode = isComponentView ? renderer.createViewRoot(containerEl.nativeElement) : null;
            templateVisitAll(visitor, asts, new ParentElement(parentRenderNode, null, null));
            view.init(flattenArray(visitor.rootNodesOrAppElements, []), visitor.renderNodes, visitor.appDisposables, visitor.appElements);
            return view;
        };
    }
}
class ParentElement {
    constructor(renderNode, appEl, component) {
        this.renderNode = renderNode;
        this.appEl = appEl;
        this.component = component;
        if (isPresent(component)) {
            this.contentNodesByNgContentIndex =
                ListWrapper.createFixedSize(component.template.ngContentSelectors.length);
            for (var i = 0; i < this.contentNodesByNgContentIndex.length; i++) {
                this.contentNodesByNgContentIndex[i] = [];
            }
        }
        else {
            this.contentNodesByNgContentIndex = null;
        }
    }
    addContentNode(ngContentIndex, nodeExpr) {
        this.contentNodesByNgContentIndex[ngContentIndex].push(nodeExpr);
    }
}
class ViewBuilderVisitor {
    constructor(renderer, viewManager, projectableNodes, rootSelector, view, protoView, targetStatements, factory) {
        this.renderer = renderer;
        this.viewManager = viewManager;
        this.projectableNodes = projectableNodes;
        this.rootSelector = rootSelector;
        this.view = view;
        this.protoView = protoView;
        this.targetStatements = targetStatements;
        this.factory = factory;
        this.renderStmts = [];
        this.renderNodes = [];
        this.appStmts = [];
        this.appElements = [];
        this.appDisposables = [];
        this.rootNodesOrAppElements = [];
        this.elementCount = 0;
    }
    _addRenderNode(renderNode, appEl, ngContentIndex, parent) {
        this.renderNodes.push(renderNode);
        if (isPresent(parent.component)) {
            if (isPresent(ngContentIndex)) {
                parent.addContentNode(ngContentIndex, isPresent(appEl) ? appEl : renderNode);
            }
        }
        else if (isBlank(parent.renderNode)) {
            this.rootNodesOrAppElements.push(isPresent(appEl) ? appEl : renderNode);
        }
    }
    _getParentRenderNode(ngContentIndex, parent) {
        return isPresent(parent.component) &&
            parent.component.template.encapsulation !== ViewEncapsulation.Native ?
            null :
            parent.renderNode;
    }
    visitBoundText(ast, parent) {
        return this._visitText('', ast.ngContentIndex, parent);
    }
    visitText(ast, parent) {
        return this._visitText(ast.value, ast.ngContentIndex, parent);
    }
    _visitText(value, ngContentIndex, parent) {
        var renderNode = this.factory.createText(this.renderer, this._getParentRenderNode(ngContentIndex, parent), value, this.renderStmts);
        this._addRenderNode(renderNode, null, ngContentIndex, parent);
        return null;
    }
    visitNgContent(ast, parent) {
        var nodesExpression = this.factory.getProjectedNodes(this.projectableNodes, ast.index);
        if (isPresent(parent.component)) {
            if (isPresent(ast.ngContentIndex)) {
                parent.addContentNode(ast.ngContentIndex, nodesExpression);
            }
        }
        else {
            if (isPresent(parent.renderNode)) {
                this.factory.appendProjectedNodes(this.renderer, parent.renderNode, nodesExpression, this.renderStmts);
            }
            else {
                this.rootNodesOrAppElements.push(nodesExpression);
            }
        }
        return null;
    }
    visitElement(ast, parent) {
        var renderNode = this.factory.createElement(this.renderer, this._getParentRenderNode(ast.ngContentIndex, parent), ast.name, this.rootSelector, this.renderStmts);
        var component = ast.getComponent();
        var elementIndex = this.elementCount++;
        var protoEl = this.protoView.protoElements[elementIndex];
        protoEl.renderEvents.forEach((eventAst) => {
            var disposable;
            if (isPresent(eventAst.target)) {
                disposable = this.factory.createGlobalEventListener(this.renderer, this.view, protoEl.boundElementIndex, eventAst, this.renderStmts);
            }
            else {
                disposable = this.factory.createElementEventListener(this.renderer, this.view, protoEl.boundElementIndex, renderNode, eventAst, this.renderStmts);
            }
            this.appDisposables.push(disposable);
        });
        for (var i = 0; i < protoEl.attrNameAndValues.length; i++) {
            var attrName = protoEl.attrNameAndValues[i][0];
            var attrValue = protoEl.attrNameAndValues[i][1];
            this.factory.setElementAttribute(this.renderer, renderNode, attrName, attrValue, this.renderStmts);
        }
        var appEl = null;
        if (isPresent(protoEl.appProtoEl)) {
            appEl = this.factory.createAppElement(protoEl.appProtoEl, this.view, renderNode, parent.appEl, null, this.appStmts);
            this.appElements.push(appEl);
        }
        this._addRenderNode(renderNode, appEl, ast.ngContentIndex, parent);
        var newParent = new ParentElement(renderNode, isPresent(appEl) ? appEl : parent.appEl, component);
        templateVisitAll(this, ast.children, newParent);
        if (isPresent(appEl) && isPresent(component)) {
            this.factory.createAndSetComponentView(this.renderer, this.viewManager, this.view, appEl, component, newParent.contentNodesByNgContentIndex, this.appStmts);
        }
        return null;
    }
    visitEmbeddedTemplate(ast, parent) {
        var renderNode = this.factory.createTemplateAnchor(this.renderer, this._getParentRenderNode(ast.ngContentIndex, parent), this.renderStmts);
        var elementIndex = this.elementCount++;
        var protoEl = this.protoView.protoElements[elementIndex];
        var embeddedViewFactory = this.factory.createViewFactory(ast.children, protoEl.embeddedTemplateIndex, this.targetStatements);
        var appEl = this.factory.createAppElement(protoEl.appProtoEl, this.view, renderNode, parent.appEl, embeddedViewFactory, this.appStmts);
        this._addRenderNode(renderNode, appEl, ast.ngContentIndex, parent);
        this.appElements.push(appEl);
        return null;
    }
    visitVariable(ast, ctx) { return null; }
    visitAttr(ast, ctx) { return null; }
    visitDirective(ast, ctx) { return null; }
    visitEvent(ast, ctx) { return null; }
    visitDirectiveProperty(ast, context) { return null; }
    visitElementProperty(ast, context) { return null; }
}
function codeGenEventHandler(view, boundElementIndex, eventName) {
    return codeGenValueFn(['event'], `${view.expression}.triggerEventHandlers(${escapeValue(eventName)}, event, ${boundElementIndex})`);
}
function codeGenViewFactoryName(component, embeddedTemplateIndex) {
    return `viewFactory_${component.type.name}${embeddedTemplateIndex}`;
}
function codeGenViewEncapsulation(value) {
    if (IS_DART) {
        return `${METADATA_MODULE_REF}${value}`;
    }
    else {
        return `${value}`;
    }
}
//# sourceMappingURL=data:application/json;base64,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