'use strict';var lang_1 = require('angular2/src/facade/lang');
var debug_node_1 = require('angular2/src/core/debug/debug_node');
var DebugDomRootRenderer = (function () {
    function DebugDomRootRenderer(_delegate) {
        this._delegate = _delegate;
    }
    DebugDomRootRenderer.prototype.renderComponent = function (componentProto) {
        return new DebugDomRenderer(this, this._delegate.renderComponent(componentProto));
    };
    return DebugDomRootRenderer;
})();
exports.DebugDomRootRenderer = DebugDomRootRenderer;
var DebugDomRenderer = (function () {
    function DebugDomRenderer(_rootRenderer, _delegate) {
        this._rootRenderer = _rootRenderer;
        this._delegate = _delegate;
    }
    DebugDomRenderer.prototype.renderComponent = function (componentType) {
        return this._rootRenderer.renderComponent(componentType);
    };
    DebugDomRenderer.prototype.selectRootElement = function (selector) {
        var nativeEl = this._delegate.selectRootElement(selector);
        var debugEl = new debug_node_1.DebugElement(nativeEl, null);
        debug_node_1.indexDebugNode(debugEl);
        return nativeEl;
    };
    DebugDomRenderer.prototype.createElement = function (parentElement, name) {
        var nativeEl = this._delegate.createElement(parentElement, name);
        var debugEl = new debug_node_1.DebugElement(nativeEl, debug_node_1.getDebugNode(parentElement));
        debugEl.name = name;
        debug_node_1.indexDebugNode(debugEl);
        return nativeEl;
    };
    DebugDomRenderer.prototype.createViewRoot = function (hostElement) { return this._delegate.createViewRoot(hostElement); };
    DebugDomRenderer.prototype.createTemplateAnchor = function (parentElement) {
        var comment = this._delegate.createTemplateAnchor(parentElement);
        var debugEl = new debug_node_1.DebugNode(comment, debug_node_1.getDebugNode(parentElement));
        debug_node_1.indexDebugNode(debugEl);
        return comment;
    };
    DebugDomRenderer.prototype.createText = function (parentElement, value) {
        var text = this._delegate.createText(parentElement, value);
        var debugEl = new debug_node_1.DebugNode(text, debug_node_1.getDebugNode(parentElement));
        debug_node_1.indexDebugNode(debugEl);
        return text;
    };
    DebugDomRenderer.prototype.projectNodes = function (parentElement, nodes) {
        var debugParent = debug_node_1.getDebugNode(parentElement);
        if (lang_1.isPresent(debugParent) && debugParent instanceof debug_node_1.DebugElement) {
            nodes.forEach(function (node) { debugParent.addChild(debug_node_1.getDebugNode(node)); });
        }
        return this._delegate.projectNodes(parentElement, nodes);
    };
    DebugDomRenderer.prototype.attachViewAfter = function (node, viewRootNodes) {
        var debugNode = debug_node_1.getDebugNode(node);
        if (lang_1.isPresent(debugNode)) {
            var debugParent = debugNode.parent;
            if (viewRootNodes.length > 0 && lang_1.isPresent(debugParent)) {
                var debugViewRootNodes = [];
                viewRootNodes.forEach(function (rootNode) { return debugViewRootNodes.push(debug_node_1.getDebugNode(rootNode)); });
                debugParent.insertChildrenAfter(debugNode, debugViewRootNodes);
            }
        }
        return this._delegate.attachViewAfter(node, viewRootNodes);
    };
    DebugDomRenderer.prototype.detachView = function (viewRootNodes) {
        viewRootNodes.forEach(function (node) {
            var debugNode = debug_node_1.getDebugNode(node);
            if (lang_1.isPresent(debugNode) && lang_1.isPresent(debugNode.parent)) {
                debugNode.parent.removeChild(debugNode);
            }
        });
        return this._delegate.detachView(viewRootNodes);
    };
    DebugDomRenderer.prototype.destroyView = function (hostElement, viewAllNodes) {
        viewAllNodes.forEach(function (node) { debug_node_1.removeDebugNodeFromIndex(debug_node_1.getDebugNode(node)); });
        return this._delegate.destroyView(hostElement, viewAllNodes);
    };
    DebugDomRenderer.prototype.listen = function (renderElement, name, callback) {
        var debugEl = debug_node_1.getDebugNode(renderElement);
        if (lang_1.isPresent(debugEl)) {
            debugEl.listeners.push(new debug_node_1.EventListener(name, callback));
        }
        return this._delegate.listen(renderElement, name, callback);
    };
    DebugDomRenderer.prototype.listenGlobal = function (target, name, callback) {
        return this._delegate.listenGlobal(target, name, callback);
    };
    DebugDomRenderer.prototype.setElementProperty = function (renderElement, propertyName, propertyValue) {
        var debugEl = debug_node_1.getDebugNode(renderElement);
        if (lang_1.isPresent(debugEl) && debugEl instanceof debug_node_1.DebugElement) {
            debugEl.properties.set(propertyName, propertyValue);
        }
        return this._delegate.setElementProperty(renderElement, propertyName, propertyValue);
    };
    DebugDomRenderer.prototype.setElementAttribute = function (renderElement, attributeName, attributeValue) {
        var debugEl = debug_node_1.getDebugNode(renderElement);
        if (lang_1.isPresent(debugEl) && debugEl instanceof debug_node_1.DebugElement) {
            debugEl.attributes.set(attributeName, attributeValue);
        }
        return this._delegate.setElementAttribute(renderElement, attributeName, attributeValue);
    };
    /**
     * Used only in debug mode to serialize property changes to comment nodes,
     * such as <template> placeholders.
     */
    DebugDomRenderer.prototype.setBindingDebugInfo = function (renderElement, propertyName, propertyValue) {
        return this._delegate.setBindingDebugInfo(renderElement, propertyName, propertyValue);
    };
    /**
     * Used only in development mode to set information needed by the DebugNode for this element.
     */
    DebugDomRenderer.prototype.setElementDebugInfo = function (renderElement, info) {
        var debugEl = debug_node_1.getDebugNode(renderElement);
        debugEl.setDebugInfo(info);
        return this._delegate.setElementDebugInfo(renderElement, info);
    };
    DebugDomRenderer.prototype.setElementClass = function (renderElement, className, isAdd) {
        return this._delegate.setElementClass(renderElement, className, isAdd);
    };
    DebugDomRenderer.prototype.setElementStyle = function (renderElement, styleName, styleValue) {
        return this._delegate.setElementStyle(renderElement, styleName, styleValue);
    };
    DebugDomRenderer.prototype.invokeElementMethod = function (renderElement, methodName, args) {
        return this._delegate.invokeElementMethod(renderElement, methodName, args);
    };
    DebugDomRenderer.prototype.setText = function (renderNode, text) { return this._delegate.setText(renderNode, text); };
    return DebugDomRenderer;
})();
exports.DebugDomRenderer = DebugDomRenderer;
//# sourceMappingURL=data:application/json;base64,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