var globalScope;
if (typeof window === 'undefined') {
    if (typeof WorkerGlobalScope !== 'undefined' && self instanceof WorkerGlobalScope) {
        // TODO: Replace any with WorkerGlobalScope from lib.webworker.d.ts #3492
        globalScope = self;
    }
    else {
        globalScope = global;
    }
}
else {
    globalScope = window;
}
export const IS_DART = false;
// Need to declare a new variable for global here since TypeScript
// exports the original value of the symbol.
var _global = globalScope;
export { _global as global };
export var Type = Function;
export function getTypeNameForDebugging(type) {
    return type['name'];
}
export var Math = _global.Math;
export var Date = _global.Date;
var _devMode = true;
var _modeLocked = false;
export function lockMode() {
    _modeLocked = true;
}
/**
 * Disable Angular's development mode, which turns off assertions and other
 * checks within the framework.
 *
 * One important assertion this disables verifies that a change detection pass
 * does not result in additional changes to any bindings (also known as
 * unidirectional data flow).
 */
export function enableProdMode() {
    if (_modeLocked) {
        // Cannot use BaseException as that ends up importing from facade/lang.
        throw 'Cannot enable prod mode after platform setup.';
    }
    _devMode = false;
}
export function assertionsEnabled() {
    return _devMode;
}
// TODO: remove calls to assert in production environment
// Note: Can't just export this and import in in other files
// as `assert` is a reserved keyword in Dart
_global.assert = function assert(condition) {
    // TODO: to be fixed properly via #2830, noop for now
};
// This function is needed only to properly support Dart's const expressions
// see https://github.com/angular/ts2dart/pull/151 for more info
export function CONST_EXPR(expr) {
    return expr;
}
export function CONST() {
    return (target) => target;
}
export function isPresent(obj) {
    return obj !== undefined && obj !== null;
}
export function isBlank(obj) {
    return obj === undefined || obj === null;
}
export function isString(obj) {
    return typeof obj === "string";
}
export function isFunction(obj) {
    return typeof obj === "function";
}
export function isType(obj) {
    return isFunction(obj);
}
export function isStringMap(obj) {
    return typeof obj === 'object' && obj !== null;
}
export function isPromise(obj) {
    return obj instanceof _global.Promise;
}
export function isArray(obj) {
    return Array.isArray(obj);
}
export function isNumber(obj) {
    return typeof obj === 'number';
}
export function isDate(obj) {
    return obj instanceof Date && !isNaN(obj.valueOf());
}
export function noop() { }
export function stringify(token) {
    if (typeof token === 'string') {
        return token;
    }
    if (token === undefined || token === null) {
        return '' + token;
    }
    if (token.name) {
        return token.name;
    }
    if (token.overriddenName) {
        return token.overriddenName;
    }
    var res = token.toString();
    var newLineIndex = res.indexOf("\n");
    return (newLineIndex === -1) ? res : res.substring(0, newLineIndex);
}
// serialize / deserialize enum exist only for consistency with dart API
// enums in typescript don't need to be serialized
export function serializeEnum(val) {
    return val;
}
export function deserializeEnum(val, values) {
    return val;
}
export class StringWrapper {
    static fromCharCode(code) { return String.fromCharCode(code); }
    static charCodeAt(s, index) { return s.charCodeAt(index); }
    static split(s, regExp) { return s.split(regExp); }
    static equals(s, s2) { return s === s2; }
    static stripLeft(s, charVal) {
        if (s && s.length) {
            var pos = 0;
            for (var i = 0; i < s.length; i++) {
                if (s[i] != charVal)
                    break;
                pos++;
            }
            s = s.substring(pos);
        }
        return s;
    }
    static stripRight(s, charVal) {
        if (s && s.length) {
            var pos = s.length;
            for (var i = s.length - 1; i >= 0; i--) {
                if (s[i] != charVal)
                    break;
                pos--;
            }
            s = s.substring(0, pos);
        }
        return s;
    }
    static replace(s, from, replace) {
        return s.replace(from, replace);
    }
    static replaceAll(s, from, replace) {
        return s.replace(from, replace);
    }
    static slice(s, from = 0, to = null) {
        return s.slice(from, to === null ? undefined : to);
    }
    static replaceAllMapped(s, from, cb) {
        return s.replace(from, function (...matches) {
            // Remove offset & string from the result array
            matches.splice(-2, 2);
            // The callback receives match, p1, ..., pn
            return cb(matches);
        });
    }
    static contains(s, substr) { return s.indexOf(substr) != -1; }
    static compare(a, b) {
        if (a < b) {
            return -1;
        }
        else if (a > b) {
            return 1;
        }
        else {
            return 0;
        }
    }
}
export class StringJoiner {
    constructor(parts = []) {
        this.parts = parts;
    }
    add(part) { this.parts.push(part); }
    toString() { return this.parts.join(""); }
}
export class NumberParseError extends Error {
    constructor(message) {
        super();
        this.message = message;
    }
    toString() { return this.message; }
}
export class NumberWrapper {
    static toFixed(n, fractionDigits) { return n.toFixed(fractionDigits); }
    static equal(a, b) { return a === b; }
    static parseIntAutoRadix(text) {
        var result = parseInt(text);
        if (isNaN(result)) {
            throw new NumberParseError("Invalid integer literal when parsing " + text);
        }
        return result;
    }
    static parseInt(text, radix) {
        if (radix == 10) {
            if (/^(\-|\+)?[0-9]+$/.test(text)) {
                return parseInt(text, radix);
            }
        }
        else if (radix == 16) {
            if (/^(\-|\+)?[0-9ABCDEFabcdef]+$/.test(text)) {
                return parseInt(text, radix);
            }
        }
        else {
            var result = parseInt(text, radix);
            if (!isNaN(result)) {
                return result;
            }
        }
        throw new NumberParseError("Invalid integer literal when parsing " + text + " in base " +
            radix);
    }
    // TODO: NaN is a valid literal but is returned by parseFloat to indicate an error.
    static parseFloat(text) { return parseFloat(text); }
    static get NaN() { return NaN; }
    static isNaN(value) { return isNaN(value); }
    static isInteger(value) { return Number.isInteger(value); }
}
export var RegExp = _global.RegExp;
export class RegExpWrapper {
    static create(regExpStr, flags = '') {
        flags = flags.replace(/g/g, '');
        return new _global.RegExp(regExpStr, flags + 'g');
    }
    static firstMatch(regExp, input) {
        // Reset multimatch regex state
        regExp.lastIndex = 0;
        return regExp.exec(input);
    }
    static test(regExp, input) {
        regExp.lastIndex = 0;
        return regExp.test(input);
    }
    static matcher(regExp, input) {
        // Reset regex state for the case
        // someone did not loop over all matches
        // last time.
        regExp.lastIndex = 0;
        return { re: regExp, input: input };
    }
}
export class RegExpMatcherWrapper {
    static next(matcher) {
        return matcher.re.exec(matcher.input);
    }
}
export class FunctionWrapper {
    static apply(fn, posArgs) { return fn.apply(null, posArgs); }
}
// JS has NaN !== NaN
export function looseIdentical(a, b) {
    return a === b || typeof a === "number" && typeof b === "number" && isNaN(a) && isNaN(b);
}
// JS considers NaN is the same as NaN for map Key (while NaN !== NaN otherwise)
// see https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Map
export function getMapKey(value) {
    return value;
}
export function normalizeBlank(obj) {
    return isBlank(obj) ? null : obj;
}
export function normalizeBool(obj) {
    return isBlank(obj) ? false : obj;
}
export function isJsObject(o) {
    return o !== null && (typeof o === "function" || typeof o === "object");
}
export function print(obj) {
    console.log(obj);
}
// Can't be all uppercase as our transpiler would think it is a special directive...
export class Json {
    static parse(s) { return _global.JSON.parse(s); }
    static stringify(data) {
        // Dart doesn't take 3 arguments
        return _global.JSON.stringify(data, null, 2);
    }
}
export class DateWrapper {
    static create(year, month = 1, day = 1, hour = 0, minutes = 0, seconds = 0, milliseconds = 0) {
        return new Date(year, month - 1, day, hour, minutes, seconds, milliseconds);
    }
    static fromISOString(str) { return new Date(str); }
    static fromMillis(ms) { return new Date(ms); }
    static toMillis(date) { return date.getTime(); }
    static now() { return new Date(); }
    static toJson(date) { return date.toJSON(); }
}
export function setValueOnPath(global, path, value) {
    var parts = path.split('.');
    var obj = global;
    while (parts.length > 1) {
        var name = parts.shift();
        if (obj.hasOwnProperty(name) && isPresent(obj[name])) {
            obj = obj[name];
        }
        else {
            obj = obj[name] = {};
        }
    }
    if (obj === undefined || obj === null) {
        obj = {};
    }
    obj[parts.shift()] = value;
}
var _symbolIterator = null;
export function getSymbolIterator() {
    if (isBlank(_symbolIterator)) {
        if (isPresent(Symbol) && isPresent(Symbol.iterator)) {
            _symbolIterator = Symbol.iterator;
        }
        else {
            // es6-shim specific logic
            var keys = Object.getOwnPropertyNames(Map.prototype);
            for (var i = 0; i < keys.length; ++i) {
                var key = keys[i];
                if (key !== 'entries' && key !== 'size' &&
                    Map.prototype[key] === Map.prototype['entries']) {
                    _symbolIterator = key;
                }
            }
        }
    }
    return _symbolIterator;
}
export function evalExpression(sourceUrl, expr, declarations, vars) {
    var fnBody = `${declarations}\nreturn ${expr}\n//# sourceURL=${sourceUrl}`;
    var fnArgNames = [];
    var fnArgValues = [];
    for (var argName in vars) {
        fnArgNames.push(argName);
        fnArgValues.push(vars[argName]);
    }
    return new Function(...fnArgNames.concat(fnBody))(...fnArgValues);
}
export function isPrimitive(obj) {
    return !isJsObject(obj);
}
export function hasConstructor(value, type) {
    return value.constructor === type;
}
//# sourceMappingURL=data:application/json;base64,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