var globalScope;
if (typeof window === 'undefined') {
    if (typeof WorkerGlobalScope !== 'undefined' && self instanceof WorkerGlobalScope) {
        // TODO: Replace any with WorkerGlobalScope from lib.webworker.d.ts #3492
        globalScope = self;
    }
    else {
        globalScope = global;
    }
}
else {
    globalScope = window;
}
export const IS_DART = false;
// Need to declare a new variable for global here since TypeScript
// exports the original value of the symbol.
var _global = globalScope;
export { _global as global };
export var Type = Function;
export function getTypeNameForDebugging(type) {
    return type['name'];
}
export var Math = _global.Math;
export var Date = _global.Date;
var _devMode = true;
var _modeLocked = false;
export function lockMode() {
    _modeLocked = true;
}
/**
 * Disable Angular's development mode, which turns off assertions and other
 * checks within the framework.
 *
 * One important assertion this disables verifies that a change detection pass
 * does not result in additional changes to any bindings (also known as
 * unidirectional data flow).
 */
export function enableProdMode() {
    if (_modeLocked) {
        // Cannot use BaseException as that ends up importing from facade/lang.
        throw 'Cannot enable prod mode after platform setup.';
    }
    _devMode = false;
}
export function assertionsEnabled() {
    return _devMode;
}
// TODO: remove calls to assert in production environment
// Note: Can't just export this and import in in other files
// as `assert` is a reserved keyword in Dart
_global.assert = function assert(condition) {
    // TODO: to be fixed properly via #2830, noop for now
};
// This function is needed only to properly support Dart's const expressions
// see https://github.com/angular/ts2dart/pull/151 for more info
export function CONST_EXPR(expr) {
    return expr;
}
export function CONST() {
    return (target) => target;
}
export function isPresent(obj) {
    return obj !== undefined && obj !== null;
}
export function isBlank(obj) {
    return obj === undefined || obj === null;
}
export function isString(obj) {
    return typeof obj === "string";
}
export function isFunction(obj) {
    return typeof obj === "function";
}
export function isType(obj) {
    return isFunction(obj);
}
export function isStringMap(obj) {
    return typeof obj === 'object' && obj !== null;
}
export function isPromise(obj) {
    return obj instanceof _global.Promise;
}
export function isArray(obj) {
    return Array.isArray(obj);
}
export function isNumber(obj) {
    return typeof obj === 'number';
}
export function isDate(obj) {
    return obj instanceof Date && !isNaN(obj.valueOf());
}
export function noop() { }
export function stringify(token) {
    if (typeof token === 'string') {
        return token;
    }
    if (token === undefined || token === null) {
        return '' + token;
    }
    if (token.name) {
        return token.name;
    }
    if (token.overriddenName) {
        return token.overriddenName;
    }
    var res = token.toString();
    var newLineIndex = res.indexOf("\n");
    return (newLineIndex === -1) ? res : res.substring(0, newLineIndex);
}
// serialize / deserialize enum exist only for consistency with dart API
// enums in typescript don't need to be serialized
export function serializeEnum(val) {
    return val;
}
export function deserializeEnum(val, values) {
    return val;
}
export class StringWrapper {
    static fromCharCode(code) { return String.fromCharCode(code); }
    static charCodeAt(s, index) { return s.charCodeAt(index); }
    static split(s, regExp) { return s.split(regExp); }
    static equals(s, s2) { return s === s2; }
    static stripLeft(s, charVal) {
        if (s && s.length) {
            var pos = 0;
            for (var i = 0; i < s.length; i++) {
                if (s[i] != charVal)
                    break;
                pos++;
            }
            s = s.substring(pos);
        }
        return s;
    }
    static stripRight(s, charVal) {
        if (s && s.length) {
            var pos = s.length;
            for (var i = s.length - 1; i >= 0; i--) {
                if (s[i] != charVal)
                    break;
                pos--;
            }
            s = s.substring(0, pos);
        }
        return s;
    }
    static replace(s, from, replace) {
        return s.replace(from, replace);
    }
    static replaceAll(s, from, replace) {
        return s.replace(from, replace);
    }
    static slice(s, from = 0, to = null) {
        return s.slice(from, to === null ? undefined : to);
    }
    static replaceAllMapped(s, from, cb) {
        return s.replace(from, function (...matches) {
            // Remove offset & string from the result array
            matches.splice(-2, 2);
            // The callback receives match, p1, ..., pn
            return cb(matches);
        });
    }
    static contains(s, substr) { return s.indexOf(substr) != -1; }
    static compare(a, b) {
        if (a < b) {
            return -1;
        }
        else if (a > b) {
            return 1;
        }
        else {
            return 0;
        }
    }
}
export class StringJoiner {
    constructor(parts = []) {
        this.parts = parts;
    }
    add(part) { this.parts.push(part); }
    toString() { return this.parts.join(""); }
}
export class NumberParseError extends Error {
    constructor(message) {
        super();
        this.message = message;
    }
    toString() { return this.message; }
}
export class NumberWrapper {
    static toFixed(n, fractionDigits) { return n.toFixed(fractionDigits); }
    static equal(a, b) { return a === b; }
    static parseIntAutoRadix(text) {
        var result = parseInt(text);
        if (isNaN(result)) {
            throw new NumberParseError("Invalid integer literal when parsing " + text);
        }
        return result;
    }
    static parseInt(text, radix) {
        if (radix == 10) {
            if (/^(\-|\+)?[0-9]+$/.test(text)) {
                return parseInt(text, radix);
            }
        }
        else if (radix == 16) {
            if (/^(\-|\+)?[0-9ABCDEFabcdef]+$/.test(text)) {
                return parseInt(text, radix);
            }
        }
        else {
            var result = parseInt(text, radix);
            if (!isNaN(result)) {
                return result;
            }
        }
        throw new NumberParseError("Invalid integer literal when parsing " + text + " in base " +
            radix);
    }
    // TODO: NaN is a valid literal but is returned by parseFloat to indicate an error.
    static parseFloat(text) { return parseFloat(text); }
    static get NaN() { return NaN; }
    static isNaN(value) { return isNaN(value); }
    static isInteger(value) { return Number.isInteger(value); }
}
export var RegExp = _global.RegExp;
export class RegExpWrapper {
    static create(regExpStr, flags = '') {
        flags = flags.replace(/g/g, '');
        return new _global.RegExp(regExpStr, flags + 'g');
    }
    static firstMatch(regExp, input) {
        // Reset multimatch regex state
        regExp.lastIndex = 0;
        return regExp.exec(input);
    }
    static test(regExp, input) {
        regExp.lastIndex = 0;
        return regExp.test(input);
    }
    static matcher(regExp, input) {
        // Reset regex state for the case
        // someone did not loop over all matches
        // last time.
        regExp.lastIndex = 0;
        return { re: regExp, input: input };
    }
}
export class RegExpMatcherWrapper {
    static next(matcher) {
        return matcher.re.exec(matcher.input);
    }
}
export class FunctionWrapper {
    static apply(fn, posArgs) { return fn.apply(null, posArgs); }
}
// JS has NaN !== NaN
export function looseIdentical(a, b) {
    return a === b || typeof a === "number" && typeof b === "number" && isNaN(a) && isNaN(b);
}
// JS considers NaN is the same as NaN for map Key (while NaN !== NaN otherwise)
// see https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Map
export function getMapKey(value) {
    return value;
}
export function normalizeBlank(obj) {
    return isBlank(obj) ? null : obj;
}
export function normalizeBool(obj) {
    return isBlank(obj) ? false : obj;
}
export function isJsObject(o) {
    return o !== null && (typeof o === "function" || typeof o === "object");
}
export function print(obj) {
    console.log(obj);
}
// Can't be all uppercase as our transpiler would think it is a special directive...
export class Json {
    static parse(s) { return _global.JSON.parse(s); }
    static stringify(data) {
        // Dart doesn't take 3 arguments
        return _global.JSON.stringify(data, null, 2);
    }
}
export class DateWrapper {
    static create(year, month = 1, day = 1, hour = 0, minutes = 0, seconds = 0, milliseconds = 0) {
        return new Date(year, month - 1, day, hour, minutes, seconds, milliseconds);
    }
    static fromISOString(str) { return new Date(str); }
    static fromMillis(ms) { return new Date(ms); }
    static toMillis(date) { return date.getTime(); }
    static now() { return new Date(); }
    static toJson(date) { return date.toJSON(); }
}
export function setValueOnPath(global, path, value) {
    var parts = path.split('.');
    var obj = global;
    while (parts.length > 1) {
        var name = parts.shift();
        if (obj.hasOwnProperty(name) && isPresent(obj[name])) {
            obj = obj[name];
        }
        else {
            obj = obj[name] = {};
        }
    }
    if (obj === undefined || obj === null) {
        obj = {};
    }
    obj[parts.shift()] = value;
}
var _symbolIterator = null;
export function getSymbolIterator() {
    if (isBlank(_symbolIterator)) {
        if (isPresent(Symbol) && isPresent(Symbol.iterator)) {
            _symbolIterator = Symbol.iterator;
        }
        else {
            // es6-shim specific logic
            var keys = Object.getOwnPropertyNames(Map.prototype);
            for (var i = 0; i < keys.length; ++i) {
                var key = keys[i];
                if (key !== 'entries' && key !== 'size' &&
                    Map.prototype[key] === Map.prototype['entries']) {
                    _symbolIterator = key;
                }
            }
        }
    }
    return _symbolIterator;
}
export function evalExpression(sourceUrl, expr, declarations, vars) {
    var fnBody = `${declarations}\nreturn ${expr}\n//# sourceURL=${sourceUrl}`;
    var fnArgNames = [];
    var fnArgValues = [];
    for (var argName in vars) {
        fnArgNames.push(argName);
        fnArgValues.push(vars[argName]);
    }
    return new Function(...fnArgNames.concat(fnBody))(...fnArgValues);
}
export function isPrimitive(obj) {
    return !isJsObject(obj);
}
export function hasConstructor(value, type) {
    return value.constructor === type;
}
//# sourceMappingURL=data:application/json;base64,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