'use strict';var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var lang_1 = require('angular2/src/facade/lang');
var exceptions_1 = require('angular2/src/facade/exceptions');
var collection_1 = require('angular2/src/facade/collection');
var async_1 = require('angular2/src/facade/async');
var directive_metadata_1 = require('./directive_metadata');
var template_ast_1 = require('./template_ast');
var di_1 = require('angular2/src/core/di');
var source_module_1 = require('./source_module');
var change_detector_compiler_1 = require('./change_detector_compiler');
var style_compiler_1 = require('./style_compiler');
var view_compiler_1 = require('./view_compiler');
var proto_view_compiler_1 = require('./proto_view_compiler');
var template_parser_1 = require('./template_parser');
var template_normalizer_1 = require('./template_normalizer');
var runtime_metadata_1 = require('./runtime_metadata');
var view_1 = require('angular2/src/core/linker/view');
var change_detection_1 = require('angular2/src/core/change_detection/change_detection');
var resolved_metadata_cache_1 = require('angular2/src/core/linker/resolved_metadata_cache');
var util_1 = require('./util');
exports.METADATA_CACHE_MODULE_REF = source_module_1.moduleRef('package:angular2/src/core/linker/resolved_metadata_cache' + util_1.MODULE_SUFFIX);
/**
 * An internal module of the Angular compiler that begins with component types,
 * extracts templates, and eventually produces a compiled version of the component
 * ready for linking into an application.
 */
var TemplateCompiler = (function () {
    function TemplateCompiler(_runtimeMetadataResolver, _templateNormalizer, _templateParser, _styleCompiler, _cdCompiler, _protoViewCompiler, _viewCompiler, _resolvedMetadataCache, _genConfig) {
        this._runtimeMetadataResolver = _runtimeMetadataResolver;
        this._templateNormalizer = _templateNormalizer;
        this._templateParser = _templateParser;
        this._styleCompiler = _styleCompiler;
        this._cdCompiler = _cdCompiler;
        this._protoViewCompiler = _protoViewCompiler;
        this._viewCompiler = _viewCompiler;
        this._resolvedMetadataCache = _resolvedMetadataCache;
        this._genConfig = _genConfig;
        this._hostCacheKeys = new Map();
        this._compiledTemplateCache = new Map();
        this._compiledTemplateDone = new Map();
    }
    TemplateCompiler.prototype.normalizeDirectiveMetadata = function (directive) {
        if (!directive.isComponent) {
            // For non components there is nothing to be normalized yet.
            return async_1.PromiseWrapper.resolve(directive);
        }
        return this._templateNormalizer.normalizeTemplate(directive.type, directive.template)
            .then(function (normalizedTemplate) { return new directive_metadata_1.CompileDirectiveMetadata({
            type: directive.type,
            isComponent: directive.isComponent,
            dynamicLoadable: directive.dynamicLoadable,
            selector: directive.selector,
            exportAs: directive.exportAs,
            changeDetection: directive.changeDetection,
            inputs: directive.inputs,
            outputs: directive.outputs,
            hostListeners: directive.hostListeners,
            hostProperties: directive.hostProperties,
            hostAttributes: directive.hostAttributes,
            lifecycleHooks: directive.lifecycleHooks,
            providers: directive.providers,
            template: normalizedTemplate
        }); });
    };
    TemplateCompiler.prototype.compileHostComponentRuntime = function (type) {
        var compMeta = this._runtimeMetadataResolver.getDirectiveMetadata(type);
        var hostCacheKey = this._hostCacheKeys.get(type);
        if (lang_1.isBlank(hostCacheKey)) {
            hostCacheKey = new Object();
            this._hostCacheKeys.set(type, hostCacheKey);
            assertComponent(compMeta);
            var hostMeta = directive_metadata_1.createHostComponentMeta(compMeta.type, compMeta.selector);
            this._compileComponentRuntime(hostCacheKey, hostMeta, [compMeta], [], []);
        }
        return this._compiledTemplateDone.get(hostCacheKey)
            .then(function (compiledTemplate) {
            return new view_1.HostViewFactory(compMeta.selector, compiledTemplate.viewFactory);
        });
    };
    TemplateCompiler.prototype.clearCache = function () {
        this._styleCompiler.clearCache();
        this._compiledTemplateCache.clear();
        this._compiledTemplateDone.clear();
        this._hostCacheKeys.clear();
    };
    TemplateCompiler.prototype.compileTemplatesCodeGen = function (components) {
        var _this = this;
        if (components.length === 0) {
            throw new exceptions_1.BaseException('No components given');
        }
        var declarations = [];
        components.forEach(function (componentWithDirs) {
            var compMeta = componentWithDirs.component;
            assertComponent(compMeta);
            _this._compileComponentCodeGen(compMeta, componentWithDirs.directives, componentWithDirs.pipes, declarations);
            if (compMeta.dynamicLoadable) {
                var hostMeta = directive_metadata_1.createHostComponentMeta(compMeta.type, compMeta.selector);
                var viewFactoryExpression = _this._compileComponentCodeGen(hostMeta, [compMeta], [], declarations);
                var constructionKeyword = lang_1.IS_DART ? 'const' : 'new';
                var compiledTemplateExpr = constructionKeyword + " " + proto_view_compiler_1.APP_VIEW_MODULE_REF + "HostViewFactory('" + compMeta.selector + "'," + viewFactoryExpression + ")";
                var varName = codeGenHostViewFactoryName(compMeta.type);
                declarations.push("" + util_1.codeGenExportVariable(varName) + compiledTemplateExpr + ";");
            }
        });
        var moduleUrl = components[0].component.type.moduleUrl;
        return new source_module_1.SourceModule("" + templateModuleUrl(moduleUrl), declarations.join('\n'));
    };
    TemplateCompiler.prototype.compileStylesheetCodeGen = function (stylesheetUrl, cssText) {
        return this._styleCompiler.compileStylesheetCodeGen(stylesheetUrl, cssText);
    };
    TemplateCompiler.prototype._compileComponentRuntime = function (cacheKey, compMeta, viewDirectives, pipes, compilingComponentsPath) {
        var _this = this;
        var uniqViewDirectives = removeDuplicates(viewDirectives);
        var uniqViewPipes = removeDuplicates(pipes);
        var compiledTemplate = this._compiledTemplateCache.get(cacheKey);
        var done = this._compiledTemplateDone.get(cacheKey);
        if (lang_1.isBlank(compiledTemplate)) {
            compiledTemplate = new CompiledTemplate();
            this._compiledTemplateCache.set(cacheKey, compiledTemplate);
            done = async_1.PromiseWrapper
                .all([this._styleCompiler.compileComponentRuntime(compMeta.template)].concat(uniqViewDirectives.map(function (dirMeta) { return _this.normalizeDirectiveMetadata(dirMeta); })))
                .then(function (stylesAndNormalizedViewDirMetas) {
                var normalizedViewDirMetas = stylesAndNormalizedViewDirMetas.slice(1);
                var styles = stylesAndNormalizedViewDirMetas[0];
                var parsedTemplate = _this._templateParser.parse(compMeta.template.template, normalizedViewDirMetas, uniqViewPipes, compMeta.type.name);
                var childPromises = [];
                var usedDirectives = DirectiveCollector.findUsedDirectives(parsedTemplate);
                usedDirectives.components.forEach(function (component) { return _this._compileNestedComponentRuntime(component, compilingComponentsPath, childPromises); });
                return async_1.PromiseWrapper.all(childPromises)
                    .then(function (_) {
                    var filteredPipes = filterPipes(parsedTemplate, uniqViewPipes);
                    compiledTemplate.init(_this._createViewFactoryRuntime(compMeta, parsedTemplate, usedDirectives.directives, styles, filteredPipes));
                    return compiledTemplate;
                });
            });
            this._compiledTemplateDone.set(cacheKey, done);
        }
        return compiledTemplate;
    };
    TemplateCompiler.prototype._compileNestedComponentRuntime = function (childComponentDir, parentCompilingComponentsPath, childPromises) {
        var compilingComponentsPath = collection_1.ListWrapper.clone(parentCompilingComponentsPath);
        var childCacheKey = childComponentDir.type.runtime;
        var childViewDirectives = this._runtimeMetadataResolver.getViewDirectivesMetadata(childComponentDir.type.runtime);
        var childViewPipes = this._runtimeMetadataResolver.getViewPipesMetadata(childComponentDir.type.runtime);
        var childIsRecursive = collection_1.ListWrapper.contains(compilingComponentsPath, childCacheKey);
        compilingComponentsPath.push(childCacheKey);
        this._compileComponentRuntime(childCacheKey, childComponentDir, childViewDirectives, childViewPipes, compilingComponentsPath);
        if (!childIsRecursive) {
            // Only wait for a child if it is not a cycle
            childPromises.push(this._compiledTemplateDone.get(childCacheKey));
        }
    };
    TemplateCompiler.prototype._createViewFactoryRuntime = function (compMeta, parsedTemplate, directives, styles, pipes) {
        var _this = this;
        if (lang_1.IS_DART || !this._genConfig.useJit) {
            var changeDetectorFactories = this._cdCompiler.compileComponentRuntime(compMeta.type, compMeta.changeDetection, parsedTemplate);
            var protoViews = this._protoViewCompiler.compileProtoViewRuntime(this._resolvedMetadataCache, compMeta, parsedTemplate, pipes);
            return this._viewCompiler.compileComponentRuntime(compMeta, parsedTemplate, styles, protoViews.protoViews, changeDetectorFactories, function (compMeta) { return _this._getNestedComponentViewFactory(compMeta); });
        }
        else {
            var declarations = [];
            var viewFactoryExpr = this._createViewFactoryCodeGen('resolvedMetadataCache', compMeta, new source_module_1.SourceExpression([], 'styles'), parsedTemplate, pipes, declarations);
            var vars = { 'exports': {}, 'styles': styles, 'resolvedMetadataCache': this._resolvedMetadataCache };
            directives.forEach(function (dirMeta) {
                vars[dirMeta.type.name] = dirMeta.type.runtime;
                if (dirMeta.isComponent && dirMeta.type.runtime !== compMeta.type.runtime) {
                    vars[("viewFactory_" + dirMeta.type.name + "0")] = _this._getNestedComponentViewFactory(dirMeta);
                }
            });
            pipes.forEach(function (pipeMeta) { return vars[pipeMeta.type.name] = pipeMeta.type.runtime; });
            var declarationsWithoutImports = source_module_1.SourceModule.getSourceWithoutImports(declarations.join('\n'));
            return lang_1.evalExpression("viewFactory_" + compMeta.type.name, viewFactoryExpr, declarationsWithoutImports, mergeStringMaps([vars, change_detector_compiler_1.CHANGE_DETECTION_JIT_IMPORTS, proto_view_compiler_1.PROTO_VIEW_JIT_IMPORTS, view_compiler_1.VIEW_JIT_IMPORTS]));
        }
    };
    TemplateCompiler.prototype._getNestedComponentViewFactory = function (compMeta) {
        return this._compiledTemplateCache.get(compMeta.type.runtime).viewFactory;
    };
    TemplateCompiler.prototype._compileComponentCodeGen = function (compMeta, directives, pipes, targetDeclarations) {
        var uniqueDirectives = removeDuplicates(directives);
        var uniqPipes = removeDuplicates(pipes);
        var styleExpr = this._styleCompiler.compileComponentCodeGen(compMeta.template);
        var parsedTemplate = this._templateParser.parse(compMeta.template.template, uniqueDirectives, uniqPipes, compMeta.type.name);
        var filteredPipes = filterPipes(parsedTemplate, uniqPipes);
        return this._createViewFactoryCodeGen(exports.METADATA_CACHE_MODULE_REF + "CODEGEN_RESOLVED_METADATA_CACHE", compMeta, styleExpr, parsedTemplate, filteredPipes, targetDeclarations);
    };
    TemplateCompiler.prototype._createViewFactoryCodeGen = function (resolvedMetadataCacheExpr, compMeta, styleExpr, parsedTemplate, pipes, targetDeclarations) {
        var changeDetectorsExprs = this._cdCompiler.compileComponentCodeGen(compMeta.type, compMeta.changeDetection, parsedTemplate);
        var protoViewExprs = this._protoViewCompiler.compileProtoViewCodeGen(new util_1.Expression(resolvedMetadataCacheExpr), compMeta, parsedTemplate, pipes);
        var viewFactoryExpr = this._viewCompiler.compileComponentCodeGen(compMeta, parsedTemplate, styleExpr, protoViewExprs.protoViews, changeDetectorsExprs, codeGenComponentViewFactoryName);
        util_1.addAll(changeDetectorsExprs.declarations, targetDeclarations);
        util_1.addAll(protoViewExprs.declarations, targetDeclarations);
        util_1.addAll(viewFactoryExpr.declarations, targetDeclarations);
        return viewFactoryExpr.expression;
    };
    TemplateCompiler = __decorate([
        di_1.Injectable(), 
        __metadata('design:paramtypes', [runtime_metadata_1.RuntimeMetadataResolver, template_normalizer_1.TemplateNormalizer, template_parser_1.TemplateParser, style_compiler_1.StyleCompiler, change_detector_compiler_1.ChangeDetectionCompiler, proto_view_compiler_1.ProtoViewCompiler, view_compiler_1.ViewCompiler, resolved_metadata_cache_1.ResolvedMetadataCache, change_detection_1.ChangeDetectorGenConfig])
    ], TemplateCompiler);
    return TemplateCompiler;
})();
exports.TemplateCompiler = TemplateCompiler;
var NormalizedComponentWithViewDirectives = (function () {
    function NormalizedComponentWithViewDirectives(component, directives, pipes) {
        this.component = component;
        this.directives = directives;
        this.pipes = pipes;
    }
    return NormalizedComponentWithViewDirectives;
})();
exports.NormalizedComponentWithViewDirectives = NormalizedComponentWithViewDirectives;
var CompiledTemplate = (function () {
    function CompiledTemplate() {
        this.viewFactory = null;
    }
    CompiledTemplate.prototype.init = function (viewFactory) { this.viewFactory = viewFactory; };
    return CompiledTemplate;
})();
function assertComponent(meta) {
    if (!meta.isComponent) {
        throw new exceptions_1.BaseException("Could not compile '" + meta.type.name + "' because it is not a component.");
    }
}
function templateModuleUrl(moduleUrl) {
    var urlWithoutSuffix = moduleUrl.substring(0, moduleUrl.length - util_1.MODULE_SUFFIX.length);
    return urlWithoutSuffix + ".template" + util_1.MODULE_SUFFIX;
}
function codeGenHostViewFactoryName(type) {
    return "hostViewFactory_" + type.name;
}
function codeGenComponentViewFactoryName(nestedCompType) {
    return source_module_1.moduleRef(templateModuleUrl(nestedCompType.type.moduleUrl)) + "viewFactory_" + nestedCompType.type.name + "0";
}
function mergeStringMaps(maps) {
    var result = {};
    maps.forEach(function (map) { collection_1.StringMapWrapper.forEach(map, function (value, key) { result[key] = value; }); });
    return result;
}
function removeDuplicates(items) {
    var res = [];
    items.forEach(function (item) {
        var hasMatch = res.filter(function (r) { return r.type.name == item.type.name && r.type.moduleUrl == item.type.moduleUrl &&
            r.type.runtime == item.type.runtime; })
            .length > 0;
        if (!hasMatch) {
            res.push(item);
        }
    });
    return res;
}
var DirectiveCollector = (function () {
    function DirectiveCollector() {
        this.directives = [];
        this.components = [];
    }
    DirectiveCollector.findUsedDirectives = function (parsedTemplate) {
        var collector = new DirectiveCollector();
        template_ast_1.templateVisitAll(collector, parsedTemplate);
        return collector;
    };
    DirectiveCollector.prototype.visitBoundText = function (ast, context) { return null; };
    DirectiveCollector.prototype.visitText = function (ast, context) { return null; };
    DirectiveCollector.prototype.visitNgContent = function (ast, context) { return null; };
    DirectiveCollector.prototype.visitElement = function (ast, context) {
        template_ast_1.templateVisitAll(this, ast.directives);
        template_ast_1.templateVisitAll(this, ast.children);
        return null;
    };
    DirectiveCollector.prototype.visitEmbeddedTemplate = function (ast, context) {
        template_ast_1.templateVisitAll(this, ast.directives);
        template_ast_1.templateVisitAll(this, ast.children);
        return null;
    };
    DirectiveCollector.prototype.visitVariable = function (ast, ctx) { return null; };
    DirectiveCollector.prototype.visitAttr = function (ast, attrNameAndValues) { return null; };
    DirectiveCollector.prototype.visitDirective = function (ast, ctx) {
        if (ast.directive.isComponent) {
            this.components.push(ast.directive);
        }
        this.directives.push(ast.directive);
        return null;
    };
    DirectiveCollector.prototype.visitEvent = function (ast, eventTargetAndNames) {
        return null;
    };
    DirectiveCollector.prototype.visitDirectiveProperty = function (ast, context) { return null; };
    DirectiveCollector.prototype.visitElementProperty = function (ast, context) { return null; };
    return DirectiveCollector;
})();
function filterPipes(template, allPipes) {
    var visitor = new PipeVisitor();
    template_ast_1.templateVisitAll(visitor, template);
    return allPipes.filter(function (pipeMeta) { return collection_1.SetWrapper.has(visitor.collector.pipes, pipeMeta.name); });
}
var PipeVisitor = (function () {
    function PipeVisitor() {
        this.collector = new template_parser_1.PipeCollector();
    }
    PipeVisitor.prototype.visitBoundText = function (ast, context) {
        ast.value.visit(this.collector);
        return null;
    };
    PipeVisitor.prototype.visitText = function (ast, context) { return null; };
    PipeVisitor.prototype.visitNgContent = function (ast, context) { return null; };
    PipeVisitor.prototype.visitElement = function (ast, context) {
        template_ast_1.templateVisitAll(this, ast.inputs);
        template_ast_1.templateVisitAll(this, ast.outputs);
        template_ast_1.templateVisitAll(this, ast.directives);
        template_ast_1.templateVisitAll(this, ast.children);
        return null;
    };
    PipeVisitor.prototype.visitEmbeddedTemplate = function (ast, context) {
        template_ast_1.templateVisitAll(this, ast.outputs);
        template_ast_1.templateVisitAll(this, ast.directives);
        template_ast_1.templateVisitAll(this, ast.children);
        return null;
    };
    PipeVisitor.prototype.visitVariable = function (ast, ctx) { return null; };
    PipeVisitor.prototype.visitAttr = function (ast, attrNameAndValues) { return null; };
    PipeVisitor.prototype.visitDirective = function (ast, ctx) {
        template_ast_1.templateVisitAll(this, ast.inputs);
        template_ast_1.templateVisitAll(this, ast.hostEvents);
        template_ast_1.templateVisitAll(this, ast.hostProperties);
        return null;
    };
    PipeVisitor.prototype.visitEvent = function (ast, eventTargetAndNames) {
        ast.handler.visit(this.collector);
        return null;
    };
    PipeVisitor.prototype.visitDirectiveProperty = function (ast, context) {
        ast.value.visit(this.collector);
        return null;
    };
    PipeVisitor.prototype.visitElementProperty = function (ast, context) {
        ast.value.visit(this.collector);
        return null;
    };
    return PipeVisitor;
})();
//# sourceMappingURL=data:application/json;base64,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