'use strict';var __extends = (this && this.__extends) || function (d, b) {
    for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p];
    function __() { this.constructor = d; }
    d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
};
var globalScope;
if (typeof window === 'undefined') {
    if (typeof WorkerGlobalScope !== 'undefined' && self instanceof WorkerGlobalScope) {
        // TODO: Replace any with WorkerGlobalScope from lib.webworker.d.ts #3492
        globalScope = self;
    }
    else {
        globalScope = global;
    }
}
else {
    globalScope = window;
}
exports.IS_DART = false;
// Need to declare a new variable for global here since TypeScript
// exports the original value of the symbol.
var _global = globalScope;
exports.global = _global;
exports.Type = Function;
function getTypeNameForDebugging(type) {
    return type['name'];
}
exports.getTypeNameForDebugging = getTypeNameForDebugging;
exports.Math = _global.Math;
exports.Date = _global.Date;
var _devMode = true;
var _modeLocked = false;
function lockMode() {
    _modeLocked = true;
}
exports.lockMode = lockMode;
/**
 * Disable Angular's development mode, which turns off assertions and other
 * checks within the framework.
 *
 * One important assertion this disables verifies that a change detection pass
 * does not result in additional changes to any bindings (also known as
 * unidirectional data flow).
 */
function enableProdMode() {
    if (_modeLocked) {
        // Cannot use BaseException as that ends up importing from facade/lang.
        throw 'Cannot enable prod mode after platform setup.';
    }
    _devMode = false;
}
exports.enableProdMode = enableProdMode;
function assertionsEnabled() {
    return _devMode;
}
exports.assertionsEnabled = assertionsEnabled;
// TODO: remove calls to assert in production environment
// Note: Can't just export this and import in in other files
// as `assert` is a reserved keyword in Dart
_global.assert = function assert(condition) {
    // TODO: to be fixed properly via #2830, noop for now
};
// This function is needed only to properly support Dart's const expressions
// see https://github.com/angular/ts2dart/pull/151 for more info
function CONST_EXPR(expr) {
    return expr;
}
exports.CONST_EXPR = CONST_EXPR;
function CONST() {
    return function (target) { return target; };
}
exports.CONST = CONST;
function isPresent(obj) {
    return obj !== undefined && obj !== null;
}
exports.isPresent = isPresent;
function isBlank(obj) {
    return obj === undefined || obj === null;
}
exports.isBlank = isBlank;
function isString(obj) {
    return typeof obj === "string";
}
exports.isString = isString;
function isFunction(obj) {
    return typeof obj === "function";
}
exports.isFunction = isFunction;
function isType(obj) {
    return isFunction(obj);
}
exports.isType = isType;
function isStringMap(obj) {
    return typeof obj === 'object' && obj !== null;
}
exports.isStringMap = isStringMap;
function isPromise(obj) {
    return obj instanceof _global.Promise;
}
exports.isPromise = isPromise;
function isArray(obj) {
    return Array.isArray(obj);
}
exports.isArray = isArray;
function isNumber(obj) {
    return typeof obj === 'number';
}
exports.isNumber = isNumber;
function isDate(obj) {
    return obj instanceof exports.Date && !isNaN(obj.valueOf());
}
exports.isDate = isDate;
function noop() { }
exports.noop = noop;
function stringify(token) {
    if (typeof token === 'string') {
        return token;
    }
    if (token === undefined || token === null) {
        return '' + token;
    }
    if (token.name) {
        return token.name;
    }
    if (token.overriddenName) {
        return token.overriddenName;
    }
    var res = token.toString();
    var newLineIndex = res.indexOf("\n");
    return (newLineIndex === -1) ? res : res.substring(0, newLineIndex);
}
exports.stringify = stringify;
// serialize / deserialize enum exist only for consistency with dart API
// enums in typescript don't need to be serialized
function serializeEnum(val) {
    return val;
}
exports.serializeEnum = serializeEnum;
function deserializeEnum(val, values) {
    return val;
}
exports.deserializeEnum = deserializeEnum;
var StringWrapper = (function () {
    function StringWrapper() {
    }
    StringWrapper.fromCharCode = function (code) { return String.fromCharCode(code); };
    StringWrapper.charCodeAt = function (s, index) { return s.charCodeAt(index); };
    StringWrapper.split = function (s, regExp) { return s.split(regExp); };
    StringWrapper.equals = function (s, s2) { return s === s2; };
    StringWrapper.stripLeft = function (s, charVal) {
        if (s && s.length) {
            var pos = 0;
            for (var i = 0; i < s.length; i++) {
                if (s[i] != charVal)
                    break;
                pos++;
            }
            s = s.substring(pos);
        }
        return s;
    };
    StringWrapper.stripRight = function (s, charVal) {
        if (s && s.length) {
            var pos = s.length;
            for (var i = s.length - 1; i >= 0; i--) {
                if (s[i] != charVal)
                    break;
                pos--;
            }
            s = s.substring(0, pos);
        }
        return s;
    };
    StringWrapper.replace = function (s, from, replace) {
        return s.replace(from, replace);
    };
    StringWrapper.replaceAll = function (s, from, replace) {
        return s.replace(from, replace);
    };
    StringWrapper.slice = function (s, from, to) {
        if (from === void 0) { from = 0; }
        if (to === void 0) { to = null; }
        return s.slice(from, to === null ? undefined : to);
    };
    StringWrapper.replaceAllMapped = function (s, from, cb) {
        return s.replace(from, function () {
            var matches = [];
            for (var _i = 0; _i < arguments.length; _i++) {
                matches[_i - 0] = arguments[_i];
            }
            // Remove offset & string from the result array
            matches.splice(-2, 2);
            // The callback receives match, p1, ..., pn
            return cb(matches);
        });
    };
    StringWrapper.contains = function (s, substr) { return s.indexOf(substr) != -1; };
    StringWrapper.compare = function (a, b) {
        if (a < b) {
            return -1;
        }
        else if (a > b) {
            return 1;
        }
        else {
            return 0;
        }
    };
    return StringWrapper;
})();
exports.StringWrapper = StringWrapper;
var StringJoiner = (function () {
    function StringJoiner(parts) {
        if (parts === void 0) { parts = []; }
        this.parts = parts;
    }
    StringJoiner.prototype.add = function (part) { this.parts.push(part); };
    StringJoiner.prototype.toString = function () { return this.parts.join(""); };
    return StringJoiner;
})();
exports.StringJoiner = StringJoiner;
var NumberParseError = (function (_super) {
    __extends(NumberParseError, _super);
    function NumberParseError(message) {
        _super.call(this);
        this.message = message;
    }
    NumberParseError.prototype.toString = function () { return this.message; };
    return NumberParseError;
})(Error);
exports.NumberParseError = NumberParseError;
var NumberWrapper = (function () {
    function NumberWrapper() {
    }
    NumberWrapper.toFixed = function (n, fractionDigits) { return n.toFixed(fractionDigits); };
    NumberWrapper.equal = function (a, b) { return a === b; };
    NumberWrapper.parseIntAutoRadix = function (text) {
        var result = parseInt(text);
        if (isNaN(result)) {
            throw new NumberParseError("Invalid integer literal when parsing " + text);
        }
        return result;
    };
    NumberWrapper.parseInt = function (text, radix) {
        if (radix == 10) {
            if (/^(\-|\+)?[0-9]+$/.test(text)) {
                return parseInt(text, radix);
            }
        }
        else if (radix == 16) {
            if (/^(\-|\+)?[0-9ABCDEFabcdef]+$/.test(text)) {
                return parseInt(text, radix);
            }
        }
        else {
            var result = parseInt(text, radix);
            if (!isNaN(result)) {
                return result;
            }
        }
        throw new NumberParseError("Invalid integer literal when parsing " + text + " in base " +
            radix);
    };
    // TODO: NaN is a valid literal but is returned by parseFloat to indicate an error.
    NumberWrapper.parseFloat = function (text) { return parseFloat(text); };
    Object.defineProperty(NumberWrapper, "NaN", {
        get: function () { return NaN; },
        enumerable: true,
        configurable: true
    });
    NumberWrapper.isNaN = function (value) { return isNaN(value); };
    NumberWrapper.isInteger = function (value) { return Number.isInteger(value); };
    return NumberWrapper;
})();
exports.NumberWrapper = NumberWrapper;
exports.RegExp = _global.RegExp;
var RegExpWrapper = (function () {
    function RegExpWrapper() {
    }
    RegExpWrapper.create = function (regExpStr, flags) {
        if (flags === void 0) { flags = ''; }
        flags = flags.replace(/g/g, '');
        return new _global.RegExp(regExpStr, flags + 'g');
    };
    RegExpWrapper.firstMatch = function (regExp, input) {
        // Reset multimatch regex state
        regExp.lastIndex = 0;
        return regExp.exec(input);
    };
    RegExpWrapper.test = function (regExp, input) {
        regExp.lastIndex = 0;
        return regExp.test(input);
    };
    RegExpWrapper.matcher = function (regExp, input) {
        // Reset regex state for the case
        // someone did not loop over all matches
        // last time.
        regExp.lastIndex = 0;
        return { re: regExp, input: input };
    };
    return RegExpWrapper;
})();
exports.RegExpWrapper = RegExpWrapper;
var RegExpMatcherWrapper = (function () {
    function RegExpMatcherWrapper() {
    }
    RegExpMatcherWrapper.next = function (matcher) {
        return matcher.re.exec(matcher.input);
    };
    return RegExpMatcherWrapper;
})();
exports.RegExpMatcherWrapper = RegExpMatcherWrapper;
var FunctionWrapper = (function () {
    function FunctionWrapper() {
    }
    FunctionWrapper.apply = function (fn, posArgs) { return fn.apply(null, posArgs); };
    return FunctionWrapper;
})();
exports.FunctionWrapper = FunctionWrapper;
// JS has NaN !== NaN
function looseIdentical(a, b) {
    return a === b || typeof a === "number" && typeof b === "number" && isNaN(a) && isNaN(b);
}
exports.looseIdentical = looseIdentical;
// JS considers NaN is the same as NaN for map Key (while NaN !== NaN otherwise)
// see https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Map
function getMapKey(value) {
    return value;
}
exports.getMapKey = getMapKey;
function normalizeBlank(obj) {
    return isBlank(obj) ? null : obj;
}
exports.normalizeBlank = normalizeBlank;
function normalizeBool(obj) {
    return isBlank(obj) ? false : obj;
}
exports.normalizeBool = normalizeBool;
function isJsObject(o) {
    return o !== null && (typeof o === "function" || typeof o === "object");
}
exports.isJsObject = isJsObject;
function print(obj) {
    console.log(obj);
}
exports.print = print;
// Can't be all uppercase as our transpiler would think it is a special directive...
var Json = (function () {
    function Json() {
    }
    Json.parse = function (s) { return _global.JSON.parse(s); };
    Json.stringify = function (data) {
        // Dart doesn't take 3 arguments
        return _global.JSON.stringify(data, null, 2);
    };
    return Json;
})();
exports.Json = Json;
var DateWrapper = (function () {
    function DateWrapper() {
    }
    DateWrapper.create = function (year, month, day, hour, minutes, seconds, milliseconds) {
        if (month === void 0) { month = 1; }
        if (day === void 0) { day = 1; }
        if (hour === void 0) { hour = 0; }
        if (minutes === void 0) { minutes = 0; }
        if (seconds === void 0) { seconds = 0; }
        if (milliseconds === void 0) { milliseconds = 0; }
        return new exports.Date(year, month - 1, day, hour, minutes, seconds, milliseconds);
    };
    DateWrapper.fromISOString = function (str) { return new exports.Date(str); };
    DateWrapper.fromMillis = function (ms) { return new exports.Date(ms); };
    DateWrapper.toMillis = function (date) { return date.getTime(); };
    DateWrapper.now = function () { return new exports.Date(); };
    DateWrapper.toJson = function (date) { return date.toJSON(); };
    return DateWrapper;
})();
exports.DateWrapper = DateWrapper;
function setValueOnPath(global, path, value) {
    var parts = path.split('.');
    var obj = global;
    while (parts.length > 1) {
        var name = parts.shift();
        if (obj.hasOwnProperty(name) && isPresent(obj[name])) {
            obj = obj[name];
        }
        else {
            obj = obj[name] = {};
        }
    }
    if (obj === undefined || obj === null) {
        obj = {};
    }
    obj[parts.shift()] = value;
}
exports.setValueOnPath = setValueOnPath;
var _symbolIterator = null;
function getSymbolIterator() {
    if (isBlank(_symbolIterator)) {
        if (isPresent(Symbol) && isPresent(Symbol.iterator)) {
            _symbolIterator = Symbol.iterator;
        }
        else {
            // es6-shim specific logic
            var keys = Object.getOwnPropertyNames(Map.prototype);
            for (var i = 0; i < keys.length; ++i) {
                var key = keys[i];
                if (key !== 'entries' && key !== 'size' &&
                    Map.prototype[key] === Map.prototype['entries']) {
                    _symbolIterator = key;
                }
            }
        }
    }
    return _symbolIterator;
}
exports.getSymbolIterator = getSymbolIterator;
function evalExpression(sourceUrl, expr, declarations, vars) {
    var fnBody = declarations + "\nreturn " + expr + "\n//# sourceURL=" + sourceUrl;
    var fnArgNames = [];
    var fnArgValues = [];
    for (var argName in vars) {
        fnArgNames.push(argName);
        fnArgValues.push(vars[argName]);
    }
    return new (Function.bind.apply(Function, [void 0].concat(fnArgNames.concat(fnBody))))().apply(void 0, fnArgValues);
}
exports.evalExpression = evalExpression;
function isPrimitive(obj) {
    return !isJsObject(obj);
}
exports.isPrimitive = isPrimitive;
function hasConstructor(value, type) {
    return value.constructor === type;
}
exports.hasConstructor = hasConstructor;
//# sourceMappingURL=data:application/json;base64,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