/**
 * @license Angular v4.0.0
 * (c) 2010-2017 Google, Inc. https://angular.io/
 * License: MIT
 */
!function(global,factory){"object"==typeof exports&&"undefined"!=typeof module?factory(exports,require("@angular/animations")):"function"==typeof define&&define.amd?define(["exports","@angular/animations"],factory):factory((global.ng=global.ng||{},global.ng.animations=global.ng.animations||{},global.ng.animations.browser=global.ng.animations.browser||{}),global.ng.animations)}(this,function(exports,_angular_animations){"use strict";function parseTimeExpression(exp,errors){var duration,regex=/^([\.\d]+)(m?s)(?:\s+([\.\d]+)(m?s))?(?:\s+([-a-z]+(?:\(.+?\))?))?$/i,delay=0,easing=null;if("string"==typeof exp){var matches=exp.match(regex);if(null===matches)return errors.push('The provided timing value "'+exp+'" is invalid.'),{duration:0,delay:0,easing:null};var durationMatch=parseFloat(matches[1]),durationUnit=matches[2];"s"==durationUnit&&(durationMatch*=ONE_SECOND),duration=Math.floor(durationMatch);var delayMatch=matches[3],delayUnit=matches[4];if(null!=delayMatch){var delayVal=parseFloat(delayMatch);null!=delayUnit&&"s"==delayUnit&&(delayVal*=ONE_SECOND),delay=Math.floor(delayVal)}var easingVal=matches[5];easingVal&&(easing=easingVal)}else duration=exp;return{duration:duration,delay:delay,easing:easing}}function normalizeStyles(styles){var normalizedStyles={};return Array.isArray(styles)?styles.forEach(function(data){return copyStyles(data,!1,normalizedStyles)}):copyStyles(styles,!1,normalizedStyles),normalizedStyles}function copyStyles(styles,readPrototype,destination){if(void 0===destination&&(destination={}),readPrototype)for(var prop in styles)destination[prop]=styles[prop];else Object.keys(styles).forEach(function(prop){return destination[prop]=styles[prop]});return destination}function setStyles(element,styles){element.style&&Object.keys(styles).forEach(function(prop){return element.style[prop]=styles[prop]})}function eraseStyles(element,styles){element.style&&Object.keys(styles).forEach(function(prop){element.style[prop]=""})}/**
 * @license
 * Copyright Google Inc. All Rights Reserved.
 *
 * Use of this source code is governed by an MIT-style license that can be
 * found in the LICENSE file at https://angular.io/license
 */
function visitAnimationNode(visitor,node,context){switch(node.type){case 0:return visitor.visitState(node,context);case 1:return visitor.visitTransition(node,context);case 2:return visitor.visitSequence(node,context);case 3:return visitor.visitGroup(node,context);case 4:return visitor.visitAnimate(node,context);case 5:return visitor.visitKeyframeSequence(node,context);case 6:return visitor.visitStyle(node,context);default:throw new Error("Unable to resolve animation metadata node #"+node.type)}}function parseTransitionExpr(transitionValue,errors){var expressions=[];return"string"==typeof transitionValue?transitionValue.split(/\s*,\s*/).forEach(function(str){return parseInnerTransitionStr(str,expressions,errors)}):expressions.push(transitionValue),expressions}function parseInnerTransitionStr(eventStr,expressions,errors){":"==eventStr[0]&&(eventStr=parseAnimationAlias(eventStr,errors));var match=eventStr.match(/^(\*|[-\w]+)\s*(<?[=-]>)\s*(\*|[-\w]+)$/);if(null==match||match.length<4)return errors.push('The provided transition expression "'+eventStr+'" is not supported'),expressions;var fromState=match[1],separator=match[2],toState=match[3];expressions.push(makeLambdaFromStates(fromState,toState));var isFullAnyStateExpr=fromState==ANY_STATE&&toState==ANY_STATE;"<"!=separator[0]||isFullAnyStateExpr||expressions.push(makeLambdaFromStates(toState,fromState))}function parseAnimationAlias(alias,errors){switch(alias){case":enter":return"void => *";case":leave":return"* => void";default:return errors.push('The transition alias value "'+alias+'" is not supported'),"* => *"}}function makeLambdaFromStates(lhs,rhs){return function(fromState,toState){var lhsMatch=lhs==ANY_STATE||lhs==fromState,rhsMatch=rhs==ANY_STATE||rhs==toState;return lhsMatch&&rhsMatch}}/**
 * @license
 * Copyright Google Inc. All Rights Reserved.
 *
 * Use of this source code is governed by an MIT-style license that can be
 * found in the LICENSE file at https://angular.io/license
 */
function createTimelineInstruction(keyframes,duration,delay,easing){return{type:1,keyframes:keyframes,duration:duration,delay:delay,totalTime:duration+delay,easing:easing}}/**
 * @license
 * Copyright Google Inc. All Rights Reserved.
 *
 * Use of this source code is governed by an MIT-style license that can be
 * found in the LICENSE file at https://angular.io/license
 */
function buildAnimationKeyframes(ast,startingStyles,finalStyles){void 0===startingStyles&&(startingStyles={}),void 0===finalStyles&&(finalStyles={});var normalizedAst=Array.isArray(ast)?_angular_animations.sequence(ast):ast;return(new AnimationTimelineVisitor).buildKeyframes(normalizedAst,startingStyles,finalStyles)}function getOffset(ast){var offset=ast.offset;if(null==offset){var styles=ast.styles;if(Array.isArray(styles))for(var i=0;i<styles.length;i++){var o=styles[i].offset;if(null!=o){offset=o;break}}else offset=styles.offset}return offset}/**
 * @license
 * Copyright Google Inc. All Rights Reserved.
 *
 * Use of this source code is governed by an MIT-style license that can be
 * found in the LICENSE file at https://angular.io/license
 */
function createTransitionInstruction(triggerName,fromState,toState,isRemovalTransition,fromStyles,toStyles,timelines){return{type:0,triggerName:triggerName,isRemovalTransition:isRemovalTransition,fromState:fromState,fromStyles:fromStyles,toState:toState,toStyles:toStyles,timelines:timelines}}function oneOrMoreTransitionsMatch(matchFns,currentState,nextState){return matchFns.some(function(fn){return fn(currentState,nextState)})}/**
 * @license
 * Copyright Google Inc. All Rights Reserved.
 *
 * Use of this source code is governed by an MIT-style license that can be
 * found in the LICENSE file at https://angular.io/license
 */
function validateAnimationSequence(ast){var normalizedAst=Array.isArray(ast)?_angular_animations.sequence(ast):ast;return(new AnimationValidatorVisitor).validate(normalizedAst)}/**
 * @license
 * Copyright Google Inc. All Rights Reserved.
 *
 * Use of this source code is governed by an MIT-style license that can be
 * found in the LICENSE file at https://angular.io/license
 */
function buildTrigger(name,definitions){return(new AnimationTriggerVisitor).buildTrigger(name,definitions)}function getOrSetAsInMap(map,key,defaultValue){var value=map.get(key);return value||map.set(key,value=defaultValue),value}function deleteFromArrayMap(map,key,value){var arr=map.get(key);if(arr){var index=arr.indexOf(value);index>=0&&(arr.splice(index,1),0==arr.length&&map.delete(key))}}function optimizeGroupPlayer(players){switch(players.length){case 0:return new _angular_animations.NoopAnimationPlayer;case 1:return players[0];default:return new _angular_animations.ɵAnimationGroupPlayer(players)}}function copyArray(source){return source?source.splice(0):[]}function validatePlayerEvent(triggerName,eventName){switch(eventName){case"start":case"done":return;default:throw new Error('The provided animation trigger event "'+eventName+'" for the animation trigger "'+triggerName+'" is not supported!')}}function listenOnPlayer(player,eventName,baseEvent,callback){switch(eventName){case"start":player.onStart(function(){var event=copyAnimationEvent(baseEvent);event.phaseName="start",callback(event)});break;case"done":player.onDone(function(){var event=copyAnimationEvent(baseEvent);event.phaseName="done",callback(event)})}}function copyAnimationEvent(e){return makeAnimationEvent(e.element,e.triggerName,e.fromState,e.toState,e.phaseName,e.totalTime)}function makeAnimationEvent(element,triggerName,fromState,toState,phaseName,totalTime){return{element:element,triggerName:triggerName,fromState:fromState,toState:toState,phaseName:phaseName,totalTime:totalTime}}function normalizeTriggerValue(value){switch(typeof value){case"boolean":return value?"1":"0";default:return value?value.toString():null}}function makeBooleanMap(keys){var map={};return keys.forEach(function(key){return map[key]=!0}),map}function dashCaseToCamelCase(input){return input.replace(DASH_CASE_REGEXP,function(){for(var m=[],_i=0;_i<arguments.length;_i++)m[_i]=arguments[_i];return m[1].toUpperCase()})}function makeAnimationEvent$1(element,triggerName,fromState,toState,phaseName,totalTime){return{element:element,triggerName:triggerName,fromState:fromState,toState:toState,phaseName:phaseName,totalTime:totalTime}}function makeStorageProp(property){return"_@_"+property}function _computeStyle(element,prop){return window.getComputedStyle(element)[prop]}function _copyKeyframeStyles(styles){var newStyles={};return Object.keys(styles).forEach(function(prop){"offset"!=prop&&(newStyles[prop]=styles[prop])}),newStyles}function supportsWebAnimations(){return"undefined"!=typeof Element&&"function"==typeof Element.prototype.animate}var __extends=function(d,b){function __(){this.constructor=d}for(var p in b)b.hasOwnProperty(p)&&(d[p]=b[p]);d.prototype=null===b?Object.create(b):(__.prototype=b.prototype,new __)},NoopAnimationDriver=function(){function NoopAnimationDriver(){}return NoopAnimationDriver.prototype.animate=function(element,keyframes,duration,delay,easing,previousPlayers){return void 0===previousPlayers&&(previousPlayers=[]),new _angular_animations.NoopAnimationPlayer},NoopAnimationDriver}(),AnimationDriver=function(){function AnimationDriver(){}return AnimationDriver}();AnimationDriver.NOOP=new NoopAnimationDriver;/**
 * @license
 * Copyright Google Inc. All Rights Reserved.
 *
 * Use of this source code is governed by an MIT-style license that can be
 * found in the LICENSE file at https://angular.io/license
 */
var AnimationEngine=function(){function AnimationEngine(){}return AnimationEngine.prototype.registerTrigger=function(trigger,name){},AnimationEngine.prototype.onInsert=function(element,domFn){},AnimationEngine.prototype.onRemove=function(element,domFn){},AnimationEngine.prototype.setProperty=function(element,property,value){},AnimationEngine.prototype.listen=function(element,eventName,eventPhase,callback){},AnimationEngine.prototype.flush=function(){},Object.defineProperty(AnimationEngine.prototype,"activePlayers",{get:function(){throw new Error("...")},enumerable:!0,configurable:!0}),Object.defineProperty(AnimationEngine.prototype,"queuedPlayers",{get:function(){throw new Error("...")},enumerable:!0,configurable:!0}),AnimationEngine}(),ONE_SECOND=1e3,ANY_STATE="*",AnimationTimelineContext=function(){function AnimationTimelineContext(errors,timelines,initialTimeline){void 0===initialTimeline&&(initialTimeline=null),this.errors=errors,this.timelines=timelines,this.previousNode={},this.subContextCount=0,this.currentTimeline=initialTimeline||new TimelineBuilder(0),timelines.push(this.currentTimeline)}return AnimationTimelineContext.prototype.createSubContext=function(){var context=new AnimationTimelineContext(this.errors,this.timelines,this.currentTimeline.fork());return context.previousNode=this.previousNode,context.currentAnimateTimings=this.currentAnimateTimings,this.subContextCount++,context},AnimationTimelineContext.prototype.transformIntoNewTimeline=function(newTime){return void 0===newTime&&(newTime=0),this.currentTimeline=this.currentTimeline.fork(newTime),this.timelines.push(this.currentTimeline),this.currentTimeline},AnimationTimelineContext.prototype.incrementTime=function(time){this.currentTimeline.forwardTime(this.currentTimeline.duration+time)},AnimationTimelineContext}(),AnimationTimelineVisitor=function(){function AnimationTimelineVisitor(){}return AnimationTimelineVisitor.prototype.buildKeyframes=function(ast,startingStyles,finalStyles){var context=new AnimationTimelineContext([],[]);context.currentTimeline.setStyles(startingStyles),visitAnimationNode(this,ast,context);var timelines=context.timelines.filter(function(timeline){return timeline.hasStyling()});if(timelines.length&&Object.keys(finalStyles).length){var tl=timelines[timelines.length-1];tl.allowOnlyTimelineStyles()||tl.setStyles(finalStyles)}return timelines.length?timelines.map(function(timeline){return timeline.buildKeyframes()}):[createTimelineInstruction([],0,0,"")]},AnimationTimelineVisitor.prototype.visitState=function(ast,context){},AnimationTimelineVisitor.prototype.visitTransition=function(ast,context){},AnimationTimelineVisitor.prototype.visitSequence=function(ast,context){var _this=this,subContextCount=context.subContextCount;6==context.previousNode.type&&(context.currentTimeline.forwardFrame(),context.currentTimeline.snapshotCurrentStyles()),ast.steps.forEach(function(s){return visitAnimationNode(_this,s,context)}),context.subContextCount>subContextCount&&context.transformIntoNewTimeline(),context.previousNode=ast},AnimationTimelineVisitor.prototype.visitGroup=function(ast,context){var _this=this,innerTimelines=[],furthestTime=context.currentTimeline.currentTime;ast.steps.forEach(function(s){var innerContext=context.createSubContext();visitAnimationNode(_this,s,innerContext),furthestTime=Math.max(furthestTime,innerContext.currentTimeline.currentTime),innerTimelines.push(innerContext.currentTimeline)}),innerTimelines.forEach(function(timeline){return context.currentTimeline.mergeTimelineCollectedStyles(timeline)}),context.transformIntoNewTimeline(furthestTime),context.previousNode=ast},AnimationTimelineVisitor.prototype.visitAnimate=function(ast,context){var timings=ast.timings.hasOwnProperty("duration")?ast.timings:parseTimeExpression(ast.timings,context.errors);context.currentAnimateTimings=timings,timings.delay&&(context.incrementTime(timings.delay),context.currentTimeline.snapshotCurrentStyles());var astType=ast.styles?ast.styles.type:-1;if(5==astType)this.visitKeyframeSequence(ast.styles,context);else{var styleAst=ast.styles;if(!styleAst){var newStyleData={};timings.easing&&(newStyleData.easing=timings.easing),styleAst=_angular_animations.style(newStyleData),styleAst.treatAsEmptyStep=!0}context.incrementTime(timings.duration),styleAst&&this.visitStyle(styleAst,context)}context.currentAnimateTimings=null,context.previousNode=ast},AnimationTimelineVisitor.prototype.visitStyle=function(ast,context){context.currentAnimateTimings||4!=context.previousNode.type||context.currentTimeline.forwardFrame();var normalizedStyles=normalizeStyles(ast.styles),easing=context.currentAnimateTimings&&context.currentAnimateTimings.easing;this._applyStyles(normalizedStyles,easing,!!ast.treatAsEmptyStep,context),context.previousNode=ast},AnimationTimelineVisitor.prototype._applyStyles=function(styles,easing,treatAsEmptyStep,context){styles.hasOwnProperty("easing")&&(easing=easing||styles.easing,delete styles.easing),context.currentTimeline.setStyles(styles,easing,treatAsEmptyStep)},AnimationTimelineVisitor.prototype.visitKeyframeSequence=function(ast,context){var _this=this,MAX_KEYFRAME_OFFSET=1,limit=ast.steps.length-1,firstKeyframe=ast.steps[0],offsetGap=0,containsOffsets=null!=getOffset(firstKeyframe);containsOffsets||(offsetGap=MAX_KEYFRAME_OFFSET/limit);var startTime=context.currentTimeline.duration,duration=context.currentAnimateTimings.duration,innerContext=context.createSubContext(),innerTimeline=innerContext.currentTimeline;innerTimeline.easing=context.currentAnimateTimings.easing,ast.steps.forEach(function(step,i){var normalizedStyles=normalizeStyles(step.styles),offset=containsOffsets?null!=step.offset?step.offset:parseFloat(normalizedStyles.offset):i==limit?MAX_KEYFRAME_OFFSET:i*offsetGap;innerTimeline.forwardTime(offset*duration),_this._applyStyles(normalizedStyles,null,!1,innerContext)}),context.currentTimeline.mergeTimelineCollectedStyles(innerTimeline),context.transformIntoNewTimeline(startTime+duration),context.previousNode=ast},AnimationTimelineVisitor}(),TimelineBuilder=function(){function TimelineBuilder(startTime,_globalTimelineStyles){void 0===_globalTimelineStyles&&(_globalTimelineStyles=null),this.startTime=startTime,this._globalTimelineStyles=_globalTimelineStyles,this.duration=0,this.easing="",this._previousKeyframe={},this._keyframes=new Map,this._styleSummary={},this._backFill={},this._currentEmptyStepKeyframe=null,this._localTimelineStyles=Object.create(this._backFill,{}),this._globalTimelineStyles||(this._globalTimelineStyles=this._localTimelineStyles),this._loadKeyframe()}return TimelineBuilder.prototype.hasStyling=function(){return this._keyframes.size>1},Object.defineProperty(TimelineBuilder.prototype,"currentTime",{get:function(){return this.startTime+this.duration},enumerable:!0,configurable:!0}),TimelineBuilder.prototype.fork=function(currentTime){return void 0===currentTime&&(currentTime=0),new TimelineBuilder(currentTime||this.currentTime,this._globalTimelineStyles)},TimelineBuilder.prototype._loadKeyframe=function(){this._currentKeyframe&&(this._previousKeyframe=this._currentKeyframe),this._currentKeyframe=this._keyframes.get(this.duration),this._currentKeyframe||(this._currentKeyframe=Object.create(this._backFill,{}),this._keyframes.set(this.duration,this._currentKeyframe))},TimelineBuilder.prototype.forwardFrame=function(){this.duration++,this._loadKeyframe()},TimelineBuilder.prototype.forwardTime=function(time){this.duration=time,this._loadKeyframe()},TimelineBuilder.prototype._updateStyle=function(prop,value){this._localTimelineStyles[prop]=value,this._globalTimelineStyles[prop]=value,this._styleSummary[prop]={time:this.currentTime,value:value}},TimelineBuilder.prototype.allowOnlyTimelineStyles=function(){return this._currentEmptyStepKeyframe!==this._currentKeyframe},TimelineBuilder.prototype.setStyles=function(styles,easing,treatAsEmptyStep){var _this=this;void 0===easing&&(easing=null),void 0===treatAsEmptyStep&&(treatAsEmptyStep=!1),easing&&(this._previousKeyframe.easing=easing),treatAsEmptyStep?(Object.keys(this._globalTimelineStyles).forEach(function(prop){_this._backFill[prop]=_this._globalTimelineStyles[prop]||_angular_animations.AUTO_STYLE,_this._currentKeyframe[prop]=_angular_animations.AUTO_STYLE}),this._currentEmptyStepKeyframe=this._currentKeyframe):(Object.keys(styles).forEach(function(prop){if("offset"!==prop){var val=styles[prop];_this._currentKeyframe[prop]=val,_this._localTimelineStyles[prop]||(_this._backFill[prop]=_this._globalTimelineStyles[prop]||_angular_animations.AUTO_STYLE),_this._updateStyle(prop,val)}}),Object.keys(this._localTimelineStyles).forEach(function(prop){_this._currentKeyframe.hasOwnProperty(prop)||(_this._currentKeyframe[prop]=_this._localTimelineStyles[prop])}))},TimelineBuilder.prototype.snapshotCurrentStyles=function(){copyStyles(this._localTimelineStyles,!1,this._currentKeyframe)},TimelineBuilder.prototype.getFinalKeyframe=function(){return this._keyframes.get(this.duration)},Object.defineProperty(TimelineBuilder.prototype,"properties",{get:function(){var properties=[];for(var prop in this._currentKeyframe)properties.push(prop);return properties},enumerable:!0,configurable:!0}),TimelineBuilder.prototype.mergeTimelineCollectedStyles=function(timeline){var _this=this;Object.keys(timeline._styleSummary).forEach(function(prop){var details0=_this._styleSummary[prop],details1=timeline._styleSummary[prop];(!details0||details1.time>details0.time)&&_this._updateStyle(prop,details1.value)})},TimelineBuilder.prototype.buildKeyframes=function(){var _this=this,finalKeyframes=[];if(0==this.duration){var targetKeyframe=this.getFinalKeyframe(),firstKeyframe=copyStyles(targetKeyframe,!0);firstKeyframe.offset=0,finalKeyframes.push(firstKeyframe);var lastKeyframe=copyStyles(targetKeyframe,!0);lastKeyframe.offset=1,finalKeyframes.push(lastKeyframe)}else this._keyframes.forEach(function(keyframe,time){var finalKeyframe=copyStyles(keyframe,!0);finalKeyframe.offset=time/_this.duration,finalKeyframes.push(finalKeyframe)});return createTimelineInstruction(finalKeyframes,this.duration,this.startTime,this.easing)},TimelineBuilder}(),AnimationTransitionFactory=function(){function AnimationTransitionFactory(_triggerName,ast,matchFns,_stateStyles){this._triggerName=_triggerName,this.matchFns=matchFns,this._stateStyles=_stateStyles;var normalizedAst=Array.isArray(ast.animation)?_angular_animations.sequence(ast.animation):ast.animation;this._animationAst=normalizedAst}return AnimationTransitionFactory.prototype.match=function(currentState,nextState){if(oneOrMoreTransitionsMatch(this.matchFns,currentState,nextState)){var backupStateStyles=this._stateStyles["*"]||{},currentStateStyles=this._stateStyles[currentState]||backupStateStyles,nextStateStyles=this._stateStyles[nextState]||backupStateStyles,timelines=buildAnimationKeyframes(this._animationAst,currentStateStyles,nextStateStyles);return createTransitionInstruction(this._triggerName,currentState,nextState,"void"===nextState,currentStateStyles,nextStateStyles,timelines)}},AnimationTransitionFactory}(),AnimationValidatorVisitor=function(){function AnimationValidatorVisitor(){}return AnimationValidatorVisitor.prototype.validate=function(ast){var context=new AnimationValidatorContext;return visitAnimationNode(this,ast,context),context.errors},AnimationValidatorVisitor.prototype.visitState=function(ast,context){},AnimationValidatorVisitor.prototype.visitTransition=function(ast,context){},AnimationValidatorVisitor.prototype.visitSequence=function(ast,context){var _this=this;ast.steps.forEach(function(step){return visitAnimationNode(_this,step,context)})},AnimationValidatorVisitor.prototype.visitGroup=function(ast,context){var _this=this,currentTime=context.currentTime,furthestTime=0;ast.steps.forEach(function(step){context.currentTime=currentTime,visitAnimationNode(_this,step,context),furthestTime=Math.max(furthestTime,context.currentTime)}),context.currentTime=furthestTime},AnimationValidatorVisitor.prototype.visitAnimate=function(ast,context){context.currentAnimateTimings=ast.timings=parseTimeExpression(ast.timings,context.errors);var astType=ast.styles&&ast.styles.type;5==astType?this.visitKeyframeSequence(ast.styles,context):(context.currentTime+=context.currentAnimateTimings.duration+context.currentAnimateTimings.delay,6==astType&&this.visitStyle(ast.styles,context)),context.currentAnimateTimings=null},AnimationValidatorVisitor.prototype.visitStyle=function(ast,context){var styleData=normalizeStyles(ast.styles),timings=context.currentAnimateTimings,endTime=context.currentTime,startTime=context.currentTime;timings&&startTime>0&&(startTime-=timings.duration+timings.delay),Object.keys(styleData).forEach(function(prop){var collectedEntry=context.collectedStyles[prop],updateCollectedStyle=!0;collectedEntry&&(startTime!=endTime&&startTime>=collectedEntry.startTime&&endTime<=collectedEntry.endTime&&(context.errors.push('The CSS property "'+prop+'" that exists between the times of "'+collectedEntry.startTime+'ms" and "'+collectedEntry.endTime+'ms" is also being animated in a parallel animation between the times of "'+startTime+'ms" and "'+endTime+'ms"'),updateCollectedStyle=!1),startTime=collectedEntry.startTime),updateCollectedStyle&&(context.collectedStyles[prop]={startTime:startTime,endTime:endTime})})},AnimationValidatorVisitor.prototype.visitKeyframeSequence=function(ast,context){var _this=this,totalKeyframesWithOffsets=0,offsets=[],offsetsOutOfOrder=!1,keyframesOutOfRange=!1,previousOffset=0;ast.steps.forEach(function(step){var styleData=normalizeStyles(step.styles),offset=0;styleData.hasOwnProperty("offset")&&(totalKeyframesWithOffsets++,offset=styleData.offset),keyframesOutOfRange=keyframesOutOfRange||offset<0||offset>1,offsetsOutOfOrder=offsetsOutOfOrder||offset<previousOffset,previousOffset=offset,offsets.push(offset)}),keyframesOutOfRange&&context.errors.push("Please ensure that all keyframe offsets are between 0 and 1"),offsetsOutOfOrder&&context.errors.push("Please ensure that all keyframe offsets are in order");var length=ast.steps.length,generatedOffset=0;totalKeyframesWithOffsets>0&&totalKeyframesWithOffsets<length?context.errors.push("Not all style() steps within the declared keyframes() contain offsets"):0==totalKeyframesWithOffsets&&(generatedOffset=1/length);var limit=length-1,currentTime=context.currentTime,animateDuration=context.currentAnimateTimings.duration;ast.steps.forEach(function(step,i){var offset=generatedOffset>0?i==limit?1:generatedOffset*i:offsets[i],durationUpToThisFrame=offset*animateDuration;context.currentTime=currentTime+context.currentAnimateTimings.delay+durationUpToThisFrame,context.currentAnimateTimings.duration=durationUpToThisFrame,_this.visitStyle(step,context)})},AnimationValidatorVisitor}(),AnimationValidatorContext=function(){function AnimationValidatorContext(){this.errors=[],this.currentTime=0,this.collectedStyles={}}return AnimationValidatorContext}(),AnimationTrigger=function(){function AnimationTrigger(name,states,_transitionAsts){var _this=this;this.name=name,this._transitionAsts=_transitionAsts,this.transitionFactories=[],this.states={},Object.keys(states).forEach(function(stateName){_this.states[stateName]=copyStyles(states[stateName],!1)});var errors=[];if(_transitionAsts.forEach(function(ast){var exprs=parseTransitionExpr(ast.expr,errors),sequenceErrors=validateAnimationSequence(ast);sequenceErrors.length?errors.push.apply(errors,sequenceErrors):_this.transitionFactories.push(new AnimationTransitionFactory(_this.name,ast,exprs,states))}),errors.length){var LINE_START="\n - ";throw new Error("Animation parsing for the "+name+" trigger have failed:"+LINE_START+errors.join(LINE_START))}}return AnimationTrigger.prototype.createFallbackInstruction=function(currentState,nextState){var backupStateStyles=this.states["*"]||{},currentStateStyles=this.states[currentState]||backupStateStyles,nextStateStyles=this.states[nextState]||backupStateStyles;return createTransitionInstruction(this.name,currentState,nextState,"void"==nextState,currentStateStyles,nextStateStyles,[])},AnimationTrigger.prototype.matchTransition=function(currentState,nextState){for(var i=0;i<this.transitionFactories.length;i++){var result=this.transitionFactories[i].match(currentState,nextState);if(result)return result}},AnimationTrigger}(),AnimationTriggerContext=function(){function AnimationTriggerContext(){this.errors=[],this.states={},this.transitions=[]}return AnimationTriggerContext}(),AnimationTriggerVisitor=function(){function AnimationTriggerVisitor(){}return AnimationTriggerVisitor.prototype.buildTrigger=function(name,definitions){var _this=this,context=new AnimationTriggerContext;return definitions.forEach(function(def){return visitAnimationNode(_this,def,context)}),new AnimationTrigger(name,context.states,context.transitions)},AnimationTriggerVisitor.prototype.visitState=function(ast,context){var styles=normalizeStyles(ast.styles.styles);ast.name.split(/\s*,\s*/).forEach(function(name){context.states[name]=styles})},AnimationTriggerVisitor.prototype.visitTransition=function(ast,context){context.transitions.push(ast)},AnimationTriggerVisitor.prototype.visitSequence=function(ast,context){},AnimationTriggerVisitor.prototype.visitGroup=function(ast,context){},AnimationTriggerVisitor.prototype.visitAnimate=function(ast,context){},AnimationTriggerVisitor.prototype.visitStyle=function(ast,context){},AnimationTriggerVisitor.prototype.visitKeyframeSequence=function(ast,context){},AnimationTriggerVisitor}(),MARKED_FOR_ANIMATION_CLASSNAME="ng-animating",MARKED_FOR_ANIMATION_SELECTOR=".ng-animating",MARKED_FOR_REMOVAL="$$ngRemove",VOID_STATE="void",DomAnimationEngine=function(){function DomAnimationEngine(_driver,_normalizer){this._driver=_driver,this._normalizer=_normalizer,this._flaggedInserts=new Set,this._queuedRemovals=new Map,this._queuedTransitionAnimations=[],this._activeTransitionAnimations=new Map,this._activeElementAnimations=new Map,this._elementTriggerStates=new Map,this._triggers=Object.create(null),this._triggerListeners=new Map,this._pendingListenerRemovals=new Map}return Object.defineProperty(DomAnimationEngine.prototype,"queuedPlayers",{get:function(){return this._queuedTransitionAnimations.map(function(q){return q.player})},enumerable:!0,configurable:!0}),Object.defineProperty(DomAnimationEngine.prototype,"activePlayers",{get:function(){var players=[];return this._activeElementAnimations.forEach(function(activePlayers){return players.push.apply(players,activePlayers)}),players},enumerable:!0,configurable:!0}),DomAnimationEngine.prototype.registerTrigger=function(trigger,name){void 0===name&&(name=null),name=name||trigger.name,this._triggers[name]||(this._triggers[name]=buildTrigger(name,trigger.definitions))},DomAnimationEngine.prototype.onInsert=function(element,domFn){1==element.nodeType&&this._flaggedInserts.add(element),domFn()},DomAnimationEngine.prototype.onRemove=function(element,domFn){var _this=this;if(1!=element.nodeType)return void domFn();var lookupRef=this._elementTriggerStates.get(element);if(lookupRef){var possibleTriggers=Object.keys(lookupRef),hasRemoval=possibleTriggers.some(function(triggerName){var oldValue=lookupRef[triggerName],instruction=_this._triggers[triggerName].matchTransition(oldValue,VOID_STATE);return!!instruction});if(hasRemoval)return element[MARKED_FOR_REMOVAL]=!0,void this._queuedRemovals.set(element,domFn)}this._triggerListeners.has(element)&&(element[MARKED_FOR_REMOVAL]=!0,this._queuedRemovals.set(element,function(){})),this._onRemovalTransition(element).forEach(function(player){return player.destroy()}),domFn()},DomAnimationEngine.prototype.setProperty=function(element,property,value){var trigger=this._triggers[property];if(!trigger)throw new Error('The provided animation trigger "'+property+'" has not been registered!');var lookupRef=this._elementTriggerStates.get(element);lookupRef||this._elementTriggerStates.set(element,lookupRef={});var oldValue=lookupRef.hasOwnProperty(property)?lookupRef[property]:VOID_STATE;if(oldValue!==value){value=normalizeTriggerValue(value);var instruction=trigger.matchTransition(oldValue,value);instruction||(instruction=trigger.createFallbackInstruction(oldValue,value)),this.animateTransition(element,instruction),lookupRef[property]=value}},DomAnimationEngine.prototype.listen=function(element,eventName,eventPhase,callback){var _this=this;if(!eventPhase)throw new Error('Unable to listen on the animation trigger "'+eventName+'" because the provided event is undefined!');if(!this._triggers[eventName])throw new Error('Unable to listen on the animation trigger event "'+eventPhase+'" because the animation trigger "'+eventName+"\" doesn't exist!");var elementListeners=this._triggerListeners.get(element);elementListeners||this._triggerListeners.set(element,elementListeners=[]),validatePlayerEvent(eventName,eventPhase);var tuple={triggerName:eventName,phase:eventPhase,callback:callback};return elementListeners.push(tuple),function(){getOrSetAsInMap(_this._pendingListenerRemovals,element,[]).push(tuple)}},DomAnimationEngine.prototype._clearPendingListenerRemovals=function(){var _this=this;this._pendingListenerRemovals.forEach(function(tuples,element){var elementListeners=_this._triggerListeners.get(element);elementListeners&&tuples.forEach(function(tuple){var index=elementListeners.indexOf(tuple);index>=0&&elementListeners.splice(index,1)})}),this._pendingListenerRemovals.clear()},DomAnimationEngine.prototype._onRemovalTransition=function(element){for(var elms=element.querySelectorAll(MARKED_FOR_ANIMATION_SELECTOR),_loop_1=function(i){var elm=elms[i],activePlayers=this_1._activeElementAnimations.get(elm);activePlayers&&activePlayers.forEach(function(player){return player.destroy()});var activeTransitions=this_1._activeTransitionAnimations.get(elm);activeTransitions&&Object.keys(activeTransitions).forEach(function(triggerName){var player=activeTransitions[triggerName];player&&player.destroy()})},this_1=this,i=0;i<elms.length;i++)_loop_1(i);return copyArray(this._activeElementAnimations.get(element))},DomAnimationEngine.prototype.animateTransition=function(element,instruction){var previousPlayers,_this=this,triggerName=instruction.triggerName;if(instruction.isRemovalTransition)previousPlayers=this._onRemovalTransition(element);else{previousPlayers=[];var existingTransitions=this._activeTransitionAnimations.get(element),existingPlayer=existingTransitions?existingTransitions[triggerName]:null;existingPlayer&&previousPlayers.push(existingPlayer)}eraseStyles(element,instruction.fromStyles);var totalTime=0,players=instruction.timelines.map(function(timelineInstruction,i){return totalTime=Math.max(totalTime,timelineInstruction.totalTime),_this._buildPlayer(element,timelineInstruction,previousPlayers,i)});previousPlayers.forEach(function(previousPlayer){return previousPlayer.destroy()});var player=optimizeGroupPlayer(players);player.onDone(function(){player.destroy();var elmTransitionMap=_this._activeTransitionAnimations.get(element);elmTransitionMap&&(delete elmTransitionMap[triggerName],0==Object.keys(elmTransitionMap).length&&_this._activeTransitionAnimations.delete(element)),deleteFromArrayMap(_this._activeElementAnimations,element,player),setStyles(element,instruction.toStyles)});var elmTransitionMap=getOrSetAsInMap(this._activeTransitionAnimations,element,{});return elmTransitionMap[triggerName]=player,this._queuePlayer(element,triggerName,player,makeAnimationEvent(element,triggerName,instruction.fromState,instruction.toState,null,totalTime)),player},DomAnimationEngine.prototype.animateTimeline=function(element,instructions,previousPlayers){var _this=this;void 0===previousPlayers&&(previousPlayers=[]);var players=instructions.map(function(instruction,i){var player=_this._buildPlayer(element,instruction,previousPlayers,i);return player.onDestroy(function(){deleteFromArrayMap(_this._activeElementAnimations,element,player)}),player.init(),_this._markPlayerAsActive(element,player),player});return optimizeGroupPlayer(players)},DomAnimationEngine.prototype._buildPlayer=function(element,instruction,previousPlayers,index){return void 0===index&&(index=0),index&&previousPlayers.length&&(previousPlayers=[]),this._driver.animate(element,this._normalizeKeyframes(instruction.keyframes),instruction.duration,instruction.delay,instruction.easing,previousPlayers)},DomAnimationEngine.prototype._normalizeKeyframes=function(keyframes){var _this=this,errors=[],normalizedKeyframes=[];if(keyframes.forEach(function(kf){var normalizedKeyframe={};Object.keys(kf).forEach(function(prop){var normalizedProp=prop,normalizedValue=kf[prop];"offset"!=prop&&(normalizedProp=_this._normalizer.normalizePropertyName(prop,errors),normalizedValue=_this._normalizer.normalizeStyleValue(prop,normalizedProp,kf[prop],errors)),normalizedKeyframe[normalizedProp]=normalizedValue}),normalizedKeyframes.push(normalizedKeyframe)}),errors.length){var LINE_START="\n - ";throw new Error("Unable to animate due to the following errors:"+LINE_START+errors.join(LINE_START))}return normalizedKeyframes},DomAnimationEngine.prototype._markPlayerAsActive=function(element,player){var elementAnimations=getOrSetAsInMap(this._activeElementAnimations,element,[]);elementAnimations.push(player)},DomAnimationEngine.prototype._queuePlayer=function(element,triggerName,player,event){var tuple={element:element,player:player,triggerName:triggerName,event:event};this._queuedTransitionAnimations.push(tuple),player.init(),element.classList.add(MARKED_FOR_ANIMATION_CLASSNAME),player.onDone(function(){element.classList.remove(MARKED_FOR_ANIMATION_CLASSNAME)})},DomAnimationEngine.prototype._flushQueuedAnimations=function(){var _loop_2=function(){for(var _a=this_2._queuedTransitionAnimations.shift(),player=_a.player,element=_a.element,triggerName=_a.triggerName,event=_a.event,parent=element;parent=parent.parentNode;)if(parent[MARKED_FOR_REMOVAL])return"continue-parentLoop";var listeners=this_2._triggerListeners.get(element);return listeners&&listeners.forEach(function(tuple){tuple.triggerName==triggerName&&listenOnPlayer(player,tuple.phase,event,tuple.callback)}),this_2._queuedRemovals.has(element)?(player.destroy(),"continue"):(this_2._markPlayerAsActive(element,player),void(player.hasStarted()||player.play()))},this_2=this;parentLoop:for(;this._queuedTransitionAnimations.length;){var state_1=_loop_2();switch(state_1){case"continue-parentLoop":continue parentLoop}}},DomAnimationEngine.prototype.flush=function(){var _this=this,leaveListeners=new Map;this._queuedRemovals.forEach(function(callback,element){var tuple=_this._pendingListenerRemovals.get(element);tuple&&(leaveListeners.set(element,tuple),_this._pendingListenerRemovals.delete(element))}),this._clearPendingListenerRemovals(),this._pendingListenerRemovals=leaveListeners,this._flushQueuedAnimations();var flushAgain=!1;this._queuedRemovals.forEach(function(callback,element){if(!_this._flaggedInserts.has(element)){for(var parent=element,players=[];parent=parent.parentNode;){if(parent[MARKED_FOR_REMOVAL])return void callback();var match=_this._activeElementAnimations.get(parent);if(match){players.push.apply(players,match);break}}if(0==players.length){var stateDetails_1=_this._elementTriggerStates.get(element);stateDetails_1&&Object.keys(stateDetails_1).forEach(function(triggerName){flushAgain=!0;var oldValue=stateDetails_1[triggerName],instruction=_this._triggers[triggerName].matchTransition(oldValue,VOID_STATE);if(instruction)players.push(_this.animateTransition(element,instruction));else{var event=makeAnimationEvent(element,triggerName,oldValue,VOID_STATE,"",0),player=new _angular_animations.NoopAnimationPlayer;_this._queuePlayer(element,triggerName,player,event)}})}players.length?optimizeGroupPlayer(players).onDone(callback):callback()}}),this._queuedRemovals.clear(),this._flaggedInserts.clear(),flushAgain&&(this._flushQueuedAnimations(),this._clearPendingListenerRemovals())},DomAnimationEngine}(),AnimationStyleNormalizer=function(){function AnimationStyleNormalizer(){}return AnimationStyleNormalizer.prototype.normalizePropertyName=function(propertyName,errors){},AnimationStyleNormalizer.prototype.normalizeStyleValue=function(userProvidedProperty,normalizedProperty,value,errors){},AnimationStyleNormalizer}(),NoopAnimationStyleNormalizer=function(){function NoopAnimationStyleNormalizer(){}return NoopAnimationStyleNormalizer.prototype.normalizePropertyName=function(propertyName,errors){return propertyName},NoopAnimationStyleNormalizer.prototype.normalizeStyleValue=function(userProvidedProperty,normalizedProperty,value,errors){return value},NoopAnimationStyleNormalizer}(),Animation=function(){function Animation(input){var ast=Array.isArray(input)?_angular_animations.sequence(input):input,errors=validateAnimationSequence(ast);if(errors.length){var errorMessage="animation validation failed:\n"+errors.join("\n");throw new Error(errorMessage)}this._animationAst=ast}return Animation.prototype.buildTimelines=function(startingStyles,destinationStyles){var start=Array.isArray(startingStyles)?normalizeStyles(startingStyles):startingStyles,dest=Array.isArray(destinationStyles)?normalizeStyles(destinationStyles):destinationStyles;return buildAnimationKeyframes(this._animationAst,start,dest)},Animation.prototype.create=function(injector,element,startingStyles,destinationStyles){void 0===startingStyles&&(startingStyles={}),void 0===destinationStyles&&(destinationStyles={});var instructions=this.buildTimelines(startingStyles,destinationStyles),driver=injector.get(AnimationDriver),normalizer=injector.get(AnimationStyleNormalizer),engine=new DomAnimationEngine(driver,normalizer);return engine.animateTimeline(element,instructions)},Animation}(),WebAnimationsStyleNormalizer=function(_super){function WebAnimationsStyleNormalizer(){return null!==_super&&_super.apply(this,arguments)||this}return __extends(WebAnimationsStyleNormalizer,_super),WebAnimationsStyleNormalizer.prototype.normalizePropertyName=function(propertyName,errors){return dashCaseToCamelCase(propertyName)},WebAnimationsStyleNormalizer.prototype.normalizeStyleValue=function(userProvidedProperty,normalizedProperty,value,errors){var unit="",strVal=value.toString().trim();if(DIMENSIONAL_PROP_MAP[normalizedProperty]&&0!==value&&"0"!==value)if("number"==typeof value)unit="px";else{var valAndSuffixMatch=value.match(/^[+-]?[\d\.]+([a-z]*)$/);valAndSuffixMatch&&0==valAndSuffixMatch[1].length&&errors.push("Please provide a CSS unit value for "+userProvidedProperty+":"+value)}return strVal+unit},WebAnimationsStyleNormalizer}(AnimationStyleNormalizer),DIMENSIONAL_PROP_MAP=makeBooleanMap("width,height,minWidth,minHeight,maxWidth,maxHeight,left,top,bottom,right,fontSize,outlineWidth,outlineOffset,paddingTop,paddingLeft,paddingBottom,paddingRight,marginTop,marginLeft,marginBottom,marginRight,borderRadius,borderWidth,borderTopWidth,borderLeftWidth,borderRightWidth,borderBottomWidth,textIndent".split(",")),DASH_CASE_REGEXP=/-+([a-z0-9])/g,DEFAULT_STATE_VALUE="void",DEFAULT_STATE_STYLES="*",NoopAnimationEngine=function(_super){function NoopAnimationEngine(){var _this=_super.apply(this,arguments)||this;return _this._listeners=new Map,_this._changes=[],_this._flaggedRemovals=new Set,_this._onDoneFns=[],_this._triggerStyles=Object.create(null),_this}return __extends(NoopAnimationEngine,_super),NoopAnimationEngine.prototype.registerTrigger=function(trigger,name){if(void 0===name&&(name=null),name=name||trigger.name,!this._triggerStyles[name]){var stateMap={};trigger.definitions.forEach(function(def){if(0===def.type){var stateDef=def;stateMap[stateDef.name]=normalizeStyles(stateDef.styles.styles)}}),this._triggerStyles[name]=stateMap}},NoopAnimationEngine.prototype.onInsert=function(element,domFn){domFn()},NoopAnimationEngine.prototype.onRemove=function(element,domFn){domFn(),1==element.nodeType&&this._flaggedRemovals.add(element)},NoopAnimationEngine.prototype.setProperty=function(element,property,value){var storageProp=makeStorageProp(property),oldValue=element[storageProp]||DEFAULT_STATE_VALUE;
this._changes.push({element:element,oldValue:oldValue,newValue:value,triggerName:property});var triggerStateStyles=this._triggerStyles[property]||{},fromStateStyles=triggerStateStyles[oldValue]||triggerStateStyles[DEFAULT_STATE_STYLES];fromStateStyles&&eraseStyles(element,fromStateStyles),element[storageProp]=value,this._onDoneFns.push(function(){var toStateStyles=triggerStateStyles[value]||triggerStateStyles[DEFAULT_STATE_STYLES];toStateStyles&&setStyles(element,toStateStyles)})},NoopAnimationEngine.prototype.listen=function(element,eventName,eventPhase,callback){var listeners=this._listeners.get(element);listeners||this._listeners.set(element,listeners=[]);var tuple={triggerName:eventName,eventPhase:eventPhase,callback:callback};return listeners.push(tuple),function(){return tuple.doRemove=!0}},NoopAnimationEngine.prototype.flush=function(){function handleListener(listener,data){var phase=listener.eventPhase,event=makeAnimationEvent$1(data.element,data.triggerName,data.oldValue,data.newValue,phase,0);"start"==phase?onStartCallbacks.push(function(){return listener.callback(event)}):"done"==phase&&onDoneCallbacks.push(function(){return listener.callback(event)})}var _this=this,onStartCallbacks=[],onDoneCallbacks=[];this._changes.forEach(function(change){var element=change.element,listeners=_this._listeners.get(element);listeners&&listeners.forEach(function(listener){listener.triggerName==change.triggerName&&handleListener(listener,change)})}),this._flaggedRemovals.forEach(function(element){var listeners=_this._listeners.get(element);listeners&&listeners.forEach(function(listener){var triggerName=listener.triggerName,storageProp=makeStorageProp(triggerName);handleListener(listener,{element:element,triggerName:triggerName,oldValue:element[storageProp]||DEFAULT_STATE_VALUE,newValue:DEFAULT_STATE_VALUE})})}),Array.from(this._listeners.keys()).forEach(function(element){var listenersToKeep=_this._listeners.get(element).filter(function(l){return!l.doRemove});listenersToKeep.length?_this._listeners.set(element,listenersToKeep):_this._listeners.delete(element)}),onStartCallbacks.forEach(function(fn){return fn()}),onDoneCallbacks.forEach(function(fn){return fn()}),this._flaggedRemovals.clear(),this._changes=[],this._onDoneFns.forEach(function(doneFn){return doneFn()}),this._onDoneFns=[]},Object.defineProperty(NoopAnimationEngine.prototype,"activePlayers",{get:function(){return[]},enumerable:!0,configurable:!0}),Object.defineProperty(NoopAnimationEngine.prototype,"queuedPlayers",{get:function(){return[]},enumerable:!0,configurable:!0}),NoopAnimationEngine}(AnimationEngine),WebAnimationsPlayer=function(){function WebAnimationsPlayer(element,keyframes,options,previousPlayers){void 0===previousPlayers&&(previousPlayers=[]);var _this=this;this.element=element,this.keyframes=keyframes,this.options=options,this._onDoneFns=[],this._onStartFns=[],this._onDestroyFns=[],this._initialized=!1,this._finished=!1,this._started=!1,this._destroyed=!1,this.time=0,this.parentPlayer=null,this._duration=options.duration,this._delay=options.delay||0,this.time=this._duration+this._delay,this.previousStyles={},previousPlayers.forEach(function(player){var styles=player._captureStyles();Object.keys(styles).forEach(function(prop){return _this.previousStyles[prop]=styles[prop]})})}return WebAnimationsPlayer.prototype._onFinish=function(){this._finished||(this._finished=!0,this._onDoneFns.forEach(function(fn){return fn()}),this._onDoneFns=[])},WebAnimationsPlayer.prototype.init=function(){var _this=this;if(!this._initialized){this._initialized=!0;var keyframes=this.keyframes.map(function(styles){var formattedKeyframe={};return Object.keys(styles).forEach(function(prop,index){var value=styles[prop];value==_angular_animations.AUTO_STYLE&&(value=_computeStyle(_this.element,prop)),void 0!=value&&(formattedKeyframe[prop]=value)}),formattedKeyframe}),previousStyleProps=Object.keys(this.previousStyles);if(previousStyleProps.length){var startingKeyframe_1=keyframes[0],missingStyleProps_1=[];if(previousStyleProps.forEach(function(prop){startingKeyframe_1.hasOwnProperty(prop)||missingStyleProps_1.push(prop),startingKeyframe_1[prop]=_this.previousStyles[prop]}),missingStyleProps_1.length)for(var self_1=this,_loop_3=function(){var kf=keyframes[i];missingStyleProps_1.forEach(function(prop){kf[prop]=_computeStyle(self_1.element,prop)})},i=1;i<keyframes.length;i++)_loop_3()}this._player=this._triggerWebAnimation(this.element,keyframes,this.options),this._finalKeyframe=keyframes.length?_copyKeyframeStyles(keyframes[keyframes.length-1]):{},this._resetDomPlayerState(),this._player.addEventListener("finish",function(){return _this._onFinish()})}},WebAnimationsPlayer.prototype._triggerWebAnimation=function(element,keyframes,options){return element.animate(keyframes,options)},Object.defineProperty(WebAnimationsPlayer.prototype,"domPlayer",{get:function(){return this._player},enumerable:!0,configurable:!0}),WebAnimationsPlayer.prototype.onStart=function(fn){this._onStartFns.push(fn)},WebAnimationsPlayer.prototype.onDone=function(fn){this._onDoneFns.push(fn)},WebAnimationsPlayer.prototype.onDestroy=function(fn){this._onDestroyFns.push(fn)},WebAnimationsPlayer.prototype.play=function(){this.init(),this.hasStarted()||(this._onStartFns.forEach(function(fn){return fn()}),this._onStartFns=[],this._started=!0),this._player.play()},WebAnimationsPlayer.prototype.pause=function(){this.init(),this._player.pause()},WebAnimationsPlayer.prototype.finish=function(){this.init(),this._onFinish(),this._player.finish()},WebAnimationsPlayer.prototype.reset=function(){this._resetDomPlayerState(),this._destroyed=!1,this._finished=!1,this._started=!1},WebAnimationsPlayer.prototype._resetDomPlayerState=function(){this._player&&this._player.cancel()},WebAnimationsPlayer.prototype.restart=function(){this.reset(),this.play()},WebAnimationsPlayer.prototype.hasStarted=function(){return this._started},WebAnimationsPlayer.prototype.destroy=function(){this._destroyed||(this._resetDomPlayerState(),this._onFinish(),this._destroyed=!0,this._onDestroyFns.forEach(function(fn){return fn()}),this._onDestroyFns=[])},WebAnimationsPlayer.prototype.setPosition=function(p){this._player.currentTime=p*this.time},WebAnimationsPlayer.prototype.getPosition=function(){return this._player.currentTime/this.time},WebAnimationsPlayer.prototype._captureStyles=function(){var _this=this,styles={};return this.hasStarted()&&Object.keys(this._finalKeyframe).forEach(function(prop){"offset"!=prop&&(styles[prop]=_this._finished?_this._finalKeyframe[prop]:_computeStyle(_this.element,prop))}),styles},WebAnimationsPlayer}(),WebAnimationsDriver=function(){function WebAnimationsDriver(){}return WebAnimationsDriver.prototype.animate=function(element,keyframes,duration,delay,easing,previousPlayers){void 0===previousPlayers&&(previousPlayers=[]);var playerOptions={duration:duration,delay:delay,fill:"forwards"};easing&&(playerOptions.easing=easing);var previousWebAnimationPlayers=previousPlayers.filter(function(player){return player instanceof WebAnimationsPlayer});return new WebAnimationsPlayer(element,keyframes,playerOptions,previousWebAnimationPlayers)},WebAnimationsDriver}();exports.AnimationDriver=AnimationDriver,exports.ɵAnimationEngine=AnimationEngine,exports.ɵAnimation=Animation,exports.ɵAnimationStyleNormalizer=AnimationStyleNormalizer,exports.ɵNoopAnimationStyleNormalizer=NoopAnimationStyleNormalizer,exports.ɵWebAnimationsStyleNormalizer=WebAnimationsStyleNormalizer,exports.ɵNoopAnimationDriver=NoopAnimationDriver,exports.ɵDomAnimationEngine=DomAnimationEngine,exports.ɵNoopAnimationEngine=NoopAnimationEngine,exports.ɵWebAnimationsDriver=WebAnimationsDriver,exports.ɵsupportsWebAnimations=supportsWebAnimations,Object.defineProperty(exports,"__esModule",{value:!0})});
//# sourceMappingURL=animations-browser.umd.min.js.map
