/**
 * @fileoverview added by tsickle
 * @suppress {checkTypes} checked by tsc
 */
/**
 * @license
 * Copyright Google Inc. All Rights Reserved.
 *
 * Use of this source code is governed by an MIT-style license that can be
 * found in the LICENSE file at https://angular.io/license
 */
export const /** @type {?} */ ANY_STATE = '*';
/**
 * @param {?} transitionValue
 * @param {?} errors
 * @return {?}
 */
export function parseTransitionExpr(transitionValue, errors) {
    const /** @type {?} */ expressions = [];
    if (typeof transitionValue == 'string') {
        (/** @type {?} */ (transitionValue))
            .split(/\s*,\s*/)
            .forEach(str => parseInnerTransitionStr(str, expressions, errors));
    }
    else {
        expressions.push(/** @type {?} */ (transitionValue));
    }
    return expressions;
}
/**
 * @param {?} eventStr
 * @param {?} expressions
 * @param {?} errors
 * @return {?}
 */
function parseInnerTransitionStr(eventStr, expressions, errors) {
    if (eventStr[0] == ':') {
        const /** @type {?} */ result = parseAnimationAlias(eventStr, errors);
        if (typeof result == 'function') {
            expressions.push(result);
            return;
        }
        eventStr = /** @type {?} */ (result);
    }
    const /** @type {?} */ match = eventStr.match(/^(\*|[-\w]+)\s*(<?[=-]>)\s*(\*|[-\w]+)$/);
    if (match == null || match.length < 4) {
        errors.push(`The provided transition expression "${eventStr}" is not supported`);
        return expressions;
    }
    const /** @type {?} */ fromState = match[1];
    const /** @type {?} */ separator = match[2];
    const /** @type {?} */ toState = match[3];
    expressions.push(makeLambdaFromStates(fromState, toState));
    const /** @type {?} */ isFullAnyStateExpr = fromState == ANY_STATE && toState == ANY_STATE;
    if (separator[0] == '<' && !isFullAnyStateExpr) {
        expressions.push(makeLambdaFromStates(toState, fromState));
    }
}
/**
 * @param {?} alias
 * @param {?} errors
 * @return {?}
 */
function parseAnimationAlias(alias, errors) {
    switch (alias) {
        case ':enter':
            return 'void => *';
        case ':leave':
            return '* => void';
        case ':increment':
            return (fromState, toState) => parseFloat(toState) > parseFloat(fromState);
        case ':decrement':
            return (fromState, toState) => parseFloat(toState) < parseFloat(fromState);
        default:
            errors.push(`The transition alias value "${alias}" is not supported`);
            return '* => *';
    }
}
// DO NOT REFACTOR ... keep the follow set instantiations
// with the values intact (closure compiler for some reason
// removes follow-up lines that add the values outside of
// the constructor...
const /** @type {?} */ TRUE_BOOLEAN_VALUES = new Set(['true', '1']);
const /** @type {?} */ FALSE_BOOLEAN_VALUES = new Set(['false', '0']);
/**
 * @param {?} lhs
 * @param {?} rhs
 * @return {?}
 */
function makeLambdaFromStates(lhs, rhs) {
    const /** @type {?} */ LHS_MATCH_BOOLEAN = TRUE_BOOLEAN_VALUES.has(lhs) || FALSE_BOOLEAN_VALUES.has(lhs);
    const /** @type {?} */ RHS_MATCH_BOOLEAN = TRUE_BOOLEAN_VALUES.has(rhs) || FALSE_BOOLEAN_VALUES.has(rhs);
    return (fromState, toState) => {
        let /** @type {?} */ lhsMatch = lhs == ANY_STATE || lhs == fromState;
        let /** @type {?} */ rhsMatch = rhs == ANY_STATE || rhs == toState;
        if (!lhsMatch && LHS_MATCH_BOOLEAN && typeof fromState === 'boolean') {
            lhsMatch = fromState ? TRUE_BOOLEAN_VALUES.has(lhs) : FALSE_BOOLEAN_VALUES.has(lhs);
        }
        if (!rhsMatch && RHS_MATCH_BOOLEAN && typeof toState === 'boolean') {
            rhsMatch = toState ? TRUE_BOOLEAN_VALUES.has(rhs) : FALSE_BOOLEAN_VALUES.has(rhs);
        }
        return lhsMatch && rhsMatch;
    };
}

//# sourceMappingURL=data:application/json;base64,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