/**
 * @license
 * Copyright Google LLC All Rights Reserved.
 *
 * Use of this source code is governed by an MIT-style license that can be
 * found in the LICENSE file at https://angular.io/license
 */
/** IE 11 compatible closest implementation that is able to start from non-Element Nodes. */
export function closest(element, selector) {
    if (!(element instanceof Node)) {
        return null;
    }
    let curr = element;
    while (curr != null && !(curr instanceof Element)) {
        curr = curr.parentNode;
    }
    return curr && (hasNativeClosest ?
        curr.closest(selector) : polyfillClosest(curr, selector));
}
/** Polyfill for browsers without Element.closest. */
function polyfillClosest(element, selector) {
    let curr = element;
    while (curr != null && !(curr instanceof Element && matches(curr, selector))) {
        curr = curr.parentNode;
    }
    return (curr || null);
}
const hasNativeClosest = typeof Element != 'undefined' && !!Element.prototype.closest;
/** IE 11 compatible matches implementation. */
function matches(element, selector) {
    return element.matches ?
        element.matches(selector) :
        element['msMatchesSelector'](selector);
}
//# sourceMappingURL=data:application/json;base64,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