"use strict";
/**
 * @license
 * Copyright Google LLC All Rights Reserved.
 *
 * Use of this source code is governed by an MIT-style license that can be
 * found in the LICENSE file at https://angular.io/license
 */
Object.defineProperty(exports, "__esModule", { value: true });
exports.getCallDecoratorImport = exports.getAngularDecorators = void 0;
const ts = require("typescript");
const imports_1 = require("./imports");
/**
 * Gets all decorators which are imported from an Angular package
 * (e.g. "@angular/core") from a list of decorators.
 */
function getAngularDecorators(typeChecker, decorators) {
    return decorators.map(node => ({ node, importData: getCallDecoratorImport(typeChecker, node) }))
        .filter(({ importData }) => importData && importData.moduleName.startsWith('@angular/'))
        .map(({ node, importData }) => ({ node: node, name: importData.symbolName }));
}
exports.getAngularDecorators = getAngularDecorators;
function getCallDecoratorImport(typeChecker, decorator) {
    if (!ts.isCallExpression(decorator.expression)) {
        return null;
    }
    const valueExpr = decorator.expression.expression;
    let identifier = null;
    if (ts.isIdentifier(valueExpr)) {
        identifier = valueExpr;
    }
    else if (ts.isPropertyAccessExpression(valueExpr) && ts.isIdentifier(valueExpr.name)) {
        identifier = valueExpr.name;
    }
    return identifier ? imports_1.getImportOfIdentifier(identifier, typeChecker) : null;
}
exports.getCallDecoratorImport = getCallDecoratorImport;
//# sourceMappingURL=data:application/json;base64,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