(function (global, factory) {
    typeof exports === 'object' && typeof module !== 'undefined' ? factory(exports, require('@angular/cdk/a11y'), require('@angular/cdk/bidi'), require('@angular/cdk/coercion'), require('@angular/cdk/keycodes'), require('@angular/common'), require('@angular/core'), require('@angular/cdk/platform'), require('rxjs'), require('rxjs/operators')) :
    typeof define === 'function' && define.amd ? define('@angular/cdk/stepper', ['exports', '@angular/cdk/a11y', '@angular/cdk/bidi', '@angular/cdk/coercion', '@angular/cdk/keycodes', '@angular/common', '@angular/core', '@angular/cdk/platform', 'rxjs', 'rxjs/operators'], factory) :
    (global = typeof globalThis !== 'undefined' ? globalThis : global || self, factory((global.ng = global.ng || {}, global.ng.cdk = global.ng.cdk || {}, global.ng.cdk.stepper = {}), global.ng.cdk.a11y, global.ng.cdk.bidi, global.ng.cdk.coercion, global.ng.cdk.keycodes, global.ng.common, global.ng.core, global.ng.cdk.platform, global.rxjs, global.rxjs.operators));
}(this, (function (exports, a11y, bidi, coercion, keycodes, common, core, platform, rxjs, operators) { 'use strict';

    /**
     * @license
     * Copyright Google LLC All Rights Reserved.
     *
     * Use of this source code is governed by an MIT-style license that can be
     * found in the LICENSE file at https://angular.io/license
     */
    var CdkStepHeader = /** @class */ (function () {
        function CdkStepHeader(_elementRef) {
            this._elementRef = _elementRef;
        }
        /** Focuses the step header. */
        CdkStepHeader.prototype.focus = function () {
            this._elementRef.nativeElement.focus();
        };
        return CdkStepHeader;
    }());
    CdkStepHeader.decorators = [
        { type: core.Directive, args: [{
                    selector: '[cdkStepHeader]',
                    host: {
                        'role': 'tab',
                    },
                },] }
    ];
    CdkStepHeader.ctorParameters = function () { return [
        { type: core.ElementRef }
    ]; };

    /**
     * @license
     * Copyright Google LLC All Rights Reserved.
     *
     * Use of this source code is governed by an MIT-style license that can be
     * found in the LICENSE file at https://angular.io/license
     */
    var CdkStepLabel = /** @class */ (function () {
        function CdkStepLabel(/** @docs-private */ template) {
            this.template = template;
        }
        return CdkStepLabel;
    }());
    CdkStepLabel.decorators = [
        { type: core.Directive, args: [{
                    selector: '[cdkStepLabel]',
                },] }
    ];
    CdkStepLabel.ctorParameters = function () { return [
        { type: core.TemplateRef }
    ]; };

    /**
     * @license
     * Copyright Google LLC All Rights Reserved.
     *
     * Use of this source code is governed by an MIT-style license that can be
     * found in the LICENSE file at https://angular.io/license
     */
    /** Used to generate unique ID for each stepper component. */
    var nextId = 0;
    /** Change event emitted on selection changes. */
    var StepperSelectionEvent = /** @class */ (function () {
        function StepperSelectionEvent() {
        }
        return StepperSelectionEvent;
    }());
    /** Enum to represent the different states of the steps. */
    var STEP_STATE = {
        NUMBER: 'number',
        EDIT: 'edit',
        DONE: 'done',
        ERROR: 'error'
    };
    /** InjectionToken that can be used to specify the global stepper options. */
    var STEPPER_GLOBAL_OPTIONS = new core.InjectionToken('STEPPER_GLOBAL_OPTIONS');
    var CdkStep = /** @class */ (function () {
        function CdkStep(_stepper, stepperOptions) {
            this._stepper = _stepper;
            /** Whether user has attempted to move away from the step. */
            this.interacted = false;
            /** Emits when the user has attempted to move away from the step. */
            this.interactedStream = new core.EventEmitter();
            this._editable = true;
            this._optional = false;
            this._completedOverride = null;
            this._customError = null;
            this._stepperOptions = stepperOptions ? stepperOptions : {};
            this._displayDefaultIndicatorType = this._stepperOptions.displayDefaultIndicatorType !== false;
        }
        Object.defineProperty(CdkStep.prototype, "editable", {
            /** Whether the user can return to this step once it has been marked as completed. */
            get: function () {
                return this._editable;
            },
            set: function (value) {
                this._editable = coercion.coerceBooleanProperty(value);
            },
            enumerable: false,
            configurable: true
        });
        Object.defineProperty(CdkStep.prototype, "optional", {
            /** Whether the completion of step is optional. */
            get: function () {
                return this._optional;
            },
            set: function (value) {
                this._optional = coercion.coerceBooleanProperty(value);
            },
            enumerable: false,
            configurable: true
        });
        Object.defineProperty(CdkStep.prototype, "completed", {
            /** Whether step is marked as completed. */
            get: function () {
                return this._completedOverride == null ? this._getDefaultCompleted() : this._completedOverride;
            },
            set: function (value) {
                this._completedOverride = coercion.coerceBooleanProperty(value);
            },
            enumerable: false,
            configurable: true
        });
        CdkStep.prototype._getDefaultCompleted = function () {
            return this.stepControl ? this.stepControl.valid && this.interacted : this.interacted;
        };
        Object.defineProperty(CdkStep.prototype, "hasError", {
            /** Whether step has an error. */
            get: function () {
                return this._customError == null ? this._getDefaultError() : this._customError;
            },
            set: function (value) {
                this._customError = coercion.coerceBooleanProperty(value);
            },
            enumerable: false,
            configurable: true
        });
        CdkStep.prototype._getDefaultError = function () {
            return this.stepControl && this.stepControl.invalid && this.interacted;
        };
        /** Selects this step component. */
        CdkStep.prototype.select = function () {
            this._stepper.selected = this;
        };
        /** Resets the step to its initial state. Note that this includes resetting form data. */
        CdkStep.prototype.reset = function () {
            this.interacted = false;
            if (this._completedOverride != null) {
                this._completedOverride = false;
            }
            if (this._customError != null) {
                this._customError = false;
            }
            if (this.stepControl) {
                this.stepControl.reset();
            }
        };
        CdkStep.prototype.ngOnChanges = function () {
            // Since basically all inputs of the MatStep get proxied through the view down to the
            // underlying MatStepHeader, we have to make sure that change detection runs correctly.
            this._stepper._stateChanged();
        };
        CdkStep.prototype._markAsInteracted = function () {
            if (!this.interacted) {
                this.interacted = true;
                this.interactedStream.emit(this);
            }
        };
        /** Determines whether the error state can be shown. */
        CdkStep.prototype._showError = function () {
            var _a;
            // We want to show the error state either if the user opted into/out of it using the
            // global options, or if they've explicitly set it through the `hasError` input.
            return (_a = this._stepperOptions.showError) !== null && _a !== void 0 ? _a : this._customError != null;
        };
        return CdkStep;
    }());
    CdkStep.decorators = [
        { type: core.Component, args: [{
                    selector: 'cdk-step',
                    exportAs: 'cdkStep',
                    template: '<ng-template><ng-content></ng-content></ng-template>',
                    encapsulation: core.ViewEncapsulation.None,
                    changeDetection: core.ChangeDetectionStrategy.OnPush
                },] }
    ];
    CdkStep.ctorParameters = function () { return [
        { type: CdkStepper, decorators: [{ type: core.Inject, args: [core.forwardRef(function () { return CdkStepper; }),] }] },
        { type: undefined, decorators: [{ type: core.Optional }, { type: core.Inject, args: [STEPPER_GLOBAL_OPTIONS,] }] }
    ]; };
    CdkStep.propDecorators = {
        stepLabel: [{ type: core.ContentChild, args: [CdkStepLabel,] }],
        content: [{ type: core.ViewChild, args: [core.TemplateRef, { static: true },] }],
        stepControl: [{ type: core.Input }],
        interactedStream: [{ type: core.Output, args: ['interacted',] }],
        label: [{ type: core.Input }],
        errorMessage: [{ type: core.Input }],
        ariaLabel: [{ type: core.Input, args: ['aria-label',] }],
        ariaLabelledby: [{ type: core.Input, args: ['aria-labelledby',] }],
        state: [{ type: core.Input }],
        editable: [{ type: core.Input }],
        optional: [{ type: core.Input }],
        completed: [{ type: core.Input }],
        hasError: [{ type: core.Input }]
    };
    var CdkStepper = /** @class */ (function () {
        function CdkStepper(_dir, _changeDetectorRef, _elementRef, 
        /**
         * @deprecated No longer in use, to be removed.
         * @breaking-change 13.0.0
         */
        _document) {
            this._dir = _dir;
            this._changeDetectorRef = _changeDetectorRef;
            this._elementRef = _elementRef;
            /** Emits when the component is destroyed. */
            this._destroyed = new rxjs.Subject();
            /** Steps that belong to the current stepper, excluding ones from nested steppers. */
            this.steps = new core.QueryList();
            /** List of step headers sorted based on their DOM order. */
            this._sortedHeaders = new core.QueryList();
            this._linear = false;
            this._selectedIndex = 0;
            /** Event emitted when the selected step has changed. */
            this.selectionChange = new core.EventEmitter();
            /**
             * @deprecated To be turned into a private property. Use `orientation` instead.
             * @breaking-change 13.0.0
             */
            this._orientation = 'horizontal';
            this._groupId = nextId++;
        }
        Object.defineProperty(CdkStepper.prototype, "linear", {
            /** Whether the validity of previous steps should be checked or not. */
            get: function () {
                return this._linear;
            },
            set: function (value) {
                this._linear = coercion.coerceBooleanProperty(value);
            },
            enumerable: false,
            configurable: true
        });
        Object.defineProperty(CdkStepper.prototype, "selectedIndex", {
            /** The index of the selected step. */
            get: function () {
                return this._selectedIndex;
            },
            set: function (index) {
                var _a;
                var newIndex = coercion.coerceNumberProperty(index);
                if (this.steps && this._steps) {
                    // Ensure that the index can't be out of bounds.
                    if (!this._isValidIndex(index) && (typeof ngDevMode === 'undefined' || ngDevMode)) {
                        throw Error('cdkStepper: Cannot assign out-of-bounds value to `selectedIndex`.');
                    }
                    (_a = this.selected) === null || _a === void 0 ? void 0 : _a._markAsInteracted();
                    if (this._selectedIndex !== newIndex && !this._anyControlsInvalidOrPending(newIndex) &&
                        (newIndex >= this._selectedIndex || this.steps.toArray()[newIndex].editable)) {
                        this._updateSelectedItemIndex(index);
                    }
                }
                else {
                    this._selectedIndex = newIndex;
                }
            },
            enumerable: false,
            configurable: true
        });
        Object.defineProperty(CdkStepper.prototype, "selected", {
            /** The step that is selected. */
            get: function () {
                return this.steps ? this.steps.toArray()[this.selectedIndex] : undefined;
            },
            set: function (step) {
                this.selectedIndex = (step && this.steps) ? this.steps.toArray().indexOf(step) : -1;
            },
            enumerable: false,
            configurable: true
        });
        Object.defineProperty(CdkStepper.prototype, "orientation", {
            /** Orientation of the stepper. */
            get: function () { return this._orientation; },
            set: function (value) {
                // This is a protected method so that `MatSteppter` can hook into it.
                this._orientation = value;
                if (this._keyManager) {
                    this._keyManager.withVerticalOrientation(value === 'vertical');
                }
            },
            enumerable: false,
            configurable: true
        });
        CdkStepper.prototype.ngAfterContentInit = function () {
            var _this = this;
            this._steps.changes
                .pipe(operators.startWith(this._steps), operators.takeUntil(this._destroyed))
                .subscribe(function (steps) {
                _this.steps.reset(steps.filter(function (step) { return step._stepper === _this; }));
                _this.steps.notifyOnChanges();
            });
        };
        CdkStepper.prototype.ngAfterViewInit = function () {
            var _this = this;
            // If the step headers are defined outside of the `ngFor` that renders the steps, like in the
            // Material stepper, they won't appear in the `QueryList` in the same order as they're
            // rendered in the DOM which will lead to incorrect keyboard navigation. We need to sort
            // them manually to ensure that they're correct. Alternatively, we can change the Material
            // template to inline the headers in the `ngFor`, but that'll result in a lot of
            // code duplciation. See #23539.
            this._stepHeader.changes
                .pipe(operators.startWith(this._stepHeader), operators.takeUntil(this._destroyed))
                .subscribe(function (headers) {
                _this._sortedHeaders.reset(headers.toArray().sort(function (a, b) {
                    var documentPosition = a._elementRef.nativeElement.compareDocumentPosition(b._elementRef.nativeElement);
                    // `compareDocumentPosition` returns a bitmask so we have to use a bitwise operator.
                    // https://developer.mozilla.org/en-US/docs/Web/API/Node/compareDocumentPosition
                    // tslint:disable-next-line:no-bitwise
                    return documentPosition & Node.DOCUMENT_POSITION_FOLLOWING ? -1 : 1;
                }));
                _this._sortedHeaders.notifyOnChanges();
            });
            // Note that while the step headers are content children by default, any components that
            // extend this one might have them as view children. We initialize the keyboard handling in
            // AfterViewInit so we're guaranteed for both view and content children to be defined.
            this._keyManager = new a11y.FocusKeyManager(this._sortedHeaders)
                .withWrap()
                .withHomeAndEnd()
                .withVerticalOrientation(this._orientation === 'vertical');
            (this._dir ? this._dir.change : rxjs.of())
                .pipe(operators.startWith(this._layoutDirection()), operators.takeUntil(this._destroyed))
                .subscribe(function (direction) { return _this._keyManager.withHorizontalOrientation(direction); });
            this._keyManager.updateActiveItem(this._selectedIndex);
            // No need to `takeUntil` here, because we're the ones destroying `steps`.
            this.steps.changes.subscribe(function () {
                if (!_this.selected) {
                    _this._selectedIndex = Math.max(_this._selectedIndex - 1, 0);
                }
            });
            // The logic which asserts that the selected index is within bounds doesn't run before the
            // steps are initialized, because we don't how many steps there are yet so we may have an
            // invalid index on init. If that's the case, auto-correct to the default so we don't throw.
            if (!this._isValidIndex(this._selectedIndex)) {
                this._selectedIndex = 0;
            }
        };
        CdkStepper.prototype.ngOnDestroy = function () {
            this.steps.destroy();
            this._sortedHeaders.destroy();
            this._destroyed.next();
            this._destroyed.complete();
        };
        /** Selects and focuses the next step in list. */
        CdkStepper.prototype.next = function () {
            this.selectedIndex = Math.min(this._selectedIndex + 1, this.steps.length - 1);
        };
        /** Selects and focuses the previous step in list. */
        CdkStepper.prototype.previous = function () {
            this.selectedIndex = Math.max(this._selectedIndex - 1, 0);
        };
        /** Resets the stepper to its initial state. Note that this includes clearing form data. */
        CdkStepper.prototype.reset = function () {
            this._updateSelectedItemIndex(0);
            this.steps.forEach(function (step) { return step.reset(); });
            this._stateChanged();
        };
        /** Returns a unique id for each step label element. */
        CdkStepper.prototype._getStepLabelId = function (i) {
            return "cdk-step-label-" + this._groupId + "-" + i;
        };
        /** Returns unique id for each step content element. */
        CdkStepper.prototype._getStepContentId = function (i) {
            return "cdk-step-content-" + this._groupId + "-" + i;
        };
        /** Marks the component to be change detected. */
        CdkStepper.prototype._stateChanged = function () {
            this._changeDetectorRef.markForCheck();
        };
        /** Returns position state of the step with the given index. */
        CdkStepper.prototype._getAnimationDirection = function (index) {
            var position = index - this._selectedIndex;
            if (position < 0) {
                return this._layoutDirection() === 'rtl' ? 'next' : 'previous';
            }
            else if (position > 0) {
                return this._layoutDirection() === 'rtl' ? 'previous' : 'next';
            }
            return 'current';
        };
        /** Returns the type of icon to be displayed. */
        CdkStepper.prototype._getIndicatorType = function (index, state) {
            if (state === void 0) { state = STEP_STATE.NUMBER; }
            var step = this.steps.toArray()[index];
            var isCurrentStep = this._isCurrentStep(index);
            return step._displayDefaultIndicatorType ? this._getDefaultIndicatorLogic(step, isCurrentStep) :
                this._getGuidelineLogic(step, isCurrentStep, state);
        };
        CdkStepper.prototype._getDefaultIndicatorLogic = function (step, isCurrentStep) {
            if (step._showError() && step.hasError && !isCurrentStep) {
                return STEP_STATE.ERROR;
            }
            else if (!step.completed || isCurrentStep) {
                return STEP_STATE.NUMBER;
            }
            else {
                return step.editable ? STEP_STATE.EDIT : STEP_STATE.DONE;
            }
        };
        CdkStepper.prototype._getGuidelineLogic = function (step, isCurrentStep, state) {
            if (state === void 0) { state = STEP_STATE.NUMBER; }
            if (step._showError() && step.hasError && !isCurrentStep) {
                return STEP_STATE.ERROR;
            }
            else if (step.completed && !isCurrentStep) {
                return STEP_STATE.DONE;
            }
            else if (step.completed && isCurrentStep) {
                return state;
            }
            else if (step.editable && isCurrentStep) {
                return STEP_STATE.EDIT;
            }
            else {
                return state;
            }
        };
        CdkStepper.prototype._isCurrentStep = function (index) {
            return this._selectedIndex === index;
        };
        /** Returns the index of the currently-focused step header. */
        CdkStepper.prototype._getFocusIndex = function () {
            return this._keyManager ? this._keyManager.activeItemIndex : this._selectedIndex;
        };
        CdkStepper.prototype._updateSelectedItemIndex = function (newIndex) {
            var stepsArray = this.steps.toArray();
            this.selectionChange.emit({
                selectedIndex: newIndex,
                previouslySelectedIndex: this._selectedIndex,
                selectedStep: stepsArray[newIndex],
                previouslySelectedStep: stepsArray[this._selectedIndex],
            });
            // If focus is inside the stepper, move it to the next header, otherwise it may become
            // lost when the active step content is hidden. We can't be more granular with the check
            // (e.g. checking whether focus is inside the active step), because we don't have a
            // reference to the elements that are rendering out the content.
            this._containsFocus() ? this._keyManager.setActiveItem(newIndex) :
                this._keyManager.updateActiveItem(newIndex);
            this._selectedIndex = newIndex;
            this._stateChanged();
        };
        CdkStepper.prototype._onKeydown = function (event) {
            var hasModifier = keycodes.hasModifierKey(event);
            var keyCode = event.keyCode;
            var manager = this._keyManager;
            if (manager.activeItemIndex != null && !hasModifier &&
                (keyCode === keycodes.SPACE || keyCode === keycodes.ENTER)) {
                this.selectedIndex = manager.activeItemIndex;
                event.preventDefault();
            }
            else {
                manager.onKeydown(event);
            }
        };
        CdkStepper.prototype._anyControlsInvalidOrPending = function (index) {
            if (this._linear && index >= 0) {
                return this.steps.toArray().slice(0, index).some(function (step) {
                    var control = step.stepControl;
                    var isIncomplete = control ? (control.invalid || control.pending || !step.interacted) : !step.completed;
                    return isIncomplete && !step.optional && !step._completedOverride;
                });
            }
            return false;
        };
        CdkStepper.prototype._layoutDirection = function () {
            return this._dir && this._dir.value === 'rtl' ? 'rtl' : 'ltr';
        };
        /** Checks whether the stepper contains the focused element. */
        CdkStepper.prototype._containsFocus = function () {
            var stepperElement = this._elementRef.nativeElement;
            var focusedElement = platform._getFocusedElementPierceShadowDom();
            return stepperElement === focusedElement || stepperElement.contains(focusedElement);
        };
        /** Checks whether the passed-in index is a valid step index. */
        CdkStepper.prototype._isValidIndex = function (index) {
            return index > -1 && (!this.steps || index < this.steps.length);
        };
        return CdkStepper;
    }());
    CdkStepper.decorators = [
        { type: core.Directive, args: [{
                    selector: '[cdkStepper]',
                    exportAs: 'cdkStepper',
                },] }
    ];
    CdkStepper.ctorParameters = function () { return [
        { type: bidi.Directionality, decorators: [{ type: core.Optional }] },
        { type: core.ChangeDetectorRef },
        { type: core.ElementRef },
        { type: undefined, decorators: [{ type: core.Inject, args: [common.DOCUMENT,] }] }
    ]; };
    CdkStepper.propDecorators = {
        _steps: [{ type: core.ContentChildren, args: [CdkStep, { descendants: true },] }],
        _stepHeader: [{ type: core.ContentChildren, args: [CdkStepHeader, { descendants: true },] }],
        linear: [{ type: core.Input }],
        selectedIndex: [{ type: core.Input }],
        selected: [{ type: core.Input }],
        selectionChange: [{ type: core.Output }],
        orientation: [{ type: core.Input }]
    };

    /**
     * @license
     * Copyright Google LLC All Rights Reserved.
     *
     * Use of this source code is governed by an MIT-style license that can be
     * found in the LICENSE file at https://angular.io/license
     */
    /** Button that moves to the next step in a stepper workflow. */
    var CdkStepperNext = /** @class */ (function () {
        function CdkStepperNext(_stepper) {
            this._stepper = _stepper;
            /** Type of the next button. Defaults to "submit" if not specified. */
            this.type = 'submit';
        }
        // We have to use a `HostListener` here in order to support both Ivy and ViewEngine.
        // In Ivy the `host` bindings will be merged when this class is extended, whereas in
        // ViewEngine they're overwritten.
        // TODO(crisbeto): we move this back into `host` once Ivy is turned on by default.
        // tslint:disable-next-line:no-host-decorator-in-concrete
        CdkStepperNext.prototype._handleClick = function () {
            this._stepper.next();
        };
        return CdkStepperNext;
    }());
    CdkStepperNext.decorators = [
        { type: core.Directive, args: [{
                    selector: 'button[cdkStepperNext]',
                    host: {
                        '[type]': 'type',
                    }
                },] }
    ];
    CdkStepperNext.ctorParameters = function () { return [
        { type: CdkStepper }
    ]; };
    CdkStepperNext.propDecorators = {
        type: [{ type: core.Input }],
        _handleClick: [{ type: core.HostListener, args: ['click',] }]
    };
    /** Button that moves to the previous step in a stepper workflow. */
    var CdkStepperPrevious = /** @class */ (function () {
        function CdkStepperPrevious(_stepper) {
            this._stepper = _stepper;
            /** Type of the previous button. Defaults to "button" if not specified. */
            this.type = 'button';
        }
        // We have to use a `HostListener` here in order to support both Ivy and ViewEngine.
        // In Ivy the `host` bindings will be merged when this class is extended, whereas in
        // ViewEngine they're overwritten.
        // TODO(crisbeto): we move this back into `host` once Ivy is turned on by default.
        // tslint:disable-next-line:no-host-decorator-in-concrete
        CdkStepperPrevious.prototype._handleClick = function () {
            this._stepper.previous();
        };
        return CdkStepperPrevious;
    }());
    CdkStepperPrevious.decorators = [
        { type: core.Directive, args: [{
                    selector: 'button[cdkStepperPrevious]',
                    host: {
                        '[type]': 'type',
                    }
                },] }
    ];
    CdkStepperPrevious.ctorParameters = function () { return [
        { type: CdkStepper }
    ]; };
    CdkStepperPrevious.propDecorators = {
        type: [{ type: core.Input }],
        _handleClick: [{ type: core.HostListener, args: ['click',] }]
    };

    /**
     * @license
     * Copyright Google LLC All Rights Reserved.
     *
     * Use of this source code is governed by an MIT-style license that can be
     * found in the LICENSE file at https://angular.io/license
     */
    var CdkStepperModule = /** @class */ (function () {
        function CdkStepperModule() {
        }
        return CdkStepperModule;
    }());
    CdkStepperModule.decorators = [
        { type: core.NgModule, args: [{
                    imports: [bidi.BidiModule],
                    exports: [
                        CdkStep,
                        CdkStepper,
                        CdkStepHeader,
                        CdkStepLabel,
                        CdkStepperNext,
                        CdkStepperPrevious,
                    ],
                    declarations: [
                        CdkStep,
                        CdkStepper,
                        CdkStepHeader,
                        CdkStepLabel,
                        CdkStepperNext,
                        CdkStepperPrevious,
                    ]
                },] }
    ];

    /**
     * @license
     * Copyright Google LLC All Rights Reserved.
     *
     * Use of this source code is governed by an MIT-style license that can be
     * found in the LICENSE file at https://angular.io/license
     */

    /**
     * Generated bundle index. Do not edit.
     */

    exports.CdkStep = CdkStep;
    exports.CdkStepHeader = CdkStepHeader;
    exports.CdkStepLabel = CdkStepLabel;
    exports.CdkStepper = CdkStepper;
    exports.CdkStepperModule = CdkStepperModule;
    exports.CdkStepperNext = CdkStepperNext;
    exports.CdkStepperPrevious = CdkStepperPrevious;
    exports.STEPPER_GLOBAL_OPTIONS = STEPPER_GLOBAL_OPTIONS;
    exports.STEP_STATE = STEP_STATE;
    exports.StepperSelectionEvent = StepperSelectionEvent;

    Object.defineProperty(exports, '__esModule', { value: true });

})));
//# sourceMappingURL=cdk-stepper.umd.js.map
