"use strict";
/**
 * @license
 * Copyright Google LLC All Rights Reserved.
 *
 * Use of this source code is governed by an MIT-style license that can be
 * found in the LICENSE file at https://angular.io/license
 */
Object.defineProperty(exports, "__esModule", { value: true });
exports.DevkitMigration = void 0;
const migration_1 = require("../update-tool/migration");
class DevkitMigration extends migration_1.Migration {
    /** Prints an informative message with context on the current target. */
    printInfo(text) {
        const targetName = this.context.isTestTarget ? 'test' : 'build';
        this.logger.info(`- ${this.context.projectName}@${targetName}: ${text}`);
    }
}
exports.DevkitMigration = DevkitMigration;
//# sourceMappingURL=data:application/json;base64,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