"use strict";
/**
 * @license
 * Copyright Google LLC All Rights Reserved.
 *
 * Use of this source code is governed by an MIT-style license that can be
 * found in the LICENSE file at https://angular.io/license
 */
Object.defineProperty(exports, "__esModule", { value: true });
exports.determineBaseTypes = void 0;
const ts = require("typescript");
/** Determines the base types of the specified class declaration. */
function determineBaseTypes(node) {
    if (!node.heritageClauses) {
        return null;
    }
    return node.heritageClauses
        .reduce((types, clause) => types.concat(clause.types), [])
        .map(typeExpression => typeExpression.expression)
        .filter(expression => expression && ts.isIdentifier(expression))
        .map(identifier => identifier.text);
}
exports.determineBaseTypes = determineBaseTypes;
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiYmFzZS10eXBlcy5qcyIsInNvdXJjZVJvb3QiOiIiLCJzb3VyY2VzIjpbIi4uLy4uLy4uLy4uLy4uLy4uLy4uLy4uL3NyYy9jZGsvc2NoZW1hdGljcy9uZy11cGRhdGUvdHlwZXNjcmlwdC9iYXNlLXR5cGVzLnRzIl0sIm5hbWVzIjpbXSwibWFwcGluZ3MiOiI7QUFBQTs7Ozs7O0dBTUc7OztBQUVILGlDQUFpQztBQUVqQyxvRUFBb0U7QUFDcEUsU0FBZ0Isa0JBQWtCLENBQUMsSUFBeUI7SUFDMUQsSUFBSSxDQUFDLElBQUksQ0FBQyxlQUFlLEVBQUU7UUFDekIsT0FBTyxJQUFJLENBQUM7S0FDYjtJQUVELE9BQU8sSUFBSSxDQUFDLGVBQWU7U0FDdEIsTUFBTSxDQUFDLENBQUMsS0FBSyxFQUFFLE1BQU0sRUFBRSxFQUFFLENBQUMsS0FBSyxDQUFDLE1BQU0sQ0FBQyxNQUFNLENBQUMsS0FBSyxDQUFDLEVBQUUsRUFBc0MsQ0FBQztTQUM3RixHQUFHLENBQUMsY0FBYyxDQUFDLEVBQUUsQ0FBQyxjQUFjLENBQUMsVUFBVSxDQUFDO1NBQ2hELE1BQU0sQ0FBQyxVQUFVLENBQUMsRUFBRSxDQUFDLFVBQVUsSUFBSSxFQUFFLENBQUMsWUFBWSxDQUFDLFVBQVUsQ0FBQyxDQUFDO1NBQy9ELEdBQUcsQ0FBQyxVQUFVLENBQUMsRUFBRSxDQUFFLFVBQTRCLENBQUMsSUFBSSxDQUFDLENBQUM7QUFDN0QsQ0FBQztBQVZELGdEQVVDIiwic291cmNlc0NvbnRlbnQiOlsiLyoqXG4gKiBAbGljZW5zZVxuICogQ29weXJpZ2h0IEdvb2dsZSBMTEMgQWxsIFJpZ2h0cyBSZXNlcnZlZC5cbiAqXG4gKiBVc2Ugb2YgdGhpcyBzb3VyY2UgY29kZSBpcyBnb3Zlcm5lZCBieSBhbiBNSVQtc3R5bGUgbGljZW5zZSB0aGF0IGNhbiBiZVxuICogZm91bmQgaW4gdGhlIExJQ0VOU0UgZmlsZSBhdCBodHRwczovL2FuZ3VsYXIuaW8vbGljZW5zZVxuICovXG5cbmltcG9ydCAqIGFzIHRzIGZyb20gJ3R5cGVzY3JpcHQnO1xuXG4vKiogRGV0ZXJtaW5lcyB0aGUgYmFzZSB0eXBlcyBvZiB0aGUgc3BlY2lmaWVkIGNsYXNzIGRlY2xhcmF0aW9uLiAqL1xuZXhwb3J0IGZ1bmN0aW9uIGRldGVybWluZUJhc2VUeXBlcyhub2RlOiB0cy5DbGFzc0RlY2xhcmF0aW9uKTogc3RyaW5nW118bnVsbCB7XG4gIGlmICghbm9kZS5oZXJpdGFnZUNsYXVzZXMpIHtcbiAgICByZXR1cm4gbnVsbDtcbiAgfVxuXG4gIHJldHVybiBub2RlLmhlcml0YWdlQ2xhdXNlc1xuICAgICAgLnJlZHVjZSgodHlwZXMsIGNsYXVzZSkgPT4gdHlwZXMuY29uY2F0KGNsYXVzZS50eXBlcyksIFtdIGFzIHRzLkV4cHJlc3Npb25XaXRoVHlwZUFyZ3VtZW50c1tdKVxuICAgICAgLm1hcCh0eXBlRXhwcmVzc2lvbiA9PiB0eXBlRXhwcmVzc2lvbi5leHByZXNzaW9uKVxuICAgICAgLmZpbHRlcihleHByZXNzaW9uID0+IGV4cHJlc3Npb24gJiYgdHMuaXNJZGVudGlmaWVyKGV4cHJlc3Npb24pKVxuICAgICAgLm1hcChpZGVudGlmaWVyID0+IChpZGVudGlmaWVyIGFzIHRzLklkZW50aWZpZXIpLnRleHQpO1xufVxuIl19