"use strict";
/**
 * @license
 * Copyright Google LLC All Rights Reserved.
 *
 * Use of this source code is governed by an MIT-style license that can be
 * found in the LICENSE file at https://angular.io/license
 */
Object.defineProperty(exports, "__esModule", { value: true });
exports.getVersionUpgradeData = exports.cdkUpgradeData = void 0;
const version_changes_1 = require("../update-tool/version-changes");
const data_1 = require("./data");
/** Upgrade data for the Angular CDK. */
exports.cdkUpgradeData = {
    attributeSelectors: data_1.attributeSelectors,
    classNames: data_1.classNames,
    constructorChecks: data_1.constructorChecks,
    cssSelectors: data_1.cssSelectors,
    elementSelectors: data_1.elementSelectors,
    inputNames: data_1.inputNames,
    methodCallChecks: data_1.methodCallChecks,
    outputNames: data_1.outputNames,
    propertyNames: data_1.propertyNames,
    symbolRemoval: data_1.symbolRemoval,
};
/**
 * Gets the reduced upgrade data for the specified data key. The function reads out the
 * target version and upgrade data object from the migration and resolves the specified
 * data portion that is specifically tied to the target version.
 */
function getVersionUpgradeData(migration, dataName) {
    // Note that below we need to cast to `unknown` first TS doesn't infer the type of T correctly.
    return version_changes_1.getChangesForTarget(migration.targetVersion, migration.upgradeData[dataName]);
}
exports.getVersionUpgradeData = getVersionUpgradeData;
//# sourceMappingURL=data:application/json;base64,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