"use strict";
/**
 * @license
 * Copyright Google LLC All Rights Reserved.
 *
 * Use of this source code is governed by an MIT-style license that can be
 * found in the LICENSE file at https://angular.io/license
 */
Object.defineProperty(exports, "__esModule", { value: true });
exports.getChildElementIndentation = void 0;
const schematics_1 = require("@angular-devkit/schematics");
/** Determines the indentation of child elements for the given Parse5 element. */
function getChildElementIndentation(element) {
    const childElement = element.childNodes
        .find(node => node.tagName);
    if ((childElement && !childElement.sourceCodeLocation) || !element.sourceCodeLocation) {
        throw new schematics_1.SchematicsException('Cannot determine child element indentation because the ' +
            'specified Parse5 element does not have any source code location metadata.');
    }
    const startColumns = childElement ?
        // In case there are child elements inside of the element, we assume that their
        // indentation is also applicable for other child elements.
        childElement.sourceCodeLocation.startCol :
        // In case there is no child element, we just assume that child elements should be indented
        // by two spaces.
        element.sourceCodeLocation.startCol + 2;
    // Since Parse5 does not set the `startCol` properties as zero-based, we need to subtract
    // one column in order to have a proper zero-based offset for the indentation.
    return startColumns - 1;
}
exports.getChildElementIndentation = getChildElementIndentation;
//# sourceMappingURL=data:application/json;base64,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